#include "Systick.h"

volatile uint32_t g_tick_count = 0;

void hal_systick_init(void)
{
    SysTick_Config(SystemCoreClock / TICKS_PER_SECONDS);
}

uint32_t HAL_GetTick(void)
{
  return g_tick_count;
}


void HAL_Delay(uint32_t Delay)
{
  #define HAL_MAX_DELAY      0xFFFFFFFFU

  uint32_t tickstart = HAL_GetTick();
  uint32_t wait = Delay;

  /* Add a freq to guarantee minimum wait */
  if (wait < HAL_MAX_DELAY)
  {
    wait++;
  }

  while ((HAL_GetTick() - tickstart) < wait)
  {
  }
}







