//*************************************************************************************************
//  Copyright (c) 	Ԫ΢޹˾
//	ļ	:  S_TouchKeyCFG.c
//			: 
//	ģ鹦	:  
// 	汾		:
// 	ļ¼	:
//	ע	:  ûҪõļS_TouchKeyCFG.h
//  汾	: 
//************************************************************************************************
#include "lib\S_TouchKeyCFG.h"

/***************ͺѡ***************/
#define  SC95F8X3X    	1 
#define  SC92F8X8X    	2
#define  SC92F8X9X    	3
#define  SC92L8X3X    	4
#define  SC95F8X6X    	5

#define  MCU_TYPE   SC95F8X6X


//*************************************************************************************
//		 Ĵ
//*************************************************************************************
sfr   OPINX = 0XFE;  //Customer Optionָ 
sfr   OPREG = 0XFF;  //Customer OptionĴ
sfr   IE  = 0XA8;  //жϿƼĴ
sbit  EA    = IE^7;  //жʹܵܿ
/*PSW*/
sfr 	TK_PSW	    = 	0xD0;							//״̬
sbit 	TK_CY		= 	TK_PSW^7;						//λ  

#if (MCU_TYPE == SC95F8X3X) || (MCU_TYPE == SC92L8X3X)  || (MCU_TYPE == SC95F8X6X) 
sfr	    BTMCON      =   0XFB;   						//ƵʱƼĴ

#elif ( MCU_TYPE == SC92F8X8X) || (MCU_TYPE == SC92F8X9X) 
sfr	    BTMCON      =   0XCE; 
#endif
sfr 	TK_IE1	    = 	0xA9;							//жϿƼĴ
/*system*/
sfr 	PCON	    =   0x87;							//ԴƼĴ

sfr		TKCR	=	0xE8;								//TouchKeyƼĴ

sfr 	TKTMH	=	0xE7;								//ʱĴL
sfr 	TKTML	=	0xE6;								//ʱĴL
sfr16   TKTM    =   0xE6;

sfr		TKCNTH	=	0xE5;								//TouchKeyֵ7λ
sfr		TKCNTL	=	0xE4;								//TouchKeyֵ8λ
sfr16   TKCNT   =   0xE4;

sfr 	TKCFG2	=	0xE3;								//οѹüĴ
sfr		TKCFG1	=	0xE2;								//TouchKeyüĴ2
sfr		TKCFG0	=	0xE1;								//TouchKeyüĴ1

/*TKCR*/
sbit	ENTKS	=	TKCR^7;								//TouchKeyصԴ
sbit	TRIG	=	TKCR^6;								//TouchKeyأд1Чһkeyɨ
sbit	TRIF	=	TKCR^5;								//TouchKeyжϱ־
//===========================================================================
//ȫֱ
unsigned	char	xdata		SOCAPI_TouchKeyStatus;	//APIӿ״̬bit7-һɨɱ־  1: 	0δ
														//			   bit6-ͨ־ 1:	 0:δ
//===============================================================================
//ȫֱ򲻿޸
unsigned 	int 	xdata		RawData [SOCAPI_SET_TOUCHKEY_TOTAL];			
unsigned 	int		xdata		BaseLine[SOCAPI_SET_TOUCHKEY_TOTAL];
unsigned    int	 	xdata		FilterData[SOCAPI_SET_TOUCHKEY_TOTAL];												
unsigned	char    xdata		RestAreaCnt[SOCAPI_SET_TOUCHKEY_TOTAL]; 			
unsigned	char    xdata		TouchCnt[SOCAPI_SET_TOUCHKEY_TOTAL];				
unsigned	char    xdata		NoTouchCnt[SOCAPI_SET_TOUCHKEY_TOTAL];  			
unsigned	char	xdata		CurrentChannel[SOCAPI_SET_TOUCHKEY_TOTAL];						     
unsigned    char    xdata 	    LowFingerDataCnt[SOCAPI_SET_TOUCHKEY_TOTAL];
unsigned	char    xdata		FloatAreaCnt[SOCAPI_SET_TOUCHKEY_TOTAL]; 
unsigned 	char 	xdata 	    BaseLineAdjusttmp[SOCAPI_SET_TOUCHKEY_TOTAL]; 	
int                 xdata 	    DifferAccum[SOCAPI_SET_TOUCHKEY_TOTAL]; 
char	            xdata		SetNoiseThreshold;
unsigned 	char	xdata		ConfirmTouchCnt;
unsigned 	char	xdata		MultipleDealTpye = 0; 

//Զ
unsigned 	int 	xdata  	    UpdateBaseLNum; 				// 
unsigned 	int 	xdata  	    MultipleLNum;					// ఴż
bit		WakeUp_Flag = 0;
bit data TK_WakeUp_Flag = 0; 
//ⲿӿ
extern 	unsigned	char	data		CurrentChannelMax;		//ǰѡеkeysensorĸ
extern  bit  bMultiple;	//ఴ־
extern	unsigned 	int     xdata       ScanTime;
	
extern 	bit  GetIsNeedUpdateBaseline(void);
extern  void SetNeedUpdateBaseline(void);
extern  unsigned long int SensorKeyFlag(void);
extern  void MultipleDeal(unsigned char CycleCnt);
extern  void FilterDataDeal(unsigned char i);
extern  void TouchKey_Service(void);
void  TKSleepMode(void);

/*******************************⺯ãһ㲻Ҫ***************************************/
#define		SOCAPI_CFG_CYCLE_CNT					    32 		//ȡֵΧ10-255سʼ˳ԼֵʼĬ32ȡֵԽ󴥿سʼʱԽԽȶ  
#define		SOCAPI_CFG_OVERLOW_MAX_COUNT			    10		//ͻ߸ٶãͻߺ󣬶ָһλߣ²noise/2ֵԽС߸ٶԽ
#define		SOCAPI_CFG_RESET_BASELINE_CNT			    10  	//ͻ߸¶ٴκڵͻ״ֱ̬ǿƸ»ߣֵԽС߸ٶԽ
																//SOCAPI_CFG_OVERLOW_MAX_COUNTSOCAPI_CFG_RESET_BASELINE_CNTȡֵ˻ܴ255
/***************************************************************************************/
/***************ɿ***************/
#define		SOCAPI_SET_CS_FUNCTION						1		//0:ʾCS,1: ʾCS,Ĭ0
#define		SOCAPI_INHIBITION_ZONE					    8		//%÷Χ5-10Ĭ7,7*10%=70% ˮʱӴò,ԽС
#define		SOCAPI_MAX_KEY_MUTIPLE						300		//ٴθŸ»ߣĬ300*5=1500
#define		SOCAPI_MAX_KEY_NUM_INVALID					3		//ǿƸ»߰ƸĬ3
/****************************************/

#define	  	AppType			     			0
#define	  	IsDoubleKey			 			1
#define	  	AirSeparationDistance	 	    2
#define   	CONFIRMTOUCHCNT        	        3
#define   	INIT_AUTO_UPDATE_TIME	 	    4
#define   	SET_KEY_CONTI_TIME     	        5  
#define   	SET_SYNC_UPDATE 		 		6
#define   	SET_UPDATE_SPEED 		 		7	
#define   	AUTO_UPDATE_TIME	     	    8
#define	  	FilteredKValue		 			9
#define	  	SET_ANTIJAM		     			10
#define	  	BAUD		             		11
#define	  	DwellTime		         		12
#define   	SaveTime					    13
#define   	NOISE                  	        16

#define   	SET_TOUCH_FREQ		 			0
#define	  	SET_RESOLUTION		 			1
#define   	SET_GAIN_CFG			 		2
#define   	SCANTIME				 		3
#define   	SET_ICHA				 		4
#define   	FINGER_THRESHOLD_H	 		    6
#define   	FINGER_THRESHOLD_L	 		    7

//**********************************************************************************	
// 								궨ӿڵò								  //
//**********************************************************************************
unsigned 	char	code        CFG_OVERLOW_MAX_COUNT = SOCAPI_CFG_OVERLOW_MAX_COUNT;
unsigned 	char	code        CFG_RESET_BASELINE_CNT = SOCAPI_CFG_RESET_BASELINE_CNT;	
unsigned 	char	code        CFG_CYCLE_CNT = SOCAPI_CFG_CYCLE_CNT;

//**********************************************************************************	
// 								͹							  //
//**********************************************************************************
#define     TK_LowPowerMode                

#ifdef  TK_LowPowerMode

#define ScanTimeCon		3

#define		BTM_TIMEBASE_15600US     0X00		//ƵʱжʱΪ15.6MS
#define		BTM_TIMEBASE_31300US     0X01		//ƵʱжʱΪ31.3MS
#define		BTM_TIMEBASE_62500US     0X02		//ƵʱжʱΪ62.5MS
#define		BTM_TIMEBASE_125MS  	 0X03		//ƵʱжʱΪ125MS
#define		BTM_TIMEBASE_250MS       0X04		//ƵʱжʱΪ250MS
#define		BTM_TIMEBASE_500MS       0X05		//ƵʱжʱΪ500MS
#define		BTM_TIMEBASE_1S          0X06		//ƵʱжʱΪ1S
#define		BTM_TIMEBASE_2S          0X07		//ƵʱжʱΪ2S
#define		BTM_TIMEBASE_4S          0X08		//ƵʱжʱΪ4S

#include <intrins.h>

#define      WakeUpKeyNum                      12                    //͹ģʽɨ谴     
#define      WakeUpKeyChannel                  0x00003CFF           //͹ɨ谴ĶӦͨ
#define      TK_SeepTimervSetting              BTM_TIMEBASE_250MS   //͹°֮ɨ
#define      TK_WakeUpConfirmTouchCnt          15 					//͹ȷϰ

#if	TK_SeepTimervSetting == BTM_TIMEBASE_4S							//͹»߸¼
	#define  BaselineUpdateCnt  1										
#elif	TK_SeepTimervSetting == BTM_TIMEBASE_2S							
	#define  BaselineUpdateCnt  3
#elif	TK_SeepTimervSetting == BTM_TIMEBASE_1S							
	#define  BaselineUpdateCnt  6
#elif	TK_SeepTimervSetting == BTM_TIMEBASE_500MS					
	#define  BaselineUpdateCnt  12
#elif TK_SeepTimervSetting == BTM_TIMEBASE_250MS					 
	#define  BaselineUpdateCnt  24
#elif TK_SeepTimervSetting == BTM_TIMEBASE_125MS
	#define  BaselineUpdateCnt  48
#elif TK_SeepTimervSetting == BTM_TIMEBASE_62500US
	#define  BaselineUpdateCnt  96
#elif TK_SeepTimervSetting == BTM_TIMEBASE_31300US
	#define  BaselineUpdateCnt  192
#elif TK_SeepTimervSetting == BTM_TIMEBASE_15600US
	#define  BaselineUpdateCnt  384									
#endif

bit  LowPowerScan_Flag = 0;                                         //͹ɨ־
bit  SingleKeyFastScan_Flag = 0;                                    //ɨ־
bit  BTM_WakeUpFlag =0;												//BTMѱ־λ
bit  Touch_WakeUpFlag=0;											//ѱ־λ

unsigned    char    idata       WakeUpKey_List[WakeUpKeyNum];
unsigned 	char 	idata  	    WakeUpThenScanCount = 0; 
unsigned 	int		WakeUpNum;										//Ѵ--ڵ͹¸»
unsigned 	char 	WakeUpKeyValue;									//==WakeUpKey_List[WakeUpKey_Index]
unsigned 	int  	ScanTimeTemp0;									//==ScanTime>>4


extern void Customer_IntoLowPowerMode_Init(void);
extern void Customer_QuitLowPowerMode_Init(void);
extern void Customer_BTM_Dispose(void);

//**********************************************************************************

/**************************************************
*ƣvoid BtmInit(void) 
*ܣ
*ڲvoid 
*ڲvoid
**************************************************/
void BTM_Init(void)
{
    BTMCON = BTMCON & 0XF0 | TK_SeepTimervSetting;
    BTMCON |= 0X80;
	TK_IE1 |= 0X04;
}
/**************************************************
*ƣvoid BtmInit(void) interrupt	0
*ܣBtmжϷ
*ڲvoid 
*ڲvoid
**************************************************/
void BtmInit(void) interrupt	9
{
   BTM_WakeUpFlag = 1;
}
#endif

//**********************************************************************************	
// 								ӿڵò								  //
//**********************************************************************************
/**************************************************
*ƣunsigned int SetOneKeyPushResetTime(void) 
*ܣʱ
*ڲvoid
*ڲunsigned int SOCAPI_SET_KEY_CONTI_TIME
*ע	 ֵã Ǹж೤ʱTouchKeyRestartһ
10ms һΣ SOCAPI_SET_KEY_CONTI_TIME*10msʱ˰Ч
**************************************************/
unsigned int SetOneKeyPushResetTime(void)   
{	  
	return  TKCFG[SET_KEY_CONTI_TIME];
}
/**************************************************
*ƣint  GetBaselineUpdateThreshold(void)
*ܣٶ 
*ڲvoid
*ڲ  int 
*ע	 
**************************************************/
int  GetBaselineUpdateThreshold(void)
{
	return TKCFG[SET_UPDATE_SPEED]; 
}

/**************************************************
*ƣunsigned char GetInitAutoUpdateTime(void)
*ܣʼԶУ׼
*ڲvoid
*ڲunsigned  char 
*ע	 
**************************************************/
unsigned char GetInitAutoUpdateTime(void)
{
	return  TKCFG[INIT_AUTO_UPDATE_TIME];
}
/**************************************************
*ƣunsigned char GetCsFunction(void)
*ܣCS 
*ڲvoid
*ڲchar SOCAPI_SET_CS_FUNCTION
*ע	 
**************************************************/
unsigned char GetCsFunction(void)
{
	return SOCAPI_SET_CS_FUNCTION; 
}
/**************************************************
*ƣint  GetCurrFingerValue(unsigned char i)
*ܣȡǰfinger ֵ
*ڲunsigned char
*ڲint 
*ע	 
**************************************************/
unsigned int   GetCurrFingerValue(unsigned char i)
{ 
	return	TKChannelCfg[i][FINGER_THRESHOLD_H]*256+TKChannelCfg[i][FINGER_THRESHOLD_L] ;
}

/**************************************************
*ƣunsigned char  GetScanTimeValue(unsigned char i)
*ܣȡǰͨɨʱ
*ڲunsigned char
*ڲunsigned char 
*ע	 
**************************************************/
unsigned char  GetScanTimeValue(unsigned char i)
{ 
	return TKChannelCfg[i][SCANTIME];
}
/**************************************************
*ƣunsigned char IsDoubleKeyOrSlideKey(void)
*ܣǷǵɻ˫
*ڲvoid
*ڲunsigned char 
*ע	 
**************************************************/
unsigned char IsDoubleKeyOrSlideKey(void)
{
    return TKCFG[IsDoubleKey];
}
/**************************************************
*ƣunsigned char  GetBaseLineAdjustValue(unsigned char i)
*ܣȡǰͨĻߵ
j
*ڲunsigned char
*ڲunsigned char 
*ע	 
**************************************************/
unsigned char  GetBaseLineAdjustValue(unsigned char i)
{	
     return BaseLineAdjusttmp[i]; 
}
/**************************************************
*ƣunsigned char GetUpConfirmCnt(void)
*ܣⰴ
*ڲvoid
*ڲذȷϴ 
*ע	 
**************************************************/
unsigned char GetUpConfirmCnt(void)
{
	return ConfirmTouchCnt>>1;
}
/**************************************************
*ƣunsigned char GetTKYzCnt(void)
*ܣȡȷϴ
*ڲvoid
*ڲƴ 
*ע	 
**************************************************/

unsigned char GetTKYzCnt(void)
{
	return (ConfirmTouchCnt/3);
}

/**************************************************
*ƣint GetTKYzThreshold(unsigned char i)
*ܣȡ
*ڲunsigned char i
*ڲ
*ע	 
**************************************************/
unsigned int GetTKYzThreshold(unsigned char i)
{	
	unsigned int SetFingerThresholdtmp; 
	
	SetFingerThresholdtmp = GetCurrFingerValue(i); 
    SetFingerThresholdtmp = SetFingerThresholdtmp*SOCAPI_INHIBITION_ZONE/10;

	return SetFingerThresholdtmp;
}
/**************************************************
*ƣvoid CurrentSensorChoose(void)
*ܣǰͨѡ
*ڲvoid
*ڲvoid
*ע	 
**************************************************/
void CurrentSensorChoose(void)
{
	unsigned char  	i = 0;
	unsigned char  	Ctk_Channel_mark = 0;
	unsigned char  	WakeUpKey_Channel_mark = 0;
	unsigned long int	CurrentSensorKey = 0 ; 
	
	CurrentSensorKey = SOCAPI_SET_TOUCHKEY_CHANNEL; 
		
	for(i=0;i<31;i++)
	{
		CurrentSensorKey=CurrentSensorKey>>1;
		if(TK_CY)
		{
			CurrentChannel[Ctk_Channel_mark] = i;						//ѡǰͨ
            #ifdef  TK_LowPowerMode
			if(WakeUpKey_Channel_mark<WakeUpKeyNum)
            {
                if((WakeUpKeyChannel&((unsigned long int)1<<i)))
                {
                    WakeUpKey_List[WakeUpKey_Channel_mark++] = Ctk_Channel_mark;
                }
            }
            #endif
			Ctk_Channel_mark++;
			if(Ctk_Channel_mark >= SOCAPI_SET_TOUCHKEY_TOTAL)
				break;
		}		
	}
	CurrentChannelMax = Ctk_Channel_mark;							//ǰѡİ 
}

/**************************************************
*ƣunsigned char  GetCfgMsg(unsigned char i)
*ܣȡTouch KEY Ϣ
*ڲvoid
*ڲint 
*ע	 
**************************************************/
unsigned char  GetCfgMsg(unsigned char i)
{
	switch(i)
	{ 
		 case 0:  return TKChannelCfg[0][SET_TOUCH_FREQ];
		 case 1:  return TKChannelCfg[0][SET_RESOLUTION];
		 case 2:  return TKChannelCfg[0][SET_GAIN_CFG];
		 case 3:  return GetBaseLineAdjustValue(0);	//TKChannelCfg[0][SET_GAIN_CFG];
		 case 4:  return TKCFG[SET_ANTIJAM];
		 default:return 0; 	 	
	}
}

/**************************************************
*ƣvoid CurrentSensorChoose(void)
*ܣʼTKĴ
*ڲvoid
*ڲvoid
*ע	 
**************************************************/
void TouchKeyCFGInit(void)
{
	unsigned char  	i;
	ConfirmTouchCnt = TKCFG[CONFIRMTOUCHCNT];
	SetNoiseThreshold = TKCFG[NOISE];
	CurrentSensorChoose(); 
	 for(i=0;i<CurrentChannelMax;i++)
	{
	  BaseLineAdjusttmp[i] =TKChannelCfg[i][SET_ICHA];;	
	} 
	UpdateBaseLNum = 0;
    #ifdef  TK_LowPowerMode
    BTM_Init();
    #endif 
}

/**************************************************
*ƣunsigned int TouchKeyScan(void)
*ܣⰴӿ
*ڲvoid
*ڲͨ صһint , ͨ
*ע	 1,  ôؿ⺯SensorKeyFlag()
		   2,  ó16ͨĸͨа£bit λΪ1Ϊ0
		   3,  ǷҪbaseline:  MAX_KEY_RESET_BASELINE ʱbaseline
		   4,  ˫ߵʱ ʱSetOneKeyPushResetTime()ʱbaseline 
**************************************************/
unsigned char OffHandCount = 0;
unsigned int  NumCount = 0;
unsigned int  CumulateCount = 0;
unsigned long int TouchKeyScan(void)
{
	unsigned char t;
    unsigned char MultipleCnt = 0;//
	unsigned long int Keyvalue = 0; 
	unsigned long int KeyData = 0; 	
	int WakeupDiffData = 0; 
	int WakeupSetFingerThresholdtmp;
	
	
	if(WakeUp_Flag == 0)
	{
		if(GetIsNeedUpdateBaseline() == 0)				//ǷҪbaseline 
		{
			Keyvalue = SensorKeyFlag();					//Sensorж, bMultiple = 1 ʾми	 //ó׼16ͨbit λ                     							   
			for(t=0;t<CurrentChannelMax;t++)
			{
				Keyvalue = Keyvalue>>1;
				if(TK_CY)
				{
					KeyData |= ((unsigned long int)0x01 << (CurrentChannel[t]));              
					MultipleCnt++;							
				}
			}                
			if(MultipleCnt >= 2) 	 						//ఴ
			{			
				bMultiple = 1;			
				if(MultipleCnt >= SOCAPI_MAX_KEY_NUM_INVALID)
				{
					SetNeedUpdateBaseline(); 				// baseline ,ǿȥ
				}
				else
				{					
					if(IsDoubleKeyOrSlideKey())
					{
						bMultiple = 0;
					} 				 
				}			
			}			
	
			if(bMultiple == 0)								//밴ж
			{		
				if(KeyData != 0x0)					    	//ﵽ೤ʱupdate baseline ,ּ
				{			
					UpdateBaseLNum++; 
				}
				else	
				{
					UpdateBaseLNum = 0; 	
				} 
			}	
			else
			{   
			    //ǻ߸		
				MultipleLNum++; 
				KeyData = 0x00;
			}
	
			if(UpdateBaseLNum >= SetOneKeyPushResetTime())	//ʱ»
			{
	 			SetNeedUpdateBaseline(); 
				UpdateBaseLNum = 0;
			}
					
			if(MultipleLNum >SOCAPI_MAX_KEY_MUTIPLE)		//ż»
	 		{
				SetNeedUpdateBaseline(); 
				MultipleDealTpye = 1; 
				MultipleLNum = 0;
			}  
		}			
		else
		{
			MultipleDeal(TKCFG[AUTO_UPDATE_TIME]);			//߸λ
		}
	}
	else
	{
        #ifdef  TK_LowPowerMode
		
		if(Touch_WakeUpFlag==1)
		{
			CumulateCount ++;
			
			KeyData |= ((unsigned long int)0x01 << (CurrentChannel[WakeUpKeyValue]));

			WakeupDiffData = RawData[WakeUpKeyValue]-BaseLine[WakeUpKeyValue];
			WakeupSetFingerThresholdtmp = GetCurrFingerValue(WakeUpKeyValue);

			if(WakeupDiffData <= (WakeupSetFingerThresholdtmp-((WakeupSetFingerThresholdtmp)>>2)))
			{	
				NumCount=0;
				if(++OffHandCount>5)
				{
					OffHandCount = 0;
					WakeUp_Flag = 0;
					Touch_WakeUpFlag=0;
					KeyData = 0;
				}
				for(t=0;t<CurrentChannelMax;t++)
				{
					FilterDataDeal(t);
					if(!WakeUp_Flag)
					{
						if(WakeUpKeyValue == t)
						continue;
						BaseLine[t] = RawData[t];	
					}
				}
					
			}
			else
			{
				OffHandCount=0;
				for(t=0;t<CurrentChannelMax;t++)
				{
					FilterDataDeal(t);	
				}
				if(++NumCount >= SetOneKeyPushResetTime())	//ʱ»
				{
		 			SetNeedUpdateBaseline(); 
					NumCount = 0;
					WakeUp_Flag = 0;
					Touch_WakeUpFlag=0;
					KeyData = 0;
				}		
			}
			
			if(CumulateCount >= SetOneKeyPushResetTime())
			{
				SetNeedUpdateBaseline(); 
				NumCount = 0;
				OffHandCount = 0;
				CumulateCount = 0;
				WakeUp_Flag = 0;
				Touch_WakeUpFlag=0;
				KeyData = 0;
			}
			
		}
		else
		{
			if(++WakeUpThenScanCount>5)
			{
				WakeUpThenScanCount = 0;
				WakeUp_Flag = 0;
			}
			for(t=0;t<CurrentChannelMax;t++)
			{
				FilterDataDeal(t);
				if(!WakeUp_Flag)
				{
					
					BaseLine[t] = RawData[t];	
				}	
			}
			
		}
		
		#endif
	}  
	return KeyData;
}

/**************************************************
*ƣvoid CTK_ISR(void) interrupt	11
*ܣжϷ
*ڲvoid
*ڲvoid
*ע	 
**************************************************/
void CTK_ISR(void) interrupt	11
{
   TK_WakeUp_Flag = 1;
   TouchKey_Service();
}

/**************************************************
*ƣbit GetLowPowerScanFlag(void)
*ܣdȡ͹ģʽ
*ڲvoid
*ڲvoid  
**************************************************/
bit GetLowPowerScanFlag(void)
{
    #ifdef  TK_LowPowerMode
    return LowPowerScan_Flag;
    #endif
}

/**************************************************
*ƣvoid TouchKey_LowPower_Init(unsigned char i)
*ܣd͹ĳʼ
*ڲvoid
*ڲvoid  
**************************************************/
unsigned 	char    xdata 	    BaseLineAdjusttmp_Low[SOCAPI_SET_TOUCHKEY_TOTAL];
unsigned 	char 	xdata 	    CurrentChannel_Low[SOCAPI_SET_TOUCHKEY_TOTAL];
unsigned 	int 	xdata       ScanTimeTemp_Low[SOCAPI_SET_TOUCHKEY_TOTAL];
int 	data       SetFingerThresholdtmp_Low[SOCAPI_SET_TOUCHKEY_TOTAL];
void TouchKey_LowPower_Init(void)
{
    unsigned char i;
    	
    for(i=0;i<WakeUpKeyNum;i++)
    {
        WakeUpKeyValue = WakeUpKey_List[i];
        ScanTimeTemp_Low[WakeUpKeyValue] = ScanTimeTemp0*TKChannelCfg[WakeUpKeyValue][SCANTIME]>> ScanTimeCon;
        BaseLineAdjusttmp_Low[WakeUpKeyValue] = BaseLineAdjusttmp[WakeUpKeyValue];//(TKCFG1 & 0X80) | BaseLineAdjusttmp[WakeUpKeyValue];
        CurrentChannel_Low[WakeUpKeyValue] =  0xc0|CurrentChannel[WakeUpKeyValue];

        SetFingerThresholdtmp_Low[WakeUpKeyValue] = TKChannelCfg[WakeUpKeyValue][FINGER_THRESHOLD_H]*256+TKChannelCfg[WakeUpKeyValue][FINGER_THRESHOLD_L];        

        TKCFG0 &= 0XF0;
        TKCFG0 |= TKChannelCfg[0][SET_TOUCH_FREQ];
    }
}

/**************************************************
*ƣvoid TouchKey_IntoLowPowerMode(void)
*ܣd͹ģʽ
*ڲvoid
*ڲvoid  
**************************************************/
bit LowPowerEnter_Flag = 0;
bit TouchKey_IntoLowPowerMode(void)  
{
    #ifdef  TK_LowPowerMode
	unsigned char t;
	if(GetIsNeedUpdateBaseline() == 0)
	{
		LowPowerScan_Flag = 1;
		LowPowerEnter_Flag = 1;
		ScanTimeTemp0 = ScanTime;
		

		TouchKey_LowPower_Init();
	   
		for(t=0;t<CurrentChannelMax;t++)
		{
		   TouchCnt[t] = 0;
		}
		return 1;
	}
	else
	{
		return 0;	
	}
    
    #endif
}

#ifdef  TK_LowPowerMode
/**************************************************
*ƣvoid TouchKey_QuitLowPowerMode(void)
*ܣd˳͹ģʽ
*ڲvoid
*ڲvoid  
**************************************************/
void TouchKey_QuitLowPowerMode(void)
{
	 LowPowerScan_Flag = 0;
     WakeUp_Flag = 1;
    
     TKCFG1 = (TKCFG1 & 0X80) | BaseLineAdjusttmp[0];
	 
     TKCR = 0x80|CurrentChannel[0];
	 TKTM = ScanTime*TKChannelCfg[0][SCANTIME]>>3; 
     TK_IE1 = TK_IE1&(~0x10);       //رTKж
	 TRIG = 1;
	 while(TRIF == 0);
	 _nop_();
     _nop_();
	 _nop_();  
	 TRIF = 0;
	 TK_IE1 = TK_IE1|0x10;    				//ʹTKж
     TRIG = 1; 
     Customer_QuitLowPowerMode_Init();
}




/**************************************************
*ƣvoid TouchKey_LowPower_Dispose(void)
*ܣd͹ɨݴ
*ڲvoid
*ڲvoid  
**************************************************/
void TouchKey_LowPower_Dispose(void)
{  
	int data differData; 

	unsigned char data WakeUpKey_Index;

	
	unsigned int data i,j;
	BTM_WakeUpFlag = 0;
	TK_WakeUp_Flag = 0;

	TRIG = 1;
    PCON |= 0x02;	//PCONbit1 STOPλд1MCUSTOPģʽ
	_nop_();		//Ҫ12_nop_()
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
	_nop_();
	_nop_();
    _nop_();
    _nop_();
	_nop_();

	while(TK_WakeUp_Flag == 0);
	TK_WakeUp_Flag = 0;
	
	for(i=0;i<1;i++) 
		for(j=0;j<100;j++);

    TRIG = 1;
    PCON |= 0x02;	//PCONbit1 STOPλд1MCUSTOPģʽ
	_nop_();		//Ҫ12_nop_()
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
	_nop_();
	
	while(TK_WakeUp_Flag == 0);
	TK_WakeUp_Flag = 0;
	
	for(i=0;i<1;i++) 
		for(j=0;j<100;j++);
	
	for(WakeUpKey_Index=0; WakeUpKey_Index<WakeUpKeyNum; WakeUpKey_Index++)	//ѭɨ谴
	{

		
        WakeUpKeyValue = WakeUpKey_List[WakeUpKey_Index];
		TKCFG1 =  BaseLineAdjusttmp_Low[WakeUpKeyValue]; 
		TKTM = ScanTimeTemp_Low[WakeUpKeyValue];//ScanTimeTemp;
		TKCR = CurrentChannel_Low[WakeUpKeyValue];

        PCON |= 0x02;	//PCONbit1 STOPλд1MCUSTOPģʽ
    	_nop_();		//Ҫ12_nop_()
        _nop_();
        _nop_();
        _nop_();
        _nop_();
        _nop_();
        _nop_();
        _nop_();
        _nop_();
        _nop_();
        _nop_();
    	_nop_();       

		while(TK_WakeUp_Flag == 0);
		TK_WakeUp_Flag = 0;

		for(i=0;i<1;i++) 
		for(j=0;j<20;j++);
		
		RawData[WakeUpKeyValue] = TKCNT<<ScanTimeCon;
		
		FilterDataDeal(WakeUpKeyValue);
		differData = RawData[WakeUpKeyValue]-BaseLine[WakeUpKeyValue] ;
		if(differData >= SetFingerThresholdtmp_Low[WakeUpKeyValue])
		{
			 SingleKeyFastScan_Flag = 1;
			 break;       
		} 
		else if(differData > (-(SetFingerThresholdtmp_Low[WakeUpKeyValue]>>1)))        
		{
			if(WakeUpNum==WakeUpKey_Index%BaselineUpdateCnt)
				BaseLine[WakeUpKeyValue] += differData>>4;            
		}
		else
		{
			BaseLine[WakeUpKeyValue] += differData>>2; 
		}
		   
            
	}


	if(++WakeUpNum>=BaselineUpdateCnt)
	{
		WakeUpNum = 0;
	}
}

/**************************************************
*ƣvoid SingleKeyFastScan(void)
*ܣdɨģʽ
*ڲvoid
*ڲvoid  
**************************************************/
void SingleKeyFastScan(void)
{ 
    unsigned char i;
    int differData; 
    int SetFingerThresholdtmp;
	
	SingleKeyFastScan_Flag = 0;
	TK_IE1 = TK_IE1|0x10; //TKж
	TKCFG1 = (TKCFG1 & 0X80) | BaseLineAdjusttmp[WakeUpKeyValue];
    TKCR = 0x80|CurrentChannel[WakeUpKeyValue]; 
	TKTM = ScanTimeTemp0*TKChannelCfg[WakeUpKeyValue][SCANTIME] >> ScanTimeCon;
	
	for(i=0;i<TK_WakeUpConfirmTouchCnt;i++)
    {        
	
		 TRIG = 1;
		 TKSleepMode();
		 RawData[WakeUpKeyValue] = TKCNT << ScanTimeCon;
		 FilterDataDeal(WakeUpKeyValue);
         differData = RawData[WakeUpKeyValue]-BaseLine[WakeUpKeyValue] ;
		 SetFingerThresholdtmp = GetCurrFingerValue(WakeUpKeyValue);

		 if(differData >= SetFingerThresholdtmp )
         {   
            TouchCnt[WakeUpKeyValue]++;  
         }             
         else
		 {
			break;
		 }
    }
	
    if(TouchCnt[WakeUpKeyValue]>=TK_WakeUpConfirmTouchCnt)
    {    
		 TouchKey_QuitLowPowerMode();       
		 Touch_WakeUpFlag= 1; 
		 CumulateCount = 0;
	}
    else
    {
        TouchCnt[WakeUpKeyValue] = 0;
    }
}


void  TKSleepMode(void)
{   
	
	PCON |= 0x02;	//PCONbit1 STOPλд1MCUSTOPģʽ
	_nop_();		//Ҫ12_nop_()
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
	_nop_();
	_nop_();
    _nop_();
    _nop_();
	_nop_();
}
#endif
/**************************************************
*ƣvoid LowPower_Touchkey_Scan(void)
*ܣd͹ģʽTKɨ
*ڲvoid
*ڲvoid  
**************************************************/
 

void LowPower_Touchkey_Scan(void)
{      					
    #ifdef  TK_LowPowerMode 
    unsigned char TEMP = 0;
	
	if(LowPowerEnter_Flag == 1) //͹ı־жϣ̶дûɾ
	{
		LowPowerEnter_Flag = 0; //͹ı־㣬̶дûɾ
		
		Customer_IntoLowPowerMode_Init();
	}
	
	EA  = 0;
    OPINX = 0XC1;
    TEMP = OPREG;
    OPREG &= 0XCF;
    OPREG |= 0X30;
	
    TKCR &= 0x7f;//~0x80;
    EA  = 1;
    
	PCON |= 0x02;	//PCONbit1 STOPλд1MCUSTOPģʽ
	_nop_();		//Ҫ12_nop_()
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
    _nop_();
	_nop_();
    
    OPINX =  0XC1;
    OPREG = TEMP;
    
	TKCR |= 0x80;	//TKԴ

	//а
	if(BTM_WakeUpFlag)
	{
		
		TouchKey_LowPower_Dispose();  	   //ⰴ	
		
		if( SingleKeyFastScan_Flag == 1)
	    {								   
			SingleKeyFastScan();		   //аϢ뵥ٶɨȷǷʵźš
	    }
	
		// ûBTMѺĴ
		Customer_BTM_Dispose();
    }
	//·֧жϲ˳͹ĺTouchKey_QuitLowPowerMode()
	//磺if(ⲿжϻѱ־==1)
	//		{
	//			TouchKey_QuitLowPowerMode();
	//			//ҵ㻽Ѻʵ߼
	//		}
	//
	//
	//
	{
		;				//BTMѣûҪ
	}
	#endif    
}