/*--------------------------------------------------------------------------
SC95F876x_C.H

C Header file for SC95F876x microcontroller.
Copyright (c) 2022 Shenzhen SinOne Microelectronics Co., Ltd.
All rights reserved.
Ԫ΢ӹɷ޹˾
汾:  V1.0    
:  2022.01.20
--------------------------------------------------------------------------*/
#ifndef _SC95F876x_H_
#define _SC95F876x_H_

///* ------------------- ֽڼĴ-------------------- */
/*CPU*/
sfr   SP    = 0X81;  //ջָ
sfr   DPL   = 0X82;  //DPTRָλ
sfr   DPH   = 0X83;  //DPTRָλ
sfr   DPL1  = 0X84;  //DPTR1ָλ
sfr   DPH1  = 0X85;  //DPTR1ָλ
sfr   DPS   = 0X86;  //DPTRѡĴ
sfr   PSW   = 0XD0;  //״ּ̬Ĵ	
sfr   ACC   = 0XE0;  //ۼ	
sfr   EXA0  = 0XE9;  //չۼ0
sfr   EXA1  = 0XEA;  //չۼ1
sfr   EXA2  = 0XEB;  //չۼ2
sfr   EXA3  = 0XEC;  //չۼ3
sfr   EXBL  = 0XED;  //չBĴ0
sfr   EXBH  = 0XEE;  //չBĴ1
sfr   B     = 0XF0;  //BĴ	

/*SRAM*/
sfr   EXADH = 0XF7;  //ⲿSRAMַλ

/*Bank*/
sfr   ROMBNK = 0XDF;  //BankлĴ

/*system*/
sfr   PCON = 0X87;  //ԴƼĴ

/*Interrupt*/
sfr   IE  = 0XA8;  //жϿƼĴ
sfr   IE1 = 0XA9;  //жϿƼĴ1
sfr   IE2 = 0XAA;  //жʹܼĴ2
sfr   IP  = 0XB8;  //жȨƼĴ
sfr   IP1 = 0XB9;  //жȼƼĴ1
sfr   IP2 = 0XBA;  //жȼƼĴ2

/*PORT*/
sfr   P0      = 0X80;  //P0ݼĴ
sfr   P1      = 0X90;  //P1ݼĴ
sfr	  P1CON	  = 0X91;  //P1/ƼĴ
sfr   P1PH	  = 0X92;  //P1ƼĴ	
sfr   DDRCON  = 0X93;  //ʾƼĴ
sfr   P1VO    = 0X94;  //P1ʾĴ
sfr   IOHCON0 = 0X96;  //IOHüĴ0
sfr   IOHCON1 = 0X97;  //IOHüĴ1
sfr	  P0CON	  = 0X9A;  //P0/ƼĴ	
sfr	  P0PH	  = 0X9B;  //P0ƼĴ
sfr   P0VO    = 0X9C;  //P0ʾĴ
sfr   P2      = 0XA0;  //P2ݼĴ
sfr	  P2CON	  = 0XA1;  //P2/ƼĴ	
sfr   P2PH	  = 0XA2;  //P2ƼĴ	
sfr   P2VO    = 0XA3;  //P2ʾĴ
sfr   P3      = 0XB0;  //P3ݼĴ
sfr   P3CON   = 0XB1;  //P3/ƼĴ
sfr   P3PH    = 0XB2;  //P3ƼĴ
sfr   P3VO    = 0XB3;  //P3ʾĴ
sfr   P4      = 0XC0;  //P4ݼĴ
sfr   P4CON   = 0XC1;  //P4/Ĵ
sfr   P4PH    = 0XC2;  //P4ƼĴ
sfr   P5      = 0XD8;  //P5ݼĴ
sfr   P5CON   = 0XD9;  //P5/ƼĴ
sfr   P5PH    = 0XDA;  //P5ƼĴ

/*ģȽ*/
sfr   CMPCFG  = 0XB6;  //ģȽüĴ
sfr   CMPCON  = 0XB7;  //ģȽƼĴ

/*TIMER*/	
sfr   TCON   = 0X88;  //ʱƼĴ
sfr   TMOD   = 0X89;  //ʱģʽĴ
sfr   TL0    = 0X8A;  //ʱ08λ
sfr   TL1    = 0X8B;  //ʱ18λ
sfr   TH0    = 0X8C;  //ʱ08λ
sfr   TH1    = 0X8D;  //ʱ18λ
sfr   TMCON  = 0X8E;  //ʱƵʿƼĴ
sfr   TXCON  = 0XC8;  //ʱ2/3/4ƼĴ
sfr   TXMOD  = 0XC9;  //ʱ2/3/4ģʽĴ
sfr   RCAPXL = 0XCA;  //ʱ2/3/4/׽8λ
sfr   RCAPXH = 0XCB;  //ʱ2/3/4/׽8λ
sfr   TLX    = 0XCC;  //ʱ2/3/48λ
sfr   THX    = 0XCD;  //ʱ2/3/48λ
sfr   TXINX  = 0XCE;  //ʱƼĴָ

/*ADC*/
sfr	  ADCCFG0 = 0XAB;  //ADCüĴ0
sfr	  ADCCFG1 = 0XAC;  //ADCüĴ1
sfr   ADCCON  = 0XAD;  //ADCƼĴ
sfr   ADCVL   = 0XAE;  //ADC Ĵ
sfr   ADCVH   = 0XAF;  //ADC Ĵ
sfr   ADCCFG2 = 0XB5;  //ADCüĴ2

/*PWM*/
sfr   PWMCFG  = 0XD1;  //PWMüĴ
sfr   PWMCON0 = 0XD2;  //PWM0ƼĴ0
sfr   PWMCON1 = 0XD3;  //PWM1ƼĴ1
sfr   PWMPDL  = 0XD4;  //PWM0ڼĴ8λ
sfr   PWMPDH  = 0XD5;  //PWM0ڼĴ8λ
sfr   PWMDFR  = 0XD6;  //PWM0üĴ
sfr   PWMFLT  = 0XD7;  //PWM0ϼüĴ

/*WatchDog*/
sfr   WDTCON = 0XCF;  //WDTƼĴ

/*BTM*/
sfr	  BTMCON = 0XFB;  //ƵʱƼĴ

/*INT*/
sfr   INT0F = 0XB4;  //INT0 ½жϿƼĴ
sfr   INT0R = 0XBB;  //INT0 ϽжϿƼĴ
sfr   INT1F = 0XBC;  //INT1 ½жϿƼĴ
sfr   INT1R = 0XBD;  //INT1 ϽжϿƼĴ
sfr   INT2F = 0XBE;  //INT2 ½жϿƼĴ
sfr   INT2R = 0XBF;  //INT2 ϽжϿƼĴ

/*IAP */
sfr   IAPKEY = 0XF1;  //IAPĴ
sfr   IAPADL = 0XF2;  //IAPдַλĴ
sfr   IAPADH = 0XF3;  //IAPдַλĴ
sfr   IAPADE = 0XF4;  //IAPչַĴ
sfr   IAPDAT = 0XF5;  //IAPݼĴ
sfr   IAPCTL = 0XF6;  //IAPƼĴ

/*uart0*/
sfr   OTCON = 0X8F;  //ƼĴ
sfr   SCON  = 0X98;  //ڿƼĴ
sfr   SBUF  = 0X99;  //ݻĴ

/*һ*/
sfr   US0CON0 = 0X95;  //USCI0ƼĴ0
sfr   US0CON1 = 0X9D;  //USCI0ƼĴ1
sfr   US0CON2 = 0X9E;  //USCI0ƼĴ2
sfr   US0CON3 = 0X9F;  //USCI0ƼĴ3
sfr   US1CON0 = 0XA4;  //USCI1ƼĴ0
sfr   US1CON1 = 0XA5;  //USCI1ƼĴ1
sfr   US1CON2 = 0XA6;  //USCI1ƼĴ2
sfr   US1CON3 = 0XA7;  //USCI1ƼĴ3
sfr   USXCON0 = 0XC4;  //USCI2/3/4/5ƼĴ0
sfr   USXCON1 = 0XC5;  //USCI2/3/4/5ƼĴ1
sfr   USXCON2 = 0XC6;  //USCI2/3/4/5ƼĴ2
sfr   USXCON3 = 0XC7;  //USCI2/3/4/5ƼĴ3
sfr   USXINX  = 0XDC;  //USCI2/3/4/5ƼĴָ  


/*OPTION*/
sfr   OPINX = 0XFE;  //Optionָ 
sfr   OPREG = 0XFF;  //OptionĴ

/*CRC*/
sfr   OPERCON = 0XEF;  //ƼĴ
sfr   CRCINX  = 0XFC;  //CRCָ
sfr   CRCREG  = 0XFD;  //CRCĴ


///* ------------------- λĴ-------------------- */
/*PSW*/
sbit  CY  = PSW^7;  //־λ          0:ӷλ޽λ߼λ޽λʱ	1:ӷλнλ߼λнλʱ
sbit  AC  = PSW^6;  //λ־λ  0:޽λλ	1:ӷʱbit3λнλbit3λнλʱ
sbit  F0  = PSW^5;  //û־λ
sbit  RS1 = PSW^4;  //Ĵѡλ
sbit  RS0 = PSW^3;  //Ĵѡλ
sbit  OV  = PSW^2;  //־λ
sbit  F1  = PSW^1;  //F1־
sbit  P   = PSW^0;  //ż־λ      0:ACC1ĸΪż0		1:ACC1ĸΪ

/*TXCON*/
sbit  TFX   = TXCON^7;  //ʱ2/3/4־λ
sbit  EXFX  = TXCON^6;  //TnEX(n=2/3/4)ⲿ¼(½)⵽ı־λ
sbit  RCLKX = TXCON^5;  //UART0ʱӿλ        0: ʱ1ղ	1: ʱ2ղ
sbit  TCLKX = TXCON^4;  //UART0ʱӿλ        0: ʱ1Ͳ	1: ʱ2Ͳ
sbit  EXENX = TXCON^3;  //TnEX(n=2/3/4)ϵⲿ¼(½)/񴥷/ֹ
sbit  TRX   = TXCON^2;  //ʱ2/3/4ʼ/ֹͣλ 0: ֹͣʱ2             1: ʼʱ2
sbit  TX    = TXCON^1;  //ʱ2/3/4ʱ/ʽѡλ
sbit  CP    = TXCON^0;  ///طʽѡλ

/*IP*/
sbit  IPADC  = IP^6;  //ADCжȨѡ         0:趨 ADCжȨ ͡      1:趨 ADCжȨ ߡ
sbit  IPT2   = IP^5;  //Timer2жȨѡ      0:趨 Timer 2жȨ ͡	 1:趨 Timer 2жȨ ߡ
sbit  IPUART = IP^4;  //UARTжȨѡ        0:趨 UARTжȨ ͡     1:趨 UARTжȨ ߡ
sbit  IPT1   = IP^3;  //Timer1жȨѡ      0:趨 Timer 1жȨ ͡	 1:趨 Timer 1жȨ ߡ
sbit  IPINT1 = IP^2;  //INT1жȨѡ  0:趨 INT1жȨ ͡     1:趨 INT1жȨ ߡ
sbit  IPT0   = IP^1;  //Timer0жȨѡ      0:趨 Timer 0жȨ ͡	 1:趨 Timer 0жȨ ߡ
sbit  IPINT0 = IP^0;  //INT0жȨѡ  0:趨 INT0жȨΪ ͡     1: INT0жȨΪ

/*IE*/
sbit  EA    = IE^7;  //жʹܵܿ       0:رеж      1:еж
sbit  EADC  = IE^6;  //ADCжʹܿ        0:رADCж         1:ADCж
sbit  ET2   = IE^5;  //Timer2жʹܿ     0:رTIMER2ж      1:TIMER2ж
sbit  EUART = IE^4;  //UARTжʹܿ       0:رSIFж         1:SIFж
sbit  ET1   = IE^3;  //Timer1жʹܿ     0:رTIMER1ж      1:TIMER1ж
sbit  EINT1 = IE^2;  //ⲿж1жʹܿ  0:رⲿж1ж   1:ⲿж1ж	
sbit  ET0   = IE^1;  //Timer0жʹܿ     0:رTIMER0ж      1:TIMER0ж
sbit  EINT0 = IE^0;  //ⲿж0жʹܿ  0:رⲿж0ж   1:ⲿж0ж

/*TCON*/
sbit  TF1 = TCON^7;  //T1ж־λ	T1жʱӲTF1Ϊ1жϣCPUӦʱӲ塰0
sbit  TR1 = TCON^6;  //ʱT1пλ	0:Timer1ֹ		1:Timer1ʼ
sbit  TF0 = TCON^5;  //T0ж־λ	T0жʱӲTF0Ϊ1жϣCPUӦʱӲ塰0
sbit  TR0 = TCON^4;  //ʱT0пλ	0:Timer0ֹ		1:Timer0ʼ

/*SCON*/
sbit  SM0 = SCON^7;  //ͨģʽλ:SM1ʹ 00: ģʽ08λ˫ͬͨģʽ 01: ģʽ110λȫ˫첽ͨ 11: ģʽ311λȫ˫첽ͨ
sbit  SM1 = SCON^6;  //ͨģʽλ
sbit  SM2 = SCON^5;  //ͨģʽλ2˿λֻģʽ3Ч   0ÿյһ֡λRIж   1յһ֡ʱֻеRB8=1ʱŻλRIж
sbit  REN = SCON^4;  //λ  0:   1
sbit  TB8 = SCON^3;  //ֻģʽ3ЧΪݵĵ9λ
sbit  RB8 = SCON^2;  //ֻģʽ3ЧΪݵĵ9λ
sbit  TI  = SCON^1;  //жϱ־λ
sbit  RI  = SCON^0;  //жϱ־λ


/******************* P0 ***************************
*SC95F8767װδĹܽţ
*SC95F8766װδĹܽţ
*SC95F8765װδĹܽţP00/P01/P02/P03
*SC95F8763װδĹܽţP00/P01/P02/P03
*SC95F8762װδĹܽţP00/P01/P02/P03
***************************************************/
sbit  P07 = P0^7;
sbit  P06 = P0^6;
sbit  P05 = P0^5;
sbit  P04 = P0^4;
sbit  P03 = P0^3;
sbit  P02 = P0^2;
sbit  P01 = P0^1;
sbit  P00 = P0^0;


/******************* P1 ***************************
*SC95F8767װδĹܽţ
*SC95F8766װδĹܽţ
*SC95F8765װδĹܽţP14/P15/P16/P17
*SC95F8763װδĹܽţP14/P15/P16/P17
*SC95F8762װδĹܽţP10/P12/P14/P15/P16/P17
***************************************************/
sbit  P17 = P1^7;
sbit  P16 = P1^6;
sbit  P15 = P1^5;
sbit  P14 = P1^4;
sbit  P13 = P1^3;
sbit  P12 = P1^2;
sbit  P11 = P1^1;
sbit  P10 = P1^0;

/******************* P2 ***************************
*SC95F8767װδĹܽţ
*SC95F8766װδĹܽţ
*SC95F8765װδĹܽţ
*SC95F8763װδĹܽţ
*SC95F8762װδĹܽţP24/P25/P26/P27
***************************************************/
sbit  P27 = P2^7;
sbit  P26 = P2^6;
sbit  P25 = P2^5;
sbit  P24 = P2^4;
sbit  P23 = P2^3;
sbit  P22 = P2^2;
sbit  P21 = P2^1;
sbit  P20 = P2^0;

/******************* P3 ***************************
*SC95F8767װδĹܽţ
*SC95F8766װδĹܽţ
*SC95F8765װδĹܽţP34/P35/P36/P37
*SC95F8763װδĹܽţP34/P35/P36/P37
*SC95F8762װδĹܽţP34/P35/P36/P37
***************************************************/
sbit  P37 = P3^7;
sbit  P36 = P3^6;
sbit  P35 = P3^5;
sbit  P34 = P3^4;
sbit  P33 = P3^3;
sbit  P32 = P3^2;
sbit  P31 = P3^1;
sbit  P30 = P3^0;

/******************* P4 ***************************
*SC95F8767װδĹܽţ
*SC95F8766װδĹܽţ
*SC95F8765װδĹܽţP46/P47
*SC95F8763װδĹܽţP46/P47
*SC95F8762װδĹܽţP44/P45/P46/P47
***************************************************/
sbit  P47 = P4^7;
sbit  P46 = P4^6;
sbit  P45 = P4^5;
sbit  P44 = P4^4;
sbit  P43 = P4^3;
sbit  P42 = P4^2;
sbit  P41 = P4^1;
sbit  P40 = P4^0;

/******************* P5 ***************************
*SC95F8767װδĹܽţ
*SC95F8766װδĹܽţP54/P55
*SC95F8765װδĹܽţP54/P55
*SC95F8763װδĹܽţP5
*SC95F8762װδĹܽţP5
***************************************************/
sbit  P55 = P5^5;
sbit  P54 = P5^4;
sbit  P53 = P5^3;
sbit  P52 = P5^2;
sbit  P51 = P5^1;
sbit  P50 = P5^0;

/****************************************************************************
*ע⣺װδĹܽţΪǿģʽ
*ICѡͣʹõICͺ,ڳʼIOں󣬵ӦδܽŵIO;
*ѡSC95F8767õú궨塣
*****************************************************************************/                                    
#define  SC95F8766_NIO_Init()   {P4CON|=0xC0,P5CON|=0x30;}                                                 //SC95F8766δIO
#define  SC95F8765_NIO_Init()   {P0CON|=0x0F,P1CON|=0xF0,P3CON|=0xF0,P4CON|=0xC0,P5CON|=0xF0;}             //SC95F8765δIO
#define  SC95F8763_NIO_Init()   {P0CON|=0x0F,P1CON|=0xF0,P3CON|=0xF0,P4CON|=0xC0,P5CON|=0xFF;}             //SC95F8763δIO
#define  SC95F8762_NIO_Init()   {P0CON|=0x0F,P1CON|=0xF0,P2CON|=0XF0,P3CON|=0xF0,P4CON|=0xF0,P5CON|=0xFF;} //SC95F8762δIO
#endif