#include "H/Function_Init.H" 

void Uart_Init(uint Freq,unsigned long int baud);
uint UART_RxData[5];//58λԶݣҪ޸ݸ޸ӦСͷ/forѭС
bit UartSendFlag = 0; //жϱ־λ
bit UartReceiveFlag = 0; //жϱ־λ
/*****************************************************
*ƣvoid Uart_Test(void)
*ܣUart
*ڲvoid
*ڲvoid
*****************************************************/
void Uart_Test(void)
{
  int num1,num2;
	Uart_Init(32,9600);
	while(1)
	{
		for(num1=0;num1<5;num1++)
		{
			while(!UartReceiveFlag);
			UartReceiveFlag = 0;
			UART_RxData[num1] = SBUF;
		}
		for(num2=0;num2<5;num2++)
		{
			SBUF = UART_RxData[num2];
			while(!UartSendFlag);
			UartSendFlag = 0;
		}

		Delay(1000);
	}
}
/*****************************************************
*ƣvoid Uart_Init(uint Freq,unsigned long int baud)
*ܣUartжϳʼ
*ڲFreq-Ƶbaud-
*ڲvoid
*****************************************************/
void Uart_Init(uint Freq,unsigned long int baud)    //ѡTimer1Ϊźŷ
{
	P2CON &= 0xFC;   //TX/RXΪ
	P2PH  |= 0x03;
	SCON  |= 0X50;   //ͨŷʽΪģʽһ
	TXINX = 0X02;   //ָʱ2
	TXCON |= 0X00;	//UART0ʱԴΪʱ1
	TMCON |= 0x02;  //T1ƵԴfsys
	TH1 = (Freq*1000000/baud)>>8;	  //ΪT1ʱ䣻
	TL1 = Freq*1000000/baud;
	TR1 = 0;	//SC95F876xϵUARTOʹöʱ1ΪʱԴTR1Ϊ0
	ET1 = 0;	
	EUART = 1;     //Uartж
	EA = 1;
}

/*
void Uart_Init(uint Freq,unsigned long int baud)    //ѡTimer2Ϊźŷ
{
	P2CON &= 0xFC;   //TX/RXΪ
	P2PH  |= 0x03;

	SCON  |= 0X50;   //ͨŷʽΪģʽһ
    TXINX = 0x02;
	TMCON |= 0X04;
	TXMOD = 0X00;
	TXCON = 0X30;
	RCAPXH = Freq*1000000/baud/256;
	RCAPXL = Freq*1000000/baud%256;
	TRX = 0;
	ET2 = 0;
	EUART = 1;     //Uartж
	EA = 1;
}
*/

/*****************************************************
*ƣvoid UartInt(void) interrupt 4
*ܣUartжϺ
*ڲvoid
*ڲvoid
*****************************************************/
void UartInt(void) interrupt 4
{
	if(TI) //UART0ж
	{
		TI = 0;	
		UartSendFlag = 1;		
	}
	if(RI) //UART0ж
	{
		RI = 0;	
		UartReceiveFlag = 1;
	}	
}
