#include "H/Function_Init.H"

//ѡһģ飺
#define  USCI2   2
#define  USCI3   3
#define  USCI4   4
#define  USCI5   5

//ѡһģʽ
#define  UartX   0
#define  TWIX    1
#define  SPIX    2

#define  USCIX_Select USCI3
#define  USCIX_Mode  TWIX
#define TWIX_Mode 0//0:ģʽ   1ӻģʽ
#define SPIX_Mode 0 //0:ģʽ   1ӻģʽ
void UARTX_Init(uint Freq, unsigned long int baud);
void TWIX_Init(void);
void SPIX_Init(void);

bit UartXSendFlag = 0;    //UartXжϱ־λ
bit UartXReceiveFlag = 0; //UartXжϱ־λ
bit SPIXFlag = 0;         //SPIXݴɱ־λ
bit TWIXFlag = 0;         //TWIXжϱ־λ

uint8_t TxXferCountX = 0;  //SPI/TWIĿ
uint8_t RxXferCountX = 0;  //SPI/TWIĿ

volatile uint8_t UartX_RxData[5];
uint8_t SPIX_Master_SendData[8] = {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
volatile uint8_t SPIX_Master_ReceiveData[8];
uint8_t SPIX_Slaver_SendData[8] = {0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F};
volatile uint8_t SPIX_Slaver_ReceiveData[8];

uint8_t TWIX_Master_SendData[8]={0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
volatile uint8_t TWIX_Master_ReceiveData[8];
uint8_t TWIX_Slaver_SendData[8]={0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F};
volatile uint8_t TWIX_Slaver_ReceiveData[8];

/*****************************************************
*ƣvoid USCIX_Test(void)
*ܣUSCIX
*ڲvoid
*ڲvoid
*****************************************************/
void USCIX_Test(void)
{
  USXINX = USCIX_Select;       //USCIXĴָӦUSCI

//жһģʽ
#if (USCIX_Mode == UartX)
  {
		int num1,num2;
    UARTX_Init(32, 9600);      //ʼڣƵͲ
    while(1)
    {
      for(num1=0;num1<5;num1++)
		{
			while(!UartXReceiveFlag);
			UartXReceiveFlag = 0;
			UartX_RxData[num1] = USXCON3 ;
		}
		for(num2=0;num2<5;num2++)
		{
			USXCON3  = UartX_RxData[num2];
		  	while(!UartXSendFlag);
		    UartXSendFlag = 0;
    }
  }
#elif (USCIX_Mode == TWIX)
  {
    TWIX_Init();
    while(1)
    
	#if (TWIX_Mode == 0)  //
			{
				USXCON1 |= 0x20;    //ʼ	
				while(TWIXFlag == 0);
				TWIXFlag = 0; 
				USXCON3 = 0x02|0X01;	    //͵ַд
				while(TWIXFlag == 0);
				TWIXFlag = 0; 

		/* ݽչ */
				do
				{
						if(RxXferCountX ==7)
					{
							USXCON0 &= 0XF7;    	
					}
				
					 while(TWIXFlag == 0);
					 TWIXFlag = 0; 
					 TWIX_Master_ReceiveData[RxXferCountX] = USXCON3;             //TWI
					 RxXferCountX++;	
				}
				while(RxXferCountX < 8);
			
			 RxXferCountX=0;
				/* ǷɣҪͽźţֹռ */
			 USXCON0 |= 0X08; //AAʹλ,UAC
			 USXCON1 |= 0x10;
			 Delay(500);
			}
	#endif
	#if (TWIX_Mode == 1)  //ӻ  
		 {  
			  TWIXFlag = 0; 
			 while((0x07 & USXCON0)!=0x00);//ж״̬Ƿص״̬
			 
			 while((0x07 & USXCON0)!=0x03);//ж״̬Ƿ״̬
			 while(TWIXFlag == 0);
			 TWIXFlag = 0;  
			 while(TxXferCountX < 8)
			 {

				USXCON3 = TWIX_Slaver_SendData[TxXferCountX];             //TWI
				while(TWIXFlag == 0);
				TWIXFlag = 0; 
				TxXferCountX++;

			 }
				USXCON3 = TWIX_Slaver_SendData[0];
			 
			 while((0x07 & USXCON0)!=0x00);//ж״̬Ƿص״̬

				TxXferCountX=0;
				Delay(100);
			 }
	#endif
	
   }  
#elif (USCIX_Mode == SPIX)
  {
    SPIX_Init();
    while(1)
    {
     #if (SPIX_Mode == 0)  //
	   TxXferCountX = 0;
    while(TxXferCountX <  8)//жǷ
    {
     
      USXCON2 = SPIX_Master_SendData[TxXferCountX];
      

      while(SPIXFlag == 0);	//ȴ
		 
      SPIXFlag = 0;		
      SPIX_Master_ReceiveData[TxXferCountX]=USXCON2;
      TxXferCountX ++;	//
    
		}
		Delay(1000);;
		

     #elif (SPIX_Mode == 1) //ӻ
 
 
	   while(RxXferCountX <8)
    {
			 USXCON2=SPIX_Slaver_SendData[RxXferCountX];
      /* ȴSPIжϱ־λ */
      
			while(SPIXFlag == 0);	//ȴ
		   
      SPIXFlag = 0;		
      SPIX_Slaver_ReceiveData[RxXferCountX] = USXCON2;			//ȡ16λ,ҵַ
      RxXferCountX++;	//1
      
      }
		 Delay(100);
	  RxXferCountX = 0;
		
     #endif
    
    }
  }
#endif

}

/*****************************************************
*ƣvoid UARTX_Init(uint Freq,unsigned long int baud)
*ܣUartXжϳʼ
*ڲFreq-Ƶbaud-
*ڲvoid
*****************************************************/
void UARTX_Init(uint Freq, unsigned long int baud)
{
  TMCON |= 0xC0;    //нӿUSCIXѡUartͨ
#if (USCIX_Select == USCI2)
  P4CON &= ~0x30;
  P4PH |= 0x30;
  IE2 |= 0x02;      //ж
#elif (USCIX_Select == USCI3)
  P2CON &= ~0xC0;
  P2PH |= 0xC0;
  IE2 |= 0x04;      //ж
#elif (USCIX_Select == USCI4)
  P4CON &= ~0xC0;
  P4PH |= 0xC0;
  IE2 |= 0x08;     //ж
#elif (USCIX_Select == USCI5)
  P0CON &= ~0x0C;
  P0PH |= 0x0C;
  IE2 |= 0x10;     //ж
#endif

  USXCON0 = 0x50;   //ͨŷʽΪģʽһ
  USXCON1 = Freq * 1000000 / baud; //ʵλ
  USXCON2 = (Freq * 1000000 / baud) >> 8; //ʸλ

  EA = 1;
}

/*****************************************************
*ƣvoid TWIX_Init(void)
*ܣTWIXʼ
*ڲvoid
*ڲvoid
*****************************************************/
void TWIX_Init(void)
{
  TMCON |= 0x80;    //нӿUSCIXѡTWIͨ
#if (USCIX_Select == USCI2)
  P4CON &= ~0x18;
  P4PH |= 0x18;
  IE2 |= 0x02;      //ж
#elif (USCIX_Select == USCI3)
  P2CON &= ~0x60;
  P2PH |= 0x60;
  IE2 |= 0x04;      //ж
#elif (USCIX_Select == USCI4)
  P5CON &= ~0x20;
  P5PH |= 0x20;
  P4CON &= ~0x70;
  P4PH |= 0x70;
  IE2 |= 0x08;     //ж
#elif (USCIX_Select == USCI5)
  P0CON &= ~0x06;
  P0PH |= 0x06;
  IE2 |= 0x10;     //ж
#endif
	#if (TWIX_Mode == 0)	
 { USXCON3 = TWIX_Slaver_SendData[0];   }   //ӻԤ׼
 #endif
  TMCON |= 0x80;   //ѡTWIXģʽ
  USXCON0 = 0x88;  //ģʽ ʹӦ־λ
  USXCON1 = 0x40;  //---- xxxx  xΪʱ,չ
  USXCON2 = 0x02;  //ӻַ
  IE2 |= 1 << (USCIX_Select - 1);    //ж
  EA = 1;
}

/*****************************************************
*ƣvoid SPIX_Init(void)
*ܣSPIXʼ
*ڲvoid
*ڲvoid
*****************************************************/
void SPIX_Init(void)
{
  TMCON |= 0x40;    //нӿUSCIXѡSPIͨ
#if (USCIX_Select == USCI2)
  P4CON &= ~0x38;
  P4PH |= 0x38;
  IE2 |= 0x02;      //ж
#elif (USCIX_Select == USCI3)
  P2CON &= ~0xE0;
  P2PH |= 0xE0;
  IE2 |= 0x04;      //ж
#elif (USCIX_Select == USCI4)
  P5CON &= ~0x20;
  P5PH |= 0x20;
  P4CON &= ~0xC0;
  P4PH |= 0xC0;
  IE2 |= 0x08;     //ж
#elif (USCIX_Select == USCI5)
  P0CON &= ~0x0E;
  P0PH |= 0x0E;
  IE2 |= 0x10;     //ж
#endif
  TMCON |= 0X40;    //ѡSPIXģʽ
#if (SPIX_Mode == 0)	
 {  USXCON0 = 0x23;   }   //SPIXΪ豸SCKʱΪ͵ƽSCKڵһزɼݣʱΪFsy/8
#elif (SPIX_Mode == 1)	
 {  USXCON0 = 0x03; }   //SPIXΪ豸SCKʱΪ͵ƽSCKڵһزɼݣʱΪFsy/8
#endif 
  USXCON1 = 0x00;   //MSBȷͣ8λ
  USXCON0 |= 0x80;  //SPIX
  IE2 |= 1 << (USCIX_Select - 1);    //ж
  EA = 1;
}

#if (USCIX_Select == USCI2)
/*****************************************************
*ƣvoid TWI2/SPI2/UART2_Int() interrupt 7
*ܣUSCI2жϺ
*ڲvoid
*ڲvoid
*****************************************************/
#if (USCIX_Mode == UartX)
void UART2_Int() interrupt 16   //UartXжϺ
{
  if(USXCON0 & 0x02)  //ͱ־λж
  {
    USXCON0 &= 0xFE;
    UartXSendFlag = 1;
  }
  if((USXCON0 & 0x01)) //ձ־λж
  {
    USXCON0 &= 0xFD;
    UartXReceiveFlag = 1;
  }
}
#elif (USCIX_Mode == TWIX)
void TWI2_Int() interrupt 16     //TWIXжϺ
{
  if(USXCON0 & 0x40)
  {
    USXCON0 &= 0xbf;  //ж
    TWIXFlag = 1;
  }
}
#elif (USCIX_Mode == SPIX)
void SPI2Int(void) interrupt 16    //SPIXжϺ
{
  if(USXCON1 & 0X08)  //ͻձ־ж
  {
    USXCON1 &= ~0X08;
  }
  if(USXCON1 & 0X80)  //ݴ־λж
  {
    USXCON1 &= ~0X80;
    SPIXFlag = 1;
  }
}
#endif
#elif (USCIX_Select == USCI3)
/*****************************************************
*ƣvoid TWI3/SPI3/UART3_Int() interrupt 7
*ܣUSCI2жϺ
*ڲvoid
*ڲvoid
*****************************************************/
#if (USCIX_Mode == UartX)
void UART3_Int() interrupt 17   //UartXжϺ
{
  if(USXCON0 & 0x02)  //ͱ־λж
  {
    USXCON0 &= 0xFE;
    UartXSendFlag = 1;
  }
  if((USXCON0 & 0x01)) //ձ־λж
  {
    USXCON0 &= 0xFD;
    UartXReceiveFlag = 1;
  }
}
#elif (USCIX_Mode == TWIX)
void TWI3_Int() interrupt 17     //TWIXжϺ
{
  if(USXCON0 & 0x40)
  {
    USXCON0 &= 0xbf;  //ж
    TWIXFlag = 1;
  }
}
#elif (USCIX_Mode == SPIX)
void SPI3_Int(void) interrupt 17    //SPIXжϺ
{
  if(USXCON1 & 0X08)  //ͻձ־ж
  {
    USXCON1 &= ~0X08;
  }
  if(USXCON1 & 0X80)  //ݴ־λж
  {
    USXCON1 &= ~0X80;
    SPIXFlag = 1;
  }
}
#endif
#elif (USCIX_Select == USCI4)
/*****************************************************
*ƣvoid TWI4/SPI4/UART4_Int() interrupt 7
*ܣUSCI2жϺ
*ڲvoid
*ڲvoid
*****************************************************/
#if (USCIX_Mode == UartX)
void UART4_Int() interrupt 18   //UartXжϺ
{
  if(USXCON0 & 0x02)  //ͱ־λж
  {
    USXCON0 &= 0xFE;
    UartXSendFlag = 1;
  }
  if((USXCON0 & 0x01)) //ձ־λж
  {
    USXCON0 &= 0xFD;
    UartXReceiveFlag = 1;
  }
}
#elif (USCIX_Mode == TWIX)
void TWI4_Int() interrupt 18     //TWIXжϺ
{
  if(USXCON0 & 0x40)
  {
    USXCON0 &= 0xbf;  //ж
    TWIXFlag = 1;
  }
}
#elif (USCIX_Mode == SPIX)
void SPI4_Int(void) interrupt 18   //SPIXжϺ
{
  if(USXCON1 & 0X08)  //ͻձ־ж
  {
    USXCON1 &= ~0X08;
  }
  if(USXCON1 & 0X80)  //ݴ־λж
  {
    USXCON1 &= ~0X80;
    SPIXFlag = 1;
  }
}
#endif

#elif (USCIX_Select == USCI5)
#if (USCIX_Mode == UartX)
void UART5_Int() interrupt 19   //UartXжϺ
{
  if(USXCON0 & 0x02)  //ͱ־λж
  {
    USXCON0 &= 0xFE;
    UartXSendFlag = 1;
  }
  if((USXCON0 & 0x01)) //ձ־λж
  {
    USXCON0 &= 0xFD;
    UartXReceiveFlag = 1;
  }
}
#elif (USCIX_Mode == TWIX)
void TWI5_Int() interrupt 19     //TWIXжϺ
{
  if(USXCON0 & 0x40)
  {
    USXCON0 &= 0xbf;  //ж
    TWIXFlag = 1;
  }
}
#elif (USCIX_Mode == SPIX)
void SPI5_Int(void) interrupt 19   //SPIXжϺ
{
  if(USXCON1 & 0X08)  //ͻձ־ж
  {
    USXCON1 &= ~0X08;
  }
  if(USXCON1 & 0X80)  //ݴ־λж
  {
    USXCON1 &= ~0X80;
    SPIXFlag = 1;
  }
}
#endif

#endif
