#include "H/Function_Init.H"

//ѡһģʽ
#define  Uart1   0
#define  TWI1    1
#define  SPI1    2

#define  USCI1_Mode  SPI1

#define TWI1_Mode 1//0:ģʽ   1ӻģʽ
#define SPI1_Mode 1 //0:ģʽ   1ӻģʽ

void Uart1_Init(uint Freq, unsigned long int baud);
void TWI1_Init(void);
void SPI1_Init(void);

bit Uart1SendFlag = 0;    //Uart1жϱ־λ
bit Uart1ReceiveFlag = 0; //Uart1жϱ־λ
bit SPI1Flag = 0;         //SPI1ݴɱ־λ
bit TWI1Flag = 0;         //TWI1жϱ־λ
uint8_t TxXferCount1 = 0;  //SPI/TWIĿ
uint8_t RxXferCount1 = 0;  //SPI/TWIĿ

volatile uint8_t Uart1_RxData[5];

uint8_t SPI1_Master_SendData[8] = {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
volatile uint8_t SPI1_Slaver_ReceiveData[8];

uint8_t TWI1_Master_SendData[8]={0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
volatile uint8_t TWI1_Slaver_ReceiveData[8];
/*****************************************************
*ƣvoid USCI1_Test(void)
*ܣUSCI1
*ڲvoid
*ڲvoid
*****************************************************/
void USCI1_Test(void)
{
#if (USCI1_Mode == Uart1)
		int num1,num2;
    Uart1_Init(32, 9600);
		while(1)
		{
			for(num1=0;num1<5;num1++)
			{
				while(!Uart1ReceiveFlag);
				Uart1ReceiveFlag = 0;
				Uart1_RxData[num1] = US1CON3 ;
			}
			for(num2=0;num2<5;num2++)
			{
				US1CON3  = Uart1_RxData[num2];
				while(!Uart1SendFlag);
				Uart1SendFlag = 0;
			}
		
  }
#endif
	
#if (USCI1_Mode == TWI1)
  TWI1_Init();
  while(1)
  {
#if (TWI1_Mode == 0)  //
		  US1CON1 |= 0x20;    //ʼ
		  Delay(100);
      while(TWI1Flag == 0);
      TWI1Flag = 0; 
      US1CON3 = 0x02;	    //͵ַд
      while(TWI1Flag == 0);
      TWI1Flag = 0; 
      while(TxXferCount1 < 8)
			{
				US1CON3 = TWI1_Master_SendData[TxXferCount1];             //TWI
				while(TWI1Flag == 0);
				TWI1Flag = 0; 
			  TxXferCount1++;
			}
     TxXferCount1=0;

    /* ǷɣҪͽźţֹռ */
      US1CON1 |= 0x10;
	
			Delay(1000);
#endif   
#if (TWI1_Mode == 1)  //ӻ  

      while((0x07 & US1CON0)!=0x02);//жΪ״̬
			Delay(100);
			while(TWI1Flag == 0);
			TWI1Flag = 0;                 
     	Delay(100);
    /* ݹ */
			do
			{
				if(RxXferCount1 == 7) US1CON0 &= 0XF7;   //AAʹλ,UAC
				while(TWI1Flag == 0);
				TWI1Flag = 0;  
				TWI1_Slaver_ReceiveData[RxXferCount1] = US1CON3;             //TWI
				RxXferCount1++; 
			}  while(RxXferCount1 < 8);

			US1CON0 |= 0X08; //AAʹλ
			RxXferCount1 =0;
			while((0x07 & US1CON0)!=0x00);
  
		
#endif
		}
#endif
		
#if (USCI1_Mode == SPI1)
  SPI1_Init();
	
			while(1)
			{
#if (SPI1_Mode == 0)  //
				TxXferCount1 = 0;
				while(TxXferCount1 <  8)//жǷ
				{
				 
					US1CON2 = SPI1_Master_SendData[TxXferCount1];
					while(SPI1Flag == 0);	//ȴ		   
					SPI1Flag = 0;		
					TxXferCount1 ++;	//
				}
				Delay(1000);
#endif
#if (SPI1_Mode == 1)  //ӻ
			while(RxXferCount1 <8)
				{
					/* ȴSPIжϱ־λ */
					while(SPI1Flag == 0);	//ȴ
					SPI1Flag = 0;		
					SPI1_Slaver_ReceiveData[RxXferCount1] = US1CON2;			//ȡ
					RxXferCount1++;	//1       
				}
				RxXferCount1 = 0;
				Delay(100);

#endif
		
 
  }
#endif
}
/*****************************************************
*ƣvoid Uart1_Init(uint Freq,unsigned long int baud)
*ܣUart1жϳʼ
*ڲFreq-Ƶbaud-
*ڲvoid
*****************************************************/
void Uart1_Init(uint Freq,unsigned long int baud)
{
	P1CON &= 0xF5;    //TX/RXΪ
	P1PH  |= 0x0A;
	
	OTCON |= 0xC0;    //нӿUSCI1ѡUart1ͨ
	US1CON0 = 0x50;   //ͨŷʽΪģʽһ
	US1CON1 = Freq*1000000/baud;   //ʵλ
	US1CON2 = (Freq*1000000/baud)>>8;   //ʸλ
	IE2 |= 0x01;      //USCI1ж
    EA = 1;	
}

/*****************************************************
*ƣvoid TWI1_Init(void)
*ܣTWI1ʼ
*ڲvoid
*ڲvoid
*****************************************************/
void TWI1_Init(void)
{
  OTCON |= 0x80;   //ѡTWI1ģʽ
  US1CON0 = 0x88;  //ģʽ ʹӦ־λ
  US1CON1 = 0x40;  //---- xxxx  xΪʱ
  US1CON2 = 0x02;  //ӻַ
  IE2 |= 0x01;
  EA = 1;
}

/*****************************************************
*ƣvoid SPI1_Init(void)
*ܣSPI1ʼ
*ڲvoid
*ڲvoid
*****************************************************/
void SPI1_Init(void)
{
   OTCON |= 0X40;    //ѡSPI1ģʽ
#if (SPI1_Mode == 0)	
 {  US1CON0 = 0x23;   }   //SPI0Ϊ豸SCKʱΪ͵ƽSCKڵһزɼݣʱΪFsy/8
#elif (SPI1_Mode == 1)	
 {  US1CON0 = 0x03;   }   //SPI0Ϊ豸SCKʱΪ͵ƽSCKڵһزɼݣʱΪFsy/8
#endif 
  US1CON1 = 0x00;   //MSBȷͣ8λ
  US1CON0 |= 0x80;  //SPI1
  IE2 |= 0x01;
  EA = 1;
}


/*****************************************************
*ƣvoid TWI1/PI/UART1_Int() interrupt 7
*ܣUSCI1жϺ
*ڲvoid
*ڲvoid
*****************************************************/
#if (USCI1_Mode == Uart1)
void Uart1_Int() interrupt 15   //Uart1жϺ
{
	if(US1CON0&0x02)    //ͱ־λж
	{
    US1CON0 &= 0xFE;
		Uart1SendFlag = 1;
	}
	if((US1CON0&0x01))  //ձ־λж
	{
    US1CON0 &= 0xFD;
		Uart1ReceiveFlag = 1;
	}	
}
#endif

#if (USCI1_Mode == TWI1)
void TWI1_Int() interrupt 15     //TWI1жϺ
{
	if(US1CON0&0x40)
	{
		US1CON0 &= 0xbf;  //ж
		TWI1Flag = 1;
	}	
}
#endif 

#if (USCI1_Mode == SPI1)
void Spi1_Int(void) interrupt 15    //SPI1жϺ
{	  
	if(US1CON1&0X08)    //ͻձ־ж
	{
		US1CON1 &= ~0X08;
	}
	if(US1CON1&0X80)    //ݴ־λж
	{
		US1CON1 &= ~0X80;
		SPI1Flag = 1;
	}
}
#endif 