#include "H/Function_Init.H"

//ѡһģʽ
#define  Uart0   0
#define  TWI0    1
#define  SPI0    2

#define  USCI0_Mode  SPI0
#define TWI0_Mode 1//0:ģʽ   1ӻģʽ
#define SPI0_Mode 1 //0:ģʽ   1ӻģʽ

void Uart0_Init(uint Freq,unsigned long int baud);
void TWI0_Init(void);
void SPI0_Init(void);

bit Uart0SendFlag = 0;    //Uart0жϱ־λ
bit Uart0ReceiveFlag = 0; //Uart0жϱ־λ
bit SPI0Flag = 0;         //SPI0ݴɱ־λ
bit TWI0Flag = 0;         //TWI0жϱ־λ
uint8_t TxXferCount = 0;  //SPI/TWIĿ
uint8_t RxXferCount = 0;  //SPI/TWIĿ

volatile uint8_t Uart0_RxData[5];

uint8_t SPI0_Master_SendData[8] = {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
volatile uint8_t SPI0_Slaver_ReceiveData[8];

uint8_t TWI0_Master_SendData[8]={0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
volatile uint8_t TWI0_Slaver_ReceiveData[8];
/*****************************************************
*ƣvoid USCI0_Test(void)
*ܣUSCI0
*ڲvoid
*ڲvoid
*****************************************************/
void USCI0_Test(void)
{
#if (USCI0_Mode == Uart0)
	int num1,num2;
   Uart0_Init(32, 9600);
  while(1)
  {
		for(num1=0;num1<5;num1++)
		{
			while(!Uart0ReceiveFlag);
			Uart0ReceiveFlag = 0;
			Uart0_RxData[num1] = US0CON3 ;
		}
		for(num2=0;num2<5;num2++)
		{
			US0CON3  = Uart0_RxData[num2];
	  	while(!Uart0SendFlag);
      Uart0SendFlag = 0;
		}
  
  }
#endif
	
#if (USCI0_Mode == TWI0)
  TWI0_Init();
  while(1)
  {
#if (TWI0_Mode == 0)  //
      US0CON1 |= 0x20;    //ʼ
		  Delay(100);
      while(TWI0Flag == 0);
      TWI0Flag = 0; 
      US0CON3 = 0x02;	    //͵ַд
      while(TWI0Flag == 0);
      TWI0Flag = 0; 
      while(TxXferCount < 8)
			{
				US0CON3 = TWI0_Master_SendData[TxXferCount];             //TWI
				while(TWI0Flag == 0);
				TWI0Flag = 0; 
			  TxXferCount++;
			}
     TxXferCount=0;

    /* ǷɣҪͽźţֹռ */
      US0CON1 |= 0x10;
	
			Delay(1000);
#endif   
#if (TWI0_Mode == 1)  //ӻ  

			while((0x07 & US0CON0)!=0x02);//жΪ״̬
			Delay(100);
			while(TWI0Flag == 0);
			TWI0Flag = 0;                 
     	Delay(100);
    /* ݹ */
			do
			{
				if(RxXferCount == 7) US0CON0 &= 0XF7;   //AAʹλ,UAC
				while(TWI0Flag == 0);
				TWI0Flag = 0;  
				TWI0_Slaver_ReceiveData[RxXferCount] = US0CON3;             //TWI
				RxXferCount++; 
			}  while(RxXferCount < 8);

			US0CON0 |= 0X08; //AAʹλ
			RxXferCount =0;
			while((0x07 & US0CON0)!=0x00);
		 
		
#endif
  }
#endif

#if (USCI0_Mode == SPI0)
   SPI0_Init();
   
   while(1)
   { 
#if (SPI0_Mode == 0)  //
	    TxXferCount = 0;
			while(TxXferCount <  8)//жǷ
			{
			 
				US0CON2 = SPI0_Master_SendData[TxXferCount];
				while(SPI0Flag == 0);	//ȴ		   
				SPI0Flag = 0;		
				TxXferCount ++;	//
			
			}
	   	Delay(1000);
		

#elif (SPI0_Mode == 1) //ӻ
   
 
			 while(RxXferCount <8)
				{
					/* ȴSPIжϱ־λ */
					while(SPI0Flag == 0);	//ȴ
					SPI0Flag = 0;		
					SPI0_Slaver_ReceiveData[RxXferCount] = US0CON2;			//ȡ16λ,ҵַ
					RxXferCount++;	//1       
				}
				RxXferCount = 0;
			  Delay(100);
#endif
  }
#endif
}
/*****************************************************
*ƣvoid Uart0_Init(uint Freq,unsigned long int baud)
*ܣUart0жϳʼ
*ڲFreq-Ƶbaud-
*ڲvoid
*****************************************************/
void Uart0_Init(uint Freq,unsigned long int baud)
{
	P0CON &= 0x9F;    //TX/RXΪ
	P0PH  |= 0x60;
	
	OTCON |= 0x30;    //нӿUSCI0ѡUart0ͨ
	US0CON0 = 0x50;   //ͨŷʽΪģʽһ
	US0CON1 = Freq*1000000/baud;   //ʵλ
	US0CON2 = (Freq*1000000/baud)>>8;   //ʸλ
	IE1 |= 0x01;      //USCI0ж
    EA = 1;	
}

/*****************************************************
*ƣvoid TWI0_Init(void)
*ܣTWI0ʼ
*ڲvoid
*ڲvoid
*****************************************************/
void TWI0_Init(void)
{
  OTCON |= 0x20;   //ѡTWI0ģʽ	
  US0CON0 = 0x88;  // ʹӦ־λ
  US0CON1 = 0x40;  //---- xxxx  xΪʱ
  US0CON2 = 0x02;  //ӻַ0x01
  IE1 |= 0x01;   //ж
  EA = 1;
}

/*****************************************************
*ƣvoid SPI0_Init(void)
*ܣSPI0ʼ
*ڲvoid
*ڲvoid
*****************************************************/
void SPI0_Init(void)
{ 
  OTCON |= 0X10;    //SPI0ģʽ
#if (SPI0_Mode == 0)	
 {  US0CON0 = 0x23;   }   //SPI0Ϊ豸SCKʱΪ͵ƽSCKڵһزɼݣʱΪFsy/8
#elif (SPI0_Mode == 1)	
 {  US0CON0 = 0x03;   }   //SPI0Ϊ豸SCKʱΪ͵ƽSCKڵһزɼݣʱΪFsy/8
#endif 
  US0CON1 = 0x00;   //MSBȷͣ8λ
  US0CON0 |= 0x80;  //SPI0
  IE1 |= 0x01;
  EA = 1;
 
}


/*****************************************************
*ƣvoid TWI0/PI/UART1_Int() interrupt 7
*ܣUSCI0жϺ
*ڲvoid
*ڲvoid
*****************************************************/
#if (USCI0_Mode == Uart0)
void Uart0_Int() interrupt 7   //Uart0жϺ
{
	if(US0CON0&0x02)    //ͱ־λж
	{
    US0CON0 &= 0xFE;
		Uart0SendFlag = 1;
	}
	if((US0CON0&0x01))  //ձ־λж
	{
    US0CON0 &= 0xFD;
		Uart0ReceiveFlag = 1;
	}	
}
#endif

#if (USCI0_Mode == TWI0)
void TWI0_Int() interrupt 7     //TWI0жϺ
{
	if(US0CON0&0x40)
	{
		US0CON0 &= 0xbf;  //ж
		TWI0Flag = 1;
	}	
}
#endif 

#if (USCI0_Mode == SPI0)
void Spi0_Int(void) interrupt 7    //SPI0жϺ
{	  
	if(US0CON1&0X08)    //ͻձ־ж
	{
		US0CON1 &= ~0X08;
	}
	if(US0CON1&0X80)    //ݴ־λж
	{
		US0CON1 &= ~0X80;
		SPI0Flag = 1;
	}
}
#endif 