#include "H/Function_Init.H"

void ADC_Init(uint Channel);
unsigned int ADCValue = 0x0000;
unsigned int ADC_AverageValue(void);
bit AdcFlag = 0;

/***********ADCѡ*************/
#if (IC_MODEL == SC95F8767 || IC_MODEL == SC95F8766)
	enum Channel {AIN0=0,AIN1,AIN2,AIN3,AIN4,AIN5,AIN6,AIN7,AIN8,AIN9,AIN10,AIN11,AIN12,AIN13,AIN14,AIN15,VDD4=31};
#endif

#if (IC_MODEL == SC95F8765 || IC_MODEL == SC95F8763)
enum Channel {AIN4=4,AIN5,AIN6,AIN7,AIN12=12,AIN13,AIN14,AIN15,VDD4=31};
#endif
	
/*****************************************************
*ƣvoid ADC_Test(void)
*ܣADC
*ڲvoid
*ڲvoid
*****************************************************/
void ADC_Test(void)
{
	ADC_Init(AIN4);
	while(1)
	{
		 ADCValue = ADC_AverageValue();	
	}
}
/*****************************************************
*ƣvoid ADC_Init(uint Channel)
*ܣADCʼ
*ڲChannel
*ڲvoid
*****************************************************/
void ADC_Init(uint Channel)
{
	ADCCON = 0X80|Channel;		//ADCADCƵΪ2M ,ѡChannelλADC
	if(Channel<8)
	{
		ADCCFG0 = 1<<Channel;   //ChannelΪ
	}
	else
	{
		ADCCFG1 = 1<<(Channel-8);   //ChannelΪ
	}
	ADCCFG2 = 0x10;			//ADCʱΪʱ
	IE |= 0X40;        //ADCж
	EA = 1;
}


unsigned int ADC_AverageValue()
{
	int i = 0; 
	unsigned int ADC_ValueSum = 0, ADC_ValueMax = 0 ,ADC_ValueMin = 0x01 << 12 ,ADC_ValueMean = 0 ,ADC_ValueTad = 0;
	for(i=0;i<10;i++ )
	{	
		ADCCON |= 0X40;   //ʼADCת
	  while(!AdcFlag);	         		 //ȴ ADCת;
		AdcFlag = 0;
		ADC_ValueTad = (ADCVH<<4)+(ADCVL>>4);
		if(ADC_ValueTad>ADC_ValueMax)
		{
		 ADC_ValueMax = ADC_ValueTad;
		}
		if(ADC_ValueTad<ADC_ValueMin)
		{
		 ADC_ValueMin = ADC_ValueTad;
		}
		ADC_ValueSum += ADC_ValueTad;
	}
	ADC_ValueMean = (unsigned int)((ADC_ValueSum - ADC_ValueMax - ADC_ValueMin) / 8);
  return ADC_ValueMean;
}



void ADC_Interrupt(void) interrupt 6
{
	ADCCON &= ~(0X20);  //жϱ־λ
	AdcFlag = 1;
}