/**
 * RT-Thread RuiChing
 *
 * COPYRIGHT (C) 2024-2025 Shanghai Real-Thread Electronic Technology Co., Ltd.
 * All rights reserved.
 *
 * The license and distribution terms for this file may be
 * found in the file LICENSE in this distribution.
 */
#include <rtthread.h>
#include <rtdevice.h>

#define ADC_DEV_NAME        "adc0"
#define ADC_CH              5
#define REFER_VOLTAGE       2500 /* 参考电压2.5v */

#define AD7606_RANGE_IS_10V 0 /* 根据硬件RANGE引脚设定：1=±10V，0=±5V */

#if AD7606_RANGE_IS_10V
#define FULL_SCALE_MV 10000 /* ±10V 量程 */
#else
#define FULL_SCALE_MV 5000 /* ±5V 量程 */
#endif
 rt_int32_t vol_mv[8];
 static rt_thread_t adc_thread = RT_NULL;
static int adc_read(void)
{
    rt_adc_device_t adc = (rt_adc_device_t)rt_device_find(ADC_DEV_NAME);
    if (!adc)
    {
        rt_kprintf("can't find %s\n", ADC_DEV_NAME);
        return -RT_ERROR;
    }

    rt_err_t ret = rt_adc_enable(adc, 1);
    if (ret != RT_EOK)
    {
        rt_kprintf("enable ch%d fail: %d\n", 1, ret);
        return ret;
    }
    rt_int16_t raw_val=0;
    uint8_t i=0;
    while(1)
    {
        for(i=0;i<8;i++)
        {
            raw_val = rt_adc_read(adc, i+1);
            vol_mv[i] = ((rt_int32_t)raw_val * (rt_int32_t)FULL_SCALE_MV) / 32767;
        }
        rt_thread_mdelay(5);
    //    mv += REFER_VOLTAGE;

//        if (mv >= 0)
//        {
//            rt_kprintf("ADC Channel %d: %d.%03d V\n", ADC_CH, mv / 1000, mv % 1000);
//        }
//        else
//        {
//            rt_kprintf(
//                "ADC Channel %d: -%d.%03d V\n", ADC_CH, (-mv) / 1000, (-mv) % 1000);
//        }
    }


//    rt_adc_disable(adc, ADC_CH);

    return RT_EOK;
}



extern int lvgl_thread_init(void);

#include "lvgl.h"
lv_obj_t * label[8];
static void change_cb(lv_timer_t * timer)
{
//  static int cc=0;
//  printf("index:%d",cc++);
  for(uint8_t i=0;i<8;i++)
  {
      if(vol_mv[i]>0)
          lv_label_set_text_fmt(label[i], "%d.%03d V",vol_mv[i]/ 1000, vol_mv[i] % 1000);
      else {
          lv_label_set_text_fmt(label[i], "-%d.%03d V",(-vol_mv[i])/ 1000, (-vol_mv[i]) % 1000);
    }
  }
}
void display_8_channels_voltage_demo() {

  lv_obj_t * scr = lv_scr_act();
  lv_obj_set_style_bg_color(scr, lv_color_hex(0x121212), LV_PART_MAIN);

  // 标题栏简化（降低负载）
  lv_obj_t * title_bar = lv_obj_create(scr);
  lv_obj_set_size(title_bar, 720, 40);  // 高度从50改为40
  lv_obj_set_style_bg_color(title_bar, lv_color_hex(0x2D2D2D), LV_PART_MAIN);
  lv_obj_set_style_border_width(title_bar, 0, LV_PART_MAIN);
  lv_obj_align(title_bar, LV_ALIGN_TOP_MID, 0, 0);

  lv_obj_t * title_label = lv_label_create(title_bar);
  lv_label_set_text(title_label, "AD7606 8-Channel Voltage Monitor");
  lv_obj_set_style_text_color(title_label, lv_color_hex(0xFFFFFF), LV_PART_MAIN);
  lv_obj_set_style_text_font(title_label, &lv_font_montserrat_18, LV_PART_MAIN);  // 字体从20改为18
  lv_obj_center(title_label);


  static lv_coord_t col_dsc[] = {100,500, LV_GRID_TEMPLATE_LAST};
  static lv_coord_t row_dsc[] = {60,60,60,60,60,60,60,60, LV_GRID_TEMPLATE_LAST};

  /*Create a container with grid*/
  lv_obj_t * cont = lv_obj_create(lv_scr_act());
  lv_obj_set_style_grid_column_dsc_array(cont, col_dsc, 0);
  lv_obj_set_style_grid_row_dsc_array(cont, row_dsc, 0);
  lv_obj_set_size(cont, 720, 640);
  lv_obj_center(cont);
  lv_obj_set_layout(cont, LV_LAYOUT_GRID);
  lv_obj_set_style_bg_color(cont, lv_color_hex(0x2D2D2D), LV_PART_MAIN);

  lv_obj_t * obj;
  lv_obj_t *t_label;
  static lv_style_t style_default;
  lv_style_init(&style_default);
  lv_style_set_bg_color(&style_default, lv_palette_main(LV_PALETTE_GREEN));
  lv_style_set_text_color(&style_default, lv_color_hex(0x2D2D2D)); // 按下字体颜色为红色
  lv_style_set_text_font(&style_default,&lv_font_montserrat_18);
  uint32_t i;
  for(i = 0; i < 8; i++) {
    obj = lv_btn_create(cont);
    lv_obj_add_style(obj, &style_default, 0);
//    /*Stretch the cell horizontally and vertically too
//         *Set span to 1 to make the cell 1 column/row sized*/
    lv_obj_set_grid_cell(obj, LV_GRID_ALIGN_STRETCH, 0, 1,
                         LV_GRID_ALIGN_STRETCH, i, 1);

    t_label = lv_label_create(obj);
    lv_label_set_text_fmt(t_label, "ch[%d]",i+1);
    lv_obj_center(t_label);
    lv_obj_align(t_label, LV_ALIGN_LEFT_MID, 0, 0);



    obj = lv_btn_create(cont);
    lv_obj_add_style(obj, &style_default, 0);
    //    /*Stretch the cell horizontally and vertically too
    //         *Set span to 1 to make the cell 1 column/row sized*/
    lv_obj_set_grid_cell(obj, LV_GRID_ALIGN_STRETCH, 1, 1,
                         LV_GRID_ALIGN_STRETCH, i, 1);

    label[i] = lv_label_create(obj);
//    lv_label_set_text_fmt(label[i], "vol:%d",i+1);
    lv_obj_center(label[i]);
    lv_obj_align(label[i], LV_ALIGN_LEFT_MID, 0, 0);




  }
  // 状态栏简化
  lv_obj_t * status_bar = lv_obj_create(scr);
  lv_obj_set_size(status_bar, 720, 25);  // 高度从30改为25
  lv_obj_set_style_bg_color(status_bar, lv_color_hex(0x2D2D2D), LV_PART_MAIN);
  lv_obj_set_style_border_width(status_bar, 0, LV_PART_MAIN);
  lv_obj_align(status_bar, LV_ALIGN_BOTTOM_MID, 0, 0);

  lv_obj_t * status_label = lv_label_create(status_bar);
  lv_label_set_text(status_label, "Sample Rate: 100Hz | Status: Normal");
  lv_obj_set_style_text_color(status_label, lv_color_hex(0xAAAAAA), LV_PART_MAIN);
  lv_obj_set_style_text_font(status_label, &lv_font_montserrat_14, LV_PART_MAIN);  // 字体从12改为11
  lv_obj_center(status_label);

  lv_timer_create(change_cb,100,NULL);
}
void lv_user_gui_init(void)
{
    display_8_channels_voltage_demo();
}

int main(void)
{
    rt_kprintf("Hello, RT-Thread app\n");
//    adc_read();
    adc_thread = rt_thread_create("ad7606", adc_read, RT_NULL, // 动态创建线程
        4096, 9, 5);
    if (adc_thread != RT_NULL)
    {
        rt_thread_control(adc_thread, RT_THREAD_CTRL_BIND_CPU, (void*)1);
        rt_thread_startup(adc_thread); // 启动线程
    }
    lvgl_thread_init();

    return 0;
}
