#ifndef __LCD_INIT_H
#define __LCD_INIT_H

#include "hal_data.h"
#define USE_HORIZONTAL 0  //设置横屏或者竖屏显示 0或1为竖屏 2或3为横屏


#if USE_HORIZONTAL==0||USE_HORIZONTAL==1
#define LCD_W 240
#define LCD_H 280

#else
#define LCD_W 280
#define LCD_H 240
#endif




//-----------------LCD端口定义----------------

#define LCD_RES_Clr()  R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_04_PIN_02, BSP_IO_LEVEL_LOW)//RES
#define LCD_RES_Set()  R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_04_PIN_02, BSP_IO_LEVEL_HIGH)

#define LCD_DC_Clr()   R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_04_PIN_03, BSP_IO_LEVEL_LOW)//DC
#define LCD_DC_Set()   R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_04_PIN_03, BSP_IO_LEVEL_HIGH)

#define LCD_CS_Clr()   R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_02_PIN_04, BSP_IO_LEVEL_LOW)//CS
#define LCD_CS_Set()   R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_02_PIN_04, BSP_IO_LEVEL_HIGH)

#define LCD_BLK_Clr()  R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_07_PIN_08, BSP_IO_LEVEL_LOW);//BLK
#define LCD_BLK_Set()  R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_07_PIN_08, BSP_IO_LEVEL_HIGH)




void LCD_GPIO_Init(void);//初始化GPIO
void LCD_SendByte(uint8_t dat);
void LCD_WR_DATA8(uint8_t dat);//写入一个字节
void LCD_WR_DATA16(uint16_t dat);//写入两个字节
void LCD_WR_REG(uint8_t dat);//写入一个指令
void LCD_Address_Set(uint16_t x1,uint16_t y1,uint16_t x2,uint16_t y2);//设置坐标函数
void TFT_Init(void);//LCD初始化
#endif




