#include "lcd_init.h"
//#include "delay.h"
  fsp_err_t err = FSP_SUCCESS;
  //volatile bool g_transfer_complete = false;
void LCD_GPIO_Init(void)
{

}


//========================================================================
// 描述: 写SPI一个字节函数
// 参数: 无.
// 返回: 无
//========================================================================

void    LCD_SendByte(uint8_t dat)
{  // LCD_CS_Clr() ;
//    //fsp_err_t err = FSP_SUCCESS;
//volatile bool  g_transfer_complete = false;
//    err = R_SPI_Write(&g_spi0_ctrl, &dat, 1, SPI_BIT_WIDTH_8_BITS);
//    assert(err == FSP_SUCCESS);
//    while(g_transfer_complete == false)
//    {
//
//    }

    uint8_t i;
    for(i=0;i<8;i++){

        if(dat&0x80){
            R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_02_PIN_11, BSP_IO_LEVEL_HIGH);

        }
        else{
            R_IOPORT_PinWrite(&g_ioport_ctrl,BSP_IO_PORT_02_PIN_11, BSP_IO_LEVEL_LOW);
        }
        dat<<=1;
        R_BSP_SoftwareDelay(6, BSP_DELAY_UNITS_MICROSECONDS);
        R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_02_PIN_09, BSP_IO_LEVEL_LOW);
        R_BSP_SoftwareDelay(6, BSP_DELAY_UNITS_MICROSECONDS);
        R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_02_PIN_09, BSP_IO_LEVEL_HIGH);
      }

 LCD_CS_Set();
}


/******************************************************************************
      函数说明：LCD写入数据
      入口数据：dat 写入的数据
      返回值：  无
******************************************************************************/
void LCD_WR_DATA8(uint8_t dat)
{
    LCD_CS_Clr() ;
    LCD_SendByte(dat);
    LCD_CS_Set();
}


/******************************************************************************
      函数说明：LCD写入数据
      入口数据：dat 写入的数据
      返回值：  无
******************************************************************************/
void LCD_WR_DATA(uint16_t dat)
{
    LCD_CS_Clr() ;
    LCD_SendByte((uint8_t)(dat>>8));
    LCD_SendByte((uint8_t)dat);
    LCD_CS_Set();
}


/******************************************************************************
      函数说明：LCD写入命令
      入口数据：dat 写入的命令
      返回值：  无
******************************************************************************/
void LCD_WR_REG(uint8_t dat)
{
    LCD_DC_Clr();//写命令
    LCD_CS_Clr() ;
    LCD_SendByte(dat);
    LCD_CS_Set();
    LCD_DC_Set();//写数据
}


/******************************************************************************
      函数说明：设置起始和结束地址
      入口数据：x1,x2 设置列的起始和结束地址
                y1,y2 设置行的起始和结束地址
      返回值：  无
******************************************************************************/
void LCD_Address_Set(uint16_t x1,uint16_t y1,uint16_t x2,uint16_t y2)
{
//	if(USE_HORIZONTAL==0)
//	{
//		LCD_WR_REG(0x2a);//列地址设置
//		LCD_WR_DATA(x1);
//		LCD_WR_DATA(x2);
//		LCD_WR_REG(0x2b);//行地址设置
//		LCD_WR_DATA(y1+20);
//		LCD_WR_DATA(y2+20);
//		LCD_WR_REG(0x2c);//储存器写
//	}
//	else if(USE_HORIZONTAL==1)
//	{
//		LCD_WR_REG(0x2a);//列地址设置
//		LCD_WR_DATA(x1);
//		LCD_WR_DATA(x2);
//		LCD_WR_REG(0x2b);//行地址设置
//		LCD_WR_DATA(y1+20);
//		LCD_WR_DATA(y2+20);
//		LCD_WR_REG(0x2c);//储存器写
//	}
//	else if(USE_HORIZONTAL==2)
//	{
//		LCD_WR_REG(0x2a);//列地址设置
//		LCD_WR_DATA(x1+20);
//		LCD_WR_DATA(x2+20);
//		LCD_WR_REG(0x2b);//行地址设置
//		LCD_WR_DATA(y1);
//		LCD_WR_DATA(y2);
//		LCD_WR_REG(0x2c);//储存器写
//	}
//	else
//	{
//		LCD_WR_REG(0x2a);//列地址设置
//		LCD_WR_DATA(x1+20);
//		LCD_WR_DATA(x2+20);
//		LCD_WR_REG(0x2b);//行地址设置
//		LCD_WR_DATA(y1);
//		LCD_WR_DATA(y2);
//		LCD_WR_REG(0x2c);//储存器写
//	}
        LCD_WR_REG(0x2a);
        LCD_WR_DATA8(0x02);
        LCD_WR_DATA8((uint8_t)(x1+2));
        LCD_WR_DATA8(0x02);
        LCD_WR_DATA8((uint8_t)(x2+2));

        LCD_WR_REG(0x2b);
        LCD_WR_DATA8(0x01);
        LCD_WR_DATA8((uint8_t)(y1+1));
        LCD_WR_DATA8(0x01);
        LCD_WR_DATA8((uint8_t)(y2+1));

        LCD_WR_REG(0x2c);


}

void TFT_Init(void)
{
	LCD_GPIO_Init();//初始化GPIO
	
	LCD_RES_Clr();//复位
	R_BSP_SoftwareDelay (100, BSP_DELAY_UNITS_MILLISECONDS);
	LCD_RES_Set();
	R_BSP_SoftwareDelay (100, BSP_DELAY_UNITS_MILLISECONDS);
	
	LCD_BLK_Set();//打开背光
	R_BSP_SoftwareDelay (100, BSP_DELAY_UNITS_MILLISECONDS);
	
	//************* Start Initial Sequence **********//
	LCD_WR_REG(0x11); //Sleep out 
	R_BSP_SoftwareDelay (120, BSP_DELAY_UNITS_MILLISECONDS);          //Delay 120ms
	//************* Start Initial Sequence **********// 
	LCD_WR_REG(0x36);
	if(USE_HORIZONTAL==0)LCD_WR_DATA8(0x00);
	else if(USE_HORIZONTAL==1)LCD_WR_DATA8(0xC0);
	else if(USE_HORIZONTAL==2)LCD_WR_DATA8(0x70);
	else LCD_WR_DATA8(0xA0);

	LCD_WR_REG(0x3A);			
	LCD_WR_DATA8(0x05);

	LCD_WR_REG(0xB2);			
	LCD_WR_DATA8(0x0C);
	LCD_WR_DATA8(0x0C); 
	LCD_WR_DATA8(0x00); 
	LCD_WR_DATA8(0x33); 
	LCD_WR_DATA8(0x33); 			

	LCD_WR_REG(0xB7);			
	LCD_WR_DATA8(0x35);

	LCD_WR_REG(0xBB);			
	LCD_WR_DATA8(0x32); //Vcom=1.35V
					
	LCD_WR_REG(0xC2);
	LCD_WR_DATA8(0x01);

	LCD_WR_REG(0xC3);			
	LCD_WR_DATA8(0x15); //GVDD=4.8V  颜色深度
				
	LCD_WR_REG(0xC4);			
	LCD_WR_DATA8(0x20); //VDV, 0x20:0v

	LCD_WR_REG(0xC6);			
	LCD_WR_DATA8(0x0F); //0x0F:60Hz        	

	LCD_WR_REG(0xD0);			
	LCD_WR_DATA8(0xA4);
	LCD_WR_DATA8(0xA1); 

	LCD_WR_REG(0xE0);
	LCD_WR_DATA8(0xD0);   
	LCD_WR_DATA8(0x08);   
	LCD_WR_DATA8(0x0E);   
	LCD_WR_DATA8(0x09);   
	LCD_WR_DATA8(0x09);   
	LCD_WR_DATA8(0x05);   
	LCD_WR_DATA8(0x31);   
	LCD_WR_DATA8(0x33);   
	LCD_WR_DATA8(0x48);   
	LCD_WR_DATA8(0x17);   
	LCD_WR_DATA8(0x14);   
	LCD_WR_DATA8(0x15);   
	LCD_WR_DATA8(0x31);   
	LCD_WR_DATA8(0x34);   

	LCD_WR_REG(0xE1);     
	LCD_WR_DATA8(0xD0);   
	LCD_WR_DATA8(0x08);   
	LCD_WR_DATA8(0x0E);   
	LCD_WR_DATA8(0x09);   
	LCD_WR_DATA8(0x09);   
	LCD_WR_DATA8(0x15);   
	LCD_WR_DATA8(0x31);   
	LCD_WR_DATA8(0x33);   
	LCD_WR_DATA8(0x48);   
	LCD_WR_DATA8(0x17);   
	LCD_WR_DATA8(0x14);   
	LCD_WR_DATA8(0x15);   
	LCD_WR_DATA8(0x31);   
	LCD_WR_DATA8(0x34);
	LCD_WR_REG(0x21); 

	LCD_WR_REG(0x29);
} 







