#include "hal_data.h"
#include "bsp_lcd.h"
#include "bsp_uart.h"
#include "bsp_adc.h"
#include "lcd_init.h"
#include "lcd.h"
volatile int g_transfer_complete=0;
void spi_callback (spi_callback_args_t * p_args)
{
    if (SPI_EVENT_TRANSFER_COMPLETE == p_args->event)
    {
        g_transfer_complete = true;
    }
}
/*******************************************************************************************************************//**
 * main() is generated by the RA Configuration editor and is used to generate threads if an RTOS is used.  This function
 * is called by main() when no RTOS is used.
 **********************************************************************************************************************/
void hal_entry(void)
{
    /* TODO: add your own code here */
    double volt;
    UART_Init();
    ADC_Init();
    printf("ADC电压采集程序\r\n");
    LCD_Init ();
    LCD_setDot (true);
    fsp_err_t err = R_SPI_Open(&g_spi0_ctrl, &g_spi0_cfg);
    assert(FSP_SUCCESS == err);
    TFT_Init();
    while(1)
        {
        volt = Read_ADC_Voltage_Value ();
                uint32_t volt_int = volt * 100;
                if (volt_int == 0) //0V显示空电池
                {
                    LCD_setBattery (true, 0);
                }
                else if (volt_int >= 1 && volt_int <= 110) //0.01V~1.1V显示1格电量
                {
                    LCD_setBattery (true, 1);
                }
                else if (volt_int >= 111 && volt_int <= 220) //1.11V~2.2V显示2格电量
                {
                    LCD_setBattery (true, 2);
                }
                else // 2.2V以上显示3格电量
                {
                    LCD_setBattery (true, 3);
                }
                LCD_ShowNumber (volt_int, 3);
                R_BSP_SoftwareDelay (100, BSP_DELAY_UNITS_MILLISECONDS);
        R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_06_PIN_01, BSP_IO_LEVEL_HIGH);
        R_BSP_SoftwareDelay (100, BSP_DELAY_UNITS_MILLISECONDS);

        R_IOPORT_PinWrite(&g_ioport_ctrl, BSP_IO_PORT_06_PIN_01, BSP_IO_LEVEL_LOW);
        R_BSP_SoftwareDelay (100, BSP_DELAY_UNITS_MILLISECONDS);
        LCD_Fill(0,0,LCD_W,LCD_H,RED);
        R_BSP_SoftwareDelay(500, BSP_DELAY_UNITS_MILLISECONDS);
        }

#if BSP_TZ_SECURE_BUILD
    /* Enter non-secure code */
    R_BSP_NonSecureEnter();
#endif
}

#if BSP_TZ_SECURE_BUILD

FSP_CPP_HEADER
BSP_CMSE_NONSECURE_ENTRY void template_nonsecure_callable ();

/* Trustzone Secure Projects require at least one nonsecure callable function in order to build (Remove this if it is not required to build). */
BSP_CMSE_NONSECURE_ENTRY void template_nonsecure_callable ()
{

}
FSP_CPP_FOOTER

#endif
