#include "hal_data.h"

#ifndef SLCD_H_
#define SLCD_H_


#define CHECK_SEGMENT_WRITE_ERROR(err)  if(FSP_SUCCESS != err) \
                                        {   APP_ERR_PRINT("\r\n ** Writing to segment Failed FAILED ** \r\n"); \
                                        }  \

#define COUNT_DELAY                     (100U)
#define LCD_STABILIZATION_DELAY         (5U)

#define HUNDRED_THOUSAND                (100000U)
#define TEN_THOUSAND                    (10000U)
#define THOUSANDS                       (1000U)
#define HUNDREDS                        (100U)
#define TENS                            (10U)
#define UNITS                           (1U)

#define TEMP_IN_F                        (1)
//#define TEMP_IN_C                        (0)

#ifdef TEMP_IN_F
#define DISPLAY_TEMP_IN_F                (1)
#define DISPLAY_TEMP_IN_C                (0)
#define UPPER_TEMP_LIMIT                 (80)
#define LOWER_TEMP_LIMIT                 (60)
#elif TEMP_IN_C
#define DISPLAY_TEMP_IN_F                (0)
#define DISPLAY_TEMP_IN_C                (1)
#define UPPER_TEMP_LIMIT                 (27)
#define LOWER_TEMP_LIMIT                 (15)
#endif


typedef enum e_battery_level {
    BATTERY_EMPTY = 0,
    BATTERY_0 = 0,
    BATTERY_1,
    BATTERY_2,
    BATTERY_3,
    BATTERY_FULL = 4,
    BATTERY_4 = 4,
    BATTERY_OFF
} battery_level_t;


typedef enum e_degc_or_degf {
    TEMP_DEG_C,
    TEMP_DEG_F,
    DEG_C_F_OFF
} degc_or_degf_t;

typedef enum e_medium_dp_or_colon {
    SET_DP,
    SET_COLON,
    COLON_OFF,
    DP_COLON_OFF
} medium_dp_or_colon_t;

typedef enum e_medium_number_units {
    MN_UNITS,
    MN_TENS,
    MN_HUNDREDS,
    MN_THOUSANDS,
    MN_TEN_THOUSANDS,
    MN_HUN_THOUSANDS
} medium_number_units_t;


typedef struct st_icon_segment
{
    uint8_t segment;
    uint8_t data;
}icon_segment_t;

#define BATTERY_SHELL_SEGMENT   (0x25)
#define BATTERY_SHELL_DATA      (0x01)

#define BATTERY_LEVEL3_SEGMENT  (0x26)
#define BATTERY_LEVEL3_DATA     (0x02)

#define BATTERY_LEVEL2_SEGMENT  (0x26)
#define BATTERY_LEVEL2_DATA     (0x04)

#define BATTERY_LEVEL1_SEGMENT  (0x26)
#define BATTERY_LEVEL1_DATA     (0x08)

#define MED_DIGIT_MASK_8_4_2_1          (0x00)
#define MED_DIGIT_MASK_4_2_1            (0x08)

#define MEDIUM_DIGIT_DEC_POINT_SEGMENT  (0x1D)
#define MEDIUM_DIGIT_DEC_POINT_DATA     (0x08)

#define MEDIUM_DIGIT_COLON_SEGMENT      (0x10)
#define MEDIUM_DIGIT_COLON_DATA         (0x08)

fsp_err_t slcd_init(void);
void deinit_slcdc(void);

fsp_err_t set_segments_medium_digits( uint32_t value, medium_dp_or_colon_t point_or_colon );
fsp_err_t set_segments_icon_medium_dp_colon( medium_dp_or_colon_t setting );
fsp_err_t set_segments_icon_battery( battery_level_t level );

#endif /* SLCD_H_ */
