/***********************************************************************************************************************
 * File Name    : usr_rtc.h
 * Description  : Contains declarations of data structures and functions used in usr_rtc.c.
 **********************************************************************************************************************/
/***********************************************************************************************************************
* Copyright (c) 2020 - 2025 Renesas Electronics Corporation and/or its affiliates
*
* SPDX-License-Identifier: BSD-3-Clause
***********************************************************************************************************************/

#include "hal_data.h"
#ifndef USR_RTC_H_
#define USR_RTC_H_

/***********************************************************************************************************************
 * Macro definitions
 **********************************************************************************************************************/
/* These are the Hard coded User configurable Time which can changed as required
 * The Application Project start with this Default RTC time and runs
 * ie Date 07/04/2025   Time : 11:59:00 AM
 */
#define USER_DATA_SECONDS           (00)      /* Range 0-59 */
#define USER_DATA_MINUTES           (59)      /* Range 0-59 */
#define USER_DATA_HOUR              (11)      /* Range 0-23 */
#define USER_DATA_DAY_OF_THE_MONTH  (04)      /* Range 1-31 */
#define USER_DATA_MONTH_OF_THE_YEAR (06)      /* Range 0-11 */
#define USER_DATA_YEAR              (125)     /* 1900 + 125 = 2025 */


/* MACRO to flag the status */
#define SET_FLAG                    (0x01)
#define RESET_FLAG                  (0x00)

/*MACROs to adjust month and year values */
#define MON_ADJUST_VALUE            (1)
#define YEAR_ADJUST_VALUE           (1900)


/***********************************************************************************************************************
 * User-defined APIs
 **********************************************************************************************************************/
/*
 * function declarations
 */
fsp_err_t rtc_init(void);
fsp_err_t set_rtc_calendar_time_with_user_configured_time(void);
fsp_err_t get_rtc_calendar_time(void);
void rtc_date_readability_update(rtc_time_t * time);
void rtc_deinit(void);

#endif /* USR_RTC_H_ */
