#include "Touch_Button_Task.h"
#include "touch_btn/touch_btn.h"
/* TouchBtn entry function */
/* pvParameters contains TaskHandle_t */
void Touch_Button_Task_entry(void *pvParameters)
{
    FSP_PARAMETER_NOT_USED (pvParameters);

    /* TODO: add your own code here */
    uint32_t num = 0;
        uint32_t last_inc_time = 0, last_dec_time = 0;
        const uint32_t repeat_interval_ms = 100;  // 自动重复自增间隔
        TouchBtn_Init ();
        while (1)
        {
            TouchBtn_Process ();

        touchBtn_event_t e0 = TouchBtn_GetEvent (0);
        touchBtn_event_t e1 = TouchBtn_GetEvent (1);

        // 短按处理
        if (e0 == TOUCH_SHORT_PRESS)
        {
            if (num > 0)
                num--;
        }
        if (e1 == TOUCH_SHORT_PRESS)
        {
            num++;
        }
        // 同时长按TS0和TS1清零
        if (e0 == TOUCH_LONG_PRESS && e1 == TOUCH_LONG_PRESS)
        {
            num = 0;
        }

        // 长按 TS0 快速减10
        if (e0 == TOUCH_LONG_PRESS && xTaskGetTickCount () - last_dec_time >= repeat_interval_ms)  // 超过长按阈值
        {
            if (num >= 10)
                num -= 10;
            else
            {
                num = 0;
            }
            last_dec_time = xTaskGetTickCount ();
        }
        // 长按 TS1 快速加10
        if (e1 == TOUCH_LONG_PRESS && xTaskGetTickCount () - last_inc_time >= repeat_interval_ms)  // 超过长按阈值
        {
            num += 10;
            last_inc_time = xTaskGetTickCount ();

        }
        xQueueSend(queue_numData, &num, 0);
            vTaskDelay (1);
        }
}
