#include "hal_data.h"
#include "rtc.h"

rtc_time_t set_time = {
    .tm_sec = 59,   /* 秒，范围从 0 到 59 */
    .tm_min = 59,   /* 分，范围从 0 到 59 */
    .tm_hour = 23,  /* 小时，范围从 0 到 23*/
    .tm_mday = 28,  /* 一月中的第几天，范围从 1 到 31*/
    .tm_mon = 1,   /* 月份，范围从 0 到 11（0代表1月，11代表12月）*/
    .tm_year = 125, /* 自 1900 起的年数，2021 为 121*/
};

volatile bool rtc_flag = false;       // RTC 延时 1s 标志位

void rtc_callback(rtc_callback_args_t *p_args)
{
    if (p_args->event == RTC_EVENT_PERIODIC_IRQ)
        rtc_flag = true;
}
