#include "hal_data.h"
#include "debug_bsp_uart.h"
#include "rtc.h"

rtc_time_t get_time;

FSP_CPP_HEADER
void R_BSP_WarmStart(bsp_warm_start_event_t event);
FSP_CPP_FOOTER

/*******************************************************************************************************************/ /**
                                                                                                                       * main() is generated by the RA Configuration editor and is used to generate threads if an RTOS is used.  This function
                                                                                                                       * is called by main() when no RTOS is used.
                                                                                                                       **********************************************************************************************************************/

void hal_entry(void)
{
    /* TODO: add your own code here */

    Debug_UART9_Init(); // SCI9 UART 调试串口初始化
    g_rtc0.p_api->open(&g_rtc0_ctrl, &g_rtc0_cfg);
    g_rtc0.p_api->calendarTimeSet(&g_rtc0_ctrl, &set_time);
    g_rtc0.p_api->periodicIrqRateSet(&g_rtc0_ctrl, RTC_PERIODIC_IRQ_SELECT_1_SECOND);
    // R_RTC_CalendarAlarmSet(&g_rtc0_ctrl, &set_alarm_time)
    while (1)
    {
        if (rtc_flag)
        {
            g_rtc0.p_api->calendarTimeGet(&g_rtc0_ctrl, &get_time); // 获取 RTC 计数时间
            rtc_flag = 0;
            printf("%d年%d月%d日 %d:%d:%d\n",
                    get_time.tm_year + 1900, get_time.tm_mon +1, get_time.tm_mday,
                    get_time.tm_hour, get_time.tm_min, get_time.tm_sec);
        }
        if (uart_rx_complete_flag)
        {
            char * time;
            uart_rx_complete_flag = 0;
            // 解析设置时间的命令 e.g: time:20250126080910
            // warning: 未添加错误纠正算法，请输入正确的时间，否则工作异常！
            if(strncmp(rx_data, "time:", 5) == 0){
                time = rx_data+5;
                set_time.tm_year = ((time[0]-'0')*1000)+((time[1]-'0')*100)+
                        ((time[2]-'0')*10)+(time[3]-'0')-1900;
                set_time.tm_mon = ((time[4]-'0')*10)+(time[5]-'0') - 1;
                set_time.tm_mday = ((time[6]-'0')*10)+(time[7]-'0');
                set_time.tm_hour = ((time[8]-'0')*10)+(time[9]-'0');
                set_time.tm_min = ((time[10]-'0')*10)+(time[11]-'0');
                set_time.tm_sec = ((time[12]-'0')*10)+(time[13]-'0');
                g_rtc0.p_api->calendarTimeSet(&g_rtc0_ctrl, &set_time);
           }
        }
    }
#if BSP_TZ_SECURE_BUILD
    /* Enter non-secure code */
    R_BSP_NonSecureEnter();
#endif
}

/*******************************************************************************************************************/ /**
                                                                                                                       * This function is called at various points during the startup process.  This implementation uses the event that is
                                                                                                                       * called right before main() to set up the pins.
                                                                                                                       *
                                                                                                                       * @param[in]  event    Where at in the start up process the code is currently at
                                                                                                                       **********************************************************************************************************************/
void R_BSP_WarmStart(bsp_warm_start_event_t event)
{
    if (BSP_WARM_START_RESET == event)
    {
#if BSP_FEATURE_FLASH_LP_VERSION != 0

        /* Enable reading from data flash. */
        R_FACI_LP->DFLCTL = 1U;

        /* Would normally have to wait tDSTOP(6us) for data flash recovery. Placing the enable here, before clock and
         * C runtime initialization, should negate the need for a delay since the initialization will typically take more than 6us. */
#endif
    }

    if (BSP_WARM_START_POST_C == event)
    {
        /* C runtime environment and system clocks are setup. */

        /* Configure pins. */
        R_IOPORT_Open(&IOPORT_CFG_CTRL, &IOPORT_CFG_NAME);

#if BSP_CFG_SDRAM_ENABLED

        /* Setup SDRAM and initialize it. Must configure pins first. */
        R_BSP_SdramInit(true);
#endif
    }
}

#if BSP_TZ_SECURE_BUILD

FSP_CPP_HEADER
BSP_CMSE_NONSECURE_ENTRY void template_nonsecure_callable();

/* Trustzone Secure Projects require at least one nonsecure callable function in order to build (Remove this if it is not required to build). */
BSP_CMSE_NONSECURE_ENTRY void template_nonsecure_callable()
{
}
FSP_CPP_FOOTER

#endif
