/*
 * debug_bsp_uart.c
 *
 *  Created on: 2025年1月21日
 *      Author: VR小杰
 */

#include "debug_bsp_uart.h"
/* 发送完成标志 */
volatile int uart_send_complete_flag = 0;

/* 调试串口 UART9 初始化 */
void Debug_UART9_Init(void)
{
   fsp_err_t err = FSP_SUCCESS;

   err = R_SCI_UART_Open (&g_uart9_ctrl, &g_uart9_cfg);
   assert(FSP_SUCCESS == err);
}

/* 串口中断回调 */
void debug_uart9_callback (uart_callback_args_t * p_args)
{
   switch (p_args->event)
   {
      case UART_EVENT_RX_CHAR:
      {
            /* 把串口接收到的数据发送回去 */
            R_SCI_UART_Write(&g_uart9_ctrl, (uint8_t *)&(p_args->data), 1);
            break;
      }
      case UART_EVENT_TX_COMPLETE:
      {
            uart_send_complete_flag = 1;
            break;
      }
      default:
            break;
   }
}

/* 重定向 printf 输出 */
#if defined __GNUC__ && !defined __clang__
int _write(int fd, char *pBuffer, int size); //防止编译警告
int _write(int fd, char *pBuffer, int size)
{
   (void)fd;
   R_SCI_UART_Write(&g_uart9_ctrl, (uint8_t *)pBuffer, (uint32_t)size);
   while(uart_send_complete_flag == 0);
   uart_send_complete_flag = 0;

   return size;
}
#else
int fputc(int ch, FILE *f)
{
   (void)f;
   R_SCI_UART_Write(&g_uart9_ctrl, (uint8_t *)&ch, 1);
   while(uart_send_complete_flag == 0);
   uart_send_complete_flag = 0;

   return ch;
}
#endif
