/*
 * Copyright (c) 2020 - 2024 Renesas Electronics Corporation and/or its affiliates
*
* SPDX-License-Identifier: BSD-3-Clause
 *
 * @file     ./out/R7FA2L1AB.h
 * @brief    CMSIS HeaderFile
 * @version  0.50.00
 */

/** @addtogroup Renesas Electronics Corporation
 * @{
 */

/** @addtogroup R7FA2L1AB
 * @{
 */

#ifndef R7FA2L1AB_H
 #define R7FA2L1AB_H

 #ifdef __cplusplus
extern "C" {
 #endif

/** @addtogroup Configuration_of_CMSIS
 * @{
 */

/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M23 Processor and Core Peripherals  =========================== */
 #define __CM23_REV                0x0100U /*!< CM23 Core Revision                                                        */
 #define __NVIC_PRIO_BITS          2       /*!< Number of Bits used for Priority Levels                                   */
 #define __Vendor_SysTickConfig    0       /*!< Set to 1 if different SysTick Config is used                              */
 #define __VTOR_PRESENT            1       /*!< Set to 1 if CPU supports Vector Table Offset Register                     */
 #define __MPU_PRESENT             1       /*!< MPU present                                                               */
 #define __FPU_PRESENT             0       /*!< FPU present                                                               */
 #define __SAUREGION_PRESENT       0       /*!< SAU region present                                                        */

/** @} */ /* End of group Configuration_of_CMSIS */

 #include "core_cm23.h"                    /*!< ARM Cortex-M23 processor and core peripherals                             */
 #include "system.h"                       /*!< R7FA2L1AB System                                                          */

 #ifndef __IM                              /*!< Fallback for older CMSIS versions                                         */
  #define __IM     __I
 #endif
 #ifndef __OM                              /*!< Fallback for older CMSIS versions                                         */
  #define __OM     __O
 #endif
 #ifndef __IOM                             /*!< Fallback for older CMSIS versions                                         */
  #define __IOM    __IO
 #endif

/* ========================================  Start of section using anonymous unions  ======================================== */
 #if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
 #elif defined(__ICCARM__)
  #pragma language=extended
 #elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
 #elif defined(__GNUC__)

/* anonymous unions are enabled by default */
 #elif defined(__TMS470__)

/* anonymous unions are enabled by default */
 #elif defined(__TASKING__)
  #pragma warning 586
 #elif defined(__CSMC__)

/* anonymous unions are enabled by default */
 #else
  #warning Not supported compiler type
 #endif

/* =========================================================================================================================== */
/* ================                              Device Specific Cluster Section                              ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_clusters
 * @{
 */

/**
 * @brief R_BUS_CSa [CSa] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t MOD;            /*!< (@ 0x00000002) Mode Register                                              */

        struct
        {
            __IOM uint16_t WRMOD : 1;  /*!< [0..0] Write Access Mode Select                                           */
            uint16_t             : 2;
            __IOM uint16_t EWENB : 1;  /*!< [3..3] External Wait Enable                                               */
            uint16_t             : 4;
            __IOM uint16_t PRENB : 1;  /*!< [8..8] Page Read Access Enable                                            */
            __IOM uint16_t PWENB : 1;  /*!< [9..9] Page Write Access Enable                                           */
            uint16_t             : 5;
            __IOM uint16_t PRMOD : 1;  /*!< [15..15] Page Read Access Mode Select                                     */
        } MOD_b;
    };

    union
    {
        __IOM uint32_t WCR1;             /*!< (@ 0x00000004) Wait Control Register 1                                    */

        struct
        {
            __IOM uint32_t CSPWWAIT : 3; /*!< [2..0] Page Write Cycle Wait Select                                       */
            uint32_t                : 5;
            __IOM uint32_t CSPRWAIT : 3; /*!< [10..8] Page Read Cycle Wait Select                                       */
            uint32_t                : 5;
            __IOM uint32_t CSWWAIT  : 5; /*!< [20..16] Normal Write Cycle Wait Select                                   */
            uint32_t                : 3;
            __IOM uint32_t CSRWAIT  : 5; /*!< [28..24] Normal Read Cycle Wait Select                                    */
            uint32_t                : 3;
        } WCR1_b;
    };

    union
    {
        __IOM uint32_t WCR2;           /*!< (@ 0x00000008) Wait Control Register 2                                    */

        struct
        {
            __IOM uint32_t CSROFF : 3; /*!< [2..0] Read-Access CS Extension Cycle Select                              */
            uint32_t              : 1;
            __IOM uint32_t CSWOFF : 3; /*!< [6..4] Write-Access CS Extension Cycle Select                             */
            uint32_t              : 1;
            __IOM uint32_t WDOFF  : 3; /*!< [10..8] Write Data Output Extension Cycle Select                          */
            uint32_t              : 1;
            __IOM uint32_t AWAIT  : 2; /*!< [13..12] CS Assert Wait Select                                            */
            uint32_t              : 2;
            __IOM uint32_t RDON   : 3; /*!< [18..16] RD Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WRON   : 3; /*!< [22..20] WR Assert Wait Select                                            */
            uint32_t              : 1;
            __IOM uint32_t WDON   : 3; /*!< [26..24] Write Data Output Wait Select                                    */
            uint32_t              : 1;
            __IOM uint32_t CSON   : 3; /*!< [30..28] CS Assert Wait Select                                            */
            uint32_t              : 1;
        } WCR2_b;
    };
    __IM uint32_t RESERVED1;
} R_BUS_CSa_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_CSb [CSb] (CS Registers)
 */
typedef struct
{
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CR;             /*!< (@ 0x00000002) Control Register                                           */

        struct
        {
            __IOM uint16_t EXENB : 1;  /*!< [0..0] Operation Enable                                                   */
            uint16_t             : 3;
            __IOM uint16_t BSIZE : 2;  /*!< [5..4] External Bus Width Select                                          */
            uint16_t             : 2;
            __IOM uint16_t EMODE : 1;  /*!< [8..8] Endian Mode                                                        */
            uint16_t             : 3;
            __IOM uint16_t MPXEN : 1;  /*!< [12..12] Address/Data Multiplexed I/O Interface Select                    */
            uint16_t             : 3;
        } CR_b;
    };
    __IM uint16_t RESERVED1[3];

    union
    {
        __IOM uint16_t REC;            /*!< (@ 0x0000000A) Recovery Cycle Register                                    */

        struct
        {
            __IOM uint16_t RRCV : 4;   /*!< [3..0] Read Recovery                                                      */
            uint16_t            : 4;
            __IOM uint16_t WRCV : 4;   /*!< [11..8] Write Recovery                                                    */
            uint16_t            : 4;
        } REC_b;
    };
    __IM uint16_t RESERVED2[2];
} R_BUS_CSb_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_SDRAM [SDRAM] (SDRAM Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t SDCCR;           /*!< (@ 0x00000000) SDC Control Register                                       */

        struct
        {
            __IOM uint8_t EXENB : 1;   /*!< [0..0] Operation Enable                                                   */
            uint8_t             : 3;
            __IOM uint8_t BSIZE : 2;   /*!< [5..4] SDRAM Bus Width Select                                             */
            uint8_t             : 2;
        } SDCCR_b;
    };

    union
    {
        __IOM uint8_t SDCMOD;          /*!< (@ 0x00000001) SDC Mode Register                                          */

        struct
        {
            __IOM uint8_t EMODE : 1;   /*!< [0..0] Endian Mode                                                        */
            uint8_t             : 7;
        } SDCMOD_b;
    };

    union
    {
        __IOM uint8_t SDAMOD;          /*!< (@ 0x00000002) SDRAM Access Mode Register                                 */

        struct
        {
            __IOM uint8_t BE : 1;      /*!< [0..0] Continuous Access Enable                                           */
            uint8_t          : 7;
        } SDAMOD_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint32_t RESERVED1[3];

    union
    {
        __IOM uint8_t SDSELF;          /*!< (@ 0x00000010) SDRAM Self-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t SFEN : 1;    /*!< [0..0] SDRAM Self-Refresh Enable                                          */
            uint8_t            : 7;
        } SDSELF_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t SDRFCR;         /*!< (@ 0x00000014) SDRAM Refresh Control Register                             */

        struct
        {
            __IOM uint16_t RFC  : 12;  /*!< [11..0] Auto-Refresh Request Interval Setting                             */
            __IOM uint16_t REFW : 4;   /*!< [15..12] Auto-Refresh Cycle/ Self-Refresh Clearing Cycle Count
                                        *   Setting. ( REFW+1 Cycles )                                                */
        } SDRFCR_b;
    };

    union
    {
        __IOM uint8_t SDRFEN;          /*!< (@ 0x00000016) SDRAM Auto-Refresh Control Register                        */

        struct
        {
            __IOM uint8_t RFEN : 1;    /*!< [0..0] Auto-Refresh Operation Enable                                      */
            uint8_t            : 7;
        } SDRFEN_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint32_t RESERVED5[2];

    union
    {
        __IOM uint8_t SDICR;           /*!< (@ 0x00000020) SDRAM Initialization Sequence Control Register             */

        struct
        {
            __IOM uint8_t INIRQ : 1;   /*!< [0..0] Initialization Sequence Start                                      */
            uint8_t             : 7;
        } SDICR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t SDIR;           /*!< (@ 0x00000024) SDRAM Initialization Register                              */

        struct
        {
            __IOM uint16_t ARFI : 4;   /*!< [3..0] Initialization Auto-Refresh Interval ( PRF+3 cycles )              */
            __IOM uint16_t ARFC : 4;   /*!< [7..4] Initialization Auto-Refresh Count                                  */
            __IOM uint16_t PRC  : 3;   /*!< [10..8] Initialization Precharge Cycle Count ( PRF+3 cycles
                                        *   )                                                                         */
            uint16_t : 5;
        } SDIR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[6];

    union
    {
        __IOM uint8_t SDADR;           /*!< (@ 0x00000040) SDRAM Address Register                                     */

        struct
        {
            __IOM uint8_t MXC : 2;     /*!< [1..0] Address Multiplex Select                                           */
            uint8_t           : 6;
        } SDADR_b;
    };
    __IM uint8_t  RESERVED10;
    __IM uint16_t RESERVED11;

    union
    {
        __IOM uint32_t SDTR;           /*!< (@ 0x00000044) SDRAM Timing Register                                      */

        struct
        {
            __IOM uint32_t CL  : 3;    /*!< [2..0] SDRAMC Column Latency                                              */
            uint32_t           : 5;
            __IOM uint32_t WR  : 1;    /*!< [8..8] Write Recovery Interval                                            */
            __IOM uint32_t RP  : 3;    /*!< [11..9] Row Precharge Interval ( RP+1 cycles )                            */
            __IOM uint32_t RCD : 2;    /*!< [13..12] Row Column Latency ( RCD+1 cycles )                              */
            uint32_t           : 2;
            __IOM uint32_t RAS : 3;    /*!< [18..16] Row Active Interval                                              */
            uint32_t           : 13;
        } SDTR_b;
    };

    union
    {
        __IOM uint16_t SDMOD;          /*!< (@ 0x00000048) SDRAM Mode Register                                        */

        struct
        {
            __IOM uint16_t MR : 15;    /*!< [14..0] Mode Register Setting                                             */
            uint16_t          : 1;
        } SDMOD_b;
    };
    __IM uint16_t RESERVED12;
    __IM uint32_t RESERVED13;

    union
    {
        __IM uint8_t SDSR;             /*!< (@ 0x00000050) SDRAM Status Register                                      */

        struct
        {
            __IM uint8_t MRSST : 1;    /*!< [0..0] Mode Register Setting Status                                       */
            uint8_t            : 2;
            __IM uint8_t INIST : 1;    /*!< [3..3] Initialization Status                                              */
            __IM uint8_t SRFST : 1;    /*!< [4..4] Self-Refresh Transition/Recovery Status                            */
            uint8_t            : 3;
        } SDSR_b;
    };
    __IM uint8_t  RESERVED14;
    __IM uint16_t RESERVED15;
} R_BUS_SDRAM_Type;                    /*!< Size = 84 (0x54)                                                          */

/**
 * @brief R_BUS_BUSERRa [BUSERRa] (Bus Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ADD;             /*!< (@ 0x00000000) Bus Error Address Register                                 */

        struct
        {
            __IM uint32_t BERAD : 32;  /*!< [31..0] Bus Error Address                                                 */
        } ADD_b;
    };

    union
    {
        union
        {
            __IM uint8_t STAT;            /*!< (@ 0x00000004) Bus Error Status Register                                  */

            struct
            {
                __IM uint8_t ACCSTAT : 1; /*!< [0..0] Error access status                                                */
                uint8_t              : 6;
                __IM uint8_t ERRSTAT : 1; /*!< [7..7] Bus Error Status                                                   */
            } STAT_b;
        };

        union
        {
            __IM uint8_t RW;             /*!< (@ 0x00000004) Bus Error Read Write                                       */

            struct
            {
                __IM uint8_t RWSTAT : 1; /*!< [0..0] Error access Read/Write Status                                     */
                uint8_t             : 7;
            } RW_b;
        };
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_BUSERRa_Type;                  /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_BTZFERR [BTZFERR] (Bus TZF Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t ADD;               /*!< (@ 0x00000000) BUS TZF Error Address                                      */

        struct
        {
            __IM uint32_t BTZFERAD : 32; /*!< [31..0] Bus TrustZone Filter Error Address                                */
        } ADD_b;
    };

    union
    {
        __IM uint8_t RW;               /*!< (@ 0x00000004) BUS TZF Error Read Write                                   */

        struct
        {
            __IM uint8_t TRWSTAT : 1;  /*!< [0..0] TrustZone filter error access Read/Write Status                    */
            uint8_t              : 7;
        } RW_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_BTZFERR_Type;                  /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_BUSERRb [BUSERRb] (Bus Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint8_t STAT;              /*!< (@ 0x00000000) Bus Error Status Register                                  */

        struct
        {
            __IM uint8_t SLERRSTAT : 1; /*!< [0..0] Slave Bus Error Status.                                            */
            __IM uint8_t STERRSTAT : 1; /*!< [1..1] Slave TrustZone filter Error Status.                               */
            uint8_t                : 1;
            __IM uint8_t MMERRSTAT : 1; /*!< [3..3] Master MPU Error Status.                                           */
            __IM uint8_t ILERRSTAT : 1; /*!< [4..4] Illegal Address Access Error Status.                               */
            __IM uint8_t MSERRSTAT : 1; /*!< [5..5] Master Security Attribution Unit Error Status.                     */
            uint8_t                : 2;
        } STAT_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2;

    union
    {
        union
        {
            __IOM uint32_t IRQEN;      /*!< (@ 0x00000008) BUS Error IRQ Enable                                       */

            struct
            {
                __IOM uint32_t EN : 1; /*!< [0..0] Bus interrupt request permission setting to ICU when
                                        *   a bus error occurs                                                        */
                uint32_t : 31;
            } IRQEN_b;
        };

        union
        {
            __IOM uint8_t CLR;              /*!< (@ 0x00000008) Bus Error Clear Register                                   */

            struct
            {
                __IOM uint8_t SLERRCLR : 1; /*!< [0..0] Slave Bus Error Clear.                                             */
                __IOM uint8_t STERRCLR : 1; /*!< [1..1] Slave TrustZone filter Error Status.                               */
                uint8_t                : 1;
                __IOM uint8_t MMERRCLR : 1; /*!< [3..3] Master MPU Error Clear.                                            */
                __IOM uint8_t ILERRCLR : 1; /*!< [4..4] Illegal Address Access Error Clear.                                */
                __IOM uint8_t MSERRCLR : 1; /*!< [5..5] Master Security Attribution Unit Error Clear.                      */
                uint8_t                : 2;
            } CLR_b;
        };
    };
    __IM uint32_t RESERVED3;
} R_BUS_BUSERRb_Type;                  /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_DMACDTCERR [DMACDTCERR] (DMAC/DTC Error Registers)
 */
typedef struct
{
    __IM uint8_t RESERVED[36];

    union
    {
        __IM uint8_t STAT;              /*!< (@ 0x00000024) DMAC/DTC Error Status Register                             */

        struct
        {
            __IM uint8_t MTERRSTAT : 1; /*!< [0..0] Master TrustZone Filter Error Status                               */
            uint8_t                : 7;
        } STAT_b;
    };
    __IM uint8_t RESERVED1[7];

    union
    {
        __IOM uint8_t CLR;              /*!< (@ 0x0000002C) DMAC/DTC Error Clear Register                              */

        struct
        {
            __IOM uint8_t MTERRCLR : 1; /*!< [0..0] Master TrustZone filter Error Clear                                */
            uint8_t                : 7;
        } CLR_b;
    };
} R_BUS_DMACDTCERR_Type;                /*!< Size = 45 (0x2d)                                                          */

/**
 * @brief R_BUS_BUSSABT0 [BUSSABT0] (Bus Slave Arbitration Control 0 Registers)
 */
typedef struct
{
    __IM uint32_t RESERVED[2];

    union
    {
        __IOM uint32_t MRE0BI;         /*!< (@ 0x00000008) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } MRE0BI_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t FLBI;           /*!< (@ 0x00000010) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } FLBI_b;
    };
    __IM uint32_t RESERVED2[3];

    union
    {
        __IOM uint32_t S0BI;           /*!< (@ 0x00000020) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } S0BI_b;
    };
    __IM uint32_t RESERVED3;

    union
    {
        __IOM uint32_t S1BI;           /*!< (@ 0x00000028) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } S1BI_b;
    };
    __IM uint32_t RESERVED4;

    union
    {
        __IOM uint32_t S2BI;           /*!< (@ 0x00000030) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } S2BI_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint32_t S3BI;           /*!< (@ 0x00000038) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } S3BI_b;
    };
    __IM uint32_t RESERVED6[3];

    union
    {
        __IOM uint32_t STBYSBI;        /*!< (@ 0x00000048) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } STBYSBI_b;
    };
    __IM uint32_t RESERVED7;

    union
    {
        union
        {
            __IOM uint32_t ECBI;         /*!< (@ 0x00000050) Bus Slave Arbitration Control Register                     */

            struct
            {
                __IOM uint32_t ARBS : 1; /*!< [0..0] Arbitration Select for slave.                                      */
                uint32_t            : 31;
            } ECBI_b;
        };

        union
        {
            __IOM uint32_t SPI0BI;       /*!< (@ 0x00000050) Bus Slave Arbitration Control Register                     */

            struct
            {
                __IOM uint32_t ARBS : 1; /*!< [0..0] Arbitration Select for slave.                                      */
                uint32_t            : 31;
            } SPI0BI_b;
        };
    };
    __IM uint32_t RESERVED8;

    union
    {
        union
        {
            __IOM uint32_t EOBI;         /*!< (@ 0x00000058) Bus Slave Arbitration Control Register                     */

            struct
            {
                __IOM uint32_t ARBS : 1; /*!< [0..0] Arbitration Select for slave.                                      */
                uint32_t            : 31;
            } EOBI_b;
        };

        union
        {
            __IOM uint32_t SPI1BI;       /*!< (@ 0x00000058) Bus Slave Arbitration Control Register                     */

            struct
            {
                __IOM uint32_t ARBS : 1; /*!< [0..0] Arbitration Select for slave.                                      */
                uint32_t            : 31;
            } SPI1BI_b;
        };
    };
    __IM uint32_t RESERVED9;

    union
    {
        __IOM uint32_t PBBI;           /*!< (@ 0x00000060) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } PBBI_b;
    };
    __IM uint32_t RESERVED10;

    union
    {
        union
        {
            __IOM uint32_t PABI;         /*!< (@ 0x00000068) Bus Slave Arbitration Control Register                     */

            struct
            {
                __IOM uint32_t ARBS : 1; /*!< [0..0] Arbitration Select for slave.                                      */
                uint32_t            : 31;
            } PABI_b;
        };

        union
        {
            __IOM uint32_t CPU0SAHBI;    /*!< (@ 0x00000068) Bus Slave Arbitration Control Register                     */

            struct
            {
                __IOM uint32_t ARBS : 1; /*!< [0..0] Arbitration Select for slave.                                      */
                uint32_t            : 31;
            } CPU0SAHBI_b;
        };
    };
    __IM uint32_t RESERVED11;

    union
    {
        __IOM uint32_t PIBI;           /*!< (@ 0x00000070) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } PIBI_b;
    };
    __IM uint32_t RESERVED12;

    union
    {
        __IOM uint32_t PSBI;           /*!< (@ 0x00000078) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 1;   /*!< [0..0] Arbitration Select for slave.                                      */
            uint32_t            : 31;
        } PSBI_b;
    };
} R_BUS_BUSSABT0_Type;                 /*!< Size = 124 (0x7c)                                                         */

/**
 * @brief R_BUS_BUSSABT1 [BUSSABT1] (Bus Slave Arbitration Control 1 Registers)
 */
typedef struct
{
    union
    {
        union
        {
            __IOM uint32_t FHBI;         /*!< (@ 0x00000000) Bus Slave Arbitration Control Register                     */

            struct
            {
                __IOM uint32_t ARBS : 2; /*!< [1..0] Arbitration Select for slave.                                      */
                uint32_t            : 30;
            } FHBI_b;
        };

        union
        {
            __IOM uint32_t MRC0BI;       /*!< (@ 0x00000000) Bus Slave Arbitration Control Register                     */

            struct
            {
                __IOM uint32_t ARBS : 2; /*!< [1..0] Arbitration Select for slave.                                      */
                uint32_t            : 30;
            } MRC0BI_b;
        };
    };
    __IM uint32_t RESERVED[5];

    union
    {
        __IOM uint32_t S0BI;           /*!< (@ 0x00000018) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 2;   /*!< [1..0] Arbitration Select for slave.                                      */
            uint32_t            : 30;
        } S0BI_b;
    };
    __IM uint32_t RESERVED1;

    union
    {
        __IOM uint32_t S1BI;           /*!< (@ 0x00000020) Bus Slave Arbitration Control Register                     */

        struct
        {
            __IOM uint32_t ARBS : 2;   /*!< [1..0] Arbitration Select for slave.                                      */
            uint32_t            : 30;
        } S1BI_b;
    };
} R_BUS_BUSSABT1_Type;                 /*!< Size = 36 (0x24)                                                          */

/**
 * @brief R_BUS_BMSAERR [BMSAERR] (Bus Master Security Attribution Unit Error Address and Read/Write Status registers.)
 */
typedef struct
{
    union
    {
        __IM uint32_t ADD;             /*!< (@ 0x00000000) Bus Master Security Attribution Unit Error Address.        */

        struct
        {
            __IM uint32_t MSERAD : 32; /*!< [31..0] Bus Master Security Attribution Unit Error Address.               */
        } ADD_b;
    };

    union
    {
        __IM uint8_t RW;                /*!< (@ 0x00000004) BUS Master Security Attribution Unit Error Read
                                         *                  Write.                                                     */

        struct
        {
            __IM uint8_t MSARWSTAT : 1; /*!< [0..0] Master Security Attribution Unit error access Read/Write
                                         *   Status.                                                                   */
            uint8_t : 7;
        } RW_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[2];
} R_BUS_BMSAERR_Type;                  /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_BUS_OAD [OAD] (Bus Operation After Detection Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t BUSOAD;           /*!< (@ 0x00000000) Bus Operation After Detection Register                     */

        struct
        {
            __IOM uint16_t ILERROAD : 1; /*!< [0..0] Illegal address access error operation after detection.            */
            __IOM uint16_t SLERROAD : 1; /*!< [1..1] Slave bus error operation after detection.                         */
            __IOM uint16_t BWERROAD : 1; /*!< [2..2] Bufferable write error operation after detection.                  */
            uint16_t                : 13;
        } BUSOAD_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t BUSOADPT;        /*!< (@ 0x00000004) BUS Operation After Detection Protect Register.            */

        struct
        {
            __IOM uint16_t PROTECT : 1; /*!< [0..0] Protection of BUSOAD register.                                     */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8; /*!< [15..8] Key code                                                          */
        } BUSOADPT_b;
    };
    __IM uint16_t RESERVED1[5];

    union
    {
        __IOM uint16_t MSAOAD;         /*!< (@ 0x00000010) Master Security Attribution Operation After Detection
                                        *                  Register.                                                  */

        struct
        {
            __IOM uint16_t OAD : 1;    /*!< [0..0] Master Security Attribution operation after detection.             */
            uint16_t           : 7;
            __OM uint16_t KEY  : 8;    /*!< [15..8] Key Code.                                                         */
        } MSAOAD_b;
    };
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t MSAPT;           /*!< (@ 0x00000014) Master Security Attribution Protect Register.              */

        struct
        {
            __IOM uint16_t PROTECT : 1; /*!< [0..0] Protection of MSAOAD register.                                     */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8; /*!< [15..8] Key code                                                          */
        } MSAPT_b;
    };
} R_BUS_OAD_Type;                       /*!< Size = 22 (0x16)                                                          */

/**
 * @brief R_BUS_MBWERR [MBWERR] (Master Bufferable Write Error Registers)
 */
typedef struct
{
    union
    {
        __IM uint32_t STAT;            /*!< (@ 0x00000000) Bufferable Write Error Status Register                     */

        struct
        {
            __IM uint32_t BWERR0  : 1; /*!< [0..0] Bufferable Write Error in 0.                                       */
            __IM uint32_t BWERR1  : 1; /*!< [1..1] Bufferable Write Error in 1.                                       */
            __IM uint32_t BWERR2  : 1; /*!< [2..2] Bufferable Write Error in 2.                                       */
            __IM uint32_t BWERR3  : 1; /*!< [3..3] Bufferable Write Error in 3.                                       */
            __IM uint32_t BWERR4  : 1; /*!< [4..4] Bufferable Write Error in 4.                                       */
            __IM uint32_t BWERR5  : 1; /*!< [5..5] Bufferable Write Error in 5.                                       */
            __IM uint32_t BWERR6  : 1; /*!< [6..6] Bufferable Write Error in 6.                                       */
            __IM uint32_t BWERR7  : 1; /*!< [7..7] Bufferable Write Error in 7.                                       */
            __IM uint32_t BWERR8  : 1; /*!< [8..8] Bufferable Write Error in 8.                                       */
            __IM uint32_t BWERR9  : 1; /*!< [9..9] Bufferable Write Error in 9.                                       */
            __IM uint32_t BWERR10 : 1; /*!< [10..10] Bufferable Write Error in 10.                                    */
            __IM uint32_t BWERR11 : 1; /*!< [11..11] Bufferable Write Error in 11.                                    */
            __IM uint32_t BWERR12 : 1; /*!< [12..12] Bufferable Write Error in 12.                                    */
            __IM uint32_t BWERR13 : 1; /*!< [13..13] Bufferable Write Error in 13.                                    */
            __IM uint32_t BWERR14 : 1; /*!< [14..14] Bufferable Write Error in 14.                                    */
            __IM uint32_t BWERR15 : 1; /*!< [15..15] Bufferable Write Error in 15.                                    */
            __IM uint32_t BWERR16 : 1; /*!< [16..16] Bufferable Write Error in 16.                                    */
            __IM uint32_t BWERR17 : 1; /*!< [17..17] Bufferable Write Error in 17.                                    */
            __IM uint32_t BWERR18 : 1; /*!< [18..18] Bufferable Write Error in 18.                                    */
            __IM uint32_t BWERR19 : 1; /*!< [19..19] Bufferable Write Error in 19.                                    */
            __IM uint32_t BWERR20 : 1; /*!< [20..20] Bufferable Write Error in 20.                                    */
            __IM uint32_t BWERR21 : 1; /*!< [21..21] Bufferable Write Error in 21.                                    */
            __IM uint32_t BWERR22 : 1; /*!< [22..22] Bufferable Write Error in 22.                                    */
            __IM uint32_t BWERR23 : 1; /*!< [23..23] Bufferable Write Error in 23.                                    */
            __IM uint32_t BWERR24 : 1; /*!< [24..24] Bufferable Write Error in 24.                                    */
            __IM uint32_t BWERR25 : 1; /*!< [25..25] Bufferable Write Error in 25.                                    */
            __IM uint32_t BWERR26 : 1; /*!< [26..26] Bufferable Write Error in 26.                                    */
            __IM uint32_t BWERR27 : 1; /*!< [27..27] Bufferable Write Error in 27.                                    */
            __IM uint32_t BWERR28 : 1; /*!< [28..28] Bufferable Write Error in 28.                                    */
            __IM uint32_t BWERR29 : 1; /*!< [29..29] Bufferable Write Error in 29.                                    */
            __IM uint32_t BWERR30 : 1; /*!< [30..30] Bufferable Write Error in 30.                                    */
            __IM uint32_t BWERR31 : 1; /*!< [31..31] Bufferable Write Error in 31.                                    */
        } STAT_b;
    };
    __IM uint32_t RESERVED;

    union
    {
        __IOM uint32_t CLR;             /*!< (@ 0x00000008) Bufferable Write Error Clear Register.                     */

        struct
        {
            __IOM uint32_t BWERR0  : 1; /*!< [0..0] Bufferable Write Error Clear for 0.                                */
            __IOM uint32_t BWERR1  : 1; /*!< [1..1] Bufferable Write Error Clear for 1.                                */
            __IOM uint32_t BWERR2  : 1; /*!< [2..2] Bufferable Write Error Clear for 2.                                */
            __IOM uint32_t BWERR3  : 1; /*!< [3..3] Bufferable Write Error Clear for 3.                                */
            __IOM uint32_t BWERR4  : 1; /*!< [4..4] Bufferable Write Error Clear for 4.                                */
            __IOM uint32_t BWERR5  : 1; /*!< [5..5] Bufferable Write Error Clear for 5.                                */
            __IOM uint32_t BWERR6  : 1; /*!< [6..6] Bufferable Write Error Clear for 6.                                */
            __IOM uint32_t BWERR7  : 1; /*!< [7..7] Bufferable Write Error Clear for 7.                                */
            __IOM uint32_t BWERR8  : 1; /*!< [8..8] Bufferable Write Error Clear for 8.                                */
            __IOM uint32_t BWERR9  : 1; /*!< [9..9] Bufferable Write Error Clear for 9.                                */
            __IOM uint32_t BWERR10 : 1; /*!< [10..10] Bufferable Write Error Clear for 10.                             */
            __IOM uint32_t BWERR11 : 1; /*!< [11..11] Bufferable Write Error Clear for 11.                             */
            __IOM uint32_t BWERR12 : 1; /*!< [12..12] Bufferable Write Error Clear for 12.                             */
            __IOM uint32_t BWERR13 : 1; /*!< [13..13] Bufferable Write Error Clear for 13.                             */
            __IOM uint32_t BWERR14 : 1; /*!< [14..14] Bufferable Write Error Clear for 14.                             */
            __IOM uint32_t BWERR15 : 1; /*!< [15..15] Bufferable Write Error Clear for 15.                             */
            __IOM uint32_t BWERR16 : 1; /*!< [16..16] Bufferable Write Error Clear for 16.                             */
            __IOM uint32_t BWERR17 : 1; /*!< [17..17] Bufferable Write Error Clear for 17.                             */
            __IOM uint32_t BWERR18 : 1; /*!< [18..18] Bufferable Write Error Clear for 18.                             */
            __IOM uint32_t BWERR19 : 1; /*!< [19..19] Bufferable Write Error Clear for 19.                             */
            __IOM uint32_t BWERR20 : 1; /*!< [20..20] Bufferable Write Error Clear for 20.                             */
            __IOM uint32_t BWERR21 : 1; /*!< [21..21] Bufferable Write Error Clear for 21.                             */
            __IOM uint32_t BWERR22 : 1; /*!< [22..22] Bufferable Write Error Clear for 22.                             */
            __IOM uint32_t BWERR23 : 1; /*!< [23..23] Bufferable Write Error Clear for 23.                             */
            __IOM uint32_t BWERR24 : 1; /*!< [24..24] Bufferable Write Error Clear for 24.                             */
            __IOM uint32_t BWERR25 : 1; /*!< [25..25] Bufferable Write Error Clear for 25.                             */
            __IOM uint32_t BWERR26 : 1; /*!< [26..26] Bufferable Write Error Clear for 26.                             */
            __IOM uint32_t BWERR27 : 1; /*!< [27..27] Bufferable Write Error Clear for 27.                             */
            __IOM uint32_t BWERR28 : 1; /*!< [28..28] Bufferable Write Error Clear for 28.                             */
            __IOM uint32_t BWERR29 : 1; /*!< [29..29] Bufferable Write Error Clear for 29.                             */
            __IOM uint32_t BWERR30 : 1; /*!< [30..30] Bufferable Write Error Clear for 30.                             */
            __IOM uint32_t BWERR31 : 1; /*!< [31..31] Bufferable Write Error Clear for 31.                             */
        } CLR_b;
    };
} R_BUS_MBWERR_Type;                    /*!< Size = 12 (0xc)                                                           */

/**
 * @brief R_BUS_BUSM [BUSM] (Master Bus Control Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Master Bus Control Register                                */

        struct
        {
            uint16_t             : 15;
            __IOM uint16_t IERES : 1;  /*!< [15..15] Ignore Error Responses                                           */
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSM_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_BUS_BUSS [BUSS] (Slave Bus Control Register Array)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CNT;            /*!< (@ 0x00000000) Slave Bus Control Register                                 */

        struct
        {
            __IOM uint16_t ARBS   : 2; /*!< [1..0] Arbitration Select                                                 */
            uint16_t              : 2;
            __IOM uint16_t ARBMET : 2; /*!< [5..4] Arbitration Method                                                 */
            uint16_t              : 10;
        } CNT_b;
    };
    __IM uint16_t RESERVED;
} R_BUS_BUSS_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_CAN0_MB [MB] (Mailbox)
 */
typedef struct
{
    union
    {
        __IOM uint32_t ID;             /*!< (@ 0x00000000) Mailbox ID Register                                        */

        struct
        {
            __IOM uint32_t EID : 18;   /*!< [17..0] Extended ID                                                       */
            __IOM uint32_t SID : 11;   /*!< [28..18] Standard ID                                                      */
            uint32_t           : 1;
            __IOM uint32_t RTR : 1;    /*!< [30..30] Remote Transmission Request                                      */
            __IOM uint32_t IDE : 1;    /*!< [31..31] ID Extension                                                     */
        } ID_b;
    };

    union
    {
        __IOM uint16_t DL;             /*!< (@ 0x00000004) Mailbox DLC Register                                       */

        struct
        {
            __IOM uint16_t DLC : 4;    /*!< [3..0] Data Length Code                                                   */
            uint16_t           : 12;
        } DL_b;
    };

    union
    {
        __IOM uint8_t D[8];            /*!< (@ 0x00000006) Mailbox Data Register                                      */

        struct
        {
            __IOM uint8_t DATA : 8;    /*!< [7..0] DATA0 to DATA7 store the transmitted or received CAN
                                        *   message data. Transmission or reception starts from DATA0.
                                        *   The bit order on the CAN bus is MSB-first, and transmission
                                        *   or reception starts from bit 7                                            */
        } D_b[8];
    };

    union
    {
        __IOM uint16_t TS;             /*!< (@ 0x0000000E) Mailbox Timestamp Register                                 */

        struct
        {
            __IOM uint16_t TSL : 8;    /*!< [7..0] Time Stamp Higher ByteBits TSL[7:0] store the counter
                                        *   value of the time stamp when received messages are stored
                                        *   in the mailbox.                                                           */
            __IOM uint16_t TSH : 8;    /*!< [15..8] Time Stamp Lower ByteBits TSH[7:0] store the counter
                                        *   value of the time stamp when received messages are stored
                                        *   in the mailbox.                                                           */
        } TS_b;
    };
} R_CAN0_MB_Type;                      /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_ELC_ELSEGR [ELSEGR] (Event Link Software Event Generation Register)
 */
typedef struct
{
    union
    {
        __IOM uint8_t BY;              /*!< (@ 0x00000000) Event Link Software Event Generation Register              */

        struct
        {
            __OM uint8_t SEG : 1;      /*!< [0..0] Software Event Generation                                          */
            uint8_t          : 5;
            __IOM uint8_t WE : 1;      /*!< [6..6] SEG Bit Write Enable                                               */
            __OM uint8_t  WI : 1;      /*!< [7..7] ELSEGR Register Write Disable                                      */
        } BY_b;
    };
    __IM uint8_t RESERVED;
} R_ELC_ELSEGR_Type;                   /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_ELC_ELSR [ELSR] (Event Link Setting Register [0..22])
 */
typedef struct
{
    union
    {
        __IOM uint16_t HA;             /*!< (@ 0x00000000) Event Link Setting Register                                */

        struct
        {
            __IOM uint16_t ELS : 9;    /*!< [8..0] Event Link Select                                                  */
            uint16_t           : 7;
        } HA_b;
    };
    __IM uint16_t RESERVED;
} R_ELC_ELSR_Type;                     /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_IIC0_SAR [SAR] (Slave Address Registers)
 */
typedef struct
{
    union
    {
        __IOM uint8_t L;               /*!< (@ 0x00000000) Slave Address Register L                                   */

        struct
        {
            __IOM uint8_t SVA : 8;     /*!< [7..0] A slave address is set.7-Bit Address = SVA[7:1] 10-Bit
                                        *   Address = { SVA9,SVA8,SVA[7:0] }                                          */
        } L_b;
    };

    union
    {
        __IOM uint8_t U;               /*!< (@ 0x00000001) Slave Address Register U                                   */

        struct
        {
            __IOM uint8_t FS   : 1;    /*!< [0..0] 7-Bit/10-Bit Address Format Selection                              */
            __IOM uint8_t SVA8 : 1;    /*!< [1..1] 10-Bit Address(bit8)                                               */
            __IOM uint8_t SVA9 : 1;    /*!< [2..2] 10-Bit Address(bit9)                                               */
            uint8_t            : 5;
        } U_b;
    };
} R_IIC0_SAR_Type;                     /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_MPU_MMPU_MMPU_REGION [REGION] (Address Region registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t AC;             /*!< (@ 0x00000000) Access Control Register                                    */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Region enable                                                      */
            __IOM uint16_t RP     : 1; /*!< [1..1] Read protection                                                    */
            __IOM uint16_t WP     : 1; /*!< [2..2] Write protection                                                   */
            uint16_t              : 13;
        } AC_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint32_t S;              /*!< (@ 0x00000004) Start Address Register                                     */

        struct
        {
            __IOM uint32_t MMPUS : 32; /*!< [31..0] Address where the region starts, for use in region determination.
                                        *   NOTE: Some low-order bits are fixed to 0.                                 */
        } S_b;
    };

    union
    {
        __IOM uint32_t E;              /*!< (@ 0x00000008) End Address Register                                       */

        struct
        {
            __IOM uint32_t MMPUE : 32; /*!< [31..0] Region end address registerAddress where the region
                                        *   end, for use in region determination. NOTE: Some low-order
                                        *   bits are fixed to 1.                                                      */
        } E_b;
    };
    __IM uint32_t RESERVED1;
} R_MPU_MMPU_MMPU_REGION_Type;         /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_MPU_MMPU_MMPU [MMPU] (Bus Master MPU Registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000000) Bus Master MPU Control Register                            */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t OAD    : 1; /*!< [1..1] Operation after detection                                          */
            uint16_t              : 6;
            __OM uint16_t KEY     : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } CTL_b;
    };
    __IM uint16_t RESERVED;
    __IM uint32_t RESERVED1[63];
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t PT;                        /*!< (@ 0x00000102) Protection of Register                                     */

        struct
        {
            __IOM uint16_t PROTECT : 1;           /*!< [0..0] Protection of region register                                      */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8;           /*!< [15..8] Write Keyword The data written to these bits are not
                                                   *   stored.                                                                   */
        } PT_b;
    };
    __IM uint32_t RESERVED3[63];
    __IOM R_MPU_MMPU_MMPU_REGION_Type REGION[32]; /*!< (@ 0x00000200) Address Region registers                                   */
} R_MPU_MMPU_MMPU_Type;                           /*!< Size = 1024 (0x400)                                                       */

/**
 * @brief R_MPU_SMPU_SMPU [SMPU] (Access Control Structure for MBIU)
 */
typedef struct
{
    union
    {
        __IOM uint16_t R;              /*!< (@ 0x00000000) Access Control Register for MBIU                           */

        struct
        {
            uint16_t              : 2;
            __IOM uint16_t RPGRPA : 1;   /*!< [2..2] Master Group A Read protection                                     */
            __IOM uint16_t WPGRPA : 1;   /*!< [3..3] Master Group A Write protection                                    */
            __IOM uint16_t RPGRPB : 1;   /*!< [4..4] Master Group B Read protection                                     */
            __IOM uint16_t WPGRPB : 1;   /*!< [5..5] Master Group B Write protection                                    */
            __IOM uint16_t RPGRPC : 1;   /*!< [6..6] Master Group C Read protection                                     */
            __IOM uint16_t WPGRPC : 1;   /*!< [7..7] Master Group C Write protection                                    */
            uint16_t              : 4;
            __IOM uint16_t RPFLI  : 1;   /*!< [12..12] Code Flash Memory Read Protection                                */
            __IOM uint16_t WPFLI  : 1;   /*!< [13..13] Code Flash Memory Write Protection (Note: This bit
                                          *   is read as 1. The write value should be 1.)                               */
            __IOM uint16_t RPSRAMHS : 1; /*!< [14..14] SRAMHS Read Protection                                           */
            __IOM uint16_t WPSRAMHS : 1; /*!< [15..15] SRAMHS Write Protection                                          */
        } R_b;
    };
    __IM uint16_t RESERVED;
} R_MPU_SMPU_SMPU_Type;                  /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_MPU_SPMON_SP [SP] (Stack Pointer Monitor)
 */
typedef struct
{
    union
    {
        __IOM uint16_t OAD;            /*!< (@ 0x00000000) Stack Pointer Monitor Operation After Detection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint16_t OAD : 1;    /*!< [0..0] Operation after detection                                          */
            uint16_t           : 7;
            __OM uint16_t KEY  : 8;    /*!< [15..8] Write Keyword The data written to these bits are not
                                        *   stored.                                                                   */
        } OAD_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint16_t CTL;            /*!< (@ 0x00000004) Stack Pointer Monitor Access Control Register              */

        struct
        {
            __IOM uint16_t ENABLE : 1; /*!< [0..0] Stack Pointer Monitor Enable                                       */
            uint16_t              : 7;
            __IOM uint16_t ERROR  : 1; /*!< [8..8] Stack Pointer Monitor Error Flag                                   */
            uint16_t              : 7;
        } CTL_b;
    };

    union
    {
        __IOM uint16_t PT;              /*!< (@ 0x00000006) Stack Pointer Monitor Protection Register                  */

        struct
        {
            __IOM uint16_t PROTECT : 1; /*!< [0..0] Protection of register (MSPMPUAC, MSPMPUSA and MSPMPUSE)           */
            uint16_t               : 7;
            __OM uint16_t KEY      : 8; /*!< [15..8] Write Keyword The data written to these bits are not
                                         *   stored.                                                                   */
        } PT_b;
    };

    union
    {
        __IOM uint32_t SA;                /*!< (@ 0x00000008) Stack Pointer Monitor Start Address Register               */

        struct
        {
            __IOM uint32_t MSPMPUSA : 32; /*!< [31..0] Region start address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00000-0x200FFFF
                                           *   The low-order 2 bits are fixed to 0.                                      */
        } SA_b;
    };

    union
    {
        __IOM uint32_t EA;                /*!< (@ 0x0000000C) Stack Pointer Monitor End Address Register                 */

        struct
        {
            __IOM uint32_t MSPMPUEA : 32; /*!< [31..0] Region end address register Address where the region
                                           *   starts, for use in region determination.NOTE: Range: 0x1FF00003-0x200FFFF
                                           *   The low-order 2 bits are fixed to 1.                                      */
        } EA_b;
    };
} R_MPU_SPMON_SP_Type;                    /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_PFS_PORT_PIN [PIN] (Pin Function Selects)
 */
typedef struct
{
    union
    {
        union
        {
            __IOM uint32_t PmnPFS;        /*!< (@ 0x00000000) Pin Function Control Register                              */

            struct
            {
                __IOM uint32_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                __IM uint32_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                __IOM uint32_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                uint32_t             : 1;
                __IOM uint32_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                __IOM uint32_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                __IOM uint32_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                uint32_t             : 3;
                __IOM uint32_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                __IOM uint32_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                __IOM uint32_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                __IOM uint32_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                __IOM uint32_t PMR   : 1; /*!< [16..16] Port Mode Control                                                */
                uint32_t             : 7;
                __IOM uint32_t PSEL  : 5; /*!< [28..24] Port Function SelectThese bits select the peripheral
                                           *   function. For individual pin functions, see the MPC table                 */
                uint32_t : 3;
            } PmnPFS_b;
        };

        struct
        {
            union
            {
                struct
                {
                    __IM uint16_t RESERVED;

                    union
                    {
                        __IOM uint16_t PmnPFS_HA;     /*!< (@ 0x00000002) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint16_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint16_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint16_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint16_t             : 1;
                            __IOM uint16_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint16_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint16_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint16_t             : 3;
                            __IOM uint16_t DSCR  : 2; /*!< [11..10] Drive Strength Control Register                                  */
                            __IOM uint16_t EOFR  : 2; /*!< [13..12] Event on Falling/Rising                                          */
                            __IOM uint16_t ISEL  : 1; /*!< [14..14] IRQ input enable                                                 */
                            __IOM uint16_t ASEL  : 1; /*!< [15..15] Analog Input enable                                              */
                        } PmnPFS_HA_b;
                    };
                };

                struct
                {
                    __IM uint16_t RESERVED1;
                    __IM uint8_t  RESERVED2;

                    union
                    {
                        __IOM uint8_t PmnPFS_BY;     /*!< (@ 0x00000003) Pin Function Control Register                              */

                        struct
                        {
                            __IOM uint8_t PODR  : 1; /*!< [0..0] Port Output Data                                                   */
                            __IM uint8_t  PIDR  : 1; /*!< [1..1] Port Input Data                                                    */
                            __IOM uint8_t PDR   : 1; /*!< [2..2] Port Direction                                                     */
                            uint8_t             : 1;
                            __IOM uint8_t PCR   : 1; /*!< [4..4] Pull-up Control                                                    */
                            __IOM uint8_t PIM   : 1; /*!< [5..5] Port Input Mode Control                                            */
                            __IOM uint8_t NCODR : 1; /*!< [6..6] N-Channel Open Drain Control                                       */
                            uint8_t             : 1;
                        } PmnPFS_BY_b;
                    };
                };
            };
        };
    };
} R_PFS_PORT_PIN_Type;                 /*!< Size = 4 (0x4)                                                            */

/**
 * @brief R_PFS_PORT [PORT] (Port [0..14])
 */
typedef struct
{
    __IOM R_PFS_PORT_PIN_Type PIN[16]; /*!< (@ 0x00000000) Pin Function Selects                                       */
} R_PFS_PORT_Type;                     /*!< Size = 64 (0x40)                                                          */

/**
 * @brief R_PFS_VLSEL [VLSEL] (VLSEL)
 */
typedef struct
{
    __IM uint8_t RESERVED[389];

    union
    {
        __IOM uint8_t VL1SEL;          /*!< (@ 0x00000185) VL1 Select Control Register                                */

        struct
        {
            __IOM uint8_t SELVL : 1;   /*!< [0..0] VL1 Voltage Connection Switching Control                           */
            uint8_t             : 7;
        } VL1SEL_b;
    };
} R_PFS_VLSEL_Type;                    /*!< Size = 390 (0x186)                                                        */

/**
 * @brief R_PMISC_PMSAR [PMSAR] (Port Security Attribution Register)
 */
typedef struct
{
    __IOM uint16_t PMSAR;              /*!< (@ 0x00000000) Port Security Attribution Register                         */
} R_PMISC_PMSAR_Type;                  /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_RTC_RTCCR [RTCCR] (Time Capture Control Register)
 */
typedef struct
{
    union
    {
        __IOM uint8_t RTCCR;           /*!< (@ 0x00000000) Time Capture Control Register                              */

        struct
        {
            __IOM uint8_t TCCT : 2;    /*!< [1..0] Time Capture Control                                               */
            __IM uint8_t  TCST : 1;    /*!< [2..2] Time Capture Status                                                */
            uint8_t            : 1;
            __IOM uint8_t TCNF : 2;    /*!< [5..4] Time Capture Noise Filter Control                                  */
            uint8_t            : 1;
            __IOM uint8_t TCEN : 1;    /*!< [7..7] Time Capture Event Input Pin Enable                                */
        } RTCCR_b;
    };
    __IM uint8_t RESERVED;
} R_RTC_RTCCR_Type;                    /*!< Size = 2 (0x2)                                                            */

/**
 * @brief R_RTC_CP [CP] (Capture registers)
 */
typedef struct
{
    __IM uint8_t RESERVED[2];

    union
    {
        union
        {
            __IM uint8_t RSEC;          /*!< (@ 0x00000002) Second Capture Register                                    */

            struct
            {
                __IM uint8_t SEC1 : 4;  /*!< [3..0] 1-Second Capture Capture value for the ones place of
                                         *   seconds                                                                   */
                __IM uint8_t SEC10 : 3; /*!< [6..4] 10-Second Capture Capture value for the tens place of
                                         *   seconds                                                                   */
                uint8_t : 1;
            } RSEC_b;
        };

        union
        {
            __IM uint8_t BCNT0;           /*!< (@ 0x00000002) BCNT0 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT0CP : 8; /*!< [7..0] BCNT0CP is a read-only register that captures the BCNT0
                                           *   value when a time capture event is detected.                              */
            } BCNT0_b;
        };
    };
    __IM uint8_t RESERVED1;

    union
    {
        union
        {
            __IM uint8_t RMIN;          /*!< (@ 0x00000004) Minute Capture Register                                    */

            struct
            {
                __IM uint8_t MIN1 : 4;  /*!< [3..0] 1-Minute Capture Capture value for the ones place of
                                         *   minutes                                                                   */
                __IM uint8_t MIN10 : 3; /*!< [6..4] 10-Minute Capture Capture value for the tens place of
                                         *   minutes                                                                   */
                uint8_t : 1;
            } RMIN_b;
        };

        union
        {
            __IM uint8_t BCNT1;           /*!< (@ 0x00000004) BCNT1 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT1CP : 8; /*!< [7..0] BCNT1CP is a read-only register that captures the BCNT1
                                           *   value when a time capture event is detected.                              */
            } BCNT1_b;
        };
    };
    __IM uint8_t RESERVED2;

    union
    {
        union
        {
            __IM uint8_t RHR;          /*!< (@ 0x00000006) Hour Capture Register                                      */

            struct
            {
                __IM uint8_t HR1 : 4;  /*!< [3..0] 1-Minute Capture Capture value for the ones place of
                                        *   minutes                                                                   */
                __IM uint8_t HR10 : 2; /*!< [5..4] 10-Minute Capture Capture value for the tens place of
                                        *   minutes                                                                   */
                __IM uint8_t PM : 1;   /*!< [6..6] A.m./p.m. select for time counter setting.                         */
                uint8_t         : 1;
            } RHR_b;
        };

        union
        {
            __IM uint8_t BCNT2;           /*!< (@ 0x00000006) BCNT2 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT2CP : 8; /*!< [7..0] BCNT2CP is a read-only register that captures the BCNT2
                                           *   value when a time capture event is detected.                              */
            } BCNT2_b;
        };
    };
    __IM uint8_t RESERVED3[3];

    union
    {
        union
        {
            __IM uint8_t RDAY;           /*!< (@ 0x0000000A) Date Capture Register                                      */

            struct
            {
                __IM uint8_t DATE1  : 4; /*!< [3..0] 1-Day Capture Capture value for the ones place of minutes          */
                __IM uint8_t DATE10 : 2; /*!< [5..4] 10-Day Capture Capture value for the tens place of minutes         */
                uint8_t             : 2;
            } RDAY_b;
        };

        union
        {
            __IM uint8_t BCNT3;           /*!< (@ 0x0000000A) BCNT3 Capture Register                                     */

            struct
            {
                __IM uint8_t BCNT3CP : 8; /*!< [7..0] BCNT3CP is a read-only register that captures the BCNT3
                                           *   value when a time capture event is detected.                              */
            } BCNT3_b;
        };
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IM uint8_t RMON;             /*!< (@ 0x0000000C) Month Capture Register                                     */

        struct
        {
            __IM uint8_t MON1  : 4;    /*!< [3..0] 1-Month Capture Capture value for the ones place of months         */
            __IM uint8_t MON10 : 1;    /*!< [4..4] 10-Month Capture Capture value for the tens place of
                                        *   months                                                                    */
            uint8_t : 3;
        } RMON_b;
    };
    __IM uint8_t RESERVED5[3];
} R_RTC_CP_Type;                       /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_AGTX0_AGT16_CTRL [CTRL] (CTRL)
 */
typedef struct
{
    union
    {
        __IOM uint8_t AGTCR;           /*!< (@ 0x00000000) AGT Control Register                                       */

        struct
        {
            __IOM uint8_t TSTART : 1;  /*!< [0..0] AGT count start                                                    */
            __IM uint8_t  TCSTF  : 1;  /*!< [1..1] AGT count status flag                                              */
            __OM uint8_t  TSTOP  : 1;  /*!< [2..2] AGT count forced stop                                              */
            uint8_t              : 1;
            __IOM uint8_t TEDGF  : 1;  /*!< [4..4] Active edge judgment flag                                          */
            __IOM uint8_t TUNDF  : 1;  /*!< [5..5] Underflow flag                                                     */
            __IOM uint8_t TCMAF  : 1;  /*!< [6..6] Compare match A flag                                               */
            __IOM uint8_t TCMBF  : 1;  /*!< [7..7] Compare match B flag                                               */
        } AGTCR_b;
    };

    union
    {
        __IOM uint8_t AGTMR1;          /*!< (@ 0x00000001) AGT Mode Register 1                                        */

        struct
        {
            __IOM uint8_t TMOD   : 3;  /*!< [2..0] Operating mode                                                     */
            __IOM uint8_t TEDGPL : 1;  /*!< [3..3] Edge polarity                                                      */
            __IOM uint8_t TCK    : 3;  /*!< [6..4] Count source                                                       */
            uint8_t              : 1;
        } AGTMR1_b;
    };

    union
    {
        __IOM uint8_t AGTMR2;          /*!< (@ 0x00000002) AGT Mode Register 2                                        */

        struct
        {
            __IOM uint8_t CKS : 3;     /*!< [2..0] AGTLCLK/AGTSCLK count source clock frequency division
                                        *   ratio                                                                     */
            uint8_t           : 4;
            __IOM uint8_t LPM : 1;     /*!< [7..7] Low Power Mode                                                     */
        } AGTMR2_b;
    };

    union
    {
        __IOM uint8_t AGTIOSEL_ALT;    /*!< (@ 0x00000003) AGT Pin Select Register                                    */

        struct
        {
            __IOM uint8_t SEL  : 2;    /*!< [1..0] AGTIO pin select                                                   */
            uint8_t            : 2;
            __IOM uint8_t TIES : 1;    /*!< [4..4] AGTIO input enable                                                 */
            uint8_t            : 3;
        } AGTIOSEL_ALT_b;
    };

    union
    {
        __IOM uint8_t AGTIOC;          /*!< (@ 0x00000004) AGT I/O Control Register                                   */

        struct
        {
            __IOM uint8_t TEDGSEL : 1; /*!< [0..0] I/O polarity switchFunction varies depending on the operating
                                        *   mode.                                                                     */
            uint8_t             : 1;
            __IOM uint8_t TOE   : 1;   /*!< [2..2] AGTOn output enable                                                */
            uint8_t             : 1;
            __IOM uint8_t TIPF  : 2;   /*!< [5..4] Input filter                                                       */
            __IOM uint8_t TIOGT : 2;   /*!< [7..6] Count control                                                      */
        } AGTIOC_b;
    };

    union
    {
        __IOM uint8_t AGTISR;          /*!< (@ 0x00000005) AGT Event Pin Select Register                              */

        struct
        {
            uint8_t            : 2;
            __IOM uint8_t EEPS : 1;    /*!< [2..2] AGTEE polarty selection                                            */
            uint8_t            : 5;
        } AGTISR_b;
    };

    union
    {
        __IOM uint8_t AGTCMSR;         /*!< (@ 0x00000006) AGT Compare Match Function Select Register                 */

        struct
        {
            __IOM uint8_t TCMEA  : 1;  /*!< [0..0] Compare match A register enable                                    */
            __IOM uint8_t TOEA   : 1;  /*!< [1..1] AGTOA output enable                                                */
            __IOM uint8_t TOPOLA : 1;  /*!< [2..2] AGTOA polarity select                                              */
            uint8_t              : 1;
            __IOM uint8_t TCMEB  : 1;  /*!< [4..4] Compare match B register enable                                    */
            __IOM uint8_t TOEB   : 1;  /*!< [5..5] AGTOB output enable                                                */
            __IOM uint8_t TOPOLB : 1;  /*!< [6..6] AGTOB polarity select                                              */
            uint8_t              : 1;
        } AGTCMSR_b;
    };

    union
    {
        __IOM uint8_t AGTIOSEL;        /*!< (@ 0x00000007) AGT Pin Select Register                                    */

        struct
        {
            __IOM uint8_t SEL  : 2;    /*!< [1..0] AGTIO pin select                                                   */
            uint8_t            : 2;
            __IOM uint8_t TIES : 1;    /*!< [4..4] AGTIO input enable                                                 */
            uint8_t            : 3;
        } AGTIOSEL_b;
    };
} R_AGTX0_AGT16_CTRL_Type;             /*!< Size = 8 (0x8)                                                            */

/**
 * @brief R_AGTX0_AGT16 [AGT16] (AGT (16-bit) peripheral registers)
 */
typedef struct
{
    union
    {
        __IOM uint16_t AGT;            /*!< (@ 0x00000000) AGT Counter Register                                       */

        struct
        {
            __IOM uint16_t AGT : 16;   /*!< [15..0] 16bit counter and reload register. NOTE : When 1 is
                                        *   written to the TSTOP bit in the AGTCRn register, the 16-bit
                                        *   counter is forcibly stopped and set to FFFFH.                             */
        } AGT_b;
    };

    union
    {
        __IOM uint16_t AGTCMA;          /*!< (@ 0x00000002) AGT Compare Match A Register                               */

        struct
        {
            __IOM uint16_t AGTCMA : 16; /*!< [15..0] AGT Compare Match A data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCRn register, set to
                                         *   FFFFH                                                                     */
        } AGTCMA_b;
    };

    union
    {
        __IOM uint16_t AGTCMB;          /*!< (@ 0x00000004) AGT Compare Match B Register                               */

        struct
        {
            __IOM uint16_t AGTCMB : 16; /*!< [15..0] AGT Compare Match B data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCR register, set to
                                         *   FFFFH                                                                     */
        } AGTCMB_b;
    };
    __IM uint16_t                 RESERVED;
    __IOM R_AGTX0_AGT16_CTRL_Type CTRL; /*!< (@ 0x00000008) CTRL                                                       */
} R_AGTX0_AGT16_Type;                   /*!< Size = 16 (0x10)                                                          */

/**
 * @brief R_AGTX0_AGT32 [AGT32] (AGTW (32-bit) peripheral registers)
 */
typedef struct
{
    union
    {
        __IOM uint32_t AGT;            /*!< (@ 0x00000000) AGT 32-bit Counter Register                                */

        struct
        {
            __IOM uint32_t AGT : 32;   /*!< [31..0] 32bit counter and reload register. NOTE : When 1 is
                                        *   written to the TSTOP bit in the AGTCRn register, the 16-bit
                                        *   counter is forcibly stopped and set to FFFFH.                             */
        } AGT_b;
    };

    union
    {
        __IOM uint32_t AGTCMA;          /*!< (@ 0x00000004) AGT Compare Match A Register                               */

        struct
        {
            __IOM uint32_t AGTCMA : 32; /*!< [31..0] AGT Compare Match A data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCRn register, set to
                                         *   FFFFH                                                                     */
        } AGTCMA_b;
    };

    union
    {
        __IOM uint32_t AGTCMB;          /*!< (@ 0x00000008) AGT Compare Match B Register                               */

        struct
        {
            __IOM uint32_t AGTCMB : 32; /*!< [31..0] AGT Compare Match B data is stored.NOTE : When 1 is
                                         *   written to the TSTOP bit in the AGTCR register, set to
                                         *   FFFFH                                                                     */
        } AGTCMB_b;
    };
    __IOM R_AGTX0_AGT16_CTRL_Type CTRL; /*!< (@ 0x0000000C) CTRL                                                       */
} R_AGTX0_AGT32_Type;                   /*!< Size = 20 (0x14)                                                          */

/** @} */ /* End of group Device_Peripheral_clusters */

/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripherals
 * @{
 */

/* =========================================================================================================================== */
/* ================                                         R_ACMPLP                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Low-Power Analog Comparator (R_ACMPLP)
 */

typedef struct                         /*!< (@ 0x40085E00) R_ACMPLP Structure                                         */
{
    union
    {
        __IOM uint8_t COMPMDR;         /*!< (@ 0x00000000) ACMPLP Mode Setting Register                               */

        struct
        {
            __IOM uint8_t C0ENB : 1;   /*!< [0..0] ACMPLP0 Operation Enable                                           */
            __IOM uint8_t C0WDE : 1;   /*!< [1..1] ACMPLP0 Window Function Mode Enable                                */
            __IOM uint8_t C0VRF : 1;   /*!< [2..2] ACMPLP0 Reference Voltage Selection                                */
            __IM uint8_t  C0MON : 1;   /*!< [3..3] ACMPLP0 Monitor Flag                                               */
            __IOM uint8_t C1ENB : 1;   /*!< [4..4] ACMPLP1 Operation Enable                                           */
            __IOM uint8_t C1WDE : 1;   /*!< [5..5] ACMPLP1 Window Function Mode Enable                                */
            __IOM uint8_t C1VRF : 1;   /*!< [6..6] ACMPLP1 Reference Voltage Selection                                */
            __IM uint8_t  C1MON : 1;   /*!< [7..7] ACMPLP1 Monitor Flag                                               */
        } COMPMDR_b;
    };

    union
    {
        __IOM uint8_t COMPFIR;         /*!< (@ 0x00000001) ACMPLP Filter Control Register                             */

        struct
        {
            __IOM uint8_t C0FCK : 2;   /*!< [1..0] ACMPLP0 Filter Select                                              */
            __IOM uint8_t C0EPO : 1;   /*!< [2..2] ACMPLP0 Edge Polarity Switching                                    */
            __IOM uint8_t C0EDG : 1;   /*!< [3..3] ACMPLP0 Edge Detection Selection                                   */
            __IOM uint8_t C1FCK : 2;   /*!< [5..4] ACMPLP1 Filter Select                                              */
            __IOM uint8_t C1EPO : 1;   /*!< [6..6] ACMPLP1 Edge Polarity Switching                                    */
            __IOM uint8_t C1EDG : 1;   /*!< [7..7] ACMPLP1 Edge Detection Selection                                   */
        } COMPFIR_b;
    };

    union
    {
        __IOM uint8_t COMPOCR;         /*!< (@ 0x00000002) ACMPLP Output Control Register                             */

        struct
        {
            uint8_t             : 1;
            __IOM uint8_t C0OE  : 1;   /*!< [1..1] ACMPLP0 VCOUT Pin Output Enable                                    */
            __IOM uint8_t C0OP  : 1;   /*!< [2..2] ACMPLP0 VCOUT Output Polarity Selection                            */
            uint8_t             : 2;
            __IOM uint8_t C1OE  : 1;   /*!< [5..5] ACMPLP1 VCOUT Pin Output Enable                                    */
            __IOM uint8_t C1OP  : 1;   /*!< [6..6] ACMPLP1 VCOUT Output Polarity Selection                            */
            __IOM uint8_t SPDMD : 1;   /*!< [7..7] ACMPLP0/ACMPLP1 Speed Selection                                    */
        } COMPOCR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t COMPSEL0;        /*!< (@ 0x00000004) Comparator Input Select Register                           */

        struct
        {
            __IOM uint8_t IVCMP0 : 3;  /*!< [2..0] ACMPLP0 Input (IVCMP0) Selection                                   */
            uint8_t              : 1;
            __IOM uint8_t IVCMP1 : 3;  /*!< [6..4] ACMPLP1 Input (IVCMP1) Selection                                   */
            uint8_t              : 1;
        } COMPSEL0_b;
    };

    union
    {
        __IOM uint8_t COMPSEL1;        /*!< (@ 0x00000005) Comparator Reference voltage Select Register               */

        struct
        {
            __IOM uint8_t IVREF0 : 3;  /*!< [2..0] ACMPLP0 Reference Voltage (IVREF0) Selection                       */
            uint8_t              : 1;
            __IOM uint8_t IVREF1 : 3;  /*!< [6..4] ACMPLP1 Reference Voltage(IVREF1) Selection                        */
            __IOM uint8_t C1VRF2 : 1;  /*!< [7..7] ACMPLP1 Reference Voltage Selection                                */
        } COMPSEL1_b;
    };
} R_ACMPLP_Type;                       /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                          R_ADC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief A/D Converter (R_ADC0)
 */

typedef struct                         /*!< (@ 0x4005C000) R_ADC0 Structure                                           */
{
    union
    {
        __IOM uint16_t ADCSR;          /*!< (@ 0x00000000) A/D Control Register                                       */

        struct
        {
            __IOM uint16_t DBLANS : 5; /*!< [4..0] Double Trigger Channel SelectThese bits select one analog
                                        *   input channel for double triggered operation. The setting
                                        *   is only effective while double trigger mode is selected.                  */
            uint16_t              : 1;
            __IOM uint16_t GBADIE : 1; /*!< [6..6] Group B Scan End Interrupt Enable                                  */
            __IOM uint16_t DBLE   : 1; /*!< [7..7] Double Trigger Mode Select                                         */
            __IOM uint16_t EXTRG  : 1; /*!< [8..8] Trigger Select                                                     */
            __IOM uint16_t TRGE   : 1; /*!< [9..9] Trigger Start Enable                                               */
            __IOM uint16_t ADHSC  : 1; /*!< [10..10] A/D Conversion Operation Mode Select                             */
            uint16_t              : 1;
            __IOM uint16_t ADIE   : 1; /*!< [12..12] Scan End Interrupt Enable                                        */
            __IOM uint16_t ADCS   : 2; /*!< [14..13] Scan Mode Select                                                 */
            __IOM uint16_t ADST   : 1; /*!< [15..15] A/D Conversion Start                                             */
        } ADCSR_b;
    };

    union
    {
        __IOM uint8_t ADREF;           /*!< (@ 0x00000002) A/D status register                                        */

        struct
        {
            __IOM uint8_t ADF : 1;     /*!< [0..0] Scanning end flag bitThis bit is a status bit that becomes
                                        *   '1' while scanning.                                                       */
            uint8_t              : 6;
            __IM uint8_t ADSCACT : 1;  /*!< [7..7] Scanning status bit                                                */
        } ADREF_b;
    };

    union
    {
        __IOM uint8_t ADEXREF;         /*!< (@ 0x00000003) A/D enhancing status register                              */

        struct
        {
            __IOM uint8_t GBADF : 1;   /*!< [0..0] Group B scanning end flag bit.                                     */
            uint8_t             : 7;
        } ADEXREF_b;
    };

    union
    {
        __IOM uint16_t ADANSA[2];      /*!< (@ 0x00000004) A/D Channel Select Register                                */

        struct
        {
            __IOM uint16_t ANSA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSA_b[2];
    };

    union
    {
        __IOM uint16_t ADADS[2];       /*!< (@ 0x00000008) A/D-Converted Value Addition/Average Channel
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint16_t ADS0  : 1;  /*!< [0..0] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS1  : 1;  /*!< [1..1] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS2  : 1;  /*!< [2..2] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS3  : 1;  /*!< [3..3] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS4  : 1;  /*!< [4..4] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS5  : 1;  /*!< [5..5] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS6  : 1;  /*!< [6..6] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS7  : 1;  /*!< [7..7] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS8  : 1;  /*!< [8..8] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS9  : 1;  /*!< [9..9] A/D-Converted Value Addition/Average Channel Select                */
            __IOM uint16_t ADS10 : 1;  /*!< [10..10] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS11 : 1;  /*!< [11..11] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS12 : 1;  /*!< [12..12] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS13 : 1;  /*!< [13..13] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS14 : 1;  /*!< [14..14] A/D-Converted Value Addition/Average Channel Select              */
            __IOM uint16_t ADS15 : 1;  /*!< [15..15] A/D-Converted Value Addition/Average Channel Select              */
        } ADADS_b[2];
    };

    union
    {
        __IOM uint8_t ADADC;           /*!< (@ 0x0000000C) A/D-Converted Value Addition/Average Count Select
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t ADC : 3;     /*!< [2..0] Addition frequency selection bit.NOTE: AVEE bit is valid
                                        *   at the only setting of ADC[2:0] bits = 001b or 011b. When
                                        *   average mode is selected by setting the ADADC.AVEE bit
                                        *   to 1, do not set the addition count to three times (ADADC.ADC[2:0]
                                        *   = 010b)                                                                   */
            uint8_t            : 4;
            __IOM uint8_t AVEE : 1;    /*!< [7..7] Average Mode Enable. NOTE:When average mode is deselected
                                        *   by setting the ADADC.AVEE bit to 0, set the addition count
                                        *   to 1, 2, 3, 4 or 16-time conversion. 16-time conversion
                                        *   can only be used with 12-bit accuracy selected. NOTE: AVEE
                                        *   bit is valid at the only setting of ADC[2:0] bits = 001b
                                        *   or 011b. When average mode is selected by setting the ADADC.AVEE
                                        *   bit to 1, do not set the addition count to three times
                                        *   (ADADC.ADC[2:0] = 010b)                                                   */
        } ADADC_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t ADCER;          /*!< (@ 0x0000000E) A/D Control Extended Register                              */

        struct
        {
            uint16_t               : 1;
            __IOM uint16_t ADPRC   : 2; /*!< [2..1] A/D Conversion Accuracy Specify                                    */
            uint16_t               : 1;
            __IOM uint16_t DCE     : 1; /*!< [4..4] Discharge Enable                                                   */
            __IOM uint16_t ACE     : 1; /*!< [5..5] A/D Data Register Automatic Clearing Enable                        */
            uint16_t               : 2;
            __IOM uint16_t DIAGVAL : 2; /*!< [9..8] Self-Diagnosis Conversion Voltage Select                           */
            __IOM uint16_t DIAGLD  : 1; /*!< [10..10] Self-Diagnosis Mode Select                                       */
            __IOM uint16_t DIAGM   : 1; /*!< [11..11] Self-Diagnosis Enable                                            */
            uint16_t               : 2;
            __IOM uint16_t ADINV   : 1; /*!< [14..14] Single-Ended Input A/D Converted Data Inversion Select           */
            __IOM uint16_t ADRFMT  : 1; /*!< [15..15] A/D Data Register Format Select                                  */
        } ADCER_b;
    };

    union
    {
        __IOM uint16_t ADSTRGR;        /*!< (@ 0x00000010) A/D Conversion Start Trigger Select Register               */

        struct
        {
            __IOM uint16_t TRSB : 6;   /*!< [5..0] A/D Conversion Start Trigger Select for Group BSelect
                                        *   the A/D conversion start trigger for group B in group scan
                                        *   mode.                                                                     */
            uint16_t            : 2;
            __IOM uint16_t TRSA : 6;   /*!< [13..8] A/D Conversion Start Trigger SelectSelect the A/D conversion
                                        *   start trigger in single scan mode and continuous mode.
                                        *   In group scan mode, the A/D conversion start trigger for
                                        *   group A is selected.                                                      */
            uint16_t : 2;
        } ADSTRGR_b;
    };

    union
    {
        __IOM uint16_t ADEXICR;        /*!< (@ 0x00000012) A/D Conversion Extended Input Control Register             */

        struct
        {
            __IOM uint16_t TSSAD : 1;  /*!< [0..0] Temperature Sensor Output A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            __IOM uint16_t OCSAD : 1;  /*!< [1..1] Internal Reference Voltage A/D converted Value Addition/Average
                                        *   Mode Select                                                               */
            uint16_t            : 6;
            __IOM uint16_t TSSA : 1;   /*!< [8..8] Temperature Sensor Output A/D Conversion Select                    */
            __IOM uint16_t OCSA : 1;   /*!< [9..9] Internal Reference Voltage A/D Conversion Select                   */
            __IOM uint16_t TSSB : 1;   /*!< [10..10] Temperature Sensor Output A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            __IOM uint16_t OCSB : 1;   /*!< [11..11] Internal Reference Voltage A/D Conversion Select for
                                        *   Group B in group scan mode.                                               */
            uint16_t             : 2;
            __IOM uint16_t EXSEL : 1;  /*!< [14..14] Extended Analog Input Select                                     */
            __IOM uint16_t EXOEN : 1;  /*!< [15..15] Extended Analog Output Control                                   */
        } ADEXICR_b;
    };

    union
    {
        __IOM uint16_t ADANSB[2];      /*!< (@ 0x00000014) A/D Channel Select Register B                              */

        struct
        {
            __IOM uint16_t ANSB0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t ANSB1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t ANSB2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t ANSB3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t ANSB4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t ANSB5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t ANSB6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t ANSB7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t ANSB8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t ANSB9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t ANSB10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t ANSB11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t ANSB12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t ANSB13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t ANSB14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t ANSB15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADANSB_b[2];
    };

    union
    {
        __IM uint16_t ADDBLDR;          /*!< (@ 0x00000018) A/D Data Duplication Register                              */

        struct
        {
            __IM uint16_t ADDBLDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                         *   result of A/D conversion in response to the second trigger
                                         *   in double trigger mode.                                                   */
        } ADDBLDR_b;
    };

    union
    {
        __IM uint16_t ADTSDR;          /*!< (@ 0x0000001A) A/D Temperature Sensor Data Register                       */

        struct
        {
            __IM uint16_t ADTSDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D conversion result of temperature sensor output.                       */
        } ADTSDR_b;
    };

    union
    {
        __IM uint16_t ADOCDR;          /*!< (@ 0x0000001C) A/D Internal Reference Voltage Data Register               */

        struct
        {
            __IM uint16_t ADOCDR : 16; /*!< [15..0] This is a 16-bit read-only register for storing the
                                        *   A/D result of internal reference voltage.                                 */
        } ADOCDR_b;
    };

    union
    {
        union
        {
            __IM uint16_t ADRD_RIGHT;     /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Right Justified           */

            struct
            {
                __IM uint16_t AD : 14;    /*!< [13..0] A/D-converted value (right-justified). The format for
                                           *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
                __IM uint16_t DIAGST : 2; /*!< [15..14] Self-Diagnosis Status                                            */
            } ADRD_RIGHT_b;
        };

        union
        {
            __IM uint16_t ADRD_LEFT;       /*!< (@ 0x0000001E) A/D Self-Diagnosis Data Register Left Justified            */

            struct
            {
                __IM uint16_t DIAGST : 2;  /*!< [1..0] Self-Diagnosis Status                                              */
                __IM uint16_t AD     : 14; /*!< [15..2] A/D-converted value (left-justified). The format for
                                            *   data determine ADCER.ADRFMT and ADCER.ADPRC.                              */
            } ADRD_LEFT_b;
        };
    };

    union
    {
        __IM uint16_t ADDR[29];        /*!< (@ 0x00000020) A/D Data Register                                          */

        struct
        {
            __IM uint16_t ADDR : 16;   /*!< [15..0] The ADDR register is a 16-bit read-only registers for
                                        *   storing the result of A/D conversion.                                     */
        } ADDR_b[29];
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2;
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint8_t ADAMPOFF;        /*!< (@ 0x00000062) A/D RRAMP off state register                               */

        struct
        {
            __IOM uint8_t OPOFF : 8;   /*!< [7..0] OPOFF                                                              */
        } ADAMPOFF_b;
    };

    union
    {
        __IOM uint8_t ADTSTPR;         /*!< (@ 0x00000063) A/D Test Protecting Release Register                       */

        struct
        {
            __IOM uint8_t PRO  : 1;    /*!< [0..0] Test register protecting bit.                                      */
            __IOM uint8_t B0WI : 1;    /*!< [1..1] Bit 0 writing permission bit.                                      */
            uint8_t            : 6;
        } ADTSTPR_b;
    };

    union
    {
        __IOM uint16_t ADDDACER;       /*!< (@ 0x00000064) A/D RRAMP Discharge Period Register                        */

        struct
        {
            __IOM uint16_t WRION  : 5; /*!< [4..0] WRION                                                              */
            uint16_t              : 3;
            __IOM uint16_t WRIOFF : 5; /*!< [12..8] WRIOFF                                                            */
            uint16_t              : 2;
            __IOM uint16_t ADHS   : 1; /*!< [15..15] ADHS                                                             */
        } ADDDACER_b;
    };

    union
    {
        __IOM uint16_t ADSHCR;         /*!< (@ 0x00000066) A/D Sample and Hold Circuit Control Register               */

        struct
        {
            __IOM uint16_t SSTSH : 8;  /*!< [7..0] Channel-Dedicated Sample-and-Hold Circuit Sampling Time
                                        *   Setting Set the sampling time (4 to 255 states)                           */
            __IOM uint16_t SHANS0 : 1; /*!< [8..8] AN000 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS1 : 1; /*!< [9..9] AN001 sample-and-hold circuit Select                               */
            __IOM uint16_t SHANS2 : 1; /*!< [10..10] AN002 sample-and-hold circuit Select                             */
            uint16_t              : 5;
        } ADSHCR_b;
    };

    union
    {
        __IOM uint16_t ADEXTSTR;       /*!< (@ 0x00000068) A/D Enhancing Test Register                                */

        struct
        {
            __IOM uint16_t SHTEST : 3; /*!< [2..0] Test mode bit for S&H circuit.Test mode bit of S&H circuit
                                        *   only for channel.                                                         */
            uint16_t             : 1;
            __IOM uint16_t SWTST : 2;  /*!< [5..4] Test selection bit for pressure switch.                            */
            uint16_t             : 2;
            __IOM uint16_t SHTRM : 2;  /*!< [9..8] Current adjustment trim bit for S&H circuit.Trim bit
                                        *   for adjustment to hardening of process.                                   */
            uint16_t              : 1;
            __IOM uint16_t ADTRM3 : 1; /*!< [11..11] Trim bit 3 for A/D hard macro.3bit Flash comparator
                                        *   power save bit for A/D hard macro to hardening of process.                */
            __IOM uint16_t ADTRM2 : 2; /*!< [13..12] Trim bit 2 for A/D hard macro.Bias adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
            __IOM uint16_t ADTRM1 : 2; /*!< [15..14] Trim bit 1 for A/D hard macro.Timing adjustment trim
                                        *   bit for A/D hard macro to hardening of process.                           */
        } ADEXTSTR_b;
    };

    union
    {
        __IOM uint16_t ADTSTRA;           /*!< (@ 0x0000006A) A/D Test Register A                                        */

        struct
        {
            __IOM uint16_t ATBUSSEL : 1;  /*!< [0..0] Analog test bus selection bit.                                     */
            __IOM uint16_t TSTSWREF : 3;  /*!< [3..1] Pressure switch refreshing setting bit for S&H circuit
                                           *   amplifier test.Refreshing the pressure switch that opens
                                           *   for the DAC output voltage charge period when the amplifier
                                           *   of the S&H circuit is tested only for the channel is set.                 */
            uint16_t            : 1;
            __IOM uint16_t OCSW : 1;      /*!< [5..5] Internal reference voltage analog switch test control
                                           *   bit.                                                                      */
            __IOM uint16_t TSSW : 1;      /*!< [6..6] Temperature sensor output analogue switch test control
                                           *   bit                                                                       */
            uint16_t                 : 1;
            __IOM uint16_t ADTEST_AD : 4; /*!< [11..8] Test bit for A/D analog module Bit for test of A/D analog
                                           *   module Details are described to the bit explanation.                      */
            __IOM uint16_t ADTEST_IO : 4; /*!< [15..12] Test bit for analog I/ODetails are described to the
                                           *   bit explanation.                                                          */
        } ADTSTRA_b;
    };

    union
    {
        __IOM uint16_t ADTSTRB;        /*!< (@ 0x0000006C) A/D Test Register B                                        */

        struct
        {
            __IOM uint16_t ADVAL : 15; /*!< [14..0] Signal input bit bit14-0 for A/D analog module test.It
                                        *   corresponds to ADVAL 14:0 input of A/D analog module.                     */
            uint16_t : 1;
        } ADTSTRB_b;
    };

    union
    {
        __IOM uint16_t ADTSTRC;         /*!< (@ 0x0000006E) A/D Test Register C                                        */

        struct
        {
            __IOM uint16_t ADMD : 8;    /*!< [7..0] Bit for A/D analog module test.ADMODE 6:0 input of A/D
                                         *   analog module.                                                            */
            uint16_t               : 4;
            __IOM uint16_t SYNCERR : 1; /*!< [12..12] Synchronous analog to digital conversion error bit.              */
            uint16_t               : 3;
        } ADTSTRC_b;
    };

    union
    {
        __IOM uint16_t ADTSTRD;         /*!< (@ 0x00000070) A/D Test Register D                                        */

        struct
        {
            __IOM uint16_t ADVAL16 : 1; /*!< [0..0] Signal input bit bit16 for A/D analog module test.It
                                         *   corresponds to ADVAL 16 input of A/D analog module.                       */
            uint16_t : 15;
        } ADTSTRD_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR0;      /*!< (@ 0x00000072) A/D Channel Switch Test Control Register 0                 */

        struct
        {
            __IOM uint16_t CHSW00 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW01 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW02 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW03 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW04 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW05 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR0_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR1;      /*!< (@ 0x00000074) A/D Channel Switch Test Control Register 1                 */

        struct
        {
            __IOM uint16_t CHSW16 : 1; /*!< [0..0] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW17 : 1; /*!< [1..1] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW18 : 1; /*!< [2..2] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW19 : 1; /*!< [3..3] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW20 : 1; /*!< [4..4] Channel switch test control bit.                                   */
            __IOM uint16_t CHSW21 : 1; /*!< [5..5] Channel switch test control bit.                                   */
            uint16_t              : 10;
        } ADSWTSTR1_b;
    };

    union
    {
        __IOM uint16_t ADSWTSTR2;        /*!< (@ 0x00000076) A/D Channel Switch Test Control Register 2                 */

        struct
        {
            __IOM uint16_t EX0SW : 1;    /*!< [0..0] Test control of 0 enhancing input channel switches bit
                                          *   (ANEX0 switch)                                                            */
            __IOM uint16_t EX1SW : 1;    /*!< [1..1] Test control of one enhancing input channel switch bit
                                          *   (ANEX1 switch).                                                           */
            uint16_t                : 2;
            __IOM uint16_t SHBYPS0  : 1; /*!< [4..4] S&H circuit by-pass switch control bit 0.                          */
            __IOM uint16_t SHBYPS1  : 1; /*!< [5..5] S&H circuit by-pass switch control bit 1.                          */
            __IOM uint16_t SHBYPS2  : 1; /*!< [6..6] S&H circuit by-pass switch control bit 2.                          */
            uint16_t                : 1;
            __IOM uint16_t GRP0SW   : 1; /*!< [8..8] Test control of 0 group switches bit.                              */
            __IOM uint16_t GRP1SW   : 1; /*!< [9..9] Test control of one group switch bit.                              */
            __IOM uint16_t GRP2SW   : 1; /*!< [10..10] Test control of two group switches bit                           */
            __IOM uint16_t GRP3SW   : 1; /*!< [11..11] Test control of two group switches bit                           */
            __IOM uint16_t GRPEX1SW : 1; /*!< [12..12] Switch test control bit of enhancing analog ANEX1                */
            uint16_t                : 3;
        } ADSWTSTR2_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint8_t ADDISCR;         /*!< (@ 0x0000007A) A/D Disconnection Detection Control Register               */

        struct
        {
            __IOM uint8_t ADNDIS : 4;  /*!< [3..0] The charging time                                                  */
            __IOM uint8_t CHARGE : 1;  /*!< [4..4] Selection of Precharge or Discharge                                */
            uint8_t              : 3;
        } ADDISCR_b;
    };

    union
    {
        __IOM uint8_t ADSWCR;          /*!< (@ 0x0000007B) A/D Pressure Switch Control Register                       */

        struct
        {
            __IOM uint8_t ADSWREF : 3; /*!< [2..0] These bits are read as 0. The write value should be 0.Refreshing
                                        *   the pressure switch in A/D analog module is set.                          */
            uint8_t               : 1;
            __IOM uint8_t SHSWREF : 3; /*!< [6..4] S&H Boost Switch Refresh Interval Setting                          */
            uint8_t               : 1;
        } ADSWCR_b;
    };

    union
    {
        __IOM uint8_t ADSHMSR;         /*!< (@ 0x0000007C) A/D Sample and Hold Operation Mode Select Register         */

        struct
        {
            __IOM uint8_t SHMD : 1;    /*!< [0..0] Channel-Dedicated Sample-and-Hold Circuit Operation Mode
                                        *   Select                                                                    */
            uint8_t : 7;
        } ADSHMSR_b;
    };

    union
    {
        __IOM uint8_t ADICR;           /*!< (@ 0x0000007D) A/D Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t ADIC : 2;    /*!< [1..0] A/D Interrupt Control                                              */
            uint8_t            : 6;
        } ADICR_b;
    };

    union
    {
        __IOM uint8_t ADACSR;          /*!< (@ 0x0000007E) A/D Conversion Operation Mode Select Register              */

        struct
        {
            uint8_t             : 1;
            __IOM uint8_t ADSAC : 1;   /*!< [1..1] Successive Approximation Control Setting                           */
            uint8_t             : 6;
        } ADACSR_b;
    };
    __IM uint8_t RESERVED5;

    union
    {
        __IOM uint16_t ADGSPCR;         /*!< (@ 0x00000080) A/D Group Scan Priority Control Register                   */

        struct
        {
            __IOM uint16_t PGS : 1;     /*!< [0..0] Group A priority control setting bit.Note: When the PGS
                                         *   bit is to be set to 1, the ADCSR.ADCS[1:0] bits must be
                                         *   set to 01b (group scan mode). If the bits are set to any
                                         *   other values, proper operation is not guaranteed.                         */
            __IOM uint16_t GBRSCN : 1;  /*!< [1..1] Group B Restart Setting(Enabled only when PGS = 1. Reserved
                                         *   when PGS = 0.)                                                            */
            uint16_t               : 6;
            __IOM uint16_t GBEXTRG : 1; /*!< [8..8] External trigger selection bit for group B.                        */
            uint16_t               : 6;
            __IOM uint16_t GBRP    : 1; /*!< [15..15] Group B Single Scan Continuous Start(Enabled only when
                                         *   PGS = 1. Reserved when PGS = 0.)Note: When the GBRP bit
                                         *   has been set to 1, single scan is performed continuously
                                         *   for group B regardless of the setting of the GBRSCN bit.                  */
        } ADGSPCR_b;
    };

    union
    {
        __IM uint16_t ADGSCS;          /*!< (@ 0x00000082) A/D Conversion Channel Status Register (for Group
                                        *                  Scan)                                                      */

        struct
        {
            __IM uint16_t CHSELGB : 8; /*!< [7..0] Channel status of Group B scan                                     */
            __IM uint16_t CHSELGA : 8; /*!< [15..8] Channel status of Group A scan                                    */
        } ADGSCS_b;
    };

    union
    {
        __IM uint16_t ADDBLDRA;          /*!< (@ 0x00000084) A/D Data Duplexing Register A                              */

        struct
        {
            __IM uint16_t ADDBLDRA : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRA_b;
    };

    union
    {
        __IM uint16_t ADDBLDRB;          /*!< (@ 0x00000086) A/D Data Duplexing Register B                              */

        struct
        {
            __IM uint16_t ADDBLDRB : 16; /*!< [15..0] This register is a 16-bit read-only registers for storing
                                          *   the result of A/D conversion in response to the respective
                                          *   triggers during extended operation in double trigger mode.                */
        } ADDBLDRB_b;
    };

    union
    {
        __IOM uint8_t ADSER;           /*!< (@ 0x00000088) A/D Sampling Extension Register                            */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t SMPEX : 1;   /*!< [7..7] Sampling extension control                                         */
        } ADSER_b;
    };
    __IM uint8_t RESERVED6;

    union
    {
        __IOM uint8_t ADHVREFCNT;      /*!< (@ 0x0000008A) A/D High-Potential/Low-Potential Reference Voltage
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint8_t HVSEL : 2;   /*!< [1..0] High-Potential Reference Voltage Select                            */
            uint8_t             : 2;
            __IOM uint8_t LVSEL : 1;   /*!< [4..4] Low-Potential Reference Voltage Select                             */
            uint8_t             : 2;
            __IOM uint8_t ADSLP : 1;   /*!< [7..7] Sleep                                                              */
        } ADHVREFCNT_b;
    };
    __IM uint8_t RESERVED7;

    union
    {
        __IM uint8_t ADWINMON;         /*!< (@ 0x0000008C) A/D Compare Function Window A/B Status Monitor
                                        *                  Register                                                   */

        struct
        {
            __IM uint8_t MONCOMB : 1;  /*!< [0..0] Combination result monitorThis bit indicates the combination
                                        *   result.This bit is valid when both window A operation and
                                        *   window B operation are enabled.                                           */
            uint8_t              : 3;
            __IM uint8_t MONCMPA : 1;  /*!< [4..4] Comparison Result Monitor A                                        */
            __IM uint8_t MONCMPB : 1;  /*!< [5..5] Comparison Result Monitor B                                        */
            uint8_t              : 2;
        } ADWINMON_b;
    };
    __IM uint8_t  RESERVED8;
    __IM uint16_t RESERVED9;

    union
    {
        __IOM uint16_t ADCMPCR;        /*!< (@ 0x00000090) A/D Compare Function Control Register                      */

        struct
        {
            __IOM uint16_t CMPAB : 2;  /*!< [1..0] Window A/B Composite Conditions SettingNOTE: These bits
                                        *   are valid when both window A and window B are enabled (CMPAE
                                        *   = 1 and CMPBE = 1).                                                       */
            uint16_t              : 7;
            __IOM uint16_t CMPBE  : 1; /*!< [9..9] Compare Window B Operation Enable                                  */
            uint16_t              : 1;
            __IOM uint16_t CMPAE  : 1; /*!< [11..11] Compare Window A Operation Enable                                */
            uint16_t              : 1;
            __IOM uint16_t CMPBIE : 1; /*!< [13..13] Compare B Interrupt Enable                                       */
            __IOM uint16_t WCMPE  : 1; /*!< [14..14] Window Function Setting                                          */
            __IOM uint16_t CMPAIE : 1; /*!< [15..15] Compare A Interrupt Enable                                       */
        } ADCMPCR_b;
    };

    union
    {
        __IOM uint8_t ADCMPANSER;      /*!< (@ 0x00000092) A/D Compare Function Window A Extended Input
                                        *                  Select Register                                            */

        struct
        {
            __IOM uint8_t CMPTSA : 1;  /*!< [0..0] Temperature sensor output Compare selection bit.                   */
            __IOM uint8_t CMPOCA : 1;  /*!< [1..1] Internal reference voltage Compare selection bit.                  */
            uint8_t              : 6;
        } ADCMPANSER_b;
    };

    union
    {
        __IOM uint8_t ADCMPLER;        /*!< (@ 0x00000093) A/D Compare Function Window A Extended Input
                                        *                  Comparison Condition Setting Register                      */

        struct
        {
            __IOM uint8_t CMPLTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Comparison
                                        *   Condition Select                                                          */
            __IOM uint8_t CMPLOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage ComparisonCondition
                                        *   Select                                                                    */
            uint8_t : 6;
        } ADCMPLER_b;
    };

    union
    {
        __IOM uint16_t ADCMPANSR[2];     /*!< (@ 0x00000094) A/D Compare Function Window A Channel Select
                                          *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPCHA0  : 1; /*!< [0..0] AN Input Select                                                    */
            __IOM uint16_t CMPCHA1  : 1; /*!< [1..1] AN Input Select                                                    */
            __IOM uint16_t CMPCHA2  : 1; /*!< [2..2] AN Input Select                                                    */
            __IOM uint16_t CMPCHA3  : 1; /*!< [3..3] AN Input Select                                                    */
            __IOM uint16_t CMPCHA4  : 1; /*!< [4..4] AN Input Select                                                    */
            __IOM uint16_t CMPCHA5  : 1; /*!< [5..5] AN Input Select                                                    */
            __IOM uint16_t CMPCHA6  : 1; /*!< [6..6] AN Input Select                                                    */
            __IOM uint16_t CMPCHA7  : 1; /*!< [7..7] AN Input Select                                                    */
            __IOM uint16_t CMPCHA8  : 1; /*!< [8..8] AN Input Select                                                    */
            __IOM uint16_t CMPCHA9  : 1; /*!< [9..9] AN Input Select                                                    */
            __IOM uint16_t CMPCHA10 : 1; /*!< [10..10] AN Input Select                                                  */
            __IOM uint16_t CMPCHA11 : 1; /*!< [11..11] AN Input Select                                                  */
            __IOM uint16_t CMPCHA12 : 1; /*!< [12..12] AN Input Select                                                  */
            __IOM uint16_t CMPCHA13 : 1; /*!< [13..13] AN Input Select                                                  */
            __IOM uint16_t CMPCHA14 : 1; /*!< [14..14] AN Input Select                                                  */
            __IOM uint16_t CMPCHA15 : 1; /*!< [15..15] AN Input Select                                                  */
        } ADCMPANSR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPLR[2];        /*!< (@ 0x00000098) A/D Compare Function Window A Comparison Condition
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t CMPLCHA0  : 1; /*!< [0..0] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA1  : 1; /*!< [1..1] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA2  : 1; /*!< [2..2] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA3  : 1; /*!< [3..3] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA4  : 1; /*!< [4..4] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA5  : 1; /*!< [5..5] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA6  : 1; /*!< [6..6] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA7  : 1; /*!< [7..7] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA8  : 1; /*!< [8..8] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA9  : 1; /*!< [9..9] Comparison condition of input                                      */
            __IOM uint16_t CMPLCHA10 : 1; /*!< [10..10] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA11 : 1; /*!< [11..11] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA12 : 1; /*!< [12..12] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA13 : 1; /*!< [13..13] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA14 : 1; /*!< [14..14] Comparison condition of input                                    */
            __IOM uint16_t CMPLCHA15 : 1; /*!< [15..15] Comparison condition of input                                    */
        } ADCMPLR_b[2];
    };

    union
    {
        __IOM uint16_t ADCMPDR0;          /*!< (@ 0x0000009C) A/D Compare Function Window A Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR0 : 16; /*!< [15..0] The ADCMPDR0 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR0 sets the lower-side
                                           *   level of window A.                                                        */
        } ADCMPDR0_b;
    };

    union
    {
        __IOM uint16_t ADCMPDR1;          /*!< (@ 0x0000009E) A/D Compare Function Window A Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADCMPDR1 : 16; /*!< [15..0] The ADCMPDR1 register sets the reference data when the
                                           *   compare window A function is used. ADCMPDR1 sets the upper-side
                                           *   level of window A..                                                       */
        } ADCMPDR1_b;
    };

    union
    {
        __IOM uint16_t ADCMPSR[2];         /*!< (@ 0x000000A0) A/D Compare Function Window A Channel Status
                                            *                  Register                                                   */

        struct
        {
            __IOM uint16_t CMPSTCHA0  : 1; /*!< [0..0] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA1  : 1; /*!< [1..1] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA2  : 1; /*!< [2..2] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA3  : 1; /*!< [3..3] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA4  : 1; /*!< [4..4] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA5  : 1; /*!< [5..5] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA6  : 1; /*!< [6..6] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA7  : 1; /*!< [7..7] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA8  : 1; /*!< [8..8] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA9  : 1; /*!< [9..9] Compare window A flag of input                                     */
            __IOM uint16_t CMPSTCHA10 : 1; /*!< [10..10] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA11 : 1; /*!< [11..11] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA12 : 1; /*!< [12..12] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA13 : 1; /*!< [13..13] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA14 : 1; /*!< [14..14] Compare window A flag of input                                   */
            __IOM uint16_t CMPSTCHA15 : 1; /*!< [15..15] Compare window A flag of input                                   */
        } ADCMPSR_b[2];
    };

    union
    {
        __IOM uint8_t ADCMPSER;         /*!< (@ 0x000000A4) A/D Compare Function Window A Extended Input
                                         *                  Channel Status Register                                    */

        struct
        {
            __IOM uint8_t CMPSTTSA : 1; /*!< [0..0] Compare Window A Temperature Sensor Output Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            __IOM uint8_t CMPSTOCA : 1; /*!< [1..1] Compare Window A Internal Reference Voltage Compare Flag
                                         *   When window A operation is enabled (ADCMPCR.CMPAE = 1b),
                                         *   this bit indicates the temperature sensor output comparison
                                         *   result. When window A operation is disabled (ADCMPCR.CMPAE
                                         *   = 0b), comparison conditions for CMPSTTSA are not met any
                                         *   time.                                                                     */
            uint8_t : 6;
        } ADCMPSER_b;
    };
    __IM uint8_t RESERVED10;

    union
    {
        __IOM uint8_t ADCMPBNSR;       /*!< (@ 0x000000A6) A/D Compare Function Window B Channel Selection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint8_t CMPCHB : 6;  /*!< [5..0] Compare window B channel selection bit.The channel that
                                        *   compares it on the condition of compare window B is selected.             */
            uint8_t             : 1;
            __IOM uint8_t CMPLB : 1;   /*!< [7..7] Compare window B Compare condition setting bit.                    */
        } ADCMPBNSR_b;
    };
    __IM uint8_t RESERVED11;

    union
    {
        __IOM uint16_t ADWINLLB;          /*!< (@ 0x000000A8) A/D Compare Function Window B Lower-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINLLB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the lower level of the window B.                              */
        } ADWINLLB_b;
    };

    union
    {
        __IOM uint16_t ADWINULB;          /*!< (@ 0x000000AA) A/D Compare Function Window B Upper-Side Level
                                           *                  Setting Register                                           */

        struct
        {
            __IOM uint16_t ADWINULB : 16; /*!< [15..0] This register is used to compare A window function is
                                           *   used to set the higher level of the window B.                             */
        } ADWINULB_b;
    };

    union
    {
        __IOM uint8_t ADCMPBSR;        /*!< (@ 0x000000AC) A/D Compare Function Window B Status Register              */

        struct
        {
            __IOM uint8_t CMPSTB : 1;  /*!< [0..0] Compare window B flag.It is a status flag that shows
                                        *   the comparative result of CH (AN000-AN027, temperature
                                        *   sensor, and internal reference voltage) made the object
                                        *   of window B relation condition.                                           */
            uint8_t : 7;
        } ADCMPBSR_b;
    };
    __IM uint8_t  RESERVED12;
    __IM uint16_t RESERVED13;

    union
    {
        __IM uint16_t ADBUF0;          /*!< (@ 0x000000B0) A/D Data Buffer Register 0                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF0_b;
    };

    union
    {
        __IM uint16_t ADBUF1;          /*!< (@ 0x000000B2) A/D Data Buffer Register 1                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF1_b;
    };

    union
    {
        __IM uint16_t ADBUF2;          /*!< (@ 0x000000B4) A/D Data Buffer Register 2                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF2_b;
    };

    union
    {
        __IM uint16_t ADBUF3;          /*!< (@ 0x000000B6) A/D Data Buffer Register 3                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF3_b;
    };

    union
    {
        __IM uint16_t ADBUF4;          /*!< (@ 0x000000B8) A/D Data Buffer Register 4                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF4_b;
    };

    union
    {
        __IM uint16_t ADBUF5;          /*!< (@ 0x000000BA) A/D Data Buffer Register 5                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF5_b;
    };

    union
    {
        __IM uint16_t ADBUF6;          /*!< (@ 0x000000BC) A/D Data Buffer Register 6                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF6_b;
    };

    union
    {
        __IM uint16_t ADBUF7;          /*!< (@ 0x000000BE) A/D Data Buffer Register 7                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF7_b;
    };

    union
    {
        __IM uint16_t ADBUF8;          /*!< (@ 0x000000C0) A/D Data Buffer Register 8                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF8_b;
    };

    union
    {
        __IM uint16_t ADBUF9;          /*!< (@ 0x000000C2) A/D Data Buffer Register 9                                 */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF9_b;
    };

    union
    {
        __IM uint16_t ADBUF10;         /*!< (@ 0x000000C4) A/D Data Buffer Register 10                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF10_b;
    };

    union
    {
        __IM uint16_t ADBUF11;         /*!< (@ 0x000000C6) A/D Data Buffer Register 11                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF11_b;
    };

    union
    {
        __IM uint16_t ADBUF12;         /*!< (@ 0x000000C8) A/D Data Buffer Register 12                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF12_b;
    };

    union
    {
        __IM uint16_t ADBUF13;         /*!< (@ 0x000000CA) A/D Data Buffer Register 13                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF13_b;
    };

    union
    {
        __IM uint16_t ADBUF14;         /*!< (@ 0x000000CC) A/D Data Buffer Register 14                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF14_b;
    };

    union
    {
        __IM uint16_t ADBUF15;         /*!< (@ 0x000000CE) A/D Data Buffer Register 15                                */

        struct
        {
            __IM uint16_t ADBUF : 16;  /*!< [15..0] A/D data buffer registers (ADBUF) are 16-bit read-only
                                        *   registers that sequentially store all A/D converted values.
                                        *   The automatic clear function is not applied to these registers.           */
        } ADBUF15_b;
    };

    union
    {
        __IOM uint8_t ADBUFEN;         /*!< (@ 0x000000D0) A/D Data Buffer Enable Register                            */

        struct
        {
            __IOM uint8_t BUFEN : 1;   /*!< [0..0] Data Buffer Enable                                                 */
            uint8_t             : 7;
        } ADBUFEN_b;
    };
    __IM uint8_t RESERVED14;

    union
    {
        __IOM uint8_t ADBUFPTR;        /*!< (@ 0x000000D2) A/D Data Buffer Pointer Register                           */

        struct
        {
            __IM uint8_t BUFPTR : 4;   /*!< [3..0] Data Buffer PointerThese bits indicate the number of
                                        *   data buffer to which the next A/D converted data is transferred.          */
            __IM uint8_t PTROVF : 1;   /*!< [4..4] Pointer Overflow Flag                                              */
            uint8_t             : 3;
        } ADBUFPTR_b;
    };
    __IM uint8_t  RESERVED15;
    __IM uint32_t RESERVED16[2];
    __IM uint8_t  RESERVED17;

    union
    {
        __IOM uint8_t ADSSTRL;         /*!< (@ 0x000000DD) A/D Sampling State Register L                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (AN016-AN027)                                */
        } ADSSTRL_b;
    };

    union
    {
        __IOM uint8_t ADSSTRT;         /*!< (@ 0x000000DE) A/D Sampling State Register T                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (temperature sensor output)                  */
        } ADSSTRT_b;
    };

    union
    {
        __IOM uint8_t ADSSTRO;         /*!< (@ 0x000000DF) A/D Sampling State Register O                              */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling Time Setting (Internal reference voltage)                 */
        } ADSSTRO_b;
    };

    union
    {
        __IOM uint8_t ADSSTR[16];      /*!< (@ 0x000000E0) A/D Sampling State Registers                               */

        struct
        {
            __IOM uint8_t SST : 8;     /*!< [7..0] Sampling time setting                                              */
        } ADSSTR_b[16];
    };

    union
    {
        __IOM uint16_t ADANIM;         /*!< (@ 0x000000F0) A/D Channel Input Mode Select Register                     */

        struct
        {
            __IOM uint16_t ANIM0 : 1;  /*!< [0..0] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM1 : 1;  /*!< [1..1] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM2 : 1;  /*!< [2..2] Analog Channel Input Mode Select                                   */
            __IOM uint16_t ANIM3 : 1;  /*!< [3..3] Analog Channel Input Mode Select                                   */
            uint16_t             : 12;
        } ADANIM_b;
    };

    union
    {
        __IOM uint8_t ADCALEXE;        /*!< (@ 0x000000F2) A/D Calibration Execution Register                         */

        struct
        {
            uint8_t              : 6;
            __IM uint8_t  CALMON : 1;  /*!< [6..6] Calibration Status Flag                                            */
            __IOM uint8_t CALEXE : 1;  /*!< [7..7] Calibration Start                                                  */
        } ADCALEXE_b;
    };
    __IM uint8_t RESERVED18;

    union
    {
        __IOM uint8_t VREFAMPCNT;        /*!< (@ 0x000000F4) A/D Dedicated Reference Voltage Circuit Control
                                          *                  Register                                                   */

        struct
        {
            __IOM uint8_t OLDETEN   : 1; /*!< [0..0] OLDET Enable                                                       */
            __IOM uint8_t VREFADCG  : 2; /*!< [2..1] VREFADC Output Voltage Control                                     */
            __IOM uint8_t VREFADCEN : 1; /*!< [3..3] VREFADCG Enable                                                    */
            __IOM uint8_t BGREN     : 1; /*!< [4..4] BGR Enable                                                         */
            uint8_t                 : 2;
            __IOM uint8_t ADSLP     : 1; /*!< [7..7] Sleep                                                              */
        } VREFAMPCNT_b;
    };
    __IM uint8_t  RESERVED19;
    __IM uint16_t RESERVED20;

    union
    {
        __IOM uint16_t ADRD;           /*!< (@ 0x000000F8) A/D Self-Diagnosis Data Register                           */

        struct
        {
            __IM uint16_t AD : 16;     /*!< [15..0] Converted Value 15 to 0                                           */
        } ADRD_b;
    };

    union
    {
        __IM uint8_t ADRST;            /*!< (@ 0x000000FA) A/D Self-Diagnostic Status Register                        */

        struct
        {
            __IM uint8_t DIAGST : 2;   /*!< [1..0] Self-Diagnosis Status                                              */
            uint8_t             : 6;
        } ADRST_b;
    };
    __IM uint8_t  RESERVED21;
    __IM uint32_t RESERVED22[41];

    union
    {
        __IOM uint16_t ADPGACR;           /*!< (@ 0x000001A0) A/D Programmable Gain Amplifier Control Register           */

        struct
        {
            __IOM uint16_t P000SEL0  : 1; /*!< [0..0] A through amplifier is enable for PGA P000                         */
            __IOM uint16_t P000SEL1  : 1; /*!< [1..1] The amplifier passing is enable for PGA P000                       */
            __IOM uint16_t P000ENAMP : 1; /*!< [2..2] Amplifier enable bit for PGA P000                                  */
            __IOM uint16_t P000GEN   : 1; /*!< [3..3] PGA P000 gain setting and enable bit                               */
            __IOM uint16_t P001SEL0  : 1; /*!< [4..4] A through amplifier is enable for PGA P001                         */
            __IOM uint16_t P001SEL1  : 1; /*!< [5..5] The amplifier passing is enable for PGA P001                       */
            __IOM uint16_t P001ENAMP : 1; /*!< [6..6] Amplifier enable bit for PGA P001                                  */
            __IOM uint16_t P001GEN   : 1; /*!< [7..7] PGA P001 gain setting and enable bit                               */
            __IOM uint16_t P002SEL0  : 1; /*!< [8..8] A through amplifier is enable for PGA P002                         */
            __IOM uint16_t P002SEL1  : 1; /*!< [9..9] The amplifier passing is enable for PGA P002                       */
            __IOM uint16_t P002ENAMP : 1; /*!< [10..10] Amplifier enable bit for PGA P002                                */
            __IOM uint16_t P002GEN   : 1; /*!< [11..11] PGA P002 gain setting and enable bit                             */
            __IOM uint16_t P003SEL0  : 1; /*!< [12..12] A through amplifier is enable for PGA P003                       */
            __IOM uint16_t P003SEL1  : 1; /*!< [13..13] The amplifier passing is enable for PGA P003                     */
            __IOM uint16_t P003ENAMP : 1; /*!< [14..14] Amplifier enable bit for PGA P003                                */
            __IOM uint16_t P003GEN   : 1; /*!< [15..15] PGA P003 gain setting and enable bit                             */
        } ADPGACR_b;
    };

    union
    {
        __IOM uint16_t ADPGAGS0;         /*!< (@ 0x000001A2) A/D Programmable Gain Amplifier Gain Setting
                                          *                  Register 0                                                 */

        struct
        {
            __IOM uint16_t P000GAIN : 4; /*!< [3..0] PGA P000 gain setting bit.The gain magnification of (ADPGSDCR0.P000GEN=
                                          *   b) when the shingle end is input and each PGA P000 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P000GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P000DG 1:0.                    */
            __IOM uint16_t P001GAIN : 4; /*!< [7..4] PGA P001 gain setting bit.The gain magnification of (ADPGSDCR0.P001GEN=
                                          *   b) when the shingle end is input and each PGA P001 is set.
                                          *   When the differential motion is input, (ADPGSDCR0.P001GEN=1b)
                                          *   sets the gain magnification when the differential motion
                                          *   is input by the combination with ADPGSDCR0.P001DG 1:0.                    */
            __IOM uint16_t P002GAIN : 4; /*!< [11..8] PGA P002 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P002GEN=0b) when the shingle end is input and
                                          *   each PGA P002 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P002GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P002DG 1:0.                                                     */
            __IOM uint16_t P003GAIN : 4; /*!< [15..12] PGA P003 gain setting bit.The gain magnification of
                                          *   (ADPGSDCR0.P003GEN=0b) when the shingle end is input and
                                          *   each PGA P003 is set. When the differential motion is input,
                                          *   (ADPGSDCR0.P003GEN=1b) sets the gain magnification when
                                          *   the differential motion is input by the combination with
                                          *   ADPGSDCR0.P003DG 1:0.                                                     */
        } ADPGAGS0_b;
    };
    __IM uint32_t RESERVED23[3];

    union
    {
        __IOM uint16_t ADPGADCR0;       /*!< (@ 0x000001B0) A/D Programmable Gain Amplifier Differential
                                         *                  Input Control Register                                     */

        struct
        {
            __IOM uint16_t P000DG : 2;  /*!< [1..0] P000 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P000DEN, P000GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P000DEN : 1; /*!< [3..3] P000 Differential Input Enable                                     */
            __IOM uint16_t P001DG  : 2; /*!< [5..4] P001 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P001DEN, P001GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P001DEN : 1; /*!< [7..7] P001 Differential Input Enable                                     */
            __IOM uint16_t P002DG  : 2; /*!< [9..8] P002 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P002DEN, P002GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P002DEN : 1; /*!< [11..11] P002 Differential Input Enable                                   */
            __IOM uint16_t P003DG  : 2; /*!< [13..12] P003 Differential Input Gain SettingNOTE: When these
                                         *   bits are used, set {P003DEN, P003GEN} to 11b.                             */
            uint16_t               : 1;
            __IOM uint16_t P003DEN : 1; /*!< [15..15] P003 Differential Input Enable                                   */
        } ADPGADCR0_b;
    };
    __IM uint16_t RESERVED24;

    union
    {
        __IOM uint8_t ADPGADBS0;       /*!< (@ 0x000001B4) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 0                               */

        struct
        {
            __IOM uint8_t P0BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P000 to P002 Bias Voltage
                                        *   SelectNOTE: This bit selects the input bias voltage value
                                        *   when differential inputs are used.                                        */
            uint8_t : 7;
        } ADPGADBS0_b;
    };

    union
    {
        __IOM uint8_t ADPGADBS1;       /*!< (@ 0x000001B5) A/D Programmable Gain Amplifier Differential
                                        *                  Input Bias Select Register 1                               */

        struct
        {
            __IOM uint8_t P3BIAS : 1;  /*!< [0..0] Programmable Gain Amplifiers P003 Bias Voltage SelectNOTE:
                                        *   This bit selects the input bias voltage value when differential
                                        *   inputs are used.                                                          */
            uint8_t : 7;
        } ADPGADBS1_b;
    };
    __IM uint16_t RESERVED25;
    __IM uint32_t RESERVED26[10];

    union
    {
        __IOM uint32_t ADREFMON;       /*!< (@ 0x000001E0) A/D External Reference Voltage Monitor Register            */

        struct
        {
            __IOM uint32_t PGAMON : 3; /*!< [2..0] PGA Monitor Output Enable                                          */
            uint32_t              : 13;
            __IOM uint32_t MONSEL : 4; /*!< [19..16] Monitor output selection bit.                                    */
            uint32_t              : 12;
        } ADREFMON_b;
    };
} R_ADC0_Type;                         /*!< Size = 484 (0x1e4)                                                        */

/* =========================================================================================================================== */
/* ================                                           R_BUS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Interface (R_BUS)
 */

typedef struct                          /*!< (@ 0x40003000) R_BUS Structure                                            */
{
    __IOM R_BUS_CSa_Type CSa[8];        /*!< (@ 0x00000000) CS Registers                                               */
    __IM uint32_t        RESERVED[480];
    __IOM R_BUS_CSb_Type CSb[8];        /*!< (@ 0x00000800) CS Registers                                               */

    union
    {
        __IOM uint16_t CSRECEN;         /*!< (@ 0x00000880) CS Recovery Cycle Insertion Enable Register                */

        struct
        {
            __IOM uint16_t RCVEN0  : 1; /*!< [0..0] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN1  : 1; /*!< [1..1] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN2  : 1; /*!< [2..2] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN3  : 1; /*!< [3..3] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN4  : 1; /*!< [4..4] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN5  : 1; /*!< [5..5] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN6  : 1; /*!< [6..6] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVEN7  : 1; /*!< [7..7] Separate Bus Recovery Cycle Insertion Enable                       */
            __IOM uint16_t RCVENM0 : 1; /*!< [8..8] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM1 : 1; /*!< [9..9] Multiplexed Bus Recovery Cycle Insertion Enable                    */
            __IOM uint16_t RCVENM2 : 1; /*!< [10..10] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM3 : 1; /*!< [11..11] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM4 : 1; /*!< [12..12] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM5 : 1; /*!< [13..13] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM6 : 1; /*!< [14..14] Multiplexed Bus Recovery Cycle Insertion Enable                  */
            __IOM uint16_t RCVENM7 : 1; /*!< [15..15] Multiplexed Bus Recovery Cycle Insertion Enable                  */
        } CSRECEN_b;
    };
    __IM uint16_t          RESERVED1;
    __IM uint32_t          RESERVED2[223];
    __IOM R_BUS_SDRAM_Type SDRAM;      /*!< (@ 0x00000C00) SDRAM Registers                                            */
    __IM uint32_t          RESERVED3[235];

    union
    {
        __IOM R_BUS_OAD_Type  OAD;     /*!< (@ 0x00001000) Bus Operation After Detection Registers                    */
        __IOM R_BUS_BUSM_Type BUSM[6]; /*!< (@ 0x00001000) Master Bus Control Registers                               */
    };
    __IM uint32_t RESERVED4[58];

    union
    {
        union
        {
            __IOM uint32_t BUSMABT;      /*!< (@ 0x00001100) Bus Master Arbitration Control Register.                   */

            struct
            {
                __IOM uint32_t ARBS : 1; /*!< [0..0] Arbitration Select for GDSSBI.                                     */
                uint32_t            : 31;
            } BUSMABT_b;
        };
        __IOM R_BUS_BUSS_Type BUSS[18];  /*!< (@ 0x00001100) Slave Bus Control Register Array                           */
    };
    __IM uint32_t RESERVED5[46];

    union
    {
        __IOM R_BUS_BUSSABT0_Type BUSSABT0; /*!< (@ 0x00001200) Bus Slave Arbitration Control 0 Registers                  */
        __IOM R_BUS_BUSSABT1_Type BUSSABT1; /*!< (@ 0x00001200) Bus Slave Arbitration Control 1 Registers                  */
    };
    __IM uint32_t RESERVED6[33];

    union
    {
        __IOM uint32_t BUSDIVBYP;        /*!< (@ 0x00001300) Bus Divider Bypass Register.                               */

        struct
        {
            __IOM uint32_t EDMABPE  : 1; /*!< [0..0] Divider for EDMACBI bypass enable.                                 */
            uint32_t                : 2;
            __IOM uint32_t GDSSBPE  : 1; /*!< [3..3] Divider for GDSSBI bypass enable.                                  */
            uint32_t                : 12;
            __IOM uint32_t CPU0SBPE : 1; /*!< [16..16] Divider for CPUSAHBI bypass enable.                              */
            uint32_t                : 15;
        } BUSDIVBYP_b;
    };
    __IM uint32_t RESERVED7[63];

    union
    {
        __IOM uint16_t BUSTHRPUT;      /*!< (@ 0x00001400) Graphic Bus Throughput Control Register                    */

        struct
        {
            __IOM uint16_t DIS : 1;    /*!< [0..0] Bandwidth Control Function                                         */
            uint16_t           : 15;
        } BUSTHRPUT_b;
    };
    __IM uint16_t            RESERVED8;
    __IM uint32_t            RESERVED9[255];
    __IOM R_BUS_BUSERRa_Type BUSERRa[12]; /*!< (@ 0x00001800) Bus Error Registers                                        */
    __IM uint32_t            RESERVED10[16];

    union
    {
        __IOM R_BUS_BTZFERR_Type BTZFERR[4]; /*!< (@ 0x00001900) Bus TZF Error Registers                                    */
        __IOM R_BUS_BMSAERR_Type BMSAERR[9]; /*!< (@ 0x00001900) Bus Master Security Attribution Unit Error Address
                                              *                  and Read/Write Status registers.                           */
    };
    __IM uint32_t RESERVED11[28];

    union
    {
        __IOM R_BUS_BUSERRb_Type    BUSERRb[12]; /*!< (@ 0x00001A00) Bus Error Registers                                        */
        __IOM R_BUS_DMACDTCERR_Type DMACDTCERR;  /*!< (@ 0x00001A00) DMAC/DTC Error Registers                                   */
    };
    __IM uint32_t           RESERVED12[16];
    __IOM R_BUS_MBWERR_Type MBWERR;              /*!< (@ 0x00001B00) Master Bufferable Write Error Registers                    */
    __IM uint32_t           RESERVED13[5];
    __IOM R_BUS_MBWERR_Type SBWERR;              /*!< (@ 0x00001B20) Slave Bufferable Write Error Registers                     */
} R_BUS_Type;                                    /*!< Size = 6956 (0x1b2c)                                                      */

/* =========================================================================================================================== */
/* ================                                           R_CAC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Clock Frequency Accuracy Measurement Circuit (R_CAC)
 */

typedef struct                         /*!< (@ 0x40044600) R_CAC Structure                                            */
{
    union
    {
        __IOM uint8_t CACR0;           /*!< (@ 0x00000000) CAC Control Register 0                                     */

        struct
        {
            __IOM uint8_t CFME : 1;    /*!< [0..0] Clock Frequency Measurement Enable.                                */
            uint8_t            : 7;
        } CACR0_b;
    };

    union
    {
        __IOM uint8_t CACR1;           /*!< (@ 0x00000001) CAC Control Register 1                                     */

        struct
        {
            __IOM uint8_t CACREFE : 1; /*!< [0..0] CACREF Pin Input Enable                                            */
            __IOM uint8_t FMCS    : 3; /*!< [3..1] Measurement Target Clock Select                                    */
            __IOM uint8_t TCSS    : 2; /*!< [5..4] Measurement Target Clock Frequency Division Ratio Select           */
            __IOM uint8_t EDGES   : 2; /*!< [7..6] Valid Edge Select                                                  */
        } CACR1_b;
    };

    union
    {
        __IOM uint8_t CACR2;           /*!< (@ 0x00000002) CAC Control Register 2                                     */

        struct
        {
            __IOM uint8_t RPS  : 1;    /*!< [0..0] Reference Signal Select                                            */
            __IOM uint8_t RSCS : 3;    /*!< [3..1] Measurement Reference Clock Select                                 */
            __IOM uint8_t RCDS : 2;    /*!< [5..4] Measurement Reference Clock Frequency Division Ratio
                                        *   Select                                                                    */
            __IOM uint8_t DFS : 2;     /*!< [7..6] Digital Filter Selection                                           */
        } CACR2_b;
    };

    union
    {
        __IOM uint8_t CAICR;           /*!< (@ 0x00000003) CAC Interrupt Control Register                             */

        struct
        {
            __IOM uint8_t FERRIE : 1;  /*!< [0..0] Frequency Error Interrupt Request Enable                           */
            __IOM uint8_t MENDIE : 1;  /*!< [1..1] Measurement End Interrupt Request Enable                           */
            __IOM uint8_t OVFIE  : 1;  /*!< [2..2] Overflow Interrupt Request Enable                                  */
            uint8_t              : 1;
            __OM uint8_t FERRFCL : 1;  /*!< [4..4] FERRF Clear                                                        */
            __OM uint8_t MENDFCL : 1;  /*!< [5..5] MENDF Clear                                                        */
            __OM uint8_t OVFFCL  : 1;  /*!< [6..6] OVFF Clear                                                         */
            uint8_t              : 1;
        } CAICR_b;
    };

    union
    {
        __IM uint8_t CASTR;            /*!< (@ 0x00000004) CAC Status Register                                        */

        struct
        {
            __IM uint8_t FERRF : 1;    /*!< [0..0] Frequency Error Flag                                               */
            __IM uint8_t MENDF : 1;    /*!< [1..1] Measurement End Flag                                               */
            __IM uint8_t OVFF  : 1;    /*!< [2..2] Counter Overflow Flag                                              */
            uint8_t            : 5;
        } CASTR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t CAULVR;          /*!< (@ 0x00000006) CAC Upper-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CAULVR : 16; /*!< [15..0] CAULVR is a 16-bit readable/writable register that stores
                                         *   the upper-limit value of the frequency.                                   */
        } CAULVR_b;
    };

    union
    {
        __IOM uint16_t CALLVR;          /*!< (@ 0x00000008) CAC Lower-Limit Value Setting Register                     */

        struct
        {
            __IOM uint16_t CALLVR : 16; /*!< [15..0] CALLVR is a 16-bit readable/writable register that stores
                                         *   the lower-limit value of the frequency.                                   */
        } CALLVR_b;
    };

    union
    {
        __IM uint16_t CACNTBR;          /*!< (@ 0x0000000A) CAC Counter Buffer Register                                */

        struct
        {
            __IM uint16_t CACNTBR : 16; /*!< [15..0] CACNTBR is a 16-bit read-only register that retains
                                         *   the counter value at the time a valid reference signal
                                         *   edge is input                                                             */
        } CACNTBR_b;
    };
} R_CAC_Type;                           /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                          R_CAN0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Controller Area Network (CAN) Module (R_CAN0)
 */

typedef struct                         /*!< (@ 0x40050000) R_CAN0 Structure                                           */
{
    __IM uint32_t        RESERVED[128];
    __IOM R_CAN0_MB_Type MB[32];       /*!< (@ 0x00000200) Mailbox                                                    */

    union
    {
        __IOM uint32_t MKR[8];         /*!< (@ 0x00000400) Mask Register                                              */

        struct
        {
            __IOM uint32_t EID : 18;   /*!< [17..0] Extended ID                                                       */
            __IOM uint32_t SID : 11;   /*!< [28..18] Standard ID                                                      */
            uint32_t           : 3;
        } MKR_b[8];
    };

    union
    {
        __IOM uint32_t FIDCR[2];       /*!< (@ 0x00000420) FIFO Received ID Compare Registers                         */

        struct
        {
            __IOM uint32_t EID : 18;   /*!< [17..0] Extended ID                                                       */
            __IOM uint32_t SID : 11;   /*!< [28..18] Standard ID                                                      */
            uint32_t           : 1;
            __IOM uint32_t RTR : 1;    /*!< [30..30] Remote Transmission Request                                      */
            __IOM uint32_t IDE : 1;    /*!< [31..31] ID Extension                                                     */
        } FIDCR_b[2];
    };

    union
    {
        __IOM uint32_t MKIVLR;         /*!< (@ 0x00000428) Mask Invalid Register                                      */

        struct
        {
            __IOM uint32_t MB0  : 1;   /*!< [0..0] mailbox 0 Mask Invalid                                             */
            __IOM uint32_t MB1  : 1;   /*!< [1..1] mailbox 1 Mask Invalid                                             */
            __IOM uint32_t MB2  : 1;   /*!< [2..2] mailbox 2 Mask Invalid                                             */
            __IOM uint32_t MB3  : 1;   /*!< [3..3] mailbox 3 Mask Invalid                                             */
            __IOM uint32_t MB4  : 1;   /*!< [4..4] mailbox 4 Mask Invalid                                             */
            __IOM uint32_t MB5  : 1;   /*!< [5..5] mailbox 5 Mask Invalid                                             */
            __IOM uint32_t MB6  : 1;   /*!< [6..6] mailbox 6 Mask Invalid                                             */
            __IOM uint32_t MB7  : 1;   /*!< [7..7] mailbox 7 Mask Invalid                                             */
            __IOM uint32_t MB8  : 1;   /*!< [8..8] mailbox 8 Mask Invalid                                             */
            __IOM uint32_t MB9  : 1;   /*!< [9..9] mailbox 9 Mask Invalid                                             */
            __IOM uint32_t MB10 : 1;   /*!< [10..10] mailbox 10 Mask Invalid                                          */
            __IOM uint32_t MB11 : 1;   /*!< [11..11] mailbox 11 Mask Invalid                                          */
            __IOM uint32_t MB12 : 1;   /*!< [12..12] mailbox 12 Mask Invalid                                          */
            __IOM uint32_t MB13 : 1;   /*!< [13..13] mailbox 13 Mask Invalid                                          */
            __IOM uint32_t MB14 : 1;   /*!< [14..14] mailbox 14 Mask Invalid                                          */
            __IOM uint32_t MB15 : 1;   /*!< [15..15] mailbox 15 Mask Invalid                                          */
            __IOM uint32_t MB16 : 1;   /*!< [16..16] mailbox 16 Mask Invalid                                          */
            __IOM uint32_t MB17 : 1;   /*!< [17..17] mailbox 17 Mask Invalid                                          */
            __IOM uint32_t MB18 : 1;   /*!< [18..18] mailbox 18 Mask Invalid                                          */
            __IOM uint32_t MB19 : 1;   /*!< [19..19] mailbox 19 Mask Invalid                                          */
            __IOM uint32_t MB20 : 1;   /*!< [20..20] mailbox 20 Mask Invalid                                          */
            __IOM uint32_t MB21 : 1;   /*!< [21..21] mailbox 21 Mask Invalid                                          */
            __IOM uint32_t MB22 : 1;   /*!< [22..22] mailbox 22 Mask Invalid                                          */
            __IOM uint32_t MB23 : 1;   /*!< [23..23] mailbox 23 Mask Invalid                                          */
            __IOM uint32_t MB24 : 1;   /*!< [24..24] mailbox 24 Mask Invalid                                          */
            __IOM uint32_t MB25 : 1;   /*!< [25..25] mailbox 25 Mask Invalid                                          */
            __IOM uint32_t MB26 : 1;   /*!< [26..26] mailbox 26 Mask Invalid                                          */
            __IOM uint32_t MB27 : 1;   /*!< [27..27] mailbox 27 Mask Invalid                                          */
            __IOM uint32_t MB28 : 1;   /*!< [28..28] mailbox 28 Mask Invalid                                          */
            __IOM uint32_t MB29 : 1;   /*!< [29..29] mailbox 29 Mask Invalid                                          */
            __IOM uint32_t MB30 : 1;   /*!< [30..30] mailbox 30 Mask Invalid                                          */
            __IOM uint32_t MB31 : 1;   /*!< [31..31] mailbox 31 Mask Invalid                                          */
        } MKIVLR_b;
    };

    union
    {
        union
        {
            __IOM uint32_t MIER;         /*!< (@ 0x0000042C) Mailbox Interrupt Enable Register                          */

            struct
            {
                __IOM uint32_t MB0  : 1; /*!< [0..0] mailbox 0 Interrupt Enable                                         */
                __IOM uint32_t MB1  : 1; /*!< [1..1] mailbox 1 Interrupt Enable                                         */
                __IOM uint32_t MB2  : 1; /*!< [2..2] mailbox 2 Interrupt Enable                                         */
                __IOM uint32_t MB3  : 1; /*!< [3..3] mailbox 3 Interrupt Enable                                         */
                __IOM uint32_t MB4  : 1; /*!< [4..4] mailbox 4 Interrupt Enable                                         */
                __IOM uint32_t MB5  : 1; /*!< [5..5] mailbox 5 Interrupt Enable                                         */
                __IOM uint32_t MB6  : 1; /*!< [6..6] mailbox 6 Interrupt Enable                                         */
                __IOM uint32_t MB7  : 1; /*!< [7..7] mailbox 7 Interrupt Enable                                         */
                __IOM uint32_t MB8  : 1; /*!< [8..8] mailbox 8 Interrupt Enable                                         */
                __IOM uint32_t MB9  : 1; /*!< [9..9] mailbox 9 Interrupt Enable                                         */
                __IOM uint32_t MB10 : 1; /*!< [10..10] mailbox 10 Interrupt Enable                                      */
                __IOM uint32_t MB11 : 1; /*!< [11..11] mailbox 11 Interrupt Enable                                      */
                __IOM uint32_t MB12 : 1; /*!< [12..12] mailbox 12 Interrupt Enable                                      */
                __IOM uint32_t MB13 : 1; /*!< [13..13] mailbox 13 Interrupt Enable                                      */
                __IOM uint32_t MB14 : 1; /*!< [14..14] mailbox 14 Interrupt Enable                                      */
                __IOM uint32_t MB15 : 1; /*!< [15..15] mailbox 15 Interrupt Enable                                      */
                __IOM uint32_t MB16 : 1; /*!< [16..16] mailbox 16 Interrupt Enable                                      */
                __IOM uint32_t MB17 : 1; /*!< [17..17] mailbox 17 Interrupt Enable                                      */
                __IOM uint32_t MB18 : 1; /*!< [18..18] mailbox 18 Interrupt Enable                                      */
                __IOM uint32_t MB19 : 1; /*!< [19..19] mailbox 19 Interrupt Enable                                      */
                __IOM uint32_t MB20 : 1; /*!< [20..20] mailbox 20 Interrupt Enable                                      */
                __IOM uint32_t MB21 : 1; /*!< [21..21] mailbox 21 Interrupt Enable                                      */
                __IOM uint32_t MB22 : 1; /*!< [22..22] mailbox 22 Interrupt Enable                                      */
                __IOM uint32_t MB23 : 1; /*!< [23..23] mailbox 23 Interrupt Enable                                      */
                __IOM uint32_t MB24 : 1; /*!< [24..24] mailbox 24 Interrupt Enable                                      */
                __IOM uint32_t MB25 : 1; /*!< [25..25] mailbox 25 Interrupt Enable                                      */
                __IOM uint32_t MB26 : 1; /*!< [26..26] mailbox 26 Interrupt Enable                                      */
                __IOM uint32_t MB27 : 1; /*!< [27..27] mailbox 27 Interrupt Enable                                      */
                __IOM uint32_t MB28 : 1; /*!< [28..28] mailbox 28 Interrupt Enable                                      */
                __IOM uint32_t MB29 : 1; /*!< [29..29] mailbox 29 Interrupt Enable                                      */
                __IOM uint32_t MB30 : 1; /*!< [30..30] mailbox 30 Interrupt Enable                                      */
                __IOM uint32_t MB31 : 1; /*!< [31..31] mailbox 31 Interrupt Enable                                      */
            } MIER_b;
        };

        union
        {
            __IOM uint32_t MIER_FIFO;    /*!< (@ 0x0000042C) Mailbox Interrupt Enable Register for FIFO Mailbox
                                          *                  Mode                                                       */

            struct
            {
                __IOM uint32_t MB0  : 1; /*!< [0..0] mailbox 0 Interrupt Enable                                         */
                __IOM uint32_t MB1  : 1; /*!< [1..1] mailbox 1 Interrupt Enable                                         */
                __IOM uint32_t MB2  : 1; /*!< [2..2] mailbox 2 Interrupt Enable                                         */
                __IOM uint32_t MB3  : 1; /*!< [3..3] mailbox 3 Interrupt Enable                                         */
                __IOM uint32_t MB4  : 1; /*!< [4..4] mailbox 4 Interrupt Enable                                         */
                __IOM uint32_t MB5  : 1; /*!< [5..5] mailbox 5 Interrupt Enable                                         */
                __IOM uint32_t MB6  : 1; /*!< [6..6] mailbox 6 Interrupt Enable                                         */
                __IOM uint32_t MB7  : 1; /*!< [7..7] mailbox 7 Interrupt Enable                                         */
                __IOM uint32_t MB8  : 1; /*!< [8..8] mailbox 8 Interrupt Enable                                         */
                __IOM uint32_t MB9  : 1; /*!< [9..9] mailbox 9 Interrupt Enable                                         */
                __IOM uint32_t MB10 : 1; /*!< [10..10] mailbox 10 Interrupt Enable                                      */
                __IOM uint32_t MB11 : 1; /*!< [11..11] mailbox 11 Interrupt Enable                                      */
                __IOM uint32_t MB12 : 1; /*!< [12..12] mailbox 12 Interrupt Enable                                      */
                __IOM uint32_t MB13 : 1; /*!< [13..13] mailbox 13 Interrupt Enable                                      */
                __IOM uint32_t MB14 : 1; /*!< [14..14] mailbox 14 Interrupt Enable                                      */
                __IOM uint32_t MB15 : 1; /*!< [15..15] mailbox 15 Interrupt Enable                                      */
                __IOM uint32_t MB16 : 1; /*!< [16..16] mailbox 16 Interrupt Enable                                      */
                __IOM uint32_t MB17 : 1; /*!< [17..17] mailbox 17 Interrupt Enable                                      */
                __IOM uint32_t MB18 : 1; /*!< [18..18] mailbox 18 Interrupt Enable                                      */
                __IOM uint32_t MB19 : 1; /*!< [19..19] mailbox 19 Interrupt Enable                                      */
                __IOM uint32_t MB20 : 1; /*!< [20..20] mailbox 20 Interrupt Enable                                      */
                __IOM uint32_t MB21 : 1; /*!< [21..21] mailbox 21 Interrupt Enable                                      */
                __IOM uint32_t MB22 : 1; /*!< [22..22] mailbox 22 Interrupt Enable                                      */
                __IOM uint32_t MB23 : 1; /*!< [23..23] mailbox 23 Interrupt Enable                                      */
                __IOM uint32_t MB24 : 1; /*!< [24..24] Transmit FIFO Interrupt Enable                                   */
                __IOM uint32_t MB25 : 1; /*!< [25..25] Transmit FIFO Interrupt Generation Timing Control                */
                uint32_t            : 2;
                __IOM uint32_t MB28 : 1; /*!< [28..28] Receive FIFO Interrupt Enable                                    */
                __IOM uint32_t MB29 : 1; /*!< [29..29] Receive FIFO Interrupt Generation Timing Control                 */
                uint32_t            : 2;
            } MIER_FIFO_b;
        };
    };
    __IM uint32_t RESERVED1[252];

    union
    {
        union
        {
            __IOM uint8_t MCTL_TX[32];       /*!< (@ 0x00000820) Message Control Register for Transmit                      */

            struct
            {
                __IOM uint8_t SENTDATA  : 1; /*!< [0..0] Transmission Complete Flag                                         */
                __IM uint8_t  TRMACTIVE : 1; /*!< [1..1] Transmission-in-Progress Status Flag (Transmit mailbox
                                              *   setting enabled)                                                          */
                __IOM uint8_t TRMABT : 1;    /*!< [2..2] Transmission Abort Complete Flag (Transmit mailbox setting
                                              *   enabled)                                                                  */
                uint8_t               : 1;
                __IOM uint8_t ONESHOT : 1;   /*!< [4..4] One-Shot Enable                                                    */
                uint8_t               : 1;
                __IOM uint8_t RECREQ  : 1;   /*!< [6..6] Receive Mailbox Request                                            */
                __IOM uint8_t TRMREQ  : 1;   /*!< [7..7] Transmit Mailbox Request                                           */
            } MCTL_TX_b[32];
        };

        union
        {
            __IOM uint8_t MCTL_RX[32];       /*!< (@ 0x00000820) Message Control Register for Receive                       */

            struct
            {
                __IOM uint8_t NEWDATA   : 1; /*!< [0..0] Reception Complete Flag                                            */
                __IM uint8_t  INVALDATA : 1; /*!< [1..1] Reception-in-Progress Status Flag (Receive mailbox setting
                                              *   enabled)                                                                  */
                __IOM uint8_t MSGLOST : 1;   /*!< [2..2] Message Lost Flag(Receive mailbox setting enabled)                 */
                uint8_t               : 1;
                __IOM uint8_t ONESHOT : 1;   /*!< [4..4] One-Shot Enable                                                    */
                uint8_t               : 1;
                __IOM uint8_t RECREQ  : 1;   /*!< [6..6] Receive Mailbox Request                                            */
                __IOM uint8_t TRMREQ  : 1;   /*!< [7..7] Transmit Mailbox Request                                           */
            } MCTL_RX_b[32];
        };
    };

    union
    {
        __IOM uint16_t CTLR;           /*!< (@ 0x00000840) Control Register                                           */

        struct
        {
            __IOM uint16_t MBM  : 1;   /*!< [0..0] CAN Mailbox Mode Select                                            */
            __IOM uint16_t IDFM : 2;   /*!< [2..1] ID Format Mode Select                                              */
            __IOM uint16_t MLM  : 1;   /*!< [3..3] Message Lost Mode Select                                           */
            __IOM uint16_t TPM  : 1;   /*!< [4..4] Transmission Priority Mode Select                                  */
            __IOM uint16_t TSRC : 1;   /*!< [5..5] Time Stamp Counter Reset Command                                   */
            __IOM uint16_t TSPS : 2;   /*!< [7..6] Time Stamp Prescaler Select                                        */
            __IOM uint16_t CANM : 2;   /*!< [9..8] CAN Operating Mode Select                                          */
            __IOM uint16_t SLPM : 1;   /*!< [10..10] CAN Sleep Mode                                                   */
            __IOM uint16_t BOM  : 2;   /*!< [12..11] Bus-Off Recovery Mode by a program request                       */
            __IOM uint16_t RBOC : 1;   /*!< [13..13] Forcible Return From Bus-Off                                     */
            uint16_t            : 2;
        } CTLR_b;
    };

    union
    {
        __IM uint16_t STR;             /*!< (@ 0x00000842) Status Register                                            */

        struct
        {
            __IM uint16_t NDST  : 1;   /*!< [0..0] NEWDATA Status Flag                                                */
            __IM uint16_t SDST  : 1;   /*!< [1..1] SENTDATA Status Flag                                               */
            __IM uint16_t RFST  : 1;   /*!< [2..2] Receive FIFO Status Flag                                           */
            __IM uint16_t TFST  : 1;   /*!< [3..3] Transmit FIFO Status Flag                                          */
            __IM uint16_t NMLST : 1;   /*!< [4..4] Normal Mailbox Message Lost Status Flag                            */
            __IM uint16_t FMLST : 1;   /*!< [5..5] FIFO Mailbox Message Lost Status Flag                              */
            __IM uint16_t TABST : 1;   /*!< [6..6] Transmission Abort Status Flag                                     */
            __IM uint16_t EST   : 1;   /*!< [7..7] Error Status Flag                                                  */
            __IM uint16_t RSTST : 1;   /*!< [8..8] CAN Reset Status Flag                                              */
            __IM uint16_t HLTST : 1;   /*!< [9..9] CAN Halt Status Flag                                               */
            __IM uint16_t SLPST : 1;   /*!< [10..10] CAN Sleep Status Flag                                            */
            __IM uint16_t EPST  : 1;   /*!< [11..11] Error-Passive Status Flag                                        */
            __IM uint16_t BOST  : 1;   /*!< [12..12] Bus-Off Status Flag                                              */
            __IM uint16_t TRMST : 1;   /*!< [13..13] Transmit Status Flag (transmitter)                               */
            __IM uint16_t RECST : 1;   /*!< [14..14] Receive Status Flag (receiver)                                   */
            uint16_t            : 1;
        } STR_b;
    };

    union
    {
        __IOM uint32_t BCR;            /*!< (@ 0x00000844) Bit Configuration Register                                 */

        struct
        {
            __IOM uint32_t CCLKS : 1;  /*!< [0..0] CAN Clock Source Selection                                         */
            uint32_t             : 7;
            __IOM uint32_t TSEG2 : 3;  /*!< [10..8] Time Segment 2 Control                                            */
            uint32_t             : 1;
            __IOM uint32_t SJW   : 2;  /*!< [13..12] Resynchronization Jump Width Control                             */
            uint32_t             : 2;
            __IOM uint32_t BRP   : 10; /*!< [25..16] Prescaler Division Ratio Select . These bits set the
                                        *   frequency of the CAN communication clock (fCANCLK).                       */
            uint32_t             : 2;
            __IOM uint32_t TSEG1 : 4;  /*!< [31..28] Time Segment 1 Control                                           */
        } BCR_b;
    };

    union
    {
        __IOM uint8_t RFCR;            /*!< (@ 0x00000848) Receive FIFO Control Register                              */

        struct
        {
            __IOM uint8_t RFE   : 1;   /*!< [0..0] Receive FIFO Enable                                                */
            __IM uint8_t  RFUST : 3;   /*!< [3..1] Receive FIFO Unread Message Number Status                          */
            __IOM uint8_t RFMLF : 1;   /*!< [4..4] Receive FIFO Message Lost Flag                                     */
            __IM uint8_t  RFFST : 1;   /*!< [5..5] Receive FIFO Full Status Flag                                      */
            __IM uint8_t  RFWST : 1;   /*!< [6..6] Receive FIFO Buffer Warning Status Flag                            */
            __IM uint8_t  RFEST : 1;   /*!< [7..7] Receive FIFO Empty Status Flag                                     */
        } RFCR_b;
    };

    union
    {
        __OM uint8_t RFPCR;            /*!< (@ 0x00000849) Receive FIFO Pointer Control Register                      */

        struct
        {
            __OM uint8_t RFPCR : 8;    /*!< [7..0] The CPU-side pointer for the receive FIFO is incremented
                                        *   by writing FFh to RFPCR.                                                  */
        } RFPCR_b;
    };

    union
    {
        __IOM uint8_t TFCR;            /*!< (@ 0x0000084A) Transmit FIFO Control Register                             */

        struct
        {
            __IOM uint8_t TFE   : 1;   /*!< [0..0] Transmit FIFO Enable                                               */
            __IM uint8_t  TFUST : 3;   /*!< [3..1] Transmit FIFO Unsent Message Number Status                         */
            uint8_t             : 2;
            __IM uint8_t TFFST  : 1;   /*!< [6..6] Transmit FIFO Full Status                                          */
            __IM uint8_t TFEST  : 1;   /*!< [7..7] Transmit FIFO Empty Status                                         */
        } TFCR_b;
    };

    union
    {
        __OM uint8_t TFPCR;            /*!< (@ 0x0000084B) Transmit FIFO Pointer Control Register                     */

        struct
        {
            __OM uint8_t TFPCR : 8;    /*!< [7..0] The CPU-side pointer for the transmit FIFO is incremented
                                        *   by writing FFh to TFPCR.                                                  */
        } TFPCR_b;
    };

    union
    {
        __IOM uint8_t EIER;            /*!< (@ 0x0000084C) Error Interrupt Enable Register                            */

        struct
        {
            __IOM uint8_t BEIE  : 1;   /*!< [0..0] Bus Error Interrupt Enable                                         */
            __IOM uint8_t EWIE  : 1;   /*!< [1..1] Error-Warning Interrupt Enable                                     */
            __IOM uint8_t EPIE  : 1;   /*!< [2..2] Error-Passive Interrupt Enable                                     */
            __IOM uint8_t BOEIE : 1;   /*!< [3..3] Bus-Off Entry Interrupt Enable                                     */
            __IOM uint8_t BORIE : 1;   /*!< [4..4] Bus-Off Recovery Interrupt Enable                                  */
            __IOM uint8_t ORIE  : 1;   /*!< [5..5] Overrun Interrupt Enable                                           */
            __IOM uint8_t OLIE  : 1;   /*!< [6..6] Overload Frame Transmit Interrupt Enable                           */
            __IOM uint8_t BLIE  : 1;   /*!< [7..7] Bus Lock Interrupt Enable                                          */
        } EIER_b;
    };

    union
    {
        __IOM uint8_t EIFR;            /*!< (@ 0x0000084D) Error Interrupt Factor Judge Register                      */

        struct
        {
            __IOM uint8_t BEIF  : 1;   /*!< [0..0] Bus Error Detect Flag                                              */
            __IOM uint8_t EWIF  : 1;   /*!< [1..1] Error-Warning Detect Flag                                          */
            __IOM uint8_t EPIF  : 1;   /*!< [2..2] Error-Passive Detect Flag                                          */
            __IOM uint8_t BOEIF : 1;   /*!< [3..3] Bus-Off Entry Detect Flag                                          */
            __IOM uint8_t BORIF : 1;   /*!< [4..4] Bus-Off Recovery Detect Flag                                       */
            __IOM uint8_t ORIF  : 1;   /*!< [5..5] Receive Overrun Detect Flag                                        */
            __IOM uint8_t OLIF  : 1;   /*!< [6..6] Overload Frame Transmission Detect Flag                            */
            __IOM uint8_t BLIF  : 1;   /*!< [7..7] Bus Lock Detect Flag                                               */
        } EIFR_b;
    };

    union
    {
        __IM uint8_t RECR;             /*!< (@ 0x0000084E) Receive Error Count Register                               */

        struct
        {
            __IM uint8_t RECR : 8;     /*!< [7..0] Receive error count functionRECR increments or decrements
                                        *   the counter value according to the error status of the
                                        *   CAN module during reception.                                              */
        } RECR_b;
    };

    union
    {
        __IM uint8_t TECR;             /*!< (@ 0x0000084F) Transmit Error Count Register                              */

        struct
        {
            __IM uint8_t TECR : 8;     /*!< [7..0] Transmit error count functionTECR increments or decrements
                                        *   the counter value according to the error status of the
                                        *   CAN module during transmission.                                           */
        } TECR_b;
    };

    union
    {
        __IOM uint8_t ECSR;            /*!< (@ 0x00000850) Error Code Store Register                                  */

        struct
        {
            __IOM uint8_t SEF  : 1;    /*!< [0..0] Stuff Error Flag                                                   */
            __IOM uint8_t FEF  : 1;    /*!< [1..1] Form Error Flag                                                    */
            __IOM uint8_t AEF  : 1;    /*!< [2..2] ACK Error Flag                                                     */
            __IOM uint8_t CEF  : 1;    /*!< [3..3] CRC Error Flag                                                     */
            __IOM uint8_t BE1F : 1;    /*!< [4..4] Bit Error (recessive) Flag                                         */
            __IOM uint8_t BE0F : 1;    /*!< [5..5] Bit Error (dominant) Flag                                          */
            __IOM uint8_t ADEF : 1;    /*!< [6..6] ACK Delimiter Error Flag                                           */
            __IOM uint8_t EDPM : 1;    /*!< [7..7] Error Display Mode Select                                          */
        } ECSR_b;
    };

    union
    {
        __IOM uint8_t CSSR;            /*!< (@ 0x00000851) Channel Search Support Register                            */

        struct
        {
            __IOM uint8_t CSSR : 8;    /*!< [7..0] When the value for the channel search is input, the channel
                                        *   number is output to MSSR.                                                 */
        } CSSR_b;
    };

    union
    {
        __IM uint8_t MSSR;             /*!< (@ 0x00000852) Mailbox Search Status Register                             */

        struct
        {
            __IM uint8_t MBNST : 5;    /*!< [4..0] Search Result Mailbox Number Status These bits output
                                        *   the smallest mailbox number that is searched in each mode
                                        *   of MSMR.                                                                  */
            uint8_t           : 2;
            __IM uint8_t SEST : 1;     /*!< [7..7] Search Result Status                                               */
        } MSSR_b;
    };

    union
    {
        __IOM uint8_t MSMR;            /*!< (@ 0x00000853) Mailbox Search Mode Register                               */

        struct
        {
            __IOM uint8_t MBSM : 2;    /*!< [1..0] Mailbox Search Mode Select                                         */
            uint8_t            : 6;
        } MSMR_b;
    };

    union
    {
        __IM uint16_t TSR;             /*!< (@ 0x00000854) Time Stamp Register                                        */

        struct
        {
            __IM uint16_t TSR : 16;    /*!< [15..0] Free-running counter value for the time stamp function            */
        } TSR_b;
    };

    union
    {
        __IOM uint16_t AFSR;           /*!< (@ 0x00000856) Acceptance Filter Support Register                         */

        struct
        {
            __IOM uint16_t AFSR : 16;  /*!< [15..0] After the standard ID of a received message is written,
                                        *   the value converted for data table search can be read.                    */
        } AFSR_b;
    };

    union
    {
        __IOM uint8_t TCR;             /*!< (@ 0x00000858) Test Control Register                                      */

        struct
        {
            __IOM uint8_t TSTE : 1;    /*!< [0..0] CAN Test Mode Enable                                               */
            __IOM uint8_t TSTM : 2;    /*!< [2..1] CAN Test Mode Select                                               */
            uint8_t            : 5;
        } TCR_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;
} R_CAN0_Type;                         /*!< Size = 2140 (0x85c)                                                       */

/* =========================================================================================================================== */
/* ================                                           R_CRC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Cyclic Redundancy Check (CRC) Calculator (R_CRC)
 */

typedef struct                         /*!< (@ 0x40074000) R_CRC Structure                                            */
{
    union
    {
        __IOM uint8_t CRCCR0;          /*!< (@ 0x00000000) CRC Control Register0                                      */

        struct
        {
            __IOM uint8_t GPS    : 3;  /*!< [2..0] CRC Generating Polynomial Switching                                */
            uint8_t              : 3;
            __IOM uint8_t LMS    : 1;  /*!< [6..6] CRC Calculation Switching                                          */
            __OM uint8_t  DORCLR : 1;  /*!< [7..7] CRCDOR Register Clear                                              */
        } CRCCR0_b;
    };

    union
    {
        __IOM uint8_t CRCCR1;          /*!< (@ 0x00000001) CRC Control Register1                                      */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t CRCSWR : 1;  /*!< [6..6] Snoop-on-write/read switch bit                                     */
            __IOM uint8_t CRCSEN : 1;  /*!< [7..7] Snoop enable bit                                                   */
        } CRCCR1_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        union
        {
            __IOM uint32_t CRCDIR;          /*!< (@ 0x00000004) CRC Data Input Register                                    */

            struct
            {
                __IOM uint32_t CRCDIR : 32; /*!< [31..0] Calculation input Data (Case of CRC-32, CRC-32C )                 */
            } CRCDIR_b;
        };

        union
        {
            __IOM uint8_t CRCDIR_BY;         /*!< (@ 0x00000004) CRC Data Input Register (byte access)                      */

            struct
            {
                __IOM uint8_t CRCDIR_BY : 8; /*!< [7..0] Calculation input Data ( Case of CRC-8, CRC-16 or CRC-CCITT
                                              *   )                                                                         */
            } CRCDIR_BY_b;
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CRCDOR;          /*!< (@ 0x00000008) CRC Data Output Register                                   */

            struct
            {
                __IOM uint32_t CRCDOR : 32; /*!< [31..0] Calculation output Data (Case of CRC-32, CRC-32C )                */
            } CRCDOR_b;
        };

        union
        {
            __IOM uint16_t CRCDOR_HA;          /*!< (@ 0x00000008) CRC Data Output Register (halfword access)                 */

            struct
            {
                __IOM uint16_t CRCDOR_HA : 16; /*!< [15..0] Calculation output Data (Case of CRC-16 or CRC-CCITT
                                                *   )                                                                         */
            } CRCDOR_HA_b;
        };

        union
        {
            __IOM uint8_t CRCDOR_BY;         /*!< (@ 0x00000008) CRC Data Output Register(byte access)                      */

            struct
            {
                __IOM uint8_t CRCDOR_BY : 8; /*!< [7..0] Calculation output Data (Case of CRC-8 )                           */
            } CRCDOR_BY_b;
        };
    };

    union
    {
        __IOM uint16_t CRCSAR;         /*!< (@ 0x0000000C) Snoop Address Register                                     */

        struct
        {
            __IOM uint16_t CRCSA : 14; /*!< [13..0] snoop address bitSet the I/O register address to snoop            */
            uint16_t             : 2;
        } CRCSAR_b;
    };
    __IM uint16_t RESERVED1;
} R_CRC_Type;                          /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_CTSU2                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Capacitive Touch Sensing Unit (R_CTSU2)
 */

typedef struct                         /*!< (@ 0x40082000) R_CTSU2 Structure                                          */
{
    union
    {
        union
        {
            __IOM uint32_t CTSUCRA;        /*!< (@ 0x00000000) CTSU Control Register A                                    */

            struct
            {
                __IOM uint32_t STRT   : 1; /*!< [0..0] CTSU Measurement Operation Start                                   */
                __IOM uint32_t CAP    : 1; /*!< [1..1] CTSU Measurement Operation Start Trigger Select                    */
                __IOM uint32_t SNZ    : 1; /*!< [2..2] CTSU Wait State Power-Saving Enable                                */
                __IOM uint32_t CFCON  : 1; /*!< [3..3] CTSU CFC Power on Control                                          */
                __OM uint32_t  INIT   : 1; /*!< [4..4] CTSU Control Block Initialization                                  */
                __IOM uint32_t PUMPON : 1; /*!< [5..5] CTSU Boost Circuit Control                                         */
                __IOM uint32_t TXVSEL : 2; /*!< [7..6] CTSU Transmission Power Supply Selection                           */
                __IOM uint32_t PON    : 1; /*!< [8..8] CTSU Power On Control                                              */
                __IOM uint32_t CSW    : 1; /*!< [9..9] TSCAP Pin Enable                                                   */
                __IOM uint32_t ATUNE0 : 1; /*!< [10..10] CTSU Power Supply Operating Mode Setting                         */
                __IOM uint32_t ATUNE1 : 1; /*!< [11..11] CTSU Current Range Adjustment                                    */
                __IOM uint32_t CLK    : 2; /*!< [13..12] CTSU Operating Clock Select                                      */
                __IOM uint32_t MD0    : 1; /*!< [14..14] CTSU Measurement Mode Select 0                                   */
                __IOM uint32_t MD1    : 1; /*!< [15..15] CTSU Measurement Mode Select 1                                   */
                __IOM uint32_t MD2    : 1; /*!< [16..16] CTSU Measurement Mode Select 2                                   */
                __IOM uint32_t ATUNE2 : 1; /*!< [17..17] CTSU Current Range Adjustment                                    */
                __IOM uint32_t LOAD   : 2; /*!< [19..18] CTSU Load Control During Measurement                             */
                __IOM uint32_t POSEL  : 2; /*!< [21..20] CTSU Non-measured Channel Output Select                          */
                __IOM uint32_t SDPSEL : 1; /*!< [22..22] CTSU Sensor Drive Pulse Select                                   */
                __IOM uint32_t PCSEL  : 1; /*!< [23..23] CTSU Boost Circuit Clock Select                                  */
                __IOM uint32_t STCLK  : 6; /*!< [29..24] CTSU STCLK Select                                                */
                __IOM uint32_t DCMODE : 1; /*!< [30..30] CTSU Current Measurement Mode Select                             */
                __IOM uint32_t DCBACK : 1; /*!< [31..31] CTSU Current Measurement Feedback Select                         */
            } CTSUCRA_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCRAL;   /*!< (@ 0x00000000) CTSU Control Register A                                    */

                struct
                {
                    __IOM uint8_t CTSUCR0; /*!< (@ 0x00000000) CTSU Control Register A                                    */
                    __IOM uint8_t CTSUCR1; /*!< (@ 0x00000001) CTSU Control Register A                                    */
                };
            };

            union
            {
                __IOM uint16_t CTSUCRAH;   /*!< (@ 0x00000002) CTSU Control Register A                                    */

                struct
                {
                    __IOM uint8_t CTSUCR2; /*!< (@ 0x00000002) CTSU Control Register A                                    */
                    __IOM uint8_t CTSUCR3; /*!< (@ 0x00000003) CTSU Control Register A                                    */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCRB;         /*!< (@ 0x00000004) CTSU Control Register B                                    */

            struct
            {
                __IOM uint32_t PRRATIO : 4; /*!< [3..0] Frequency of Drive Pulse Phase Control                             */
                __IOM uint32_t PRMODE  : 2; /*!< [5..4] Phase Control Period                                               */
                __IOM uint32_t SOFF    : 1; /*!< [6..6] High-Pass Noise Reduction Function Disable                         */
                __IOM uint32_t PROFF   : 1; /*!< [7..7] Drive Pulse Phase Control                                          */
                __IOM uint32_t SST     : 8; /*!< [15..8] Wait Time Sensor Stabilization                                    */
                uint32_t               : 8;
                __IOM uint32_t SSMOD   : 3; /*!< [26..24] Spread Spectrum Modulation Frequency                             */
                uint32_t               : 1;
                __IOM uint32_t SSCNT   : 2; /*!< [29..28] Adjusting the SUCLK frequency                                    */
                uint32_t               : 2;
            } CTSUCRB_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCRBL;     /*!< (@ 0x00000004) CTSU Control Register B                                    */

                struct
                {
                    __IOM uint8_t CTSUSDPRS; /*!< (@ 0x00000004) CTSU Control Register B                                    */
                    __IOM uint8_t CTSUSST;   /*!< (@ 0x00000005) CTSU Control Register B                                    */
                };
            };

            union
            {
                __IOM uint16_t CTSUCRBH; /*!< (@ 0x00000006) CTSU Control Register B                                    */

                struct
                {
                    __IM uint8_t  RESERVED;
                    __IOM uint8_t CTSUDCLKC; /*!< (@ 0x00000007) CTSU Control Register B                                    */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUMCH;      /*!< (@ 0x00000008) CTSU Measurement Channel Register                          */

            struct
            {
                __IOM uint32_t MCH0 : 6; /*!< [5..0] CTSU Measurement Channel 0                                         */
                uint32_t            : 2;
                __IOM uint32_t MCH1 : 6; /*!< [13..8] CTSU Measurement Channel 1                                        */
                uint32_t            : 2;
                __IOM uint32_t MCA0 : 1; /*!< [16..16] CTSU Multiple Valid Clock Control                                */
                __IOM uint32_t MCA1 : 1; /*!< [17..17] CTSU Multiple Valid Clock Control                                */
                __IOM uint32_t MCA2 : 1; /*!< [18..18] CTSU Multiple Valid Clock Control                                */
                __IOM uint32_t MCA3 : 1; /*!< [19..19] CTSU Multiple Valid Clock Control                                */
                uint32_t            : 12;
            } CTSUMCH_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUMCHL;    /*!< (@ 0x00000008) CTSU Measurement Channel Register                          */

                struct
                {
                    __IOM uint8_t CTSUMCH0; /*!< (@ 0x00000008) CTSU Measurement Channel Register                          */
                    __IOM uint8_t CTSUMCH1; /*!< (@ 0x00000009) CTSU Measurement Channel Register                          */
                };
            };

            union
            {
                __IOM uint16_t CTSUMCHH; /*!< (@ 0x0000000A) CTSU Measurement Channel Register                          */
                __IOM uint8_t  CTSUMFAF; /*!< (@ 0x0000000A) CTSU Measurement Channel Register                          */
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHACA;      /*!< (@ 0x0000000C) CTSU Channel Enable Control Register A                     */

            struct
            {
                __IOM uint32_t CHAC00 : 1; /*!< [0..0] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC01 : 1; /*!< [1..1] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC02 : 1; /*!< [2..2] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC03 : 1; /*!< [3..3] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC04 : 1; /*!< [4..4] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC05 : 1; /*!< [5..5] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC06 : 1; /*!< [6..6] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC07 : 1; /*!< [7..7] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC08 : 1; /*!< [8..8] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC09 : 1; /*!< [9..9] CTSU Channel Enable Control A                                      */
                __IOM uint32_t CHAC10 : 1; /*!< [10..10] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC11 : 1; /*!< [11..11] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC12 : 1; /*!< [12..12] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC13 : 1; /*!< [13..13] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC14 : 1; /*!< [14..14] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC15 : 1; /*!< [15..15] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC16 : 1; /*!< [16..16] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC17 : 1; /*!< [17..17] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC18 : 1; /*!< [18..18] CTSU Channel Enable Control A                                    */
                uint32_t              : 2;
                __IOM uint32_t CHAC21 : 1; /*!< [21..21] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC22 : 1; /*!< [22..22] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC23 : 1; /*!< [23..23] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC24 : 1; /*!< [24..24] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC25 : 1; /*!< [25..25] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC26 : 1; /*!< [26..26] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC27 : 1; /*!< [27..27] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC28 : 1; /*!< [28..28] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC29 : 1; /*!< [29..29] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC30 : 1; /*!< [30..30] CTSU Channel Enable Control A                                    */
                __IOM uint32_t CHAC31 : 1; /*!< [31..31] CTSU Channel Enable Control A                                    */
            } CTSUCHACA_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCHACAL;   /*!< (@ 0x0000000C) CTSU Channel Enable Control Register A                     */

                struct
                {
                    __IOM uint8_t CTSUCHAC0; /*!< (@ 0x0000000C) CTSU Channel Enable Control Register A                     */
                    __IOM uint8_t CTSUCHAC1; /*!< (@ 0x0000000D) CTSU Channel Enable Control Register A                     */
                };
            };

            union
            {
                __IOM uint16_t CTSUCHACAH;   /*!< (@ 0x0000000E) CTSU Channel Enable Control Register A                     */

                struct
                {
                    __IOM uint8_t CTSUCHAC2; /*!< (@ 0x0000000E) CTSU Channel Enable Control Register A                     */
                    __IOM uint8_t CTSUCHAC3; /*!< (@ 0x0000000F) CTSU Channel Enable Control Register A                     */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHACB;      /*!< (@ 0x00000010) CTSU Channel Enable Control Register B                     */

            struct
            {
                __IOM uint32_t CHAC32 : 1; /*!< [0..0] CTSU Channel Enable Control B                                      */
                __IOM uint32_t CHAC33 : 1; /*!< [1..1] CTSU Channel Enable Control B                                      */
                __IOM uint32_t CHAC34 : 1; /*!< [2..2] CTSU Channel Enable Control B                                      */
                __IOM uint32_t CHAC35 : 1; /*!< [3..3] CTSU Channel Enable Control B                                      */
                uint32_t              : 28;
            } CTSUCHACB_b;
        };
        __IOM uint16_t CTSUCHACBL;         /*!< (@ 0x00000010) CTSU Channel Enable Control Register B                     */
        __IOM uint8_t  CTSUCHAC4;          /*!< (@ 0x00000010) CTSU Channel Enable Control Register B                     */
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHTRCA;      /*!< (@ 0x00000014) CTSU Channel Transmit/Receive Control Register
                                             *                  A                                                          */

            struct
            {
                __IOM uint32_t CHTRC   : 1; /*!< [0..0] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC01 : 1; /*!< [1..1] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC02 : 1; /*!< [2..2] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC03 : 1; /*!< [3..3] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC04 : 1; /*!< [4..4] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC05 : 1; /*!< [5..5] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC06 : 1; /*!< [6..6] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC07 : 1; /*!< [7..7] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC08 : 1; /*!< [8..8] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC09 : 1; /*!< [9..9] CTSU Channel Transmit/Receive Control A                            */
                __IOM uint32_t CHTRC10 : 1; /*!< [10..10] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC11 : 1; /*!< [11..11] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC12 : 1; /*!< [12..12] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC13 : 1; /*!< [13..13] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC14 : 1; /*!< [14..14] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC15 : 1; /*!< [15..15] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC16 : 1; /*!< [16..16] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC17 : 1; /*!< [17..17] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC18 : 1; /*!< [18..18] CTSU Channel Transmit/Receive Control A                          */
                uint32_t               : 2;
                __IOM uint32_t CHTRC21 : 1; /*!< [21..21] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC22 : 1; /*!< [22..22] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC23 : 1; /*!< [23..23] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC24 : 1; /*!< [24..24] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC25 : 1; /*!< [25..25] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC26 : 1; /*!< [26..26] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC27 : 1; /*!< [27..27] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC28 : 1; /*!< [28..28] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC29 : 1; /*!< [29..29] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC30 : 1; /*!< [30..30] CTSU Channel Transmit/Receive Control A                          */
                __IOM uint32_t CHTRC31 : 1; /*!< [31..31] CTSU Channel Transmit/Receive Control A                          */
            } CTSUCHTRCA_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUCHTRCAL;   /*!< (@ 0x00000014) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */

                struct
                {
                    __IOM uint8_t CTSUCHTRC0; /*!< (@ 0x00000014) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                    __IOM uint8_t CTSUCHTRC1; /*!< (@ 0x00000015) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                };
            };

            union
            {
                __IOM uint16_t CTSUCHTRCAH;   /*!< (@ 0x00000016) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */

                struct
                {
                    __IOM uint8_t CTSUCHTRC2; /*!< (@ 0x00000016) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                    __IOM uint8_t CTSUCHTRC3; /*!< (@ 0x00000017) CTSU Channel Transmit/Receive Control Register
                                               *                  A                                                          */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCHTRCB;      /*!< (@ 0x00000018) CTSU Channel Transmit/Receive Control Register
                                             *                  B                                                          */

            struct
            {
                __IOM uint32_t CHTRC32 : 1; /*!< [0..0] CTSU Channel Transmit/Receive Control B                            */
                __IOM uint32_t CHTRC33 : 1; /*!< [1..1] CTSU Channel Transmit/Receive Control B                            */
                __IOM uint32_t CHTRC34 : 1; /*!< [2..2] CTSU Channel Transmit/Receive Control B                            */
                __IOM uint32_t CHTRC35 : 1; /*!< [3..3] CTSU Channel Transmit/Receive Control B                            */
                uint32_t               : 28;
            } CTSUCHTRCB_b;
        };
        __IOM uint16_t CTSUCHTRCBL;         /*!< (@ 0x00000018) CTSU Channel Transmit/Receive Control Register
                                             *                  B                                                          */
        __IOM uint8_t CTSUCHTRC4;           /*!< (@ 0x00000018) CTSU Channel Transmit/Receive Control Register
                                             *                  B                                                          */
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSR;          /*!< (@ 0x0000001C) CTSU Status Register                                       */

            struct
            {
                __IOM uint32_t MFC     : 2; /*!< [1..0] CTSU Multi-clock Counter                                           */
                uint32_t               : 3;
                __OM uint32_t ICOMPRST : 1; /*!< [5..5] CTSU CTSUICOMP1 Flag Reset                                         */
                __IM uint32_t ICOMP1   : 1; /*!< [6..6] CTSU Sense Current Error Monitor                                   */
                __IM uint32_t ICOMP0   : 1; /*!< [7..7] TSCAP Voltage Error Monitor                                        */
                __IM uint32_t STC      : 3; /*!< [10..8] CTSU Measurement Status Counter                                   */
                uint32_t               : 1;
                __IM uint32_t  DTSR    : 1; /*!< [12..12] CTSU Data Transfer Status Flag                                   */
                __IOM uint32_t SENSOVF : 1; /*!< [13..13] CTSU Sensor Counter Overflow Flag                                */
                __IOM uint32_t SUOVF   : 1; /*!< [14..14] CTSU SUCLK Counter Overflow Flag                                 */
                __IM uint32_t  PS      : 1; /*!< [15..15] CTSU Mutual Capacitance Status Flag                              */
                __IOM uint32_t CFCRDCH : 6; /*!< [21..16] CTSU CFC Read Channel Select                                     */
                uint32_t               : 10;
            } CTSUSR_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUSRL;    /*!< (@ 0x0000001C) CTSU Status Register                                       */

                struct
                {
                    __IOM uint8_t CTSUSR0; /*!< (@ 0x0000001C) CTSU Status Register                                       */
                    __IOM uint8_t CTSUST;  /*!< (@ 0x0000001D) CTSU Status Register                                       */
                };
            };

            union
            {
                __IOM uint16_t CTSUSRH; /*!< (@ 0x0000001E) CTSU Status Register                                       */
                __IOM uint8_t  CTSUSR2; /*!< (@ 0x0000001E) CTSU Status Register                                       */
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSO;         /*!< (@ 0x00000020) CTSU Sensor Offset Register                                */

            struct
            {
                __IOM uint32_t SO    : 10; /*!< [9..0] CTSU Sensor Offset Adjustment                                      */
                __IOM uint32_t SNUM  : 8;  /*!< [17..10] CTSU Measurement Count Setting                                   */
                uint32_t             : 2;
                __IOM uint32_t SSDIV : 4;  /*!< [23..20] Spread Spectrum Frequency                                        */
                __IOM uint32_t SDPA  : 8;  /*!< [31..24] CTSU Base Clock Setting                                          */
            } CTSUSO_b;
        };

        struct
        {
            __IOM uint16_t CTSUSO0;    /*!< (@ 0x00000020) CTSU Sensor Offset Register                                */
            __IOM uint16_t CTSUSO1;    /*!< (@ 0x00000022) CTSU Sensor Offset Register                                */
        };
    };

    union
    {
        union
        {
            __IM uint32_t CTSUSCNT;         /*!< (@ 0x00000024) CTSU Sensor Counter Register                               */

            struct
            {
                __IM uint32_t SENSCNT : 16; /*!< [15..0] CTSU Sensor Counter                                               */
                __IM uint32_t SUCKCNT : 16; /*!< [31..16] CTSU SUCLK Counter                                               */
            } CTSUSCNT_b;
        };
        __IM uint16_t CTSUSC;               /*!< (@ 0x00000024) CTSU Sensor Counter Register                               */
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUCALIB;  /*!< (@ 0x00000028) CTSU Calibration Register                                  */

            struct
            {
                uint32_t                : 2;
                __IOM uint32_t TSOD     : 1; /*!< [2..2] TS Pins Fixed Output                                               */
                __IOM uint32_t DRV      : 1; /*!< [3..3] Power Supply Calibration Select                                    */
                __IOM uint32_t CLKSEL   : 2; /*!< [5..4] Observation Clock Select                                           */
                __IOM uint32_t SUCLKEN  : 1; /*!< [6..6] SUCLK Forced Oscillation Control                                   */
                __IOM uint32_t TSOC     : 1; /*!< [7..7] Switched Capacitor Operation Calibration Select Bit                */
                __IOM uint32_t CNTRDSEL : 1; /*!< [8..8] Read Count Select of Sensor Counter                                */
                __IOM uint32_t IOC      : 1; /*!< [9..9] TS Pin Fixed Output Value Set                                      */
                __IOM uint32_t CFCRDMD  : 1; /*!< [10..10] CFC Counter Read Mode Select                                     */
                __IOM uint32_t DCOFF    : 1; /*!< [11..11] Down Converter Control                                           */
                __IOM uint32_t IOCSEL   : 1; /*!< [12..12] TS Pins Fixed Output Select                                      */
                uint32_t                : 3;
                __IOM uint32_t CFCSEL   : 6; /*!< [21..16] Observation CFC Clock Select                                     */
                __IOM uint32_t CFCMODE  : 1; /*!< [22..22] CFC Oscillator Calibration Mode Select                           */
                uint32_t                : 1;
                __IOM uint32_t DACMSEL  : 1; /*!< [24..24] Current Offset DAC Current Matrix Calibration Select             */
                __IOM uint32_t DACCARRY : 1; /*!< [25..25] Offset Current Adjustment for Calibration                        */
                __IOM uint32_t SUMSEL   : 1; /*!< [26..26] Current Control Oscillator Input Current Matrix Calibration
                                              *   Select                                                                    */
                __IOM uint32_t SUCARRY : 1;  /*!< [27..27] Current Control Oscillator Input Current Adjustment
                                              *   for SUCLK                                                                 */
                __IOM uint32_t DACCLK : 1;   /*!< [28..28] Modulation Clock Select for Offset Current Circuits              */
                __IOM uint32_t CCOCLK : 1;   /*!< [29..29] Modulation Clock Select for Current Controlled Oscillator
                                              *   Input Current of SUCLK                                                    */
                __IOM uint32_t CCOCALIB : 1; /*!< [30..30] Calibration Selection of Current Controlled Oscillator
                                              *   for Measurement                                                           */
                __IOM uint32_t TXREV : 1;    /*!< [31..31] Transmit Pin Inverted Output                                     */
            } CTSUCALIB_b;
        };

        struct
        {
            __IOM uint16_t CTSUDBGR0;  /*!< (@ 0x00000028) CTSU Calibration Register                                  */
            __IOM uint16_t CTSUDBGR1;  /*!< (@ 0x0000002A) CTSU Calibration Register                                  */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSUCLKA;       /*!< (@ 0x0000002C) CTSU Sensor Unit Clock Control Register A                  */

            struct
            {
                __IOM uint32_t SUADJ0   : 8; /*!< [7..0] CTSU SUCLK Frequency Adjustment                                    */
                __IOM uint32_t SUMULTI0 : 8; /*!< [15..8] CTSU SUCLK Multiplier Rate Setting                                */
                __IOM uint32_t SUADJ1   : 8; /*!< [23..16] CTSU SUCLK Frequency Adjustment                                  */
                __IOM uint32_t SUMULTI1 : 8; /*!< [31..24] CTSU SUCLK Multiplier Rate Setting                               */
            } CTSUSUCLKA_b;
        };

        struct
        {
            __IOM uint16_t CTSUSUCLK0; /*!< (@ 0x0000002C) CTSU Sensor Unit Clock Control Register A                  */
            __IOM uint16_t CTSUSUCLK1; /*!< (@ 0x0000002E) CTSU Sensor Unit Clock Control Register A                  */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSUCLKB;       /*!< (@ 0x00000030) CTSU Sensor Unit Clock Control Register B                  */

            struct
            {
                __IOM uint32_t SUADJ2   : 8; /*!< [7..0] CTSU SUCLK Frequency Adjustment                                    */
                __IOM uint32_t SUMULTI2 : 8; /*!< [15..8] CTSU SUCLK Multiplier Rate Setting                                */
                __IOM uint32_t SUADJ3   : 8; /*!< [23..16] CTSU SUCLK Frequency Adjustment                                  */
                __IOM uint32_t SUMULTI3 : 8; /*!< [31..24] CTSU SUCLK Multiplier Rate Setting                               */
            } CTSUSUCLKB_b;
        };

        struct
        {
            __IOM uint16_t CTSUSUCLK2; /*!< (@ 0x00000030) CTSU Sensor Unit Clock Control Register B                  */
            __IOM uint16_t CTSUSUCLK3; /*!< (@ 0x00000032) CTSU Sensor Unit Clock Control Register B                  */
        };
    };

    union
    {
        union
        {
            __IM uint32_t CTSUCFCCNT;      /*!< (@ 0x00000034) CTSU CFC Counter Register                                  */

            struct
            {
                __IM uint32_t CFCCNT : 16; /*!< [15..0] CTSU CFC Counter                                                  */
                uint32_t             : 16;
            } CTSUCFCCNT_b;
        };
        __IM uint16_t CTSUCFCCNTL;         /*!< (@ 0x00000034) CTSU CFC Counter Register                                  */
    };
    __IM uint32_t RESERVED1[2];

    union
    {
        union
        {
            __IOM uint32_t CTSUOPT;          /*!< (@ 0x00000040) CTSU Option Setting Register                               */

            struct
            {
                __IOM uint32_t CCOCFEN  : 1; /*!< [0..0] CCO Characteristics Correction Function Enable                     */
                __IOM uint32_t MCACEFN  : 1; /*!< [1..1] Multi-clock Correction Function Enable                             */
                __IOM uint32_t MAJIRIMD : 1; /*!< [2..2] Majority Mode                                                      */
                uint32_t                : 1;
                __IOM uint32_t DTCLESS  : 1; /*!< [4..4] Data Transfer Request Disable                                      */
                __IOM uint32_t MTUCFEN  : 1; /*!< [5..5] 5 MTUCFEN Mutual Capacitance Calculation Enable                    */
                uint32_t                : 2;
                __IOM uint32_t AJFEN    : 1; /*!< [8..8] Automatic Judgment Function Enable                                 */
                __IOM uint32_t AJINTC   : 1; /*!< [9..9] Automatic Judgment Interrupt Control                               */
                uint32_t                : 6;
                __IOM uint32_t SCACTB   : 4; /*!< [19..16] Sensor Counter Automatic Correction Table Number Setting         */
                uint32_t                : 12;
            } CTSUOPT_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUOPTL; /*!< (@ 0x00000040) CTSU Option Setting Register                               */

                struct
                {
                    __IOM uint8_t AC;    /*!< (@ 0x00000040) CTSU Option Setting Register                               */
                    __IOM uint8_t AJ;    /*!< (@ 0x00000041) CTSU Option Setting Register                               */
                };
            };

            union
            {
                __IOM uint16_t CTSUOPTH; /*!< (@ 0x00000042) CTSU Option Setting Register                               */
                __IOM uint8_t  ACTB;     /*!< (@ 0x00000042) CTSU Option Setting Register                               */
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUSCNTACT;          /*!< (@ 0x00000044) CTSU Sensor Counter Automatic Correction Table
                                                  *                  Access Register                                            */

            struct
            {
                __IOM uint32_t SCNTACCOEFF : 16; /*!< [15..0] Sensor Counter Correction Coefficient Setting                     */
                __IOM uint32_t SCNTACCOUNT : 16; /*!< [31..16] Set the measurement value to be compared                         */
            } CTSUSCNTACT_b;
        };

        struct
        {
            __IOM uint16_t CTSUSCNTACTL; /*!< (@ 0x00000044) CTSU Option Setting Register                               */
            __IOM uint16_t CTSUSCNTACTH; /*!< (@ 0x00000046) CTSU Option Setting Register                               */
        };
    };
    __IM uint32_t RESERVED2;

    union
    {
        union
        {
            __IOM uint32_t CTSUMACT1;            /*!< (@ 0x0000004C) Multi-Clock Automatic Correction Table Access
                                                  *                  Register                                                   */

            struct
            {
                __IOM uint32_t SO          : 10; /*!< [9..0] Sensor offset adjustment bits for multi-clock                      */
                uint32_t                   : 6;
                __IOM uint32_t OFFSETCOEFF : 16; /*!< [31..16] Offset coefficient bits for multi-clock                          */
            } CTSUMACT1_b;
        };

        struct
        {
            __IOM uint16_t CTSUMACT1L; /*!< (@ 0x0000004C) CTSU Option Setting Register                               */
            __IOM uint16_t CTSUMACT1H; /*!< (@ 0x0000004E) CTSU Option Setting Register                               */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUMACT2;            /*!< (@ 0x00000050) Multi-Clock Automatic Correction Table Access
                                                  *                  Register                                                   */

            struct
            {
                __IOM uint32_t SO          : 10; /*!< [9..0] Sensor offset adjustment bits for multi-clock                      */
                uint32_t                   : 6;
                __IOM uint32_t OFFSETCOEFF : 16; /*!< [31..16] Offset coefficient bits for multi-clock                          */
            } CTSUMACT2_b;
        };

        struct
        {
            __IOM uint16_t CTSUMACT2L; /*!< (@ 0x00000050) CTSU Option Setting Register                               */
            __IOM uint16_t CTSUMACT2H; /*!< (@ 0x00000052) CTSU Option Setting Register                               */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUMACT3;            /*!< (@ 0x00000054) Multi-Clock Automatic Correction Table Access
                                                  *                  Register                                                   */

            struct
            {
                __IOM uint32_t SO          : 10; /*!< [9..0] Sensor offset adjustment bits for multi-clock                      */
                uint32_t                   : 6;
                __IOM uint32_t OFFSETCOEFF : 16; /*!< [31..16] Offset coefficient bits for multi-clock                          */
            } CTSUMACT3_b;
        };

        struct
        {
            __IOM uint16_t CTSUMACT3L; /*!< (@ 0x00000054) CTSU Option Setting Register                               */
            __IOM uint16_t CTSUMACT3H; /*!< (@ 0x00000056) CTSU Option Setting Register                               */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUAJCR;       /*!< (@ 0x00000058) CTSU Automatic Judgment Control Registe                    */

            struct
            {
                __IOM uint32_t TLOT   : 8; /*!< [7..0] Non-Touch Judgment Criterion Setting                               */
                __IOM uint32_t THOT   : 8; /*!< [15..8] Touch Judgment Criterion Setting                                  */
                __IOM uint32_t BLINI  : 1; /*!< [16..16] Baseline Initialization                                          */
                uint32_t              : 3;
                __IOM uint32_t JC     : 2; /*!< [21..20] Judgment Condition Setting                                       */
                uint32_t              : 2;
                __IOM uint32_t AJMMAT : 4; /*!< [27..24] Measured Value Moving Average Number Setting                     */
                __IOM uint32_t AJBMAT : 4; /*!< [31..28] Baseline Average Number Setting                                  */
            } CTSUAJCR_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t CTSUAJCRL; /*!< (@ 0x00000058) CTSU Automatic Judgment Control Register                   */

                struct
                {
                    __IOM uint8_t AJCR0;  /*!< (@ 0x00000058) CTSU Automatic Judgment Control Register                   */
                    __IOM uint8_t AJCR1;  /*!< (@ 0x00000059) CTSU Automatic Judgment Control Register                   */
                };
            };

            union
            {
                __IOM uint16_t CTSUAJCRH; /*!< (@ 0x0000005A) CTSU Automatic Judgment Control Register                   */

                struct
                {
                    __IOM uint8_t AJCR2;  /*!< (@ 0x0000005A) CTSU Automatic Judgment Control Register                   */
                    __IOM uint8_t AJCR3;  /*!< (@ 0x0000005B) CTSU Automatic Judgment Control Register                   */
                };
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUAJTHR;      /*!< (@ 0x0000005C) CTSU Automatic Judgment Control Register                   */

            struct
            {
                __IOM uint32_t AJTHL : 16; /*!< [15..0] Lower Threshold Setting                                           */
                __IOM uint32_t AJTHH : 16; /*!< [31..16] Upper Threshold Setting                                          */
            } CTSUAJTHR_b;
        };

        struct
        {
            __IOM uint16_t CTSUAJTHRL; /*!< (@ 0x0000005C) CTSU Automatic Judgment Control Register                   */
            __IOM uint16_t CTSUAJTHRH; /*!< (@ 0x0000005E) CTSU Automatic Judgment Control Register                   */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUAJMMAR;       /*!< (@ 0x00000060) CTSU Threshold Register                                    */

            struct
            {
                __IOM uint32_t AJMMATI : 4;  /*!< [3..0] Moving Average Count                                               */
                uint32_t               : 1;
                __IOM uint32_t AJMMR   : 27; /*!< [31..5] Moving Average Result                                             */
            } CTSUAJMMAR_b;
        };

        struct
        {
            __IOM uint16_t CTSUAJMMARL; /*!< (@ 0x00000060) CTSU Threshold Register                                    */
            __IOM uint16_t CTSUAJMMARH; /*!< (@ 0x00000062) CTSU Threshold Register                                    */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUAJBLACT;      /*!< (@ 0x00000064) CTSU Baseline Average Intermediate Result Register         */

            struct
            {
                __IOM uint32_t AJBLACT : 32; /*!< [31..0] Automatic determination baseline average calculation
                                              *   bits                                                                      */
            } CTSUAJBLACT_b;
        };

        struct
        {
            __IOM uint16_t CTSUAJBLACTL; /*!< (@ 0x00000064) CTSU Baseline Average Intermediate Result Register         */
            __IOM uint16_t CTSUAJBLACTH; /*!< (@ 0x00000066) CTSU Baseline Average Intermediate Result Register         */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUAJBLAR;      /*!< (@ 0x00000068) CTSU Baseline Average Result Register                      */

            struct
            {
                __IOM uint32_t AJBLAC : 16; /*!< [15..0] Baseline Average Count                                            */
                __IOM uint32_t AJBLAR : 16; /*!< [31..16] Baseline Average Result                                          */
            } CTSUAJBLAR_b;
        };

        struct
        {
            __IOM uint16_t CTSUAJBLARL; /*!< (@ 0x00000068) CTSU Baseline Average Result Register                      */
            __IOM uint16_t CTSUAJBLARH; /*!< (@ 0x0000006A) CTSU Baseline Average Result Register                      */
        };
    };

    union
    {
        union
        {
            __IOM uint32_t CTSUAJRR;      /*!< (@ 0x0000006C) CTSU Automatic Judgment Result Register                    */

            struct
            {
                __IOM uint32_t TJR0 : 1;  /*!< [0..0] The judgment result when using SUCLK0 is stored.                   */
                __IOM uint32_t TJR1 : 1;  /*!< [1..1] The judgment result when using SUCLK1 is stored.                   */
                __IOM uint32_t TJR2 : 1;  /*!< [2..2] The judgment result when using SUCLK2 is stored.                   */
                __IOM uint32_t TJR3 : 1;  /*!< [3..3] The judgment result when using SUCLK3 is stored.                   */
                __IOM uint32_t FJR  : 1;  /*!< [4..4] The final judgment result on multi-clock measurement
                                           *   is stored.                                                                */
                uint32_t             : 3;
                __IOM uint32_t SJCCR : 8; /*!< [15..8] Remaining Number of Consecutive Detections                        */
                uint32_t             : 16;
            } CTSUAJRR_b;
        };
        __IOM uint16_t CTSUAJRRL;         /*!< (@ 0x0000006C) CTSU Automatic Judgment Result Register                    */

        struct
        {
            __IOM uint8_t CTSUAJRR0;      /*!< (@ 0x0000006C) CTSU Automatic Judgment Result Register                    */
            __IOM uint8_t CTSUAJRR1;      /*!< (@ 0x0000006D) CTSU Automatic Judgment Result Register                    */
        };
    };
} R_CTSU2_Type;                           /*!< Size = 112 (0x70)                                                         */

/* =========================================================================================================================== */
/* ================                                           R_DAC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief D/A Converter (R_DAC)
 */

typedef struct                         /*!< (@ 0x4005E000) R_DAC Structure                                            */
{
    union
    {
        __IOM uint16_t DADR[2];        /*!< (@ 0x00000000) D/A Data Register                                          */

        struct
        {
            __IOM uint16_t DADR : 16;  /*!< [15..0] D/A Data RegisterNOTE: When DADPR.DPSEL = 0, the high-order
                                        *   4 bits are fixed to 0: right justified format. When DADPR.DPSEL
                                        *   = 1, the low-order 4 bits are fixed to 0: left justified
                                        *   format.                                                                   */
        } DADR_b[2];
    };

    union
    {
        __IOM uint8_t DACR;            /*!< (@ 0x00000004) D/A Control Register                                       */

        struct
        {
            uint8_t             : 5;
            __IOM uint8_t DAE   : 1;   /*!< [5..5] D/A Enable                                                         */
            __IOM uint8_t DAOE0 : 1;   /*!< [6..6] D/A Output Enable 0                                                */
            __IOM uint8_t DAOE1 : 1;   /*!< [7..7] D/A Output Enable 0                                                */
        } DACR_b;
    };

    union
    {
        __IOM uint8_t DADPR;           /*!< (@ 0x00000005) DADR0 Format Select Register                               */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t DPSEL : 1;   /*!< [7..7] DADRm Format Select                                                */
        } DADPR_b;
    };

    union
    {
        __IOM uint8_t DAADSCR;         /*!< (@ 0x00000006) D/A-A/D Synchronous Start Control Register                 */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t DAADST : 1;  /*!< [7..7] D/A-A/D Synchronous Conversion                                     */
        } DAADSCR_b;
    };

    union
    {
        __IOM uint8_t DAVREFCR;        /*!< (@ 0x00000007) D/A VREF Control Register                                  */

        struct
        {
            __IOM uint8_t REF : 3;     /*!< [2..0] D/A Reference Voltage Select                                       */
            uint8_t           : 5;
        } DAVREFCR_b;
    };

    union
    {
        __IOM uint8_t DAAMPCR;         /*!< (@ 0x00000008) D/A Output Amplifier Control Register                      */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t DAAMP0 : 1;  /*!< [6..6] Amplifier Control                                                  */
            __IOM uint8_t DAAMP1 : 1;  /*!< [7..7] Amplifier Control                                                  */
        } DAAMPCR_b;
    };

    union
    {
        __IOM uint8_t DAPC;            /*!< (@ 0x00000009) D/A Switch Charge Pump Control Register                    */

        struct
        {
            __IOM uint8_t PUMPEN : 1;  /*!< [0..0] Charge Pump Enable                                                 */
            uint8_t              : 7;
        } DAPC_b;
    };
    __IM uint16_t RESERVED[9];

    union
    {
        __IOM uint8_t DAASWCR;         /*!< (@ 0x0000001C) D/A Amplifier Stabilization Wait Control Register          */

        struct
        {
            uint8_t              : 6;
            __IOM uint8_t DAASW0 : 1;  /*!< [6..6] Set the DAASW0 bit to 1 in the initialization procedure
                                        *   to wait for stabilization of the output amplifier of D/A
                                        *   channel 0. When DAASW0 is set to 1, D/A conversion operates,
                                        *   but the conversion result D/A is not output from channel
                                        *   0. When the DAASW0 bit is 0, the stabilization wait time
                                        *   stops, and the D/A conversion result of channel 0 is output
                                        *   through the output amplifier.                                             */
            __IOM uint8_t DAASW1 : 1;  /*!< [7..7] Set the DAASW1 bit to 1 in the initialization procedure
                                        *   to wait for stabilization of the output amplifier of D/A
                                        *   channel 1. When DAASW1 is set to 1, D/A conversion operates,
                                        *   but the conversion result D/A is not output from channel
                                        *   1. When the DAASW1 bit is 0, the stabilization wait time
                                        *   stops, and the D/A conversion result of channel 1 is output
                                        *   through the output amplifier.                                             */
        } DAASWCR_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2[2129];

    union
    {
        __IOM uint8_t DAADUSR;          /*!< (@ 0x000010C0) D/A A/D Synchronous Unit Select Register                   */

        struct
        {
            __IOM uint8_t AMADSEL0 : 1; /*!< [0..0] The DAADUSR register selects the target ADC12 unit for
                                         *   D/A and A/D synchronous conversions. Set bit [0] to 1 to
                                         *   select unit 0 as the target synchronous unit for the MCU.
                                         *   When setting the DAADSCR.DAADST bit to 1 for synchronous
                                         *   conversions, select the target unit in this register in
                                         *   advance. Only set the DAADUSR register while the ADCSR.ADST
                                         *   bit of the ADC12 is set to 0 and the DAADSCR.DAADST bit
                                         *   is set to 0.                                                              */
            __IOM uint8_t AMADSEL1 : 1; /*!< [1..1] The DAADUSR register selects the target ADC12 unit for
                                         *   D/A and A/D synchronous conversions. Set bit [1] to 1 to
                                         *   select unit 1 as the target synchronous unit for the MCU.
                                         *   When setting the DAADSCR.DAADST bit to 1 for synchronous
                                         *   conversions, select the target unit in this register in
                                         *   advance. Only set the DAADUSR register while the ADCSR.ADST
                                         *   bit of the ADC12 is set to 0 and the DAADSCR.DAADST bit
                                         *   is set to 0.                                                              */
            uint8_t : 6;
        } DAADUSR_b;
    };
    __IM uint8_t  RESERVED3;
    __IM uint16_t RESERVED4;
} R_DAC_Type;                          /*!< Size = 4292 (0x10c4)                                                      */

/* =========================================================================================================================== */
/* ================                                          R_DEBUG                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Debug Function (R_DEBUG)
 */

typedef struct                         /*!< (@ 0x4001B000) R_DEBUG Structure                                          */
{
    union
    {
        __IM uint32_t DBGSTR;          /*!< (@ 0x00000000) Debug Status Register                                      */

        struct
        {
            uint32_t                   : 28;
            __IM uint32_t CDBGPWRUPREQ : 1; /*!< [28..28] Debug power-up request                                           */
            __IM uint32_t CDBGPWRUPACK : 1; /*!< [29..29] Debug power-up acknowledge                                       */
            uint32_t                   : 2;
        } DBGSTR_b;
    };
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint32_t DBGSTOPCR;             /*!< (@ 0x00000010) Debug Stop Control Register                                */

        struct
        {
            __IOM uint32_t DBGSTOP_IWDT  : 1; /*!< [0..0] Mask bit for IWDT reset/interrupt                                  */
            __IOM uint32_t DBGSTOP_WDT   : 1; /*!< [1..1] Mask bit for WDT reset/interrupt                                   */
            uint32_t                     : 12;
            __IOM uint32_t DBGSTOP_TIM   : 1; /*!< [14..14] Mask bit for RTC, TAU reset/interrupt                            */
            __IOM uint32_t DBGSTOP_SIR   : 1; /*!< [15..15] Mask bit for SAU, IICA, PORT_IRQ0-5 reset/interrupt              */
            __IOM uint32_t DBGSTOP_LVD0  : 1; /*!< [16..16] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD1  : 1; /*!< [17..17] Mask bit for LVD reset/interupt                                  */
            __IOM uint32_t DBGSTOP_LVD2  : 1; /*!< [18..18] Mask bit for LVD reset/interupt                                  */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_RPER  : 1; /*!< [24..24] Mask bit for SRAM parity error                                   */
            __IOM uint32_t DBGSTOP_RECCR : 1; /*!< [25..25] Mask bit for SRAM ECC error                                      */
            uint32_t                     : 5;
            __IOM uint32_t DBGSTOP_CPER  : 1; /*!< [31..31] Mask bit for Cache SRAM parity error reset/interrupt             */
        } DBGSTOPCR_b;
    };
    __IM uint32_t RESERVED1[123];

    union
    {
        __IOM uint32_t FSBLSTAT;       /*!< (@ 0x00000200) First Stage Boot Loader Status Register                    */

        struct
        {
            __IOM uint32_t CS     : 1; /*!< [0..0] FSBL completion status.                                            */
            __IOM uint32_t RS     : 1; /*!< [1..1] FSBL result status.                                                */
            uint32_t              : 6;
            __IM uint32_t FSBLCLK : 3; /*!< [10..8] System clock frequency selection during FSBL execution            */
            uint32_t              : 21;
        } FSBLSTAT_b;
    };
} R_DEBUG_Type;                        /*!< Size = 516 (0x204)                                                        */

/* =========================================================================================================================== */
/* ================                                           R_DOC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Operation Circuit (R_DOC)
 */

typedef struct                         /*!< (@ 0x40054100) R_DOC Structure                                            */
{
    union
    {
        __IOM uint8_t DOCR;            /*!< (@ 0x00000000) DOC Control Register                                       */

        struct
        {
            __IOM uint8_t OMS     : 2; /*!< [1..0] Operating Mode Select                                              */
            __IOM uint8_t DCSEL   : 1; /*!< [2..2] Detection Condition Select                                         */
            uint8_t               : 2;
            __IM uint8_t  DOPCF   : 1; /*!< [5..5] Data Operation Circuit Flag                                        */
            __IOM uint8_t DOPCFCL : 1; /*!< [6..6] DOPCF Clear                                                        */
            uint8_t               : 1;
        } DOCR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t DODIR;          /*!< (@ 0x00000002) DOC Data Input Register                                    */

        struct
        {
            __IOM uint16_t DODIR : 16; /*!< [15..0] 16-bit read-write register in which 16-bit data for
                                        *   use in the operations are stored.                                         */
        } DODIR_b;
    };

    union
    {
        __IOM uint16_t DODSR;          /*!< (@ 0x00000004) DOC Data Setting Register                                  */

        struct
        {
            __IOM uint16_t DODSR : 16; /*!< [15..0] This register stores 16-bit data for use as a reference
                                        *   in data comparison mode. This register also stores the
                                        *   results of operations in data addition and data subtraction
                                        *   modes.                                                                    */
        } DODSR_b;
    };
} R_DOC_Type;                          /*!< Size = 6 (0x6)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_DTC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Data Transfer Controller (R_DTC)
 */

typedef struct                         /*!< (@ 0x40005400) R_DTC Structure                                            */
{
    union
    {
        __IOM uint8_t DTCCR;           /*!< (@ 0x00000000) DTC Control Register                                       */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t RRS : 1;     /*!< [4..4] DTC Transfer Information Read Skip Enable.                         */
            uint8_t           : 3;
        } DTCCR_b;
    };
    __IM uint8_t  RESERVED;
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint32_t DTCVBR;          /*!< (@ 0x00000004) DTC Vector Base Register                                   */

        struct
        {
            __IOM uint32_t DTCVBR : 32; /*!< [31..0] DTC Vector Base Address.                                          */
        } DTCVBR_b;
    };

    union
    {
        __IOM uint8_t DTCADMOD;        /*!< (@ 0x00000008) DTC Address Mode Register                                  */

        struct
        {
            __IOM uint8_t SHORT : 1;   /*!< [0..0] Short-Address Mode Set                                             */
            uint8_t             : 7;
        } DTCADMOD_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint8_t DTCST;           /*!< (@ 0x0000000C) DTC Module Start Register                                  */

        struct
        {
            __IOM uint8_t DTCST : 1;   /*!< [0..0] DTC Module Start                                                   */
            uint8_t             : 7;
        } DTCST_b;
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IM uint16_t DTCSTS;          /*!< (@ 0x0000000E) DTC Status Register                                        */

        struct
        {
            __IM uint16_t VECN : 8;    /*!< [7..0] DTC-Activating Vector Number MonitoringThese bits indicate
                                        *   the vector number for the activating source when DTC transfer
                                        *   is in progress.The value is only valid if DTC transfer
                                        *   is in progress (the value of the ACT flag is 1)                           */
            uint16_t          : 7;
            __IM uint16_t ACT : 1;     /*!< [15..15] DTC Active Flag                                                  */
        } DTCSTS_b;
    };

    union
    {
        __IOM uint8_t DTCCR_SEC;       /*!< (@ 0x00000010) DTC Control Register for secure Region                     */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t RRS : 1;     /*!< [4..4] DTC Transfer Information Read Skip Enable.                         */
            uint8_t           : 3;
        } DTCCR_SEC_b;
    };
    __IM uint8_t  RESERVED5;
    __IM uint16_t RESERVED6;

    union
    {
        __IOM uint32_t DTCVBR_SEC;      /*!< (@ 0x00000014) DTC Vector Base Register for secure Region                 */

        struct
        {
            __IOM uint32_t DTCVBR : 32; /*!< [31..0] DTC Vector Base Address.                                          */
        } DTCVBR_SEC_b;
    };

    union
    {
        __IOM uint32_t DTCDISP;          /*!< (@ 0x00000018) DTC Address Displacement Register                          */

        struct
        {
            __IOM uint32_t DTCDISP : 32; /*!< [31..0] DTC Address Displacement                                          */
        } DTCDISP_b;
    };
    __IM uint32_t RESERVED7;

    union
    {
        __IOM uint32_t DTEVR;          /*!< (@ 0x00000020) DTC Error Vector Register                                  */

        struct
        {
            __IM uint32_t DTEV    : 8; /*!< [7..0] DTC Error Vector Number                                            */
            __IM uint32_t DTEVSAM : 1; /*!< [8..8] DTC Error Vector Number SA Monitor                                 */
            uint32_t              : 7;
            __IOM uint32_t DTESTA : 1; /*!< [16..16] DTC Error Status Flag                                            */
            uint32_t              : 15;
        } DTEVR_b;
    };

    union
    {
        __IOM uint32_t DTCIBR;         /*!< (@ 0x00000024) DTC Index Table Base Register                              */

        struct
        {
            uint32_t              : 10;
            __IOM uint32_t DTCIBR : 22; /*!< [31..10] DTC Index Table Base Address                                     */
        } DTCIBR_b;
    };

    union
    {
        __IOM uint8_t DTCOR;           /*!< (@ 0x00000028) DTC Operation Register                                     */

        struct
        {
            __IOM uint8_t SQTFRL : 1;  /*!< [0..0] Sequence Transfer Stop                                             */
            uint8_t              : 7;
        } DTCOR_b;
    };
    __IM uint8_t  RESERVED8;
    __IM uint16_t RESERVED9;

    union
    {
        __IOM uint16_t DTCSQE;         /*!< (@ 0x0000002C) DTC Sequence Transfer Enable Register                      */

        struct
        {
            __IOM uint16_t VECN   : 8; /*!< [7..0] DTC Sequence Transfer Vector Number Specified                      */
            uint16_t              : 7;
            __IOM uint16_t ESPSEL : 1; /*!< [15..15] DTC Sequence Transfer Enable                                     */
        } DTCSQE_b;
    };
    __IM uint16_t RESERVED10;
} R_DTC_Type;                          /*!< Size = 48 (0x30)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_ELC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Event Link Controller (R_ELC)
 */

typedef struct                         /*!< (@ 0x40041000) R_ELC Structure                                            */
{
    union
    {
        __IOM uint8_t ELCR;            /*!< (@ 0x00000000) Event Link Controller Register                             */

        struct
        {
            uint8_t             : 7;
            __IOM uint8_t ELCON : 1;   /*!< [7..7] All Event Link Enable                                              */
        } ELCR_b;
    };
    __IM uint8_t            RESERVED;
    __IOM R_ELC_ELSEGR_Type ELSEGR[2]; /*!< (@ 0x00000002) Event Link Software Event Generation Register              */
    __IM uint16_t           RESERVED1[5];
    __IOM R_ELC_ELSR_Type   ELSR[23];  /*!< (@ 0x00000010) Event Link Setting Register [0..22]                        */
    __IM uint16_t           RESERVED2[4];

    union
    {
        __IOM uint16_t ELCSARA;         /*!< (@ 0x00000074) Event Link Controller Security Attribution Register
                                         *                  A                                                          */

        struct
        {
            __IOM uint16_t ELCR    : 1; /*!< [0..0] Event Link Controller RegisterSecurity Attribution                 */
            __IOM uint16_t ELSEGR0 : 1; /*!< [1..1] Event Link Software Event Generation Register 0 Security
                                         *   Attribution                                                               */
            __IOM uint16_t ELSEGR1 : 1; /*!< [2..2] Event Link Software Event Generation Register 1Security
                                         *   Attribution                                                               */
            uint16_t : 13;
        } ELCSARA_b;
    };
    __IM uint16_t RESERVED3;

    union
    {
        __IOM uint16_t ELCSARB;        /*!< (@ 0x00000078) Event Link Controller Security Attribution Register
                                        *                  B                                                          */

        struct
        {
            __IOM uint16_t ELSR0  : 1; /*!< [0..0] Event Link Setting Register 0Security Attribution                  */
            __IOM uint16_t ELSR1  : 1; /*!< [1..1] Event Link Setting Register 1Security Attribution                  */
            __IOM uint16_t ELSR2  : 1; /*!< [2..2] Event Link Setting Register 2Security Attribution                  */
            __IOM uint16_t ELSR3  : 1; /*!< [3..3] Event Link Setting Register 3Security Attribution                  */
            __IOM uint16_t ELSR4  : 1; /*!< [4..4] Event Link Setting Register 4Security Attribution                  */
            __IOM uint16_t ELSR5  : 1; /*!< [5..5] Event Link Setting Register 5Security Attribution                  */
            __IOM uint16_t ELSR6  : 1; /*!< [6..6] Event Link Setting Register 6Security Attribution                  */
            __IOM uint16_t ELSR7  : 1; /*!< [7..7] Event Link Setting Register 7Security Attribution                  */
            __IOM uint16_t ELSR8  : 1; /*!< [8..8] Event Link Setting Register 8Security Attribution                  */
            __IOM uint16_t ELSR9  : 1; /*!< [9..9] Event Link Setting Register 9Security Attribution                  */
            __IOM uint16_t ELSR10 : 1; /*!< [10..10] Event Link Setting Register 10Security Attribution               */
            __IOM uint16_t ELSR11 : 1; /*!< [11..11] Event Link Setting Register 11Security Attribution               */
            __IOM uint16_t ELSR12 : 1; /*!< [12..12] Event Link Setting Register 12Security Attribution               */
            __IOM uint16_t ELSR13 : 1; /*!< [13..13] Event Link Setting Register 13Security Attribution               */
            __IOM uint16_t ELSR14 : 1; /*!< [14..14] Event Link Setting Register 14Security Attribution               */
            __IOM uint16_t ELSR15 : 1; /*!< [15..15] Event Link Setting Register 15Security Attribution               */
        } ELCSARB_b;
    };
    __IM uint16_t RESERVED4;

    union
    {
        __IOM uint16_t ELCSARC;        /*!< (@ 0x0000007C) Event Link Controller Security Attribution Register
                                        *                  C                                                          */

        struct
        {
            __IOM uint16_t ELSR16 : 1; /*!< [0..0] Event Link Setting Register 16Security Attribution                 */
            __IOM uint16_t ELSR17 : 1; /*!< [1..1] Event Link Setting Register 17Security Attribution                 */
            __IOM uint16_t ELSR18 : 1; /*!< [2..2] Event Link Setting Register 18Security Attribution                 */
            uint16_t              : 13;
        } ELCSARC_b;
    };
} R_ELC_Type;                          /*!< Size = 126 (0x7e)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_FACI_LP                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Flash Application Command Interface (R_FACI_LP)
 */

typedef struct                         /*!< (@ 0x407EC000) R_FACI_LP Structure                                        */
{
    __IM uint32_t RESERVED[36];
    __IOM uint8_t DFLCTL;              /*!< (@ 0x00000090) Flash P/E Mode Control Register                            */
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3[27];

    union
    {
        __IOM uint8_t FPMCR;           /*!< (@ 0x00000100) Flash P/E Mode Control Register                            */

        struct
        {
            uint8_t            : 1;
            __IOM uint8_t FMS0 : 1;    /*!< [1..1] Flash Operating Mode Select 0FMS2,1,0: 000: Read mode
                                        *   011: Discharge mode 1 111: Discharge mode 2 101: Code Flash
                                        *   P/E mode 010: Data flash P/E mode Others: Setting prohibited.             */
            uint8_t             : 1;
            __IOM uint8_t RPDIS : 1;   /*!< [3..3] Code Flash P/E Disable                                             */
            __IOM uint8_t FMS1  : 1;   /*!< [4..4] The bit to make data flash a programming modeRefer to
                                        *   the description of the FMS0 bit.                                          */
            uint8_t            : 1;
            __IOM uint8_t VLPE : 1;    /*!< [6..6] Low-Voltage P/E Mode Enable                                        */
            __IOM uint8_t FMS2 : 1;    /*!< [7..7] Flash Operating Mode Select 2.Refer to the description
                                        *   of the FMS0 bit.                                                          */
        } FPMCR_b;
    };
    __IM uint8_t  RESERVED4;
    __IM uint16_t RESERVED5;

    union
    {
        __IOM uint8_t FASR;            /*!< (@ 0x00000104) Flash Area Select Register                                 */

        struct
        {
            __IOM uint8_t EXS : 1;     /*!< [0..0] Extra area select                                                  */
            uint8_t           : 7;
        } FASR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint16_t FSARL;             /*!< (@ 0x00000108) Flash Processing Start Address Register L                  */

        struct
        {
            __IOM uint16_t FSAR15_0 : 16; /*!< [15..0] Start address                                                     */
        } FSARL_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9;

    union
    {
        __IOM uint16_t FSARH;             /*!< (@ 0x00000110) Flash Processing Start Address Register H                  */

        struct
        {
            __IOM uint16_t FSAR20_16 : 5; /*!< [4..0] Start address                                                      */
            uint16_t                 : 4;
            __IOM uint16_t FSAR31_25 : 7; /*!< [15..9] Start address                                                     */
        } FSARH_b;
    };
    __IM uint16_t RESERVED10;

    union
    {
        __IOM uint8_t FCR;             /*!< (@ 0x00000114) Flash Control Register                                     */

        struct
        {
            __IOM uint8_t CMD  : 4;    /*!< [3..0] Software Command Setting                                           */
            __IOM uint8_t DRC  : 1;    /*!< [4..4] Data Read Completion                                               */
            uint8_t            : 1;
            __IOM uint8_t STOP : 1;    /*!< [6..6] Forced Processing Stop                                             */
            __IOM uint8_t OPST : 1;    /*!< [7..7] Processing Start                                                   */
        } FCR_b;
    };
    __IM uint8_t  RESERVED11;
    __IM uint16_t RESERVED12;

    union
    {
        __IOM uint16_t FEARL;             /*!< (@ 0x00000118) Flash Processing End Address Register L                    */

        struct
        {
            __IOM uint16_t FEAR15_0 : 16; /*!< [15..0] End address                                                       */
        } FEARL_b;
    };
    __IM uint16_t RESERVED13;
    __IM uint32_t RESERVED14;

    union
    {
        __IOM uint32_t FEARH;             /*!< (@ 0x00000120) Flash Processing End Address Register H                    */

        struct
        {
            __IOM uint32_t FEAR20_16 : 5; /*!< [4..0] End address                                                        */
            uint32_t                 : 4;
            __IOM uint32_t FEAR31_25 : 7; /*!< [15..9] End address                                                       */
            uint32_t                 : 16;
        } FEARH_b;
    };

    union
    {
        __IOM uint32_t FRESETR;        /*!< (@ 0x00000124) Flash Reset Register                                       */

        struct
        {
            __IOM uint32_t FRESET : 1; /*!< [0..0] Software Reset of the registers                                    */
            uint32_t              : 31;
        } FRESETR_b;
    };

    union
    {
        __IM uint32_t FSTATR00;         /*!< (@ 0x00000128) Flash Status Register00                                    */

        struct
        {
            __IM uint32_t ERERR0   : 1; /*!< [0..0] Erase Error Flag0                                                  */
            __IM uint32_t PRGERR0  : 1; /*!< [1..1] Program Error Flag0                                                */
            __IM uint32_t PRGERR01 : 1; /*!< [2..2] Program Error Flag 01                                              */
            __IM uint32_t BCERR0   : 1; /*!< [3..3] Blank Check Error Flag0                                            */
            __IM uint32_t ILGLERR  : 1; /*!< [4..4] Illegal Command Error Flag                                         */
            __IM uint32_t EILGLERR : 1; /*!< [5..5] Extra Area Illegal Command Error Flag                              */
            uint32_t               : 26;
        } FSTATR00_b;
    };

    union
    {
        __IM uint32_t FSTATR1;         /*!< (@ 0x0000012C) Flash Status Register1                                     */

        struct
        {
            uint32_t            : 1;
            __IM uint32_t DRRDY : 1;   /*!< [1..1] Data read request                                                  */
            uint32_t            : 4;
            __IM uint32_t FRDY  : 1;   /*!< [6..6] End status signal of a sequencer                                   */
            __IM uint32_t EXRDY : 1;   /*!< [7..7] End status signal of a Extra programming sequencer                 */
            uint32_t            : 24;
        } FSTATR1_b;
    };

    union
    {
        __IOM uint32_t FWBL0;          /*!< (@ 0x00000130) Flash Write Buffer Register L0                             */

        struct
        {
            __IOM uint32_t WDATA : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t             : 16;
        } FWBL0_b;
    };
    __IM uint32_t RESERVED15;

    union
    {
        __IOM uint32_t FWBH0;          /*!< (@ 0x00000138) Flash Write Buffer Register H0                             */

        struct
        {
            __IOM uint32_t WDATA : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t             : 16;
        } FWBH0_b;
    };

    union
    {
        __IM uint32_t FSTATR01;        /*!< (@ 0x0000013C) Flash Status Register01                                    */

        struct
        {
            __IM uint32_t ERERR1  : 1; /*!< [0..0] Erase Error Flag1                                                  */
            __IM uint32_t PRGERR1 : 1; /*!< [1..1] Program Error Flag1                                                */
            uint32_t              : 1;
            __IM uint32_t BCERR1  : 1; /*!< [3..3] Blank Check Error Flag1                                            */
            uint32_t              : 28;
        } FSTATR01_b;
    };

    union
    {
        __IOM uint32_t FWBL1;               /*!< (@ 0x00000140) Flash Write Buffer Register L1                             */

        struct
        {
            __IOM uint32_t WDATA47_32 : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t                  : 16;
        } FWBL1_b;
    };

    union
    {
        __IOM uint32_t FWBH1;               /*!< (@ 0x00000144) Flash Write Buffer Register H1                             */

        struct
        {
            __IOM uint32_t WDATA63_48 : 16; /*!< [15..0] Program data of the program command                               */
            uint32_t                  : 16;
        } FWBH1_b;
    };

    union
    {
        __IM uint32_t FRBL1;               /*!< (@ 0x00000148) Flash Read Buffer Register L1                              */

        struct
        {
            __IM uint32_t RDATA47_32 : 16; /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t                 : 16;
        } FRBL1_b;
    };

    union
    {
        __IM uint32_t FRBH1;               /*!< (@ 0x0000014C) Flash Read Buffer Register H1                              */

        struct
        {
            __IM uint32_t RDATA63_48 : 16; /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t                 : 16;
        } FRBH1_b;
    };
    __IM uint32_t RESERVED16[12];

    union
    {
        __OM uint32_t FPR;             /*!< (@ 0x00000180) Protection Unlock Register                                 */

        struct
        {
            __OM uint32_t FPR : 8;     /*!< [7..0] Protection Unlock Register                                         */
            uint32_t          : 24;
        } FPR_b;
    };

    union
    {
        __IM uint32_t FPSR;            /*!< (@ 0x00000184) Protection Unlock Status Register                          */

        struct
        {
            __IM uint32_t PERR : 1;    /*!< [0..0] Protect Error Flag                                                 */
            uint32_t           : 31;
        } FPSR_b;
    };

    union
    {
        __IM uint32_t FRBL0;           /*!< (@ 0x00000188) Flash Read Buffer Register L0                              */

        struct
        {
            __IM uint32_t RDATA : 16;  /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t            : 16;
        } FRBL0_b;
    };
    __IM uint32_t RESERVED17;

    union
    {
        __IM uint32_t FRBH0;           /*!< (@ 0x00000190) Flash Read Buffer Register H0                              */

        struct
        {
            __IM uint32_t RDATA : 16;  /*!< [15..0] Read data of the consecutive read command                         */
            uint32_t            : 16;
        } FRBH0_b;
    };
    __IM uint32_t RESERVED18[11];

    union
    {
        __IM uint32_t FSCMR;           /*!< (@ 0x000001C0) Flash Start-Up Setting Monitor Register                    */

        struct
        {
            uint32_t            : 8;
            __IM uint32_t SASMF : 1;   /*!< [8..8] Start-up Area Setting Monitor Flag                                 */
            uint32_t            : 5;
            __IM uint32_t FSPR  : 1;   /*!< [14..14] Access Window Protection Flag                                    */
            uint32_t            : 17;
        } FSCMR_b;
    };
    __IM uint32_t RESERVED19;

    union
    {
        __IM uint32_t FAWSMR;          /*!< (@ 0x000001C8) Flash Access Window Start Address Monitor Register         */

        struct
        {
            __IM uint32_t FAWS : 12;   /*!< [11..0] Flash Access Window Start Address                                 */
            uint32_t           : 20;
        } FAWSMR_b;
    };
    __IM uint32_t RESERVED20;

    union
    {
        __IM uint32_t FAWEMR;          /*!< (@ 0x000001D0) Flash Access Window End Address Monitor Register           */

        struct
        {
            __IM uint32_t FAWE : 12;   /*!< [11..0] Flash Access Window End Address                                   */
            uint32_t           : 20;
        } FAWEMR_b;
    };
    __IM uint32_t RESERVED21;

    union
    {
        __IOM uint32_t FISR;           /*!< (@ 0x000001D8) Flash Initial Setting Register                             */

        struct
        {
            __IOM uint32_t PCKA : 6;   /*!< [5..0] Peripheral Clock Notification                                      */
            __IOM uint32_t SAS  : 2;   /*!< [7..6] Temporary boot swap mode                                           */
            uint32_t            : 24;
        } FISR_b;
    };

    union
    {
        __IOM uint32_t FEXCR;          /*!< (@ 0x000001DC) Flash Extra Area Control Register                          */

        struct
        {
            __IOM uint32_t CMD  : 3;   /*!< [2..0] Processing Start)                                                  */
            uint32_t            : 4;
            __IOM uint32_t OPST : 1;   /*!< [7..7] Software Command Setting                                           */
            uint32_t            : 24;
        } FEXCR_b;
    };

    union
    {
        __IM uint32_t FEAML;           /*!< (@ 0x000001E0) Flash Error Address Monitor Register L                     */

        struct
        {
            __IM uint32_t FEAM : 16;   /*!< [15..0] Flash Error Address Monitor Register                              */
            uint32_t           : 16;
        } FEAML_b;
    };
    __IM uint32_t RESERVED22;

    union
    {
        __IM uint32_t FEAMH;           /*!< (@ 0x000001E8) Flash Error Address Monitor Register H                     */

        struct
        {
            __IM uint32_t FEAM : 16;   /*!< [15..0] Flash Error Address Monitor Register                              */
            uint32_t           : 16;
        } FEAMH_b;
    };
    __IM uint32_t RESERVED23;

    union
    {
        __IM uint32_t FSTATR2;           /*!< (@ 0x000001F0) Flash Status Register2                                     */

        struct
        {
            __IM uint32_t  ERERR    : 1; /*!< [0..0] Erase Error Flag                                                   */
            __IM uint32_t  PRGERR1  : 1; /*!< [1..1] Program Error Flag                                                 */
            __IOM uint32_t PRGERR01 : 1; /*!< [2..2] Program Error Flag 01                                              */
            __IM uint32_t  BCERR    : 1; /*!< [3..3] Blank Check Error Flag                                             */
            __IM uint32_t  ILGLERR  : 1; /*!< [4..4] Illegal Command Error Flag                                         */
            __IM uint32_t  EILGLERR : 1; /*!< [5..5] Extra Area Illegal Command Error Flag                              */
            uint32_t                : 26;
        } FSTATR2_b;
    };
    __IM uint32_t RESERVED24[3];

    union
    {
        __IOM uint8_t HIOTRM;          /*!< (@ 0x00000200) High-speed On-chip Oscillator Trimming Register            */

        struct
        {
            __IOM uint8_t HIOTRM : 6;  /*!< [5..0] HOCO User Trimming                                                 */
            uint8_t              : 2;
        } HIOTRM_b;
    };
    __IM uint8_t  RESERVED25;
    __IM uint16_t RESERVED26;
    __IM uint32_t RESERVED27;
    __IM uint16_t RESERVED28;

    union
    {
        __IOM uint8_t FLMODE;          /*!< (@ 0x0000020A) Flash Operating Mode Control Register                      */

        struct
        {
            uint8_t            : 6;
            __IOM uint8_t MODE : 2;    /*!< [7..6] Operating Mode Select                                              */
        } FLMODE_b;
    };

    union
    {
        __IOM uint8_t FLMWRP;          /*!< (@ 0x0000020B) Flash Operating Mode Protect Register                      */

        struct
        {
            __IOM uint8_t FLMWEN : 1;  /*!< [0..0] Control of Flash Operation Mode Select Register                    */
            uint8_t              : 7;
        } FLMWRP_b;
    };
    __IM uint32_t RESERVED29[89];

    union
    {
        __IOM uint32_t FCTLFR;          /*!< (@ 0x00000370) Flash Control Flag Register                                */

        struct
        {
            __IOM uint32_t BANKSWP : 3; /*!< [2..0] Bank Swap Setting                                                  */
            uint32_t               : 29;
        } FCTLFR_b;
    };
    __IM uint32_t  RESERVED30[3855];
    __IOM uint16_t FENTRYR_MF4;        /*!< (@ 0x00003FB0) Flash P/E Mode Entry Register for MF4                      */
    __IOM uint16_t FENTRYR;            /*!< (@ 0x00003FB2) Flash P/E Mode Entry Register                              */
    __IM uint32_t  RESERVED31[3];
    __IOM uint8_t  FLWAITR;            /*!< (@ 0x00003FC0) Flash Wait Cycle Register                                  */
    __IM uint8_t   RESERVED32;
    __IM uint16_t  RESERVED33;

    union
    {
        __IOM uint8_t FLDWAITR;         /*!< (@ 0x00003FC4) Memory Wait Cycle Control Register for Data Flash          */

        struct
        {
            __IOM uint8_t FLDWAIT1 : 1; /*!< [0..0] Memory Wait Cycle Select for Data Flash                            */
            uint8_t                : 7;
        } FLDWAITR_b;
    };
    __IM uint8_t  RESERVED34;
    __IM uint16_t RESERVED35;
    __IOM uint8_t PFBER;               /*!< (@ 0x00003FC8) Prefetch Buffer Enable Register                            */
    __IM uint8_t  RESERVED36;
    __IM uint16_t RESERVED37;
    __IM uint32_t RESERVED38;

    union
    {
        __IOM uint16_t FBKPGCR;        /*!< (@ 0x00003FD0) Flash Bank Program Control Register                        */

        struct
        {
            __IOM uint16_t BKPGEN : 1; /*!< [0..0] Bank Programming Setting Enable                                    */
            uint16_t              : 7;
            __OM uint16_t FEKEY   : 8; /*!< [15..8] Key Code                                                          */
        } FBKPGCR_b;
    };
    __IM uint16_t RESERVED39;

    union
    {
        __IOM uint16_t FBKSWCR;          /*!< (@ 0x00003FD4) Flash Bank Swap Control Register                           */

        struct
        {
            __IOM uint16_t BKSWUPEN : 1; /*!< [0..0] Bank Swap Update Enable                                            */
            uint16_t                : 7;
            __OM uint16_t FEKEY     : 8; /*!< [15..8] Key Code                                                          */
        } FBKSWCR_b;
    };
    __IM uint16_t RESERVED40;
} R_FACI_LP_Type;                        /*!< Size = 16344 (0x3fd8)                                                     */

/* =========================================================================================================================== */
/* ================                                        R_CTSUTRIM                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief CTSU Trimming Registers (R_CTSUTRIM)
 */

typedef struct                         /*!< (@ 0x407EC000) R_CTSUTRIM Structure                                       */
{
    __IM uint32_t RESERVED[233];

    union
    {
        __IOM uint32_t CTSUTRIMA;         /*!< (@ 0x000003A4) CTSU Trimming Register A                                   */

        struct
        {
            __IOM uint32_t RTRIM     : 8; /*!< [7..0] CTSU Reference Resistance Adjustment                               */
            __IOM uint32_t DACTRIM   : 8; /*!< [15..8] Linearity Adjustment of Offset Current                            */
            __IOM uint32_t SUADJD    : 8; /*!< [23..16] CTSU SUCLK Frequency Adjustment                                  */
            __IOM uint32_t SUADJTRIM : 8; /*!< [31..24] Coefficient of variation for the reference load resistance
                                           *   (120k)                                                                    */
        } CTSUTRIMA_b;
    };

    union
    {
        __IOM uint32_t CTSUTRIMB;        /*!< (@ 0x000003A8) CTSU Trimming Register B                                   */

        struct
        {
            __IOM uint32_t TRESULT0 : 8; /*!< [7..0] Coefficient of variation for the reference load resistance
                                          *   (7.5k)                                                                    */
            __IOM uint32_t TRESULT1 : 8; /*!< [15..8] Coefficient of variation for the reference load resistance
                                          *   (15k)                                                                     */
            __IOM uint32_t TRESULT2 : 8; /*!< [23..16] Coefficient of variation for the reference load resistance
                                          *   (30k)                                                                     */
            __IOM uint32_t TRESULT3 : 8; /*!< [31..24] Coefficient of variation for the reference load resistance
                                          *   (60k)                                                                     */
        } CTSUTRIMB_b;
    };
} R_CTSUTRIM_Type;                       /*!< Size = 940 (0x3ac)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_GPT0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief General PWM Timer (R_GPT0)
 */

typedef struct                         /*!< (@ 0x40078000) R_GPT0 Structure                                           */
{
    union
    {
        __IOM uint32_t GTWP;           /*!< (@ 0x00000000) General PWM Timer Write-Protection Register                */

        struct
        {
            __IOM uint32_t WP    : 1;  /*!< [0..0] Register Write Disable                                             */
            __IOM uint32_t STRWP : 1;  /*!< [1..1] GTSTR.CSTRT Bit Write Disable                                      */
            __IOM uint32_t STPWP : 1;  /*!< [2..2] GTSTP.CSTOP Bit Write Disable                                      */
            __IOM uint32_t CLRWP : 1;  /*!< [3..3] GTCLR.CCLR Bit Write Disable                                       */
            __IOM uint32_t CMNWP : 1;  /*!< [4..4] Common Register Write Disabled                                     */
            uint32_t             : 3;
            __OM uint32_t PRKEY  : 8;  /*!< [15..8] GTWP Key Code                                                     */
            uint32_t             : 16;
        } GTWP_b;
    };

    union
    {
        __IOM uint32_t GTSTR;           /*!< (@ 0x00000004) General PWM Timer Software Start Register                  */

        struct
        {
            __IOM uint32_t CSTRT0 : 1;  /*!< [0..0] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT1 : 1;  /*!< [1..1] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT2 : 1;  /*!< [2..2] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT3 : 1;  /*!< [3..3] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT4 : 1;  /*!< [4..4] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT5 : 1;  /*!< [5..5] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT6 : 1;  /*!< [6..6] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT7 : 1;  /*!< [7..7] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT8 : 1;  /*!< [8..8] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT9 : 1;  /*!< [9..9] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT10 : 1; /*!< [10..10] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT11 : 1; /*!< [11..11] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT12 : 1; /*!< [12..12] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT13 : 1; /*!< [13..13] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT14 : 1; /*!< [14..14] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT15 : 1; /*!< [15..15] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT16 : 1; /*!< [16..16] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT17 : 1; /*!< [17..17] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT18 : 1; /*!< [18..18] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT19 : 1; /*!< [19..19] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT20 : 1; /*!< [20..20] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT21 : 1; /*!< [21..21] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT22 : 1; /*!< [22..22] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT23 : 1; /*!< [23..23] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT24 : 1; /*!< [24..24] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT25 : 1; /*!< [25..25] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT26 : 1; /*!< [26..26] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT27 : 1; /*!< [27..27] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT28 : 1; /*!< [28..28] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT29 : 1; /*!< [29..29] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT30 : 1; /*!< [30..30] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
            __IOM uint32_t CSTRT31 : 1; /*!< [31..31] Channel GTCNT Count StartRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter stop. 1
                                         *   means counter running.                                                    */
        } GTSTR_b;
    };

    union
    {
        __IOM uint32_t GTSTP;           /*!< (@ 0x00000008) General PWM Timer Software Stop Register                   */

        struct
        {
            __IOM uint32_t CSTOP0 : 1;  /*!< [0..0] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP1 : 1;  /*!< [1..1] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP2 : 1;  /*!< [2..2] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP3 : 1;  /*!< [3..3] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP4 : 1;  /*!< [4..4] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP5 : 1;  /*!< [5..5] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP6 : 1;  /*!< [6..6] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP7 : 1;  /*!< [7..7] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP8 : 1;  /*!< [8..8] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP9 : 1;  /*!< [9..9] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP10 : 1; /*!< [10..10] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP11 : 1; /*!< [11..11] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP12 : 1; /*!< [12..12] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP13 : 1; /*!< [13..13] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP14 : 1; /*!< [14..14] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP15 : 1; /*!< [15..15] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP16 : 1; /*!< [16..16] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP17 : 1; /*!< [17..17] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP18 : 1; /*!< [18..18] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP19 : 1; /*!< [19..19] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP20 : 1; /*!< [20..20] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP21 : 1; /*!< [21..21] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP22 : 1; /*!< [22..22] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP23 : 1; /*!< [23..23] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP24 : 1; /*!< [24..24] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP25 : 1; /*!< [25..25] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP26 : 1; /*!< [26..26] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP27 : 1; /*!< [27..27] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP28 : 1; /*!< [28..28] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP29 : 1; /*!< [29..29] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP30 : 1; /*!< [30..30] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
            __IOM uint32_t CSTOP31 : 1; /*!< [31..31] Channel GTCNT Count StopRead data shows each channel's
                                         *   counter status (GTCR.CST bit). 0 means counter runnning.
                                         *   1 means counter stop.                                                     */
        } GTSTP_b;
    };

    union
    {
        __OM uint32_t GTCLR;           /*!< (@ 0x0000000C) General PWM Timer Software Clear Register                  */

        struct
        {
            __OM uint32_t CCLR0  : 1;  /*!< [0..0] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR1  : 1;  /*!< [1..1] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR2  : 1;  /*!< [2..2] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR3  : 1;  /*!< [3..3] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR4  : 1;  /*!< [4..4] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR5  : 1;  /*!< [5..5] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR6  : 1;  /*!< [6..6] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR7  : 1;  /*!< [7..7] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR8  : 1;  /*!< [8..8] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR9  : 1;  /*!< [9..9] Channel GTCNT Count Clear                                          */
            __OM uint32_t CCLR10 : 1;  /*!< [10..10] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR11 : 1;  /*!< [11..11] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR12 : 1;  /*!< [12..12] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR13 : 1;  /*!< [13..13] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR14 : 1;  /*!< [14..14] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR15 : 1;  /*!< [15..15] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR16 : 1;  /*!< [16..16] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR17 : 1;  /*!< [17..17] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR18 : 1;  /*!< [18..18] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR19 : 1;  /*!< [19..19] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR20 : 1;  /*!< [20..20] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR21 : 1;  /*!< [21..21] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR22 : 1;  /*!< [22..22] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR23 : 1;  /*!< [23..23] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR24 : 1;  /*!< [24..24] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR25 : 1;  /*!< [25..25] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR26 : 1;  /*!< [26..26] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR27 : 1;  /*!< [27..27] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR28 : 1;  /*!< [28..28] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR29 : 1;  /*!< [29..29] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR30 : 1;  /*!< [30..30] Channel GTCNT Count Clear                                        */
            __OM uint32_t CCLR31 : 1;  /*!< [31..31] Channel GTCNT Count Clear                                        */
        } GTCLR_b;
    };

    union
    {
        __IOM uint32_t GTSSR;            /*!< (@ 0x00000010) General PWM Timer Start Source Select Register             */

        struct
        {
            __IOM uint32_t SSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Start Enable                */
            __IOM uint32_t SSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Start Enable               */
            __IOM uint32_t SSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Start Enable                                                      */
            __IOM uint32_t SSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Start Enable                        */
            __IOM uint32_t SSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Start Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTRT  : 1;   /*!< [31..31] Software Source Counter Start Enable                             */
        } GTSSR_b;
    };

    union
    {
        __IOM uint32_t GTPSR;            /*!< (@ 0x00000014) General PWM Timer Stop Source Select Register              */

        struct
        {
            __IOM uint32_t PSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Stop Enable                 */
            __IOM uint32_t PSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Stop Enable                */
            __IOM uint32_t PSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Stop Enable                                                       */
            __IOM uint32_t PSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Stop Enable                        */
            __IOM uint32_t PSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Stop Enable                        */
            uint32_t              : 7;
            __IOM uint32_t CSTOP  : 1;   /*!< [31..31] Software Source Counter Stop Enable                              */
        } GTPSR_b;
    };

    union
    {
        __IOM uint32_t GTCSR;            /*!< (@ 0x00000018) General PWM Timer Clear Source Select Register             */

        struct
        {
            __IOM uint32_t CSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Clear Enable                */
            __IOM uint32_t CSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Clear Enable               */
            __IOM uint32_t CSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Clear Enable                                                      */
            __IOM uint32_t CSELCA : 1;   /*!< [16..16] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCB : 1;   /*!< [17..17] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCC : 1;   /*!< [18..18] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCD : 1;   /*!< [19..19] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCE : 1;   /*!< [20..20] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCF : 1;   /*!< [21..21] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCG : 1;   /*!< [22..22] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSELCH : 1;   /*!< [23..23] ELC_GPTA Event Source Counter Clear Enable                       */
            __IOM uint32_t CSCMSC : 3;   /*!< [26..24] Compare Match/Input Capture/Synchronous counter clearing
                                          *   Source Counter Clear Enable.                                              */
            __IOM uint32_t CP1CCE : 1;   /*!< [27..27] Complementary PWM mode1 Crest Source Counter Clear
                                          *   Enable (This bit is only available in GPT324 to GPT329.
                                          *   In GPT320 to GPT323, this bit is read as 0. The write value
                                          *   should be 0.)                                                             */
            uint32_t            : 3;
            __IOM uint32_t CCLR : 1;     /*!< [31..31] Software Source Counter Clear Enable                             */
        } GTCSR_b;
    };

    union
    {
        __IOM uint32_t GTUPSR;           /*!< (@ 0x0000001C) General PWM Timer Up Count Source Select Register          */

        struct
        {
            __IOM uint32_t USGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Up Enable             */
            __IOM uint32_t USGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Up Enable            */
            __IOM uint32_t USCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Up Enable                                                   */
            __IOM uint32_t USELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Up Enable                     */
            __IOM uint32_t USILVL : 4;   /*!< [27..24] External Input Level Source Count-Up Enable                      */
            uint32_t              : 4;
        } GTUPSR_b;
    };

    union
    {
        __IOM uint32_t GTDNSR;           /*!< (@ 0x00000020) General PWM Timer Down Count Source Select Register        */

        struct
        {
            __IOM uint32_t DSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source Counter Count Down Enable           */
            __IOM uint32_t DSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source Counter Count Down Enable          */
            __IOM uint32_t DSCARBL  : 1; /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   Counter Count Down Enable                                                 */
            __IOM uint32_t DSELCA : 1;   /*!< [16..16] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCB : 1;   /*!< [17..17] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCC : 1;   /*!< [18..18] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCD : 1;   /*!< [19..19] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCE : 1;   /*!< [20..20] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCF : 1;   /*!< [21..21] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCG : 1;   /*!< [22..22] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSELCH : 1;   /*!< [23..23] ELC_GPT Event Source Counter Count Down Enable                   */
            __IOM uint32_t DSILVL : 4;   /*!< [27..24] External Input Level Source Count-Down Enable                    */
            uint32_t              : 4;
        } GTDNSR_b;
    };

    union
    {
        __IOM uint32_t GTICASR;          /*!< (@ 0x00000024) General PWM Timer Input Capture Source Select
                                          *                  Register A                                                 */

        struct
        {
            __IOM uint32_t ASGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRA Input Capture Enable         */
            __IOM uint32_t ASGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRA Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t ASCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRA Input Capture Enable                                               */
            __IOM uint32_t ASELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRA Input Capture Enable                 */
            __IOM uint32_t ASOC   : 1;   /*!< [24..24] Other channel Source GTCCRA Input Capture Enable                 */
            uint32_t              : 7;
        } GTICASR_b;
    };

    union
    {
        __IOM uint32_t GTICBSR;          /*!< (@ 0x00000028) General PWM Timer Input Capture Source Select
                                          *                  Register B                                                 */

        struct
        {
            __IOM uint32_t BSGTRGAR : 1; /*!< [0..0] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGAF : 1; /*!< [1..1] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGBR : 1; /*!< [2..2] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGBF : 1; /*!< [3..3] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGCR : 1; /*!< [4..4] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGCF : 1; /*!< [5..5] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSGTRGDR : 1; /*!< [6..6] GTETRG Pin Rising Input Source GTCCRB Input Capture Enable         */
            __IOM uint32_t BSGTRGDF : 1; /*!< [7..7] GTETRG Pin Falling Input Source GTCCRB Input Capture
                                          *   Enable                                                                    */
            __IOM uint32_t BSCARBL : 1;  /*!< [8..8] GTIOCA Pin Rising Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCARBH : 1;  /*!< [9..9] GTIOCA Pin Rising Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBL : 1;  /*!< [10..10] GTIOCA Pin Falling Input during GTIOCB Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCAFBH : 1;  /*!< [11..11] GTIOCA Pin Falling Input during GTIOCB Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAL : 1;  /*!< [12..12] GTIOCB Pin Rising Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBRAH : 1;  /*!< [13..13] GTIOCB Pin Rising Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAL : 1;  /*!< [14..14] GTIOCB Pin Falling Input during GTIOCA Value Low Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSCBFAH : 1;  /*!< [15..15] GTIOCB Pin Falling Input during GTIOCA Value High Source
                                          *   GTCCRB Input Capture Enable                                               */
            __IOM uint32_t BSELCA : 1;   /*!< [16..16] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCB : 1;   /*!< [17..17] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCC : 1;   /*!< [18..18] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCD : 1;   /*!< [19..19] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCE : 1;   /*!< [20..20] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCF : 1;   /*!< [21..21] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCG : 1;   /*!< [22..22] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSELCH : 1;   /*!< [23..23] ELC_GPT Event Source GTCCRB Input Capture Enable                 */
            __IOM uint32_t BSOC   : 1;   /*!< [24..24] Other channel Source GTCCRB Input Capture Enable                 */
            uint32_t              : 7;
        } GTICBSR_b;
    };

    union
    {
        __IOM uint32_t GTCR;            /*!< (@ 0x0000002C) General PWM Timer Control Register                         */

        struct
        {
            __IOM uint32_t CST     : 1; /*!< [0..0] Count Start                                                        */
            uint32_t               : 3;
            __IOM uint32_t AINV    : 1; /*!< [4..4] GTIOCnA input/output pin polarity reversal control                 */
            __IOM uint32_t BINV    : 1; /*!< [5..5] GTIOCnB input/output pin polarity reversal control                 */
            uint32_t               : 2;
            __IOM uint32_t ICDS    : 1; /*!< [8..8] Input Capture Operation Select During Count Stop                   */
            __IOM uint32_t SCGTIOC : 1; /*!< [9..9] GTIOC input Source Synchronous Clear Enable                        */
            __IOM uint32_t SSCGRP  : 2; /*!< [11..10] Synchronous Set/Clear Group Select                               */
            __IOM uint32_t CPSCD   : 1; /*!< [12..12] Complementary PWM Mode Synchronous Clear Disable                 */
            uint32_t               : 2;
            __IOM uint32_t SSCEN   : 1; /*!< [15..15] Synchronous Set/Clear Enable                                     */
            __IOM uint32_t MD      : 4; /*!< [19..16] Mode Select                                                      */
            uint32_t               : 4;
            __IOM uint32_t TPCS    : 3; /*!< [26..24] Timer Prescaler Select                                           */
            __IOM uint32_t CKEG    : 2; /*!< [28..27] Clock Edge Select                                                */
            uint32_t               : 3;
        } GTCR_b;
    };

    union
    {
        __IOM uint32_t GTUDDTYC;        /*!< (@ 0x00000030) General PWM Timer Count Direction and Duty Setting
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t UD     : 1;  /*!< [0..0] Count Direction Setting                                            */
            __IOM uint32_t UDF    : 1;  /*!< [1..1] Forcible Count Direction Setting                                   */
            uint32_t              : 14;
            __IOM uint32_t OADTY  : 2;  /*!< [17..16] GTIOCA Output Duty Setting                                       */
            __IOM uint32_t OADTYF : 1;  /*!< [18..18] Forcible GTIOCA Output Duty Setting                              */
            __IOM uint32_t OADTYR : 1;  /*!< [19..19] GTIOCA Output Value Selecting after Releasing 0 percent/100
                                         *   percent Duty Setting                                                      */
            uint32_t              : 4;
            __IOM uint32_t OBDTY  : 2;  /*!< [25..24] GTIOCB Output Duty Setting                                       */
            __IOM uint32_t OBDTYF : 1;  /*!< [26..26] Forcible GTIOCB Output Duty Setting                              */
            __IOM uint32_t OBDTYR : 1;  /*!< [27..27] GTIOCB Output Value Selecting after Releasing 0 percent/100
                                         *   percent Duty Setting                                                      */
            __IOM uint32_t OABDTYT : 1; /*!< [28..28] GTIOCnA,B pin output 0%/100% duty setting reflection
                                         *   timing setting                                                            */
            uint32_t : 3;
        } GTUDDTYC_b;
    };

    union
    {
        __IOM uint32_t GTIOR;          /*!< (@ 0x00000034) General PWM Timer I/O Control Register                     */

        struct
        {
            __IOM uint32_t GTIOA  : 5; /*!< [4..0] GTIOCA Pin Function Select                                         */
            __IOM uint32_t CPSCIR : 1; /*!< [5..5] Complementary PWM Mode Initial Output at Synchronous
                                        *   Clear Disable.(This bit is only available in GPT324 to
                                        *   GPT329. In GPT320 to GPT323, this bit is read as 0. The
                                        *   write value should be 0.)                                                 */
            __IOM uint32_t OADFLT : 1; /*!< [6..6] GTIOCA Pin Output Value Setting at the Count Stop                  */
            __IOM uint32_t OAHLD  : 1; /*!< [7..7] GTIOCA Pin Output Setting at the Start/Stop Count                  */
            __IOM uint32_t OAE    : 1; /*!< [8..8] GTIOCA Pin Output Enable                                           */
            __IOM uint32_t OADF   : 2; /*!< [10..9] GTIOCA Pin Disable Value Setting                                  */
            __IOM uint32_t OAEOCD : 1; /*!< [11..11] GTCCRA Compare Match Cycle End Output Invalidate.(This
                                        *   bit is only available in GPT324 to GPT329. In GPT320 to
                                        *   GPT323, this bit is read as 0. The write value should be
                                        *   0.)                                                                       */
            __IOM uint32_t PSYE   : 1; /*!< [12..12] PWM Synchronous output Enable                                    */
            __IOM uint32_t NFAEN  : 1; /*!< [13..13] Noise Filter A Enable                                            */
            __IOM uint32_t NFCSA  : 2; /*!< [15..14] Noise Filter A Sampling Clock Select                             */
            __IOM uint32_t GTIOB  : 5; /*!< [20..16] GTIOCB Pin Function Select                                       */
            uint32_t              : 1;
            __IOM uint32_t OBDFLT : 1; /*!< [22..22] GTIOCB Pin Output Value Setting at the Count Stop                */
            __IOM uint32_t OBHLD  : 1; /*!< [23..23] GTIOCB Pin Output Setting at the Start/Stop Count                */
            __IOM uint32_t OBE    : 1; /*!< [24..24] GTIOCB Pin Output Enable                                         */
            __IOM uint32_t OBDF   : 2; /*!< [26..25] GTIOCB Pin Disable Value Setting                                 */
            __IOM uint32_t OBEOCD : 1; /*!< [27..27] GTCCRB Compare Match Cycle End Output Invalidate.(This
                                        *   bit is only available in GPT324 to GPT329. In GPT320 to
                                        *   GPT323, this bit is read as 0. The write value should be
                                        *   0.)                                                                       */
            uint32_t             : 1;
            __IOM uint32_t NFBEN : 1;  /*!< [29..29] Noise Filter B Enable                                            */
            __IOM uint32_t NFCSB : 2;  /*!< [31..30] Noise Filter B Sampling Clock Select                             */
        } GTIOR_b;
    };

    union
    {
        __IOM uint32_t GTINTAD;          /*!< (@ 0x00000038) General PWM Timer Interrupt Output Setting Register        */

        struct
        {
            __IOM uint32_t GTINTA : 1;   /*!< [0..0] GTCCRA Register Compare Match/Input Capture Interrupt
                                          *   Enable                                                                    */
            __IOM uint32_t GTINTB : 1;   /*!< [1..1] GTCCRB Register Compare Match/Input Capture Interrupt
                                          *   Enable                                                                    */
            __IOM uint32_t GTINTC : 1;   /*!< [2..2] GTCCRC Register Compare Match/Input Capture Interrupt
                                          *   Enable                                                                    */
            __IOM uint32_t GTINTD : 1;   /*!< [3..3] GTCCRD Register Compare Match/Input Capture Interrupt
                                          *   Enable                                                                    */
            __IOM uint32_t GTINTE : 1;   /*!< [4..4] GTCCRE Register Compare Match/Input Capture Interrupt
                                          *   Enable                                                                    */
            __IOM uint32_t GTINTF : 1;   /*!< [5..5] GTCCRF Register Compare Match/Input Capture Interrupt
                                          *   Enable                                                                    */
            __IOM uint32_t GTINTPR : 2;  /*!< [7..6] GTPR Register Compare Match Interrupt Enable                       */
            __IOM uint32_t SCFA    : 1;  /*!< [8..8] GTCCRn Register Compare Match/Input Capture Source Synchronous
                                          *   Clear Enable                                                              */
            __IOM uint32_t SCFB : 1;     /*!< [9..9] GTCCRn Register Compare Match/Input Capture Source Synchronous
                                          *   Clear Enable                                                              */
            __IOM uint32_t SCFC : 1;     /*!< [10..10] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFD : 1;     /*!< [11..11] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFE : 1;     /*!< [12..12] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFF : 1;     /*!< [13..13] GTCCRn Register Compare Match/Input Capture Source
                                          *   Synchronous Clear Enable                                                  */
            __IOM uint32_t SCFPO    : 1; /*!< [14..14] Overflow Source Synchronous Clear Enable                         */
            __IOM uint32_t SCFPU    : 1; /*!< [15..15] Underflow Source Synchronous Clear Enable                        */
            __IOM uint32_t ADTRAUEN : 1; /*!< [16..16] GTADTRn Register Compare Match (Up-Counting) A/D Conversion
                                          *   Start Request Enable                                                      */
            __IOM uint32_t ADTRADEN : 1; /*!< [17..17] GTADTRn Register Compare Match (Down-Counting) A/D
                                          *   Conversion Start Request Enable                                           */
            __IOM uint32_t ADTRBUEN : 1; /*!< [18..18] GTADTRn Register Compare Match (Up-Counting) A/D Conversion
                                          *   Start Request Enable                                                      */
            __IOM uint32_t ADTRBDEN : 1; /*!< [19..19] GTADTRn Register Compare Match (Down-Counting) A/D
                                          *   Conversion Start Request Enable                                           */
            uint32_t               : 4;
            __IOM uint32_t GRP     : 2;  /*!< [25..24] Output Disable Source Select                                     */
            uint32_t               : 2;
            __IOM uint32_t GRPDTE  : 1;  /*!< [28..28] Dead Time Error Output Disable Request Enable                    */
            __IOM uint32_t GRPABH  : 1;  /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IOM uint32_t GRPABL  : 1;  /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t GTINTPC : 1;  /*!< [31..31] Period Count Function Finish Interrupt Enable                    */
        } GTINTAD_b;
    };

    union
    {
        __IOM uint32_t GTST;            /*!< (@ 0x0000003C) General PWM Timer Status Register                          */

        struct
        {
            __IOM uint32_t TCFA  : 1;   /*!< [0..0] Input Capture/Compare Match Flag A                                 */
            __IOM uint32_t TCFB  : 1;   /*!< [1..1] Input Capture/Compare Match Flag B                                 */
            __IOM uint32_t TCFC  : 1;   /*!< [2..2] Input Compare Match Flag C                                         */
            __IOM uint32_t TCFD  : 1;   /*!< [3..3] Input Compare Match Flag D                                         */
            __IOM uint32_t TCFE  : 1;   /*!< [4..4] Input Compare Match Flag E                                         */
            __IOM uint32_t TCFF  : 1;   /*!< [5..5] Input Compare Match Flag F                                         */
            __IOM uint32_t TCFPO : 1;   /*!< [6..6] Overflow Flag                                                      */
            __IOM uint32_t TCFPU : 1;   /*!< [7..7] Underflow Flag                                                     */
            __IM uint32_t  ITCNT : 3;   /*!< [10..8] GTCIV/GTCIU Interrupt Skipping Count Counter(Counter
                                         *   for counting the number of times a timer interrupt has
                                         *   been skipped.)                                                            */
            uint32_t               : 4;
            __IM uint32_t  TUCF    : 1; /*!< [15..15] Count Direction Flag                                             */
            __IOM uint32_t ADTRAUF : 1; /*!< [16..16] GTADTRA Compare Match (Up-Counting) A/D Converter Start
                                         *   Request Interrupt Enable                                                  */
            __IOM uint32_t ADTRADF : 1; /*!< [17..17] GTADTRA Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            __IOM uint32_t ADTRBUF : 1; /*!< [18..18] GTADTRB Compare Match(Up-Counting) A/D Convertor Start
                                         *   Request Flag                                                              */
            __IOM uint32_t ADTRBDF : 1; /*!< [19..19] GTADTRB Compare Match(Down-Counting) A/D Convertor
                                         *   Start Request Flag                                                        */
            uint32_t             : 4;
            __IM uint32_t ODF    : 1;   /*!< [24..24] Output Disable Flag                                              */
            uint32_t             : 3;
            __IM uint32_t  DTEF  : 1;   /*!< [28..28] Dead Time Error Flag                                             */
            __IM uint32_t  OABHF : 1;   /*!< [29..29] Same Time Output Level High Disable Request Enable               */
            __IM uint32_t  OABLF : 1;   /*!< [30..30] Same Time Output Level Low Disable Request Enable                */
            __IOM uint32_t PCF   : 1;   /*!< [31..31] Period Count Function Finish Flag                                */
        } GTST_b;
    };

    union
    {
        __IOM uint32_t GTBER;           /*!< (@ 0x00000040) General PWM Timer Buffer Enable Register                   */

        struct
        {
            __IOM uint32_t BD0     : 1; /*!< [0..0] BD[0]: GTCCR Buffer Operation Disable                              */
            __IOM uint32_t BD1     : 1; /*!< [1..1] BD[1]: GTPR Buffer Operation Disable                               */
            __IOM uint32_t BD2     : 1; /*!< [2..2] BD[2]: GTADTR Buffer Operation DisableBD                           */
            __IOM uint32_t BD3     : 1; /*!< [3..3] BD[3]: GTDV Buffer Operation DisableBD[2]                          */
            uint32_t               : 4;
            __IOM uint32_t DBRTECA : 1; /*!< [8..8] GTCCRn Register Double Buffer Repeat Operation Enable              */
            uint32_t               : 1;
            __IOM uint32_t DBRTECB : 1; /*!< [10..10] GTCCRn Register Double Buffer Repeat Operation Enable            */
            uint32_t               : 5;
            __IOM uint32_t CCRA    : 2; /*!< [17..16] GTCCRA Buffer Operation                                          */
            __IOM uint32_t CCRB    : 2; /*!< [19..18] GTCCRB Buffer Operation                                          */
            __IOM uint32_t PR      : 2; /*!< [21..20] GTPR Buffer Operation                                            */
            __OM uint32_t  CCRSWT  : 1; /*!< [22..22] GTCCRA and GTCCRB Forcible Buffer OperationThis bit
                                         *   is read as 0.                                                             */
            uint32_t             : 1;
            __IOM uint32_t ADTTA : 2;   /*!< [25..24] GTADTRA Buffer Transfer Timing Select in the Triangle
                                         *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                         *   at an underflow (in down-counting) or overflow (in up-counting)
                                         *   is performed.                                                             */
            __IOM uint32_t ADTDA : 1;   /*!< [26..26] GTADTRA Double Buffer Operation                                  */
            uint32_t             : 1;
            __IOM uint32_t ADTTB : 2;   /*!< [29..28] GTADTRB Buffer Transfer Timing Select in the Triangle
                                         *   wavesNOTE: In the Saw waves, values other than 0 0: Transfer
                                         *   at an underflow (in down-counting) or overflow (in up-counting)
                                         *   is performed.                                                             */
            __IOM uint32_t ADTDB : 1;   /*!< [30..30] GTADTRB Double Buffer Operation                                  */
            uint32_t             : 1;
        } GTBER_b;
    };

    union
    {
        __IOM uint32_t GTITC;          /*!< (@ 0x00000044) General PWM Timer Interrupt and A/D Converter
                                        *                  Start Request Skipping Setting Register                    */

        struct
        {
            __IOM uint32_t ITLA  : 1;  /*!< [0..0] GTCCRA Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLB  : 1;  /*!< [1..1] GTCCRB Compare Match/Input Capture Interrupt Link                  */
            __IOM uint32_t ITLC  : 1;  /*!< [2..2] GTCCRC Compare Match Interrupt Link                                */
            __IOM uint32_t ITLD  : 1;  /*!< [3..3] GTCCRD Compare Match Interrupt Link                                */
            __IOM uint32_t ITLE  : 1;  /*!< [4..4] GTCCRE Compare Match Interrupt Link                                */
            __IOM uint32_t ITLF  : 1;  /*!< [5..5] GTCCRF Compare Match Interrupt Link                                */
            __IOM uint32_t IVTC  : 2;  /*!< [7..6] GPT_OVF/GPT_UDF Interrupt Skipping Function Select                 */
            __IOM uint32_t IVTT  : 3;  /*!< [10..8] GPT_OVF/GPT_UDF Interrupt Skipping Count Select                   */
            uint32_t             : 1;
            __IOM uint32_t ADTAL : 1;  /*!< [12..12] GTADTRA A/D Converter Start Request Link                         */
            uint32_t             : 1;
            __IOM uint32_t ADTBL : 1;  /*!< [14..14] GTADTRB A/D Converter Start Request Link                         */
            uint32_t             : 17;
        } GTITC_b;
    };

    union
    {
        __IOM uint32_t GTCNT;          /*!< (@ 0x00000048) General PWM Timer Counter                                  */

        struct
        {
            __IOM uint32_t GTCNT : 32; /*!< [31..0] Counter                                                           */
        } GTCNT_b;
    };

    union
    {
        __IOM uint32_t GTCCR[6];       /*!< (@ 0x0000004C) General PWM Timer Compare Capture Register                 */

        struct
        {
            __IOM uint32_t GTCCR : 32; /*!< [31..0] Compare Capture Register A                                        */
        } GTCCR_b[6];
    };

    union
    {
        __IOM uint32_t GTPR;           /*!< (@ 0x00000064) General PWM Timer Cycle Setting Register                   */

        struct
        {
            __IOM uint32_t GTPR : 32;  /*!< [31..0] Cycle Setting Register                                            */
        } GTPR_b;
    };

    union
    {
        __IOM uint32_t GTPBR;          /*!< (@ 0x00000068) General PWM Timer Cycle Setting Buffer Register            */

        struct
        {
            __IOM uint32_t GTPBR : 32; /*!< [31..0] Cycle Setting Buffer Register                                     */
        } GTPBR_b;
    };

    union
    {
        __IOM uint32_t GTPDBR;          /*!< (@ 0x0000006C) General PWM Timer Cycle Setting Double-Buffer
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t GTPDBR : 32; /*!< [31..0] Cycle Setting Double-Buffer Register                              */
        } GTPDBR_b;
    };

    union
    {
        __IOM uint32_t GTADTRA;          /*!< (@ 0x00000070) A/D Converter Start Request Timing Register A              */

        struct
        {
            __IOM uint32_t GTADTRA : 32; /*!< [31..0] A/D Converter Start Request Timing Register A                     */
        } GTADTRA_b;
    };

    union
    {
        __IOM uint32_t GTADTBRA;          /*!< (@ 0x00000074) A/D Converter Start Request Timing Buffer Register
                                           *                  A                                                          */

        struct
        {
            __IOM uint32_t GTADTBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register A              */
        } GTADTBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRA;          /*!< (@ 0x00000078) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register A                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRA : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   A                                                                         */
        } GTADTDBRA_b;
    };

    union
    {
        __IOM uint32_t GTADTRB;          /*!< (@ 0x0000007C) A/D Converter Start Request Timing Register B              */

        struct
        {
            __IOM uint32_t GTADTRB : 32; /*!< [31..0] A/D Converter Start Request Timing Register B                     */
        } GTADTRB_b;
    };

    union
    {
        __IOM uint32_t GTADTBRB;          /*!< (@ 0x00000080) A/D Converter Start Request Timing Buffer Register
                                           *                  B                                                          */

        struct
        {
            __IOM uint32_t GTADTBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Buffer Register B              */
        } GTADTBRB_b;
    };

    union
    {
        __IOM uint32_t GTADTDBRB;          /*!< (@ 0x00000084) A/D Converter Start Request Timing Double-Buffer
                                            *                  Register B                                                 */

        struct
        {
            __IOM uint32_t GTADTDBRB : 32; /*!< [31..0] A/D Converter Start Request Timing Double-Buffer Register
                                            *   B                                                                         */
        } GTADTDBRB_b;
    };

    union
    {
        __IOM uint32_t GTDTCR;         /*!< (@ 0x00000088) General PWM Timer Dead Time Control Register               */

        struct
        {
            __IOM uint32_t TDE   : 1;  /*!< [0..0] Negative-Phase Waveform Setting                                    */
            uint32_t             : 3;
            __IOM uint32_t TDBUE : 1;  /*!< [4..4] GTDVU Buffer Operation Enable                                      */
            __IOM uint32_t TDBDE : 1;  /*!< [5..5] GTDVD Buffer Operation Enable                                      */
            uint32_t             : 2;
            __IOM uint32_t TDFER : 1;  /*!< [8..8] GTDVD Setting                                                      */
            uint32_t             : 23;
        } GTDTCR_b;
    };

    union
    {
        __IOM uint32_t GTDVU;          /*!< (@ 0x0000008C) General PWM Timer Dead Time Value Register U               */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Value Register U                                        */
        } GTDVU_b;
    };

    union
    {
        __IOM uint32_t GTDVD;          /*!< (@ 0x00000090) General PWM Timer Dead Time Value Register D               */

        struct
        {
            __IOM uint32_t GTDVD : 32; /*!< [31..0] Dead Time Value Register D                                        */
        } GTDVD_b;
    };

    union
    {
        __IOM uint32_t GTDBU;          /*!< (@ 0x00000094) General PWM Timer Dead Time Buffer Register U              */

        struct
        {
            __IOM uint32_t GTDVU : 32; /*!< [31..0] Dead Time Buffer Register U                                       */
        } GTDBU_b;
    };

    union
    {
        __IOM uint32_t GTDBD;          /*!< (@ 0x00000098) General PWM Timer Dead Time Buffer Register D              */

        struct
        {
            __IOM uint32_t GTDBD : 32; /*!< [31..0] Dead Time Buffer Register D                                       */
        } GTDBD_b;
    };

    union
    {
        __IM uint32_t GTSOS;           /*!< (@ 0x0000009C) General PWM Timer Output Protection Function
                                        *                  Status Register                                            */

        struct
        {
            __IM uint32_t SOS : 2;     /*!< [1..0] Output Protection Function Status                                  */
            uint32_t          : 30;
        } GTSOS_b;
    };

    union
    {
        __IOM uint32_t GTSOTR;         /*!< (@ 0x000000A0) General PWM Timer Output Protection Function
                                        *                  Temporary Release Register                                 */

        struct
        {
            __IOM uint32_t SOTR : 1;   /*!< [0..0] Output Protection Function Temporary Release                       */
            uint32_t            : 31;
        } GTSOTR_b;
    };

    union
    {
        __IOM uint32_t GTADSMR;         /*!< (@ 0x000000A4) General PWM Timer A/D Conversion Start Request
                                         *                  Signal Monitoring Register                                 */

        struct
        {
            __IOM uint32_t ADSMS0  : 2; /*!< [1..0] A/D Conversion Start Request Signal Monitor 0 Selection            */
            uint32_t               : 6;
            __IOM uint32_t ADSMEN0 : 1; /*!< [8..8] A/D Conversion Start Request Signal Monitor 0 Output
                                         *   Enabling                                                                  */
            uint32_t               : 7;
            __IOM uint32_t ADSMS1  : 2; /*!< [17..16] A/D Conversion Start Request Signal Monitor 1 Selection          */
            uint32_t               : 6;
            __IOM uint32_t ADSMEN1 : 1; /*!< [24..24] A/D Conversion Start Request Signal Monitor 1 Output
                                         *   Enabling                                                                  */
            uint32_t : 7;
        } GTADSMR_b;
    };

    union
    {
        __IOM uint32_t GTEITC;            /*!< (@ 0x000000A8) General PWM Timer Extended Interrupt Skipping
                                           *                  Counter Control Register                                   */

        struct
        {
            __IOM uint32_t EIVTC1  : 2;   /*!< [1..0] Extended Interrupt Skipping Counter 1 Count Source Select          */
            uint32_t               : 2;
            __IOM uint32_t EIVTT1  : 4;   /*!< [7..4] Extended Interrupt Skipping 1 Skipping Count Setting               */
            uint32_t               : 4;
            __IM uint32_t  EITCNT1 : 4;   /*!< [15..12] Extended Interrupt Skipping Counter 1                            */
            __IOM uint32_t EIVTC2  : 2;   /*!< [17..16] Extended Interrupt Skipping Counter 2 Count Source
                                           *   select                                                                    */
            uint32_t                 : 2;
            __IOM uint32_t EIVTT2    : 4; /*!< [23..20] Extended Interrupt Skipping 2 Skipping Count Setting             */
            __IOM uint32_t EITCNT2IV : 4; /*!< [27..24] Extended Interrupt Skipping Counter 2 Initial Value              */
            __IM uint32_t  EITCNT2   : 4; /*!< [31..28] Extended Interrupt Skipping Counter 2                            */
        } GTEITC_b;
    };

    union
    {
        __IOM uint32_t GTEITLI1;       /*!< (@ 0x000000AC) General PWM Timer Extended Interrupt Skipping
                                        *                  Setting Register 1                                         */

        struct
        {
            __IOM uint32_t EITLA : 3;  /*!< [2..0] GTCCRA Register Compare Match/Input Capture Interrupt
                                        *   Extended Skipping Function Select                                         */
            uint32_t             : 1;
            __IOM uint32_t EITLB : 3;  /*!< [6..4] GTCCRB Register Compare Match/Input Capture Interrupt
                                        *   Extended Skipping Function Select                                         */
            uint32_t             : 1;
            __IOM uint32_t EITLC : 3;  /*!< [10..8] GTCCRC Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLD : 3;  /*!< [14..12] GTCCRD Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLE : 3;  /*!< [18..16] GTCCRE Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLF : 3;  /*!< [22..20] GTCCRF Register Compare Match Interrupt Extended Skipping
                                        *   Function Select                                                           */
            uint32_t             : 1;
            __IOM uint32_t EITLV : 3;  /*!< [26..24] Overflow Interrupt Extended Skipping Function Select             */
            uint32_t             : 1;
            __IOM uint32_t EITLU : 3;  /*!< [30..28] Underflow Interrupt Extended Skipping Function Select            */
            uint32_t             : 1;
        } GTEITLI1_b;
    };

    union
    {
        __IOM uint32_t GTEITLI2;       /*!< (@ 0x000000B0) General PWM Timer Extended Interrupt Skipping
                                        *                  Setting Register 2                                         */

        struct
        {
            __IOM uint32_t EADTAL : 3; /*!< [2..0] GTADTRA Register A/D Conversion Start Request Extended
                                        *   Skipping Function Select                                                  */
            uint32_t              : 1;
            __IOM uint32_t EADTBL : 3; /*!< [6..4] GTADTRB Register A/D Conversion Start Request Extended
                                        *   Skipping Function Select                                                  */
            uint32_t : 25;
        } GTEITLI2_b;
    };

    union
    {
        __IOM uint32_t GTEITLB;         /*!< (@ 0x000000B4) General PWM Timer Extended Buffer Transfer Skipping
                                         *                  Setting Register                                           */

        struct
        {
            __IOM uint32_t EBTLCA : 3;  /*!< [2..0] GTCCRA Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t              : 1;
            __IOM uint32_t EBTLCB : 3;  /*!< [6..4] GTCCRB Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t              : 1;
            __IOM uint32_t EBTLPR : 3;  /*!< [10..8] GTPR Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t               : 5;
            __IOM uint32_t EBTLADA : 3; /*!< [18..16] GTADTRA Register Buffer Transfer Extended Skipping
                                         *   Function Select                                                           */
            uint32_t               : 1;
            __IOM uint32_t EBTLADB : 3; /*!< [22..20] GTADTRB Register Buffer Transfer Extended Skipping
                                         *   Function Select                                                           */
            uint32_t               : 1;
            __IOM uint32_t EBTLDVU : 3; /*!< [26..24] GTDVU Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t               : 1;
            __IOM uint32_t EBTLDVD : 3; /*!< [30..28] GTDVD Register Buffer Transfer Extended Skipping Function
                                         *   Select                                                                    */
            uint32_t : 1;
        } GTEITLB_b;
    };

    union
    {
        __IOM uint32_t GTICLF;           /*!< (@ 0x000000B8) General PWM Timer Inter Channel Logical Operation
                                          *                  Function Setting Register                                  */

        struct
        {
            __IOM uint32_t ICLFA    : 3; /*!< [2..0] GTIOCnA Output Logical Operation Function Select                   */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELC : 6; /*!< [9..4] Inter Channel Signal C Select                                      */
            uint32_t                : 6;
            __IOM uint32_t ICLFB    : 3; /*!< [18..16] GTIOCnB Output Logical Operation Function Select                 */
            uint32_t                : 1;
            __IOM uint32_t ICLFSELD : 6; /*!< [25..20] Inter Channel Signal D Select                                    */
            uint32_t                : 6;
        } GTICLF_b;
    };

    union
    {
        __IOM uint32_t GTPC;           /*!< (@ 0x000000BC) General PWM Timer Period Count Register                    */

        struct
        {
            __IOM uint32_t PCEN : 1;   /*!< [0..0] Period Count Function Enable                                       */
            uint32_t            : 7;
            __IOM uint32_t ASTP : 1;   /*!< [8..8] Automatic Stop Function Enable                                     */
            uint32_t            : 7;
            __IOM uint32_t PCNT : 12;  /*!< [27..16] Period Counter                                                   */
            uint32_t            : 4;
        } GTPC_b;
    };

    union
    {
        __IOM uint32_t GTADCMSC;            /*!< (@ 0x000000C0) General PWM Timer A/D Conversion Start Request
                                             *                  Compare Match Skipping Control Register                    */

        struct
        {
            __IOM uint32_t ADCMSC1 : 2;     /*!< [1..0] A/D Conversion Start Request Compare Match Skipping Counter
                                             *   1 Count Source Select                                                     */
            uint32_t               : 2;
            __IOM uint32_t ADCMST1 : 4;     /*!< [7..4] A/D Conversion Start Request Compare Match Skipping 1
                                             *   Skipping Count Setting                                                    */
            __IOM uint32_t ADCMSCNT1IV : 4; /*!< [11..8] A/D Conversion Start Request Compare Match Skipping
                                             *   Counter 1 Initial Value                                                   */
            __IM uint32_t ADCMSCNT1 : 4;    /*!< [15..12] A/D Conversion Start Request Compare Match Skipping
                                             *   Counter 1                                                                 */
            __IOM uint32_t ADCMSC2 : 2;     /*!< [17..16] A/D Conversion Start Request Compare Match Skipping
                                             *   Counter 2 Count Source Select                                             */
            uint32_t               : 2;
            __IOM uint32_t ADCMST2 : 4;     /*!< [23..20] A/D Conversion Start Request Compare Match Skipping
                                             *   2 Skipping Count Setting                                                  */
            __IOM uint32_t ADCMSCNT2IV : 4; /*!< [27..24] A/D Conversion Start Request Compare Match Skipping
                                             *   Counter 2 Initial Value                                                   */
            __IM uint32_t ADCMSCNT2 : 4;    /*!< [31..28] A/D Conversion Start Request Compare Match Skipping
                                             *   Counter 2                                                                 */
        } GTADCMSC_b;
    };

    union
    {
        __IOM uint32_t GTADCMSS;        /*!< (@ 0x000000C4) General PWM Timer A/D Conversion Start Request
                                         *                  Compare Match Skipping Setting Register                    */

        struct
        {
            __IOM uint32_t ADCMSAL : 3; /*!< [2..0] GTADTRA Register A/D Conversion Start Request Compare
                                         *   Match Skipping Function Select                                            */
            uint32_t               : 1;
            __IOM uint32_t ADCMSBL : 3; /*!< [6..4] GTADTRB Register A/D Conversion Start Request Compare
                                         *   Match Skipping Function Select                                            */
            uint32_t               : 9;
            __IOM uint32_t ADCMBSA : 3; /*!< [18..16] GTADTRA Register Buffer Transfer by A/D Conversion
                                         *   Start Request Compare Match Skipping Function Select                      */
            uint32_t               : 1;
            __IOM uint32_t ADCMBSB : 3; /*!< [22..20] GTADTRB Register Buffer Transfer by A/D Conversion
                                         *   Start Request Compare Match Skipping Function Select                      */
            uint32_t : 9;
        } GTADCMSS_b;
    };
    __IM uint32_t RESERVED[2];

    union
    {
        __IOM uint32_t GTSECSR;         /*!< (@ 0x000000D0) General PWM Timer Operation Enable Bit Simultaneous
                                         *                  Control Channel Select Register                            */

        struct
        {
            __IOM uint32_t SECSEL0 : 1; /*!< [0..0] Channel 0 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL1 : 1; /*!< [1..1] Channel 1 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL2 : 1; /*!< [2..2] Channel 2 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL3 : 1; /*!< [3..3] Channel 3 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL4 : 1; /*!< [4..4] Channel 4 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL5 : 1; /*!< [5..5] Channel 5 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL6 : 1; /*!< [6..6] Channel 6 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL7 : 1; /*!< [7..7] Channel 7 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL8 : 1; /*!< [8..8] Channel 8 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            __IOM uint32_t SECSEL9 : 1; /*!< [9..9] Channel 9 Operation Enable Bit Simultaneous Control Channel
                                         *   Select                                                                    */
            uint32_t : 22;
        } GTSECSR_b;
    };

    union
    {
        __IOM uint32_t GTSECR;         /*!< (@ 0x000000D4) General PWM Timer Operation Enable Bit Simultaneous
                                        *                  Control Register                                           */

        struct
        {
            __IOM uint32_t SBDCE : 1;  /*!< [0..0] GTCCR Register Buffer Operation Simultaneous Enable                */
            __IOM uint32_t SBDPE : 1;  /*!< [1..1] GTPR Register Buffer Operation Simultaneous Enable                 */
            __IOM uint32_t SBDAE : 1;  /*!< [2..2] GTADTR Register Buffer Operation Simultaneous Enable               */
            __IOM uint32_t SBDDE : 1;  /*!< [3..3] GTDV Register Buffer Operation Simultaneous Enable                 */
            uint32_t             : 4;
            __IOM uint32_t SBDCD : 1;  /*!< [8..8] GTCCR Register Buffer Operation Simultaneous Disable               */
            __IOM uint32_t SBDPD : 1;  /*!< [9..9] GTPR Register Buffer Operation Simultaneous Disable                */
            __IOM uint32_t SBDAD : 1;  /*!< [10..10] GTADTR Register Buffer Operation Simultaneous Disable            */
            __IOM uint32_t SBDDD : 1;  /*!< [11..11] GTDV Register Buffer Operation Simultaneous Disable              */
            uint32_t             : 4;
            __IOM uint32_t SPCE  : 1;  /*!< [16..16] Period Count Function Simultaneous Enable                        */
            __IOM uint32_t SSCE  : 1;  /*!< [17..17] Synchronous Set/Clear Simultaneous Enable                        */
            uint32_t             : 6;
            __IOM uint32_t SPCD  : 1;  /*!< [24..24] Period Count Function Simultaneous Disable                       */
            __IOM uint32_t SSCD  : 1;  /*!< [25..25] Synchronous Set/Clear Simultaneous Disable                       */
            uint32_t             : 6;
        } GTSECR_b;
    };
    __IM uint32_t RESERVED1[2];

    union
    {
        __IOM uint32_t GTBER2;         /*!< (@ 0x000000E0) General PWM Timer Buffer Enable Register 2                 */

        struct
        {
            __IOM uint32_t CCTCA : 1;  /*!< [0..0] Counter Clear Source GTCCRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTCB : 1;  /*!< [1..1] Counter Clear Source GTCCRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTPR  : 1; /*!< [2..2] Counter Clear Source GTPR Register Buffer Transfer Disable         */
            __IOM uint32_t CCTADA : 1; /*!< [3..3] Counter Clear Source GTADTRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTADB : 1; /*!< [4..4] Counter Clear Source GTADTRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CCTDV : 1;  /*!< [5..5] Counter Clear Source GTDVU/GTDVD Register Buffer Transfer
                                        *   Disable                                                                   */
            uint32_t             : 2;
            __IOM uint32_t CMTCA : 2;  /*!< [9..8] Compare Match Source GTCCRA Register Buffer Transfer
                                        *   Enable                                                                    */
            __IOM uint32_t CMTCB : 2;  /*!< [11..10] Compare Match Source GTCCRB Register Buffer Transfer
                                        *   Enable                                                                    */
            uint32_t              : 1;
            __IOM uint32_t CMTADA : 1; /*!< [13..13] Compare Match Source GTADTRA Register Buffer Transfer
                                        *   Enable                                                                    */
            __IOM uint32_t CMTADB : 1; /*!< [14..14] Compare Match Source GTADTRA Register Buffer Transfer
                                        *   Enable                                                                    */
            uint32_t             : 1;
            __IOM uint32_t CPTCA : 1;  /*!< [16..16] Overflow/Underflow Source GTCCRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTCB : 1;  /*!< [17..17] Overflow/Underflow Source GTCCRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTPR : 1;  /*!< [18..18] Overflow/Underflow Source GTPR Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTADA : 1; /*!< [19..19] Overflow/Underflow Source GTADTRA Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTADB : 1; /*!< [20..20] Overflow/Underflow Source GTADTRB Register Buffer Transfer
                                        *   Disable                                                                   */
            __IOM uint32_t CPTDV : 1;  /*!< [21..21] Overflow/Underflow Source GTDVU/GTDVD Register Buffer
                                        *   Transfer Disable                                                          */
            uint32_t             : 2;
            __IOM uint32_t CP3DB : 1;  /*!< [24..24] Complementary PWM mode 3,4 Double Buffer select                  */
            __IOM uint32_t CPBTD : 1;  /*!< [25..25] Complementary PWM mode Buffer Transfer Disable                   */
            __IOM uint32_t OLTTA : 2;  /*!< [27..26] GTIOCnA Output Level Buffer Transfer Timing Select               */
            __IOM uint32_t OLTTB : 2;  /*!< [29..28] GTIOCnB Output Level Buffer Transfer Timing Select               */
            uint32_t             : 2;
        } GTBER2_b;
    };

    union
    {
        __IOM uint32_t GTOLBR;         /*!< (@ 0x000000E4) General PWM Timer Output Level Buffer Register             */

        struct
        {
            __IOM uint32_t GTIOAB : 5; /*!< [4..0] GTIOA buffer bits                                                  */
            uint32_t              : 11;
            __IOM uint32_t GTIOBB : 5; /*!< [20..16] GTIOBB buffer bits                                               */
            uint32_t              : 11;
        } GTOLBR_b;
    };
    __IM uint32_t RESERVED2;

    union
    {
        __IOM uint32_t GTICCR;         /*!< (@ 0x000000EC) General PWM Timer Inter Channel Cooperation Input
                                        *                  Capture Control Register                                   */

        struct
        {
            __IOM uint32_t ICAFA : 1;  /*!< [0..0] Forwarding GTCCRA register Compare Match/Input Capture
                                        *   to Other Channel GTCCRA Input Capture Source Enable                       */
            __IOM uint32_t ICAFB : 1;  /*!< [1..1] Forwarding GTCCRB register Compare Match/Input Capture
                                        *   to Other Channel GTCCRA Input Capture Source Enable                       */
            __IOM uint32_t ICAFC : 1;  /*!< [2..2] Forwarding GTCCRC register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFD : 1;  /*!< [3..3] Forwarding GTCCRD register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFE : 1;  /*!< [4..4] Forwarding GTCCRE register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFF : 1;  /*!< [5..5] Forwarding GTCCRF register Compare Match Capture to Other
                                        *   Channel GTCCRA Input Capture Source Enable                                */
            __IOM uint32_t ICAFPO : 1; /*!< [6..6] Forwarding Overflow to Other Channel GTCCRA Input Capture
                                        *   Source Enable                                                             */
            __IOM uint32_t ICAFPU : 1; /*!< [7..7] Forwarding Underflow to Other Channel GTCCRA Input Capture
                                        *   Source Enable                                                             */
            __IOM uint32_t ICACLK : 1; /*!< [8..8] Forwarding Count Clock to Other Channel GTCCRA Input
                                        *   Capture Source Enable                                                     */
            uint32_t              : 5;
            __IOM uint32_t ICAGRP : 2; /*!< [15..14] GTCCRA Input Capture Group Select                                */
            __IOM uint32_t ICBFA  : 1; /*!< [16..16] Forwarding GTCCRA register Compare Match/Input Capture
                                        *   to Other Channel GTCCRB Input Capture Source Enable                       */
            __IOM uint32_t ICBFB : 1;  /*!< [17..17] Forwarding GTCCRB register Compare Match/Input Capture
                                        *   to Other Channel GTCCRB Input Capture Source Enable                       */
            __IOM uint32_t ICBFC : 1;  /*!< [18..18] Forwarding GTCCRC register Compare Match Capture to
                                        *   Other Channel GTCCRB Input Capture Source Enable                          */
            __IOM uint32_t ICBFD : 1;  /*!< [19..19] Forwarding GTCCRD register Compare Match Capture to
                                        *   Other Channel GTCCRB Input Capture Source Enable                          */
            __IOM uint32_t ICBFE : 1;  /*!< [20..20] Forwarding GTCCRE register Compare Match Capture to
                                        *   Other Channel GTCCRb Input Capture Source Enable                          */
            __IOM uint32_t ICBFF : 1;  /*!< [21..21] Forwarding GTCCRF register Compare Match Capture to
                                        *   Other Channel GTCCRB Input Capture Source Enable                          */
            __IOM uint32_t ICBFPO : 1; /*!< [22..22] Forwarding Overflow to Other Channel GTCCRB Input Capture
                                        *   Source Enable                                                             */
            __IOM uint32_t ICBFPU : 1; /*!< [23..23] Forwarding Underflow to Other Channel GTCCRB Input
                                        *   Capture Source Enable                                                     */
            __IOM uint32_t ICBCLK : 1; /*!< [24..24] Forwarding Count Clock to Other Channel GTCCRB Input
                                        *   Capture Source Enable                                                     */
            uint32_t              : 5;
            __IOM uint32_t ICBGRP : 2; /*!< [31..30] GTCCRB Input Capture Group Select                                */
        } GTICCR_b;
    };
} R_GPT0_Type;                         /*!< Size = 240 (0xf0)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_GPT_OPS                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Output Phase Switching for GPT (R_GPT_OPS)
 */

typedef struct                         /*!< (@ 0x40078FF0) R_GPT_OPS Structure                                        */
{
    union
    {
        __IOM uint32_t OPSCR;          /*!< (@ 0x00000000) Output Phase Switching Control Register                    */

        struct
        {
            __IOM uint32_t UF : 1;     /*!< [0..0] Input Phase Soft Setting WFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t VF : 1;     /*!< [1..1] Input Phase Soft Setting VFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            __IOM uint32_t WF : 1;     /*!< [2..2] Input Phase Soft Setting UFThis bit sets the input phase
                                        *   by the software settings.This bit setting is valid when
                                        *   the OPSCR.FB bit = 1.                                                     */
            uint32_t        : 1;
            __IM uint32_t U : 1;       /*!< [4..4] Input U-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t V : 1;       /*!< [5..5] Input V-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            __IM uint32_t W : 1;       /*!< [6..6] Input W-Phase MonitorThis bit monitors the state of the
                                        *   input phase.OPSCR.FB=0:External input monitoring by PCLKOPSCR.FB=1:Softwa
                                        *   e settings (UF/VF/WF)                                                     */
            uint32_t          : 1;
            __IOM uint32_t EN : 1;     /*!< [8..8] Enable-Phase Output Control                                        */
            uint32_t          : 7;
            __IOM uint32_t FB : 1;     /*!< [16..16] External Feedback Signal EnableThis bit selects the
                                        *   input phase from the software settings and external input.                */
            __IOM uint32_t P     : 1;  /*!< [17..17] Positive-Phase Output (P) Control                                */
            __IOM uint32_t N     : 1;  /*!< [18..18] Negative-Phase Output (N) Control                                */
            __IOM uint32_t INV   : 1;  /*!< [19..19] Invert-Phase Output Control                                      */
            __IOM uint32_t RV    : 1;  /*!< [20..20] Output phase rotation direction reversal                         */
            __IOM uint32_t ALIGN : 1;  /*!< [21..21] Input phase alignment                                            */
            uint32_t             : 2;
            __IOM uint32_t GRP   : 2;  /*!< [25..24] Output disabled source selection                                 */
            __IOM uint32_t GODF  : 1;  /*!< [26..26] Group output disable function                                    */
            uint32_t             : 2;
            __IOM uint32_t NFEN  : 1;  /*!< [29..29] External Input Noise Filter Enable                               */
            __IOM uint32_t NFCS  : 2;  /*!< [31..30] External Input Noise Filter Clock selectionNoise filter
                                        *   sampling clock setting of the external input.                             */
        } OPSCR_b;
    };
} R_GPT_OPS_Type;                      /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_GPT_POEG0                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief Port Output Enable for GPT (R_GPT_POEG0)
 */

typedef struct                         /*!< (@ 0x40042000) R_GPT_POEG0 Structure                                      */
{
    union
    {
        __IOM uint32_t POEGG;          /*!< (@ 0x00000000) POEG Group Setting Register                                */

        struct
        {
            __IOM uint32_t PIDF  : 1;  /*!< [0..0] Port Input Detection Flag                                          */
            __IOM uint32_t IOCF  : 1;  /*!< [1..1] Real Time Overcurrent Detection Flag                               */
            __IOM uint32_t OSTPF : 1;  /*!< [2..2] Oscillation Stop Detection Flag                                    */
            __IOM uint32_t SSF   : 1;  /*!< [3..3] Software Stop Flag                                                 */
            __IOM uint32_t PIDE  : 1;  /*!< [4..4] Port Input Detection Enable. Note: Can be modified only
                                        *   once after a reset.                                                       */
            __IOM uint32_t IOCE : 1;   /*!< [5..5] Enable for GPT Output-Disable Request. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t OSTPE : 1;  /*!< [6..6] Oscillation Stop Detection Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t             : 1;
            __IOM uint32_t CDRE0 : 1;  /*!< [8..8] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE1 : 1;  /*!< [9..9] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE2 : 1;  /*!< [10..10] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE3 : 1;  /*!< [11..11] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE4 : 1;  /*!< [12..12] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            __IOM uint32_t CDRE5 : 1;  /*!< [13..13] Comparator Disable Request Enable. Note: Can be modified
                                        *   only once after a reset.                                                  */
            uint32_t            : 2;
            __IM uint32_t ST    : 1;   /*!< [16..16] GTETRG Input Status Flag                                         */
            uint32_t            : 11;
            __IOM uint32_t INV  : 1;   /*!< [28..28] GTETRG Input Reverse                                             */
            __IOM uint32_t NFEN : 1;   /*!< [29..29] Noise Filter Enable                                              */
            __IOM uint32_t NFCS : 2;   /*!< [31..30] Noise Filter Clock Select                                        */
        } POEGG_b;
    };
    __IM uint32_t RESERVED[15];

    union
    {
        __IOM uint16_t GTONCWP;        /*!< (@ 0x00000040) GPT Output Stopping Control Group Write Protection
                                        *                  Register                                                   */

        struct
        {
            __IOM uint16_t WP    : 1;  /*!< [0..0] Register Writing Disable                                           */
            uint16_t             : 7;
            __IOM uint16_t PRKEY : 8;  /*!< [15..8] Key Code                                                          */
        } GTONCWP_b;
    };
    __IM uint16_t RESERVED1;

    union
    {
        __IOM uint16_t GTONCCR;        /*!< (@ 0x00000044) GPT Output Stopping Control Group Controlling
                                        *                  Register                                                   */

        struct
        {
            __IOM uint16_t NE  : 1;    /*!< [0..0] Direct Stopping Request Setting                                    */
            uint16_t           : 3;
            __IOM uint16_t NFS : 4;    /*!< [7..4] Direct Stopping Request Selection                                  */
            __IOM uint16_t NFV : 1;    /*!< [8..8] Direct Stopping Request Active Sense                               */
            uint16_t           : 7;
        } GTONCCR_b;
    };
    __IM uint16_t RESERVED2;
} R_GPT_POEG0_Type;                    /*!< Size = 72 (0x48)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_ICU                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Interrupt Controller Unit (R_ICU)
 */

typedef struct                         /*!< (@ 0x40006000) R_ICU Structure                                            */
{
    union
    {
        __IOM uint8_t IRQCR[16];       /*!< (@ 0x00000000) IRQ Control Register [0..15]                               */

        struct
        {
            __IOM uint8_t IRQMD   : 2; /*!< [1..0] IRQ Detection Sense Select                                         */
            uint8_t               : 1;
            __IOM uint8_t LOCOSEL : 1; /*!< [3..3] IRQi Digital Filter Sampling LOCO Clock Select                     */
            __IOM uint8_t FCLKSEL : 2; /*!< [5..4] IRQ Digital Filter Sampling Clock Select                           */
            uint8_t               : 1;
            __IOM uint8_t FLTEN   : 1; /*!< [7..7] IRQ Digital Filter Enable                                          */
        } IRQCR_b[16];
    };
    __IM uint32_t RESERVED[60];

    union
    {
        __IOM uint8_t NMICR;            /*!< (@ 0x00000100) NMI Pin Interrupt Control Register                         */

        struct
        {
            __IOM uint8_t NMIMD    : 1; /*!< [0..0] NMI Detection Set                                                  */
            uint8_t                : 3;
            __IOM uint8_t NFCLKSEL : 2; /*!< [5..4] NMI Digital Filter Sampling Clock Select                           */
            uint8_t                : 1;
            __IOM uint8_t NFLTEN   : 1; /*!< [7..7] NMI Digital Filter Enable                                          */
        } NMICR_b;
    };
    __IM uint8_t  RESERVED1;
    __IM uint16_t RESERVED2;
    __IM uint32_t RESERVED3[7];

    union
    {
        __IOM uint16_t NMIER;           /*!< (@ 0x00000120) Non-Maskable Interrupt Enable Register                     */

        struct
        {
            __IOM uint16_t IWDTEN  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Interrupt Enable                      */
            __IOM uint16_t WDTEN   : 1; /*!< [1..1] WDT Underflow/Refresh Error Interrupt Enable                       */
            __IOM uint16_t LVD1EN  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Enable                              */
            __IOM uint16_t LVD2EN  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Enable                              */
            __IOM uint16_t VBATTEN : 1; /*!< [4..4] VBATT monitor Interrupt Enable                                     */
            uint16_t               : 1;
            __IOM uint16_t OSTEN   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Enable                        */
            __IOM uint16_t NMIEN   : 1; /*!< [7..7] NMI Pin Interrupt Enable                                           */
            __IOM uint16_t RPEEN   : 1; /*!< [8..8] RAM Parity Error Interrupt Enable                                  */
            __IOM uint16_t RECCEN  : 1; /*!< [9..9] RAM ECC Error Interrupt Enable                                     */
            __IOM uint16_t BUSSEN  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Enable                             */
            __IOM uint16_t BUSMEN  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Enable                            */
            __IOM uint16_t SPEEN   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Enable                       */
            __IOM uint16_t TZFEN   : 1; /*!< [13..13] TZFEN                                                            */
            uint16_t               : 1;
            __IOM uint16_t CPEEN   : 1; /*!< [15..15] CPEEN                                                            */
        } NMIER_b;
    };
    __IM uint16_t RESERVED4;
    __IM uint32_t RESERVED5[3];

    union
    {
        __IOM uint16_t NMICLR;          /*!< (@ 0x00000130) Non-Maskable Interrupt Status Clear Register               */

        struct
        {
            __OM uint16_t IWDTCLR  : 1; /*!< [0..0] IWDT Clear                                                         */
            __OM uint16_t WDTCLR   : 1; /*!< [1..1] WDT Clear                                                          */
            __OM uint16_t LVD1CLR  : 1; /*!< [2..2] LVD1 Clear                                                         */
            __OM uint16_t LVD2CLR  : 1; /*!< [3..3] LVD2 Clear                                                         */
            __OM uint16_t VBATTCLR : 1; /*!< [4..4] VBATT Clear                                                        */
            uint16_t               : 1;
            __OM uint16_t  OSTCLR  : 1; /*!< [6..6] OST Clear                                                          */
            __OM uint16_t  NMICLR  : 1; /*!< [7..7] NMI Clear                                                          */
            __OM uint16_t  RPECLR  : 1; /*!< [8..8] SRAM Parity Error Clear                                            */
            __OM uint16_t  RECCCLR : 1; /*!< [9..9] SRAM ECC Error Clear                                               */
            __OM uint16_t  BUSSCLR : 1; /*!< [10..10] Bus Slave Error Clear                                            */
            __OM uint16_t  BUSMCLR : 1; /*!< [11..11] Bus Master Error Clear                                           */
            __OM uint16_t  SPECLR  : 1; /*!< [12..12] CPU Stack Pointer Monitor Interrupt Clear                        */
            __IOM uint16_t TZFCLR  : 1; /*!< [13..13] TZFCLR                                                           */
            uint16_t               : 1;
            __IOM uint16_t CPECLR  : 1; /*!< [15..15] CPECLR                                                           */
        } NMICLR_b;
    };
    __IM uint16_t RESERVED6;
    __IM uint32_t RESERVED7[3];

    union
    {
        __IM uint16_t NMISR;           /*!< (@ 0x00000140) Non-Maskable Interrupt Status Register                     */

        struct
        {
            __IM uint16_t IWDTST  : 1; /*!< [0..0] IWDT Underflow/Refresh Error Status Flag                           */
            __IM uint16_t WDTST   : 1; /*!< [1..1] WDT Underflow/Refresh Error Status Flag                            */
            __IM uint16_t LVD1ST  : 1; /*!< [2..2] Voltage-Monitoring 1 Interrupt Status Flag                         */
            __IM uint16_t LVD2ST  : 1; /*!< [3..3] Voltage-Monitoring 2 Interrupt Status Flag                         */
            __IM uint16_t VBATTST : 1; /*!< [4..4] VBATT monitor Interrupt Status Flag                                */
            uint16_t              : 1;
            __IM uint16_t OSTST   : 1; /*!< [6..6] Oscillation Stop Detection Interrupt Status Flag                   */
            __IM uint16_t NMIST   : 1; /*!< [7..7] NMI Status Flag                                                    */
            __IM uint16_t RPEST   : 1; /*!< [8..8] RAM Parity Error Interrupt Status Flag                             */
            __IM uint16_t RECCST  : 1; /*!< [9..9] RAM ECC Error Interrupt Status Flag                                */
            __IM uint16_t BUSSST  : 1; /*!< [10..10] MPU Bus Slave Error Interrupt Status Flag                        */
            __IM uint16_t BUSMST  : 1; /*!< [11..11] MPU Bus Master Error Interrupt Status Flag                       */
            __IM uint16_t SPEST   : 1; /*!< [12..12] CPU Stack pointer monitor Interrupt Status Flag                  */
            __IM uint16_t TZFST   : 1; /*!< [13..13] TZFST                                                            */
            uint16_t              : 1;
            __IM uint16_t CPEST   : 1; /*!< [15..15] CPEST                                                            */
        } NMISR_b;
    };
    __IM uint16_t RESERVED8;
    __IM uint32_t RESERVED9[23];

    union
    {
        __IOM uint32_t WUPEN;                /*!< (@ 0x000001A0) Wake Up Interrupt Enable Register                          */

        struct
        {
            __IOM uint32_t IRQWUPEN0    : 1; /*!< [0..0] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN1    : 1; /*!< [1..1] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN2    : 1; /*!< [2..2] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN3    : 1; /*!< [3..3] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN4    : 1; /*!< [4..4] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN5    : 1; /*!< [5..5] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN6    : 1; /*!< [6..6] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN7    : 1; /*!< [7..7] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN8    : 1; /*!< [8..8] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN9    : 1; /*!< [9..9] IRQ interrupt S/W standby returns enable                           */
            __IOM uint32_t IRQWUPEN10   : 1; /*!< [10..10] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN11   : 1; /*!< [11..11] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN12   : 1; /*!< [12..12] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN13   : 1; /*!< [13..13] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN14   : 1; /*!< [14..14] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IRQWUPEN15   : 1; /*!< [15..15] IRQ interrupt S/W standby returns enable                         */
            __IOM uint32_t IWDTWUPEN    : 1; /*!< [16..16] IWDT interrupt S/W standby returns enable                        */
            __IOM uint32_t KEYWUPEN     : 1; /*!< [17..17] Key interrupt S/W standby returns enable                         */
            __IOM uint32_t LVD1WUPEN    : 1; /*!< [18..18] LVD1 interrupt S/W standby returns enable                        */
            __IOM uint32_t LVD2WUPEN    : 1; /*!< [19..19] LVD2 interrupt S/W standby returns enable                        */
            __IOM uint32_t VBATTWUPEN   : 1; /*!< [20..20] VBATT monitor interrupt S/W standby returns enable               */
            uint32_t                    : 1;
            __IOM uint32_t ACMPHS0WUPEN : 1; /*!< [22..22] ACMPHS0 interrupt S/W standby returns enable bit                 */
            __IOM uint32_t ACMPLP0WUPEN : 1; /*!< [23..23] ACMPLP0 interrupt S/W standby returns enable                     */
            __IOM uint32_t RTCALMWUPEN  : 1; /*!< [24..24] RTC alarm interrupt S/W standby returns enable                   */
            __IOM uint32_t RTCPRDWUPEN  : 1; /*!< [25..25] RCT period interrupt S/W standby returns enable                  */
            __IOM uint32_t USBHSWUPEN   : 1; /*!< [26..26] USBHS interrupt S/W standby returns enable bit                   */
            __IOM uint32_t USBFSWUPEN   : 1; /*!< [27..27] USBFS interrupt S/W standby returns enable                       */
            __IOM uint32_t AGT1UDWUPEN  : 1; /*!< [28..28] AGT1 underflow interrupt S/W standby returns enable              */
            __IOM uint32_t AGT1CAWUPEN  : 1; /*!< [29..29] AGT1 compare match A interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t AGT1CBWUPEN : 1;  /*!< [30..30] AGT1 compare match B interrupt S/W standby returns
                                              *   enable                                                                    */
            __IOM uint32_t IIC0WUPEN : 1;    /*!< [31..31] IIC0 address match interrupt S/W standby returns enable          */
        } WUPEN_b;
    };

    union
    {
        __IOM uint32_t WUPEN1;              /*!< (@ 0x000001A4) Wake Up interrupt enable register 1                        */

        struct
        {
            __IOM uint32_t AGT3UDWUPEN : 1; /*!< [0..0] AGT3 underflow interrupt S/W standby returns enable bit            */
            __IOM uint32_t AGT3CAWUPEN : 1; /*!< [1..1] AGT3 compare match A interrupt S/W standby returns enable
                                             *   bit                                                                       */
            __IOM uint32_t AGT3CBWUPEN : 1; /*!< [2..2] AGT3 compare match B interrupt S/W standby returns enable
                                             *   bit                                                                       */
            uint32_t : 29;
        } WUPEN1_b;
    };

    union
    {
        __IOM uint32_t WUPEN2;               /*!< (@ 0x000001A8) Wake Up Interrupt Enable Register 2                        */

        struct
        {
            __IOM uint32_t INTUR0WUPEN : 1;  /*!< [0..0] UARTA0_INTUR Interrupt Software Standby/Snooze Mode Return
                                              *   Enable                                                                    */
            __IOM uint32_t INTURE0WUPEN : 1; /*!< [1..1] UARTA0_INTURE Interrupt Software Standby/Snooze Mode
                                              *   Return Enable                                                             */
            __IOM uint32_t INTUR1WUPEN : 1;  /*!< [2..2] UARTA1_INTUR Interrupt Software Standby/Snooze Mode Return
                                              *   Enable                                                                    */
            __IOM uint32_t INTURE1WUPEN : 1; /*!< [3..3] UARTA1_INTURE Interrupt Software Standby/Snooze Mode
                                              *   Return Enable                                                             */
            __IOM uint32_t USBCCSWUPEN : 1;  /*!< [4..4] USBCC Status Change Interrupt Software Standby/Snooze
                                              *   Mode                                                                      */
            uint32_t : 27;
        } WUPEN2_b;
    };
    __IM uint32_t RESERVED10[5];

    union
    {
        __IOM uint8_t IELEN;            /*!< (@ 0x000001C0) ICU event Enable Register                                  */

        struct
        {
            __IOM uint8_t RTCINTEN : 1; /*!< [0..0] RTCALM and RTCPRD Interrupts Enable (when LPOPTEN bit
                                         *   = 1)                                                                      */
            __IOM uint8_t IELEN : 1;    /*!< [1..1] Parts Asynchronous Interrupts Enable except RTC (when
                                         *   LPOPTEN bit = 1)                                                          */
            uint8_t : 6;
        } IELEN_b;
    };
    __IM uint8_t  RESERVED11;
    __IM uint16_t RESERVED12;
    __IM uint32_t RESERVED13[15];

    union
    {
        __IOM uint16_t SELSR0;         /*!< (@ 0x00000200) Snooze Event Link Setting Register                         */

        struct
        {
            __IOM uint16_t SELS : 9;   /*!< [8..0] SYS Event Link Select                                              */
            uint16_t            : 7;
        } SELSR0_b;
    };
    __IM uint16_t RESERVED14;
    __IM uint32_t RESERVED15[31];

    union
    {
        __IOM uint32_t DELSR[8];       /*!< (@ 0x00000280) DMAC Event Link Setting Register                           */

        struct
        {
            __IOM uint32_t DELS : 9;   /*!< [8..0] Event selection to DMAC Start request                              */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag for DMAC NOTE: Writing 1 to the
                                        *   IR flag is prohibited.                                                    */
            uint32_t : 15;
        } DELSR_b[8];
    };
    __IM uint32_t RESERVED16[24];

    union
    {
        __IOM uint32_t IELSR[96];      /*!< (@ 0x00000300) ICU Event Link Setting Register [0..95]                    */

        struct
        {
            __IOM uint32_t IELS : 9;   /*!< [8..0] ICU Event selection to NVICSet the number for the event
                                        *   signal to be linked .                                                     */
            uint32_t            : 7;
            __IOM uint32_t IR   : 1;   /*!< [16..16] Interrupt Status Flag                                            */
            uint32_t            : 7;
            __IOM uint32_t DTCE : 1;   /*!< [24..24] DTC Activation Enable                                            */
            uint32_t            : 7;
        } IELSR_b[96];
    };
} R_ICU_Type;                          /*!< Size = 1152 (0x480)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_IIC0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I2C Bus Interface (R_IIC0)
 */

typedef struct                         /*!< (@ 0x40053000) R_IIC0 Structure                                           */
{
    union
    {
        __IOM uint8_t ICCR1;           /*!< (@ 0x00000000) I2C Bus Control Register 1                                 */

        struct
        {
            __IM uint8_t  SDAI   : 1;  /*!< [0..0] SDA Line Monitor                                                   */
            __IM uint8_t  SCLI   : 1;  /*!< [1..1] SCL Line Monitor                                                   */
            __IOM uint8_t SDAO   : 1;  /*!< [2..2] SDA Output Control/Monitor                                         */
            __IOM uint8_t SCLO   : 1;  /*!< [3..3] SCL Output Control/Monitor                                         */
            __IOM uint8_t SOWP   : 1;  /*!< [4..4] SCLO/SDAO Write Protect                                            */
            __IOM uint8_t CLO    : 1;  /*!< [5..5] Extra SCL Clock Cycle Output                                       */
            __IOM uint8_t IICRST : 1;  /*!< [6..6] I2C Bus Interface Internal ResetNote:If an internal reset
                                        *   is initiated using the IICRST bit for a bus hang-up occurred
                                        *   during communication with the master device in slave mode,
                                        *   the states may become different between the slave device
                                        *   and the master device (due to the difference in the bit
                                        *   counter information).                                                     */
            __IOM uint8_t ICE : 1;     /*!< [7..7] I2C Bus Interface Enable                                           */
        } ICCR1_b;
    };

    union
    {
        __IOM uint8_t ICCR2;           /*!< (@ 0x00000001) I2C Bus Control Register 2                                 */

        struct
        {
            uint8_t          : 1;
            __IOM uint8_t ST : 1;      /*!< [1..1] Start Condition Issuance RequestSet the ST bit to 1 (start
                                        *   condition issuance request) when the BBSY flag is set to
                                        *   0 (bus free state).                                                       */
            __IOM uint8_t RS : 1;      /*!< [2..2] Restart Condition Issuance RequestNote: Do not set the
                                        *   RS bit to 1 while issuing a stop condition.                               */
            __IOM uint8_t SP : 1;      /*!< [3..3] Stop Condition Issuance RequestNote: Writing to the SP
                                        *   bit is not possible while the setting of the BBSY flag
                                        *   is 0 (bus free state).Note: Do not set the SP bit to 1
                                        *   while a restart condition is being issued.                                */
            uint8_t            : 1;
            __IOM uint8_t TRS  : 1;    /*!< [5..5] Transmit/Receive Mode                                              */
            __IOM uint8_t MST  : 1;    /*!< [6..6] Master/Slave Mode                                                  */
            __IM uint8_t  BBSY : 1;    /*!< [7..7] Bus Busy Detection Flag                                            */
        } ICCR2_b;
    };

    union
    {
        __IOM uint8_t ICMR1;           /*!< (@ 0x00000002) I2C Bus Mode Register 1                                    */

        struct
        {
            __IOM uint8_t BC   : 3;    /*!< [2..0] Bit Counter                                                        */
            __OM uint8_t  BCWP : 1;    /*!< [3..3] BC Write Protect(This bit is read as 1.)                           */
            __IOM uint8_t CKS  : 3;    /*!< [6..4] Internal Reference Clock (fIIC) Selection ( fIIC = PCLKB
                                        *   / 2^CKS )                                                                 */
            __IOM uint8_t MTWP : 1;    /*!< [7..7] MST/TRS Write Protect                                              */
        } ICMR1_b;
    };

    union
    {
        __IOM uint8_t ICMR2;           /*!< (@ 0x00000003) I2C Bus Mode Register 2                                    */

        struct
        {
            __IOM uint8_t TMOS : 1;    /*!< [0..0] Timeout Detection Time Select                                      */
            __IOM uint8_t TMOL : 1;    /*!< [1..1] Timeout L Count Control                                            */
            __IOM uint8_t TMOH : 1;    /*!< [2..2] Timeout H Count Control                                            */
            uint8_t            : 1;
            __IOM uint8_t SDDL : 3;    /*!< [6..4] SDA Output Delay Counter                                           */
            __IOM uint8_t DLCS : 1;    /*!< [7..7] SDA Output Delay Clock Source Select                               */
        } ICMR2_b;
    };

    union
    {
        __IOM uint8_t ICMR3;           /*!< (@ 0x00000004) I2C Bus Mode Register 3                                    */

        struct
        {
            __IOM uint8_t NF    : 2;   /*!< [1..0] Noise Filter Stage Selection                                       */
            __IM uint8_t  ACKBR : 1;   /*!< [2..2] Receive Acknowledge                                                */
            __IOM uint8_t ACKBT : 1;   /*!< [3..3] Transmit Acknowledge                                               */
            __IOM uint8_t ACKWP : 1;   /*!< [4..4] ACKBT Write Protect                                                */
            __IOM uint8_t RDRFS : 1;   /*!< [5..5] RDRF Flag Set Timing Selection                                     */
            __IOM uint8_t WAIT  : 1;   /*!< [6..6] WAITNote: When the value of the WAIT bit is to be read,
                                        *   be sure to read the ICDRR beforehand.                                     */
            __IOM uint8_t SMBS : 1;    /*!< [7..7] SMBus/I2C Bus Selection                                            */
        } ICMR3_b;
    };

    union
    {
        __IOM uint8_t ICFER;           /*!< (@ 0x00000005) I2C Bus Function Enable Register                           */

        struct
        {
            __IOM uint8_t TMOE  : 1;   /*!< [0..0] Timeout Function Enable                                            */
            __IOM uint8_t MALE  : 1;   /*!< [1..1] Master Arbitration-Lost Detection Enable                           */
            __IOM uint8_t NALE  : 1;   /*!< [2..2] NACK Transmission Arbitration-Lost Detection Enable                */
            __IOM uint8_t SALE  : 1;   /*!< [3..3] Slave Arbitration-Lost Detection Enable                            */
            __IOM uint8_t NACKE : 1;   /*!< [4..4] NACK Reception Transfer Suspension Enable                          */
            __IOM uint8_t NFE   : 1;   /*!< [5..5] Digital Noise Filter Circuit Enable                                */
            __IOM uint8_t SCLE  : 1;   /*!< [6..6] SCL Synchronous Circuit Enable                                     */
            __IOM uint8_t FMPE  : 1;   /*!< [7..7] Fast-mode Plus Enable                                              */
        } ICFER_b;
    };

    union
    {
        __IOM uint8_t ICSER;           /*!< (@ 0x00000006) I2C Bus Status Enable Register                             */

        struct
        {
            __IOM uint8_t SAR0E : 1;   /*!< [0..0] Slave Address Register 0 Enable                                    */
            __IOM uint8_t SAR1E : 1;   /*!< [1..1] Slave Address Register 1 Enable                                    */
            __IOM uint8_t SAR2E : 1;   /*!< [2..2] Slave Address Register 2 Enable                                    */
            __IOM uint8_t GCAE  : 1;   /*!< [3..3] General Call Address Enable                                        */
            uint8_t             : 1;
            __IOM uint8_t DIDE  : 1;   /*!< [5..5] Device-ID Address Detection Enable                                 */
            uint8_t             : 1;
            __IOM uint8_t HOAE  : 1;   /*!< [7..7] Host Address Enable                                                */
        } ICSER_b;
    };

    union
    {
        __IOM uint8_t ICIER;           /*!< (@ 0x00000007) I2C Bus Interrupt Enable Register                          */

        struct
        {
            __IOM uint8_t TMOIE : 1;   /*!< [0..0] Timeout Interrupt Request Enable                                   */
            __IOM uint8_t ALIE  : 1;   /*!< [1..1] Arbitration-Lost Interrupt Request Enable                          */
            __IOM uint8_t STIE  : 1;   /*!< [2..2] Start Condition Detection Interrupt Request Enable                 */
            __IOM uint8_t SPIE  : 1;   /*!< [3..3] Stop Condition Detection Interrupt Request Enable                  */
            __IOM uint8_t NAKIE : 1;   /*!< [4..4] NACK Reception Interrupt Request Enable                            */
            __IOM uint8_t RIE   : 1;   /*!< [5..5] Receive Data Full Interrupt Request Enable                         */
            __IOM uint8_t TEIE  : 1;   /*!< [6..6] Transmit End Interrupt Request Enable                              */
            __IOM uint8_t TIE   : 1;   /*!< [7..7] Transmit Data Empty Interrupt Request Enable                       */
        } ICIER_b;
    };

    union
    {
        __IOM uint8_t ICSR1;           /*!< (@ 0x00000008) I2C Bus Status Register 1                                  */

        struct
        {
            __IOM uint8_t AAS0 : 1;    /*!< [0..0] Slave Address 0 Detection Flag                                     */
            __IOM uint8_t AAS1 : 1;    /*!< [1..1] Slave Address 1 Detection Flag                                     */
            __IOM uint8_t AAS2 : 1;    /*!< [2..2] Slave Address 2 Detection Flag                                     */
            __IOM uint8_t GCA  : 1;    /*!< [3..3] General Call Address Detection Flag                                */
            uint8_t            : 1;
            __IOM uint8_t DID  : 1;    /*!< [5..5] Device-ID Address Detection Flag                                   */
            uint8_t            : 1;
            __IOM uint8_t HOA  : 1;    /*!< [7..7] Host Address Detection Flag                                        */
        } ICSR1_b;
    };

    union
    {
        __IOM uint8_t ICSR2;           /*!< (@ 0x00000009) I2C Bus Status Register 2                                  */

        struct
        {
            __IOM uint8_t TMOF  : 1;   /*!< [0..0] Timeout Detection Flag                                             */
            __IOM uint8_t AL    : 1;   /*!< [1..1] Arbitration-Lost Flag                                              */
            __IOM uint8_t START : 1;   /*!< [2..2] Start Condition Detection Flag                                     */
            __IOM uint8_t STOP  : 1;   /*!< [3..3] Stop Condition Detection Flag                                      */
            __IOM uint8_t NACKF : 1;   /*!< [4..4] NACK Detection Flag                                                */
            __IOM uint8_t RDRF  : 1;   /*!< [5..5] Receive Data Full Flag                                             */
            __IOM uint8_t TEND  : 1;   /*!< [6..6] Transmit End Flag                                                  */
            __IM uint8_t  TDRE  : 1;   /*!< [7..7] Transmit Data Empty Flag                                           */
        } ICSR2_b;
    };
    __IOM R_IIC0_SAR_Type SAR[3];      /*!< (@ 0x0000000A) Slave Address Registers                                    */

    union
    {
        __IOM uint8_t ICBRL;           /*!< (@ 0x00000010) I2C Bus Bit Rate Low-Level Register                        */

        struct
        {
            __IOM uint8_t BRL : 5;     /*!< [4..0] Bit Rate Low-Level Period(Low-level period of SCL clock)           */
            uint8_t           : 3;
        } ICBRL_b;
    };

    union
    {
        __IOM uint8_t ICBRH;           /*!< (@ 0x00000011) I2C Bus Bit Rate High-Level Register                       */

        struct
        {
            __IOM uint8_t BRH : 5;     /*!< [4..0] Bit Rate High-Level Period(High-level period of SCL clock)         */
            uint8_t           : 3;
        } ICBRH_b;
    };

    union
    {
        __IOM uint8_t ICDRT;           /*!< (@ 0x00000012) I2C Bus Transmit Data Register                             */

        struct
        {
            __IOM uint8_t ICDRT : 8;   /*!< [7..0] 8-bit read-write register that stores transmit data.               */
        } ICDRT_b;
    };

    union
    {
        __IM uint8_t ICDRR;            /*!< (@ 0x00000013) I2C Bus Receive Data Register                              */

        struct
        {
            __IM uint8_t ICDRR : 8;    /*!< [7..0] 8-bit register that stores the received data                       */
        } ICDRR_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t ICWUR;           /*!< (@ 0x00000016) I2C Bus Wake Up Unit Register                              */

        struct
        {
            __IOM uint8_t WUAFA : 1;   /*!< [0..0] Wakeup Analog Filter Additional Selection                          */
            uint8_t             : 3;
            __IOM uint8_t WUACK : 1;   /*!< [4..4] ACK bit for Wakeup Mode                                            */
            __IOM uint8_t WUF   : 1;   /*!< [5..5] Wakeup Event Occurrence Flag                                       */
            __IOM uint8_t WUIE  : 1;   /*!< [6..6] Wakeup Interrupt Request Enable                                    */
            __IOM uint8_t WUE   : 1;   /*!< [7..7] Wakeup Function Enable                                             */
        } ICWUR_b;
    };

    union
    {
        __IOM uint8_t ICWUR2;          /*!< (@ 0x00000017) I2C Bus Wake up Unit Register 2                            */

        struct
        {
            __IOM uint8_t WUSEN  : 1;  /*!< [0..0] Wake-up Function Synchronous Enable                                */
            __IM uint8_t  WUASYF : 1;  /*!< [1..1] Wake-up Function Asynchronous Operation Status Flag                */
            __IM uint8_t  WUSYF  : 1;  /*!< [2..2] Wake-up Function Synchronous Operation Status Flag                 */
            uint8_t              : 5;
        } ICWUR2_b;
    };
} R_IIC0_Type;                         /*!< Size = 24 (0x18)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_IWDT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Independent Watchdog Timer (R_IWDT)
 */

typedef struct                         /*!< (@ 0x40044400) R_IWDT Structure                                           */
{
    union
    {
        __IOM uint8_t IWDTRR;          /*!< (@ 0x00000000) IWDT Refresh Register                                      */

        struct
        {
            __IOM uint8_t IWDTRR : 8;  /*!< [7..0] The counter is refreshed by writing 0x00 and then writing
                                        *   0xFF to this register.                                                    */
        } IWDTRR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t IWDTCR;         /*!< (@ 0x00000002) IWDT Control Register                                      */

        struct
        {
            __IOM uint16_t TOPS : 2;   /*!< [1..0] Timeout Period Selection                                           */
            uint16_t            : 2;
            __IOM uint16_t CKS  : 4;   /*!< [7..4] Clock Division Ratio Selection                                     */
            __IOM uint16_t RPES : 2;   /*!< [9..8] Window End Position Selection                                      */
            uint16_t            : 2;
            __IOM uint16_t RPSS : 2;   /*!< [13..12] Window Start Position Selection                                  */
            uint16_t            : 2;
        } IWDTCR_b;
    };

    union
    {
        __IOM uint16_t IWDTSR;          /*!< (@ 0x00000004) IWDT Status Register                                       */

        struct
        {
            __IM uint16_t  CNTVAL : 14; /*!< [13..0] Down-Counter Value                                                */
            __IOM uint16_t UNDFF  : 1;  /*!< [14..14] Underflow Flag                                                   */
            __IOM uint16_t REFEF  : 1;  /*!< [15..15] Refresh Error Flag                                               */
        } IWDTSR_b;
    };

    union
    {
        __IOM uint8_t IWDTRCR;         /*!< (@ 0x00000006) IWDT Reset Control Register                                */

        struct
        {
            uint8_t               : 7;
            __IOM uint8_t RSTIRQS : 1; /*!< [7..7] Reset Interrupt Request Selection                                  */
        } IWDTRCR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t IWDTCSTPR;       /*!< (@ 0x00000008) IWDT Count Stop Control Register                           */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t SLCSTP : 1;  /*!< [7..7] Sleep-Mode Count Stop Control                                      */
        } IWDTCSTPR_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;
} R_IWDT_Type;                         /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                          R_KINT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Key Interrupt Function (R_KINT)
 */

typedef struct                         /*!< (@ 0x40080000) R_KINT Structure                                           */
{
    union
    {
        __IOM uint8_t KRCTL;           /*!< (@ 0x00000000) KEY Return Control Register                                */

        struct
        {
            __IOM uint8_t KREG : 1;    /*!< [0..0] Detection Edge Selection (KRF0 to KRF7)                            */
            uint8_t            : 6;
            __IOM uint8_t KRMD : 1;    /*!< [7..7] Usage of Key Interrupt Flags(KR0 to KR7)                           */
        } KRCTL_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t KRF;             /*!< (@ 0x00000004) KEY Return Flag Register                                   */

        struct
        {
            __IOM uint8_t KRF0 : 1;    /*!< [0..0] Key interrupt flag 0                                               */
            __IOM uint8_t KRF1 : 1;    /*!< [1..1] Key interrupt flag 1                                               */
            __IOM uint8_t KRF2 : 1;    /*!< [2..2] Key interrupt flag 2                                               */
            __IOM uint8_t KRF3 : 1;    /*!< [3..3] Key interrupt flag 3                                               */
            __IOM uint8_t KRF4 : 1;    /*!< [4..4] Key interrupt flag 4                                               */
            __IOM uint8_t KRF5 : 1;    /*!< [5..5] Key interrupt flag 5                                               */
            __IOM uint8_t KRF6 : 1;    /*!< [6..6] Key interrupt flag 6                                               */
            __IOM uint8_t KRF7 : 1;    /*!< [7..7] Key interrupt flag 7                                               */
        } KRF_b;
    };
    __IM uint8_t RESERVED1[3];

    union
    {
        __IOM uint8_t KRM;             /*!< (@ 0x00000008) KEY Return Mode Register                                   */

        struct
        {
            __IOM uint8_t KRM0 : 1;    /*!< [0..0] Key interrupt mode control 0                                       */
            __IOM uint8_t KRM1 : 1;    /*!< [1..1] Key interrupt mode control 1                                       */
            __IOM uint8_t KRM2 : 1;    /*!< [2..2] Key interrupt mode control 2                                       */
            __IOM uint8_t KRM3 : 1;    /*!< [3..3] Key interrupt mode control 3                                       */
            __IOM uint8_t KRM4 : 1;    /*!< [4..4] Key interrupt mode control 4                                       */
            __IOM uint8_t KRM5 : 1;    /*!< [5..5] Key interrupt mode control 5                                       */
            __IOM uint8_t KRM6 : 1;    /*!< [6..6] Key interrupt mode control 6                                       */
            __IOM uint8_t KRM7 : 1;    /*!< [7..7] Key interrupt mode control 7                                       */
        } KRM_b;
    };
} R_KINT_Type;                         /*!< Size = 9 (0x9)                                                            */

/* =========================================================================================================================== */
/* ================                                        R_MPU_MMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Master MPU (R_MPU_MMPU)
 */

typedef struct                          /*!< (@ 0x40000000) R_MPU_MMPU Structure                                       */
{
    __IOM R_MPU_MMPU_MMPU_Type MMPU[3]; /*!< (@ 0x00000000) Bus Master MPU Registers                                   */
} R_MPU_MMPU_Type;                      /*!< Size = 3072 (0xc00)                                                       */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SMPU                                         ================ */
/* =========================================================================================================================== */

/**
 * @brief Bus Slave MPU (R_MPU_SMPU)
 */

typedef struct                           /*!< (@ 0x40000C00) R_MPU_SMPU Structure                                       */
{
    union
    {
        __IOM uint16_t SMPUCTL;          /*!< (@ 0x00000000) Slave MPU Control Register                                 */

        struct
        {
            __IOM uint16_t OAD     : 1;  /*!< [0..0] Master Group enable                                                */
            __IOM uint16_t PROTECT : 1;  /*!< [1..1] Protection of register                                             */
            uint16_t               : 6;
            __OM uint16_t KEY      : 8;  /*!< [15..8] Key Code This bit is used to enable or disable rewriting
                                          *   of the PROTECT and OAD bit.                                               */
        } SMPUCTL_b;
    };
    __IM uint16_t              RESERVED[7];
    __IOM R_MPU_SMPU_SMPU_Type SMPU[10]; /*!< (@ 0x00000010) Access Control Structure for MBIU                          */
} R_MPU_SMPU_Type;                       /*!< Size = 56 (0x38)                                                          */

/* =========================================================================================================================== */
/* ================                                        R_MPU_SPMON                                        ================ */
/* =========================================================================================================================== */

/**
 * @brief CPU Stack Pointer Monitor (R_MPU_SPMON)
 */

typedef struct                         /*!< (@ 0x40000D00) R_MPU_SPMON Structure                                      */
{
    __IOM R_MPU_SPMON_SP_Type SP[2];   /*!< (@ 0x00000000) Stack Pointer Monitor                                      */
} R_MPU_SPMON_Type;                    /*!< Size = 32 (0x20)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_MSTP                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief System-Module Stop (R_MSTP)
 */

typedef struct                          /*!< (@ 0x40047000) R_MSTP Structure                                           */
{
    union
    {
        __IOM uint32_t MSTPCRA;         /*!< (@ 0x00000000) Module Stop Control Register A                             */

        struct
        {
            __IOM uint32_t MSTPA0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRA_b;
    };

    union
    {
        __IOM uint32_t MSTPCRB;         /*!< (@ 0x00000004) Module Stop Control Register B                             */

        struct
        {
            __IOM uint32_t MSTPB0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPB10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPB31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRB_b;
    };

    union
    {
        __IOM uint32_t MSTPCRC;         /*!< (@ 0x00000008) Module Stop Control Register C                             */

        struct
        {
            __IOM uint32_t MSTPC0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPC10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPC31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRC_b;
    };

    union
    {
        __IOM uint32_t MSTPCRD;         /*!< (@ 0x0000000C) Module Stop Control Register D                             */

        struct
        {
            __IOM uint32_t MSTPD0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPD10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPD31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRD_b;
    };

    union
    {
        union
        {
            __IOM uint32_t MSTPCRE;         /*!< (@ 0x00000010) Module Stop Control Register E                             */

            struct
            {
                __IOM uint32_t MSTPE0  : 1; /*!< [0..0] Module stop bit 0. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE1  : 1; /*!< [1..1] Module stop bit 1. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE2  : 1; /*!< [2..2] Module stop bit 2. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE3  : 1; /*!< [3..3] Module stop bit 3. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE4  : 1; /*!< [4..4] Module stop bit 4. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE5  : 1; /*!< [5..5] Module stop bit 5. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE6  : 1; /*!< [6..6] Module stop bit 6. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE7  : 1; /*!< [7..7] Module stop bit 7. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE8  : 1; /*!< [8..8] Module stop bit 8. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE9  : 1; /*!< [9..9] Module stop bit 9. See device hardware manual for usage.           */
                __IOM uint32_t MSTPE10 : 1; /*!< [10..10] Module stop bit 10. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE11 : 1; /*!< [11..11] Module stop bit 11. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE12 : 1; /*!< [12..12] Module stop bit 12. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE13 : 1; /*!< [13..13] Module stop bit 13. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE14 : 1; /*!< [14..14] Module stop bit 14. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE15 : 1; /*!< [15..15] Module stop bit 15. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE16 : 1; /*!< [16..16] Module stop bit 16. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE17 : 1; /*!< [17..17] Module stop bit 17. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE18 : 1; /*!< [18..18] Module stop bit 18. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE19 : 1; /*!< [19..19] Module stop bit 19. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE20 : 1; /*!< [20..20] Module stop bit 20. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE21 : 1; /*!< [21..21] Module stop bit 21. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE22 : 1; /*!< [22..22] Module stop bit 22. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE23 : 1; /*!< [23..23] Module stop bit 23. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE24 : 1; /*!< [24..24] Module stop bit 24. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE25 : 1; /*!< [25..25] Module stop bit 25. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE26 : 1; /*!< [26..26] Module stop bit 26. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE27 : 1; /*!< [27..27] Module stop bit 27. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE28 : 1; /*!< [28..28] Module stop bit 28. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE29 : 1; /*!< [29..29] Module stop bit 29. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE30 : 1; /*!< [30..30] Module stop bit 30. See device hardware manual for
                                             *   usage.                                                                    */
                __IOM uint32_t MSTPE31 : 1; /*!< [31..31] Module stop bit 31. See device hardware manual for
                                             *   usage.                                                                    */
            } MSTPCRE_b;
        };

        union
        {
            __IOM uint16_t LSMRWDIS;         /*!< (@ 0x00000010) Low Speed Module R/W Disable Control Register              */

            struct
            {
                __IOM uint16_t RTCRWDIS : 1; /*!< [0..0] RTC Register R/W Enable Control                                    */
                __IOM uint16_t WDTDIS   : 1; /*!< [1..1] WDT Operate Clock Control                                          */
                __IOM uint16_t IWDTIDS  : 1; /*!< [2..2] IWDT Register Clock Control                                        */
                uint16_t                : 4;
                __IOM uint16_t WREN     : 1; /*!< [7..7] Write Enable for bits [2:0]                                        */
                __OM uint16_t  PRKEY    : 8; /*!< [15..8] LSMRWDIS Key Code                                                 */
            } LSMRWDIS_b;
        };
    };
} R_MSTP_Type;                               /*!< Size = 20 (0x14)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_PORT0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports (R_PORT0)
 */

typedef struct                         /*!< (@ 0x40040000) R_PORT0 Structure                                          */
{
    union
    {
        union
        {
            __IOM uint32_t PCNTR1;        /*!< (@ 0x00000000) Port Control Register 1                                    */

            struct
            {
                __IOM uint32_t PDR  : 16; /*!< [15..0] Pmn Direction                                                     */
                __IOM uint32_t PODR : 16; /*!< [31..16] Pmn Output Data                                                  */
            } PCNTR1_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t PODR;           /*!< (@ 0x00000000) Output data register                                       */

                struct
                {
                    __IOM uint16_t PODR0  : 1; /*!< [0..0] Pmn Output Data                                                    */
                    __IOM uint16_t PODR1  : 1; /*!< [1..1] Pmn Output Data                                                    */
                    __IOM uint16_t PODR2  : 1; /*!< [2..2] Pmn Output Data                                                    */
                    __IOM uint16_t PODR3  : 1; /*!< [3..3] Pmn Output Data                                                    */
                    __IOM uint16_t PODR4  : 1; /*!< [4..4] Pmn Output Data                                                    */
                    __IOM uint16_t PODR5  : 1; /*!< [5..5] Pmn Output Data                                                    */
                    __IOM uint16_t PODR6  : 1; /*!< [6..6] Pmn Output Data                                                    */
                    __IOM uint16_t PODR7  : 1; /*!< [7..7] Pmn Output Data                                                    */
                    __IOM uint16_t PODR8  : 1; /*!< [8..8] Pmn Output Data                                                    */
                    __IOM uint16_t PODR9  : 1; /*!< [9..9] Pmn Output Data                                                    */
                    __IOM uint16_t PODR10 : 1; /*!< [10..10] Pmn Output Data                                                  */
                    __IOM uint16_t PODR11 : 1; /*!< [11..11] Pmn Output Data                                                  */
                    __IOM uint16_t PODR12 : 1; /*!< [12..12] Pmn Output Data                                                  */
                    __IOM uint16_t PODR13 : 1; /*!< [13..13] Pmn Output Data                                                  */
                    __IOM uint16_t PODR14 : 1; /*!< [14..14] Pmn Output Data                                                  */
                    __IOM uint16_t PODR15 : 1; /*!< [15..15] Pmn Output Data                                                  */
                } PODR_b;
            };

            union
            {
                __IOM uint16_t PDR;           /*!< (@ 0x00000002) Data direction register                                    */

                struct
                {
                    __IOM uint16_t PDR0  : 1; /*!< [0..0] Pmn Direction                                                      */
                    __IOM uint16_t PDR1  : 1; /*!< [1..1] Pmn Direction                                                      */
                    __IOM uint16_t PDR2  : 1; /*!< [2..2] Pmn Direction                                                      */
                    __IOM uint16_t PDR3  : 1; /*!< [3..3] Pmn Direction                                                      */
                    __IOM uint16_t PDR4  : 1; /*!< [4..4] Pmn Direction                                                      */
                    __IOM uint16_t PDR5  : 1; /*!< [5..5] Pmn Direction                                                      */
                    __IOM uint16_t PDR6  : 1; /*!< [6..6] Pmn Direction                                                      */
                    __IOM uint16_t PDR7  : 1; /*!< [7..7] Pmn Direction                                                      */
                    __IOM uint16_t PDR8  : 1; /*!< [8..8] Pmn Direction                                                      */
                    __IOM uint16_t PDR9  : 1; /*!< [9..9] Pmn Direction                                                      */
                    __IOM uint16_t PDR10 : 1; /*!< [10..10] Pmn Direction                                                    */
                    __IOM uint16_t PDR11 : 1; /*!< [11..11] Pmn Direction                                                    */
                    __IOM uint16_t PDR12 : 1; /*!< [12..12] Pmn Direction                                                    */
                    __IOM uint16_t PDR13 : 1; /*!< [13..13] Pmn Direction                                                    */
                    __IOM uint16_t PDR14 : 1; /*!< [14..14] Pmn Direction                                                    */
                    __IOM uint16_t PDR15 : 1; /*!< [15..15] Pmn Direction                                                    */
                } PDR_b;
            };
        };
    };

    union
    {
        union
        {
            __IM uint32_t PCNTR2;        /*!< (@ 0x00000004) Port Control Register 2                                    */

            struct
            {
                __IM uint32_t PIDR : 16; /*!< [15..0] Pmn Input Data                                                    */
                __IM uint32_t EIDR : 16; /*!< [31..16] Pmn Event Input Data                                             */
            } PCNTR2_b;
        };

        struct
        {
            union
            {
                __IM uint16_t EIDR;           /*!< (@ 0x00000004) Event input data register                                  */

                struct
                {
                    __IM uint16_t EIDR0  : 1; /*!< [0..0] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR1  : 1; /*!< [1..1] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR2  : 1; /*!< [2..2] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR3  : 1; /*!< [3..3] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR4  : 1; /*!< [4..4] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR5  : 1; /*!< [5..5] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR6  : 1; /*!< [6..6] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR7  : 1; /*!< [7..7] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR8  : 1; /*!< [8..8] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR9  : 1; /*!< [9..9] Pmn Event Input Data                                               */
                    __IM uint16_t EIDR10 : 1; /*!< [10..10] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR11 : 1; /*!< [11..11] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR12 : 1; /*!< [12..12] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR13 : 1; /*!< [13..13] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR14 : 1; /*!< [14..14] Pmn Event Input Data                                             */
                    __IM uint16_t EIDR15 : 1; /*!< [15..15] Pmn Event Input Data                                             */
                } EIDR_b;
            };

            union
            {
                __IM uint16_t PIDR;           /*!< (@ 0x00000006) Input data register                                        */

                struct
                {
                    __IM uint16_t PIDR0  : 1; /*!< [0..0] Pmn Input Data                                                     */
                    __IM uint16_t PIDR1  : 1; /*!< [1..1] Pmn Input Data                                                     */
                    __IM uint16_t PIDR2  : 1; /*!< [2..2] Pmn Input Data                                                     */
                    __IM uint16_t PIDR3  : 1; /*!< [3..3] Pmn Input Data                                                     */
                    __IM uint16_t PIDR4  : 1; /*!< [4..4] Pmn Input Data                                                     */
                    __IM uint16_t PIDR5  : 1; /*!< [5..5] Pmn Input Data                                                     */
                    __IM uint16_t PIDR6  : 1; /*!< [6..6] Pmn Input Data                                                     */
                    __IM uint16_t PIDR7  : 1; /*!< [7..7] Pmn Input Data                                                     */
                    __IM uint16_t PIDR8  : 1; /*!< [8..8] Pmn Input Data                                                     */
                    __IM uint16_t PIDR9  : 1; /*!< [9..9] Pmn Input Data                                                     */
                    __IM uint16_t PIDR10 : 1; /*!< [10..10] Pmn Input Data                                                   */
                    __IM uint16_t PIDR11 : 1; /*!< [11..11] Pmn Input Data                                                   */
                    __IM uint16_t PIDR12 : 1; /*!< [12..12] Pmn Input Data                                                   */
                    __IM uint16_t PIDR13 : 1; /*!< [13..13] Pmn Input Data                                                   */
                    __IM uint16_t PIDR14 : 1; /*!< [14..14] Pmn Input Data                                                   */
                    __IM uint16_t PIDR15 : 1; /*!< [15..15] Pmn Input Data                                                   */
                } PIDR_b;
            };
        };
    };

    union
    {
        union
        {
            __OM uint32_t PCNTR3;        /*!< (@ 0x00000008) Port Control Register 3                                    */

            struct
            {
                __OM uint32_t POSR : 16; /*!< [15..0] Pmn Output Set                                                    */
                __OM uint32_t PORR : 16; /*!< [31..16] Pmn Output Reset                                                 */
            } PCNTR3_b;
        };

        struct
        {
            union
            {
                __OM uint16_t PORR;           /*!< (@ 0x00000008) Output set register                                        */

                struct
                {
                    __OM uint16_t PORR0  : 1; /*!< [0..0] Pmn Output Reset                                                   */
                    __OM uint16_t PORR1  : 1; /*!< [1..1] Pmn Output Reset                                                   */
                    __OM uint16_t PORR2  : 1; /*!< [2..2] Pmn Output Reset                                                   */
                    __OM uint16_t PORR3  : 1; /*!< [3..3] Pmn Output Reset                                                   */
                    __OM uint16_t PORR4  : 1; /*!< [4..4] Pmn Output Reset                                                   */
                    __OM uint16_t PORR5  : 1; /*!< [5..5] Pmn Output Reset                                                   */
                    __OM uint16_t PORR6  : 1; /*!< [6..6] Pmn Output Reset                                                   */
                    __OM uint16_t PORR7  : 1; /*!< [7..7] Pmn Output Reset                                                   */
                    __OM uint16_t PORR8  : 1; /*!< [8..8] Pmn Output Reset                                                   */
                    __OM uint16_t PORR9  : 1; /*!< [9..9] Pmn Output Reset                                                   */
                    __OM uint16_t PORR10 : 1; /*!< [10..10] Pmn Output Reset                                                 */
                    __OM uint16_t PORR11 : 1; /*!< [11..11] Pmn Output Reset                                                 */
                    __OM uint16_t PORR12 : 1; /*!< [12..12] Pmn Output Reset                                                 */
                    __OM uint16_t PORR13 : 1; /*!< [13..13] Pmn Output Reset                                                 */
                    __OM uint16_t PORR14 : 1; /*!< [14..14] Pmn Output Reset                                                 */
                    __OM uint16_t PORR15 : 1; /*!< [15..15] Pmn Output Reset                                                 */
                } PORR_b;
            };

            union
            {
                __OM uint16_t POSR;           /*!< (@ 0x0000000A) Output reset register                                      */

                struct
                {
                    __OM uint16_t POSR0  : 1; /*!< [0..0] Pmn Output Set                                                     */
                    __OM uint16_t POSR1  : 1; /*!< [1..1] Pmn Output Set                                                     */
                    __OM uint16_t POSR2  : 1; /*!< [2..2] Pmn Output Set                                                     */
                    __OM uint16_t POSR3  : 1; /*!< [3..3] Pmn Output Set                                                     */
                    __OM uint16_t POSR4  : 1; /*!< [4..4] Pmn Output Set                                                     */
                    __OM uint16_t POSR5  : 1; /*!< [5..5] Pmn Output Set                                                     */
                    __OM uint16_t POSR6  : 1; /*!< [6..6] Pmn Output Set                                                     */
                    __OM uint16_t POSR7  : 1; /*!< [7..7] Pmn Output Set                                                     */
                    __OM uint16_t POSR8  : 1; /*!< [8..8] Pmn Output Set                                                     */
                    __OM uint16_t POSR9  : 1; /*!< [9..9] Pmn Output Set                                                     */
                    __OM uint16_t POSR10 : 1; /*!< [10..10] Pmn Output Set                                                   */
                    __OM uint16_t POSR11 : 1; /*!< [11..11] Pmn Output Set                                                   */
                    __OM uint16_t POSR12 : 1; /*!< [12..12] Pmn Output Set                                                   */
                    __OM uint16_t POSR13 : 1; /*!< [13..13] Pmn Output Set                                                   */
                    __OM uint16_t POSR14 : 1; /*!< [14..14] Pmn Output Set                                                   */
                    __OM uint16_t POSR15 : 1; /*!< [15..15] Pmn Output Set                                                   */
                } POSR_b;
            };
        };
    };

    union
    {
        union
        {
            __IOM uint32_t PCNTR4;        /*!< (@ 0x0000000C) Port Control Register 4                                    */

            struct
            {
                __IOM uint32_t EOSR : 16; /*!< [15..0] Pmn Event Output Set                                              */
                __IOM uint32_t EORR : 16; /*!< [31..16] Pmn Event Output Reset                                           */
            } PCNTR4_b;
        };

        struct
        {
            union
            {
                __IOM uint16_t EORR;           /*!< (@ 0x0000000C) Event output set register                                  */

                struct
                {
                    __IOM uint16_t EORR0  : 1; /*!< [0..0] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR1  : 1; /*!< [1..1] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR2  : 1; /*!< [2..2] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR3  : 1; /*!< [3..3] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR4  : 1; /*!< [4..4] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR5  : 1; /*!< [5..5] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR6  : 1; /*!< [6..6] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR7  : 1; /*!< [7..7] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR8  : 1; /*!< [8..8] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR9  : 1; /*!< [9..9] Pmn Event Output Reset                                             */
                    __IOM uint16_t EORR10 : 1; /*!< [10..10] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR11 : 1; /*!< [11..11] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR12 : 1; /*!< [12..12] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR13 : 1; /*!< [13..13] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR14 : 1; /*!< [14..14] Pmn Event Output Reset                                           */
                    __IOM uint16_t EORR15 : 1; /*!< [15..15] Pmn Event Output Reset                                           */
                } EORR_b;
            };

            union
            {
                __IOM uint16_t EOSR;           /*!< (@ 0x0000000E) Event output reset register                                */

                struct
                {
                    __IOM uint16_t EOSR0  : 1; /*!< [0..0] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR1  : 1; /*!< [1..1] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR2  : 1; /*!< [2..2] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR3  : 1; /*!< [3..3] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR4  : 1; /*!< [4..4] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR5  : 1; /*!< [5..5] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR6  : 1; /*!< [6..6] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR7  : 1; /*!< [7..7] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR8  : 1; /*!< [8..8] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR9  : 1; /*!< [9..9] Pmn Event Output Set                                               */
                    __IOM uint16_t EOSR10 : 1; /*!< [10..10] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR11 : 1; /*!< [11..11] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR12 : 1; /*!< [12..12] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR13 : 1; /*!< [13..13] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR14 : 1; /*!< [14..14] Pmn Event Output Set                                             */
                    __IOM uint16_t EOSR15 : 1; /*!< [15..15] Pmn Event Output Set                                             */
                } EOSR_b;
            };
        };
    };
} R_PORT0_Type;                        /*!< Size = 16 (0x10)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_PFS                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-PFS (R_PFS)
 */

typedef struct                           /*!< (@ 0x40040800) R_PFS Structure                                            */
{
    union
    {
        __IOM R_PFS_PORT_Type  PORT[15]; /*!< (@ 0x00000000) Port [0..14]                                               */
        __IOM R_PFS_VLSEL_Type VLSEL;    /*!< (@ 0x00000000) VLSEL                                                      */
    };
} R_PFS_Type;                            /*!< Size = 960 (0x3c0)                                                        */

/* =========================================================================================================================== */
/* ================                                          R_PMISC                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief I/O Ports-MISC (R_PMISC)
 */

typedef struct                         /*!< (@ 0x40040D00) R_PMISC Structure                                          */
{
    union
    {
        __IOM uint8_t PFENET;          /*!< (@ 0x00000000) Ethernet Control Register                                  */

        struct
        {
            uint8_t                : 4;
            __IOM uint8_t PHYMODE0 : 1; /*!< [4..4] Ethernet Mode Setting ch0                                          */
            __IOM uint8_t PHYMODE1 : 1; /*!< [5..5] Ethernet Mode Setting ch1                                          */
            uint8_t                : 2;
        } PFENET_b;
    };
    __IM uint8_t RESERVED[2];

    union
    {
        __IOM uint8_t PWPR;            /*!< (@ 0x00000003) Write-Protect Register                                     */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;   /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;   /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t PWPRS;           /*!< (@ 0x00000005) Write-Protect Register for Secure                          */

        struct
        {
            uint8_t             : 6;
            __IOM uint8_t PFSWE : 1;   /*!< [6..6] PmnPFS Register Write                                              */
            __IOM uint8_t B0WI  : 1;   /*!< [7..7] PFSWE Bit Write Disable                                            */
        } PWPRS_b;
    };
    __IM uint16_t RESERVED2[4];
    __IM uint8_t  RESERVED3;

    union
    {
        __IOM uint8_t PRWCNTR;          /*!< (@ 0x0000000F) Port Read Wait Control Register                            */

        struct
        {
            __IOM uint8_t WAIT : 2;     /*!< [1..0] Wait Cycle Control                                                 */
            uint8_t            : 6;
        } PRWCNTR_b;
    };
    __IOM R_PMISC_PMSAR_Type PMSAR[12]; /*!< (@ 0x00000010) Port Security Attribution Register                         */
} R_PMISC_Type;                         /*!< Size = 40 (0x28)                                                          */

/* =========================================================================================================================== */
/* ================                                           R_RTC                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Realtime Clock (R_RTC)
 */

typedef struct                         /*!< (@ 0x40044000) R_RTC Structure                                            */
{
    union
    {
        __IM uint8_t R64CNT;           /*!< (@ 0x00000000) 64-Hz Counter                                              */

        struct
        {
            __IM uint8_t F64HZ  : 1;   /*!< [0..0] 64Hz Flag                                                          */
            __IM uint8_t F32HZ  : 1;   /*!< [1..1] 32Hz Flag                                                          */
            __IM uint8_t F16HZ  : 1;   /*!< [2..2] 16Hz Flag                                                          */
            __IM uint8_t F8HZ   : 1;   /*!< [3..3] 8Hz Flag                                                           */
            __IM uint8_t F4HZ   : 1;   /*!< [4..4] 4Hz Flag                                                           */
            __IM uint8_t F2HZ   : 1;   /*!< [5..5] 2Hz Flag                                                           */
            __IM uint8_t F1HZ   : 1;   /*!< [6..6] 1Hz Flag                                                           */
            __IM uint8_t R64OVF : 1;   /*!< [7..7] This bit indicates the overflow of F1HZ only when using
                                        *   time error adjustment function inlow-consumption clock
                                        *   mode.                                                                     */
        } R64CNT_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        union
        {
            __IOM uint8_t BCNT0;         /*!< (@ 0x00000002) Binary Counter 0                                           */

            struct
            {
                __IOM uint8_t BCNT0 : 8; /*!< [7..0] The BCNT0 counter is a readable/writable 32-bit binary
                                          *   counter b7 to b0.                                                         */
            } BCNT0_b;
        };

        union
        {
            __IOM uint8_t RSECCNT;       /*!< (@ 0x00000002) Second Counter                                             */

            struct
            {
                __IOM uint8_t SEC1 : 4;  /*!< [3..0] 1-Second Count Counts from 0 to 9 every second. When
                                          *   a carry is generated, 1 is added to the tens place.                       */
                __IOM uint8_t SEC10 : 3; /*!< [6..4] 10-Second Count Counts from 0 to 5 for 60-second counting.         */
                uint8_t             : 1;
            } RSECCNT_b;
        };
    };
    __IM uint8_t RESERVED1;

    union
    {
        union
        {
            __IOM uint8_t BCNT1;         /*!< (@ 0x00000004) Binary Counter 1                                           */

            struct
            {
                __IOM uint8_t BCNT1 : 8; /*!< [7..0] The BCNT1 counter is a readable/writable 32-bit binary
                                          *   counter b15 to b8.                                                        */
            } BCNT1_b;
        };

        union
        {
            __IOM uint8_t RMINCNT;       /*!< (@ 0x00000004) Minute Counter                                             */

            struct
            {
                __IOM uint8_t MIN1 : 4;  /*!< [3..0] 1-Minute Count Counts from 0 to 9 every minute. When
                                          *   a carry is generated, 1 is added to the tens place.                       */
                __IOM uint8_t MIN10 : 3; /*!< [6..4] 10-Minute Count Counts from 0 to 5 for 60-minute counting.         */
                uint8_t             : 1;
            } RMINCNT_b;
        };
    };
    __IM uint8_t RESERVED2;

    union
    {
        union
        {
            __IOM uint8_t BCNT2;         /*!< (@ 0x00000006) Binary Counter 2                                           */

            struct
            {
                __IOM uint8_t BCNT2 : 8; /*!< [7..0] The BCNT2 counter is a readable/writable 32-bit binary
                                          *   counter b23 to b16.                                                       */
            } BCNT2_b;
        };

        union
        {
            __IOM uint8_t RHRCNT;       /*!< (@ 0x00000006) Hour Counter                                               */

            struct
            {
                __IOM uint8_t HR1 : 4;  /*!< [3..0] 1-Hour Count Counts from 0 to 9 once per hour. When a
                                         *   carry is generated, 1 is added to the tens place.                         */
                __IOM uint8_t HR10 : 2; /*!< [5..4] 10-Hour Count Counts from 0 to 2 once per carry from
                                         *   the ones place.                                                           */
                __IOM uint8_t PM : 1;   /*!< [6..6] Time Counter Setting for a.m./p.m.                                 */
                uint8_t          : 1;
            } RHRCNT_b;
        };
    };
    __IM uint8_t RESERVED3;

    union
    {
        union
        {
            __IOM uint8_t BCNT3;         /*!< (@ 0x00000008) Binary Counter 3                                           */

            struct
            {
                __IOM uint8_t BCNT3 : 8; /*!< [7..0] The BCNT3 counter is a readable/writable 32-bit binary
                                          *   counter b31 to b24.                                                       */
            } BCNT3_b;
        };

        union
        {
            __IOM uint8_t RWKCNT;       /*!< (@ 0x00000008) Day-of-Week Counter                                        */

            struct
            {
                __IOM uint8_t DAYW : 3; /*!< [2..0] Day-of-Week Counting                                               */
                uint8_t            : 5;
            } RWKCNT_b;
        };
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IOM uint8_t RDAYCNT;         /*!< (@ 0x0000000A) Day Counter                                                */

        struct
        {
            __IOM uint8_t DATE1 : 4;   /*!< [3..0] 1-Day Count Counts from 0 to 9 once per day. When a carry
                                        *   is generated, 1 is added to the tens place.                               */
            __IOM uint8_t DATE10 : 2;  /*!< [5..4] 10-Day Count Counts from 0 to 3 once per carry from the
                                        *   ones place.                                                               */
            uint8_t : 2;
        } RDAYCNT_b;
    };
    __IM uint8_t RESERVED5;

    union
    {
        __IOM uint8_t RMONCNT;         /*!< (@ 0x0000000C) Month Counter                                              */

        struct
        {
            __IOM uint8_t MON1 : 4;    /*!< [3..0] 1-Month Count Counts from 0 to 9 once per month. When
                                        *   a carry is generated, 1 is added to the tens place.                       */
            __IOM uint8_t MON10 : 1;   /*!< [4..4] 10-Month Count Counts from 0 to 1 once per carry from
                                        *   the ones place.                                                           */
            uint8_t : 3;
        } RMONCNT_b;
    };
    __IM uint8_t RESERVED6;

    union
    {
        __IOM uint16_t RYRCNT;         /*!< (@ 0x0000000E) Year Counter                                               */

        struct
        {
            __IOM uint16_t YR1 : 4;    /*!< [3..0] 1-Year Count Counts from 0 to 9 once per year. When a
                                        *   carry is generated, 1 is added to the tens place.                         */
            __IOM uint16_t YR10 : 4;   /*!< [7..4] 10-Year Count Counts from 0 to 9 once per carry from
                                        *   ones place. When a carry is generated in the tens place,
                                        *   1 is added to the hundreds place.                                         */
            uint16_t : 8;
        } RYRCNT_b;
    };

    union
    {
        union
        {
            __IOM uint8_t BCNT0AR;         /*!< (@ 0x00000010) Binary Counter 0 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT0AR : 8; /*!< [7..0] he BCNT0AR counter is a readable/writable alarm register
                                            *   corresponding to 32-bit binary counter b7 to b0.                          */
            } BCNT0AR_b;
        };

        union
        {
            __IOM uint8_t RSECAR;        /*!< (@ 0x00000010) Second Alarm Register                                      */

            struct
            {
                __OM uint8_t  SEC1  : 4; /*!< [3..0] 1-Second Value for the ones place of seconds                       */
                __IOM uint8_t SEC10 : 3; /*!< [6..4] 10-Seconds Value for the tens place of seconds                     */
                __IOM uint8_t ENB   : 1; /*!< [7..7] Compare enable                                                     */
            } RSECAR_b;
        };
    };
    __IM uint8_t RESERVED7;

    union
    {
        union
        {
            __IOM uint8_t BCNT1AR;         /*!< (@ 0x00000012) Binary Counter 1 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT1AR : 8; /*!< [7..0] he BCNT1AR counter is a readable/writable alarm register
                                            *   corresponding to 32-bit binary counter b15 to b8.                         */
            } BCNT1AR_b;
        };

        union
        {
            __IOM uint8_t RMINAR;        /*!< (@ 0x00000012) Minute Alarm Register                                      */

            struct
            {
                __IOM uint8_t MIN1  : 4; /*!< [3..0] 1-Minute Count Value for the ones place of minutes                 */
                __IOM uint8_t MIN10 : 3; /*!< [6..4] 10-Minute Count Value for the tens place of minutes                */
                __IOM uint8_t ENB   : 1; /*!< [7..7] Compare enable                                                     */
            } RMINAR_b;
        };
    };
    __IM uint8_t RESERVED8;

    union
    {
        union
        {
            __IOM uint8_t BCNT2AR;         /*!< (@ 0x00000014) Binary Counter 2 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT2AR : 8; /*!< [7..0] The BCNT2AR counter is a readable/writable 32-bit binary
                                            *   counter b23 to b16.                                                       */
            } BCNT2AR_b;
        };

        union
        {
            __IOM uint8_t RHRAR;        /*!< (@ 0x00000014) Hour Alarm Register                                        */

            struct
            {
                __IOM uint8_t HR1  : 4; /*!< [3..0] 1-Hour Count Value for the ones place of hours                     */
                __IOM uint8_t HR10 : 2; /*!< [5..4] 10-Hour Count Value for the tens place of hours                    */
                __IOM uint8_t PM   : 1; /*!< [6..6] Time Counter Setting for a.m./p.m.                                 */
                __IOM uint8_t ENB  : 1; /*!< [7..7] Compare enable                                                     */
            } RHRAR_b;
        };
    };
    __IM uint8_t RESERVED9;

    union
    {
        union
        {
            __IOM uint8_t BCNT3AR;         /*!< (@ 0x00000016) Binary Counter 3 Alarm Register                            */

            struct
            {
                __IOM uint8_t BCNT3AR : 8; /*!< [7..0] The BCNT3AR counter is a readable/writable 32-bit binary
                                            *   counter b31 to b24.                                                       */
            } BCNT3AR_b;
        };

        union
        {
            __IOM uint8_t RWKAR;        /*!< (@ 0x00000016) Day-of-Week Alarm Register                                 */

            struct
            {
                __IOM uint8_t DAYW : 3; /*!< [2..0] Day-of-Week Counting                                               */
                uint8_t            : 4;
                __IOM uint8_t ENB  : 1; /*!< [7..7] Compare enable                                                     */
            } RWKAR_b;
        };
    };
    __IM uint8_t RESERVED10;

    union
    {
        union
        {
            __IOM uint8_t BCNT0AER;    /*!< (@ 0x00000018) Binary Counter 0 Alarm Enable Register                     */

            struct
            {
                __IOM uint8_t ENB : 8; /*!< [7..0] The BCNT0AER register is a readable/writable register
                                        *   for setting the alarm enable corresponding to 32-bit binary
                                        *   counter b7 to b0.                                                         */
            } BCNT0AER_b;
        };

        union
        {
            __IOM uint8_t RDAYAR;         /*!< (@ 0x00000018) Date Alarm Register                                        */

            struct
            {
                __IOM uint8_t DATE1  : 4; /*!< [3..0] 1 Day Value for the ones place of days                             */
                __IOM uint8_t DATE10 : 2; /*!< [5..4] 10 Days Value for the tens place of days                           */
                uint8_t              : 1;
                __IOM uint8_t ENB    : 1; /*!< [7..7] Compare enable                                                     */
            } RDAYAR_b;
        };
    };
    __IM uint8_t RESERVED11;

    union
    {
        union
        {
            __IOM uint8_t BCNT1AER;    /*!< (@ 0x0000001A) Binary Counter 1 Alarm Enable Register                     */

            struct
            {
                __IOM uint8_t ENB : 8; /*!< [7..0] The BCNT1AER register is a readable/writable register
                                        *   for setting the alarm enable corresponding to 32-bit binary
                                        *   counter b15 to b8.                                                        */
            } BCNT1AER_b;
        };

        union
        {
            __IOM uint8_t RMONAR;        /*!< (@ 0x0000001A) Month Alarm Register                                       */

            struct
            {
                __IOM uint8_t MON1  : 4; /*!< [3..0] 1 Month Value for the ones place of months                         */
                __IOM uint8_t MON10 : 1; /*!< [4..4] 10 Months Value for the tens place of months                       */
                uint8_t             : 2;
                __IOM uint8_t ENB   : 1; /*!< [7..7] Compare enable                                                     */
            } RMONAR_b;
        };
    };
    __IM uint8_t RESERVED12;

    union
    {
        union
        {
            __IOM uint16_t BCNT2AER;    /*!< (@ 0x0000001C) Binary Counter 2 Alarm Enable Register                     */

            struct
            {
                __IOM uint16_t ENB : 8; /*!< [7..0] The BCNT2AER register is a readable/writable register
                                         *   for setting the alarm enable corresponding to 32-bit binary
                                         *   counter b23 to b16.                                                       */
                uint16_t : 8;
            } BCNT2AER_b;
        };

        union
        {
            __IOM uint16_t RYRAR;        /*!< (@ 0x0000001C) Year Alarm Register                                        */

            struct
            {
                __IOM uint16_t YR1  : 4; /*!< [3..0] 1 Year Value for the ones place of years                           */
                __IOM uint16_t YR10 : 4; /*!< [7..4] 10 Years Value for the tens place of years                         */
                uint16_t            : 8;
            } RYRAR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t BCNT3AER;    /*!< (@ 0x0000001E) Binary Counter 3 Alarm Enable Register                     */

            struct
            {
                __IOM uint8_t ENB : 8; /*!< [7..0] The BCNT3AER register is a readable/writable register
                                        *   for setting the alarm enable corresponding to 32-bit binary
                                        *   counter b31 to b24.                                                       */
            } BCNT3AER_b;
        };

        union
        {
            __IOM uint8_t RYRAREN;     /*!< (@ 0x0000001E) Year Alarm Enable Register                                 */

            struct
            {
                uint8_t           : 7;
                __IOM uint8_t ENB : 1; /*!< [7..7] Compare enable                                                     */
            } RYRAREN_b;
        };
    };
    __IM uint8_t  RESERVED13;
    __IM uint16_t RESERVED14;

    union
    {
        __IOM uint8_t RCR1;            /*!< (@ 0x00000022) RTC Control Register 1                                     */

        struct
        {
            __IOM uint8_t AIE   : 1;   /*!< [0..0] Alarm Interrupt Enable                                             */
            __IOM uint8_t CIE   : 1;   /*!< [1..1] Carry Interrupt Enable                                             */
            __IOM uint8_t PIE   : 1;   /*!< [2..2] Periodic Interrupt Enable                                          */
            __IOM uint8_t RTCOS : 1;   /*!< [3..3] RTCOUT Output Select                                               */
            __IOM uint8_t PES   : 4;   /*!< [7..4] Periodic Interrupt Select                                          */
        } RCR1_b;
    };
    __IM uint8_t RESERVED15;

    union
    {
        __IOM uint8_t RCR2;            /*!< (@ 0x00000024) RTC Control Register 2                                     */

        struct
        {
            __IOM uint8_t START : 1;   /*!< [0..0] Start                                                              */
            __IOM uint8_t RESET : 1;   /*!< [1..1] RTC Software Reset                                                 */
            __IOM uint8_t ADJ30 : 1;   /*!< [2..2] 30-Second Adjustment                                               */
            __IOM uint8_t RTCOE : 1;   /*!< [3..3] RTCOUT Output Enable                                               */
            __IOM uint8_t AADJE : 1;   /*!< [4..4] Automatic Adjustment Enable (When the LOCO clock is selected,
                                        *   the setting of this bit is disabled.)                                     */
            __IOM uint8_t AADJP : 1;   /*!< [5..5] Automatic Adjustment Period Select (When the LOCO clock
                                        *   is selected, the setting of this bit is disabled.)                        */
            __IOM uint8_t HR24  : 1;   /*!< [6..6] Hours Mode                                                         */
            __IOM uint8_t CNTMD : 1;   /*!< [7..7] Count Mode Select                                                  */
        } RCR2_b;
    };
    __IM uint8_t  RESERVED16;
    __IM uint16_t RESERVED17;

    union
    {
        __IOM uint8_t RCR4;            /*!< (@ 0x00000028) RTC Control Register 4                                     */

        struct
        {
            __IOM uint8_t RCKSEL : 1;  /*!< [0..0] Count Source Select                                                */
            uint8_t              : 6;
            __IOM uint8_t ROPSEL : 1;  /*!< [7..7] RTC Operation Mode Select                                          */
        } RCR4_b;
    };
    __IM uint8_t RESERVED18;

    union
    {
        __IOM uint16_t RFRH;           /*!< (@ 0x0000002A) Frequency Register H                                       */

        struct
        {
            __IOM uint16_t RFC16 : 1;  /*!< [0..0] Frequency Comparison Value (b16) To generate the operating
                                        *   clock from the LOCOclock, this bit sets the comparison
                                        *   value of the 128-Hz clock cycle.                                          */
            uint16_t : 15;
        } RFRH_b;
    };

    union
    {
        __IOM uint16_t RFRL;           /*!< (@ 0x0000002C) Frequency Register L                                       */

        struct
        {
            __IOM uint16_t RFC : 16;   /*!< [15..0] Frequency Comparison Value(b15-b0) To generate the operating
                                        *   clock from the main clock, this bit sets the comparison
                                        *   value of the 128-Hz clock cycle.                                          */
        } RFRL_b;
    };

    union
    {
        __IOM uint8_t RADJ;            /*!< (@ 0x0000002E) Time Error Adjustment Register                             */

        struct
        {
            __IOM uint8_t ADJ : 6;     /*!< [5..0] Adjustment Value These bits specify the adjustment value
                                        *   from the prescaler.                                                       */
            __IOM uint8_t PMADJ : 2;   /*!< [7..6] Plus-Minus                                                         */
        } RADJ_b;
    };
    __IM uint8_t           RESERVED19;
    __IM uint16_t          RESERVED20[8];
    __IOM R_RTC_RTCCR_Type RTCCR[3];   /*!< (@ 0x00000040) Time Capture Control Register                              */
    __IM uint16_t          RESERVED21[5];
    __IOM R_RTC_CP_Type    CP[3];      /*!< (@ 0x00000050) Capture registers                                          */
} R_RTC_Type;                          /*!< Size = 128 (0x80)                                                         */

/* =========================================================================================================================== */
/* ================                                          R_SCI0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Serial Communications Interface (R_SCI0)
 */

typedef struct                         /*!< (@ 0x40070000) R_SCI0 Structure                                           */
{
    union
    {
        union
        {
            __IOM uint8_t SMR;          /*!< (@ 0x00000000) Serial Mode Register (SCMR.SMIF = 0)                       */

            struct
            {
                __IOM uint8_t CKS  : 2; /*!< [1..0] Clock Select                                                       */
                __IOM uint8_t MP   : 1; /*!< [2..2] Multi-Processor Mode(Valid only in asynchronous mode)              */
                __IOM uint8_t STOP : 1; /*!< [3..3] Stop Bit Length(Valid only in asynchronous mode)                   */
                __IOM uint8_t PM   : 1; /*!< [4..4] Parity Mode (Valid only when the PE bit is 1)                      */
                __IOM uint8_t PE   : 1; /*!< [5..5] Parity Enable(Valid only in asynchronous mode)                     */
                __IOM uint8_t CHR  : 1; /*!< [6..6] Character Length(Valid only in asynchronous mode)                  */
                __IOM uint8_t CM   : 1; /*!< [7..7] Communication Mode                                                 */
            } SMR_b;
        };

        union
        {
            __IOM uint8_t SMR_SMCI;    /*!< (@ 0x00000000) Serial mode register (SCMR.SMIF = 1)                       */

            struct
            {
                __IOM uint8_t CKS : 2; /*!< [1..0] Clock Select                                                       */
                __IOM uint8_t BCP : 2; /*!< [3..2] Base Clock Pulse(Valid only in asynchronous mode)                  */
                __IOM uint8_t PM  : 1; /*!< [4..4] Parity Mode (Valid only when the PE bit is 1)                      */
                __IOM uint8_t PE  : 1; /*!< [5..5] Parity Enable(Valid only in asynchronous mode)                     */
                __IOM uint8_t BLK : 1; /*!< [6..6] Block Transfer Mode                                                */
                __IOM uint8_t GM  : 1; /*!< [7..7] GSM Mode                                                           */
            } SMR_SMCI_b;
        };
    };

    union
    {
        __IOM uint8_t BRR;             /*!< (@ 0x00000001) Bit Rate Register                                          */

        struct
        {
            __IOM uint8_t BRR : 8;     /*!< [7..0] BRR is an 8-bit register that adjusts the bit rate.                */
        } BRR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t SCR;          /*!< (@ 0x00000002) Serial Control Register (SCMR.SMIF = 0)                    */

            struct
            {
                __IOM uint8_t CKE  : 2; /*!< [1..0] Clock Enable                                                       */
                __IOM uint8_t TEIE : 1; /*!< [2..2] Transmit End Interrupt Enable                                      */
                __IOM uint8_t MPIE : 1; /*!< [3..3] Multi-Processor Interrupt Enable(Valid in asynchronous
                                         *   mode when SMR.MP = 1)                                                     */
                __IOM uint8_t RE  : 1;  /*!< [4..4] Receive Enable                                                     */
                __IOM uint8_t TE  : 1;  /*!< [5..5] Transmit Enable                                                    */
                __IOM uint8_t RIE : 1;  /*!< [6..6] Receive Interrupt Enable                                           */
                __IOM uint8_t TIE : 1;  /*!< [7..7] Transmit Interrupt Enable                                          */
            } SCR_b;
        };

        union
        {
            __IOM uint8_t SCR_SMCI;     /*!< (@ 0x00000002) Serial Control Register (SCMR.SMIF =1)                     */

            struct
            {
                __IOM uint8_t CKE  : 2; /*!< [1..0] Clock Enable                                                       */
                __IOM uint8_t TEIE : 1; /*!< [2..2] Transmit End Interrupt Enable                                      */
                __IOM uint8_t MPIE : 1; /*!< [3..3] Multi-Processor Interrupt Enable                                   */
                __IOM uint8_t RE   : 1; /*!< [4..4] Receive Enable                                                     */
                __IOM uint8_t TE   : 1; /*!< [5..5] Transmit Enable                                                    */
                __IOM uint8_t RIE  : 1; /*!< [6..6] Receive Interrupt Enable                                           */
                __IOM uint8_t TIE  : 1; /*!< [7..7] Transmit Interrupt Enable                                          */
            } SCR_SMCI_b;
        };
    };

    union
    {
        __IOM uint8_t TDR;             /*!< (@ 0x00000003) Transmit Data Register                                     */

        struct
        {
            __IOM uint8_t TDR : 8;     /*!< [7..0] TDR is an 8-bit register that stores transmit data.                */
        } TDR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t SSR;          /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 0 and FCR.FM=0)         */

            struct
            {
                __IOM uint8_t MPBT : 1; /*!< [0..0] Multi-Processor Bit Transfer                                       */
                __IM uint8_t  MPB  : 1; /*!< [1..1] Multi-Processor                                                    */
                __IM uint8_t  TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t FER  : 1; /*!< [4..4] Framing Error Flag                                                 */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDRF : 1; /*!< [6..6] Receive Data Full Flag                                             */
                __IOM uint8_t TDRE : 1; /*!< [7..7] Transmit Data Empty Flag                                           */
            } SSR_b;
        };

        union
        {
            __IOM uint8_t SSR_FIFO;     /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 0 and FCR.FM=1)         */

            struct
            {
                __IOM uint8_t DR : 1;   /*!< [0..0] Receive Data Ready flag(Valid only in asynchronous mode(including
                                         *   multi-processor) and FIFO selected)                                       */
                uint8_t            : 1;
                __IOM uint8_t TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t FER  : 1; /*!< [4..4] Framing Error Flag                                                 */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDF  : 1; /*!< [6..6] Receive FIFO data full flag                                        */
                __IOM uint8_t TDFE : 1; /*!< [7..7] Transmit FIFO data empty flag                                      */
            } SSR_FIFO_b;
        };

        union
        {
            __IOM uint8_t SSR_SMCI;     /*!< (@ 0x00000004) Serial Status Register(SCMR.SMIF = 1)                      */

            struct
            {
                __IOM uint8_t MPBT : 1; /*!< [0..0] Multi-Processor Bit TransferThis bit should be 0 in smart
                                         *   card interface mode.                                                      */
                __IM uint8_t MPB : 1;   /*!< [1..1] Multi-ProcessorThis bit should be 0 in smart card interface
                                         *   mode.                                                                     */
                __IM uint8_t  TEND : 1; /*!< [2..2] Transmit End Flag                                                  */
                __IOM uint8_t PER  : 1; /*!< [3..3] Parity Error Flag                                                  */
                __IOM uint8_t ERS  : 1; /*!< [4..4] Error Signal Status Flag                                           */
                __IOM uint8_t ORER : 1; /*!< [5..5] Overrun Error Flag                                                 */
                __IOM uint8_t RDRF : 1; /*!< [6..6] Receive Data Full Flag                                             */
                __IOM uint8_t TDRE : 1; /*!< [7..7] Transmit Data Empty Flag                                           */
            } SSR_SMCI_b;
        };
    };

    union
    {
        __IM uint8_t RDR;              /*!< (@ 0x00000005) Receive Data Register                                      */

        struct
        {
            __IM uint8_t RDR : 8;      /*!< [7..0] RDR is an 8-bit register that stores receive data.                 */
        } RDR_b;
    };

    union
    {
        __IOM uint8_t SCMR;            /*!< (@ 0x00000006) Smart Card Mode Register                                   */

        struct
        {
            __IOM uint8_t SMIF : 1;    /*!< [0..0] Smart Card Interface Mode Select                                   */
            uint8_t            : 1;
            __IOM uint8_t SINV : 1;    /*!< [2..2] Transmitted/Received Data InvertSet this bit to 0 if
                                        *   operation is to be in simple I2C mode.                                    */
            __IOM uint8_t SDIR : 1;    /*!< [3..3] Transmitted/Received Data Transfer DirectionNOTE: The
                                        *   setting is invalid and a fixed data length of 8 bits is
                                        *   used in modes other than asynchronous mode.Set this bit
                                        *   to 1 if operation is to be in simple I2C mode.                            */
            __IOM uint8_t CHR1 : 1;    /*!< [4..4] Character Length 1(Only valid in asynchronous mode)                */
            uint8_t            : 2;
            __IOM uint8_t BCP2 : 1;    /*!< [7..7] Base Clock Pulse 2Selects the number of base clock cycles
                                        *   in combination with the SMR.BCP[1:0] bits                                 */
        } SCMR_b;
    };

    union
    {
        __IOM uint8_t SEMR;            /*!< (@ 0x00000007) Serial Extended Mode Register                              */

        struct
        {
            __IOM uint8_t ACS0 : 1;    /*!< [0..0] Asynchronous Mode Clock Source Select (Valid only in
                                        *   asynchronous mode).                                                       */
            __IOM uint8_t PADIS : 1;   /*!< [1..1] Preamble function Disable (Valid only in asynchronous
                                        *   mode).                                                                    */
            __IOM uint8_t BRME  : 1;   /*!< [2..2] Bit Rate Modulation Enable                                         */
            __IOM uint8_t ABCSE : 1;   /*!< [3..3] Asynchronous Mode Extended Base Clock Select 1(Valid
                                        *   only in asynchronous mode and SCR.CKE[1]=0)                               */
            __IOM uint8_t ABCS : 1;    /*!< [4..4] Asynchronous Mode Base Clock Select(Valid only in asynchronous
                                        *   mode)                                                                     */
            __IOM uint8_t NFEN : 1;    /*!< [5..5] Digital Noise Filter Function Enable(The NFEN bit should
                                        *   be 0 without simple I2C mode and asynchronous mode.)In
                                        *   asynchronous mode, for RXDn input only. In simple I2C mode,
                                        *   for RXDn/TxDn input.                                                      */
            __IOM uint8_t BGDM : 1;    /*!< [6..6] Baud Rate Generator Double-Speed Mode Select(Only valid
                                        *   the CKE[1] bit in SCR is 0 in asynchronous mode).                         */
            __IOM uint8_t RXDESEL : 1; /*!< [7..7] Asynchronous Start Bit Edge Detection Select(Valid only
                                        *   in asynchronous mode)                                                     */
        } SEMR_b;
    };

    union
    {
        __IOM uint8_t SNFR;            /*!< (@ 0x00000008) Noise Filter Setting Register                              */

        struct
        {
            __IOM uint8_t NFCS : 3;    /*!< [2..0] Noise Filter Clock Select                                          */
            uint8_t            : 5;
        } SNFR_b;
    };

    union
    {
        __IOM uint8_t SIMR1;           /*!< (@ 0x00000009) I2C Mode Register 1                                        */

        struct
        {
            __IOM uint8_t IICM  : 1;   /*!< [0..0] Simple I2C Mode Select                                             */
            uint8_t             : 2;
            __IOM uint8_t IICDL : 5;   /*!< [7..3] SDA Delay Output SelectCycles below are of the clock
                                        *   signal from the on-chip baud rate generator.                              */
        } SIMR1_b;
    };

    union
    {
        __IOM uint8_t SIMR2;           /*!< (@ 0x0000000A) I2C Mode Register 2                                        */

        struct
        {
            __IOM uint8_t IICINTM : 1; /*!< [0..0] I2C Interrupt Mode Select                                          */
            __IOM uint8_t IICCSC  : 1; /*!< [1..1] Clock Synchronization                                              */
            uint8_t               : 3;
            __IOM uint8_t IICACKT : 1; /*!< [5..5] ACK Transmission Data                                              */
            uint8_t               : 2;
        } SIMR2_b;
    };

    union
    {
        __IOM uint8_t SIMR3;              /*!< (@ 0x0000000B) I2C Mode Register 3                                        */

        struct
        {
            __IOM uint8_t IICSTAREQ  : 1; /*!< [0..0] Start Condition Generation                                         */
            __IOM uint8_t IICRSTAREQ : 1; /*!< [1..1] Restart Condition Generation                                       */
            __IOM uint8_t IICSTPREQ  : 1; /*!< [2..2] Stop Condition Generation                                          */
            __IOM uint8_t IICSTIF    : 1; /*!< [3..3] Issuing of Start, Restart, or Stop Condition Completed
                                           *   Flag(When 0 is written to IICSTIF, it is cleared to 0.)                   */
            __IOM uint8_t IICSDAS : 2;    /*!< [5..4] SDA Output Select                                                  */
            __IOM uint8_t IICSCLS : 2;    /*!< [7..6] SCL Output Select                                                  */
        } SIMR3_b;
    };

    union
    {
        __IM uint8_t SISR;             /*!< (@ 0x0000000C) I2C Status Register                                        */

        struct
        {
            __IM uint8_t IICACKR : 1;  /*!< [0..0] ACK Reception Data Flag                                            */
            uint8_t              : 7;
        } SISR_b;
    };

    union
    {
        __IOM uint8_t SPMR;            /*!< (@ 0x0000000D) SPI Mode Register                                          */

        struct
        {
            __IOM uint8_t SSE    : 1;  /*!< [0..0] SSn Pin Function Enable                                            */
            __IOM uint8_t CTSE   : 1;  /*!< [1..1] CTS Enable                                                         */
            __IOM uint8_t MSS    : 1;  /*!< [2..2] Master Slave Select                                                */
            __IOM uint8_t CSTPEN : 1;  /*!< [3..3] CTS external pin Enable                                            */
            __IOM uint8_t MFF    : 1;  /*!< [4..4] Mode Fault Flag                                                    */
            uint8_t              : 1;
            __IOM uint8_t CKPOL  : 1;  /*!< [6..6] Clock Polarity Select                                              */
            __IOM uint8_t CKPH   : 1;  /*!< [7..7] Clock Phase Select                                                 */
        } SPMR_b;
    };

    union
    {
        union
        {
            __IOM uint16_t TDRHL;         /*!< (@ 0x0000000E) Transmit 9-bit Data Register                               */

            struct
            {
                __OM uint16_t TDRHL : 16; /*!< [15..0] TDRHL is a 16-bit register that stores transmit data.             */
            } TDRHL_b;
        };

        union
        {
            __OM uint16_t FTDRHL;       /*!< (@ 0x0000000E) Transmit FIFO Data Register HL                             */

            struct
            {
                __OM uint16_t TDAT : 9; /*!< [8..0] Serial transmit data (Valid only in asynchronous mode(including
                                         *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                __OM uint16_t MPBT : 1; /*!< [9..9] Multi-processor transfer bit flag(Valid only in asynchronous
                                         *   mode and SMR.MP=1 and FIFO selected)                                      */
                uint16_t : 6;
            } FTDRHL_b;
        };

        struct
        {
            union
            {
                __OM uint8_t FTDRH;         /*!< (@ 0x0000000E) Transmit FIFO Data Register H                              */

                struct
                {
                    __OM uint8_t TDATH : 1; /*!< [0..0] Serial transmit data (b8) (Valid only in asynchronous
                                             *   mode(including multi-processor) or clock synchronous mode,
                                             *   and FIFO selected)                                                        */
                    __OM uint8_t MPBT : 1;  /*!< [1..1] Multi-processor transfer bit flag(Valid only in asynchronous
                                             *   mode and SMR.MP=1 and FIFO selected)                                      */
                    uint8_t : 6;
                } FTDRH_b;
            };

            union
            {
                __OM uint8_t FTDRL;         /*!< (@ 0x0000000F) Transmit FIFO Data Register L                              */

                struct
                {
                    __OM uint8_t TDATL : 8; /*!< [7..0] Serial transmit data(b7-b0) (Valid only in asynchronous
                                             *   mode(including multi-processor) or clock synchronous mode,
                                             *   and FIFO selected)                                                        */
                } FTDRL_b;
            };
        };
    };

    union
    {
        union
        {
            __IM uint16_t RDRHL;          /*!< (@ 0x00000010) Receive 9-bit Data Register                                */

            struct
            {
                __IM uint16_t RDRHL : 16; /*!< [15..0] RDRHL is an 16-bit register that stores receive data.             */
            } RDRHL_b;
        };

        union
        {
            __IM uint16_t FRDRHL;       /*!< (@ 0x00000010) Receive FIFO Data Register HL                              */

            struct
            {
                __IM uint16_t RDAT : 9; /*!< [8..0] Serial receive data(Valid only in asynchronous mode(including
                                         *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                __IM uint16_t MPB : 1;  /*!< [9..9] Multi-processor bit flag(Valid only in asynchronous mode
                                         *   with SMR.MP=1 and FIFO selected) It can read multi-processor
                                         *   bit corresponded to serial receive data(RDATA[8:0])                       */
                __IM uint16_t DR   : 1; /*!< [10..10] Receive data ready flag(It is same as SSR.DR)                    */
                __IM uint16_t PER  : 1; /*!< [11..11] Parity error flag                                                */
                __IM uint16_t FER  : 1; /*!< [12..12] Framing error flag                                               */
                __IM uint16_t ORER : 1; /*!< [13..13] Overrun error flag(It is same as SSR.ORER)                       */
                __IM uint16_t RDF  : 1; /*!< [14..14] Receive FIFO data full flag(It is same as SSR.RDF)               */
                uint16_t           : 1;
            } FRDRHL_b;
        };

        struct
        {
            union
            {
                __IM uint8_t FRDRH;         /*!< (@ 0x00000010) Receive FIFO Data Register H                               */

                struct
                {
                    __IM uint8_t RDATH : 1; /*!< [0..0] Serial receive data(b8)(Valid only in asynchronous mode(including
                                             *   multi-processor) or clock synchronous mode, and FIFO selected)            */
                    __IM uint8_t MPB : 1;   /*!< [1..1] Multi-processor bit flag(Valid only in asynchronous mode
                                             *   with SMR.MP=1 and FIFO selected) It can read multi-processor
                                             *   bit corresponded to serial receive data(RDATA[8:0])                       */
                    __IM uint8_t DR   : 1;  /*!< [2..2] Receive data ready flag(It is same as SSR.DR)                      */
                    __IM uint8_t PER  : 1;  /*!< [3..3] Parity error flag                                                  */
                    __IM uint8_t FER  : 1;  /*!< [4..4] Framing error flag                                                 */
                    __IM uint8_t ORER : 1;  /*!< [5..5] Overrun error flag(It is same as SSR.ORER)                         */
                    __IM uint8_t RDF  : 1;  /*!< [6..6] Receive FIFO data full flag(It is same as SSR.RDF)                 */
                    uint8_t           : 1;
                } FRDRH_b;
            };

            union
            {
                __IM uint8_t FRDRL;         /*!< (@ 0x00000011) Receive FIFO Data Register L                               */

                struct
                {
                    __IM uint8_t RDATL : 8; /*!< [7..0] Serial receive data(Valid only in asynchronous mode(including
                                             *   multi-processor) or clock synchronous mode, and FIFO selected)NOTE:
                                             *   When reading both of FRDRH register and FRDRL register,
                                             *   please read by an order of the FRDRH register and the FRDRL
                                             *   register.                                                                 */
                } FRDRL_b;
            };
        };
    };

    union
    {
        __IOM uint8_t MDDR;            /*!< (@ 0x00000012) Modulation Duty Register                                   */

        struct
        {
            __IOM uint8_t MDDR : 8;    /*!< [7..0] MDDR corrects the bit rate adjusted by the BRR register.           */
        } MDDR_b;
    };

    union
    {
        __IOM uint8_t DCCR;            /*!< (@ 0x00000013) Data Compare Match Control Register                        */

        struct
        {
            __IOM uint8_t DCMF  : 1;   /*!< [0..0] Data Compare Match Flag                                            */
            uint8_t             : 2;
            __IOM uint8_t DPER  : 1;   /*!< [3..3] Data Compare Match Parity Error Flag                               */
            __IOM uint8_t DFER  : 1;   /*!< [4..4] Data Compare Match Framing Error Flag                              */
            uint8_t             : 1;
            __IOM uint8_t IDSEL : 1;   /*!< [6..6] ID frame select(Valid only in asynchronous mode(including
                                        *   multi-processor)                                                          */
            __IOM uint8_t DCME : 1;    /*!< [7..7] Data Compare Match Enable(Valid only in asynchronous
                                        *   mode(including multi-processor)                                           */
        } DCCR_b;
    };

    union
    {
        __IOM uint16_t FCR;            /*!< (@ 0x00000014) FIFO Control Register                                      */

        struct
        {
            __IOM uint16_t FM : 1;     /*!< [0..0] FIFO Mode Select(Valid only in asynchronous mode(including
                                        *   multi-processor) or clock synchronous mode)                               */
            __IOM uint16_t RFRST : 1;  /*!< [1..1] Receive FIFO Data Register Reset(Valid only in FCR.FM=1)           */
            __IOM uint16_t TFRST : 1;  /*!< [2..2] Transmit FIFO Data Register Reset(Valid only in FCR.FM=1)          */
            __IOM uint16_t DRES  : 1;  /*!< [3..3] Receive data ready error select bit(When detecting a
                                        *   reception data ready, the interrupt request is selected.)                 */
            __IOM uint16_t TTRG : 4;   /*!< [7..4] Transmit FIFO data trigger number(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode)                */
            __IOM uint16_t RTRG : 4;   /*!< [11..8] Receive FIFO data trigger number(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode)                */
            __IOM uint16_t RSTRG : 4;  /*!< [15..12] RTS Output Active Trigger Number Select(Valid only
                                        *   in asynchronous mode(including multi-processor) or clock
                                        *   synchronous mode)                                                         */
        } FCR_b;
    };

    union
    {
        __IM uint16_t FDR;             /*!< (@ 0x00000016) FIFO Data Count Register                                   */

        struct
        {
            __IM uint16_t R : 5;       /*!< [4..0] Receive FIFO Data CountIndicate the quantity of receive
                                        *   data stored in FRDRH and FRDRL(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode,
                                        *   while FCR.FM=1)                                                           */
            uint16_t        : 3;
            __IM uint16_t T : 5;       /*!< [12..8] Transmit FIFO Data CountIndicate the quantity of non-transmit
                                        *   data stored in FTDRH and FTDRL(Valid only in asynchronous
                                        *   mode(including multi-processor) or clock synchronous mode,
                                        *   while FCR.FM=1)                                                           */
            uint16_t : 3;
        } FDR_b;
    };

    union
    {
        __IM uint16_t LSR;             /*!< (@ 0x00000018) Line Status Register                                       */

        struct
        {
            __IM uint16_t ORER : 1;    /*!< [0..0] Overrun Error Flag (Valid only in asynchronous mode(including
                                        *   multi-processor) or clock synchronous mode, and FIFO selected)            */
            uint16_t           : 1;
            __IM uint16_t FNUM : 5;    /*!< [6..2] Framing Error CountIndicates the quantity of data with
                                        *   a framing error among the receive data stored in the receive
                                        *   FIFO data register (FRDRH and FRDRL).                                     */
            uint16_t           : 1;
            __IM uint16_t PNUM : 5;    /*!< [12..8] Parity Error CountIndicates the quantity of data with
                                        *   a parity error among the receive data stored in the receive
                                        *   FIFO data register (FRDRH and FRDRL).                                     */
            uint16_t : 3;
        } LSR_b;
    };

    union
    {
        __IOM uint16_t CDR;            /*!< (@ 0x0000001A) Compare Match Data Register                                */

        struct
        {
            __IOM uint16_t CMPD : 9;   /*!< [8..0] Compare Match DataCompare data pattern for address match
                                        *   wake-up function                                                          */
            uint16_t : 7;
        } CDR_b;
    };

    union
    {
        __IOM uint8_t SPTR;            /*!< (@ 0x0000001C) Serial Port Register                                       */

        struct
        {
            __IM uint8_t RXDMON : 1;   /*!< [0..0] Serial input data monitor bit(The state of the RXD terminal
                                        *   is shown.)                                                                */
            __IOM uint8_t SPB2DT : 1;  /*!< [1..1] Serial port break data select bit(The output level of
                                        *   TxD terminal is selected when SCR.TE = 0.)                                */
            __IOM uint8_t SPB2IO : 1;  /*!< [2..2] Serial port break I/O bit(It's selected whether the value
                                        *   of SPB2DT is output to TxD terminal.)                                     */
            uint8_t            : 1;
            __IOM uint8_t RINV : 1;    /*!< [4..4] RXD invert bit                                                     */
            __IOM uint8_t TINV : 1;    /*!< [5..5] TXD invert bit                                                     */
            __IOM uint8_t ASEN : 1;    /*!< [6..6] Adjust receive sampling timing enable                              */
            __IOM uint8_t ATEN : 1;    /*!< [7..7] Adjust transmit timing enable                                      */
        } SPTR_b;
    };

    union
    {
        __IOM uint8_t ACTR;            /*!< (@ 0x0000001D) Adjustment Communication Timing Register                   */

        struct
        {
            __IOM uint8_t AST : 3;     /*!< [2..0] Adjustment value for receive Sampling Timing                       */
            __IOM uint8_t AJD : 1;     /*!< [3..3] Adjustment Direction for receive sampling timing                   */
            __IOM uint8_t ATT : 3;     /*!< [6..4] Adjustment value for Transmit timing                               */
            __IOM uint8_t AET : 1;     /*!< [7..7] Adjustment edge for transmit timing                                */
        } ACTR_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint8_t ESMER;           /*!< (@ 0x00000020) Extended Serial Module Enable Register                     */

        struct
        {
            __IOM uint8_t ESME : 1;    /*!< [0..0] Extended Serial Mode Enable                                        */
            uint8_t            : 7;
        } ESMER_b;
    };

    union
    {
        __IOM uint8_t CR0;             /*!< (@ 0x00000021) Control Register 0                                         */

        struct
        {
            uint8_t             : 1;
            __IM uint8_t  SFSF  : 1;   /*!< [1..1] Start Frame Status Flag                                            */
            __IM uint8_t  RXDSF : 1;   /*!< [2..2] RXDXn Input Status Flag                                            */
            __IOM uint8_t BRME  : 1;   /*!< [3..3] Bit Rate Measurement Enable                                        */
            uint8_t             : 4;
        } CR0_b;
    };

    union
    {
        __IOM uint8_t CR1;             /*!< (@ 0x00000022) Control Register 1                                         */

        struct
        {
            __IOM uint8_t BFE   : 1;   /*!< [0..0] Break Field Enable                                                 */
            __IOM uint8_t CF0RE : 1;   /*!< [1..1] Control Field 0 Reception Enable                                   */
            __IOM uint8_t CF1DS : 2;   /*!< [3..2] Control Field 1 Data Register Select                               */
            __IOM uint8_t PIBE  : 1;   /*!< [4..4] Priority Interrupt Bit Enable                                      */
            __IOM uint8_t PIBS  : 3;   /*!< [7..5] Priority Interrupt Bit Select                                      */
        } CR1_b;
    };

    union
    {
        __IOM uint8_t CR2;             /*!< (@ 0x00000023) Control Register 2                                         */

        struct
        {
            __IOM uint8_t DFCS : 3;    /*!< [2..0] RXDXn Signal Digital Filter Clock Select                           */
            uint8_t            : 1;
            __IOM uint8_t BCCS : 2;    /*!< [5..4] Bus Collision Detection Clock Select                               */
            __IOM uint8_t RTS  : 2;    /*!< [7..6] RXDXn Reception Sampling Timing Select                             */
        } CR2_b;
    };

    union
    {
        __IOM uint8_t CR3;             /*!< (@ 0x00000024) Control Register 3                                         */

        struct
        {
            __IOM uint8_t SDST : 1;    /*!< [0..0] Start Frame Detection Start                                        */
            uint8_t            : 7;
        } CR3_b;
    };

    union
    {
        __IOM uint8_t PCR;             /*!< (@ 0x00000025) Port Control Register                                      */

        struct
        {
            __IOM uint8_t TXDXPS : 1;  /*!< [0..0] TXDXn Signal Polarity Select                                       */
            __IOM uint8_t RXDXPS : 1;  /*!< [1..1] RXDXn Signal Polarity Select                                       */
            uint8_t              : 2;
            __IOM uint8_t SHARPS : 1;  /*!< [4..4] TXDXn/RXDXn Pin Multiplexing Select                                */
            uint8_t              : 3;
        } PCR_b;
    };

    union
    {
        __IOM uint8_t ICR;             /*!< (@ 0x00000026) Interrupt Control Register                                 */

        struct
        {
            __IOM uint8_t BFDIE  : 1;  /*!< [0..0] Break Field Low Width Detected Interrupt Enable                    */
            __IOM uint8_t CF0MIE : 1;  /*!< [1..1] Control Field 0 Match Detected Interrupt Enable                    */
            __IOM uint8_t CF1MIE : 1;  /*!< [2..2] Control Field 1 Match Detected Interrupt Enable                    */
            __IOM uint8_t PIBDIE : 1;  /*!< [3..3] Priority Interrupt Bit Detected Interrupt Enable                   */
            __IOM uint8_t BCDIE  : 1;  /*!< [4..4] Bus Collision Detected Interrupt Enable                            */
            __IOM uint8_t AEDIE  : 1;  /*!< [5..5] Valid Edge Detected Interrupt Enable                               */
            uint8_t              : 2;
        } ICR_b;
    };

    union
    {
        __IM uint8_t STR;              /*!< (@ 0x00000027) Status Register                                            */

        struct
        {
            __IM uint8_t BFDF  : 1;    /*!< [0..0] Break Field Low Width Detection Flag                               */
            __IM uint8_t CF0MF : 1;    /*!< [1..1] Control Field 0 Match Flag                                         */
            __IM uint8_t CF1MF : 1;    /*!< [2..2] Control Field 1 Match Flag                                         */
            __IM uint8_t PIBDF : 1;    /*!< [3..3] Priority Interrupt Bit Detection Flag                              */
            __IM uint8_t BCDF  : 1;    /*!< [4..4] Bus Collision Detected Flag                                        */
            __IM uint8_t AEDF  : 1;    /*!< [5..5] Valid Edge Detection Flag                                          */
            uint8_t            : 2;
        } STR_b;
    };

    union
    {
        __IOM uint8_t STCR;            /*!< (@ 0x00000028) Status Clear Register                                      */

        struct
        {
            __IOM uint8_t BFDCL  : 1;  /*!< [0..0] BFDF Clear                                                         */
            __IOM uint8_t CF0MCL : 1;  /*!< [1..1] CF0MF Clear                                                        */
            __IOM uint8_t CF1MCL : 1;  /*!< [2..2] CF1MF Clear                                                        */
            __IOM uint8_t PIBDCL : 1;  /*!< [3..3] PIBDF Clear                                                        */
            __IOM uint8_t BCDCL  : 1;  /*!< [4..4] BCDF Clear                                                         */
            __IOM uint8_t AEDCL  : 1;  /*!< [5..5] AEDF Clear                                                         */
            uint8_t              : 2;
        } STCR_b;
    };
    __IOM uint8_t CF0DR;               /*!< (@ 0x00000029) Control Field 0 Data Register                              */

    union
    {
        __IOM uint8_t CF0CR;           /*!< (@ 0x0000002A) Control Field 0 Compare Enable Register                    */

        struct
        {
            __IOM uint8_t CF0CE0 : 1;  /*!< [0..0] Control Field 0 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE1 : 1;  /*!< [1..1] Control Field 1 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE2 : 1;  /*!< [2..2] Control Field 2 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE3 : 1;  /*!< [3..3] Control Field 3 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE4 : 1;  /*!< [4..4] Control Field 4 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE5 : 1;  /*!< [5..5] Control Field 5 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE6 : 1;  /*!< [6..6] Control Field 6 Bit 0 Compare Enable                               */
            __IOM uint8_t CF0CE7 : 1;  /*!< [7..7] Control Field 7 Bit 0 Compare Enable                               */
        } CF0CR_b;
    };
    __IOM uint8_t CF0RR;               /*!< (@ 0x0000002B) Control Field 0 Receive Data Register                      */
    __IOM uint8_t PCF1DR;              /*!< (@ 0x0000002C) Primary Control Field 1 Data Register                      */
    __IOM uint8_t SCF1DR;              /*!< (@ 0x0000002D) Secondary Control Field 1 Data Register                    */

    union
    {
        __IOM uint8_t CF1CR;           /*!< (@ 0x0000002E) Control Field 1 Compare Enable Register                    */

        struct
        {
            __IOM uint8_t CF1CE0 : 1;  /*!< [0..0] Control Field 1 Bit 0 Compare Enable                               */
            __IOM uint8_t CF1CE1 : 1;  /*!< [1..1] Control Field 1 Bit 1 Compare Enable                               */
            __IOM uint8_t CF1CE2 : 1;  /*!< [2..2] Control Field 1 Bit 2 Compare Enable                               */
            __IOM uint8_t CF1CE3 : 1;  /*!< [3..3] Control Field 1 Bit 3 Compare Enable                               */
            __IOM uint8_t CF1CE4 : 1;  /*!< [4..4] Control Field 1 Bit 4 Compare Enable                               */
            __IOM uint8_t CF1CE5 : 1;  /*!< [5..5] Control Field 1 Bit 5 Compare Enable                               */
            __IOM uint8_t CF1CE6 : 1;  /*!< [6..6] Control Field 1 Bit 6 Compare Enable                               */
            __IOM uint8_t CF1CE7 : 1;  /*!< [7..7] Control Field 1 Bit 7 Compare Enable                               */
        } CF1CR_b;
    };
    __IOM uint8_t CF1RR;               /*!< (@ 0x0000002F) Control Field 1 Receive Data Register                      */

    union
    {
        __IOM uint8_t TCR;             /*!< (@ 0x00000030) Timer Control Register                                     */

        struct
        {
            __IOM uint8_t TCST : 1;    /*!< [0..0] Timer Count Start                                                  */
            uint8_t            : 7;
        } TCR_b;
    };

    union
    {
        __IOM uint8_t TMR;             /*!< (@ 0x00000031) Timer Mode Register                                        */

        struct
        {
            __IOM uint8_t TOMS : 2;    /*!< [1..0] Timer Operating Mode Select                                        */
            uint8_t            : 1;
            __IOM uint8_t TWRC : 1;    /*!< [3..3] Counter Write Control                                              */
            __IOM uint8_t TCSS : 3;    /*!< [6..4] Timer Count Clock Source Select                                    */
            uint8_t            : 1;
        } TMR_b;
    };
    __IOM uint8_t TPRE;                /*!< (@ 0x00000032) Timer Prescaler Register                                   */
    __IOM uint8_t TCNT;                /*!< (@ 0x00000033) Timer Count Register                                       */
} R_SCI0_Type;                         /*!< Size = 52 (0x34)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SPI0                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Serial Peripheral Interface (R_SPI0)
 */

typedef struct                         /*!< (@ 0x40072000) R_SPI0 Structure                                           */
{
    union
    {
        __IOM uint8_t SPCR;            /*!< (@ 0x00000000) SPI Control Register                                       */

        struct
        {
            __IOM uint8_t SPMS   : 1;  /*!< [0..0] SPI Mode Select                                                    */
            __IOM uint8_t TXMD   : 1;  /*!< [1..1] Communications Operating Mode Select                               */
            __IOM uint8_t MODFEN : 1;  /*!< [2..2] Mode Fault Error Detection Enable                                  */
            __IOM uint8_t MSTR   : 1;  /*!< [3..3] SPI Master/Slave Mode Select                                       */
            __IOM uint8_t SPEIE  : 1;  /*!< [4..4] SPI Error Interrupt Enable                                         */
            __IOM uint8_t SPTIE  : 1;  /*!< [5..5] Transmit Buffer Empty Interrupt Enable                             */
            __IOM uint8_t SPE    : 1;  /*!< [6..6] SPI Function Enable                                                */
            __IOM uint8_t SPRIE  : 1;  /*!< [7..7] SPI Receive Buffer Full Interrupt Enable                           */
        } SPCR_b;
    };

    union
    {
        __IOM uint8_t SSLP;            /*!< (@ 0x00000001) SPI Slave Select Polarity Register                         */

        struct
        {
            __IOM uint8_t SSL0P : 1;   /*!< [0..0] SSL0 Signal Polarity Setting                                       */
            __IOM uint8_t SSL1P : 1;   /*!< [1..1] SSL1 Signal Polarity Setting                                       */
            __IOM uint8_t SSL2P : 1;   /*!< [2..2] SSL2 Signal Polarity Setting                                       */
            __IOM uint8_t SSL3P : 1;   /*!< [3..3] SSL3 Signal Polarity Setting                                       */
            __IOM uint8_t SSL4P : 1;   /*!< [4..4] SSL4 Signal Polarity Setting                                       */
            __IOM uint8_t SSL5P : 1;   /*!< [5..5] SSL5 Signal Polarity Setting                                       */
            __IOM uint8_t SSL6P : 1;   /*!< [6..6] SSL6 Signal Polarity Setting                                       */
            __IOM uint8_t SSL7P : 1;   /*!< [7..7] SSL7 Signal Polarity Setting                                       */
        } SSLP_b;
    };

    union
    {
        __IOM uint8_t SPPCR;           /*!< (@ 0x00000002) SPI Pin Control Register                                   */

        struct
        {
            __IOM uint8_t SPLP  : 1;   /*!< [0..0] SPI Loopback                                                       */
            __IOM uint8_t SPLP2 : 1;   /*!< [1..1] SPI Loopback 2                                                     */
            uint8_t             : 2;
            __IOM uint8_t MOIFV : 1;   /*!< [4..4] MOSI Idle Fixed Value                                              */
            __IOM uint8_t MOIFE : 1;   /*!< [5..5] MOSI Idle Value Fixing Enable                                      */
            uint8_t             : 2;
        } SPPCR_b;
    };

    union
    {
        __IOM uint8_t SPSR;            /*!< (@ 0x00000003) SPI Status Register                                        */

        struct
        {
            __IOM uint8_t OVRF  : 1;   /*!< [0..0] Overrun Error Flag                                                 */
            __IM uint8_t  IDLNF : 1;   /*!< [1..1] SPI Idle Flag                                                      */
            __IOM uint8_t MODF  : 1;   /*!< [2..2] Mode Fault Error Flag                                              */
            __IOM uint8_t PERF  : 1;   /*!< [3..3] Parity Error Flag                                                  */
            __IOM uint8_t UDRF  : 1;   /*!< [4..4] Underrun Error Flag(When MODF is 0, This bit is invalid.)          */
            __IOM uint8_t SPTEF : 1;   /*!< [5..5] SPI Transmit Buffer Empty Flag                                     */
            __IOM uint8_t CENDF : 1;   /*!< [6..6] Communication End Flag                                             */
            __IOM uint8_t SPRF  : 1;   /*!< [7..7] SPI Receive Buffer Full Flag                                       */
        } SPSR_b;
    };

    union
    {
        __IOM uint32_t SPDR;           /*!< (@ 0x00000004) SPI Data Register                                          */
        __IOM uint16_t SPDR_HA;        /*!< (@ 0x00000004) SPI Data Register ( halfword access )                      */
        __IOM uint8_t  SPDR_BY;        /*!< (@ 0x00000004) SPI Data Register ( byte access )                          */
    };

    union
    {
        __IOM uint8_t SPSCR;           /*!< (@ 0x00000008) SPI Sequence Control Register                              */

        struct
        {
            __IOM uint8_t SPSLN : 3;   /*!< [2..0] RSPI Sequence Length SpecificationThe order in which
                                        *   the SPCMD0 to SPCMD07 registers are to be referenced is
                                        *   changed in accordance with the sequence length that is
                                        *   set in these bits. The relationship among the setting of
                                        *   these bits, sequence length, and SPCMD0 to SPCMD7 registers
                                        *   referenced by the RSPI is shown above. However, the RSPI
                                        *   in slave mode always references SPCMD0.                                   */
            uint8_t : 5;
        } SPSCR_b;
    };

    union
    {
        __IM uint8_t SPSSR;            /*!< (@ 0x00000009) SPI Sequence Status Register                               */

        struct
        {
            __IM uint8_t SPCP  : 3;    /*!< [2..0] RSPI Command Pointer                                               */
            uint8_t            : 1;
            __IM uint8_t SPECM : 3;    /*!< [6..4] RSPI Error Command                                                 */
            uint8_t            : 1;
        } SPSSR_b;
    };

    union
    {
        __IOM uint8_t SPBR;            /*!< (@ 0x0000000A) SPI Bit Rate Register                                      */

        struct
        {
            __IOM uint8_t SPR : 8;     /*!< [7..0] SPBR sets the bit rate in master mode.                             */
        } SPBR_b;
    };

    union
    {
        __IOM uint8_t SPDCR;           /*!< (@ 0x0000000B) SPI Data Control Register                                  */

        struct
        {
            __IOM uint8_t SPFC   : 2;  /*!< [1..0] Number of Frames Specification                                     */
            __IOM uint8_t SLSEL  : 2;  /*!< [3..2] SSL Pin Output Select                                              */
            __IOM uint8_t SPRDTD : 1;  /*!< [4..4] SPI Receive/Transmit Data Selection                                */
            __IOM uint8_t SPLW   : 1;  /*!< [5..5] SPI Word Access/Halfword Access Specification                      */
            __IOM uint8_t SPBYT  : 1;  /*!< [6..6] SPI Byte Access Specification                                      */
            uint8_t              : 1;
        } SPDCR_b;
    };

    union
    {
        __IOM uint8_t SPCKD;           /*!< (@ 0x0000000C) SPI Clock Delay Register                                   */

        struct
        {
            __IOM uint8_t SCKDL : 3;   /*!< [2..0] RSPCK Delay Setting                                                */
            uint8_t             : 5;
        } SPCKD_b;
    };

    union
    {
        __IOM uint8_t SSLND;           /*!< (@ 0x0000000D) SPI Slave Select Negation Delay Register                   */

        struct
        {
            __IOM uint8_t SLNDL : 3;   /*!< [2..0] SSL Negation Delay Setting                                         */
            uint8_t             : 5;
        } SSLND_b;
    };

    union
    {
        __IOM uint8_t SPND;            /*!< (@ 0x0000000E) SPI Next-Access Delay Register                             */

        struct
        {
            __IOM uint8_t SPNDL : 3;   /*!< [2..0] SPI Next-Access Delay Setting                                      */
            uint8_t             : 5;
        } SPND_b;
    };

    union
    {
        __IOM uint8_t SPCR2;           /*!< (@ 0x0000000F) SPI Control Register 2                                     */

        struct
        {
            __IOM uint8_t SPPE   : 1;  /*!< [0..0] Parity Enable                                                      */
            __IOM uint8_t SPOE   : 1;  /*!< [1..1] Parity Mode                                                        */
            __IOM uint8_t SPIIE  : 1;  /*!< [2..2] SPI Idle Interrupt Enable                                          */
            __IOM uint8_t PTE    : 1;  /*!< [3..3] Parity Self-Testing                                                */
            __IOM uint8_t SCKASE : 1;  /*!< [4..4] RSPCK Auto-Stop Function Enable                                    */
            __IOM uint8_t SPTDDL : 3;  /*!< [7..5] RSPI Transmit Data Delay                                           */
        } SPCR2_b;
    };

    union
    {
        __IOM uint16_t SPCMD[8];       /*!< (@ 0x00000010) SPI Command Register [0..7]                                */

        struct
        {
            __IOM uint16_t CPHA   : 1; /*!< [0..0] RSPCK Phase Setting                                                */
            __IOM uint16_t CPOL   : 1; /*!< [1..1] RSPCK Polarity Setting                                             */
            __IOM uint16_t BRDV   : 2; /*!< [3..2] Bit Rate Division Setting                                          */
            __IOM uint16_t SSLA   : 3; /*!< [6..4] SSL Signal Assertion Setting                                       */
            __IOM uint16_t SSLKP  : 1; /*!< [7..7] SSL Signal Level Keeping                                           */
            __IOM uint16_t SPB    : 4; /*!< [11..8] SPI Data Length Setting                                           */
            __IOM uint16_t LSBF   : 1; /*!< [12..12] SPI LSB First                                                    */
            __IOM uint16_t SPNDEN : 1; /*!< [13..13] SPI Next-Access Delay Enable                                     */
            __IOM uint16_t SLNDEN : 1; /*!< [14..14] SSL Negation Delay Setting Enable                                */
            __IOM uint16_t SCKDEN : 1; /*!< [15..15] RSPCK Delay Setting Enable                                       */
        } SPCMD_b[8];
    };

    union
    {
        __IOM uint8_t SPDCR2;          /*!< (@ 0x00000020) SPI Data Control Register 2                                */

        struct
        {
            __IOM uint8_t BYSW : 1;    /*!< [0..0] Byte Swap Operating Mode Select                                    */
            __IOM uint8_t SINV : 1;    /*!< [1..1] Serial data invert bit                                             */
            uint8_t            : 6;
        } SPDCR2_b;
    };

    union
    {
        __IOM uint8_t SPCR3;           /*!< (@ 0x00000021) RSPI Control Register 3                                    */

        struct
        {
            __IOM uint8_t ETXMD  : 1;  /*!< [0..0] Extended Communication Mode Select                                 */
            __IOM uint8_t BFDS   : 1;  /*!< [1..1] Between Burst Transfer Frames Delay Select                         */
            uint8_t              : 2;
            __IOM uint8_t CENDIE : 1;  /*!< [4..4] RSPI Communication End Interrupt Enable                            */
            uint8_t              : 3;
        } SPCR3_b;
    };
    __IM uint16_t RESERVED;
    __IM uint32_t RESERVED1[6];
    __IM uint16_t RESERVED2;

    union
    {
        __IOM uint16_t SPPR;           /*!< (@ 0x0000003E) RSPI Parameter Read Register                               */

        struct
        {
            uint16_t              : 4;
            __IOM uint16_t BUFWID : 1; /*!< [4..4] Buffer Width check                                                 */
            uint16_t              : 3;
            __IOM uint16_t BUFNUM : 3; /*!< [10..8] Buffer Number check                                               */
            uint16_t              : 1;
            __IOM uint16_t CMDNUM : 4; /*!< [15..12] Command Number check                                             */
        } SPPR_b;
    };
} R_SPI0_Type;                         /*!< Size = 64 (0x40)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_SRAM                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief SRAM (R_SRAM)
 */

typedef struct                         /*!< (@ 0x40002000) R_SRAM Structure                                           */
{
    union
    {
        __IOM uint8_t PARIOAD;         /*!< (@ 0x00000000) SRAM Parity Error Operation After Detection Register       */

        struct
        {
            __IOM uint8_t OAD : 1;     /*!< [0..0] Operation after Detection                                          */
            uint8_t           : 7;
        } PARIOAD_b;
    };
    __IM uint8_t RESERVED[3];

    union
    {
        __IOM uint8_t SRAMPRCR;         /*!< (@ 0x00000004) SRAM Protection Register                                   */

        struct
        {
            __IOM uint8_t SRAMPRCR : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW       : 7; /*!< [7..1] Write Key Code                                                     */
        } SRAMPRCR_b;
    };
    __IM uint8_t  RESERVED1[3];
    __IOM uint8_t SRAMWTSC;             /*!< (@ 0x00000008) RAM Wait State Control Register                            */
    __IM uint8_t  RESERVED2[3];

    union
    {
        __IOM uint8_t SRAMPRCR2;         /*!< (@ 0x0000000C) SRAM Protection Register 2                                 */

        struct
        {
            __IOM uint8_t SRAMPRCR2 : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW        : 7; /*!< [7..1] Write Key Code                                                     */
        } SRAMPRCR2_b;
    };
    __IM uint8_t RESERVED3[179];

    union
    {
        __IOM uint8_t ECCMODE;         /*!< (@ 0x000000C0) ECC Operating Mode Control Register                        */

        struct
        {
            __IOM uint8_t ECCMOD : 2;  /*!< [1..0] ECC Operating Mode Select                                          */
            uint8_t              : 6;
        } ECCMODE_b;
    };

    union
    {
        __IOM uint8_t ECC2STS;         /*!< (@ 0x000000C1) ECC 2-Bit Error Status Register                            */

        struct
        {
            __IOM uint8_t ECC2ERR : 1; /*!< [0..0] ECC 2-Bit Error Status                                             */
            uint8_t               : 7;
        } ECC2STS_b;
    };

    union
    {
        __IOM uint8_t ECC1STSEN;       /*!< (@ 0x000000C2) ECC 1-Bit Error Information Update Enable Register         */

        struct
        {
            __IOM uint8_t E1STSEN : 1; /*!< [0..0] ECC 1-Bit Error Information Update Enable                          */
            uint8_t               : 7;
        } ECC1STSEN_b;
    };

    union
    {
        __IOM uint8_t ECC1STS;         /*!< (@ 0x000000C3) ECC 1-Bit Error Status Register                            */

        struct
        {
            __IOM uint8_t ECC1ERR : 1; /*!< [0..0] ECC 1-Bit Error Status                                             */
            uint8_t               : 7;
        } ECC1STS_b;
    };

    union
    {
        __IOM uint8_t ECCPRCR;         /*!< (@ 0x000000C4) ECC Protection Register                                    */

        struct
        {
            __IOM uint8_t ECCPRCR : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW      : 7; /*!< [7..1] Write Key Code                                                     */
        } ECCPRCR_b;
    };
    __IM uint8_t RESERVED4[11];

    union
    {
        __IOM uint8_t ECCPRCR2;         /*!< (@ 0x000000D0) ECC Protection Register 2                                  */

        struct
        {
            __IOM uint8_t ECCPRCR2 : 1; /*!< [0..0] Register Write Control                                             */
            __OM uint8_t  KW2      : 7; /*!< [7..1] Write Key Code                                                     */
        } ECCPRCR2_b;
    };
    __IM uint8_t RESERVED5[3];

    union
    {
        __IOM uint8_t ECCETST;         /*!< (@ 0x000000D4) ECC Test Control Register                                  */

        struct
        {
            __IOM uint8_t TSTBYP : 1;  /*!< [0..0] ECC Bypass Select                                                  */
            uint8_t              : 7;
        } ECCETST_b;
    };
    __IM uint8_t RESERVED6[3];

    union
    {
        __IOM uint8_t ECCOAD;          /*!< (@ 0x000000D8) SRAM ECC Error Operation After Detection Register          */

        struct
        {
            __IOM uint8_t OAD : 1;     /*!< [0..0] Operation after Detection                                          */
            uint8_t           : 7;
        } ECCOAD_b;
    };
} R_SRAM_Type;                         /*!< Size = 217 (0xd9)                                                         */

/* =========================================================================================================================== */
/* ================                                         R_SYSTEM                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief System Pins (R_SYSTEM)
 */

typedef struct                         /*!< (@ 0x4001E000) R_SYSTEM Structure                                         */
{
    __IM uint32_t RESERVED[3];

    union
    {
        __IOM uint16_t SBYCR;          /*!< (@ 0x0000000C) Standby Control Register                                   */

        struct
        {
            uint16_t            : 14;
            __IOM uint16_t OPE  : 1;   /*!< [14..14] Output Port Enable                                               */
            __IOM uint16_t SSBY : 1;   /*!< [15..15] Software Standby                                                 */
        } SBYCR_b;
    };
    __IM uint16_t RESERVED1;
    __IM uint32_t RESERVED2[3];

    union
    {
        __IOM uint32_t MSTPCRA;         /*!< (@ 0x0000001C) Module Stop Control Register A                             */

        struct
        {
            __IOM uint32_t MSTPA0  : 1; /*!< [0..0] Module Stop bit 0. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA1  : 1; /*!< [1..1] Module Stop bit 1. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA2  : 1; /*!< [2..2] Module Stop bit 2. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA3  : 1; /*!< [3..3] Module Stop bit 3. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA4  : 1; /*!< [4..4] Module Stop bit 4. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA5  : 1; /*!< [5..5] Module Stop bit 5. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA6  : 1; /*!< [6..6] Module Stop bit 6. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA7  : 1; /*!< [7..7] Module Stop bit 7. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA8  : 1; /*!< [8..8] Module Stop bit 8. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA9  : 1; /*!< [9..9] Module Stop bit 9. See device hardware manual for usage.           */
            __IOM uint32_t MSTPA10 : 1; /*!< [10..10] Module Stop bit 10. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA11 : 1; /*!< [11..11] Module Stop bit 11. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA12 : 1; /*!< [12..12] Module Stop bit 12. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA13 : 1; /*!< [13..13] Module Stop bit 13. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA14 : 1; /*!< [14..14] Module Stop bit 14. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA15 : 1; /*!< [15..15] Module Stop bit 15. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA16 : 1; /*!< [16..16] Module Stop bit 16. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA17 : 1; /*!< [17..17] Module Stop bit 17. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA18 : 1; /*!< [18..18] Module Stop bit 18. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA19 : 1; /*!< [19..19] Module Stop bit 19. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA20 : 1; /*!< [20..20] Module Stop bit 20. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA21 : 1; /*!< [21..21] Module Stop bit 21. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA22 : 1; /*!< [22..22] Module Stop bit 22. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA23 : 1; /*!< [23..23] Module Stop bit 23. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA24 : 1; /*!< [24..24] Module Stop bit 24. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA25 : 1; /*!< [25..25] Module Stop bit 25. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA26 : 1; /*!< [26..26] Module Stop bit 26. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA27 : 1; /*!< [27..27] Module Stop bit 27. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA28 : 1; /*!< [28..28] Module Stop bit 28. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA29 : 1; /*!< [29..29] Module Stop bit 29. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA30 : 1; /*!< [30..30] Module Stop bit 30. See device hardware manual for
                                         *   usage.                                                                    */
            __IOM uint32_t MSTPA31 : 1; /*!< [31..31] Module Stop bit 31. See device hardware manual for
                                         *   usage.                                                                    */
        } MSTPCRA_b;
    };

    union
    {
        __IOM uint32_t SCKDIVCR;       /*!< (@ 0x00000020) System Clock Division Control Register                     */

        struct
        {
            __IOM uint32_t PCKD : 3;   /*!< [2..0] Peripheral Module Clock D (PCLKD) Select                           */
            uint32_t            : 1;
            __IOM uint32_t PCKC : 3;   /*!< [6..4] Peripheral Module Clock C (PCLKC) Select                           */
            uint32_t            : 1;
            __IOM uint32_t PCKB : 3;   /*!< [10..8] Peripheral Module Clock B (PCLKB) Select                          */
            uint32_t            : 1;
            __IOM uint32_t PCKA : 3;   /*!< [14..12] Peripheral Module Clock A (PCLKA) Select                         */
            uint32_t            : 1;
            __IOM uint32_t BCK  : 3;   /*!< [18..16] External Bus Clock (BCLK) Select                                 */
            uint32_t            : 5;
            __IOM uint32_t ICK  : 3;   /*!< [26..24] System Clock (ICLK) Select                                       */
            uint32_t            : 1;
            __IOM uint32_t FCK  : 3;   /*!< [30..28] Flash IF Clock (FCLK) Select                                     */
            uint32_t            : 1;
        } SCKDIVCR_b;
    };

    union
    {
        __IOM uint8_t SCKDIVCR2;       /*!< (@ 0x00000024) System Clock Division Control Register 2                   */

        struct
        {
            uint8_t           : 4;
            __IOM uint8_t UCK : 3;     /*!< [6..4] USB Clock (UCLK) Select                                            */
            uint8_t           : 1;
        } SCKDIVCR2_b;
    };
    __IM uint8_t RESERVED3;

    union
    {
        __IOM uint8_t SCKSCR;          /*!< (@ 0x00000026) System Clock Source Control Register                       */

        struct
        {
            __IOM uint8_t CKSEL : 3;   /*!< [2..0] Clock Source Select                                                */
            uint8_t             : 5;
        } SCKSCR_b;
    };
    __IM uint8_t RESERVED4;

    union
    {
        __IOM uint16_t PLLCCR;           /*!< (@ 0x00000028) PLL Clock Control Register                                 */

        struct
        {
            __IOM uint16_t PLIDIV   : 2; /*!< [1..0] PLL Input Frequency Division Ratio Select                          */
            uint16_t                : 2;
            __IOM uint16_t PLSRCSEL : 1; /*!< [4..4] PLL Clock Source Select                                            */
            uint16_t                : 3;
            __IOM uint16_t PLLMUL   : 6; /*!< [13..8] PLL Frequency Multiplication Factor Select [PLL Frequency
                                          *   Multiplication Factor] = (PLLUMUL+1) / 2 Range: 0x23 -
                                          *   0x3B for example 010011: x10.0 010100: x10.5 010101: x11.0
                                          *   : 011100: x14.5 011101: x15.0 011110: x15.5 : 111010: x29.5
                                          *   111011: x30.0                                                             */
            uint16_t : 2;
        } PLLCCR_b;
    };

    union
    {
        __IOM uint8_t PLLCR;           /*!< (@ 0x0000002A) PLL Control Register                                       */

        struct
        {
            __IOM uint8_t PLLSTP : 1;  /*!< [0..0] PLL Stop Control                                                   */
            uint8_t              : 7;
        } PLLCR_b;
    };

    union
    {
        __IOM uint8_t PLLCCR2;         /*!< (@ 0x0000002B) PLL Clock Control Register2                                */

        struct
        {
            __IOM uint8_t PLLMUL : 5;  /*!< [4..0] PLL Frequency Multiplication Factor Select                         */
            uint8_t              : 1;
            __IOM uint8_t PLODIV : 2;  /*!< [7..6] PLL Output Frequency Division Ratio Select                         */
        } PLLCCR2_b;
    };
    __IM uint32_t RESERVED5;

    union
    {
        __IOM uint8_t BCKCR;           /*!< (@ 0x00000030) External Bus Clock Control Register                        */

        struct
        {
            __IOM uint8_t BCLKDIV : 1; /*!< [0..0] BCLK Pin Output Select                                             */
            uint8_t               : 7;
        } BCKCR_b;
    };

    union
    {
        __IOM uint8_t MEMWAIT;         /*!< (@ 0x00000031) Memory Wait Cycle Control Register                         */

        struct
        {
            __IOM uint8_t MEMWAIT : 1; /*!< [0..0] Memory Wait Cycle SelectNote: Writing 0 to the MEMWAIT
                                        *   is prohibited when SCKDIVCR.ICK selects division by 1 and
                                        *   SCKSCR.CKSEL[2:0] bits select thesystem clock source that
                                        *   is faster than 32 MHz (ICLK > 32 MHz).                                    */
            uint8_t : 7;
        } MEMWAIT_b;
    };

    union
    {
        __IOM uint8_t MOSCCR;          /*!< (@ 0x00000032) Main Clock Oscillator Control Register                     */

        struct
        {
            __IOM uint8_t MOSTP : 1;   /*!< [0..0] Main Clock Oscillator Stop                                         */
            uint8_t             : 7;
        } MOSCCR_b;
    };
    __IM uint8_t  RESERVED6;
    __IM uint16_t RESERVED7;

    union
    {
        __IOM uint8_t HOCOCR;          /*!< (@ 0x00000036) High-Speed On-Chip Oscillator Control Register             */

        struct
        {
            __IOM uint8_t HCSTP : 1;   /*!< [0..0] HOCO Stop                                                          */
            uint8_t             : 7;
        } HOCOCR_b;
    };

    union
    {
        __IOM uint8_t HOCOCR2;         /*!< (@ 0x00000037) High-Speed On-Chip Oscillator Control Register
                                        *                  2                                                          */

        struct
        {
            __IOM uint8_t HCFRQ0 : 2;  /*!< [1..0] HOCO Frequency Setting 0                                           */
            uint8_t              : 1;
            __IOM uint8_t HCFRQ1 : 3;  /*!< [5..3] HOCO Frequency Setting 1                                           */
            uint8_t              : 2;
        } HOCOCR2_b;
    };

    union
    {
        __IOM uint8_t MOCOCR;          /*!< (@ 0x00000038) Middle-Speed On-Chip Oscillator Control Register           */

        struct
        {
            __IOM uint8_t MCSTP : 1;   /*!< [0..0] MOCO Stop                                                          */
            uint8_t             : 7;
        } MOCOCR_b;
    };

    union
    {
        __IOM uint8_t FLLCR1;          /*!< (@ 0x00000039) FLL Control Register 1                                     */

        struct
        {
            __IOM uint8_t FLLEN : 1;   /*!< [0..0] FLL Enable                                                         */
            uint8_t             : 7;
        } FLLCR1_b;
    };

    union
    {
        __IOM uint16_t FLLCR2;           /*!< (@ 0x0000003A) FLL Control Register 2                                     */

        struct
        {
            __IOM uint16_t FLLCNTL : 11; /*!< [10..0] FLL Multiplication ControlMultiplication ratio of the
                                          *   FLL reference clock select                                                */
            uint16_t : 5;
        } FLLCR2_b;
    };

    union
    {
        __IM uint8_t OSCSF;            /*!< (@ 0x0000003C) Oscillation Stabilization Flag Register                    */

        struct
        {
            __IM uint8_t HOCOSF : 1;   /*!< [0..0] HOCO Clock Oscillation Stabilization FlagNOTE: The HOCOSF
                                        *   bit value after a reset is 1 when the OFS1.HOCOEN bit is
                                        *   0. It is 0 when the OFS1.HOCOEN bit is 1.                                 */
            uint8_t             : 2;
            __IM uint8_t MOSCSF : 1;   /*!< [3..3] Main Clock Oscillation Stabilization Flag                          */
            uint8_t             : 1;
            __IM uint8_t PLLSF  : 1;   /*!< [5..5] PLL Clock Oscillation Stabilization Flag                           */
            __IM uint8_t PLL2SF : 1;   /*!< [6..6] PLL2 Clock Oscillation Stabilization Flag                          */
            uint8_t             : 1;
        } OSCSF_b;
    };
    __IM uint8_t RESERVED8;

    union
    {
        __IOM uint8_t CKOCR;           /*!< (@ 0x0000003E) Clock Out Control Register                                 */

        struct
        {
            __IOM uint8_t CKOSEL : 3;  /*!< [2..0] Clock out source select                                            */
            uint8_t              : 1;
            __IOM uint8_t CKODIV : 3;  /*!< [6..4] Clock out input frequency Division Select                          */
            __IOM uint8_t CKOEN  : 1;  /*!< [7..7] Clock out enable                                                   */
        } CKOCR_b;
    };

    union
    {
        __IOM uint8_t TRCKCR;          /*!< (@ 0x0000003F) Trace Clock Control Register                               */

        struct
        {
            __IOM uint8_t TRCK   : 4;  /*!< [3..0] Trace Clock operating frequency select                             */
            uint8_t              : 3;
            __IOM uint8_t TRCKEN : 1;  /*!< [7..7] Trace Clock operating Enable                                       */
        } TRCKCR_b;
    };

    union
    {
        __IOM uint8_t OSTDCR;          /*!< (@ 0x00000040) Oscillation Stop Detection Control Register                */

        struct
        {
            __IOM uint8_t OSTDIE : 1;  /*!< [0..0] Oscillation Stop Detection Interrupt Enable                        */
            uint8_t              : 6;
            __IOM uint8_t OSTDE  : 1;  /*!< [7..7] Oscillation Stop Detection Function Enable                         */
        } OSTDCR_b;
    };

    union
    {
        __IOM uint8_t OSTDSR;          /*!< (@ 0x00000041) Oscillation Stop Detection Status Register                 */

        struct
        {
            __IOM uint8_t OSTDF : 1;   /*!< [0..0] Oscillation Stop Detection Flag                                    */
            uint8_t             : 7;
        } OSTDSR_b;
    };
    __IM uint16_t RESERVED9;
    __IM uint32_t RESERVED10;

    union
    {
        __IOM uint16_t PLL2CCR;           /*!< (@ 0x00000048) PLL2 Clock Control Register                                */

        struct
        {
            __IOM uint16_t PL2IDIV   : 2; /*!< [1..0] PLL2 Input Frequency Division Ratio Select                         */
            uint16_t                 : 2;
            __IOM uint16_t PL2SRCSEL : 1; /*!< [4..4] PLL2 Clock Source Select                                           */
            uint16_t                 : 3;
            __IOM uint16_t PLL2MUL   : 6; /*!< [13..8] PLL2 Frequency Multiplication Factor Select                       */
            uint16_t                 : 2;
        } PLL2CCR_b;
    };

    union
    {
        __IOM uint8_t PLL2CR;          /*!< (@ 0x0000004A) PLL2 Control Register                                      */

        struct
        {
            __IOM uint8_t PLL2STP : 1; /*!< [0..0] PLL2 Stop Control                                                  */
            uint8_t               : 7;
        } PLL2CR_b;
    };
    __IM uint8_t RESERVED11;

    union
    {
        __IOM uint8_t LPOPT;             /*!< (@ 0x0000004C) Lower Power Operation Control Register                     */

        struct
        {
            __IOM uint8_t MPUDIS : 1;    /*!< [0..0] MPU Clock Disable Control. Stop the MPU operate clock
                                          *   (valid only when LPOPTEN = 1)                                             */
            __IOM uint8_t DCLKDIS   : 2; /*!< [2..1] Debug Clock Disable Control                                        */
            __IOM uint8_t BPFCLKDIS : 1; /*!< [3..3] BPF Clock Disable Control. Stop the Flash register R/W
                                          *   clock (valid only when LPOPT.LPOPTEN = 1)                                 */
            uint8_t               : 3;
            __IOM uint8_t LPOPTEN : 1;   /*!< [7..7] Lower Power Operation Enable                                       */
        } LPOPT_b;
    };
    __IM uint8_t  RESERVED12;
    __IM uint16_t RESERVED13;

    union
    {
        __IOM uint8_t SLCDSCKCR;         /*!< (@ 0x00000050) Segment LCD Source Clock Control Register                  */

        struct
        {
            __IOM uint8_t LCDSCKSEL : 3; /*!< [2..0] LCD Source Clock (LCDSRCCLK) Select                                */
            uint8_t                 : 4;
            __IOM uint8_t LCDSCKEN  : 1; /*!< [7..7] LCD Source Clock Out Enable                                        */
        } SLCDSCKCR_b;
    };
    __IM uint8_t RESERVED14;

    union
    {
        __IOM uint8_t EBCKOCR;         /*!< (@ 0x00000052) External Bus Clock Output Control Register                 */

        struct
        {
            __IOM uint8_t EBCKOEN : 1; /*!< [0..0] BCLK Pin Output Control                                            */
            uint8_t               : 7;
        } EBCKOCR_b;
    };

    union
    {
        __IOM uint8_t SDCKOCR;         /*!< (@ 0x00000053) SDRAM Clock Output Control Register                        */

        struct
        {
            __IOM uint8_t SDCKOEN : 1; /*!< [0..0] SDCLK Pin Output Control                                           */
            uint8_t               : 7;
        } SDCKOCR_b;
    };
    __IM uint32_t RESERVED15[3];
    __IM uint8_t  RESERVED16;

    union
    {
        __IOM uint8_t MOCOUTCR;         /*!< (@ 0x00000061) MOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t MOCOUTRM : 8; /*!< [7..0] MOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original MOCO
                                         *   trimming bits                                                             */
        } MOCOUTCR_b;
    };

    union
    {
        __IOM uint8_t HOCOUTCR;         /*!< (@ 0x00000062) HOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t HOCOUTRM : 8; /*!< [7..0] HOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original HOCO
                                         *   trimming bits                                                             */
        } HOCOUTCR_b;
    };
    __IM uint8_t  RESERVED17;
    __IM uint32_t RESERVED18[2];

    union
    {
        __IOM uint8_t USBCKDIVCR;       /*!< (@ 0x0000006C) USB Clock Division Control Register                        */

        struct
        {
            __IOM uint8_t USBCKDIV : 3; /*!< [2..0] USB Clock (USBCLK) Division Select                                 */
            uint8_t                : 5;
        } USBCKDIVCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t OCTACKDIVCR;       /*!< (@ 0x0000006D) Octal-SPI Clock Division Control Register                  */

            struct
            {
                __IOM uint8_t OCTACKDIV : 3; /*!< [2..0] Octal-SPI Clock (OCTACLK) Division Select                          */
                uint8_t                 : 5;
            } OCTACKDIVCR_b;
        };

        union
        {
            __IOM uint8_t SCISPICKDIVCR;       /*!< (@ 0x0000006D) SCI SPI Clock Division Control Register                    */

            struct
            {
                __IOM uint8_t SCISPICKDIV : 3; /*!< [2..0] SCI SPI Clock (SCISPICLK) Division Select                          */
                uint8_t                   : 5;
            } SCISPICKDIVCR_b;
        };
    };

    union
    {
        __IOM uint8_t CANFDCKDIVCR;       /*!< (@ 0x0000006E) CANFD Clock Division Control Register                      */

        struct
        {
            __IOM uint8_t CANFDCKDIV : 3; /*!< [2..0] CANFD Clock (CANFDCLK) Division Select                             */
            uint8_t                  : 5;
        } CANFDCKDIVCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t GPTCKDIVCR;       /*!< (@ 0x0000006F) GPT Clock Division Control Register                        */

            struct
            {
                __IOM uint8_t GPTCKDIV : 3; /*!< [2..0] GPT Clock (GPTCLK) Division Select                                 */
                uint8_t                : 5;
            } GPTCKDIVCR_b;
        };

        union
        {
            __IOM uint8_t USB60CKDIVCR;       /*!< (@ 0x0000006F) USB60 Clock Division Control Register                      */

            struct
            {
                __IOM uint8_t USB60CKDIV : 3; /*!< [2..0] USB clock (USB60CLK) Division Select                               */
                uint8_t                  : 5;
            } USB60CKDIVCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t CECCKDIVCR;       /*!< (@ 0x00000070) CEC Clock Division Control Register                        */

            struct
            {
                __IOM uint8_t CECCKDIV : 3; /*!< [2..0] CEC clock (CECCLK) Division Select                                 */
                uint8_t                : 5;
            } CECCKDIVCR_b;
        };

        union
        {
            __IOM uint8_t IICCKDIVCR;       /*!< (@ 0x00000070) IIC Clock Division Control Register                        */

            struct
            {
                __IOM uint8_t IICCKDIV : 3; /*!< [2..0] IIC Clock (IICCLK) Division Select                                 */
                uint8_t                : 5;
            } IICCKDIVCR_b;
        };
    };

    union
    {
        __IOM uint8_t I3CCKDIVCR;       /*!< (@ 0x00000071) I3C clock Division control register                        */

        struct
        {
            __IOM uint8_t I3CCKDIV : 3; /*!< [2..0] I3C clock (I3CCLK) Division Select                                 */
            uint8_t                : 5;
        } I3CCKDIVCR_b;
    };
    __IM uint16_t RESERVED19;

    union
    {
        __IOM uint8_t USBCKCR;           /*!< (@ 0x00000074) USB Clock Control Register                                 */

        struct
        {
            __IOM uint8_t USBCKSEL  : 3; /*!< [2..0] USB Clock (USBCLK) Source Select                                   */
            uint8_t                 : 3;
            __IOM uint8_t USBCKSREQ : 1; /*!< [6..6] USB Clock (USBCLK) Switching Request                               */
            __IM uint8_t  USBCKSRDY : 1; /*!< [7..7] USB Clock (USBCLK) Switching Ready state flag                      */
        } USBCKCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t OCTACKCR;           /*!< (@ 0x00000075) Octal-SPI Clock Control Register                           */

            struct
            {
                __IOM uint8_t OCTACKSEL  : 3; /*!< [2..0] Octal-SPI Clock (OCTACLK) Source Select                            */
                uint8_t                  : 3;
                __IOM uint8_t OCTACKSREQ : 1; /*!< [6..6] Octal-SPI Clock (OCTACLK) Switching Request                        */
                __IM uint8_t  OCTACKSRDY : 1; /*!< [7..7] Octal-SPI Clock (OCTACLK) Switching Ready state flag               */
            } OCTACKCR_b;
        };

        union
        {
            __IOM uint8_t SCISPICKCR;           /*!< (@ 0x00000075) SCI SPI Clock Control Register                             */

            struct
            {
                __IOM uint8_t SCISPICKSEL  : 3; /*!< [2..0] SCI SPI Clock (SCISPICLK) Source Select                            */
                uint8_t                    : 3;
                __IOM uint8_t SCISPICKSREQ : 1; /*!< [6..6] SCI SPI Clock (SCISPICLK) Switching Request                        */
                __IM uint8_t  SCISPICKSRDY : 1; /*!< [7..7] SCI SPI Clock (SCISPICLK) Switching Ready state flag               */
            } SCISPICKCR_b;
        };
    };

    union
    {
        __IOM uint8_t CANFDCKCR;           /*!< (@ 0x00000076) CANFD Clock Control Register                               */

        struct
        {
            __IOM uint8_t CANFDCKSEL  : 3; /*!< [2..0] CANFD Clock (CANFDCLK) Source Select                               */
            uint8_t                   : 3;
            __IOM uint8_t CANFDCKSREQ : 1; /*!< [6..6] CANFD Clock (CANFDCLK) Switching Request                           */
            __IM uint8_t  CANFDCKSRDY : 1; /*!< [7..7] CANFD Clock (CANFDCLK) Switching Ready state flag                  */
        } CANFDCKCR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t GPTCKCR;           /*!< (@ 0x00000077) GPT Clock Control Register                                 */

            struct
            {
                __IOM uint8_t GPTCKSEL  : 3; /*!< [2..0] GPT Clock (GPTCLK) Source Select                                   */
                uint8_t                 : 3;
                __IOM uint8_t GPTCKSREQ : 1; /*!< [6..6] GPT Clock (GPTCLK) Switching Request                               */
                __IM uint8_t  GPTCKSRDY : 1; /*!< [7..7] GPT Clock (GPTCLK) Switching Ready state flag                      */
            } GPTCKCR_b;
        };

        union
        {
            __IOM uint8_t USB60CKCR;           /*!< (@ 0x00000077) USB60 clock control register                               */

            struct
            {
                __IOM uint8_t USB60CKSEL  : 4; /*!< [3..0] USB clock (USB60CLK) Source Select                                 */
                uint8_t                   : 2;
                __IOM uint8_t USB60CKSREQ : 1; /*!< [6..6] USB clock (USB60CLK) Switching Request                             */
                __IOM uint8_t USB60CKSRDY : 1; /*!< [7..7] USB clock (USB60CLK) Switching Ready state flag                    */
            } USB60CKCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t CECCKCR;           /*!< (@ 0x00000078) CEC Clock Control Register                                 */

            struct
            {
                __IOM uint8_t CECCKSEL  : 3; /*!< [2..0] CEC clock (CECCLK) Source Select                                   */
                uint8_t                 : 3;
                __IOM uint8_t CECCKSREQ : 1; /*!< [6..6] CEC clock (CECCLK) Switching Request                               */
                __IM uint8_t  CECCKSRDY : 1; /*!< [7..7] CEC clock (CECCLK) Switching Ready state flag                      */
            } CECCKCR_b;
        };

        union
        {
            __IOM uint8_t IICCKCR;           /*!< (@ 0x00000078) IIC Clock Control Register                                 */

            struct
            {
                __IOM uint8_t IICCKSEL  : 3; /*!< [2..0] IIC Clock (IICCLK) Source Select                                   */
                uint8_t                 : 3;
                __IOM uint8_t IICCKSREQ : 1; /*!< [6..6] IIC Clock (IICCLK) Switching Request                               */
                __IM uint8_t  IICCKSRDY : 1; /*!< [7..7] IIC Clock (IICCLK) Switching Ready state flag                      */
            } IICCKCR_b;
        };
    };

    union
    {
        __IOM uint8_t I3CCKCR;           /*!< (@ 0x00000079) I3C Clock Control Register                                 */

        struct
        {
            __IOM uint8_t I3CCKSEL  : 3; /*!< [2..0] I3C clock (I3CCLK) source select                                   */
            uint8_t                 : 3;
            __IOM uint8_t I3CCKSREQ : 1; /*!< [6..6] I3C clock (I3CCLK) switching request                               */
            __IM uint8_t  I3CCKSRDY : 1; /*!< [7..7] I3C clock (I3CCLK) switching ready state flag                      */
        } I3CCKCR_b;
    };
    __IM uint16_t RESERVED20;
    __IM uint32_t RESERVED21[3];

    union
    {
        __IOM uint32_t SNZREQCR1;         /*!< (@ 0x00000088) Snooze Request Control Register 1                          */

        struct
        {
            __IOM uint32_t SNZREQEN0 : 1; /*!< [0..0] Enable AGT3 underflow snooze request                               */
            __IOM uint32_t SNZREQEN1 : 1; /*!< [1..1] Enable AGT3 underflow snooze request                               */
            __IOM uint32_t SNZREQEN2 : 1; /*!< [2..2] Enable AGT3 underflow snooze request                               */
            uint32_t                 : 29;
        } SNZREQCR1_b;
    };
    __IM uint32_t RESERVED22;
    __IM uint16_t RESERVED23;

    union
    {
        __IOM uint8_t SNZCR;            /*!< (@ 0x00000092) Snooze Control Register                                    */

        struct
        {
            __IOM uint8_t RXDREQEN : 1; /*!< [0..0] RXD0 Snooze Request Enable NOTE: Do not set to 1 other
                                         *   than in asynchronous mode.                                                */
            __IOM uint8_t SNZDTCEN : 1; /*!< [1..1] DTC Enable in Snooze Mode                                          */
            uint8_t                : 5;
            __IOM uint8_t SNZE     : 1; /*!< [7..7] Snooze Mode Enable                                                 */
        } SNZCR_b;
    };
    __IM uint8_t RESERVED24;

    union
    {
        __IOM uint8_t SNZEDCR;           /*!< (@ 0x00000094) Snooze End Control Register                                */

        struct
        {
            __IOM uint8_t AGT1UNFED : 1; /*!< [0..0] AGT1 underflow Snooze End Enable                                   */
            __IOM uint8_t DTCZRED   : 1; /*!< [1..1] Last DTC transmission completion Snooze End Enable                 */
            __IOM uint8_t DTCNZRED  : 1; /*!< [2..2] Not Last DTC transmission completion Snooze End Enable             */
            __IOM uint8_t AD0MATED  : 1; /*!< [3..3] AD compare match 0 Snooze End Enable                               */
            __IOM uint8_t AD0UMTED  : 1; /*!< [4..4] AD compare mismatch 0 Snooze End Enable                            */
            __IOM uint8_t AD1MATED  : 1; /*!< [5..5] AD compare match 1 Snooze End Enable                               */
            __IOM uint8_t AD1UMTED  : 1; /*!< [6..6] AD compare mismatch 1 Snooze End Enable                            */
            __IOM uint8_t SCI0UMTED : 1; /*!< [7..7] SCI0 address unmatch Snooze End EnableNote: Do not set
                                          *   to 1 other than in asynchronous mode.                                     */
        } SNZEDCR_b;
    };

    union
    {
        __IOM uint8_t SNZEDCR1;          /*!< (@ 0x00000095) Snooze End Control Register 1                              */

        struct
        {
            __IOM uint8_t AGT3UNFED : 1; /*!< [0..0] AGT3 underflow Snooze End Enable                                   */
            uint8_t                 : 7;
        } SNZEDCR1_b;
    };
    __IM uint16_t RESERVED25;

    union
    {
        __IOM uint32_t SNZREQCR;           /*!< (@ 0x00000098) Snooze Request Control Register                            */

        struct
        {
            __IOM uint32_t SNZREQEN0  : 1; /*!< [0..0] Snooze Request Enable 0Enable IRQ 0 pin snooze request             */
            __IOM uint32_t SNZREQEN1  : 1; /*!< [1..1] Snooze Request Enable 0Enable IRQ 1 pin snooze request             */
            __IOM uint32_t SNZREQEN2  : 1; /*!< [2..2] Snooze Request Enable 0Enable IRQ 2 pin snooze request             */
            __IOM uint32_t SNZREQEN3  : 1; /*!< [3..3] Snooze Request Enable 0Enable IRQ 3 pin snooze request             */
            __IOM uint32_t SNZREQEN4  : 1; /*!< [4..4] Snooze Request Enable 0Enable IRQ 4 pin snooze request             */
            __IOM uint32_t SNZREQEN5  : 1; /*!< [5..5] Snooze Request Enable 0Enable IRQ 5 pin snooze request             */
            __IOM uint32_t SNZREQEN6  : 1; /*!< [6..6] Snooze Request Enable 0Enable IRQ 6 pin snooze request             */
            __IOM uint32_t SNZREQEN7  : 1; /*!< [7..7] Snooze Request Enable 0Enable IRQ 7 pin snooze request             */
            __IOM uint32_t SNZREQEN8  : 1; /*!< [8..8] Snooze Request Enable 0Enable IRQ 8 pin snooze request             */
            __IOM uint32_t SNZREQEN9  : 1; /*!< [9..9] Snooze Request Enable 0Enable IRQ 9 pin snooze request             */
            __IOM uint32_t SNZREQEN10 : 1; /*!< [10..10] Snooze Request Enable 0Enable IRQ 10 pin snooze request          */
            __IOM uint32_t SNZREQEN11 : 1; /*!< [11..11] Snooze Request Enable 0Enable IRQ 11 pin snooze request          */
            __IOM uint32_t SNZREQEN12 : 1; /*!< [12..12] Snooze Request Enable 0Enable IRQ 12 pin snooze request          */
            __IOM uint32_t SNZREQEN13 : 1; /*!< [13..13] Snooze Request Enable 0Enable IRQ 13 pin snooze request          */
            __IOM uint32_t SNZREQEN14 : 1; /*!< [14..14] Snooze Request Enable 0Enable IRQ 14 pin snooze request          */
            __IOM uint32_t SNZREQEN15 : 1; /*!< [15..15] Snooze Request Enable 0Enable IRQ 15 pin snooze request          */
            uint32_t                  : 1;
            __IOM uint32_t SNZREQEN17 : 1; /*!< [17..17] Snooze Request Enable 17Enable KR snooze request                 */
            uint32_t                  : 4;
            __IOM uint32_t SNZREQEN22 : 1; /*!< [22..22] Snooze Request Enable 22Enable Comparator-HS0 snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN23 : 1; /*!< [23..23] Snooze Request Enable 23Enable Comparator-LP0 snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN24 : 1; /*!< [24..24] Snooze Request Enable 24Enable RTC alarm snooze request          */
            __IOM uint32_t SNZREQEN25 : 1; /*!< [25..25] Snooze Request Enable 25Enable RTC period snooze request         */
            uint32_t                  : 2;
            __IOM uint32_t SNZREQEN28 : 1; /*!< [28..28] Snooze Request Enable 28Enable AGT1 underflow snooze
                                            *   request                                                                   */
            __IOM uint32_t SNZREQEN29 : 1; /*!< [29..29] Snooze Request Enable 29Enable AGT1 compare match A
                                            *   snooze request                                                            */
            __IOM uint32_t SNZREQEN30 : 1; /*!< [30..30] Snooze Request Enable 30Enable AGT1 compare match B
                                            *   snooze request                                                            */
            uint32_t : 1;
        } SNZREQCR_b;
    };
    __IM uint16_t RESERVED26;

    union
    {
        __IOM uint8_t FLSTOP;          /*!< (@ 0x0000009E) Flash Operation Control Register                           */

        struct
        {
            __IOM uint8_t FLSTOP : 1;  /*!< [0..0] Selecting ON/OFF of the Flash Memory Operation                     */
            uint8_t              : 3;
            __IOM uint8_t FLSTPF : 1;  /*!< [4..4] Flash Memory Operation Status Flag                                 */
            uint8_t              : 3;
        } FLSTOP_b;
    };

    union
    {
        __IOM uint8_t PSMCR;           /*!< (@ 0x0000009F) Power Save Memory Control Register                         */

        struct
        {
            __IOM uint8_t PSMC : 2;    /*!< [1..0] Power save memory control.                                         */
            uint8_t            : 6;
        } PSMCR_b;
    };

    union
    {
        __IOM uint8_t OPCCR;           /*!< (@ 0x000000A0) Operating Power Control Register                           */

        struct
        {
            __IOM uint8_t OPCM   : 2;  /*!< [1..0] Operating Power Control Mode Select                                */
            uint8_t              : 2;
            __IM uint8_t OPCMTSF : 1;  /*!< [4..4] Operating Power Control Mode Transition Status Flag                */
            uint8_t              : 3;
        } OPCCR_b;
    };
    __IM uint8_t RESERVED27;

    union
    {
        __IOM uint8_t MOSCWTCR;        /*!< (@ 0x000000A2) Main Clock Oscillator Wait Control Register                */

        struct
        {
            __IOM uint8_t MSTS : 4;    /*!< [3..0] Main clock oscillator wait time setting                            */
            uint8_t            : 4;
        } MOSCWTCR_b;
    };
    __IM uint8_t RESERVED28[2];

    union
    {
        __IOM uint8_t HOCOWTCR;        /*!< (@ 0x000000A5) High-speed on-chip oscillator wait control register        */

        struct
        {
            __IOM uint8_t HSTS : 3;    /*!< [2..0] HOCO wait time settingWaiting time (sec) = setting of
                                        *   the HSTS[2:0] bits/fLOCO(Trimmed) + 3/fLOC(Untrimmed)                     */
            uint8_t : 5;
        } HOCOWTCR_b;
    };
    __IM uint16_t RESERVED29[2];

    union
    {
        __IOM uint8_t SOPCCR;          /*!< (@ 0x000000AA) Sub Operating Power Control Register                       */

        struct
        {
            __IOM uint8_t SOPCM   : 1; /*!< [0..0] Sub Operating Power Control Mode Select                            */
            uint8_t               : 3;
            __IM uint8_t SOPCMTSF : 1; /*!< [4..4] Sub Operating Power Control Mode Transition Status Flag            */
            uint8_t               : 3;
        } SOPCCR_b;
    };
    __IM uint8_t  RESERVED30;
    __IM uint32_t RESERVED31[5];

    union
    {
        __IOM uint16_t RSTSR1;         /*!< (@ 0x000000C0) Reset Status Register 1                                    */

        struct
        {
            __IOM uint16_t IWDTRF : 1; /*!< [0..0] Independent Watchdog Timer Reset Detect FlagNOTE: Writable
                                        *   only to clear the flag. Confirm the value is 1 and then
                                        *   write 0.                                                                  */
            __IOM uint16_t WDTRF : 1;  /*!< [1..1] Watchdog Timer Reset Detect FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
            __IOM uint16_t SWRF : 1;   /*!< [2..2] Software Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            uint16_t             : 5;
            __IOM uint16_t RPERF : 1;  /*!< [8..8] RAM Parity Error Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t REERF : 1;  /*!< [9..9] RAM ECC Error Reset Detect FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
            __IOM uint16_t BUSSRF : 1; /*!< [10..10] Bus Slave MPU Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t BUSMRF : 1; /*!< [11..11] Bus Master MPU Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint16_t SPERF : 1;  /*!< [12..12] SP Error Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            __IOM uint16_t TZERF : 1;  /*!< [13..13] Trust Zone Error Reset Detect Flag                               */
            uint16_t             : 1;
            __IOM uint16_t CPERF : 1;  /*!< [15..15] Cache Parity Error Reset Detect Flag                             */
        } RSTSR1_b;
    };
    __IM uint16_t RESERVED32;
    __IM uint32_t RESERVED33[3];

    union
    {
        __IOM uint8_t USBCKCR_ALT;       /*!< (@ 0x000000D0) USB Clock Control Register                                 */

        struct
        {
            __IOM uint8_t USBCLKSEL : 1; /*!< [0..0] The USBCLKSEL bit selects the source of the USB clock
                                          *   (UCLK).                                                                   */
            uint8_t : 7;
        } USBCKCR_ALT_b;
    };

    union
    {
        __IOM uint8_t SDADCCKCR;          /*!< (@ 0x000000D1) 24-bit Sigma-Delta A/D Converter Clock Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t SDADCCKSEL : 1; /*!< [0..0] 24-bit Sigma-Delta A/D Converter Clock Select                      */
            uint8_t                  : 6;
            __IOM uint8_t SDADCCKEN  : 1; /*!< [7..7] 24-bit Sigma-Delta A/D Converter Clock Enable                      */
        } SDADCCKCR_b;
    };
    __IM uint16_t RESERVED34;
    __IM uint32_t RESERVED35[3];

    union
    {
        __IOM uint8_t LVD1CR1;         /*!< (@ 0x000000E0) Voltage Monitor 1 Circuit Control Register 1               */

        struct
        {
            __IOM uint8_t IDTSEL : 2;  /*!< [1..0] Voltage Monitor Interrupt Generation Condition Select              */
            __IOM uint8_t IRQSEL : 1;  /*!< [2..2] Voltage Monitor Interrupt Type Select                              */
            uint8_t              : 5;
        } LVD1CR1_b;
    };

    union
    {
        __IOM uint8_t LVD1SR;          /*!< (@ 0x000000E1) Voltage Monitor 1 Circuit Status Register                  */

        struct
        {
            __IOM uint8_t DET : 1;     /*!< [0..0] Voltage Monitor Voltage Change Detection Flag NOTE: Only
                                        *   0 can be written to this bit. After writing 0 to this bit,
                                        *   it takes 2 system clock cycles for the bit to be read as
                                        *   0.                                                                        */
            __IM uint8_t MON : 1;      /*!< [1..1] Voltage Monitor 1 Signal Monitor Flag                              */
            uint8_t          : 6;
        } LVD1SR_b;
    };

    union
    {
        __IOM uint8_t LVD2CR1;         /*!< (@ 0x000000E2) Voltage Monitor 2 Circuit Control Register 1               */

        struct
        {
            __IOM uint8_t IDTSEL : 2;  /*!< [1..0] Voltage Monitor Interrupt Generation Condition Select              */
            __IOM uint8_t IRQSEL : 1;  /*!< [2..2] Voltage Monitor Interrupt Type Select                              */
            uint8_t              : 5;
        } LVD2CR1_b;
    };

    union
    {
        __IOM uint8_t LVD2SR;          /*!< (@ 0x000000E3) Voltage Monitor 2 Circuit Status Register                  */

        struct
        {
            __IOM uint8_t DET : 1;     /*!< [0..0] Voltage Monitor Voltage Change Detection Flag NOTE: Only
                                        *   0 can be written to this bit. After writing 0 to this bit,
                                        *   it takes 2 system clock cycles for the bit to be read as
                                        *   0.                                                                        */
            __IM uint8_t MON : 1;      /*!< [1..1] Voltage Monitor 1 Signal Monitor Flag                              */
            uint8_t          : 6;
        } LVD2SR_b;
    };
    __IM uint32_t RESERVED36[183];

    union
    {
        __IOM uint32_t CGFSAR;           /*!< (@ 0x000003C0) Clock Generation Function Security Attribute
                                          *                  Register                                                   */

        struct
        {
            __IOM uint32_t NONSEC00 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
            __IOM uint32_t NONSEC01 : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
            __IOM uint32_t NONSEC02 : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
            __IOM uint32_t NONSEC03 : 1; /*!< [3..3] Non Secure Attribute bit 3                                         */
            __IOM uint32_t NONSEC04 : 1; /*!< [4..4] Non Secure Attribute bit 4                                         */
            __IOM uint32_t NONSEC05 : 1; /*!< [5..5] Non Secure Attribute bit 5                                         */
            __IOM uint32_t NONSEC06 : 1; /*!< [6..6] Non Secure Attribute bit 6                                         */
            __IOM uint32_t NONSEC07 : 1; /*!< [7..7] Non Secure Attribute bit 7                                         */
            __IOM uint32_t NONSEC08 : 1; /*!< [8..8] Non Secure Attribute bit 8                                         */
            __IOM uint32_t NONSEC09 : 1; /*!< [9..9] Non Secure Attribute bit 9                                         */
            __IOM uint32_t NONSEC10 : 1; /*!< [10..10] Non Secure Attribute bit 10                                      */
            __IOM uint32_t NONSEC11 : 1; /*!< [11..11] Non Secure Attribute bit 11                                      */
            __IOM uint32_t NONSEC12 : 1; /*!< [12..12] Non Secure Attribute bit 12                                      */
            __IOM uint32_t NONSEC13 : 1; /*!< [13..13] Non Secure Attribute bit 13                                      */
            __IOM uint32_t NONSEC14 : 1; /*!< [14..14] Non Secure Attribute bit 14                                      */
            __IOM uint32_t NONSEC15 : 1; /*!< [15..15] Non Secure Attribute bit 15                                      */
            __IOM uint32_t NONSEC16 : 1; /*!< [16..16] Non Secure Attribute bit 16                                      */
            __IOM uint32_t NONSEC17 : 1; /*!< [17..17] Non Secure Attribute bit 17                                      */
            __IOM uint32_t NONSEC18 : 1; /*!< [18..18] Non Secure Attribute bit 18                                      */
            __IOM uint32_t NONSEC19 : 1; /*!< [19..19] Non Secure Attribute bit 19                                      */
            __IOM uint32_t NONSEC20 : 1; /*!< [20..20] Non Secure Attribute bit 20                                      */
            __IOM uint32_t NONSEC21 : 1; /*!< [21..21] Non Secure Attribute bit 21                                      */
            __IOM uint32_t NONSEC22 : 1; /*!< [22..22] Non Secure Attribute bit 22                                      */
            __IOM uint32_t NONSEC23 : 1; /*!< [23..23] Non Secure Attribute bit 23                                      */
            __IOM uint32_t NONSEC24 : 1; /*!< [24..24] Non Secure Attribute bit 24                                      */
            __IOM uint32_t NONSEC25 : 1; /*!< [25..25] Non Secure Attribute bit 25                                      */
            __IOM uint32_t NONSEC26 : 1; /*!< [26..26] Non Secure Attribute bit 26                                      */
            __IOM uint32_t NONSEC27 : 1; /*!< [27..27] Non Secure Attribute bit 27                                      */
            __IOM uint32_t NONSEC28 : 1; /*!< [28..28] Non Secure Attribute bit 28                                      */
            __IOM uint32_t NONSEC29 : 1; /*!< [29..29] Non Secure Attribute bit 29                                      */
            __IOM uint32_t NONSEC30 : 1; /*!< [30..30] Non Secure Attribute bit 30                                      */
            __IOM uint32_t NONSEC31 : 1; /*!< [31..31] Non Secure Attribute bit 31                                      */
        } CGFSAR_b;
    };
    __IM uint32_t RESERVED37;

    union
    {
        __IOM uint32_t LPMSAR;          /*!< (@ 0x000003C8) Low Power Mode Security Attribution Register               */

        struct
        {
            __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
            uint32_t               : 1;
            __IOM uint32_t NONSEC2 : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
            uint32_t               : 1;
            __IOM uint32_t NONSEC4 : 1; /*!< [4..4] Non Secure Attribute bit 4                                         */
            uint32_t               : 3;
            __IOM uint32_t NONSEC8 : 1; /*!< [8..8] Non Secure Attribute bit 8                                         */
            __IOM uint32_t NONSEC9 : 1; /*!< [9..9] Non Secure Attribute bit 9                                         */
            uint32_t               : 22;
        } LPMSAR_b;
    };

    union
    {
        union
        {
            __IOM uint32_t LVDSAR;          /*!< (@ 0x000003CC) Low Voltage Detection Security Attribution Register        */

            struct
            {
                __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
                __IOM uint32_t NONSEC1 : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
                uint32_t               : 30;
            } LVDSAR_b;
        };

        union
        {
            __IOM uint32_t RSTSAR;          /*!< (@ 0x000003CC) Reset Security Attribution Register                        */

            struct
            {
                __IOM uint32_t NONSEC0 : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
                __IOM uint32_t NONSEC1 : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
                __IOM uint32_t NONSEC2 : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
                uint32_t               : 29;
            } RSTSAR_b;
        };
    };

    union
    {
        __IOM uint32_t BBFSAR;           /*!< (@ 0x000003D0) Battery Backup Function Security Attribute Register        */

        struct
        {
            __IOM uint32_t NONSEC0  : 1; /*!< [0..0] Non Secure Attribute bit 0                                         */
            __IOM uint32_t NONSEC1  : 1; /*!< [1..1] Non Secure Attribute bit 1                                         */
            __IOM uint32_t NONSEC2  : 1; /*!< [2..2] Non Secure Attribute bit 2                                         */
            uint32_t                : 13;
            __IOM uint32_t NONSEC16 : 1; /*!< [16..16] Non Secure Attribute bit 16                                      */
            __IOM uint32_t NONSEC17 : 1; /*!< [17..17] Non Secure Attribute bit 17                                      */
            __IOM uint32_t NONSEC18 : 1; /*!< [18..18] Non Secure Attribute bit 18                                      */
            __IOM uint32_t NONSEC19 : 1; /*!< [19..19] Non Secure Attribute bit 19                                      */
            __IOM uint32_t NONSEC20 : 1; /*!< [20..20] Non Secure Attribute bit 20                                      */
            __IOM uint32_t NONSEC21 : 1; /*!< [21..21] Non Secure Attribute bit 21                                      */
            __IOM uint32_t NONSEC22 : 1; /*!< [22..22] Non Secure Attribute bit 22                                      */
            __IOM uint32_t NONSEC23 : 1; /*!< [23..23] Non Secure Attribute bit 23                                      */
            uint32_t                : 8;
        } BBFSAR_b;
    };
    __IM uint32_t RESERVED38[3];

    union
    {
        __IOM uint32_t DPFSAR;          /*!< (@ 0x000003E0) Deep Standby Interrupt Factor Security Attribution
                                         *                  Register                                                   */

        struct
        {
            __IOM uint32_t DPFSA0 : 1;  /*!< [0..0] Deep Standby Interrupt Factor Security Attribute bit
                                         *   0                                                                         */
            __IOM uint32_t DPFSA1 : 1;  /*!< [1..1] Deep Standby Interrupt Factor Security Attribute bit
                                         *   1                                                                         */
            __IOM uint32_t DPFSA2 : 1;  /*!< [2..2] Deep Standby Interrupt Factor Security Attribute bit
                                         *   2                                                                         */
            __IOM uint32_t DPFSA3 : 1;  /*!< [3..3] Deep Standby Interrupt Factor Security Attribute bit
                                         *   3                                                                         */
            __IOM uint32_t DPFSA4 : 1;  /*!< [4..4] Deep Standby Interrupt Factor Security Attribute bit
                                         *   4                                                                         */
            __IOM uint32_t DPFSA5 : 1;  /*!< [5..5] Deep Standby Interrupt Factor Security Attribute bit
                                         *   5                                                                         */
            __IOM uint32_t DPFSA6 : 1;  /*!< [6..6] Deep Standby Interrupt Factor Security Attribute bit
                                         *   6                                                                         */
            __IOM uint32_t DPFSA7 : 1;  /*!< [7..7] Deep Standby Interrupt Factor Security Attribute bit
                                         *   7                                                                         */
            __IOM uint32_t DPFSA8 : 1;  /*!< [8..8] Deep Standby Interrupt Factor Security Attribute bit
                                         *   8                                                                         */
            __IOM uint32_t DPFSA9 : 1;  /*!< [9..9] Deep Standby Interrupt Factor Security Attribute bit
                                         *   9                                                                         */
            __IOM uint32_t DPFSA10 : 1; /*!< [10..10] Deep Standby Interrupt Factor Security Attribute bit
                                         *   10                                                                        */
            __IOM uint32_t DPFSA11 : 1; /*!< [11..11] Deep Standby Interrupt Factor Security Attribute bit
                                         *   11                                                                        */
            __IOM uint32_t DPFSA12 : 1; /*!< [12..12] Deep Standby Interrupt Factor Security Attribute bit
                                         *   12                                                                        */
            __IOM uint32_t DPFSA13 : 1; /*!< [13..13] Deep Standby Interrupt Factor Security Attribute bit
                                         *   13                                                                        */
            __IOM uint32_t DPFSA14 : 1; /*!< [14..14] Deep Standby Interrupt Factor Security Attribute bit
                                         *   14                                                                        */
            __IOM uint32_t DPFSA15 : 1; /*!< [15..15] Deep Standby Interrupt Factor Security Attribute bit
                                         *   15                                                                        */
            __IOM uint32_t DPFSA16 : 1; /*!< [16..16] Deep Standby Interrupt Factor Security Attribute bit
                                         *   16                                                                        */
            __IOM uint32_t DPFSA17 : 1; /*!< [17..17] Deep Standby Interrupt Factor Security Attribute bit
                                         *   17                                                                        */
            __IOM uint32_t DPFSA18 : 1; /*!< [18..18] Deep Standby Interrupt Factor Security Attribute bit
                                         *   18                                                                        */
            __IOM uint32_t DPFSA19 : 1; /*!< [19..19] Deep Standby Interrupt Factor Security Attribute bit
                                         *   19                                                                        */
            __IOM uint32_t DPFSA20 : 1; /*!< [20..20] Deep Standby Interrupt Factor Security Attribute bit
                                         *   20                                                                        */
            uint32_t               : 3;
            __IOM uint32_t DPFSA24 : 1; /*!< [24..24] Deep Standby Interrupt Factor Security Attribute bit
                                         *   24                                                                        */
            uint32_t               : 1;
            __IOM uint32_t DPFSA26 : 1; /*!< [26..26] Deep Standby Interrupt Factor Security Attribute bit
                                         *   26                                                                        */
            __IOM uint32_t DPFSA27 : 1; /*!< [27..27] Deep Standby Interrupt Factor Security Attribute bit
                                         *   27                                                                        */
            uint32_t : 4;
        } DPFSAR_b;
    };
    __IM uint32_t RESERVED39[6];
    __IM uint16_t RESERVED40;

    union
    {
        __IOM uint16_t PRCR;           /*!< (@ 0x000003FE) Protect Register                                           */

        struct
        {
            __IOM uint16_t PRC0 : 1;   /*!< [0..0] Enables writing to the registers related to the clock
                                        *   generation circuit.                                                       */
            __IOM uint16_t PRC1 : 1;   /*!< [1..1] Enables writing to the registers related to the operating
                                        *   modes, the low power consumption modes and the battery
                                        *   backup function.                                                          */
            uint16_t            : 1;
            __IOM uint16_t PRC3 : 1;   /*!< [3..3] Enables writing to the registers related to the LVD.               */
            __IOM uint16_t PRC4 : 1;   /*!< [4..4] PRC4                                                               */
            uint16_t            : 3;
            __OM uint16_t PRKEY : 8;   /*!< [15..8] PRKEY Key Code                                                    */
        } PRCR_b;
    };

    union
    {
        __IOM uint8_t DPSBYCR;         /*!< (@ 0x00000400) Deep Standby Control Register                              */

        struct
        {
            __IOM uint8_t DEEPCUT : 2; /*!< [1..0] Power-Supply Control                                               */
            uint8_t               : 4;
            __IOM uint8_t IOKEEP  : 1; /*!< [6..6] I/O Port Retention                                                 */
            __IOM uint8_t DPSBY   : 1; /*!< [7..7] Deep Software Standby                                              */
        } DPSBYCR_b;
    };

    union
    {
        __IOM uint8_t DPSWCR;          /*!< (@ 0x00000401) Deep Standby Wait Control Register                         */

        struct
        {
            __IOM uint8_t WTSTS : 6;   /*!< [5..0] Deep Software Wait Standby Time Setting Bit                        */
            uint8_t             : 2;
        } DPSWCR_b;
    };

    union
    {
        __IOM uint8_t DPSIER0;         /*!< (@ 0x00000402) Deep Standby Interrupt Enable Register 0                   */

        struct
        {
            __IOM uint8_t DIRQ0E : 1;  /*!< [0..0] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ1E : 1;  /*!< [1..1] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ2E : 1;  /*!< [2..2] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ3E : 1;  /*!< [3..3] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ4E : 1;  /*!< [4..4] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ5E : 1;  /*!< [5..5] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ6E : 1;  /*!< [6..6] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ7E : 1;  /*!< [7..7] IRQ-DS Pin Enable                                                  */
        } DPSIER0_b;
    };

    union
    {
        __IOM uint8_t DPSIER1;         /*!< (@ 0x00000403) Deep Standby Interrupt Enable Register 1                   */

        struct
        {
            __IOM uint8_t DIRQ8E  : 1; /*!< [0..0] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ9E  : 1; /*!< [1..1] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ10E : 1; /*!< [2..2] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ11E : 1; /*!< [3..3] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ12E : 1; /*!< [4..4] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ13E : 1; /*!< [5..5] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ14E : 1; /*!< [6..6] IRQ-DS Pin Enable                                                  */
            __IOM uint8_t DIRQ15E : 1; /*!< [7..7] IRQ-DS Pin Enable                                                  */
        } DPSIER1_b;
    };

    union
    {
        __IOM uint8_t DPSIER2;          /*!< (@ 0x00000404) Deep Standby Interrupt Enable Register 2                   */

        struct
        {
            __IOM uint8_t DLVD1IE  : 1; /*!< [0..0] LVD1 Deep Standby Cancel Signal Enable                             */
            __IOM uint8_t DLVD2IE  : 1; /*!< [1..1] LVD2 Deep Standby Cancel Signal Enable                             */
            __IOM uint8_t DTRTCIIE : 1; /*!< [2..2] RTC Interval interrupt Deep Standby Cancel Signal Enable           */
            __IOM uint8_t DRTCAIE  : 1; /*!< [3..3] RTC Alarm interrupt Deep Standby Cancel Signal Enable              */
            __IOM uint8_t DNMIE    : 1; /*!< [4..4] NMI Pin Enable                                                     */
            uint8_t                : 3;
        } DPSIER2_b;
    };

    union
    {
        __IOM uint8_t DPSIER3;          /*!< (@ 0x00000405) Deep Standby Interrupt Enable Register 3                   */

        struct
        {
            __IOM uint8_t DUSBFSIE : 1; /*!< [0..0] USBFS Suspend/Resume Deep Standby Cancel Signal Enable             */
            __IOM uint8_t DUSBHSIE : 1; /*!< [1..1] USBHS Suspend/Resume Deep Standby Cancel Signal Enable             */
            __IOM uint8_t DAGT1IE  : 1; /*!< [2..2] AGT1 Underflow Deep Standby Cancel Signal Enable                   */
            __IOM uint8_t DAGT3IE  : 1; /*!< [3..3] AGT3 Underflow Deep Standby Cancel Signal Enable                   */
            uint8_t                : 4;
        } DPSIER3_b;
    };

    union
    {
        __IOM uint8_t DPSIFR0;         /*!< (@ 0x00000406) Deep Standby Interrupt Flag Register 0                     */

        struct
        {
            __IOM uint8_t DIRQ0F : 1;  /*!< [0..0] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ1F : 1;  /*!< [1..1] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ2F : 1;  /*!< [2..2] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ3F : 1;  /*!< [3..3] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ4F : 1;  /*!< [4..4] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ5F : 1;  /*!< [5..5] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ6F : 1;  /*!< [6..6] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ7F : 1;  /*!< [7..7] IRQ-DS Pin Deep Standby Cancel Flag                                */
        } DPSIFR0_b;
    };

    union
    {
        __IOM uint8_t DPSIFR1;         /*!< (@ 0x00000407) Deep Standby Interrupt Flag Register 1                     */

        struct
        {
            __IOM uint8_t DIRQ8F  : 1; /*!< [0..0] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ9F  : 1; /*!< [1..1] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ10F : 1; /*!< [2..2] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ11F : 1; /*!< [3..3] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ12F : 1; /*!< [4..4] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ13F : 1; /*!< [5..5] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ14F : 1; /*!< [6..6] IRQ-DS Pin Deep Standby Cancel Flag                                */
            __IOM uint8_t DIRQ15F : 1; /*!< [7..7] IRQ-DS Pin Deep Standby Cancel Flag                                */
        } DPSIFR1_b;
    };

    union
    {
        __IOM uint8_t DPSIFR2;          /*!< (@ 0x00000408) Deep Standby Interrupt Flag Register 2                     */

        struct
        {
            __IOM uint8_t DLVD1IF  : 1; /*!< [0..0] LVD1 Deep Standby Cancel Flag                                      */
            __IOM uint8_t DLVD2IF  : 1; /*!< [1..1] LVD2 Deep Standby Cancel Flag                                      */
            __IOM uint8_t DTRTCIIF : 1; /*!< [2..2] RTC Interval interrupt Deep Standby Cancel Flag                    */
            __IOM uint8_t DRTCAIF  : 1; /*!< [3..3] RTC Alarm interrupt Deep Standby Cancel Flag                       */
            __IOM uint8_t DNMIF    : 1; /*!< [4..4] NMI Pin Deep Standby Cancel Flag                                   */
            uint8_t                : 3;
        } DPSIFR2_b;
    };

    union
    {
        __IOM uint8_t DPSIFR3;          /*!< (@ 0x00000409) Deep Standby Interrupt Flag Register 3                     */

        struct
        {
            __IOM uint8_t DUSBFSIF : 1; /*!< [0..0] USBFS Suspend/Resume Deep Standby Cancel Flag                      */
            __IOM uint8_t DUSBHSIF : 1; /*!< [1..1] USBHS Suspend/Resume Deep Standby Cancel Flag                      */
            __IOM uint8_t DAGT1IF  : 1; /*!< [2..2] AGT1 Underflow Deep Standby Cancel Flag                            */
            __IOM uint8_t DAGT3IF  : 1; /*!< [3..3] AGT3 Underflow Deep Standby Cancel Flag                            */
            uint8_t                : 4;
        } DPSIFR3_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR0;        /*!< (@ 0x0000040A) Deep Standby Interrupt Edge Register 0                     */

        struct
        {
            __IOM uint8_t DIRQ0EG : 1; /*!< [0..0] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ1EG : 1; /*!< [1..1] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ2EG : 1; /*!< [2..2] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ3EG : 1; /*!< [3..3] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ4EG : 1; /*!< [4..4] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ5EG : 1; /*!< [5..5] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ6EG : 1; /*!< [6..6] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ7EG : 1; /*!< [7..7] IRQ-DS Pin Edge Select                                             */
        } DPSIEGR0_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR1;        /*!< (@ 0x0000040B) Deep Standby Interrupt Edge Register 1                     */

        struct
        {
            __IOM uint8_t DIRQ0EG : 1; /*!< [0..0] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ1EG : 1; /*!< [1..1] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ2EG : 1; /*!< [2..2] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ3EG : 1; /*!< [3..3] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ4EG : 1; /*!< [4..4] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ5EG : 1; /*!< [5..5] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ6EG : 1; /*!< [6..6] IRQ-DS Pin Edge Select                                             */
            __IOM uint8_t DIRQ7EG : 1; /*!< [7..7] IRQ-DS Pin Edge Select                                             */
        } DPSIEGR1_b;
    };

    union
    {
        __IOM uint8_t DPSIEGR2;         /*!< (@ 0x0000040C) Deep Standby Interrupt Edge Register 2                     */

        struct
        {
            __IOM uint8_t DLVD1IEG : 1; /*!< [0..0] LVD1 Edge Select                                                   */
            __IOM uint8_t DLVD2IEG : 1; /*!< [1..1] LVD2 Edge Select                                                   */
            uint8_t                : 2;
            __IOM uint8_t DNMIEG   : 1; /*!< [4..4] NMI Pin Edge Select                                                */
            uint8_t                : 3;
        } DPSIEGR2_b;
    };
    __IM uint8_t RESERVED41;

    union
    {
        __IOM uint8_t SYOCDCR;         /*!< (@ 0x0000040E) System Control OCD Control Register                        */

        struct
        {
            __IOM uint8_t DOCDF : 1;   /*!< [0..0] Deep Standby OCD flag                                              */
            uint8_t             : 6;
            __IOM uint8_t DBGEN : 1;   /*!< [7..7] Debugger Enable bit                                                */
        } SYOCDCR_b;
    };

    union
    {
        __IOM uint8_t STCONR;          /*!< (@ 0x0000040F) Standby Condition Register                                 */

        struct
        {
            __IOM uint8_t STCON : 2;   /*!< [1..0] SSTBY condition bit                                                */
            uint8_t             : 6;
        } STCONR_b;
    };

    union
    {
        __IOM uint8_t RSTSR0;          /*!< (@ 0x00000410) Reset Status Register 0                                    */

        struct
        {
            __IOM uint8_t PORF : 1;    /*!< [0..0] Power-On Reset Detect FlagNOTE: Writable only to clear
                                        *   the flag. Confirm the value is 1 and then write 0.                        */
            __IOM uint8_t LVD0RF : 1;  /*!< [1..1] Voltage Monitor 0 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint8_t LVD1RF : 1;  /*!< [2..2] Voltage Monitor 1 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            __IOM uint8_t LVD2RF : 1;  /*!< [3..3] Voltage Monitor 2 Reset Detect FlagNOTE: Writable only
                                        *   to clear the flag. Confirm the value is 1 and then write
                                        *   0.                                                                        */
            uint8_t               : 3;
            __IOM uint8_t DPSRSTF : 1; /*!< [7..7] Deep Software Standby Reset FlagNOTE: Writable only to
                                        *   clear the flag. Confirm the value is 1 and then write 0.                  */
        } RSTSR0_b;
    };

    union
    {
        __IOM uint8_t RSTSR2;          /*!< (@ 0x00000411) Reset Status Register 2                                    */

        struct
        {
            __IOM uint8_t CWSF : 1;    /*!< [0..0] Cold/Warm Start Determination Flag                                 */
            uint8_t            : 7;
        } RSTSR2_b;
    };
    __IM uint8_t RESERVED42;

    union
    {
        __IOM uint8_t MOMCR;           /*!< (@ 0x00000413) Main Clock Oscillator Mode Oscillation Control
                                        *                  Register                                                   */

        struct
        {
            uint8_t                 : 3;
            __IOM uint8_t MODRV1    : 1; /*!< [3..3] Main Clock Oscillator Drive Capability 1 Switching                 */
            __IOM uint8_t MODRV0    : 2; /*!< [5..4] Main Clock Oscillator Drive Capability 0 Switching                 */
            __IOM uint8_t MOSEL     : 1; /*!< [6..6] Main Clock Oscillator Switching                                    */
            __IOM uint8_t AUTODRVEN : 1; /*!< [7..7] Main Clock Oscillator Drive Capability Auto Switching
                                          *   Enable                                                                    */
        } MOMCR_b;
    };
    __IM uint16_t RESERVED43;

    union
    {
        __IOM uint8_t FWEPROR;         /*!< (@ 0x00000416) Flash P/E Protect Register                                 */

        struct
        {
            __IOM uint8_t FLWE : 2;    /*!< [1..0] Flash Programming and Erasure                                      */
            uint8_t            : 6;
        } FWEPROR_b;
    };

    union
    {
        union
        {
            __IOM uint8_t LVCMPCR;     /*!< (@ 0x00000417) Voltage Monitor Circuit Control Register                   */

            struct
            {
                uint8_t             : 5;
                __IOM uint8_t LVD1E : 1; /*!< [5..5] Voltage Detection 1 Enable                                         */
                __IOM uint8_t LVD2E : 1; /*!< [6..6] Voltage Detection 2 Enable                                         */
                uint8_t             : 1;
            } LVCMPCR_b;
        };

        union
        {
            __IOM uint8_t LVD1CMPCR;       /*!< (@ 0x00000417) Voltage Monitoring 1 Comparator Control Register           */

            struct
            {
                __IOM uint8_t LVD1LVL : 5; /*!< [4..0] Voltage Detection 1 Level Select (Standard voltage during
                                            *   drop in voltage)                                                          */
                uint8_t             : 2;
                __IOM uint8_t LVD1E : 1;   /*!< [7..7] Voltage Detection 1 Enable                                         */
            } LVD1CMPCR_b;
        };
    };

    union
    {
        union
        {
            __IOM uint8_t LVDLVLR;         /*!< (@ 0x00000418) Voltage Detection Level Select Register                    */

            struct
            {
                __IOM uint8_t LVD1LVL : 5; /*!< [4..0] Voltage Detection 1 Level Select (Standard voltage during
                                            *   fall in voltage)                                                          */
                __IOM uint8_t LVD2LVL : 3; /*!< [7..5] Voltage Detection 2 Level Select (Standard voltage during
                                            *   fall in voltage)                                                          */
            } LVDLVLR_b;
        };

        union
        {
            __IOM uint8_t LVD2CMPCR;       /*!< (@ 0x00000418) Voltage Monitoring 2 Comparator Control Register           */

            struct
            {
                __IOM uint8_t LVD2LVL : 3; /*!< [2..0] Voltage Detection 2 Level Select (Standard voltage during
                                            *   drop in voltage)                                                          */
                uint8_t             : 4;
                __IOM uint8_t LVD2E : 1;   /*!< [7..7] Voltage Detection 2 Enable                                         */
            } LVD2CMPCR_b;
        };
    };
    __IM uint8_t RESERVED44;

    union
    {
        __IOM uint8_t LVD1CR0;         /*!< (@ 0x0000041A) Voltage Monitor 1 Circuit Control Register 0               */

        struct
        {
            __IOM uint8_t RIE   : 1;   /*!< [0..0] Voltage Monitor Interrupt/Reset Enable                             */
            __IOM uint8_t DFDIS : 1;   /*!< [1..1] Voltage Monitor Digital Filter Disable Mode Select                 */
            __IOM uint8_t CMPE  : 1;   /*!< [2..2] Voltage Monitor Circuit Comparison Result Output Enable            */
            uint8_t             : 1;
            __IOM uint8_t FSAMP : 2;   /*!< [5..4] Sampling Clock Select                                              */
            __IOM uint8_t RI    : 1;   /*!< [6..6] Voltage Monitor Circuit Mode Select                                */
            __IOM uint8_t RN    : 1;   /*!< [7..7] Voltage Monitor Reset Negate Select                                */
        } LVD1CR0_b;
    };

    union
    {
        __IOM uint8_t LVD2CR0;         /*!< (@ 0x0000041B) Voltage Monitor 2 Circuit Control Register 0               */

        struct
        {
            __IOM uint8_t RIE   : 1;   /*!< [0..0] Voltage Monitor Interrupt/Reset Enable                             */
            __IOM uint8_t DFDIS : 1;   /*!< [1..1] Voltage Monitor Digital Filter Disable Mode Select                 */
            __IOM uint8_t CMPE  : 1;   /*!< [2..2] Voltage Monitor Circuit Comparison Result Output Enable            */
            uint8_t             : 1;
            __IOM uint8_t FSAMP : 2;   /*!< [5..4] Sampling Clock Select                                              */
            __IOM uint8_t RI    : 1;   /*!< [6..6] Voltage Monitor Circuit Mode Select                                */
            __IOM uint8_t RN    : 1;   /*!< [7..7] Voltage Monitor Reset Negate Select                                */
        } LVD2CR0_b;
    };
    __IM uint8_t RESERVED45;

    union
    {
        __IOM uint8_t VBATTMNSELR;        /*!< (@ 0x0000041D) Battery Backup Voltage Monitor Function Select
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t VBATTMNSEL : 1; /*!< [0..0] VBATT Low Voltage Detect Function Select Bit                       */
            uint8_t                  : 7;
        } VBATTMNSELR_b;
    };

    union
    {
        __IM uint8_t VBATTMONR;        /*!< (@ 0x0000041E) Battery Backup Voltage Monitor Register                    */

        struct
        {
            __IM uint8_t VBATTMON : 1; /*!< [0..0] VBATT Voltage Monitor Bit                                          */
            uint8_t               : 7;
        } VBATTMONR_b;
    };

    union
    {
        __IOM uint8_t VBTCR1;           /*!< (@ 0x0000041F) VBATT Control Register1                                    */

        struct
        {
            __IOM uint8_t BPWSWSTP : 1; /*!< [0..0] Battery Power supply Switch Stop                                   */
            uint8_t                : 7;
        } VBTCR1_b;
    };
    __IM uint32_t RESERVED46[8];

    union
    {
        union
        {
            __IOM uint8_t DCDCCTL;         /*!< (@ 0x00000440) DCDC/LDO Control Register                                  */

            struct
            {
                __IOM uint8_t DCDCON  : 1; /*!< [0..0] LDO/DCDC on/off Control bit                                        */
                __IOM uint8_t OCPEN   : 1; /*!< [1..1] DCDC OCP Function Enable bit                                       */
                uint8_t               : 2;
                __IOM uint8_t STOPZA  : 1; /*!< [4..4] DCDC IO Buffer Power Control bit                                   */
                __IOM uint8_t LCBOOST : 1; /*!< [5..5] LDO LCBOOST Mode Control bit                                       */
                __IOM uint8_t FST     : 1; /*!< [6..6] DCDC Fast Startup                                                  */
                __IOM uint8_t PD      : 1; /*!< [7..7] DCDC VREF Generate Disable bit                                     */
            } DCDCCTL_b;
        };

        union
        {
            __IOM uint8_t LDOSCR;          /*!< (@ 0x00000440) LDO Stop Control Register                                  */

            struct
            {
                __IOM uint8_t LDOSTP0 : 1; /*!< [0..0] LDO0 Stop                                                          */
                __IOM uint8_t LDOSTP1 : 1; /*!< [1..1] LDO1 Stop                                                          */
                uint8_t               : 6;
            } LDOSCR_b;
        };
    };

    union
    {
        __IOM uint8_t VCCSEL;          /*!< (@ 0x00000441) Voltage Level Selection Control Register                   */

        struct
        {
            __IOM uint8_t VCCSEL : 2;  /*!< [1..0] DCDC Working Voltage Level Selection                               */
            uint8_t              : 6;
        } VCCSEL_b;
    };
    __IM uint16_t RESERVED47;

    union
    {
        __IOM uint8_t PL2LDOSCR;         /*!< (@ 0x00000444) PLL2-LDO Stop Control Register                             */

        struct
        {
            __IOM uint8_t PL2LDOSTP : 1; /*!< [0..0] LDO0 Stop                                                          */
            uint8_t                 : 7;
        } PL2LDOSCR_b;
    };
    __IM uint8_t  RESERVED48;
    __IM uint16_t RESERVED49;
    __IM uint32_t RESERVED50[14];

    union
    {
        __IOM uint8_t SOSCCR;          /*!< (@ 0x00000480) Sub-Clock Oscillator Control Register                      */

        struct
        {
            __IOM uint8_t SOSTP : 1;   /*!< [0..0] Sub-Clock Oscillator Stop                                          */
            uint8_t             : 7;
        } SOSCCR_b;
    };

    union
    {
        __IOM uint8_t SOMCR;           /*!< (@ 0x00000481) Sub Clock Oscillator Mode Control Register                 */

        struct
        {
            __IOM uint8_t SODRV : 2;   /*!< [1..0] Sub-Clock Oscillator Drive Capability Switching                    */
            uint8_t             : 6;
        } SOMCR_b;
    };

    union
    {
        __IOM uint8_t SOMRG;           /*!< (@ 0x00000482) Sub Clock Oscillator Margin Check Register                 */

        struct
        {
            __IOM uint8_t SOSCMRG : 2; /*!< [1..0] Sub Clock Oscillator Margin check Switching                        */
            uint8_t               : 6;
        } SOMRG_b;
    };
    __IM uint8_t  RESERVED51;
    __IM uint32_t RESERVED52[3];

    union
    {
        __IOM uint8_t LOCOCR;          /*!< (@ 0x00000490) Low-Speed On-Chip Oscillator Control Register              */

        struct
        {
            __IOM uint8_t LCSTP : 1;   /*!< [0..0] LOCO Stop                                                          */
            uint8_t             : 7;
        } LOCOCR_b;
    };
    __IM uint8_t RESERVED53;

    union
    {
        __IOM uint8_t LOCOUTCR;         /*!< (@ 0x00000492) LOCO User Trimming Control Register                        */

        struct
        {
            __IOM uint8_t LOCOUTRM : 8; /*!< [7..0] LOCO User Trimming 1000_0000 : -128 1000_0001 : -127
                                         *   1000_0010 : -126 . . . 1111_1111 : -1 0000_0000 : Center
                                         *   Code 0000_0001 : +1 . . . 0111_1101 : +125 0111_1110 :
                                         +126 0111_1111 : +127These bits are added to original LOCO
                                         *   trimming bits                                                             */
        } LOCOUTCR_b;
    };
    __IM uint8_t  RESERVED54;
    __IM uint32_t RESERVED55[7];

    union
    {
        __IOM uint8_t VBTCR2;          /*!< (@ 0x000004B0) VBATT Control Register2                                    */

        struct
        {
            uint8_t                 : 4;
            __IOM uint8_t VBTLVDEN  : 1; /*!< [4..4] VBATT Pin Low Voltage Detect Enable Bit                            */
            uint8_t                 : 1;
            __IOM uint8_t VBTLVDLVL : 2; /*!< [7..6] VBATT Pin Voltage Low Voltage Detect Level Select Bit              */
        } VBTCR2_b;
    };

    union
    {
        __IOM uint8_t VBTSR;           /*!< (@ 0x000004B1) VBATT Status Register                                      */

        struct
        {
            __IOM uint8_t VBTRDF  : 1; /*!< [0..0] VBAT_R Reset Detect Flag                                           */
            __IOM uint8_t VBTBLDF : 1; /*!< [1..1] VBATT Battery Low voltage Detect Flag                              */
            uint8_t               : 2;
            __IM uint8_t VBTRVLD  : 1; /*!< [4..4] VBATT_R Valid                                                      */
            uint8_t               : 3;
        } VBTSR_b;
    };

    union
    {
        __IOM uint8_t VBTCMPCR;        /*!< (@ 0x000004B2) VBATT Comparator Control Register                          */

        struct
        {
            __IOM uint8_t VBTCMPE : 1; /*!< [0..0] VBATT pin low voltage detect circuit output enable                 */
            uint8_t               : 7;
        } VBTCMPCR_b;
    };
    __IM uint8_t RESERVED56;

    union
    {
        __IOM uint8_t VBTLVDICR;          /*!< (@ 0x000004B4) VBATT Pin Low Voltage Detect Interrupt Control
                                           *                  Register                                                   */

        struct
        {
            __IOM uint8_t VBTLVDIE   : 1; /*!< [0..0] VBATT Pin Low Voltage Detect Interrupt Enable bit                  */
            __IOM uint8_t VBTLVDISEL : 1; /*!< [1..1] Pin Low Voltage Detect Interrupt Select bit                        */
            uint8_t                  : 6;
        } VBTLVDICR_b;
    };
    __IM uint8_t RESERVED57;

    union
    {
        __IOM uint8_t VBTWCTLR;        /*!< (@ 0x000004B6) VBATT Wakeup function Control Register                     */

        struct
        {
            __IOM uint8_t VWEN : 1;    /*!< [0..0] VBATT wakeup enable                                                */
            uint8_t            : 7;
        } VBTWCTLR_b;
    };
    __IM uint8_t RESERVED58;

    union
    {
        __IOM uint8_t VBTWCH0OTSR;     /*!< (@ 0x000004B8) VBATT Wakeup I/O 0 Output Trigger Select Register          */

        struct
        {
            uint8_t                  : 1;
            __IOM uint8_t CH0VCH1TE  : 1; /*!< [1..1] VBATWIO0 Output VBATWIO1 Trigger Enable                            */
            __IOM uint8_t CH0VCH2TE  : 1; /*!< [2..2] VBATWIO0 Output VBATWIO2 Trigger Enable                            */
            __IOM uint8_t CH0VRTCTE  : 1; /*!< [3..3] VBATWIO0 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH0VRTCATE : 1; /*!< [4..4] VBATWIO0 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH0VAGTUTE : 1; /*!< [5..5] CH0 Output AGT(ch1) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH0OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTWCH1OTSR;        /*!< (@ 0x000004B9) VBATT Wakeup I/O 1 Output Trigger Select Register          */

        struct
        {
            __IOM uint8_t CH1VCH0TE  : 1; /*!< [0..0] VBATWIO1 Output VBATWIO0 Trigger Enable                            */
            uint8_t                  : 1;
            __IOM uint8_t CH1VCH2TE  : 1; /*!< [2..2] VBATWIO1 Output VBATWIO2 Trigger Enable                            */
            __IOM uint8_t CH1VRTCTE  : 1; /*!< [3..3] VBATWIO1 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH1VRTCATE : 1; /*!< [4..4] VBATWIO1 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH1VAGTUTE : 1; /*!< [5..5] CH1 Output AGT(ch1) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH1OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTWCH2OTSR;        /*!< (@ 0x000004BA) VBATT Wakeup I/O 2 Output Trigger Select Register          */

        struct
        {
            __IOM uint8_t CH2VCH0TE  : 1; /*!< [0..0] VBATWIO2 Output VBATWIO0 Trigger Enable                            */
            __IOM uint8_t CH2VCH1TE  : 1; /*!< [1..1] VBATWIO2 Output VBATWIO1 Trigger Enable                            */
            uint8_t                  : 1;
            __IOM uint8_t CH2VRTCTE  : 1; /*!< [3..3] VBATWIO2 Output RTC Periodic Signal Enable                         */
            __IOM uint8_t CH2VRTCATE : 1; /*!< [4..4] VBATWIO2 Output RTC Alarm Signal Enable                            */
            __IOM uint8_t CH2VAGTUTE : 1; /*!< [5..5] CH2 Output AGT(CH2) underflow Signal Enable                        */
            uint8_t                  : 2;
        } VBTWCH2OTSR_b;
    };

    union
    {
        __IOM uint8_t VBTICTLR;         /*!< (@ 0x000004BB) VBATT Input Control Register                               */

        struct
        {
            __IOM uint8_t VCH0INEN : 1; /*!< [0..0] RTCIC0 Input Enable                                                */
            __IOM uint8_t VCH1INEN : 1; /*!< [1..1] RTCIC1 Input Enable                                                */
            __IOM uint8_t VCH2INEN : 1; /*!< [2..2] RTCIC2 Input Enable                                                */
            uint8_t                : 5;
        } VBTICTLR_b;
    };

    union
    {
        __IOM uint8_t VBTOCTLR;          /*!< (@ 0x000004BC) VBATT Output Control Register                              */

        struct
        {
            __IOM uint8_t VCH0OEN   : 1; /*!< [0..0] VBATT Wakeup I/O 0 Output Enable                                   */
            __IOM uint8_t VCH1OEN   : 1; /*!< [1..1] VBATT Wakeup I/O 1 Output Enable                                   */
            __IOM uint8_t VCH2OEN   : 1; /*!< [2..2] VBATT Wakeup I/O 2 Output Enable                                   */
            __IOM uint8_t VOUT0LSEL : 1; /*!< [3..3] VBATT Wakeup I/O 0 Output Level Selection                          */
            __IOM uint8_t VCOU1LSEL : 1; /*!< [4..4] VBATT Wakeup I/O 1 Output Level Selection                          */
            __IOM uint8_t VOUT2LSEL : 1; /*!< [5..5] VBATT Wakeup I/O 2 Output Level Selection                          */
            uint8_t                 : 2;
        } VBTOCTLR_b;
    };

    union
    {
        __IOM uint8_t VBTWTER;         /*!< (@ 0x000004BD) VBATT Wakeup Trigger source Enable Register                */

        struct
        {
            __IOM uint8_t VCH0E  : 1;  /*!< [0..0] VBATWIO0 Pin Enable                                                */
            __IOM uint8_t VCH1E  : 1;  /*!< [1..1] VBATWIO1 Pin Enable                                                */
            __IOM uint8_t VCH2E  : 1;  /*!< [2..2] VBATWIO2 Pin Enable                                                */
            __IOM uint8_t VRTCIE : 1;  /*!< [3..3] RTC Periodic Signal Enable                                         */
            __IOM uint8_t VRTCAE : 1;  /*!< [4..4] RTC Alarm Signal Enable                                            */
            __IOM uint8_t VAGTUE : 1;  /*!< [5..5] AGT(ch1) underflow Signal Enable                                   */
            uint8_t              : 2;
        } VBTWTER_b;
    };

    union
    {
        __IOM uint8_t VBTWEGR;         /*!< (@ 0x000004BE) VBATT Wakeup Trigger source Edge Register                  */

        struct
        {
            __IOM uint8_t VCH0EG : 1;  /*!< [0..0] VBATWIO0 Wakeup Trigger Source Edge Select                         */
            __IOM uint8_t VCH1EG : 1;  /*!< [1..1] VBATWIO1 Wakeup Trigger Source Edge Select                         */
            __IOM uint8_t VCH2EG : 1;  /*!< [2..2] VBATWIO2 Wakeup Trigger Source Edge Select                         */
            uint8_t              : 5;
        } VBTWEGR_b;
    };

    union
    {
        __IOM uint8_t VBTWFR;          /*!< (@ 0x000004BF) VBATT Wakeup trigger source Flag Register                  */

        struct
        {
            __IOM uint8_t VCH0F  : 1;  /*!< [0..0] VBATWIO0 Wakeup Trigger Flag                                       */
            __IOM uint8_t VCH1F  : 1;  /*!< [1..1] VBATWIO1 Wakeup Trigger Flag                                       */
            __IOM uint8_t VCH2F  : 1;  /*!< [2..2] VBATWIO2 Wakeup Trigger Flag                                       */
            __IOM uint8_t VRTCIF : 1;  /*!< [3..3] VBATT RTC-Interval Wakeup Trigger Flag                             */
            __IOM uint8_t VRTCAF : 1;  /*!< [4..4] VBATT RTC-Alarm Wakeup Trigger Flag                                */
            __IOM uint8_t VAGTUF : 1;  /*!< [5..5] AGT(ch1) underflow VBATT Wakeup Trigger Flag                       */
            uint8_t              : 2;
        } VBTWFR_b;
    };

    union
    {
        __IOM uint8_t VBTBER;          /*!< (@ 0x000004C0) VBATT Backup Enable Register                               */

        struct
        {
            uint8_t            : 3;
            __IOM uint8_t VBAE : 1;    /*!< [3..3] VBATT backup register access enable bit                            */
            uint8_t            : 4;
        } VBTBER_b;
    };
    __IM uint8_t  RESERVED59;
    __IM uint16_t RESERVED60;
    __IM uint32_t RESERVED61[15];

    union
    {
        __IOM uint8_t VBTBKR[512];     /*!< (@ 0x00000500) VBATT Backup Register [0..511]                             */

        struct
        {
            __IOM uint8_t VBTBKR : 8;  /*!< [7..0] VBTBKR is a 512-byte readable/writable register to store
                                        *   data powered by VBATT.The value of this register is retained
                                        *   even when VCC is not powered but VBATT is powered.VBTBKR
                                        *   is initialized by VBATT selected voltage power-on-reset.                  */
        } VBTBKR_b[512];
    };
} R_SYSTEM_Type;                       /*!< Size = 1792 (0x700)                                                       */

/* =========================================================================================================================== */
/* ================                                          R_TRNG                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief True Random Number Generator (R_TRNG)
 */

typedef struct                         /*!< (@ 0x400D1000) R_TRNG Structure                                           */
{
    union
    {
        __IM uint8_t TRNGSDR;          /*!< (@ 0x00000000) TRNG SEED Data Register                                    */

        struct
        {
            __IM uint8_t SDATA : 8;    /*!< [7..0] When RDRDY bit is 1, these bits hold the generated SEED.
                                        *   When RDRDY bit is 0, these bits are read as 00h.The SEED
                                        *   is generated as 32-bit data. When TRNGSDR is read 4 times
                                        *   while RDRDY = 1, SEED reading is completed and RDRDY bit
                                        *   changes to 0                                                              */
        } TRNGSDR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint8_t TRNGSCR0;        /*!< (@ 0x00000002) TRNG SEED Command Register 0                               */

        struct
        {
            uint8_t               : 2;
            __OM uint8_t  SGSTART : 1; /*!< [2..2] SEED Generation Start                                              */
            __IOM uint8_t SGCEN   : 1; /*!< [3..3] SEED Generation Circuit Enable                                     */
            uint8_t               : 3;
            __IM uint8_t RDRDY    : 1; /*!< [7..7] When SEED geenration is completed, this bit changes to
                                        *   0                                                                         */
        } TRNGSCR0_b;
    };

    union
    {
        __IOM uint8_t TRNGSCR1;        /*!< (@ 0x00000003) TRNG SEED Command Register 1                               */

        struct
        {
            __IOM uint8_t INTEN : 1;   /*!< [0..0] TRNG Interrupt Enable                                              */
            uint8_t             : 7;
        } TRNGSCR1_b;
    };
} R_TRNG_Type;                         /*!< Size = 4 (0x4)                                                            */

/* =========================================================================================================================== */
/* ================                                           R_TSN                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Temperature Sensor (R_TSN)
 */

typedef struct                         /*!< (@ 0x407EC000) R_TSN Structure                                            */
{
    __IM uint16_t RESERVED[276];

    union
    {
        __IM uint16_t TSCDR;           /*!< (@ 0x00000228) Temperature Sensor Calibration Data Register               */

        struct
        {
            union
            {
                __IM uint8_t TSCDRL;         /*!< (@ 0x00000228) Temperature Sensor Calibration Data Register
                                              *                  L                                                          */

                struct
                {
                    __IM uint8_t TSCDRL : 8; /*!< [7..0] The calibration data stores the lower 8 bits of the convertedvalue. */
                } TSCDRL_b;
            };

            union
            {
                __IM uint8_t TSCDRH;         /*!< (@ 0x00000229) Temperature Sensor Calibration Data Register
                                              *                  H                                                          */

                struct
                {
                    __IM uint8_t TSCDRH : 8; /*!< [7..0] The calibration data stores the higher 8 bits of the
                                              *   convertedvalue.                                                           */
                } TSCDRH_b;
            };
        };
    };
} R_TSN_Type;                          /*!< Size = 554 (0x22a)                                                        */

/* =========================================================================================================================== */
/* ================                                           R_WDT                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief Watchdog Timer (R_WDT)
 */

typedef struct                         /*!< (@ 0x40044200) R_WDT Structure                                            */
{
    union
    {
        __IOM uint8_t WDTRR;           /*!< (@ 0x00000000) WDT Refresh Register                                       */

        struct
        {
            __IOM uint8_t WDTRR : 8;   /*!< [7..0] WDTRR is an 8-bit register that refreshes the down-counter
                                        *   of the WDT.                                                               */
        } WDTRR_b;
    };
    __IM uint8_t RESERVED;

    union
    {
        __IOM uint16_t WDTCR;          /*!< (@ 0x00000002) WDT Control Register                                       */

        struct
        {
            __IOM uint16_t TOPS : 2;   /*!< [1..0] Timeout Period Selection                                           */
            uint16_t            : 2;
            __IOM uint16_t CKS  : 4;   /*!< [7..4] Clock Division Ratio Selection                                     */
            __IOM uint16_t RPES : 2;   /*!< [9..8] Window End Position Selection                                      */
            uint16_t            : 2;
            __IOM uint16_t RPSS : 2;   /*!< [13..12] Window Start Position Selection                                  */
            uint16_t            : 2;
        } WDTCR_b;
    };

    union
    {
        __IOM uint16_t WDTSR;           /*!< (@ 0x00000004) WDT Status Register                                        */

        struct
        {
            __IM uint16_t  CNTVAL : 14; /*!< [13..0] Down-Counter Value                                                */
            __IOM uint16_t UNDFF  : 1;  /*!< [14..14] Underflow Flag                                                   */
            __IOM uint16_t REFEF  : 1;  /*!< [15..15] Refresh Error Flag                                               */
        } WDTSR_b;
    };

    union
    {
        __IOM uint8_t WDTRCR;          /*!< (@ 0x00000006) WDT Reset Control Register                                 */

        struct
        {
            uint8_t               : 7;
            __IOM uint8_t RSTIRQS : 1; /*!< [7..7] Reset Interrupt Request Selection                                  */
        } WDTRCR_b;
    };
    __IM uint8_t RESERVED1;

    union
    {
        __IOM uint8_t WDTCSTPR;        /*!< (@ 0x00000008) WDT Count Stop Control Register                            */

        struct
        {
            uint8_t              : 7;
            __IOM uint8_t SLCSTP : 1;  /*!< [7..7] Sleep-Mode Count Stop Control                                      */
        } WDTCSTPR_b;
    };
    __IM uint8_t  RESERVED2;
    __IM uint16_t RESERVED3;
} R_WDT_Type;                          /*!< Size = 12 (0xc)                                                           */

/* =========================================================================================================================== */
/* ================                                           R_AES                                           ================ */
/* =========================================================================================================================== */

/**
 * @brief AES Engine (R_AES)
 */

typedef struct                         /*!< (@ 0x400D0000) R_AES Structure                                            */
{
    union
    {
        __IOM uint16_t AESMOD;         /*!< (@ 0x00000000) AES Mode Register                                          */

        struct
        {
            __IOM uint16_t MODEN  : 1; /*!< [0..0] Read Request Enable                                                */
            uint16_t              : 7;
            __IOM uint16_t RDRQEN : 1; /*!< [8..8] Read Request Enable                                                */
            __IOM uint16_t WRRQEN : 1; /*!< [9..9] Write Request Enable                                               */
            uint16_t              : 6;
        } AESMOD_b;
    };
    __IM uint16_t RESERVED;

    union
    {
        __IOM uint32_t AESCMD;           /*!< (@ 0x00000004) AES Command Register                                       */

        struct
        {
            __IOM uint32_t INVCIP   : 1; /*!< [0..0] Select data encryption/decryption                                  */
            __IOM uint32_t KEYLN    : 1; /*!< [1..1] Select the Key Length                                              */
            uint32_t                : 2;
            __IOM uint32_t CHAIN    : 2; /*!< [5..4] Select the chaining mode                                           */
            uint32_t                : 2;
            __IOM uint32_t STORESEL : 2; /*!< [9..8] Read Request Enable                                                */
            uint32_t                : 2;
            __IOM uint32_t KEYSEL   : 1; /*!< [12..12] Select the Key Register                                          */
            uint32_t                : 11;
            __IM uint32_t DWRDY     : 1; /*!< [24..24] This bit indicates that AESDW is ready to write or
                                          *   is writing                                                                */
            __IM uint32_t DRRDY : 1;     /*!< [25..25] This bit indicates that AESDW is ready to read or is
                                          *   reading                                                                   */
            __IM uint32_t CWRDY : 1;     /*!< [26..26] This bit indicates that AESCMD is ready to write                 */
            __IM uint32_t IWRDY : 1;     /*!< [27..27] This bit indicates that AESIVW is ready to write or
                                          *   is writing                                                                */
            __IM uint32_t IRRDY : 1;     /*!< [28..28] This bit indicates that AESIVW is ready to read or
                                          *   is reading                                                                */
            __IM uint32_t KWRDY0 : 1;    /*!< [29..29] This bit indicates that AESKW0 is ready to write or
                                          *   is writing                                                                */
            __IM uint32_t KWRDY1 : 1;    /*!< [30..30] This bit indicates that AESKW1 is ready to write or
                                          *   is writing                                                                */
            __IM uint32_t ILOP : 1;      /*!< [31..31] This bit shows that the relation of Key Register 0
                                          *   and Key Register1 is not correct (for 256-bit key-length)                 */
        } AESCMD_b;
    };
    __IOM uint32_t AESDW;                /*!< (@ 0x00000008) AES Data Window Register                                   */
    __IOM uint32_t AESIVW;               /*!< (@ 0x0000000C) AES IV Window Register                                     */
    __IOM uint32_t AESKW0;               /*!< (@ 0x00000010) AES Key Window 0 Register                                  */
    __IOM uint32_t AESKW1;               /*!< (@ 0x00000014) AES Key Window 1 Register                                  */
} R_AES_Type;                            /*!< Size = 24 (0x18)                                                          */

/* =========================================================================================================================== */
/* ================                                          R_AGTX0                                          ================ */
/* =========================================================================================================================== */

/**
 * @brief Asynchronous General Purpose Timer (R_AGTX0)
 */

typedef struct                          /*!< (@ 0x40084000) R_AGTX0 Structure                                          */
{
    union
    {
        __IOM R_AGTX0_AGT32_Type AGT32; /*!< (@ 0x00000000) AGTW (32-bit) peripheral registers                         */
        __IOM R_AGTX0_AGT16_Type AGT16; /*!< (@ 0x00000000) AGT (16-bit) peripheral registers                          */
    };
} R_AGTX0_Type;                         /*!< Size = 20 (0x14)                                                          */

/** @} */ /* End of group Device_Peripheral_peripherals */

/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripheralAddr
 * @{
 */

 #define R_ACMPLP_BASE       0x40085E00UL
 #define R_ADC0_BASE         0x4005C000UL
 #define R_ADC1_BASE         0x4005C200UL
 #define R_BUS_BASE          0x40003000UL
 #define R_CAC_BASE          0x40044600UL
 #define R_CAN0_BASE         0x40050000UL
 #define R_CAN1_BASE         0x40051000UL
 #define R_CRC_BASE          0x40074000UL
 #define R_CTSU2_BASE        0x40082000UL
 #define R_DAC_BASE          0x4005E000UL
 #define R_DEBUG_BASE        0x4001B000UL
 #define R_DOC_BASE          0x40054100UL
 #define R_DTC_BASE          0x40005400UL
 #define R_ELC_BASE          0x40041000UL
 #define R_FACI_LP_BASE      0x407EC000UL
 #define R_CTSUTRIM_BASE     0x407EC000UL
 #define R_GPT0_BASE         0x40078000UL
 #define R_GPT1_BASE         0x40078100UL
 #define R_GPT2_BASE         0x40078200UL
 #define R_GPT3_BASE         0x40078300UL
 #define R_GPT4_BASE         0x40078400UL
 #define R_GPT5_BASE         0x40078500UL
 #define R_GPT6_BASE         0x40078600UL
 #define R_GPT7_BASE         0x40078700UL
 #define R_GPT8_BASE         0x40078800UL
 #define R_GPT9_BASE         0x40078900UL
 #define R_GPT10_BASE        0x40078A00UL
 #define R_GPT11_BASE        0x40078B00UL
 #define R_GPT12_BASE        0x40078C00UL
 #define R_GPT13_BASE        0x40078D00UL
 #define R_GPT_OPS_BASE      0x40078FF0UL
 #define R_GPT_POEG0_BASE    0x40042000UL
 #define R_GPT_POEG1_BASE    0x40042100UL
 #define R_GPT_POEG2_BASE    0x40042200UL
 #define R_GPT_POEG3_BASE    0x40042300UL
 #define R_ICU_BASE          0x40006000UL
 #define R_IIC0_BASE         0x40053000UL
 #define R_IIC1_BASE         0x40053100UL
 #define R_IIC2_BASE         0x40053200UL
 #define R_IWDT_BASE         0x40044400UL
 #define R_KINT_BASE         0x40080000UL
 #define R_MPU_MMPU_BASE     0x40000000UL
 #define R_MPU_SMPU_BASE     0x40000C00UL
 #define R_MPU_SPMON_BASE    0x40000D00UL
 #define R_MSTP_BASE         (0x40047000UL - 4UL) /* MSTPCRA is not located in R_MSTP so the base address must be moved so that MSTPCRB is located at 0x40047000. */
 #define R_PORT0_BASE        0x40040000UL
 #define R_PORT1_BASE        0x40040020UL
 #define R_PORT2_BASE        0x40040040UL
 #define R_PORT3_BASE        0x40040060UL
 #define R_PORT4_BASE        0x40040080UL
 #define R_PORT5_BASE        0x400400A0UL
 #define R_PORT6_BASE        0x400400C0UL
 #define R_PORT7_BASE        0x400400E0UL
 #define R_PORT8_BASE        0x40040100UL
 #define R_PORT9_BASE        0x40040120UL
 #define R_PORT10_BASE       0x40040140UL
 #define R_PORT11_BASE       0x40040160UL
 #define R_PORT12_BASE       0x40040180UL
 #define R_PORT13_BASE       0x400401A0UL
 #define R_PORT14_BASE       0x400401C0UL
 #define R_PFS_BASE          0x40040800UL
 #define R_PMISC_BASE        0x40040D00UL
 #define R_RTC_BASE          0x40044000UL
 #define R_SCI0_BASE         0x40070000UL
 #define R_SCI1_BASE         0x40070020UL
 #define R_SCI2_BASE         0x40070040UL
 #define R_SCI3_BASE         0x40070060UL
 #define R_SCI4_BASE         0x40070080UL
 #define R_SCI5_BASE         0x400700A0UL
 #define R_SCI6_BASE         0x400700C0UL
 #define R_SCI7_BASE         0x400700E0UL
 #define R_SCI8_BASE         0x40070100UL
 #define R_SCI9_BASE         0x40070120UL
 #define R_SPI0_BASE         0x40072000UL
 #define R_SPI1_BASE         0x40072100UL
 #define R_SRAM_BASE         0x40002000UL
 #define R_SYSTEM_BASE       0x4001E000UL
 #define R_TRNG_BASE         0x400D1000UL
 #define R_TSN_BASE          0x407EC000UL
 #define R_WDT_BASE          0x40044200UL
 #define R_AES_BASE          0x400D0000UL
 #define R_AGTX0_BASE        0x40084000UL
 #define R_AGTX1_BASE        0x40084100UL
 #define R_AGTX2_BASE        0x40084200UL
 #define R_AGTX3_BASE        0x40084300UL
 #define R_AGTX4_BASE        0x40084400UL
 #define R_AGTX5_BASE        0x40084500UL
 #define R_AGTX6_BASE        0x40084600UL
 #define R_AGTX7_BASE        0x40084700UL
 #define R_AGTX8_BASE        0x40084800UL
 #define R_AGTX9_BASE        0x40084900UL
 #define R_WDT1_BASE         0x40044300UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */

/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_declaration
 * @{
 */

 #define R_ACMPLP       ((R_ACMPLP_Type *) R_ACMPLP_BASE)
 #define R_ADC0         ((R_ADC0_Type *) R_ADC0_BASE)
 #define R_ADC1         ((R_ADC0_Type *) R_ADC1_BASE)
 #define R_BUS          ((R_BUS_Type *) R_BUS_BASE)
 #define R_CAC          ((R_CAC_Type *) R_CAC_BASE)
 #define R_CAN0         ((R_CAN0_Type *) R_CAN0_BASE)
 #define R_CAN1         ((R_CAN0_Type *) R_CAN1_BASE)
 #define R_CRC          ((R_CRC_Type *) R_CRC_BASE)
 #define R_CTSU         ((R_CTSU2_Type *) R_CTSU2_BASE)
 #define R_DAC          ((R_DAC_Type *) R_DAC_BASE)
 #define R_DEBUG        ((R_DEBUG_Type *) R_DEBUG_BASE)
 #define R_DOC          ((R_DOC_Type *) R_DOC_BASE)
 #define R_DTC          ((R_DTC_Type *) R_DTC_BASE)
 #define R_ELC          ((R_ELC_Type *) R_ELC_BASE)
 #define R_FACI_LP      ((R_FACI_LP_Type *) R_FACI_LP_BASE)
 #define R_CTSUTRIM     ((R_CTSUTRIM_Type *) R_CTSUTRIM_BASE)
 #define R_GPT0         ((R_GPT0_Type *) R_GPT0_BASE)
 #define R_GPT1         ((R_GPT0_Type *) R_GPT1_BASE)
 #define R_GPT2         ((R_GPT0_Type *) R_GPT2_BASE)
 #define R_GPT3         ((R_GPT0_Type *) R_GPT3_BASE)
 #define R_GPT4         ((R_GPT0_Type *) R_GPT4_BASE)
 #define R_GPT5         ((R_GPT0_Type *) R_GPT5_BASE)
 #define R_GPT6         ((R_GPT0_Type *) R_GPT6_BASE)
 #define R_GPT7         ((R_GPT0_Type *) R_GPT7_BASE)
 #define R_GPT8         ((R_GPT0_Type *) R_GPT8_BASE)
 #define R_GPT9         ((R_GPT0_Type *) R_GPT9_BASE)
 #define R_GPT10        ((R_GPT0_Type *) R_GPT10_BASE)
 #define R_GPT11        ((R_GPT0_Type *) R_GPT11_BASE)
 #define R_GPT12        ((R_GPT0_Type *) R_GPT12_BASE)
 #define R_GPT13        ((R_GPT0_Type *) R_GPT13_BASE)
 #define R_GPT_OPS      ((R_GPT_OPS_Type *) R_GPT_OPS_BASE)
 #define R_GPT_POEG0    ((R_GPT_POEG0_Type *) R_GPT_POEG0_BASE)
 #define R_GPT_POEG1    ((R_GPT_POEG0_Type *) R_GPT_POEG1_BASE)
 #define R_GPT_POEG2    ((R_GPT_POEG0_Type *) R_GPT_POEG2_BASE)
 #define R_GPT_POEG3    ((R_GPT_POEG0_Type *) R_GPT_POEG3_BASE)
 #define R_ICU          ((R_ICU_Type *) R_ICU_BASE)
 #define R_IIC0         ((R_IIC0_Type *) R_IIC0_BASE)
 #define R_IIC1         ((R_IIC0_Type *) R_IIC1_BASE)
 #define R_IIC2         ((R_IIC0_Type *) R_IIC2_BASE)
 #define R_IWDT         ((R_IWDT_Type *) R_IWDT_BASE)
 #define R_KINT         ((R_KINT_Type *) R_KINT_BASE)
 #define R_MPU_MMPU     ((R_MPU_MMPU_Type *) R_MPU_MMPU_BASE)
 #define R_MPU_SMPU     ((R_MPU_SMPU_Type *) R_MPU_SMPU_BASE)
 #define R_MPU_SPMON    ((R_MPU_SPMON_Type *) R_MPU_SPMON_BASE)
 #define R_MSTP         ((R_MSTP_Type *) R_MSTP_BASE)
 #define R_PORT0        ((R_PORT0_Type *) R_PORT0_BASE)
 #define R_PORT1        ((R_PORT0_Type *) R_PORT1_BASE)
 #define R_PORT2        ((R_PORT0_Type *) R_PORT2_BASE)
 #define R_PORT3        ((R_PORT0_Type *) R_PORT3_BASE)
 #define R_PORT4        ((R_PORT0_Type *) R_PORT4_BASE)
 #define R_PORT5        ((R_PORT0_Type *) R_PORT5_BASE)
 #define R_PORT6        ((R_PORT0_Type *) R_PORT6_BASE)
 #define R_PORT7        ((R_PORT0_Type *) R_PORT7_BASE)
 #define R_PORT8        ((R_PORT0_Type *) R_PORT8_BASE)
 #define R_PORT9        ((R_PORT0_Type *) R_PORT9_BASE)
 #define R_PORT10       ((R_PORT0_Type *) R_PORT10_BASE)
 #define R_PORT11       ((R_PORT0_Type *) R_PORT11_BASE)
 #define R_PORT12       ((R_PORT0_Type *) R_PORT12_BASE)
 #define R_PORT13       ((R_PORT0_Type *) R_PORT13_BASE)
 #define R_PORT14       ((R_PORT0_Type *) R_PORT14_BASE)
 #define R_PFS          ((R_PFS_Type *) R_PFS_BASE)
 #define R_PMISC        ((R_PMISC_Type *) R_PMISC_BASE)
 #define R_RTC          ((R_RTC_Type *) R_RTC_BASE)
 #define R_SCI0         ((R_SCI0_Type *) R_SCI0_BASE)
 #define R_SCI1         ((R_SCI0_Type *) R_SCI1_BASE)
 #define R_SCI2         ((R_SCI0_Type *) R_SCI2_BASE)
 #define R_SCI3         ((R_SCI0_Type *) R_SCI3_BASE)
 #define R_SCI4         ((R_SCI0_Type *) R_SCI4_BASE)
 #define R_SCI5         ((R_SCI0_Type *) R_SCI5_BASE)
 #define R_SCI6         ((R_SCI0_Type *) R_SCI6_BASE)
 #define R_SCI7         ((R_SCI0_Type *) R_SCI7_BASE)
 #define R_SCI8         ((R_SCI0_Type *) R_SCI8_BASE)
 #define R_SCI9         ((R_SCI0_Type *) R_SCI9_BASE)
 #define R_SPI0         ((R_SPI0_Type *) R_SPI0_BASE)
 #define R_SPI1         ((R_SPI0_Type *) R_SPI1_BASE)
 #define R_SRAM         ((R_SRAM_Type *) R_SRAM_BASE)
 #define R_SYSTEM       ((R_SYSTEM_Type *) R_SYSTEM_BASE)
 #define R_TRNG         ((R_TRNG_Type *) R_TRNG_BASE)
 #define R_TSN          ((R_TSN_Type *) R_TSN_BASE)
 #define R_WDT          ((R_WDT_Type *) R_WDT_BASE)
 #define R_AES          ((R_AES_Type *) R_AES_BASE)
 #define R_AGT0         ((R_AGTX0_Type *) R_AGTX0_BASE)
 #define R_AGT1         ((R_AGTX0_Type *) R_AGTX1_BASE)
 #define R_AGT2         ((R_AGTX0_Type *) R_AGTX2_BASE)
 #define R_AGT3         ((R_AGTX0_Type *) R_AGTX3_BASE)
 #define R_AGT4         ((R_AGTX0_Type *) R_AGTX4_BASE)
 #define R_AGT5         ((R_AGTX0_Type *) R_AGTX5_BASE)
 #define R_AGT6         ((R_AGTX0_Type *) R_AGTX6_BASE)
 #define R_AGT7         ((R_AGTX0_Type *) R_AGTX7_BASE)
 #define R_AGT8         ((R_AGTX0_Type *) R_AGTX8_BASE)
 #define R_AGT9         ((R_AGTX0_Type *) R_AGTX9_BASE)
 #define R_WDT1         ((R_WDT_Type *) R_WDT1_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */

/* =========================================  End of section using anonymous unions  ========================================= */
 #if defined(__CC_ARM)
  #pragma pop
 #elif defined(__ICCARM__)

/* leave anonymous unions enabled */
 #elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
 #elif defined(__GNUC__)

/* anonymous unions are enabled by default */
 #elif defined(__TMS470__)

/* anonymous unions are enabled by default */
 #elif defined(__TASKING__)
  #pragma warning restore
 #elif defined(__CSMC__)

/* anonymous unions are enabled by default */
 #endif

/* =========================================================================================================================== */
/* ================                                 Pos/Mask Cluster Section                                  ================ */
/* =========================================================================================================================== */

/** @addtogroup PosMask_clusters
 * @{
 */

/* =========================================================================================================================== */
/* ================                                            CSa                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  MOD  ========================================================== */
 #define R_BUS_CSa_MOD_PRMOD_Pos        (15UL)         /*!< PRMOD (Bit 15)                                        */
 #define R_BUS_CSa_MOD_PRMOD_Msk        (0x8000UL)     /*!< PRMOD (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_PWENB_Pos        (9UL)          /*!< PWENB (Bit 9)                                         */
 #define R_BUS_CSa_MOD_PWENB_Msk        (0x200UL)      /*!< PWENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_PRENB_Pos        (8UL)          /*!< PRENB (Bit 8)                                         */
 #define R_BUS_CSa_MOD_PRENB_Msk        (0x100UL)      /*!< PRENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_EWENB_Pos        (3UL)          /*!< EWENB (Bit 3)                                         */
 #define R_BUS_CSa_MOD_EWENB_Msk        (0x8UL)        /*!< EWENB (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSa_MOD_WRMOD_Pos        (0UL)          /*!< WRMOD (Bit 0)                                         */
 #define R_BUS_CSa_MOD_WRMOD_Msk        (0x1UL)        /*!< WRMOD (Bitfield-Mask: 0x01)                           */
/* =========================================================  WCR1  ========================================================== */
 #define R_BUS_CSa_WCR1_CSRWAIT_Pos     (24UL)         /*!< CSRWAIT (Bit 24)                                      */
 #define R_BUS_CSa_WCR1_CSRWAIT_Msk     (0x1f000000UL) /*!< CSRWAIT (Bitfield-Mask: 0x1f)                         */
 #define R_BUS_CSa_WCR1_CSWWAIT_Pos     (16UL)         /*!< CSWWAIT (Bit 16)                                      */
 #define R_BUS_CSa_WCR1_CSWWAIT_Msk     (0x1f0000UL)   /*!< CSWWAIT (Bitfield-Mask: 0x1f)                         */
 #define R_BUS_CSa_WCR1_CSPRWAIT_Pos    (8UL)          /*!< CSPRWAIT (Bit 8)                                      */
 #define R_BUS_CSa_WCR1_CSPRWAIT_Msk    (0x700UL)      /*!< CSPRWAIT (Bitfield-Mask: 0x07)                        */
 #define R_BUS_CSa_WCR1_CSPWWAIT_Pos    (0UL)          /*!< CSPWWAIT (Bit 0)                                      */
 #define R_BUS_CSa_WCR1_CSPWWAIT_Msk    (0x7UL)        /*!< CSPWWAIT (Bitfield-Mask: 0x07)                        */
/* =========================================================  WCR2  ========================================================== */
 #define R_BUS_CSa_WCR2_CSON_Pos        (28UL)         /*!< CSON (Bit 28)                                         */
 #define R_BUS_CSa_WCR2_CSON_Msk        (0x70000000UL) /*!< CSON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_WDON_Pos        (24UL)         /*!< WDON (Bit 24)                                         */
 #define R_BUS_CSa_WCR2_WDON_Msk        (0x7000000UL)  /*!< WDON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_WRON_Pos        (20UL)         /*!< WRON (Bit 20)                                         */
 #define R_BUS_CSa_WCR2_WRON_Msk        (0x700000UL)   /*!< WRON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_RDON_Pos        (16UL)         /*!< RDON (Bit 16)                                         */
 #define R_BUS_CSa_WCR2_RDON_Msk        (0x70000UL)    /*!< RDON (Bitfield-Mask: 0x07)                            */
 #define R_BUS_CSa_WCR2_AWAIT_Pos       (12UL)         /*!< AWAIT (Bit 12)                                        */
 #define R_BUS_CSa_WCR2_AWAIT_Msk       (0x3000UL)     /*!< AWAIT (Bitfield-Mask: 0x03)                           */
 #define R_BUS_CSa_WCR2_WDOFF_Pos       (8UL)          /*!< WDOFF (Bit 8)                                         */
 #define R_BUS_CSa_WCR2_WDOFF_Msk       (0x700UL)      /*!< WDOFF (Bitfield-Mask: 0x07)                           */
 #define R_BUS_CSa_WCR2_CSWOFF_Pos      (4UL)          /*!< CSWOFF (Bit 4)                                        */
 #define R_BUS_CSa_WCR2_CSWOFF_Msk      (0x70UL)       /*!< CSWOFF (Bitfield-Mask: 0x07)                          */
 #define R_BUS_CSa_WCR2_CSROFF_Pos      (0UL)          /*!< CSROFF (Bit 0)                                        */
 #define R_BUS_CSa_WCR2_CSROFF_Msk      (0x7UL)        /*!< CSROFF (Bitfield-Mask: 0x07)                          */

/* =========================================================================================================================== */
/* ================                                            CSb                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
 #define R_BUS_CSb_CR_MPXEN_Pos    (12UL)     /*!< MPXEN (Bit 12)                                        */
 #define R_BUS_CSb_CR_MPXEN_Msk    (0x1000UL) /*!< MPXEN (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSb_CR_EMODE_Pos    (8UL)      /*!< EMODE (Bit 8)                                         */
 #define R_BUS_CSb_CR_EMODE_Msk    (0x100UL)  /*!< EMODE (Bitfield-Mask: 0x01)                           */
 #define R_BUS_CSb_CR_BSIZE_Pos    (4UL)      /*!< BSIZE (Bit 4)                                         */
 #define R_BUS_CSb_CR_BSIZE_Msk    (0x30UL)   /*!< BSIZE (Bitfield-Mask: 0x03)                           */
 #define R_BUS_CSb_CR_EXENB_Pos    (0UL)      /*!< EXENB (Bit 0)                                         */
 #define R_BUS_CSb_CR_EXENB_Msk    (0x1UL)    /*!< EXENB (Bitfield-Mask: 0x01)                           */
/* ==========================================================  REC  ========================================================== */
 #define R_BUS_CSb_REC_WRCV_Pos    (8UL)      /*!< WRCV (Bit 8)                                          */
 #define R_BUS_CSb_REC_WRCV_Msk    (0xf00UL)  /*!< WRCV (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_CSb_REC_RRCV_Pos    (0UL)      /*!< RRCV (Bit 0)                                          */
 #define R_BUS_CSb_REC_RRCV_Msk    (0xfUL)    /*!< RRCV (Bitfield-Mask: 0x0f)                            */

/* =========================================================================================================================== */
/* ================                                           SDRAM                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  SDCCR  ========================================================= */
 #define R_BUS_SDRAM_SDCCR_BSIZE_Pos     (4UL)       /*!< BSIZE (Bit 4)                                         */
 #define R_BUS_SDRAM_SDCCR_BSIZE_Msk     (0x30UL)    /*!< BSIZE (Bitfield-Mask: 0x03)                           */
 #define R_BUS_SDRAM_SDCCR_EXENB_Pos     (0UL)       /*!< EXENB (Bit 0)                                         */
 #define R_BUS_SDRAM_SDCCR_EXENB_Msk     (0x1UL)     /*!< EXENB (Bitfield-Mask: 0x01)                           */
/* ========================================================  SDCMOD  ========================================================= */
 #define R_BUS_SDRAM_SDCMOD_EMODE_Pos    (0UL)       /*!< EMODE (Bit 0)                                         */
 #define R_BUS_SDRAM_SDCMOD_EMODE_Msk    (0x1UL)     /*!< EMODE (Bitfield-Mask: 0x01)                           */
/* ========================================================  SDAMOD  ========================================================= */
 #define R_BUS_SDRAM_SDAMOD_BE_Pos       (0UL)       /*!< BE (Bit 0)                                            */
 #define R_BUS_SDRAM_SDAMOD_BE_Msk       (0x1UL)     /*!< BE (Bitfield-Mask: 0x01)                              */
/* ========================================================  SDSELF  ========================================================= */
 #define R_BUS_SDRAM_SDSELF_SFEN_Pos     (0UL)       /*!< SFEN (Bit 0)                                          */
 #define R_BUS_SDRAM_SDSELF_SFEN_Msk     (0x1UL)     /*!< SFEN (Bitfield-Mask: 0x01)                            */
/* ========================================================  SDRFCR  ========================================================= */
 #define R_BUS_SDRAM_SDRFCR_REFW_Pos     (12UL)      /*!< REFW (Bit 12)                                         */
 #define R_BUS_SDRAM_SDRFCR_REFW_Msk     (0xf000UL)  /*!< REFW (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_SDRAM_SDRFCR_RFC_Pos      (0UL)       /*!< RFC (Bit 0)                                           */
 #define R_BUS_SDRAM_SDRFCR_RFC_Msk      (0xfffUL)   /*!< RFC (Bitfield-Mask: 0xfff)                            */
/* ========================================================  SDRFEN  ========================================================= */
 #define R_BUS_SDRAM_SDRFEN_RFEN_Pos     (0UL)       /*!< RFEN (Bit 0)                                          */
 #define R_BUS_SDRAM_SDRFEN_RFEN_Msk     (0x1UL)     /*!< RFEN (Bitfield-Mask: 0x01)                            */
/* =========================================================  SDICR  ========================================================= */
 #define R_BUS_SDRAM_SDICR_INIRQ_Pos     (0UL)       /*!< INIRQ (Bit 0)                                         */
 #define R_BUS_SDRAM_SDICR_INIRQ_Msk     (0x1UL)     /*!< INIRQ (Bitfield-Mask: 0x01)                           */
/* =========================================================  SDIR  ========================================================== */
 #define R_BUS_SDRAM_SDIR_PRC_Pos        (8UL)       /*!< PRC (Bit 8)                                           */
 #define R_BUS_SDRAM_SDIR_PRC_Msk        (0x700UL)   /*!< PRC (Bitfield-Mask: 0x07)                             */
 #define R_BUS_SDRAM_SDIR_ARFC_Pos       (4UL)       /*!< ARFC (Bit 4)                                          */
 #define R_BUS_SDRAM_SDIR_ARFC_Msk       (0xf0UL)    /*!< ARFC (Bitfield-Mask: 0x0f)                            */
 #define R_BUS_SDRAM_SDIR_ARFI_Pos       (0UL)       /*!< ARFI (Bit 0)                                          */
 #define R_BUS_SDRAM_SDIR_ARFI_Msk       (0xfUL)     /*!< ARFI (Bitfield-Mask: 0x0f)                            */
/* =========================================================  SDADR  ========================================================= */
 #define R_BUS_SDRAM_SDADR_MXC_Pos       (0UL)       /*!< MXC (Bit 0)                                           */
 #define R_BUS_SDRAM_SDADR_MXC_Msk       (0x3UL)     /*!< MXC (Bitfield-Mask: 0x03)                             */
/* =========================================================  SDTR  ========================================================== */
 #define R_BUS_SDRAM_SDTR_RAS_Pos        (16UL)      /*!< RAS (Bit 16)                                          */
 #define R_BUS_SDRAM_SDTR_RAS_Msk        (0x70000UL) /*!< RAS (Bitfield-Mask: 0x07)                             */
 #define R_BUS_SDRAM_SDTR_RCD_Pos        (12UL)      /*!< RCD (Bit 12)                                          */
 #define R_BUS_SDRAM_SDTR_RCD_Msk        (0x3000UL)  /*!< RCD (Bitfield-Mask: 0x03)                             */
 #define R_BUS_SDRAM_SDTR_RP_Pos         (9UL)       /*!< RP (Bit 9)                                            */
 #define R_BUS_SDRAM_SDTR_RP_Msk         (0xe00UL)   /*!< RP (Bitfield-Mask: 0x07)                              */
 #define R_BUS_SDRAM_SDTR_WR_Pos         (8UL)       /*!< WR (Bit 8)                                            */
 #define R_BUS_SDRAM_SDTR_WR_Msk         (0x100UL)   /*!< WR (Bitfield-Mask: 0x01)                              */
 #define R_BUS_SDRAM_SDTR_CL_Pos         (0UL)       /*!< CL (Bit 0)                                            */
 #define R_BUS_SDRAM_SDTR_CL_Msk         (0x7UL)     /*!< CL (Bitfield-Mask: 0x07)                              */
/* =========================================================  SDMOD  ========================================================= */
 #define R_BUS_SDRAM_SDMOD_MR_Pos        (0UL)       /*!< MR (Bit 0)                                            */
 #define R_BUS_SDRAM_SDMOD_MR_Msk        (0x7fffUL)  /*!< MR (Bitfield-Mask: 0x7fff)                            */
/* =========================================================  SDSR  ========================================================== */
 #define R_BUS_SDRAM_SDSR_SRFST_Pos      (4UL)       /*!< SRFST (Bit 4)                                         */
 #define R_BUS_SDRAM_SDSR_SRFST_Msk      (0x10UL)    /*!< SRFST (Bitfield-Mask: 0x01)                           */
 #define R_BUS_SDRAM_SDSR_INIST_Pos      (3UL)       /*!< INIST (Bit 3)                                         */
 #define R_BUS_SDRAM_SDSR_INIST_Msk      (0x8UL)     /*!< INIST (Bitfield-Mask: 0x01)                           */
 #define R_BUS_SDRAM_SDSR_MRSST_Pos      (0UL)       /*!< MRSST (Bit 0)                                         */
 #define R_BUS_SDRAM_SDSR_MRSST_Msk      (0x1UL)     /*!< MRSST (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                          BUSERRa                                          ================ */
/* =========================================================================================================================== */

/* ==========================================================  ADD  ========================================================== */
 #define R_BUS_BUSERRa_ADD_BERAD_Pos       (0UL)          /*!< BERAD (Bit 0)                                         */
 #define R_BUS_BUSERRa_ADD_BERAD_Msk       (0xffffffffUL) /*!< BERAD (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  STAT  ========================================================== */
 #define R_BUS_BUSERRa_STAT_ERRSTAT_Pos    (7UL)          /*!< ERRSTAT (Bit 7)                                       */
 #define R_BUS_BUSERRa_STAT_ERRSTAT_Msk    (0x80UL)       /*!< ERRSTAT (Bitfield-Mask: 0x01)                         */
 #define R_BUS_BUSERRa_STAT_ACCSTAT_Pos    (0UL)          /*!< ACCSTAT (Bit 0)                                       */
 #define R_BUS_BUSERRa_STAT_ACCSTAT_Msk    (0x1UL)        /*!< ACCSTAT (Bitfield-Mask: 0x01)                         */
/* ==========================================================  RW  =========================================================== */
 #define R_BUS_BUSERRa_RW_RWSTAT_Pos       (0UL)          /*!< RWSTAT (Bit 0)                                        */
 #define R_BUS_BUSERRa_RW_RWSTAT_Msk       (0x1UL)        /*!< RWSTAT (Bitfield-Mask: 0x01)                          */

/* =========================================================================================================================== */
/* ================                                          BTZFERR                                          ================ */
/* =========================================================================================================================== */

/* ==========================================================  ADD  ========================================================== */
 #define R_BUS_BTZFERR_ADD_BTZFERAD_Pos    (0UL)          /*!< BTZFERAD (Bit 0)                                      */
 #define R_BUS_BTZFERR_ADD_BTZFERAD_Msk    (0xffffffffUL) /*!< BTZFERAD (Bitfield-Mask: 0xffffffff)                  */
/* ==========================================================  RW  =========================================================== */
 #define R_BUS_BTZFERR_RW_TRWSTAT_Pos      (0UL)          /*!< TRWSTAT (Bit 0)                                       */
 #define R_BUS_BTZFERR_RW_TRWSTAT_Msk      (0x1UL)        /*!< TRWSTAT (Bitfield-Mask: 0x01)                         */

/* =========================================================================================================================== */
/* ================                                          BUSERRb                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  STAT  ========================================================== */
 #define R_BUS_BUSERRb_STAT_MSERRSTAT_Pos    (5UL)    /*!< MSERRSTAT (Bit 5)                                     */
 #define R_BUS_BUSERRb_STAT_MSERRSTAT_Msk    (0x20UL) /*!< MSERRSTAT (Bitfield-Mask: 0x01)                       */
 #define R_BUS_BUSERRb_STAT_ILERRSTAT_Pos    (4UL)    /*!< ILERRSTAT (Bit 4)                                     */
 #define R_BUS_BUSERRb_STAT_ILERRSTAT_Msk    (0x10UL) /*!< ILERRSTAT (Bitfield-Mask: 0x01)                       */
 #define R_BUS_BUSERRb_STAT_MMERRSTAT_Pos    (3UL)    /*!< MMERRSTAT (Bit 3)                                     */
 #define R_BUS_BUSERRb_STAT_MMERRSTAT_Msk    (0x8UL)  /*!< MMERRSTAT (Bitfield-Mask: 0x01)                       */
 #define R_BUS_BUSERRb_STAT_STERRSTAT_Pos    (1UL)    /*!< STERRSTAT (Bit 1)                                     */
 #define R_BUS_BUSERRb_STAT_STERRSTAT_Msk    (0x2UL)  /*!< STERRSTAT (Bitfield-Mask: 0x01)                       */
 #define R_BUS_BUSERRb_STAT_SLERRSTAT_Pos    (0UL)    /*!< SLERRSTAT (Bit 0)                                     */
 #define R_BUS_BUSERRb_STAT_SLERRSTAT_Msk    (0x1UL)  /*!< SLERRSTAT (Bitfield-Mask: 0x01)                       */
/* ==========================================================  CLR  ========================================================== */
 #define R_BUS_BUSERRb_CLR_MSERRCLR_Pos      (5UL)    /*!< MSERRCLR (Bit 5)                                      */
 #define R_BUS_BUSERRb_CLR_MSERRCLR_Msk      (0x20UL) /*!< MSERRCLR (Bitfield-Mask: 0x01)                        */
 #define R_BUS_BUSERRb_CLR_ILERRCLR_Pos      (4UL)    /*!< ILERRCLR (Bit 4)                                      */
 #define R_BUS_BUSERRb_CLR_ILERRCLR_Msk      (0x10UL) /*!< ILERRCLR (Bitfield-Mask: 0x01)                        */
 #define R_BUS_BUSERRb_CLR_MMERRCLR_Pos      (3UL)    /*!< MMERRCLR (Bit 3)                                      */
 #define R_BUS_BUSERRb_CLR_MMERRCLR_Msk      (0x8UL)  /*!< MMERRCLR (Bitfield-Mask: 0x01)                        */
 #define R_BUS_BUSERRb_CLR_STERRCLR_Pos      (1UL)    /*!< STERRCLR (Bit 1)                                      */
 #define R_BUS_BUSERRb_CLR_STERRCLR_Msk      (0x2UL)  /*!< STERRCLR (Bitfield-Mask: 0x01)                        */
 #define R_BUS_BUSERRb_CLR_SLERRCLR_Pos      (0UL)    /*!< SLERRCLR (Bit 0)                                      */
 #define R_BUS_BUSERRb_CLR_SLERRCLR_Msk      (0x1UL)  /*!< SLERRCLR (Bitfield-Mask: 0x01)                        */
/* =========================================================  IRQEN  ========================================================= */
 #define R_BUS_BUSERRb_IRQEN_EN_Pos          (0UL)    /*!< EN (Bit 0)                                            */
 #define R_BUS_BUSERRb_IRQEN_EN_Msk          (0x1UL)  /*!< EN (Bitfield-Mask: 0x01)                              */

/* =========================================================================================================================== */
/* ================                                        DMACDTCERR                                         ================ */
/* =========================================================================================================================== */

/* =========================================================  STAT  ========================================================== */
 #define R_BUS_DMACDTCERR_STAT_MTERRSTAT_Pos    (0UL)   /*!< MTERRSTAT (Bit 0)                                     */
 #define R_BUS_DMACDTCERR_STAT_MTERRSTAT_Msk    (0x1UL) /*!< MTERRSTAT (Bitfield-Mask: 0x01)                       */
/* ==========================================================  CLR  ========================================================== */
 #define R_BUS_DMACDTCERR_CLR_MTERRCLR_Pos      (0UL)   /*!< MTERRCLR (Bit 0)                                      */
 #define R_BUS_DMACDTCERR_CLR_MTERRCLR_Msk      (0x1UL) /*!< MTERRCLR (Bitfield-Mask: 0x01)                        */

/* =========================================================================================================================== */
/* ================                                         BUSSABT0                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  FLBI  ========================================================== */
 #define R_BUS_BUSSABT0_FLBI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_FLBI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* ========================================================  MRE0BI  ========================================================= */
 #define R_BUS_BUSSABT0_MRE0BI_ARBS_Pos       (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_MRE0BI_ARBS_Msk       (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  S0BI  ========================================================== */
 #define R_BUS_BUSSABT0_S0BI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_S0BI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  S1BI  ========================================================== */
 #define R_BUS_BUSSABT0_S1BI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_S1BI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  S2BI  ========================================================== */
 #define R_BUS_BUSSABT0_S2BI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_S2BI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  S3BI  ========================================================== */
 #define R_BUS_BUSSABT0_S3BI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_S3BI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* ========================================================  STBYSBI  ======================================================== */
 #define R_BUS_BUSSABT0_STBYSBI_ARBS_Pos      (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_STBYSBI_ARBS_Msk      (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  ECBI  ========================================================== */
 #define R_BUS_BUSSABT0_ECBI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_ECBI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  EOBI  ========================================================== */
 #define R_BUS_BUSSABT0_EOBI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_EOBI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* ========================================================  SPI0BI  ========================================================= */
 #define R_BUS_BUSSABT0_SPI0BI_ARBS_Pos       (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_SPI0BI_ARBS_Msk       (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* ========================================================  SPI1BI  ========================================================= */
 #define R_BUS_BUSSABT0_SPI1BI_ARBS_Pos       (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_SPI1BI_ARBS_Msk       (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  PBBI  ========================================================== */
 #define R_BUS_BUSSABT0_PBBI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_PBBI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  PABI  ========================================================== */
 #define R_BUS_BUSSABT0_PABI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_PABI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  PIBI  ========================================================== */
 #define R_BUS_BUSSABT0_PIBI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_PIBI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =========================================================  PSBI  ========================================================== */
 #define R_BUS_BUSSABT0_PSBI_ARBS_Pos         (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_PSBI_ARBS_Msk         (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =======================================================  CPU0SAHBI  ======================================================= */
 #define R_BUS_BUSSABT0_CPU0SAHBI_ARBS_Pos    (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT0_CPU0SAHBI_ARBS_Msk    (0x1UL) /*!< ARBS (Bitfield-Mask: 0x01)                            */

/* =========================================================================================================================== */
/* ================                                         BUSSABT1                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  FHBI  ========================================================== */
 #define R_BUS_BUSSABT1_FHBI_ARBS_Pos      (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT1_FHBI_ARBS_Msk      (0x3UL) /*!< ARBS (Bitfield-Mask: 0x03)                            */
/* ========================================================  MRC0BI  ========================================================= */
 #define R_BUS_BUSSABT1_MRC0BI_ARBS_Pos    (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT1_MRC0BI_ARBS_Msk    (0x3UL) /*!< ARBS (Bitfield-Mask: 0x03)                            */
/* =========================================================  S0BI  ========================================================== */
 #define R_BUS_BUSSABT1_S0BI_ARBS_Pos      (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT1_S0BI_ARBS_Msk      (0x3UL) /*!< ARBS (Bitfield-Mask: 0x03)                            */
/* =========================================================  S1BI  ========================================================== */
 #define R_BUS_BUSSABT1_S1BI_ARBS_Pos      (0UL)   /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSSABT1_S1BI_ARBS_Msk      (0x3UL) /*!< ARBS (Bitfield-Mask: 0x03)                            */

/* =========================================================================================================================== */
/* ================                                          BMSAERR                                          ================ */
/* =========================================================================================================================== */

/* ==========================================================  ADD  ========================================================== */
 #define R_BUS_BMSAERR_ADD_MSERAD_Pos      (0UL)          /*!< MSERAD (Bit 0)                                        */
 #define R_BUS_BMSAERR_ADD_MSERAD_Msk      (0xffffffffUL) /*!< MSERAD (Bitfield-Mask: 0xffffffff)                    */
/* ==========================================================  RW  =========================================================== */
 #define R_BUS_BMSAERR_RW_MSARWSTAT_Pos    (0UL)          /*!< MSARWSTAT (Bit 0)                                     */
 #define R_BUS_BMSAERR_RW_MSARWSTAT_Msk    (0x1UL)        /*!< MSARWSTAT (Bitfield-Mask: 0x01)                       */

/* =========================================================================================================================== */
/* ================                                            OAD                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  BUSOAD  ========================================================= */
 #define R_BUS_OAD_BUSOAD_BWERROAD_Pos     (2UL)      /*!< BWERROAD (Bit 2)                                      */
 #define R_BUS_OAD_BUSOAD_BWERROAD_Msk     (0x4UL)    /*!< BWERROAD (Bitfield-Mask: 0x01)                        */
 #define R_BUS_OAD_BUSOAD_SLERROAD_Pos     (1UL)      /*!< SLERROAD (Bit 1)                                      */
 #define R_BUS_OAD_BUSOAD_SLERROAD_Msk     (0x2UL)    /*!< SLERROAD (Bitfield-Mask: 0x01)                        */
 #define R_BUS_OAD_BUSOAD_ILERROAD_Pos     (0UL)      /*!< ILERROAD (Bit 0)                                      */
 #define R_BUS_OAD_BUSOAD_ILERROAD_Msk     (0x1UL)    /*!< ILERROAD (Bitfield-Mask: 0x01)                        */
/* =======================================================  BUSOADPT  ======================================================== */
 #define R_BUS_OAD_BUSOADPT_KEY_Pos        (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_BUS_OAD_BUSOADPT_KEY_Msk        (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_BUS_OAD_BUSOADPT_PROTECT_Pos    (0UL)      /*!< PROTECT (Bit 0)                                       */
 #define R_BUS_OAD_BUSOADPT_PROTECT_Msk    (0x1UL)    /*!< PROTECT (Bitfield-Mask: 0x01)                         */
/* ========================================================  MSAOAD  ========================================================= */
 #define R_BUS_OAD_MSAOAD_KEY_Pos          (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_BUS_OAD_MSAOAD_KEY_Msk          (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_BUS_OAD_MSAOAD_OAD_Pos          (0UL)      /*!< OAD (Bit 0)                                           */
 #define R_BUS_OAD_MSAOAD_OAD_Msk          (0x1UL)    /*!< OAD (Bitfield-Mask: 0x01)                             */
/* =========================================================  MSAPT  ========================================================= */
 #define R_BUS_OAD_MSAPT_KEY_Pos           (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_BUS_OAD_MSAPT_KEY_Msk           (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_BUS_OAD_MSAPT_PROTECT_Pos       (0UL)      /*!< PROTECT (Bit 0)                                       */
 #define R_BUS_OAD_MSAPT_PROTECT_Msk       (0x1UL)    /*!< PROTECT (Bitfield-Mask: 0x01)                         */

/* =========================================================================================================================== */
/* ================                                          MBWERR                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  STAT  ========================================================== */
 #define R_BUS_MBWERR_STAT_BWERR_Pos    (0UL)   /*!< BWERR (Bit 0)                                         */
 #define R_BUS_MBWERR_STAT_BWERR_Msk    (0x1UL) /*!< BWERR (Bitfield-Mask: 0x01)                           */
/* ==========================================================  CLR  ========================================================== */
 #define R_BUS_MBWERR_CLR_BWERR_Pos     (0UL)   /*!< BWERR (Bit 0)                                         */
 #define R_BUS_MBWERR_CLR_BWERR_Msk     (0x1UL) /*!< BWERR (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                           BUSM                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CNT  ========================================================== */
 #define R_BUS_BUSM_CNT_IERES_Pos    (15UL)     /*!< IERES (Bit 15)                                        */
 #define R_BUS_BUSM_CNT_IERES_Msk    (0x8000UL) /*!< IERES (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                           BUSS                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CNT  ========================================================== */
 #define R_BUS_BUSS_CNT_ARBMET_Pos    (4UL)    /*!< ARBMET (Bit 4)                                        */
 #define R_BUS_BUSS_CNT_ARBMET_Msk    (0x30UL) /*!< ARBMET (Bitfield-Mask: 0x03)                          */
 #define R_BUS_BUSS_CNT_ARBS_Pos      (0UL)    /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSS_CNT_ARBS_Msk      (0x3UL)  /*!< ARBS (Bitfield-Mask: 0x03)                            */

/* =========================================================================================================================== */
/* ================                                            MB                                             ================ */
/* =========================================================================================================================== */

/* ==========================================================  ID  =========================================================== */
 #define R_CAN0_MB_ID_IDE_Pos    (31UL)         /*!< IDE (Bit 31)                                          */
 #define R_CAN0_MB_ID_IDE_Msk    (0x80000000UL) /*!< IDE (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MB_ID_RTR_Pos    (30UL)         /*!< RTR (Bit 30)                                          */
 #define R_CAN0_MB_ID_RTR_Msk    (0x40000000UL) /*!< RTR (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MB_ID_SID_Pos    (18UL)         /*!< SID (Bit 18)                                          */
 #define R_CAN0_MB_ID_SID_Msk    (0x1ffc0000UL) /*!< SID (Bitfield-Mask: 0x7ff)                            */
 #define R_CAN0_MB_ID_EID_Pos    (0UL)          /*!< EID (Bit 0)                                           */
 #define R_CAN0_MB_ID_EID_Msk    (0x3ffffUL)    /*!< EID (Bitfield-Mask: 0x3ffff)                          */
/* ==========================================================  DL  =========================================================== */
 #define R_CAN0_MB_DL_DLC_Pos    (0UL)          /*!< DLC (Bit 0)                                           */
 #define R_CAN0_MB_DL_DLC_Msk    (0xfUL)        /*!< DLC (Bitfield-Mask: 0x0f)                             */
/* ===========================================================  D  =========================================================== */
 #define R_CAN0_MB_D_DATA_Pos    (0UL)          /*!< DATA (Bit 0)                                          */
 #define R_CAN0_MB_D_DATA_Msk    (0xffUL)       /*!< DATA (Bitfield-Mask: 0xff)                            */
/* ==========================================================  TS  =========================================================== */
 #define R_CAN0_MB_TS_TSH_Pos    (8UL)          /*!< TSH (Bit 8)                                           */
 #define R_CAN0_MB_TS_TSH_Msk    (0xff00UL)     /*!< TSH (Bitfield-Mask: 0xff)                             */
 #define R_CAN0_MB_TS_TSL_Pos    (0UL)          /*!< TSL (Bit 0)                                           */
 #define R_CAN0_MB_TS_TSL_Msk    (0xffUL)       /*!< TSL (Bitfield-Mask: 0xff)                             */

/* =========================================================================================================================== */
/* ================                                          ELSEGR                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  BY  =========================================================== */
 #define R_ELC_ELSEGR_BY_WI_Pos     (7UL)    /*!< WI (Bit 7)                                            */
 #define R_ELC_ELSEGR_BY_WI_Msk     (0x80UL) /*!< WI (Bitfield-Mask: 0x01)                              */
 #define R_ELC_ELSEGR_BY_WE_Pos     (6UL)    /*!< WE (Bit 6)                                            */
 #define R_ELC_ELSEGR_BY_WE_Msk     (0x40UL) /*!< WE (Bitfield-Mask: 0x01)                              */
 #define R_ELC_ELSEGR_BY_SEG_Pos    (0UL)    /*!< SEG (Bit 0)                                           */
 #define R_ELC_ELSEGR_BY_SEG_Msk    (0x1UL)  /*!< SEG (Bitfield-Mask: 0x01)                             */

/* =========================================================================================================================== */
/* ================                                           ELSR                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  HA  =========================================================== */
 #define R_ELC_ELSR_HA_ELS_Pos    (0UL)     /*!< ELS (Bit 0)                                           */
 #define R_ELC_ELSR_HA_ELS_Msk    (0x1ffUL) /*!< ELS (Bitfield-Mask: 0x1ff)                            */

/* =========================================================================================================================== */
/* ================                                            SAR                                            ================ */
/* =========================================================================================================================== */

/* ===========================================================  L  =========================================================== */
 #define R_IIC0_SAR_L_SVA_Pos     (0UL)    /*!< SVA (Bit 0)                                           */
 #define R_IIC0_SAR_L_SVA_Msk     (0xffUL) /*!< SVA (Bitfield-Mask: 0xff)                             */
/* ===========================================================  U  =========================================================== */
 #define R_IIC0_SAR_U_SVA9_Pos    (2UL)    /*!< SVA9 (Bit 2)                                          */
 #define R_IIC0_SAR_U_SVA9_Msk    (0x4UL)  /*!< SVA9 (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_SAR_U_SVA8_Pos    (1UL)    /*!< SVA8 (Bit 1)                                          */
 #define R_IIC0_SAR_U_SVA8_Msk    (0x2UL)  /*!< SVA8 (Bitfield-Mask: 0x01)                            */
 #define R_IIC0_SAR_U_FS_Pos      (0UL)    /*!< FS (Bit 0)                                            */
 #define R_IIC0_SAR_U_FS_Msk      (0x1UL)  /*!< FS (Bitfield-Mask: 0x01)                              */

/* =========================================================================================================================== */
/* ================                                          REGION                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  AC  =========================================================== */
 #define R_MPU_MMPU_MMPU_REGION_AC_WP_Pos        (2UL)          /*!< WP (Bit 2)                                            */
 #define R_MPU_MMPU_MMPU_REGION_AC_WP_Msk        (0x4UL)        /*!< WP (Bitfield-Mask: 0x01)                              */
 #define R_MPU_MMPU_MMPU_REGION_AC_RP_Pos        (1UL)          /*!< RP (Bit 1)                                            */
 #define R_MPU_MMPU_MMPU_REGION_AC_RP_Msk        (0x2UL)        /*!< RP (Bitfield-Mask: 0x01)                              */
 #define R_MPU_MMPU_MMPU_REGION_AC_ENABLE_Pos    (0UL)          /*!< ENABLE (Bit 0)                                        */
 #define R_MPU_MMPU_MMPU_REGION_AC_ENABLE_Msk    (0x1UL)        /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* ===========================================================  S  =========================================================== */
 #define R_MPU_MMPU_MMPU_REGION_S_MMPUS_Pos      (0UL)          /*!< MMPUS (Bit 0)                                         */
 #define R_MPU_MMPU_MMPU_REGION_S_MMPUS_Msk      (0xffffffffUL) /*!< MMPUS (Bitfield-Mask: 0xffffffff)                     */
/* ===========================================================  E  =========================================================== */
 #define R_MPU_MMPU_MMPU_REGION_E_MMPUE_Pos      (0UL)          /*!< MMPUE (Bit 0)                                         */
 #define R_MPU_MMPU_MMPU_REGION_E_MMPUE_Msk      (0xffffffffUL) /*!< MMPUE (Bitfield-Mask: 0xffffffff)                     */

/* =========================================================================================================================== */
/* ================                                           MMPU                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CTL  ========================================================== */
 #define R_MPU_MMPU_MMPU_CTL_KEY_Pos       (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_MPU_MMPU_MMPU_CTL_KEY_Msk       (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_MMPU_MMPU_CTL_OAD_Pos       (1UL)      /*!< OAD (Bit 1)                                           */
 #define R_MPU_MMPU_MMPU_CTL_OAD_Msk       (0x2UL)    /*!< OAD (Bitfield-Mask: 0x01)                             */
 #define R_MPU_MMPU_MMPU_CTL_ENABLE_Pos    (0UL)      /*!< ENABLE (Bit 0)                                        */
 #define R_MPU_MMPU_MMPU_CTL_ENABLE_Msk    (0x1UL)    /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* ==========================================================  PT  =========================================================== */
 #define R_MPU_MMPU_MMPU_PT_KEY_Pos        (8UL)      /*!< KEY (Bit 8)                                           */
 #define R_MPU_MMPU_MMPU_PT_KEY_Msk        (0xff00UL) /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_MMPU_MMPU_PT_PROTECT_Pos    (0UL)      /*!< PROTECT (Bit 0)                                       */
 #define R_MPU_MMPU_MMPU_PT_PROTECT_Msk    (0x1UL)    /*!< PROTECT (Bitfield-Mask: 0x01)                         */

/* =========================================================================================================================== */
/* ================                                           SMPU                                            ================ */
/* =========================================================================================================================== */

/* ===========================================================  R  =========================================================== */
 #define R_MPU_SMPU_SMPU_R_WPSRAMHS_Pos    (15UL)     /*!< WPSRAMHS (Bit 15)                                     */
 #define R_MPU_SMPU_SMPU_R_WPSRAMHS_Msk    (0x8000UL) /*!< WPSRAMHS (Bitfield-Mask: 0x01)                        */
 #define R_MPU_SMPU_SMPU_R_RPSRAMHS_Pos    (14UL)     /*!< RPSRAMHS (Bit 14)                                     */
 #define R_MPU_SMPU_SMPU_R_RPSRAMHS_Msk    (0x4000UL) /*!< RPSRAMHS (Bitfield-Mask: 0x01)                        */
 #define R_MPU_SMPU_SMPU_R_WPFLI_Pos       (13UL)     /*!< WPFLI (Bit 13)                                        */
 #define R_MPU_SMPU_SMPU_R_WPFLI_Msk       (0x2000UL) /*!< WPFLI (Bitfield-Mask: 0x01)                           */
 #define R_MPU_SMPU_SMPU_R_RPFLI_Pos       (12UL)     /*!< RPFLI (Bit 12)                                        */
 #define R_MPU_SMPU_SMPU_R_RPFLI_Msk       (0x1000UL) /*!< RPFLI (Bitfield-Mask: 0x01)                           */
 #define R_MPU_SMPU_SMPU_R_WPGRPC_Pos      (7UL)      /*!< WPGRPC (Bit 7)                                        */
 #define R_MPU_SMPU_SMPU_R_WPGRPC_Msk      (0x80UL)   /*!< WPGRPC (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_RPGRPC_Pos      (6UL)      /*!< RPGRPC (Bit 6)                                        */
 #define R_MPU_SMPU_SMPU_R_RPGRPC_Msk      (0x40UL)   /*!< RPGRPC (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_WPGRPB_Pos      (5UL)      /*!< WPGRPB (Bit 5)                                        */
 #define R_MPU_SMPU_SMPU_R_WPGRPB_Msk      (0x20UL)   /*!< WPGRPB (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_RPGRPB_Pos      (4UL)      /*!< RPGRPB (Bit 4)                                        */
 #define R_MPU_SMPU_SMPU_R_RPGRPB_Msk      (0x10UL)   /*!< RPGRPB (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_WPGRPA_Pos      (3UL)      /*!< WPGRPA (Bit 3)                                        */
 #define R_MPU_SMPU_SMPU_R_WPGRPA_Msk      (0x8UL)    /*!< WPGRPA (Bitfield-Mask: 0x01)                          */
 #define R_MPU_SMPU_SMPU_R_RPGRPA_Pos      (2UL)      /*!< RPGRPA (Bit 2)                                        */
 #define R_MPU_SMPU_SMPU_R_RPGRPA_Msk      (0x4UL)    /*!< RPGRPA (Bitfield-Mask: 0x01)                          */

/* =========================================================================================================================== */
/* ================                                            SP                                             ================ */
/* =========================================================================================================================== */

/* ==========================================================  OAD  ========================================================== */
 #define R_MPU_SPMON_SP_OAD_KEY_Pos        (8UL)          /*!< KEY (Bit 8)                                           */
 #define R_MPU_SPMON_SP_OAD_KEY_Msk        (0xff00UL)     /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_SPMON_SP_OAD_OAD_Pos        (0UL)          /*!< OAD (Bit 0)                                           */
 #define R_MPU_SPMON_SP_OAD_OAD_Msk        (0x1UL)        /*!< OAD (Bitfield-Mask: 0x01)                             */
/* ==========================================================  CTL  ========================================================== */
 #define R_MPU_SPMON_SP_CTL_ERROR_Pos      (8UL)          /*!< ERROR (Bit 8)                                         */
 #define R_MPU_SPMON_SP_CTL_ERROR_Msk      (0x100UL)      /*!< ERROR (Bitfield-Mask: 0x01)                           */
 #define R_MPU_SPMON_SP_CTL_ENABLE_Pos     (0UL)          /*!< ENABLE (Bit 0)                                        */
 #define R_MPU_SPMON_SP_CTL_ENABLE_Msk     (0x1UL)        /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* ==========================================================  PT  =========================================================== */
 #define R_MPU_SPMON_SP_PT_KEY_Pos         (8UL)          /*!< KEY (Bit 8)                                           */
 #define R_MPU_SPMON_SP_PT_KEY_Msk         (0xff00UL)     /*!< KEY (Bitfield-Mask: 0xff)                             */
 #define R_MPU_SPMON_SP_PT_PROTECT_Pos     (0UL)          /*!< PROTECT (Bit 0)                                       */
 #define R_MPU_SPMON_SP_PT_PROTECT_Msk     (0x1UL)        /*!< PROTECT (Bitfield-Mask: 0x01)                         */
/* ==========================================================  SA  =========================================================== */
 #define R_MPU_SPMON_SP_SA_MSPMPUSA_Pos    (0UL)          /*!< MSPMPUSA (Bit 0)                                      */
 #define R_MPU_SPMON_SP_SA_MSPMPUSA_Msk    (0xffffffffUL) /*!< MSPMPUSA (Bitfield-Mask: 0xffffffff)                  */
/* ==========================================================  EA  =========================================================== */
 #define R_MPU_SPMON_SP_EA_MSPMPUEA_Pos    (0UL)          /*!< MSPMPUEA (Bit 0)                                      */
 #define R_MPU_SPMON_SP_EA_MSPMPUEA_Msk    (0xffffffffUL) /*!< MSPMPUEA (Bitfield-Mask: 0xffffffff)                  */

/* =========================================================================================================================== */
/* ================                                            PIN                                            ================ */
/* =========================================================================================================================== */

/* =======================================================  PmnPFS_BY  ======================================================= */
 #define R_PFS_PORT_PIN_PmnPFS_BY_NCODR_Pos    (6UL)          /*!< NCODR (Bit 6)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_BY_NCODR_Msk    (0x40UL)       /*!< NCODR (Bitfield-Mask: 0x01)                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIM_Pos      (5UL)          /*!< PIM (Bit 5)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIM_Msk      (0x20UL)       /*!< PIM (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PCR_Pos      (4UL)          /*!< PCR (Bit 4)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PCR_Msk      (0x10UL)       /*!< PCR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PDR_Pos      (2UL)          /*!< PDR (Bit 2)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PDR_Msk      (0x4UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIDR_Pos     (1UL)          /*!< PIDR (Bit 1)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PIDR_Msk     (0x2UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PODR_Pos     (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_BY_PODR_Msk     (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
/* =======================================================  PmnPFS_HA  ======================================================= */
 #define R_PFS_PORT_PIN_PmnPFS_HA_NCODR_Pos    (6UL)          /*!< NCODR (Bit 6)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_NCODR_Msk    (0x40UL)       /*!< NCODR (Bitfield-Mask: 0x01)                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIM_Pos      (5UL)          /*!< PIM (Bit 5)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIM_Msk      (0x20UL)       /*!< PIM (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PCR_Pos      (4UL)          /*!< PCR (Bit 4)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PCR_Msk      (0x10UL)       /*!< PCR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PDR_Pos      (2UL)          /*!< PDR (Bit 2)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PDR_Msk      (0x4UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIDR_Pos     (1UL)          /*!< PIDR (Bit 1)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PIDR_Msk     (0x2UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PODR_Pos     (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_HA_PODR_Msk     (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ASEL_Pos     (15UL)         /*!< ASEL (Bit 15)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ASEL_Msk     (0x8000UL)     /*!< ASEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ISEL_Pos     (14UL)         /*!< ISEL (Bit 14)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_ISEL_Msk     (0x4000UL)     /*!< ISEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_EOFR_Pos     (12UL)         /*!< EOFR (Bit 12)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_EOFR_Msk     (0x3000UL)     /*!< EOFR (Bitfield-Mask: 0x03)                            */
 #define R_PFS_PORT_PIN_PmnPFS_HA_DSCR_Pos     (10UL)         /*!< DSCR (Bit 10)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_HA_DSCR_Msk     (0xc00UL)      /*!< DSCR (Bitfield-Mask: 0x03)                            */
/* ========================================================  PmnPFS  ========================================================= */
 #define R_PFS_PORT_PIN_PmnPFS_NCODR_Pos       (6UL)          /*!< NCODR (Bit 6)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_NCODR_Msk       (0x40UL)       /*!< NCODR (Bitfield-Mask: 0x01)                           */
 #define R_PFS_PORT_PIN_PmnPFS_PIM_Pos         (5UL)          /*!< PIM (Bit 5)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_PIM_Msk         (0x20UL)       /*!< PIM (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_PCR_Pos         (4UL)          /*!< PCR (Bit 4)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_PCR_Msk         (0x10UL)       /*!< PCR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_PDR_Pos         (2UL)          /*!< PDR (Bit 2)                                           */
 #define R_PFS_PORT_PIN_PmnPFS_PDR_Msk         (0x4UL)        /*!< PDR (Bitfield-Mask: 0x01)                             */
 #define R_PFS_PORT_PIN_PmnPFS_PIDR_Pos        (1UL)          /*!< PIDR (Bit 1)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_PIDR_Msk        (0x2UL)        /*!< PIDR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_PODR_Pos        (0UL)          /*!< PODR (Bit 0)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_PODR_Msk        (0x1UL)        /*!< PODR (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_ASEL_Pos        (15UL)         /*!< ASEL (Bit 15)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_ASEL_Msk        (0x8000UL)     /*!< ASEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_ISEL_Pos        (14UL)         /*!< ISEL (Bit 14)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_ISEL_Msk        (0x4000UL)     /*!< ISEL (Bitfield-Mask: 0x01)                            */
 #define R_PFS_PORT_PIN_PmnPFS_EOFR_Pos        (12UL)         /*!< EOFR (Bit 12)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_EOFR_Msk        (0x3000UL)     /*!< EOFR (Bitfield-Mask: 0x03)                            */
 #define R_PFS_PORT_PIN_PmnPFS_DSCR_Pos        (10UL)         /*!< DSCR (Bit 10)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_DSCR_Msk        (0xc00UL)      /*!< DSCR (Bitfield-Mask: 0x03)                            */
 #define R_PFS_PORT_PIN_PmnPFS_PSEL_Pos        (24UL)         /*!< PSEL (Bit 24)                                         */
 #define R_PFS_PORT_PIN_PmnPFS_PSEL_Msk        (0x1f000000UL) /*!< PSEL (Bitfield-Mask: 0x1f)                            */
 #define R_PFS_PORT_PIN_PmnPFS_PMR_Pos         (16UL)         /*!< PMR (Bit 16)                                          */
 #define R_PFS_PORT_PIN_PmnPFS_PMR_Msk         (0x10000UL)    /*!< PMR (Bitfield-Mask: 0x01)                             */

/* =========================================================================================================================== */
/* ================                                           PORT                                            ================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================                                           VLSEL                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  VL1SEL  ========================================================= */
 #define R_PFS_VLSEL_VL1SEL_SELVL_Pos    (0UL)   /*!< SELVL (Bit 0)                                         */
 #define R_PFS_VLSEL_VL1SEL_SELVL_Msk    (0x1UL) /*!< SELVL (Bitfield-Mask: 0x01)                           */

/* =========================================================================================================================== */
/* ================                                           PMSAR                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  PMSAR  ========================================================= */

/* =========================================================================================================================== */
/* ================                                           RTCCR                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  RTCCR  ========================================================= */
 #define R_RTC_RTCCR_RTCCR_TCEN_Pos    (7UL)    /*!< TCEN (Bit 7)                                          */
 #define R_RTC_RTCCR_RTCCR_TCEN_Msk    (0x80UL) /*!< TCEN (Bitfield-Mask: 0x01)                            */
 #define R_RTC_RTCCR_RTCCR_TCNF_Pos    (4UL)    /*!< TCNF (Bit 4)                                          */
 #define R_RTC_RTCCR_RTCCR_TCNF_Msk    (0x30UL) /*!< TCNF (Bitfield-Mask: 0x03)                            */
 #define R_RTC_RTCCR_RTCCR_TCST_Pos    (2UL)    /*!< TCST (Bit 2)                                          */
 #define R_RTC_RTCCR_RTCCR_TCST_Msk    (0x4UL)  /*!< TCST (Bitfield-Mask: 0x01)                            */
 #define R_RTC_RTCCR_RTCCR_TCCT_Pos    (0UL)    /*!< TCCT (Bit 0)                                          */
 #define R_RTC_RTCCR_RTCCR_TCCT_Msk    (0x3UL)  /*!< TCCT (Bitfield-Mask: 0x03)                            */

/* =========================================================================================================================== */
/* ================                                            CP                                             ================ */
/* =========================================================================================================================== */

/* =========================================================  RSEC  ========================================================== */
 #define R_RTC_CP_RSEC_SEC10_Pos       (4UL)    /*!< SEC10 (Bit 4)                                         */
 #define R_RTC_CP_RSEC_SEC10_Msk       (0x70UL) /*!< SEC10 (Bitfield-Mask: 0x07)                           */
 #define R_RTC_CP_RSEC_SEC1_Pos        (0UL)    /*!< SEC1 (Bit 0)                                          */
 #define R_RTC_CP_RSEC_SEC1_Msk        (0xfUL)  /*!< SEC1 (Bitfield-Mask: 0x0f)                            */
/* =========================================================  BCNT0  ========================================================= */
 #define R_RTC_CP_BCNT0_BCNT0CP_Pos    (0UL)    /*!< BCNT0CP (Bit 0)                                       */
 #define R_RTC_CP_BCNT0_BCNT0CP_Msk    (0xffUL) /*!< BCNT0CP (Bitfield-Mask: 0xff)                         */
/* =========================================================  RMIN  ========================================================== */
 #define R_RTC_CP_RMIN_MIN10_Pos       (4UL)    /*!< MIN10 (Bit 4)                                         */
 #define R_RTC_CP_RMIN_MIN10_Msk       (0x70UL) /*!< MIN10 (Bitfield-Mask: 0x07)                           */
 #define R_RTC_CP_RMIN_MIN1_Pos        (0UL)    /*!< MIN1 (Bit 0)                                          */
 #define R_RTC_CP_RMIN_MIN1_Msk        (0xfUL)  /*!< MIN1 (Bitfield-Mask: 0x0f)                            */
/* =========================================================  BCNT1  ========================================================= */
 #define R_RTC_CP_BCNT1_BCNT1CP_Pos    (0UL)    /*!< BCNT1CP (Bit 0)                                       */
 #define R_RTC_CP_BCNT1_BCNT1CP_Msk    (0xffUL) /*!< BCNT1CP (Bitfield-Mask: 0xff)                         */
/* ==========================================================  RHR  ========================================================== */
 #define R_RTC_CP_RHR_PM_Pos           (6UL)    /*!< PM (Bit 6)                                            */
 #define R_RTC_CP_RHR_PM_Msk           (0x40UL) /*!< PM (Bitfield-Mask: 0x01)                              */
 #define R_RTC_CP_RHR_HR10_Pos         (4UL)    /*!< HR10 (Bit 4)                                          */
 #define R_RTC_CP_RHR_HR10_Msk         (0x30UL) /*!< HR10 (Bitfield-Mask: 0x03)                            */
 #define R_RTC_CP_RHR_HR1_Pos          (0UL)    /*!< HR1 (Bit 0)                                           */
 #define R_RTC_CP_RHR_HR1_Msk          (0xfUL)  /*!< HR1 (Bitfield-Mask: 0x0f)                             */
/* =========================================================  BCNT2  ========================================================= */
 #define R_RTC_CP_BCNT2_BCNT2CP_Pos    (0UL)    /*!< BCNT2CP (Bit 0)                                       */
 #define R_RTC_CP_BCNT2_BCNT2CP_Msk    (0xffUL) /*!< BCNT2CP (Bitfield-Mask: 0xff)                         */
/* =========================================================  RDAY  ========================================================== */
 #define R_RTC_CP_RDAY_DATE10_Pos      (4UL)    /*!< DATE10 (Bit 4)                                        */
 #define R_RTC_CP_RDAY_DATE10_Msk      (0x30UL) /*!< DATE10 (Bitfield-Mask: 0x03)                          */
 #define R_RTC_CP_RDAY_DATE1_Pos       (0UL)    /*!< DATE1 (Bit 0)                                         */
 #define R_RTC_CP_RDAY_DATE1_Msk       (0xfUL)  /*!< DATE1 (Bitfield-Mask: 0x0f)                           */
/* =========================================================  BCNT3  ========================================================= */
 #define R_RTC_CP_BCNT3_BCNT3CP_Pos    (0UL)    /*!< BCNT3CP (Bit 0)                                       */
 #define R_RTC_CP_BCNT3_BCNT3CP_Msk    (0xffUL) /*!< BCNT3CP (Bitfield-Mask: 0xff)                         */
/* =========================================================  RMON  ========================================================== */
 #define R_RTC_CP_RMON_MON10_Pos       (4UL)    /*!< MON10 (Bit 4)                                         */
 #define R_RTC_CP_RMON_MON10_Msk       (0x10UL) /*!< MON10 (Bitfield-Mask: 0x01)                           */
 #define R_RTC_CP_RMON_MON1_Pos        (0UL)    /*!< MON1 (Bit 0)                                          */
 #define R_RTC_CP_RMON_MON1_Msk        (0xfUL)  /*!< MON1 (Bitfield-Mask: 0x0f)                            */

/* =========================================================================================================================== */
/* ================                                           CTRL                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  AGTCR  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMBF_Pos          (7UL)    /*!< TCMBF (Bit 7)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMBF_Msk          (0x80UL) /*!< TCMBF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMAF_Pos          (6UL)    /*!< TCMAF (Bit 6)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCMAF_Msk          (0x40UL) /*!< TCMAF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TUNDF_Pos          (5UL)    /*!< TUNDF (Bit 5)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TUNDF_Msk          (0x20UL) /*!< TUNDF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TEDGF_Pos          (4UL)    /*!< TEDGF (Bit 4)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TEDGF_Msk          (0x10UL) /*!< TEDGF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTOP_Pos          (2UL)    /*!< TSTOP (Bit 2)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTOP_Msk          (0x4UL)  /*!< TSTOP (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCSTF_Pos          (1UL)    /*!< TCSTF (Bit 1)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TCSTF_Msk          (0x2UL)  /*!< TCSTF (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTART_Pos         (0UL)    /*!< TSTART (Bit 0)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTCR_TSTART_Msk         (0x1UL)  /*!< TSTART (Bitfield-Mask: 0x01)                          */
/* ========================================================  AGTMR1  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TCK_Pos           (4UL)    /*!< TCK (Bit 4)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TCK_Msk           (0x70UL) /*!< TCK (Bitfield-Mask: 0x07)                             */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TEDGPL_Pos        (3UL)    /*!< TEDGPL (Bit 3)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TEDGPL_Msk        (0x8UL)  /*!< TEDGPL (Bitfield-Mask: 0x01)                          */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TMOD_Pos          (0UL)    /*!< TMOD (Bit 0)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTMR1_TMOD_Msk          (0x7UL)  /*!< TMOD (Bitfield-Mask: 0x07)                            */
/* ========================================================  AGTMR2  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_LPM_Pos           (7UL)    /*!< LPM (Bit 7)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_LPM_Msk           (0x80UL) /*!< LPM (Bitfield-Mask: 0x01)                             */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_CKS_Pos           (0UL)    /*!< CKS (Bit 0)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTMR2_CKS_Msk           (0x7UL)  /*!< CKS (Bitfield-Mask: 0x07)                             */
/* =====================================================  AGTIOSEL_ALT  ====================================================== */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_TIES_Pos    (4UL)    /*!< TIES (Bit 4)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_TIES_Msk    (0x10UL) /*!< TIES (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_SEL_Pos     (0UL)    /*!< SEL (Bit 0)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_ALT_SEL_Msk     (0x3UL)  /*!< SEL (Bitfield-Mask: 0x03)                             */
/* ========================================================  AGTIOC  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIOGT_Pos         (6UL)    /*!< TIOGT (Bit 6)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIOGT_Msk         (0xc0UL) /*!< TIOGT (Bitfield-Mask: 0x03)                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIPF_Pos          (4UL)    /*!< TIPF (Bit 4)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TIPF_Msk          (0x30UL) /*!< TIPF (Bitfield-Mask: 0x03)                            */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TOE_Pos           (2UL)    /*!< TOE (Bit 2)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TOE_Msk           (0x4UL)  /*!< TOE (Bitfield-Mask: 0x01)                             */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TEDGSEL_Pos       (0UL)    /*!< TEDGSEL (Bit 0)                                       */
 #define R_AGTX0_AGT16_CTRL_AGTIOC_TEDGSEL_Msk       (0x1UL)  /*!< TEDGSEL (Bitfield-Mask: 0x01)                         */
/* ========================================================  AGTISR  ========================================================= */
 #define R_AGTX0_AGT16_CTRL_AGTISR_EEPS_Pos          (2UL)    /*!< EEPS (Bit 2)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTISR_EEPS_Msk          (0x4UL)  /*!< EEPS (Bitfield-Mask: 0x01)                            */
/* ========================================================  AGTCMSR  ======================================================== */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLB_Pos       (6UL)    /*!< TOPOLB (Bit 6)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLB_Msk       (0x40UL) /*!< TOPOLB (Bitfield-Mask: 0x01)                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEB_Pos         (5UL)    /*!< TOEB (Bit 5)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEB_Msk         (0x20UL) /*!< TOEB (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEB_Pos        (4UL)    /*!< TCMEB (Bit 4)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEB_Msk        (0x10UL) /*!< TCMEB (Bitfield-Mask: 0x01)                           */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLA_Pos       (2UL)    /*!< TOPOLA (Bit 2)                                        */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOPOLA_Msk       (0x4UL)  /*!< TOPOLA (Bitfield-Mask: 0x01)                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEA_Pos         (1UL)    /*!< TOEA (Bit 1)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TOEA_Msk         (0x2UL)  /*!< TOEA (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEA_Pos        (0UL)    /*!< TCMEA (Bit 0)                                         */
 #define R_AGTX0_AGT16_CTRL_AGTCMSR_TCMEA_Msk        (0x1UL)  /*!< TCMEA (Bitfield-Mask: 0x01)                           */
/* =======================================================  AGTIOSEL  ======================================================== */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_TIES_Pos        (4UL)    /*!< TIES (Bit 4)                                          */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_TIES_Msk        (0x10UL) /*!< TIES (Bitfield-Mask: 0x01)                            */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_SEL_Pos         (0UL)    /*!< SEL (Bit 0)                                           */
 #define R_AGTX0_AGT16_CTRL_AGTIOSEL_SEL_Msk         (0x3UL)  /*!< SEL (Bitfield-Mask: 0x03)                             */

/* =========================================================================================================================== */
/* ================                                           AGT16                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  AGT  ========================================================== */
 #define R_AGTX0_AGT16_AGT_AGT_Pos          (0UL)      /*!< AGT (Bit 0)                                           */
 #define R_AGTX0_AGT16_AGT_AGT_Msk          (0xffffUL) /*!< AGT (Bitfield-Mask: 0xffff)                           */
/* ========================================================  AGTCMA  ========================================================= */
 #define R_AGTX0_AGT16_AGTCMA_AGTCMA_Pos    (0UL)      /*!< AGTCMA (Bit 0)                                        */
 #define R_AGTX0_AGT16_AGTCMA_AGTCMA_Msk    (0xffffUL) /*!< AGTCMA (Bitfield-Mask: 0xffff)                        */
/* ========================================================  AGTCMB  ========================================================= */
 #define R_AGTX0_AGT16_AGTCMB_AGTCMB_Pos    (0UL)      /*!< AGTCMB (Bit 0)                                        */
 #define R_AGTX0_AGT16_AGTCMB_AGTCMB_Msk    (0xffffUL) /*!< AGTCMB (Bitfield-Mask: 0xffff)                        */

/* =========================================================================================================================== */
/* ================                                           AGT32                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  AGT  ========================================================== */
 #define R_AGTX0_AGT32_AGT_AGT_Pos          (0UL)          /*!< AGT (Bit 0)                                           */
 #define R_AGTX0_AGT32_AGT_AGT_Msk          (0xffffffffUL) /*!< AGT (Bitfield-Mask: 0xffffffff)                       */
/* ========================================================  AGTCMA  ========================================================= */
 #define R_AGTX0_AGT32_AGTCMA_AGTCMA_Pos    (0UL)          /*!< AGTCMA (Bit 0)                                        */
 #define R_AGTX0_AGT32_AGTCMA_AGTCMA_Msk    (0xffffffffUL) /*!< AGTCMA (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  AGTCMB  ========================================================= */
 #define R_AGTX0_AGT32_AGTCMB_AGTCMB_Pos    (0UL)          /*!< AGTCMB (Bit 0)                                        */
 #define R_AGTX0_AGT32_AGTCMB_AGTCMB_Msk    (0xffffffffUL) /*!< AGTCMB (Bitfield-Mask: 0xffffffff)                    */

/** @} */ /* End of group PosMask_clusters */

/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */

/** @addtogroup PosMask_peripherals
 * @{
 */

/* =========================================================================================================================== */
/* ================                                         R_ACMPLP                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  COMPMDR  ======================================================== */
 #define R_ACMPLP_COMPMDR_C1MON_Pos      (7UL)    /*!< C1MON (Bit 7)                                         */
 #define R_ACMPLP_COMPMDR_C1MON_Msk      (0x80UL) /*!< C1MON (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPMDR_C1VRF_Pos      (6UL)    /*!< C1VRF (Bit 6)                                         */
 #define R_ACMPLP_COMPMDR_C1VRF_Msk      (0x40UL) /*!< C1VRF (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPMDR_C1WDE_Pos      (5UL)    /*!< C1WDE (Bit 5)                                         */
 #define R_ACMPLP_COMPMDR_C1WDE_Msk      (0x20UL) /*!< C1WDE (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPMDR_C1ENB_Pos      (4UL)    /*!< C1ENB (Bit 4)                                         */
 #define R_ACMPLP_COMPMDR_C1ENB_Msk      (0x10UL) /*!< C1ENB (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPMDR_C0MON_Pos      (3UL)    /*!< C0MON (Bit 3)                                         */
 #define R_ACMPLP_COMPMDR_C0MON_Msk      (0x8UL)  /*!< C0MON (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPMDR_C0WDE_Pos      (1UL)    /*!< C0WDE (Bit 1)                                         */
 #define R_ACMPLP_COMPMDR_C0WDE_Msk      (0x2UL)  /*!< C0WDE (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPMDR_C0VRF_Pos      (2UL)    /*!< C0VRF (Bit 2)                                         */
 #define R_ACMPLP_COMPMDR_C0VRF_Msk      (0x4UL)  /*!< C0VRF (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPMDR_C0ENB_Pos      (0UL)    /*!< C0ENB (Bit 0)                                         */
 #define R_ACMPLP_COMPMDR_C0ENB_Msk      (0x1UL)  /*!< C0ENB (Bitfield-Mask: 0x01)                           */
/* ========================================================  COMPFIR  ======================================================== */
 #define R_ACMPLP_COMPFIR_C1EDG_Pos      (7UL)    /*!< C1EDG (Bit 7)                                         */
 #define R_ACMPLP_COMPFIR_C1EDG_Msk      (0x80UL) /*!< C1EDG (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPFIR_C1EPO_Pos      (6UL)    /*!< C1EPO (Bit 6)                                         */
 #define R_ACMPLP_COMPFIR_C1EPO_Msk      (0x40UL) /*!< C1EPO (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPFIR_C1FCK_Pos      (4UL)    /*!< C1FCK (Bit 4)                                         */
 #define R_ACMPLP_COMPFIR_C1FCK_Msk      (0x30UL) /*!< C1FCK (Bitfield-Mask: 0x03)                           */
 #define R_ACMPLP_COMPFIR_C0EDG_Pos      (3UL)    /*!< C0EDG (Bit 3)                                         */
 #define R_ACMPLP_COMPFIR_C0EDG_Msk      (0x8UL)  /*!< C0EDG (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPFIR_C0EPO_Pos      (2UL)    /*!< C0EPO (Bit 2)                                         */
 #define R_ACMPLP_COMPFIR_C0EPO_Msk      (0x4UL)  /*!< C0EPO (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPFIR_C0FCK_Pos      (0UL)    /*!< C0FCK (Bit 0)                                         */
 #define R_ACMPLP_COMPFIR_C0FCK_Msk      (0x3UL)  /*!< C0FCK (Bitfield-Mask: 0x03)                           */
/* ========================================================  COMPOCR  ======================================================== */
 #define R_ACMPLP_COMPOCR_SPDMD_Pos      (7UL)    /*!< SPDMD (Bit 7)                                         */
 #define R_ACMPLP_COMPOCR_SPDMD_Msk      (0x80UL) /*!< SPDMD (Bitfield-Mask: 0x01)                           */
 #define R_ACMPLP_COMPOCR_C1OP_Pos       (6UL)    /*!< C1OP (Bit 6)                                          */
 #define R_ACMPLP_COMPOCR_C1OP_Msk       (0x40UL) /*!< C1OP (Bitfield-Mask: 0x01)                            */
 #define R_ACMPLP_COMPOCR_C1OE_Pos       (5UL)    /*!< C1OE (Bit 5)                                          */
 #define R_ACMPLP_COMPOCR_C1OE_Msk       (0x20UL) /*!< C1OE (Bitfield-Mask: 0x01)                            */
 #define R_ACMPLP_COMPOCR_C0OP_Pos       (2UL)    /*!< C0OP (Bit 2)                                          */
 #define R_ACMPLP_COMPOCR_C0OP_Msk       (0x4UL)  /*!< C0OP (Bitfield-Mask: 0x01)                            */
 #define R_ACMPLP_COMPOCR_C0OE_Pos       (1UL)    /*!< C0OE (Bit 1)                                          */
 #define R_ACMPLP_COMPOCR_C0OE_Msk       (0x2UL)  /*!< C0OE (Bitfield-Mask: 0x01)                            */
/* =======================================================  COMPSEL0  ======================================================== */
 #define R_ACMPLP_COMPSEL0_IVCMP1_Pos    (4UL)    /*!< IVCMP1 (Bit 4)                                        */
 #define R_ACMPLP_COMPSEL0_IVCMP1_Msk    (0x70UL) /*!< IVCMP1 (Bitfield-Mask: 0x07)                          */
 #define R_ACMPLP_COMPSEL0_IVCMP0_Pos    (0UL)    /*!< IVCMP0 (Bit 0)                                        */
 #define R_ACMPLP_COMPSEL0_IVCMP0_Msk    (0x7UL)  /*!< IVCMP0 (Bitfield-Mask: 0x07)                          */
/* =======================================================  COMPSEL1  ======================================================== */
 #define R_ACMPLP_COMPSEL1_C1VRF2_Pos    (7UL)    /*!< C1VRF2 (Bit 7)                                        */
 #define R_ACMPLP_COMPSEL1_C1VRF2_Msk    (0x80UL) /*!< C1VRF2 (Bitfield-Mask: 0x01)                          */
 #define R_ACMPLP_COMPSEL1_IVREF1_Pos    (4UL)    /*!< IVREF1 (Bit 4)                                        */
 #define R_ACMPLP_COMPSEL1_IVREF1_Msk    (0x70UL) /*!< IVREF1 (Bitfield-Mask: 0x07)                          */
 #define R_ACMPLP_COMPSEL1_IVREF0_Pos    (0UL)    /*!< IVREF0 (Bit 0)                                        */
 #define R_ACMPLP_COMPSEL1_IVREF0_Msk    (0x7UL)  /*!< IVREF0 (Bitfield-Mask: 0x07)                          */

/* =========================================================================================================================== */
/* ================                                          R_ADC0                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  ADCSR  ========================================================= */
 #define R_ADC0_ADCSR_ADST_Pos              (15UL)      /*!< ADST (Bit 15)                                         */
 #define R_ADC0_ADCSR_ADST_Msk              (0x8000UL)  /*!< ADST (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADCSR_ADCS_Pos              (13UL)      /*!< ADCS (Bit 13)                                         */
 #define R_ADC0_ADCSR_ADCS_Msk              (0x6000UL)  /*!< ADCS (Bitfield-Mask: 0x03)                            */
 #define R_ADC0_ADCSR_ADHSC_Pos             (10UL)      /*!< ADHSC (Bit 10)                                        */
 #define R_ADC0_ADCSR_ADHSC_Msk             (0x400UL)   /*!< ADHSC (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCSR_TRGE_Pos              (9UL)       /*!< TRGE (Bit 9)                                          */
 #define R_ADC0_ADCSR_TRGE_Msk              (0x200UL)   /*!< TRGE (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADCSR_EXTRG_Pos             (8UL)       /*!< EXTRG (Bit 8)                                         */
 #define R_ADC0_ADCSR_EXTRG_Msk             (0x100UL)   /*!< EXTRG (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCSR_DBLE_Pos              (7UL)       /*!< DBLE (Bit 7)                                          */
 #define R_ADC0_ADCSR_DBLE_Msk              (0x80UL)    /*!< DBLE (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADCSR_GBADIE_Pos            (6UL)       /*!< GBADIE (Bit 6)                                        */
 #define R_ADC0_ADCSR_GBADIE_Msk            (0x40UL)    /*!< GBADIE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCSR_DBLANS_Pos            (0UL)       /*!< DBLANS (Bit 0)                                        */
 #define R_ADC0_ADCSR_DBLANS_Msk            (0x1fUL)    /*!< DBLANS (Bitfield-Mask: 0x1f)                          */
 #define R_ADC0_ADCSR_ADIE_Pos              (12UL)      /*!< ADIE (Bit 12)                                         */
 #define R_ADC0_ADCSR_ADIE_Msk              (0x1000UL)  /*!< ADIE (Bitfield-Mask: 0x01)                            */
/* ========================================================  ADANSA  ========================================================= */
 #define R_ADC0_ADANSA_ANSA_Pos             (0UL)       /*!< ANSA (Bit 0)                                          */
 #define R_ADC0_ADANSA_ANSA_Msk             (0x1UL)     /*!< ANSA (Bitfield-Mask: 0x01)                            */
/* =========================================================  ADADS  ========================================================= */
 #define R_ADC0_ADADS_ADS_Pos               (0UL)       /*!< ADS (Bit 0)                                           */
 #define R_ADC0_ADADS_ADS_Msk               (0x1UL)     /*!< ADS (Bitfield-Mask: 0x01)                             */
/* =========================================================  ADADC  ========================================================= */
 #define R_ADC0_ADADC_ADC_Pos               (0UL)       /*!< ADC (Bit 0)                                           */
 #define R_ADC0_ADADC_ADC_Msk               (0x7UL)     /*!< ADC (Bitfield-Mask: 0x07)                             */
 #define R_ADC0_ADADC_AVEE_Pos              (7UL)       /*!< AVEE (Bit 7)                                          */
 #define R_ADC0_ADADC_AVEE_Msk              (0x80UL)    /*!< AVEE (Bitfield-Mask: 0x01)                            */
/* =========================================================  ADCER  ========================================================= */
 #define R_ADC0_ADCER_ADRFMT_Pos            (15UL)      /*!< ADRFMT (Bit 15)                                       */
 #define R_ADC0_ADCER_ADRFMT_Msk            (0x8000UL)  /*!< ADRFMT (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCER_ADINV_Pos             (14UL)      /*!< ADINV (Bit 14)                                        */
 #define R_ADC0_ADCER_ADINV_Msk             (0x4000UL)  /*!< ADINV (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCER_DIAGM_Pos             (11UL)      /*!< DIAGM (Bit 11)                                        */
 #define R_ADC0_ADCER_DIAGM_Msk             (0x800UL)   /*!< DIAGM (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCER_DIAGLD_Pos            (10UL)      /*!< DIAGLD (Bit 10)                                       */
 #define R_ADC0_ADCER_DIAGLD_Msk            (0x400UL)   /*!< DIAGLD (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCER_DIAGVAL_Pos           (8UL)       /*!< DIAGVAL (Bit 8)                                       */
 #define R_ADC0_ADCER_DIAGVAL_Msk           (0x300UL)   /*!< DIAGVAL (Bitfield-Mask: 0x03)                         */
 #define R_ADC0_ADCER_ACE_Pos               (5UL)       /*!< ACE (Bit 5)                                           */
 #define R_ADC0_ADCER_ACE_Msk               (0x20UL)    /*!< ACE (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADCER_ADPRC_Pos             (1UL)       /*!< ADPRC (Bit 1)                                         */
 #define R_ADC0_ADCER_ADPRC_Msk             (0x6UL)     /*!< ADPRC (Bitfield-Mask: 0x03)                           */
 #define R_ADC0_ADCER_DCE_Pos               (4UL)       /*!< DCE (Bit 4)                                           */
 #define R_ADC0_ADCER_DCE_Msk               (0x10UL)    /*!< DCE (Bitfield-Mask: 0x01)                             */
/* ========================================================  ADSTRGR  ======================================================== */
 #define R_ADC0_ADSTRGR_TRSA_Pos            (8UL)       /*!< TRSA (Bit 8)                                          */
 #define R_ADC0_ADSTRGR_TRSA_Msk            (0x3f00UL)  /*!< TRSA (Bitfield-Mask: 0x3f)                            */
 #define R_ADC0_ADSTRGR_TRSB_Pos            (0UL)       /*!< TRSB (Bit 0)                                          */
 #define R_ADC0_ADSTRGR_TRSB_Msk            (0x3fUL)    /*!< TRSB (Bitfield-Mask: 0x3f)                            */
/* ========================================================  ADEXICR  ======================================================== */
 #define R_ADC0_ADEXICR_OCSB_Pos            (11UL)      /*!< OCSB (Bit 11)                                         */
 #define R_ADC0_ADEXICR_OCSB_Msk            (0x800UL)   /*!< OCSB (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_TSSB_Pos            (10UL)      /*!< TSSB (Bit 10)                                         */
 #define R_ADC0_ADEXICR_TSSB_Msk            (0x400UL)   /*!< TSSB (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_OCSA_Pos            (9UL)       /*!< OCSA (Bit 9)                                          */
 #define R_ADC0_ADEXICR_OCSA_Msk            (0x200UL)   /*!< OCSA (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_TSSA_Pos            (8UL)       /*!< TSSA (Bit 8)                                          */
 #define R_ADC0_ADEXICR_TSSA_Msk            (0x100UL)   /*!< TSSA (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADEXICR_OCSAD_Pos           (1UL)       /*!< OCSAD (Bit 1)                                         */
 #define R_ADC0_ADEXICR_OCSAD_Msk           (0x2UL)     /*!< OCSAD (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADEXICR_TSSAD_Pos           (0UL)       /*!< TSSAD (Bit 0)                                         */
 #define R_ADC0_ADEXICR_TSSAD_Msk           (0x1UL)     /*!< TSSAD (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADEXICR_EXSEL_Pos           (14UL)      /*!< EXSEL (Bit 14)                                        */
 #define R_ADC0_ADEXICR_EXSEL_Msk           (0x4000UL)  /*!< EXSEL (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADEXICR_EXOEN_Pos           (15UL)      /*!< EXOEN (Bit 15)                                        */
 #define R_ADC0_ADEXICR_EXOEN_Msk           (0x8000UL)  /*!< EXOEN (Bitfield-Mask: 0x01)                           */
/* ========================================================  ADANSB  ========================================================= */
 #define R_ADC0_ADANSB_ANSB_Pos             (0UL)       /*!< ANSB (Bit 0)                                          */
 #define R_ADC0_ADANSB_ANSB_Msk             (0x1UL)     /*!< ANSB (Bitfield-Mask: 0x01)                            */
/* ========================================================  ADDBLDR  ======================================================== */
 #define R_ADC0_ADDBLDR_ADDBLDR_Pos         (0UL)       /*!< ADDBLDR (Bit 0)                                       */
 #define R_ADC0_ADDBLDR_ADDBLDR_Msk         (0xffffUL)  /*!< ADDBLDR (Bitfield-Mask: 0xffff)                       */
/* ========================================================  ADTSDR  ========================================================= */
 #define R_ADC0_ADTSDR_ADTSDR_Pos           (0UL)       /*!< ADTSDR (Bit 0)                                        */
 #define R_ADC0_ADTSDR_ADTSDR_Msk           (0xffffUL)  /*!< ADTSDR (Bitfield-Mask: 0xffff)                        */
/* ========================================================  ADOCDR  ========================================================= */
 #define R_ADC0_ADOCDR_ADOCDR_Pos           (0UL)       /*!< ADOCDR (Bit 0)                                        */
 #define R_ADC0_ADOCDR_ADOCDR_Msk           (0xffffUL)  /*!< ADOCDR (Bitfield-Mask: 0xffff)                        */
/* ======================================================  ADRD_RIGHT  ======================================================= */
 #define R_ADC0_ADRD_RIGHT_DIAGST_Pos       (14UL)      /*!< DIAGST (Bit 14)                                       */
 #define R_ADC0_ADRD_RIGHT_DIAGST_Msk       (0xc000UL)  /*!< DIAGST (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADRD_RIGHT_AD_Pos           (0UL)       /*!< AD (Bit 0)                                            */
 #define R_ADC0_ADRD_RIGHT_AD_Msk           (0x3fffUL)  /*!< AD (Bitfield-Mask: 0x3fff)                            */
/* =======================================================  ADRD_LEFT  ======================================================= */
 #define R_ADC0_ADRD_LEFT_AD_Pos            (2UL)       /*!< AD (Bit 2)                                            */
 #define R_ADC0_ADRD_LEFT_AD_Msk            (0xfffcUL)  /*!< AD (Bitfield-Mask: 0x3fff)                            */
 #define R_ADC0_ADRD_LEFT_DIAGST_Pos        (0UL)       /*!< DIAGST (Bit 0)                                        */
 #define R_ADC0_ADRD_LEFT_DIAGST_Msk        (0x3UL)     /*!< DIAGST (Bitfield-Mask: 0x03)                          */
/* =========================================================  ADDR  ========================================================== */
 #define R_ADC0_ADDR_ADDR_Pos               (0UL)       /*!< ADDR (Bit 0)                                          */
 #define R_ADC0_ADDR_ADDR_Msk               (0xffffUL)  /*!< ADDR (Bitfield-Mask: 0xffff)                          */
/* ========================================================  ADSHCR  ========================================================= */
 #define R_ADC0_ADSHCR_SHANS2_Pos           (10UL)      /*!< SHANS2 (Bit 10)                                       */
 #define R_ADC0_ADSHCR_SHANS2_Msk           (0x400UL)   /*!< SHANS2 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSHCR_SHANS1_Pos           (9UL)       /*!< SHANS1 (Bit 9)                                        */
 #define R_ADC0_ADSHCR_SHANS1_Msk           (0x200UL)   /*!< SHANS1 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSHCR_SHANS0_Pos           (8UL)       /*!< SHANS0 (Bit 8)                                        */
 #define R_ADC0_ADSHCR_SHANS0_Msk           (0x100UL)   /*!< SHANS0 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSHCR_SSTSH_Pos            (0UL)       /*!< SSTSH (Bit 0)                                         */
 #define R_ADC0_ADSHCR_SSTSH_Msk            (0xffUL)    /*!< SSTSH (Bitfield-Mask: 0xff)                           */
/* ========================================================  ADDISCR  ======================================================== */
 #define R_ADC0_ADDISCR_CHARGE_Pos          (4UL)       /*!< CHARGE (Bit 4)                                        */
 #define R_ADC0_ADDISCR_CHARGE_Msk          (0x10UL)    /*!< CHARGE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADDISCR_ADNDIS_Pos          (0UL)       /*!< ADNDIS (Bit 0)                                        */
 #define R_ADC0_ADDISCR_ADNDIS_Msk          (0xfUL)     /*!< ADNDIS (Bitfield-Mask: 0x0f)                          */
/* ========================================================  ADSHMSR  ======================================================== */
 #define R_ADC0_ADSHMSR_SHMD_Pos            (0UL)       /*!< SHMD (Bit 0)                                          */
 #define R_ADC0_ADSHMSR_SHMD_Msk            (0x1UL)     /*!< SHMD (Bitfield-Mask: 0x01)                            */
/* ========================================================  ADACSR  ========================================================= */
 #define R_ADC0_ADACSR_ADSAC_Pos            (1UL)       /*!< ADSAC (Bit 1)                                         */
 #define R_ADC0_ADACSR_ADSAC_Msk            (0x2UL)     /*!< ADSAC (Bitfield-Mask: 0x01)                           */
/* ========================================================  ADGSPCR  ======================================================== */
 #define R_ADC0_ADGSPCR_GBRP_Pos            (15UL)      /*!< GBRP (Bit 15)                                         */
 #define R_ADC0_ADGSPCR_GBRP_Msk            (0x8000UL)  /*!< GBRP (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADGSPCR_GBRSCN_Pos          (1UL)       /*!< GBRSCN (Bit 1)                                        */
 #define R_ADC0_ADGSPCR_GBRSCN_Msk          (0x2UL)     /*!< GBRSCN (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADGSPCR_PGS_Pos             (0UL)       /*!< PGS (Bit 0)                                           */
 #define R_ADC0_ADGSPCR_PGS_Msk             (0x1UL)     /*!< PGS (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADGSPCR_GBEXTRG_Pos         (8UL)       /*!< GBEXTRG (Bit 8)                                       */
 #define R_ADC0_ADGSPCR_GBEXTRG_Msk         (0x100UL)   /*!< GBEXTRG (Bitfield-Mask: 0x01)                         */
/* =========================================================  ADICR  ========================================================= */
 #define R_ADC0_ADICR_ADIC_Pos              (0UL)       /*!< ADIC (Bit 0)                                          */
 #define R_ADC0_ADICR_ADIC_Msk              (0x3UL)     /*!< ADIC (Bitfield-Mask: 0x03)                            */
/* =======================================================  ADDBLDRA  ======================================================== */
 #define R_ADC0_ADDBLDRA_ADDBLDRA_Pos       (0UL)       /*!< ADDBLDRA (Bit 0)                                      */
 #define R_ADC0_ADDBLDRA_ADDBLDRA_Msk       (0xffffUL)  /*!< ADDBLDRA (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADDBLDRB  ======================================================== */
 #define R_ADC0_ADDBLDRB_ADDBLDRB_Pos       (0UL)       /*!< ADDBLDRB (Bit 0)                                      */
 #define R_ADC0_ADDBLDRB_ADDBLDRB_Msk       (0xffffUL)  /*!< ADDBLDRB (Bitfield-Mask: 0xffff)                      */
/* ======================================================  ADHVREFCNT  ======================================================= */
 #define R_ADC0_ADHVREFCNT_ADSLP_Pos        (7UL)       /*!< ADSLP (Bit 7)                                         */
 #define R_ADC0_ADHVREFCNT_ADSLP_Msk        (0x80UL)    /*!< ADSLP (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADHVREFCNT_LVSEL_Pos        (4UL)       /*!< LVSEL (Bit 4)                                         */
 #define R_ADC0_ADHVREFCNT_LVSEL_Msk        (0x10UL)    /*!< LVSEL (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADHVREFCNT_HVSEL_Pos        (0UL)       /*!< HVSEL (Bit 0)                                         */
 #define R_ADC0_ADHVREFCNT_HVSEL_Msk        (0x3UL)     /*!< HVSEL (Bitfield-Mask: 0x03)                           */
/* =======================================================  ADWINMON  ======================================================== */
 #define R_ADC0_ADWINMON_MONCMPB_Pos        (5UL)       /*!< MONCMPB (Bit 5)                                       */
 #define R_ADC0_ADWINMON_MONCMPB_Msk        (0x20UL)    /*!< MONCMPB (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADWINMON_MONCMPA_Pos        (4UL)       /*!< MONCMPA (Bit 4)                                       */
 #define R_ADC0_ADWINMON_MONCMPA_Msk        (0x10UL)    /*!< MONCMPA (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADWINMON_MONCOMB_Pos        (0UL)       /*!< MONCOMB (Bit 0)                                       */
 #define R_ADC0_ADWINMON_MONCOMB_Msk        (0x1UL)     /*!< MONCOMB (Bitfield-Mask: 0x01)                         */
/* ========================================================  ADCMPCR  ======================================================== */
 #define R_ADC0_ADCMPCR_CMPAIE_Pos          (15UL)      /*!< CMPAIE (Bit 15)                                       */
 #define R_ADC0_ADCMPCR_CMPAIE_Msk          (0x8000UL)  /*!< CMPAIE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCMPCR_WCMPE_Pos           (14UL)      /*!< WCMPE (Bit 14)                                        */
 #define R_ADC0_ADCMPCR_WCMPE_Msk           (0x4000UL)  /*!< WCMPE (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPCR_CMPBIE_Pos          (13UL)      /*!< CMPBIE (Bit 13)                                       */
 #define R_ADC0_ADCMPCR_CMPBIE_Msk          (0x2000UL)  /*!< CMPBIE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCMPCR_CMPAE_Pos           (11UL)      /*!< CMPAE (Bit 11)                                        */
 #define R_ADC0_ADCMPCR_CMPAE_Msk           (0x800UL)   /*!< CMPAE (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPCR_CMPBE_Pos           (9UL)       /*!< CMPBE (Bit 9)                                         */
 #define R_ADC0_ADCMPCR_CMPBE_Msk           (0x200UL)   /*!< CMPBE (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPCR_CMPAB_Pos           (0UL)       /*!< CMPAB (Bit 0)                                         */
 #define R_ADC0_ADCMPCR_CMPAB_Msk           (0x3UL)     /*!< CMPAB (Bitfield-Mask: 0x03)                           */
/* ======================================================  ADCMPANSER  ======================================================= */
 #define R_ADC0_ADCMPANSER_CMPOCA_Pos       (1UL)       /*!< CMPOCA (Bit 1)                                        */
 #define R_ADC0_ADCMPANSER_CMPOCA_Msk       (0x2UL)     /*!< CMPOCA (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCMPANSER_CMPTSA_Pos       (0UL)       /*!< CMPTSA (Bit 0)                                        */
 #define R_ADC0_ADCMPANSER_CMPTSA_Msk       (0x1UL)     /*!< CMPTSA (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADCMPLER  ======================================================== */
 #define R_ADC0_ADCMPLER_CMPLOCA_Pos        (1UL)       /*!< CMPLOCA (Bit 1)                                       */
 #define R_ADC0_ADCMPLER_CMPLOCA_Msk        (0x2UL)     /*!< CMPLOCA (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADCMPLER_CMPLTSA_Pos        (0UL)       /*!< CMPLTSA (Bit 0)                                       */
 #define R_ADC0_ADCMPLER_CMPLTSA_Msk        (0x1UL)     /*!< CMPLTSA (Bitfield-Mask: 0x01)                         */
/* =======================================================  ADCMPANSR  ======================================================= */
 #define R_ADC0_ADCMPANSR_CMPCHA_Pos        (0UL)       /*!< CMPCHA (Bit 0)                                        */
 #define R_ADC0_ADCMPANSR_CMPCHA_Msk        (0x1UL)     /*!< CMPCHA (Bitfield-Mask: 0x01)                          */
/* ========================================================  ADCMPLR  ======================================================== */
 #define R_ADC0_ADCMPLR_CMPLCHA_Pos         (0UL)       /*!< CMPLCHA (Bit 0)                                       */
 #define R_ADC0_ADCMPLR_CMPLCHA_Msk         (0x1UL)     /*!< CMPLCHA (Bitfield-Mask: 0x01)                         */
/* =======================================================  ADCMPDR0  ======================================================== */
 #define R_ADC0_ADCMPDR0_ADCMPDR0_Pos       (0UL)       /*!< ADCMPDR0 (Bit 0)                                      */
 #define R_ADC0_ADCMPDR0_ADCMPDR0_Msk       (0xffffUL)  /*!< ADCMPDR0 (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADCMPDR1  ======================================================== */
 #define R_ADC0_ADCMPDR1_ADCMPDR1_Pos       (0UL)       /*!< ADCMPDR1 (Bit 0)                                      */
 #define R_ADC0_ADCMPDR1_ADCMPDR1_Msk       (0xffffUL)  /*!< ADCMPDR1 (Bitfield-Mask: 0xffff)                      */
/* ========================================================  ADCMPSR  ======================================================== */
 #define R_ADC0_ADCMPSR_CMPSTCHA_Pos        (0UL)       /*!< CMPSTCHA (Bit 0)                                      */
 #define R_ADC0_ADCMPSR_CMPSTCHA_Msk        (0x1UL)     /*!< CMPSTCHA (Bitfield-Mask: 0x01)                        */
/* =======================================================  ADCMPSER  ======================================================== */
 #define R_ADC0_ADCMPSER_CMPSTOCA_Pos       (1UL)       /*!< CMPSTOCA (Bit 1)                                      */
 #define R_ADC0_ADCMPSER_CMPSTOCA_Msk       (0x2UL)     /*!< CMPSTOCA (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADCMPSER_CMPSTTSA_Pos       (0UL)       /*!< CMPSTTSA (Bit 0)                                      */
 #define R_ADC0_ADCMPSER_CMPSTTSA_Msk       (0x1UL)     /*!< CMPSTTSA (Bitfield-Mask: 0x01)                        */
/* =======================================================  ADCMPBNSR  ======================================================= */
 #define R_ADC0_ADCMPBNSR_CMPLB_Pos         (7UL)       /*!< CMPLB (Bit 7)                                         */
 #define R_ADC0_ADCMPBNSR_CMPLB_Msk         (0x80UL)    /*!< CMPLB (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADCMPBNSR_CMPCHB_Pos        (0UL)       /*!< CMPCHB (Bit 0)                                        */
 #define R_ADC0_ADCMPBNSR_CMPCHB_Msk        (0x3fUL)    /*!< CMPCHB (Bitfield-Mask: 0x3f)                          */
/* =======================================================  ADWINLLB  ======================================================== */
 #define R_ADC0_ADWINLLB_ADWINLLB_Pos       (0UL)       /*!< ADWINLLB (Bit 0)                                      */
 #define R_ADC0_ADWINLLB_ADWINLLB_Msk       (0xffffUL)  /*!< ADWINLLB (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADWINULB  ======================================================== */
 #define R_ADC0_ADWINULB_ADWINULB_Pos       (0UL)       /*!< ADWINULB (Bit 0)                                      */
 #define R_ADC0_ADWINULB_ADWINULB_Msk       (0xffffUL)  /*!< ADWINULB (Bitfield-Mask: 0xffff)                      */
/* =======================================================  ADCMPBSR  ======================================================== */
 #define R_ADC0_ADCMPBSR_CMPSTB_Pos         (0UL)       /*!< CMPSTB (Bit 0)                                        */
 #define R_ADC0_ADCMPBSR_CMPSTB_Msk         (0x1UL)     /*!< CMPSTB (Bitfield-Mask: 0x01)                          */
/* ========================================================  ADSSTRL  ======================================================== */
 #define R_ADC0_ADSSTRL_SST_Pos             (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTRL_SST_Msk             (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADSSTRT  ======================================================== */
 #define R_ADC0_ADSSTRT_SST_Pos             (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTRT_SST_Msk             (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADSSTRO  ======================================================== */
 #define R_ADC0_ADSSTRO_SST_Pos             (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTRO_SST_Msk             (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADSSTR  ========================================================= */
 #define R_ADC0_ADSSTR_SST_Pos              (0UL)       /*!< SST (Bit 0)                                           */
 #define R_ADC0_ADSSTR_SST_Msk              (0xffUL)    /*!< SST (Bitfield-Mask: 0xff)                             */
/* ========================================================  ADPGACR  ======================================================== */
 #define R_ADC0_ADPGACR_P002GEN_Pos         (11UL)      /*!< P002GEN (Bit 11)                                      */
 #define R_ADC0_ADPGACR_P002GEN_Msk         (0x800UL)   /*!< P002GEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGACR_P002ENAMP_Pos       (10UL)      /*!< P002ENAMP (Bit 10)                                    */
 #define R_ADC0_ADPGACR_P002ENAMP_Msk       (0x400UL)   /*!< P002ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P002SEL1_Pos        (9UL)       /*!< P002SEL1 (Bit 9)                                      */
 #define R_ADC0_ADPGACR_P002SEL1_Msk        (0x200UL)   /*!< P002SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P002SEL0_Pos        (8UL)       /*!< P002SEL0 (Bit 8)                                      */
 #define R_ADC0_ADPGACR_P002SEL0_Msk        (0x100UL)   /*!< P002SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P001GEN_Pos         (7UL)       /*!< P001GEN (Bit 7)                                       */
 #define R_ADC0_ADPGACR_P001GEN_Msk         (0x80UL)    /*!< P001GEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGACR_P001ENAMP_Pos       (6UL)       /*!< P001ENAMP (Bit 6)                                     */
 #define R_ADC0_ADPGACR_P001ENAMP_Msk       (0x40UL)    /*!< P001ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P001SEL1_Pos        (5UL)       /*!< P001SEL1 (Bit 5)                                      */
 #define R_ADC0_ADPGACR_P001SEL1_Msk        (0x20UL)    /*!< P001SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P001SEL0_Pos        (4UL)       /*!< P001SEL0 (Bit 4)                                      */
 #define R_ADC0_ADPGACR_P001SEL0_Msk        (0x10UL)    /*!< P001SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P000GEN_Pos         (3UL)       /*!< P000GEN (Bit 3)                                       */
 #define R_ADC0_ADPGACR_P000GEN_Msk         (0x8UL)     /*!< P000GEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGACR_P000ENAMP_Pos       (2UL)       /*!< P000ENAMP (Bit 2)                                     */
 #define R_ADC0_ADPGACR_P000ENAMP_Msk       (0x4UL)     /*!< P000ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P000SEL1_Pos        (1UL)       /*!< P000SEL1 (Bit 1)                                      */
 #define R_ADC0_ADPGACR_P000SEL1_Msk        (0x2UL)     /*!< P000SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P000SEL0_Pos        (0UL)       /*!< P000SEL0 (Bit 0)                                      */
 #define R_ADC0_ADPGACR_P000SEL0_Msk        (0x1UL)     /*!< P000SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P003SEL0_Pos        (12UL)      /*!< P003SEL0 (Bit 12)                                     */
 #define R_ADC0_ADPGACR_P003SEL0_Msk        (0x1000UL)  /*!< P003SEL0 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P003SEL1_Pos        (13UL)      /*!< P003SEL1 (Bit 13)                                     */
 #define R_ADC0_ADPGACR_P003SEL1_Msk        (0x2000UL)  /*!< P003SEL1 (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADPGACR_P003ENAMP_Pos       (14UL)      /*!< P003ENAMP (Bit 14)                                    */
 #define R_ADC0_ADPGACR_P003ENAMP_Msk       (0x4000UL)  /*!< P003ENAMP (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_ADPGACR_P003GEN_Pos         (15UL)      /*!< P003GEN (Bit 15)                                      */
 #define R_ADC0_ADPGACR_P003GEN_Msk         (0x8000UL)  /*!< P003GEN (Bitfield-Mask: 0x01)                         */
/* =========================================================  ADRD  ========================================================== */
 #define R_ADC0_ADRD_AD_Pos                 (0UL)       /*!< AD (Bit 0)                                            */
 #define R_ADC0_ADRD_AD_Msk                 (0xffffUL)  /*!< AD (Bitfield-Mask: 0xffff)                            */
/* =========================================================  ADRST  ========================================================= */
 #define R_ADC0_ADRST_DIAGST_Pos            (0UL)       /*!< DIAGST (Bit 0)                                        */
 #define R_ADC0_ADRST_DIAGST_Msk            (0x3UL)     /*!< DIAGST (Bitfield-Mask: 0x03)                          */
/* ======================================================  VREFAMPCNT  ======================================================= */
 #define R_ADC0_VREFAMPCNT_VREFADCG_Pos     (1UL)       /*!< VREFADCG (Bit 1)                                      */
 #define R_ADC0_VREFAMPCNT_VREFADCG_Msk     (0x6UL)     /*!< VREFADCG (Bitfield-Mask: 0x03)                        */
 #define R_ADC0_VREFAMPCNT_VREFADCEN_Pos    (3UL)       /*!< VREFADCEN (Bit 3)                                     */
 #define R_ADC0_VREFAMPCNT_VREFADCEN_Msk    (0x8UL)     /*!< VREFADCEN (Bitfield-Mask: 0x01)                       */
 #define R_ADC0_VREFAMPCNT_ADSLP_Pos        (7UL)       /*!< ADSLP (Bit 7)                                         */
 #define R_ADC0_VREFAMPCNT_ADSLP_Msk        (0x80UL)    /*!< ADSLP (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_VREFAMPCNT_OLDETEN_Pos      (0UL)       /*!< OLDETEN (Bit 0)                                       */
 #define R_ADC0_VREFAMPCNT_OLDETEN_Msk      (0x1UL)     /*!< OLDETEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_VREFAMPCNT_BGREN_Pos        (4UL)       /*!< BGREN (Bit 4)                                         */
 #define R_ADC0_VREFAMPCNT_BGREN_Msk        (0x10UL)    /*!< BGREN (Bitfield-Mask: 0x01)                           */
/* =======================================================  ADCALEXE  ======================================================== */
 #define R_ADC0_ADCALEXE_CALEXE_Pos         (7UL)       /*!< CALEXE (Bit 7)                                        */
 #define R_ADC0_ADCALEXE_CALEXE_Msk         (0x80UL)    /*!< CALEXE (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADCALEXE_CALMON_Pos         (6UL)       /*!< CALMON (Bit 6)                                        */
 #define R_ADC0_ADCALEXE_CALMON_Msk         (0x40UL)    /*!< CALMON (Bitfield-Mask: 0x01)                          */
/* ========================================================  ADANIM  ========================================================= */
 #define R_ADC0_ADANIM_ANIM_Pos             (0UL)       /*!< ANIM (Bit 0)                                          */
 #define R_ADC0_ADANIM_ANIM_Msk             (0x1UL)     /*!< ANIM (Bitfield-Mask: 0x01)                            */
/* =======================================================  ADPGAGS0  ======================================================== */
 #define R_ADC0_ADPGAGS0_P002GAIN_Pos       (8UL)       /*!< P002GAIN (Bit 8)                                      */
 #define R_ADC0_ADPGAGS0_P002GAIN_Msk       (0xf00UL)   /*!< P002GAIN (Bitfield-Mask: 0x0f)                        */
 #define R_ADC0_ADPGAGS0_P001GAIN_Pos       (4UL)       /*!< P001GAIN (Bit 4)                                      */
 #define R_ADC0_ADPGAGS0_P001GAIN_Msk       (0xf0UL)    /*!< P001GAIN (Bitfield-Mask: 0x0f)                        */
 #define R_ADC0_ADPGAGS0_P000GAIN_Pos       (0UL)       /*!< P000GAIN (Bit 0)                                      */
 #define R_ADC0_ADPGAGS0_P000GAIN_Msk       (0xfUL)     /*!< P000GAIN (Bitfield-Mask: 0x0f)                        */
 #define R_ADC0_ADPGAGS0_P003GAIN_Pos       (12UL)      /*!< P003GAIN (Bit 12)                                     */
 #define R_ADC0_ADPGAGS0_P003GAIN_Msk       (0xf000UL)  /*!< P003GAIN (Bitfield-Mask: 0x0f)                        */
/* =======================================================  ADPGADCR0  ======================================================= */
 #define R_ADC0_ADPGADCR0_P003DG_Pos        (12UL)      /*!< P003DG (Bit 12)                                       */
 #define R_ADC0_ADPGADCR0_P003DG_Msk        (0x3000UL)  /*!< P003DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P002DEN_Pos       (11UL)      /*!< P002DEN (Bit 11)                                      */
 #define R_ADC0_ADPGADCR0_P002DEN_Msk       (0x800UL)   /*!< P002DEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGADCR0_P002DG_Pos        (8UL)       /*!< P002DG (Bit 8)                                        */
 #define R_ADC0_ADPGADCR0_P002DG_Msk        (0x300UL)   /*!< P002DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P001DEN_Pos       (7UL)       /*!< P001DEN (Bit 7)                                       */
 #define R_ADC0_ADPGADCR0_P001DEN_Msk       (0x80UL)    /*!< P001DEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGADCR0_P001DG_Pos        (4UL)       /*!< P001DG (Bit 4)                                        */
 #define R_ADC0_ADPGADCR0_P001DG_Msk        (0x30UL)    /*!< P001DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P000DEN_Pos       (3UL)       /*!< P000DEN (Bit 3)                                       */
 #define R_ADC0_ADPGADCR0_P000DEN_Msk       (0x8UL)     /*!< P000DEN (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADPGADCR0_P000DG_Pos        (0UL)       /*!< P000DG (Bit 0)                                        */
 #define R_ADC0_ADPGADCR0_P000DG_Msk        (0x3UL)     /*!< P000DG (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADPGADCR0_P003DEN_Pos       (15UL)      /*!< P003DEN (Bit 15)                                      */
 #define R_ADC0_ADPGADCR0_P003DEN_Msk       (0x8000UL)  /*!< P003DEN (Bitfield-Mask: 0x01)                         */
/* =========================================================  ADREF  ========================================================= */
 #define R_ADC0_ADREF_ADF_Pos               (0UL)       /*!< ADF (Bit 0)                                           */
 #define R_ADC0_ADREF_ADF_Msk               (0x1UL)     /*!< ADF (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADREF_ADSCACT_Pos           (7UL)       /*!< ADSCACT (Bit 7)                                       */
 #define R_ADC0_ADREF_ADSCACT_Msk           (0x80UL)    /*!< ADSCACT (Bitfield-Mask: 0x01)                         */
/* ========================================================  ADEXREF  ======================================================== */
 #define R_ADC0_ADEXREF_GBADF_Pos           (0UL)       /*!< GBADF (Bit 0)                                         */
 #define R_ADC0_ADEXREF_GBADF_Msk           (0x1UL)     /*!< GBADF (Bitfield-Mask: 0x01)                           */
/* =======================================================  ADAMPOFF  ======================================================== */
 #define R_ADC0_ADAMPOFF_OPOFF_Pos          (0UL)       /*!< OPOFF (Bit 0)                                         */
 #define R_ADC0_ADAMPOFF_OPOFF_Msk          (0xffUL)    /*!< OPOFF (Bitfield-Mask: 0xff)                           */
/* ========================================================  ADTSTPR  ======================================================== */
 #define R_ADC0_ADTSTPR_PRO_Pos             (0UL)       /*!< PRO (Bit 0)                                           */
 #define R_ADC0_ADTSTPR_PRO_Msk             (0x1UL)     /*!< PRO (Bitfield-Mask: 0x01)                             */
 #define R_ADC0_ADTSTPR_B0WI_Pos            (1UL)       /*!< B0WI (Bit 1)                                          */
 #define R_ADC0_ADTSTPR_B0WI_Msk            (0x2UL)     /*!< B0WI (Bitfield-Mask: 0x01)                            */
/* =======================================================  ADDDACER  ======================================================== */
 #define R_ADC0_ADDDACER_WRION_Pos          (0UL)       /*!< WRION (Bit 0)                                         */
 #define R_ADC0_ADDDACER_WRION_Msk          (0x1fUL)    /*!< WRION (Bitfield-Mask: 0x1f)                           */
 #define R_ADC0_ADDDACER_WRIOFF_Pos         (8UL)       /*!< WRIOFF (Bit 8)                                        */
 #define R_ADC0_ADDDACER_WRIOFF_Msk         (0x1f00UL)  /*!< WRIOFF (Bitfield-Mask: 0x1f)                          */
 #define R_ADC0_ADDDACER_ADHS_Pos           (15UL)      /*!< ADHS (Bit 15)                                         */
 #define R_ADC0_ADDDACER_ADHS_Msk           (0x8000UL)  /*!< ADHS (Bitfield-Mask: 0x01)                            */
/* =======================================================  ADEXTSTR  ======================================================== */
 #define R_ADC0_ADEXTSTR_SHTEST_Pos         (0UL)       /*!< SHTEST (Bit 0)                                        */
 #define R_ADC0_ADEXTSTR_SHTEST_Msk         (0x7UL)     /*!< SHTEST (Bitfield-Mask: 0x07)                          */
 #define R_ADC0_ADEXTSTR_SWTST_Pos          (4UL)       /*!< SWTST (Bit 4)                                         */
 #define R_ADC0_ADEXTSTR_SWTST_Msk          (0x30UL)    /*!< SWTST (Bitfield-Mask: 0x03)                           */
 #define R_ADC0_ADEXTSTR_SHTRM_Pos          (8UL)       /*!< SHTRM (Bit 8)                                         */
 #define R_ADC0_ADEXTSTR_SHTRM_Msk          (0x300UL)   /*!< SHTRM (Bitfield-Mask: 0x03)                           */
 #define R_ADC0_ADEXTSTR_ADTRM3_Pos         (11UL)      /*!< ADTRM3 (Bit 11)                                       */
 #define R_ADC0_ADEXTSTR_ADTRM3_Msk         (0x800UL)   /*!< ADTRM3 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADEXTSTR_ADTRM2_Pos         (12UL)      /*!< ADTRM2 (Bit 12)                                       */
 #define R_ADC0_ADEXTSTR_ADTRM2_Msk         (0x3000UL)  /*!< ADTRM2 (Bitfield-Mask: 0x03)                          */
 #define R_ADC0_ADEXTSTR_ADTRM1_Pos         (14UL)      /*!< ADTRM1 (Bit 14)                                       */
 #define R_ADC0_ADEXTSTR_ADTRM1_Msk         (0xc000UL)  /*!< ADTRM1 (Bitfield-Mask: 0x03)                          */
/* ========================================================  ADTSTRA  ======================================================== */
 #define R_ADC0_ADTSTRA_ATBUSSEL_Pos        (0UL)       /*!< ATBUSSEL (Bit 0)                                      */
 #define R_ADC0_ADTSTRA_ATBUSSEL_Msk        (0x1UL)     /*!< ATBUSSEL (Bitfield-Mask: 0x01)                        */
 #define R_ADC0_ADTSTRA_TSTSWREF_Pos        (1UL)       /*!< TSTSWREF (Bit 1)                                      */
 #define R_ADC0_ADTSTRA_TSTSWREF_Msk        (0xeUL)     /*!< TSTSWREF (Bitfield-Mask: 0x07)                        */
 #define R_ADC0_ADTSTRA_OCSW_Pos            (5UL)       /*!< OCSW (Bit 5)                                          */
 #define R_ADC0_ADTSTRA_OCSW_Msk            (0x20UL)    /*!< OCSW (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADTSTRA_TSSW_Pos            (6UL)       /*!< TSSW (Bit 6)                                          */
 #define R_ADC0_ADTSTRA_TSSW_Msk            (0x40UL)    /*!< TSSW (Bitfield-Mask: 0x01)                            */
 #define R_ADC0_ADTSTRA_ADTEST_AD_Pos       (8UL)       /*!< ADTEST_AD (Bit 8)                                     */
 #define R_ADC0_ADTSTRA_ADTEST_AD_Msk       (0xf00UL)   /*!< ADTEST_AD (Bitfield-Mask: 0x0f)                       */
 #define R_ADC0_ADTSTRA_ADTEST_IO_Pos       (12UL)      /*!< ADTEST_IO (Bit 12)                                    */
 #define R_ADC0_ADTSTRA_ADTEST_IO_Msk       (0xf000UL)  /*!< ADTEST_IO (Bitfield-Mask: 0x0f)                       */
/* ========================================================  ADTSTRB  ======================================================== */
 #define R_ADC0_ADTSTRB_ADVAL_Pos           (0UL)       /*!< ADVAL (Bit 0)                                         */
 #define R_ADC0_ADTSTRB_ADVAL_Msk           (0x7fffUL)  /*!< ADVAL (Bitfield-Mask: 0x7fff)                         */
/* ========================================================  ADTSTRC  ======================================================== */
 #define R_ADC0_ADTSTRC_ADMD_Pos            (0UL)       /*!< ADMD (Bit 0)                                          */
 #define R_ADC0_ADTSTRC_ADMD_Msk            (0xffUL)    /*!< ADMD (Bitfield-Mask: 0xff)                            */
 #define R_ADC0_ADTSTRC_SYNCERR_Pos         (12UL)      /*!< SYNCERR (Bit 12)                                      */
 #define R_ADC0_ADTSTRC_SYNCERR_Msk         (0x1000UL)  /*!< SYNCERR (Bitfield-Mask: 0x01)                         */
/* ========================================================  ADTSTRD  ======================================================== */
 #define R_ADC0_ADTSTRD_ADVAL16_Pos         (0UL)       /*!< ADVAL16 (Bit 0)                                       */
 #define R_ADC0_ADTSTRD_ADVAL16_Msk         (0x1UL)     /*!< ADVAL16 (Bitfield-Mask: 0x01)                         */
/* =======================================================  ADSWTSTR0  ======================================================= */
 #define R_ADC0_ADSWTSTR0_CHSW00_Pos        (0UL)       /*!< CHSW00 (Bit 0)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW00_Msk        (0x1UL)     /*!< CHSW00 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW01_Pos        (1UL)       /*!< CHSW01 (Bit 1)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW01_Msk        (0x2UL)     /*!< CHSW01 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW02_Pos        (2UL)       /*!< CHSW02 (Bit 2)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW02_Msk        (0x4UL)     /*!< CHSW02 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW03_Pos        (3UL)       /*!< CHSW03 (Bit 3)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW03_Msk        (0x8UL)     /*!< CHSW03 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW04_Pos        (4UL)       /*!< CHSW04 (Bit 4)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW04_Msk        (0x10UL)    /*!< CHSW04 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR0_CHSW05_Pos        (5UL)       /*!< CHSW05 (Bit 5)                                        */
 #define R_ADC0_ADSWTSTR0_CHSW05_Msk        (0x20UL)    /*!< CHSW05 (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADSWTSTR1  ======================================================= */
 #define R_ADC0_ADSWTSTR1_CHSW16_Pos        (0UL)       /*!< CHSW16 (Bit 0)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW16_Msk        (0x1UL)     /*!< CHSW16 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW17_Pos        (1UL)       /*!< CHSW17 (Bit 1)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW17_Msk        (0x2UL)     /*!< CHSW17 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW18_Pos        (2UL)       /*!< CHSW18 (Bit 2)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW18_Msk        (0x4UL)     /*!< CHSW18 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW19_Pos        (3UL)       /*!< CHSW19 (Bit 3)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW19_Msk        (0x8UL)     /*!< CHSW19 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW20_Pos        (4UL)       /*!< CHSW20 (Bit 4)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW20_Msk        (0x10UL)    /*!< CHSW20 (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR1_CHSW21_Pos        (5UL)       /*!< CHSW21 (Bit 5)                                        */
 #define R_ADC0_ADSWTSTR1_CHSW21_Msk        (0x20UL)    /*!< CHSW21 (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADSWTSTR2  ======================================================= */
 #define R_ADC0_ADSWTSTR2_EX0SW_Pos         (0UL)       /*!< EX0SW (Bit 0)                                         */
 #define R_ADC0_ADSWTSTR2_EX0SW_Msk         (0x1UL)     /*!< EX0SW (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADSWTSTR2_EX1SW_Pos         (1UL)       /*!< EX1SW (Bit 1)                                         */
 #define R_ADC0_ADSWTSTR2_EX1SW_Msk         (0x2UL)     /*!< EX1SW (Bitfield-Mask: 0x01)                           */
 #define R_ADC0_ADSWTSTR2_SHBYPS0_Pos       (4UL)       /*!< SHBYPS0 (Bit 4)                                       */
 #define R_ADC0_ADSWTSTR2_SHBYPS0_Msk       (0x10UL)    /*!< SHBYPS0 (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADSWTSTR2_SHBYPS1_Pos       (5UL)       /*!< SHBYPS1 (Bit 5)                                       */
 #define R_ADC0_ADSWTSTR2_SHBYPS1_Msk       (0x20UL)    /*!< SHBYPS1 (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADSWTSTR2_SHBYPS2_Pos       (6UL)       /*!< SHBYPS2 (Bit 6)                                       */
 #define R_ADC0_ADSWTSTR2_SHBYPS2_Msk       (0x40UL)    /*!< SHBYPS2 (Bitfield-Mask: 0x01)                         */
 #define R_ADC0_ADSWTSTR2_GRP0SW_Pos        (8UL)       /*!< GRP0SW (Bit 8)                                        */
 #define R_ADC0_ADSWTSTR2_GRP0SW_Msk        (0x100UL)   /*!< GRP0SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRP1SW_Pos        (9UL)       /*!< GRP1SW (Bit 9)                                        */
 #define R_ADC0_ADSWTSTR2_GRP1SW_Msk        (0x200UL)   /*!< GRP1SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRP2SW_Pos        (10UL)      /*!< GRP2SW (Bit 10)                                       */
 #define R_ADC0_ADSWTSTR2_GRP2SW_Msk        (0x400UL)   /*!< GRP2SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRP3SW_Pos        (11UL)      /*!< GRP3SW (Bit 11)                                       */
 #define R_ADC0_ADSWTSTR2_GRP3SW_Msk        (0x800UL)   /*!< GRP3SW (Bitfield-Mask: 0x01)                          */
 #define R_ADC0_ADSWTSTR2_GRPEX1SW_Pos      (12UL)      /*!< GRPEX1SW (Bit 12)                                     */
 #define R_ADC0_ADSWTSTR2_GRPEX1SW_Msk      (0x1000UL)  /*!< GRPEX1SW (Bitfield-Mask: 0x01)                        */
/* ========================================================  ADSWCR  ========================================================= */
 #define R_ADC0_ADSWCR_ADSWREF_Pos          (0UL)       /*!< ADSWREF (Bit 0)                                       */
 #define R_ADC0_ADSWCR_ADSWREF_Msk          (0x7UL)     /*!< ADSWREF (Bitfield-Mask: 0x07)                         */
 #define R_ADC0_ADSWCR_SHSWREF_Pos          (4UL)       /*!< SHSWREF (Bit 4)                                       */
 #define R_ADC0_ADSWCR_SHSWREF_Msk          (0x70UL)    /*!< SHSWREF (Bitfield-Mask: 0x07)                         */
/* ========================================================  ADGSCS  ========================================================= */
 #define R_ADC0_ADGSCS_CHSELGB_Pos          (0UL)       /*!< CHSELGB (Bit 0)                                       */
 #define R_ADC0_ADGSCS_CHSELGB_Msk          (0xffUL)    /*!< CHSELGB (Bitfield-Mask: 0xff)                         */
 #define R_ADC0_ADGSCS_CHSELGA_Pos          (8UL)       /*!< CHSELGA (Bit 8)                                       */
 #define R_ADC0_ADGSCS_CHSELGA_Msk          (0xff00UL)  /*!< CHSELGA (Bitfield-Mask: 0xff)                         */
/* =========================================================  ADSER  ========================================================= */
 #define R_ADC0_ADSER_SMPEX_Pos             (7UL)       /*!< SMPEX (Bit 7)                                         */
 #define R_ADC0_ADSER_SMPEX_Msk             (0x80UL)    /*!< SMPEX (Bitfield-Mask: 0x01)                           */
/* ========================================================  ADBUF0  ========================================================= */
 #define R_ADC0_ADBUF0_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF0_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF1  ========================================================= */
 #define R_ADC0_ADBUF1_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF1_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF2  ========================================================= */
 #define R_ADC0_ADBUF2_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF2_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF3  ========================================================= */
 #define R_ADC0_ADBUF3_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF3_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF4  ========================================================= */
 #define R_ADC0_ADBUF4_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF4_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF5  ========================================================= */
 #define R_ADC0_ADBUF5_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF5_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF6  ========================================================= */
 #define R_ADC0_ADBUF6_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF6_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF7  ========================================================= */
 #define R_ADC0_ADBUF7_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF7_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF8  ========================================================= */
 #define R_ADC0_ADBUF8_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF8_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF9  ========================================================= */
 #define R_ADC0_ADBUF9_ADBUF_Pos            (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF9_ADBUF_Msk            (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF10  ======================================================== */
 #define R_ADC0_ADBUF10_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF10_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF11  ======================================================== */
 #define R_ADC0_ADBUF11_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF11_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF12  ======================================================== */
 #define R_ADC0_ADBUF12_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF12_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF13  ======================================================== */
 #define R_ADC0_ADBUF13_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF13_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF14  ======================================================== */
 #define R_ADC0_ADBUF14_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF14_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUF15  ======================================================== */
 #define R_ADC0_ADBUF15_ADBUF_Pos           (0UL)       /*!< ADBUF (Bit 0)                                         */
 #define R_ADC0_ADBUF15_ADBUF_Msk           (0xffffUL)  /*!< ADBUF (Bitfield-Mask: 0xffff)                         */
/* ========================================================  ADBUFEN  ======================================================== */
 #define R_ADC0_ADBUFEN_BUFEN_Pos           (0UL)       /*!< BUFEN (Bit 0)                                         */
 #define R_ADC0_ADBUFEN_BUFEN_Msk           (0x1UL)     /*!< BUFEN (Bitfield-Mask: 0x01)                           */
/* =======================================================  ADBUFPTR  ======================================================== */
 #define R_ADC0_ADBUFPTR_BUFPTR_Pos         (0UL)       /*!< BUFPTR (Bit 0)                                        */
 #define R_ADC0_ADBUFPTR_BUFPTR_Msk         (0xfUL)     /*!< BUFPTR (Bitfield-Mask: 0x0f)                          */
 #define R_ADC0_ADBUFPTR_PTROVF_Pos         (4UL)       /*!< PTROVF (Bit 4)                                        */
 #define R_ADC0_ADBUFPTR_PTROVF_Msk         (0x10UL)    /*!< PTROVF (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADPGADBS0  ======================================================= */
 #define R_ADC0_ADPGADBS0_P0BIAS_Pos        (0UL)       /*!< P0BIAS (Bit 0)                                        */
 #define R_ADC0_ADPGADBS0_P0BIAS_Msk        (0x1UL)     /*!< P0BIAS (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADPGADBS1  ======================================================= */
 #define R_ADC0_ADPGADBS1_P3BIAS_Pos        (0UL)       /*!< P3BIAS (Bit 0)                                        */
 #define R_ADC0_ADPGADBS1_P3BIAS_Msk        (0x1UL)     /*!< P3BIAS (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADREFMON  ======================================================== */
 #define R_ADC0_ADREFMON_PGAMON_Pos         (0UL)       /*!< PGAMON (Bit 0)                                        */
 #define R_ADC0_ADREFMON_PGAMON_Msk         (0x7UL)     /*!< PGAMON (Bitfield-Mask: 0x07)                          */
 #define R_ADC0_ADREFMON_MONSEL_Pos         (16UL)      /*!< MONSEL (Bit 16)                                       */
 #define R_ADC0_ADREFMON_MONSEL_Msk         (0xf0000UL) /*!< MONSEL (Bitfield-Mask: 0x0f)                          */

/* =========================================================================================================================== */
/* ================                                           R_BUS                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  CSRECEN  ======================================================== */
 #define R_BUS_CSRECEN_RCVENM_Pos        (8UL)       /*!< RCVENM (Bit 8)                                        */
 #define R_BUS_CSRECEN_RCVENM_Msk        (0x100UL)   /*!< RCVENM (Bitfield-Mask: 0x01)                          */
 #define R_BUS_CSRECEN_RCVEN_Pos         (0UL)       /*!< RCVEN (Bit 0)                                         */
 #define R_BUS_CSRECEN_RCVEN_Msk         (0x1UL)     /*!< RCVEN (Bitfield-Mask: 0x01)                           */
/* ========================================================  BUSMABT  ======================================================== */
 #define R_BUS_BUSMABT_ARBS_Pos          (0UL)       /*!< ARBS (Bit 0)                                          */
 #define R_BUS_BUSMABT_ARBS_Msk          (0x1UL)     /*!< ARBS (Bitfield-Mask: 0x01)                            */
/* =======================================================  BUSDIVBYP  ======================================================= */
 #define R_BUS_BUSDIVBYP_CPU0SBPE_Pos    (16UL)      /*!< CPU0SBPE (Bit 16)                                     */
 #define R_BUS_BUSDIVBYP_CPU0SBPE_Msk    (0x10000UL) /*!< CPU0SBPE (Bitfield-Mask: 0x01)                        */
 #define R_BUS_BUSDIVBYP_GDSSBPE_Pos     (3UL)       /*!< GDSSBPE (Bit 3)                                       */
 #define R_BUS_BUSDIVBYP_GDSSBPE_Msk     (0x8UL)     /*!< GDSSBPE (Bitfield-Mask: 0x01)                         */
 #define R_BUS_BUSDIVBYP_EDMABPE_Pos     (0UL)       /*!< EDMABPE (Bit 0)                                       */
 #define R_BUS_BUSDIVBYP_EDMABPE_Msk     (0x1UL)     /*!< EDMABPE (Bitfield-Mask: 0x01)                         */
/* =======================================================  BUSTHRPUT  ======================================================= */
 #define R_BUS_BUSTHRPUT_DIS_Pos         (0UL)       /*!< DIS (Bit 0)                                           */
 #define R_BUS_BUSTHRPUT_DIS_Msk         (0x1UL)     /*!< DIS (Bitfield-Mask: 0x01)                             */

/* =========================================================================================================================== */
/* ================                                           R_CAC                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CACR0  ========================================================= */
 #define R_CAC_CACR0_CFME_Pos         (0UL)      /*!< CFME (Bit 0)                                          */
 #define R_CAC_CACR0_CFME_Msk         (0x1UL)    /*!< CFME (Bitfield-Mask: 0x01)                            */
/* =========================================================  CACR1  ========================================================= */
 #define R_CAC_CACR1_EDGES_Pos        (6UL)      /*!< EDGES (Bit 6)                                         */
 #define R_CAC_CACR1_EDGES_Msk        (0xc0UL)   /*!< EDGES (Bitfield-Mask: 0x03)                           */
 #define R_CAC_CACR1_TCSS_Pos         (4UL)      /*!< TCSS (Bit 4)                                          */
 #define R_CAC_CACR1_TCSS_Msk         (0x30UL)   /*!< TCSS (Bitfield-Mask: 0x03)                            */
 #define R_CAC_CACR1_FMCS_Pos         (1UL)      /*!< FMCS (Bit 1)                                          */
 #define R_CAC_CACR1_FMCS_Msk         (0xeUL)    /*!< FMCS (Bitfield-Mask: 0x07)                            */
 #define R_CAC_CACR1_CACREFE_Pos      (0UL)      /*!< CACREFE (Bit 0)                                       */
 #define R_CAC_CACR1_CACREFE_Msk      (0x1UL)    /*!< CACREFE (Bitfield-Mask: 0x01)                         */
/* =========================================================  CACR2  ========================================================= */
 #define R_CAC_CACR2_DFS_Pos          (6UL)      /*!< DFS (Bit 6)                                           */
 #define R_CAC_CACR2_DFS_Msk          (0xc0UL)   /*!< DFS (Bitfield-Mask: 0x03)                             */
 #define R_CAC_CACR2_RCDS_Pos         (4UL)      /*!< RCDS (Bit 4)                                          */
 #define R_CAC_CACR2_RCDS_Msk         (0x30UL)   /*!< RCDS (Bitfield-Mask: 0x03)                            */
 #define R_CAC_CACR2_RSCS_Pos         (1UL)      /*!< RSCS (Bit 1)                                          */
 #define R_CAC_CACR2_RSCS_Msk         (0xeUL)    /*!< RSCS (Bitfield-Mask: 0x07)                            */
 #define R_CAC_CACR2_RPS_Pos          (0UL)      /*!< RPS (Bit 0)                                           */
 #define R_CAC_CACR2_RPS_Msk          (0x1UL)    /*!< RPS (Bitfield-Mask: 0x01)                             */
/* =========================================================  CAICR  ========================================================= */
 #define R_CAC_CAICR_OVFFCL_Pos       (6UL)      /*!< OVFFCL (Bit 6)                                        */
 #define R_CAC_CAICR_OVFFCL_Msk       (0x40UL)   /*!< OVFFCL (Bitfield-Mask: 0x01)                          */
 #define R_CAC_CAICR_MENDFCL_Pos      (5UL)      /*!< MENDFCL (Bit 5)                                       */
 #define R_CAC_CAICR_MENDFCL_Msk      (0x20UL)   /*!< MENDFCL (Bitfield-Mask: 0x01)                         */
 #define R_CAC_CAICR_FERRFCL_Pos      (4UL)      /*!< FERRFCL (Bit 4)                                       */
 #define R_CAC_CAICR_FERRFCL_Msk      (0x10UL)   /*!< FERRFCL (Bitfield-Mask: 0x01)                         */
 #define R_CAC_CAICR_OVFIE_Pos        (2UL)      /*!< OVFIE (Bit 2)                                         */
 #define R_CAC_CAICR_OVFIE_Msk        (0x4UL)    /*!< OVFIE (Bitfield-Mask: 0x01)                           */
 #define R_CAC_CAICR_MENDIE_Pos       (1UL)      /*!< MENDIE (Bit 1)                                        */
 #define R_CAC_CAICR_MENDIE_Msk       (0x2UL)    /*!< MENDIE (Bitfield-Mask: 0x01)                          */
 #define R_CAC_CAICR_FERRIE_Pos       (0UL)      /*!< FERRIE (Bit 0)                                        */
 #define R_CAC_CAICR_FERRIE_Msk       (0x1UL)    /*!< FERRIE (Bitfield-Mask: 0x01)                          */
/* =========================================================  CASTR  ========================================================= */
 #define R_CAC_CASTR_OVFF_Pos         (2UL)      /*!< OVFF (Bit 2)                                          */
 #define R_CAC_CASTR_OVFF_Msk         (0x4UL)    /*!< OVFF (Bitfield-Mask: 0x01)                            */
 #define R_CAC_CASTR_MENDF_Pos        (1UL)      /*!< MENDF (Bit 1)                                         */
 #define R_CAC_CASTR_MENDF_Msk        (0x2UL)    /*!< MENDF (Bitfield-Mask: 0x01)                           */
 #define R_CAC_CASTR_FERRF_Pos        (0UL)      /*!< FERRF (Bit 0)                                         */
 #define R_CAC_CASTR_FERRF_Msk        (0x1UL)    /*!< FERRF (Bitfield-Mask: 0x01)                           */
/* ========================================================  CAULVR  ========================================================= */
 #define R_CAC_CAULVR_CAULVR_Pos      (0UL)      /*!< CAULVR (Bit 0)                                        */
 #define R_CAC_CAULVR_CAULVR_Msk      (0xffffUL) /*!< CAULVR (Bitfield-Mask: 0xffff)                        */
/* ========================================================  CALLVR  ========================================================= */
 #define R_CAC_CALLVR_CALLVR_Pos      (0UL)      /*!< CALLVR (Bit 0)                                        */
 #define R_CAC_CALLVR_CALLVR_Msk      (0xffffUL) /*!< CALLVR (Bitfield-Mask: 0xffff)                        */
/* ========================================================  CACNTBR  ======================================================== */
 #define R_CAC_CACNTBR_CACNTBR_Pos    (0UL)      /*!< CACNTBR (Bit 0)                                       */
 #define R_CAC_CACNTBR_CACNTBR_Msk    (0xffffUL) /*!< CACNTBR (Bitfield-Mask: 0xffff)                       */

/* =========================================================================================================================== */
/* ================                                          R_CAN0                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  MKR  ========================================================== */
 #define R_CAN0_MKR_SID_Pos              (18UL)         /*!< SID (Bit 18)                                          */
 #define R_CAN0_MKR_SID_Msk              (0x1ffc0000UL) /*!< SID (Bitfield-Mask: 0x7ff)                            */
 #define R_CAN0_MKR_EID_Pos              (0UL)          /*!< EID (Bit 0)                                           */
 #define R_CAN0_MKR_EID_Msk              (0x3ffffUL)    /*!< EID (Bitfield-Mask: 0x3ffff)                          */
/* =========================================================  FIDCR  ========================================================= */
 #define R_CAN0_FIDCR_IDE_Pos            (31UL)         /*!< IDE (Bit 31)                                          */
 #define R_CAN0_FIDCR_IDE_Msk            (0x80000000UL) /*!< IDE (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_FIDCR_RTR_Pos            (30UL)         /*!< RTR (Bit 30)                                          */
 #define R_CAN0_FIDCR_RTR_Msk            (0x40000000UL) /*!< RTR (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_FIDCR_SID_Pos            (18UL)         /*!< SID (Bit 18)                                          */
 #define R_CAN0_FIDCR_SID_Msk            (0x1ffc0000UL) /*!< SID (Bitfield-Mask: 0x7ff)                            */
 #define R_CAN0_FIDCR_EID_Pos            (0UL)          /*!< EID (Bit 0)                                           */
 #define R_CAN0_FIDCR_EID_Msk            (0x3ffffUL)    /*!< EID (Bitfield-Mask: 0x3ffff)                          */
/* ========================================================  MKIVLR  ========================================================= */
 #define R_CAN0_MKIVLR_MB31_Pos          (31UL)         /*!< MB31 (Bit 31)                                         */
 #define R_CAN0_MKIVLR_MB31_Msk          (0x80000000UL) /*!< MB31 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB30_Pos          (30UL)         /*!< MB30 (Bit 30)                                         */
 #define R_CAN0_MKIVLR_MB30_Msk          (0x40000000UL) /*!< MB30 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB29_Pos          (29UL)         /*!< MB29 (Bit 29)                                         */
 #define R_CAN0_MKIVLR_MB29_Msk          (0x20000000UL) /*!< MB29 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB28_Pos          (28UL)         /*!< MB28 (Bit 28)                                         */
 #define R_CAN0_MKIVLR_MB28_Msk          (0x10000000UL) /*!< MB28 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB27_Pos          (27UL)         /*!< MB27 (Bit 27)                                         */
 #define R_CAN0_MKIVLR_MB27_Msk          (0x8000000UL)  /*!< MB27 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB26_Pos          (26UL)         /*!< MB26 (Bit 26)                                         */
 #define R_CAN0_MKIVLR_MB26_Msk          (0x4000000UL)  /*!< MB26 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB25_Pos          (25UL)         /*!< MB25 (Bit 25)                                         */
 #define R_CAN0_MKIVLR_MB25_Msk          (0x2000000UL)  /*!< MB25 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB24_Pos          (24UL)         /*!< MB24 (Bit 24)                                         */
 #define R_CAN0_MKIVLR_MB24_Msk          (0x1000000UL)  /*!< MB24 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB23_Pos          (23UL)         /*!< MB23 (Bit 23)                                         */
 #define R_CAN0_MKIVLR_MB23_Msk          (0x800000UL)   /*!< MB23 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB22_Pos          (22UL)         /*!< MB22 (Bit 22)                                         */
 #define R_CAN0_MKIVLR_MB22_Msk          (0x400000UL)   /*!< MB22 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB21_Pos          (21UL)         /*!< MB21 (Bit 21)                                         */
 #define R_CAN0_MKIVLR_MB21_Msk          (0x200000UL)   /*!< MB21 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB20_Pos          (20UL)         /*!< MB20 (Bit 20)                                         */
 #define R_CAN0_MKIVLR_MB20_Msk          (0x100000UL)   /*!< MB20 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB19_Pos          (19UL)         /*!< MB19 (Bit 19)                                         */
 #define R_CAN0_MKIVLR_MB19_Msk          (0x80000UL)    /*!< MB19 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB18_Pos          (18UL)         /*!< MB18 (Bit 18)                                         */
 #define R_CAN0_MKIVLR_MB18_Msk          (0x40000UL)    /*!< MB18 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB17_Pos          (17UL)         /*!< MB17 (Bit 17)                                         */
 #define R_CAN0_MKIVLR_MB17_Msk          (0x20000UL)    /*!< MB17 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB16_Pos          (16UL)         /*!< MB16 (Bit 16)                                         */
 #define R_CAN0_MKIVLR_MB16_Msk          (0x10000UL)    /*!< MB16 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB15_Pos          (15UL)         /*!< MB15 (Bit 15)                                         */
 #define R_CAN0_MKIVLR_MB15_Msk          (0x8000UL)     /*!< MB15 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB14_Pos          (14UL)         /*!< MB14 (Bit 14)                                         */
 #define R_CAN0_MKIVLR_MB14_Msk          (0x4000UL)     /*!< MB14 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB13_Pos          (13UL)         /*!< MB13 (Bit 13)                                         */
 #define R_CAN0_MKIVLR_MB13_Msk          (0x2000UL)     /*!< MB13 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB12_Pos          (12UL)         /*!< MB12 (Bit 12)                                         */
 #define R_CAN0_MKIVLR_MB12_Msk          (0x1000UL)     /*!< MB12 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB11_Pos          (11UL)         /*!< MB11 (Bit 11)                                         */
 #define R_CAN0_MKIVLR_MB11_Msk          (0x800UL)      /*!< MB11 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB10_Pos          (10UL)         /*!< MB10 (Bit 10)                                         */
 #define R_CAN0_MKIVLR_MB10_Msk          (0x400UL)      /*!< MB10 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MKIVLR_MB9_Pos           (9UL)          /*!< MB9 (Bit 9)                                           */
 #define R_CAN0_MKIVLR_MB9_Msk           (0x200UL)      /*!< MB9 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MKIVLR_MB8_Pos           (8UL)          /*!< MB8 (Bit 8)                                           */
 #define R_CAN0_MKIVLR_MB8_Msk           (0x100UL)      /*!< MB8 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MKIVLR_MB7_Pos           (7UL)          /*!< MB7 (Bit 7)                                           */
 #define R_CAN0_MKIVLR_MB7_Msk           (0x80UL)       /*!< MB7 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MKIVLR_MB6_Pos           (6UL)          /*!< MB6 (Bit 6)                                           */
 #define R_CAN0_MKIVLR_MB6_Msk           (0x40UL)       /*!< MB6 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MKIVLR_MB5_Pos           (5UL)          /*!< MB5 (Bit 5)                                           */
 #define R_CAN0_MKIVLR_MB5_Msk           (0x20UL)       /*!< MB5 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MKIVLR_MB4_Pos           (4UL)          /*!< MB4 (Bit 4)                                           */
 #define R_CAN0_MKIVLR_MB4_Msk           (0x10UL)       /*!< MB4 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MKIVLR_MB3_Pos           (3UL)          /*!< MB3 (Bit 3)                                           */
 #define R_CAN0_MKIVLR_MB3_Msk           (0x8UL)        /*!< MB3 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MKIVLR_MB2_Pos           (2UL)          /*!< MB2 (Bit 2)                                           */
 #define R_CAN0_MKIVLR_MB2_Msk           (0x4UL)        /*!< MB2 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MKIVLR_MB1_Pos           (1UL)          /*!< MB1 (Bit 1)                                           */
 #define R_CAN0_MKIVLR_MB1_Msk           (0x2UL)        /*!< MB1 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MKIVLR_MB0_Pos           (0UL)          /*!< MB0 (Bit 0)                                           */
 #define R_CAN0_MKIVLR_MB0_Msk           (0x1UL)        /*!< MB0 (Bitfield-Mask: 0x01)                             */
/* =========================================================  MIER  ========================================================== */
 #define R_CAN0_MIER_MB31_Pos            (31UL)         /*!< MB31 (Bit 31)                                         */
 #define R_CAN0_MIER_MB31_Msk            (0x80000000UL) /*!< MB31 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB30_Pos            (30UL)         /*!< MB30 (Bit 30)                                         */
 #define R_CAN0_MIER_MB30_Msk            (0x40000000UL) /*!< MB30 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB29_Pos            (29UL)         /*!< MB29 (Bit 29)                                         */
 #define R_CAN0_MIER_MB29_Msk            (0x20000000UL) /*!< MB29 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB28_Pos            (28UL)         /*!< MB28 (Bit 28)                                         */
 #define R_CAN0_MIER_MB28_Msk            (0x10000000UL) /*!< MB28 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB27_Pos            (27UL)         /*!< MB27 (Bit 27)                                         */
 #define R_CAN0_MIER_MB27_Msk            (0x8000000UL)  /*!< MB27 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB26_Pos            (26UL)         /*!< MB26 (Bit 26)                                         */
 #define R_CAN0_MIER_MB26_Msk            (0x4000000UL)  /*!< MB26 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB25_Pos            (25UL)         /*!< MB25 (Bit 25)                                         */
 #define R_CAN0_MIER_MB25_Msk            (0x2000000UL)  /*!< MB25 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB24_Pos            (24UL)         /*!< MB24 (Bit 24)                                         */
 #define R_CAN0_MIER_MB24_Msk            (0x1000000UL)  /*!< MB24 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB23_Pos            (23UL)         /*!< MB23 (Bit 23)                                         */
 #define R_CAN0_MIER_MB23_Msk            (0x800000UL)   /*!< MB23 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB22_Pos            (22UL)         /*!< MB22 (Bit 22)                                         */
 #define R_CAN0_MIER_MB22_Msk            (0x400000UL)   /*!< MB22 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB21_Pos            (21UL)         /*!< MB21 (Bit 21)                                         */
 #define R_CAN0_MIER_MB21_Msk            (0x200000UL)   /*!< MB21 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB20_Pos            (20UL)         /*!< MB20 (Bit 20)                                         */
 #define R_CAN0_MIER_MB20_Msk            (0x100000UL)   /*!< MB20 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB19_Pos            (19UL)         /*!< MB19 (Bit 19)                                         */
 #define R_CAN0_MIER_MB19_Msk            (0x80000UL)    /*!< MB19 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB18_Pos            (18UL)         /*!< MB18 (Bit 18)                                         */
 #define R_CAN0_MIER_MB18_Msk            (0x40000UL)    /*!< MB18 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB17_Pos            (17UL)         /*!< MB17 (Bit 17)                                         */
 #define R_CAN0_MIER_MB17_Msk            (0x20000UL)    /*!< MB17 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB16_Pos            (16UL)         /*!< MB16 (Bit 16)                                         */
 #define R_CAN0_MIER_MB16_Msk            (0x10000UL)    /*!< MB16 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB15_Pos            (15UL)         /*!< MB15 (Bit 15)                                         */
 #define R_CAN0_MIER_MB15_Msk            (0x8000UL)     /*!< MB15 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB14_Pos            (14UL)         /*!< MB14 (Bit 14)                                         */
 #define R_CAN0_MIER_MB14_Msk            (0x4000UL)     /*!< MB14 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB13_Pos            (13UL)         /*!< MB13 (Bit 13)                                         */
 #define R_CAN0_MIER_MB13_Msk            (0x2000UL)     /*!< MB13 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB12_Pos            (12UL)         /*!< MB12 (Bit 12)                                         */
 #define R_CAN0_MIER_MB12_Msk            (0x1000UL)     /*!< MB12 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB11_Pos            (11UL)         /*!< MB11 (Bit 11)                                         */
 #define R_CAN0_MIER_MB11_Msk            (0x800UL)      /*!< MB11 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB10_Pos            (10UL)         /*!< MB10 (Bit 10)                                         */
 #define R_CAN0_MIER_MB10_Msk            (0x400UL)      /*!< MB10 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_MB9_Pos             (9UL)          /*!< MB9 (Bit 9)                                           */
 #define R_CAN0_MIER_MB9_Msk             (0x200UL)      /*!< MB9 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_MB8_Pos             (8UL)          /*!< MB8 (Bit 8)                                           */
 #define R_CAN0_MIER_MB8_Msk             (0x100UL)      /*!< MB8 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_MB7_Pos             (7UL)          /*!< MB7 (Bit 7)                                           */
 #define R_CAN0_MIER_MB7_Msk             (0x80UL)       /*!< MB7 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_MB6_Pos             (6UL)          /*!< MB6 (Bit 6)                                           */
 #define R_CAN0_MIER_MB6_Msk             (0x40UL)       /*!< MB6 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_MB5_Pos             (5UL)          /*!< MB5 (Bit 5)                                           */
 #define R_CAN0_MIER_MB5_Msk             (0x20UL)       /*!< MB5 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_MB4_Pos             (4UL)          /*!< MB4 (Bit 4)                                           */
 #define R_CAN0_MIER_MB4_Msk             (0x10UL)       /*!< MB4 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_MB3_Pos             (3UL)          /*!< MB3 (Bit 3)                                           */
 #define R_CAN0_MIER_MB3_Msk             (0x8UL)        /*!< MB3 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_MB2_Pos             (2UL)          /*!< MB2 (Bit 2)                                           */
 #define R_CAN0_MIER_MB2_Msk             (0x4UL)        /*!< MB2 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_MB1_Pos             (1UL)          /*!< MB1 (Bit 1)                                           */
 #define R_CAN0_MIER_MB1_Msk             (0x2UL)        /*!< MB1 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_MB0_Pos             (0UL)          /*!< MB0 (Bit 0)                                           */
 #define R_CAN0_MIER_MB0_Msk             (0x1UL)        /*!< MB0 (Bitfield-Mask: 0x01)                             */
/* =======================================================  MIER_FIFO  ======================================================= */
 #define R_CAN0_MIER_FIFO_MB29_Pos       (29UL)         /*!< MB29 (Bit 29)                                         */
 #define R_CAN0_MIER_FIFO_MB29_Msk       (0x20000000UL) /*!< MB29 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB28_Pos       (28UL)         /*!< MB28 (Bit 28)                                         */
 #define R_CAN0_MIER_FIFO_MB28_Msk       (0x10000000UL) /*!< MB28 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB25_Pos       (25UL)         /*!< MB25 (Bit 25)                                         */
 #define R_CAN0_MIER_FIFO_MB25_Msk       (0x2000000UL)  /*!< MB25 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB24_Pos       (24UL)         /*!< MB24 (Bit 24)                                         */
 #define R_CAN0_MIER_FIFO_MB24_Msk       (0x1000000UL)  /*!< MB24 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB23_Pos       (23UL)         /*!< MB23 (Bit 23)                                         */
 #define R_CAN0_MIER_FIFO_MB23_Msk       (0x800000UL)   /*!< MB23 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB22_Pos       (22UL)         /*!< MB22 (Bit 22)                                         */
 #define R_CAN0_MIER_FIFO_MB22_Msk       (0x400000UL)   /*!< MB22 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB21_Pos       (21UL)         /*!< MB21 (Bit 21)                                         */
 #define R_CAN0_MIER_FIFO_MB21_Msk       (0x200000UL)   /*!< MB21 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB20_Pos       (20UL)         /*!< MB20 (Bit 20)                                         */
 #define R_CAN0_MIER_FIFO_MB20_Msk       (0x100000UL)   /*!< MB20 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB19_Pos       (19UL)         /*!< MB19 (Bit 19)                                         */
 #define R_CAN0_MIER_FIFO_MB19_Msk       (0x80000UL)    /*!< MB19 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB18_Pos       (18UL)         /*!< MB18 (Bit 18)                                         */
 #define R_CAN0_MIER_FIFO_MB18_Msk       (0x40000UL)    /*!< MB18 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB17_Pos       (17UL)         /*!< MB17 (Bit 17)                                         */
 #define R_CAN0_MIER_FIFO_MB17_Msk       (0x20000UL)    /*!< MB17 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB16_Pos       (16UL)         /*!< MB16 (Bit 16)                                         */
 #define R_CAN0_MIER_FIFO_MB16_Msk       (0x10000UL)    /*!< MB16 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB15_Pos       (15UL)         /*!< MB15 (Bit 15)                                         */
 #define R_CAN0_MIER_FIFO_MB15_Msk       (0x8000UL)     /*!< MB15 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB14_Pos       (14UL)         /*!< MB14 (Bit 14)                                         */
 #define R_CAN0_MIER_FIFO_MB14_Msk       (0x4000UL)     /*!< MB14 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB13_Pos       (13UL)         /*!< MB13 (Bit 13)                                         */
 #define R_CAN0_MIER_FIFO_MB13_Msk       (0x2000UL)     /*!< MB13 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB12_Pos       (12UL)         /*!< MB12 (Bit 12)                                         */
 #define R_CAN0_MIER_FIFO_MB12_Msk       (0x1000UL)     /*!< MB12 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB11_Pos       (11UL)         /*!< MB11 (Bit 11)                                         */
 #define R_CAN0_MIER_FIFO_MB11_Msk       (0x800UL)      /*!< MB11 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB10_Pos       (10UL)         /*!< MB10 (Bit 10)                                         */
 #define R_CAN0_MIER_FIFO_MB10_Msk       (0x400UL)      /*!< MB10 (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MIER_FIFO_MB9_Pos        (9UL)          /*!< MB9 (Bit 9)                                           */
 #define R_CAN0_MIER_FIFO_MB9_Msk        (0x200UL)      /*!< MB9 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_FIFO_MB8_Pos        (8UL)          /*!< MB8 (Bit 8)                                           */
 #define R_CAN0_MIER_FIFO_MB8_Msk        (0x100UL)      /*!< MB8 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_FIFO_MB7_Pos        (7UL)          /*!< MB7 (Bit 7)                                           */
 #define R_CAN0_MIER_FIFO_MB7_Msk        (0x80UL)       /*!< MB7 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_FIFO_MB6_Pos        (6UL)          /*!< MB6 (Bit 6)                                           */
 #define R_CAN0_MIER_FIFO_MB6_Msk        (0x40UL)       /*!< MB6 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_FIFO_MB5_Pos        (5UL)          /*!< MB5 (Bit 5)                                           */
 #define R_CAN0_MIER_FIFO_MB5_Msk        (0x20UL)       /*!< MB5 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_FIFO_MB4_Pos        (4UL)          /*!< MB4 (Bit 4)                                           */
 #define R_CAN0_MIER_FIFO_MB4_Msk        (0x10UL)       /*!< MB4 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_FIFO_MB3_Pos        (3UL)          /*!< MB3 (Bit 3)                                           */
 #define R_CAN0_MIER_FIFO_MB3_Msk        (0x8UL)        /*!< MB3 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_FIFO_MB2_Pos        (2UL)          /*!< MB2 (Bit 2)                                           */
 #define R_CAN0_MIER_FIFO_MB2_Msk        (0x4UL)        /*!< MB2 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_FIFO_MB1_Pos        (1UL)          /*!< MB1 (Bit 1)                                           */
 #define R_CAN0_MIER_FIFO_MB1_Msk        (0x2UL)        /*!< MB1 (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_MIER_FIFO_MB0_Pos        (0UL)          /*!< MB0 (Bit 0)                                           */
 #define R_CAN0_MIER_FIFO_MB0_Msk        (0x1UL)        /*!< MB0 (Bitfield-Mask: 0x01)                             */
/* ========================================================  MCTL_TX  ======================================================== */
 #define R_CAN0_MCTL_TX_TRMREQ_Pos       (7UL)          /*!< TRMREQ (Bit 7)                                        */
 #define R_CAN0_MCTL_TX_TRMREQ_Msk       (0x80UL)       /*!< TRMREQ (Bitfield-Mask: 0x01)                          */
 #define R_CAN0_MCTL_TX_RECREQ_Pos       (6UL)          /*!< RECREQ (Bit 6)                                        */
 #define R_CAN0_MCTL_TX_RECREQ_Msk       (0x40UL)       /*!< RECREQ (Bitfield-Mask: 0x01)                          */
 #define R_CAN0_MCTL_TX_ONESHOT_Pos      (4UL)          /*!< ONESHOT (Bit 4)                                       */
 #define R_CAN0_MCTL_TX_ONESHOT_Msk      (0x10UL)       /*!< ONESHOT (Bitfield-Mask: 0x01)                         */
 #define R_CAN0_MCTL_TX_TRMABT_Pos       (2UL)          /*!< TRMABT (Bit 2)                                        */
 #define R_CAN0_MCTL_TX_TRMABT_Msk       (0x4UL)        /*!< TRMABT (Bitfield-Mask: 0x01)                          */
 #define R_CAN0_MCTL_TX_TRMACTIVE_Pos    (1UL)          /*!< TRMACTIVE (Bit 1)                                     */
 #define R_CAN0_MCTL_TX_TRMACTIVE_Msk    (0x2UL)        /*!< TRMACTIVE (Bitfield-Mask: 0x01)                       */
 #define R_CAN0_MCTL_TX_SENTDATA_Pos     (0UL)          /*!< SENTDATA (Bit 0)                                      */
 #define R_CAN0_MCTL_TX_SENTDATA_Msk     (0x1UL)        /*!< SENTDATA (Bitfield-Mask: 0x01)                        */
/* ========================================================  MCTL_RX  ======================================================== */
 #define R_CAN0_MCTL_RX_TRMREQ_Pos       (7UL)          /*!< TRMREQ (Bit 7)                                        */
 #define R_CAN0_MCTL_RX_TRMREQ_Msk       (0x80UL)       /*!< TRMREQ (Bitfield-Mask: 0x01)                          */
 #define R_CAN0_MCTL_RX_RECREQ_Pos       (6UL)          /*!< RECREQ (Bit 6)                                        */
 #define R_CAN0_MCTL_RX_RECREQ_Msk       (0x40UL)       /*!< RECREQ (Bitfield-Mask: 0x01)                          */
 #define R_CAN0_MCTL_RX_ONESHOT_Pos      (4UL)          /*!< ONESHOT (Bit 4)                                       */
 #define R_CAN0_MCTL_RX_ONESHOT_Msk      (0x10UL)       /*!< ONESHOT (Bitfield-Mask: 0x01)                         */
 #define R_CAN0_MCTL_RX_MSGLOST_Pos      (2UL)          /*!< MSGLOST (Bit 2)                                       */
 #define R_CAN0_MCTL_RX_MSGLOST_Msk      (0x4UL)        /*!< MSGLOST (Bitfield-Mask: 0x01)                         */
 #define R_CAN0_MCTL_RX_INVALDATA_Pos    (1UL)          /*!< INVALDATA (Bit 1)                                     */
 #define R_CAN0_MCTL_RX_INVALDATA_Msk    (0x2UL)        /*!< INVALDATA (Bitfield-Mask: 0x01)                       */
 #define R_CAN0_MCTL_RX_NEWDATA_Pos      (0UL)          /*!< NEWDATA (Bit 0)                                       */
 #define R_CAN0_MCTL_RX_NEWDATA_Msk      (0x1UL)        /*!< NEWDATA (Bitfield-Mask: 0x01)                         */
/* =========================================================  CTLR  ========================================================== */
 #define R_CAN0_CTLR_RBOC_Pos            (13UL)         /*!< RBOC (Bit 13)                                         */
 #define R_CAN0_CTLR_RBOC_Msk            (0x2000UL)     /*!< RBOC (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_CTLR_BOM_Pos             (11UL)         /*!< BOM (Bit 11)                                          */
 #define R_CAN0_CTLR_BOM_Msk             (0x1800UL)     /*!< BOM (Bitfield-Mask: 0x03)                             */
 #define R_CAN0_CTLR_SLPM_Pos            (10UL)         /*!< SLPM (Bit 10)                                         */
 #define R_CAN0_CTLR_SLPM_Msk            (0x400UL)      /*!< SLPM (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_CTLR_CANM_Pos            (8UL)          /*!< CANM (Bit 8)                                          */
 #define R_CAN0_CTLR_CANM_Msk            (0x300UL)      /*!< CANM (Bitfield-Mask: 0x03)                            */
 #define R_CAN0_CTLR_TSPS_Pos            (6UL)          /*!< TSPS (Bit 6)                                          */
 #define R_CAN0_CTLR_TSPS_Msk            (0xc0UL)       /*!< TSPS (Bitfield-Mask: 0x03)                            */
 #define R_CAN0_CTLR_TSRC_Pos            (5UL)          /*!< TSRC (Bit 5)                                          */
 #define R_CAN0_CTLR_TSRC_Msk            (0x20UL)       /*!< TSRC (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_CTLR_TPM_Pos             (4UL)          /*!< TPM (Bit 4)                                           */
 #define R_CAN0_CTLR_TPM_Msk             (0x10UL)       /*!< TPM (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_CTLR_MLM_Pos             (3UL)          /*!< MLM (Bit 3)                                           */
 #define R_CAN0_CTLR_MLM_Msk             (0x8UL)        /*!< MLM (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_CTLR_IDFM_Pos            (1UL)          /*!< IDFM (Bit 1)                                          */
 #define R_CAN0_CTLR_IDFM_Msk            (0x6UL)        /*!< IDFM (Bitfield-Mask: 0x03)                            */
 #define R_CAN0_CTLR_MBM_Pos             (0UL)          /*!< MBM (Bit 0)                                           */
 #define R_CAN0_CTLR_MBM_Msk             (0x1UL)        /*!< MBM (Bitfield-Mask: 0x01)                             */
/* ==========================================================  STR  ========================================================== */
 #define R_CAN0_STR_RECST_Pos            (14UL)         /*!< RECST (Bit 14)                                        */
 #define R_CAN0_STR_RECST_Msk            (0x4000UL)     /*!< RECST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_STR_TRMST_Pos            (13UL)         /*!< TRMST (Bit 13)                                        */
 #define R_CAN0_STR_TRMST_Msk            (0x2000UL)     /*!< TRMST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_STR_BOST_Pos             (12UL)         /*!< BOST (Bit 12)                                         */
 #define R_CAN0_STR_BOST_Msk             (0x1000UL)     /*!< BOST (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_STR_EPST_Pos             (11UL)         /*!< EPST (Bit 11)                                         */
 #define R_CAN0_STR_EPST_Msk             (0x800UL)      /*!< EPST (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_STR_SLPST_Pos            (10UL)         /*!< SLPST (Bit 10)                                        */
 #define R_CAN0_STR_SLPST_Msk            (0x400UL)      /*!< SLPST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_STR_HLTST_Pos            (9UL)          /*!< HLTST (Bit 9)                                         */
 #define R_CAN0_STR_HLTST_Msk            (0x200UL)      /*!< HLTST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_STR_RSTST_Pos            (8UL)          /*!< RSTST (Bit 8)                                         */
 #define R_CAN0_STR_RSTST_Msk            (0x100UL)      /*!< RSTST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_STR_EST_Pos              (7UL)          /*!< EST (Bit 7)                                           */
 #define R_CAN0_STR_EST_Msk              (0x80UL)       /*!< EST (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_STR_TABST_Pos            (6UL)          /*!< TABST (Bit 6)                                         */
 #define R_CAN0_STR_TABST_Msk            (0x40UL)       /*!< TABST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_STR_FMLST_Pos            (5UL)          /*!< FMLST (Bit 5)                                         */
 #define R_CAN0_STR_FMLST_Msk            (0x20UL)       /*!< FMLST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_STR_NMLST_Pos            (4UL)          /*!< NMLST (Bit 4)                                         */
 #define R_CAN0_STR_NMLST_Msk            (0x10UL)       /*!< NMLST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_STR_TFST_Pos             (3UL)          /*!< TFST (Bit 3)                                          */
 #define R_CAN0_STR_TFST_Msk             (0x8UL)        /*!< TFST (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_STR_RFST_Pos             (2UL)          /*!< RFST (Bit 2)                                          */
 #define R_CAN0_STR_RFST_Msk             (0x4UL)        /*!< RFST (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_STR_SDST_Pos             (1UL)          /*!< SDST (Bit 1)                                          */
 #define R_CAN0_STR_SDST_Msk             (0x2UL)        /*!< SDST (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_STR_NDST_Pos             (0UL)          /*!< NDST (Bit 0)                                          */
 #define R_CAN0_STR_NDST_Msk             (0x1UL)        /*!< NDST (Bitfield-Mask: 0x01)                            */
/* ==========================================================  BCR  ========================================================== */
 #define R_CAN0_BCR_TSEG1_Pos            (28UL)         /*!< TSEG1 (Bit 28)                                        */
 #define R_CAN0_BCR_TSEG1_Msk            (0xf0000000UL) /*!< TSEG1 (Bitfield-Mask: 0x0f)                           */
 #define R_CAN0_BCR_BRP_Pos              (16UL)         /*!< BRP (Bit 16)                                          */
 #define R_CAN0_BCR_BRP_Msk              (0x3ff0000UL)  /*!< BRP (Bitfield-Mask: 0x3ff)                            */
 #define R_CAN0_BCR_SJW_Pos              (12UL)         /*!< SJW (Bit 12)                                          */
 #define R_CAN0_BCR_SJW_Msk              (0x3000UL)     /*!< SJW (Bitfield-Mask: 0x03)                             */
 #define R_CAN0_BCR_TSEG2_Pos            (8UL)          /*!< TSEG2 (Bit 8)                                         */
 #define R_CAN0_BCR_TSEG2_Msk            (0x700UL)      /*!< TSEG2 (Bitfield-Mask: 0x07)                           */
 #define R_CAN0_BCR_CCLKS_Pos            (0UL)          /*!< CCLKS (Bit 0)                                         */
 #define R_CAN0_BCR_CCLKS_Msk            (0x1UL)        /*!< CCLKS (Bitfield-Mask: 0x01)                           */
/* =========================================================  RFCR  ========================================================== */
 #define R_CAN0_RFCR_RFEST_Pos           (7UL)          /*!< RFEST (Bit 7)                                         */
 #define R_CAN0_RFCR_RFEST_Msk           (0x80UL)       /*!< RFEST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_RFCR_RFWST_Pos           (6UL)          /*!< RFWST (Bit 6)                                         */
 #define R_CAN0_RFCR_RFWST_Msk           (0x40UL)       /*!< RFWST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_RFCR_RFFST_Pos           (5UL)          /*!< RFFST (Bit 5)                                         */
 #define R_CAN0_RFCR_RFFST_Msk           (0x20UL)       /*!< RFFST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_RFCR_RFMLF_Pos           (4UL)          /*!< RFMLF (Bit 4)                                         */
 #define R_CAN0_RFCR_RFMLF_Msk           (0x10UL)       /*!< RFMLF (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_RFCR_RFUST_Pos           (1UL)          /*!< RFUST (Bit 1)                                         */
 #define R_CAN0_RFCR_RFUST_Msk           (0xeUL)        /*!< RFUST (Bitfield-Mask: 0x07)                           */
 #define R_CAN0_RFCR_RFE_Pos             (0UL)          /*!< RFE (Bit 0)                                           */
 #define R_CAN0_RFCR_RFE_Msk             (0x1UL)        /*!< RFE (Bitfield-Mask: 0x01)                             */
/* =========================================================  RFPCR  ========================================================= */
 #define R_CAN0_RFPCR_RFPCR_Pos          (0UL)          /*!< RFPCR (Bit 0)                                         */
 #define R_CAN0_RFPCR_RFPCR_Msk          (0xffUL)       /*!< RFPCR (Bitfield-Mask: 0xff)                           */
/* =========================================================  TFCR  ========================================================== */
 #define R_CAN0_TFCR_TFEST_Pos           (7UL)          /*!< TFEST (Bit 7)                                         */
 #define R_CAN0_TFCR_TFEST_Msk           (0x80UL)       /*!< TFEST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_TFCR_TFFST_Pos           (6UL)          /*!< TFFST (Bit 6)                                         */
 #define R_CAN0_TFCR_TFFST_Msk           (0x40UL)       /*!< TFFST (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_TFCR_TFUST_Pos           (1UL)          /*!< TFUST (Bit 1)                                         */
 #define R_CAN0_TFCR_TFUST_Msk           (0xeUL)        /*!< TFUST (Bitfield-Mask: 0x07)                           */
 #define R_CAN0_TFCR_TFE_Pos             (0UL)          /*!< TFE (Bit 0)                                           */
 #define R_CAN0_TFCR_TFE_Msk             (0x1UL)        /*!< TFE (Bitfield-Mask: 0x01)                             */
/* =========================================================  TFPCR  ========================================================= */
 #define R_CAN0_TFPCR_TFPCR_Pos          (0UL)          /*!< TFPCR (Bit 0)                                         */
 #define R_CAN0_TFPCR_TFPCR_Msk          (0xffUL)       /*!< TFPCR (Bitfield-Mask: 0xff)                           */
/* =========================================================  EIER  ========================================================== */
 #define R_CAN0_EIER_BLIE_Pos            (7UL)          /*!< BLIE (Bit 7)                                          */
 #define R_CAN0_EIER_BLIE_Msk            (0x80UL)       /*!< BLIE (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIER_OLIE_Pos            (6UL)          /*!< OLIE (Bit 6)                                          */
 #define R_CAN0_EIER_OLIE_Msk            (0x40UL)       /*!< OLIE (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIER_ORIE_Pos            (5UL)          /*!< ORIE (Bit 5)                                          */
 #define R_CAN0_EIER_ORIE_Msk            (0x20UL)       /*!< ORIE (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIER_BORIE_Pos           (4UL)          /*!< BORIE (Bit 4)                                         */
 #define R_CAN0_EIER_BORIE_Msk           (0x10UL)       /*!< BORIE (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_EIER_BOEIE_Pos           (3UL)          /*!< BOEIE (Bit 3)                                         */
 #define R_CAN0_EIER_BOEIE_Msk           (0x8UL)        /*!< BOEIE (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_EIER_EPIE_Pos            (2UL)          /*!< EPIE (Bit 2)                                          */
 #define R_CAN0_EIER_EPIE_Msk            (0x4UL)        /*!< EPIE (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIER_EWIE_Pos            (1UL)          /*!< EWIE (Bit 1)                                          */
 #define R_CAN0_EIER_EWIE_Msk            (0x2UL)        /*!< EWIE (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIER_BEIE_Pos            (0UL)          /*!< BEIE (Bit 0)                                          */
 #define R_CAN0_EIER_BEIE_Msk            (0x1UL)        /*!< BEIE (Bitfield-Mask: 0x01)                            */
/* =========================================================  EIFR  ========================================================== */
 #define R_CAN0_EIFR_BLIF_Pos            (7UL)          /*!< BLIF (Bit 7)                                          */
 #define R_CAN0_EIFR_BLIF_Msk            (0x80UL)       /*!< BLIF (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIFR_OLIF_Pos            (6UL)          /*!< OLIF (Bit 6)                                          */
 #define R_CAN0_EIFR_OLIF_Msk            (0x40UL)       /*!< OLIF (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIFR_ORIF_Pos            (5UL)          /*!< ORIF (Bit 5)                                          */
 #define R_CAN0_EIFR_ORIF_Msk            (0x20UL)       /*!< ORIF (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIFR_BORIF_Pos           (4UL)          /*!< BORIF (Bit 4)                                         */
 #define R_CAN0_EIFR_BORIF_Msk           (0x10UL)       /*!< BORIF (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_EIFR_BOEIF_Pos           (3UL)          /*!< BOEIF (Bit 3)                                         */
 #define R_CAN0_EIFR_BOEIF_Msk           (0x8UL)        /*!< BOEIF (Bitfield-Mask: 0x01)                           */
 #define R_CAN0_EIFR_EPIF_Pos            (2UL)          /*!< EPIF (Bit 2)                                          */
 #define R_CAN0_EIFR_EPIF_Msk            (0x4UL)        /*!< EPIF (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIFR_EWIF_Pos            (1UL)          /*!< EWIF (Bit 1)                                          */
 #define R_CAN0_EIFR_EWIF_Msk            (0x2UL)        /*!< EWIF (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_EIFR_BEIF_Pos            (0UL)          /*!< BEIF (Bit 0)                                          */
 #define R_CAN0_EIFR_BEIF_Msk            (0x1UL)        /*!< BEIF (Bitfield-Mask: 0x01)                            */
/* =========================================================  RECR  ========================================================== */
 #define R_CAN0_RECR_RECR_Pos            (0UL)          /*!< RECR (Bit 0)                                          */
 #define R_CAN0_RECR_RECR_Msk            (0xffUL)       /*!< RECR (Bitfield-Mask: 0xff)                            */
/* =========================================================  TECR  ========================================================== */
 #define R_CAN0_TECR_TECR_Pos            (0UL)          /*!< TECR (Bit 0)                                          */
 #define R_CAN0_TECR_TECR_Msk            (0xffUL)       /*!< TECR (Bitfield-Mask: 0xff)                            */
/* =========================================================  ECSR  ========================================================== */
 #define R_CAN0_ECSR_EDPM_Pos            (7UL)          /*!< EDPM (Bit 7)                                          */
 #define R_CAN0_ECSR_EDPM_Msk            (0x80UL)       /*!< EDPM (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_ECSR_ADEF_Pos            (6UL)          /*!< ADEF (Bit 6)                                          */
 #define R_CAN0_ECSR_ADEF_Msk            (0x40UL)       /*!< ADEF (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_ECSR_BE0F_Pos            (5UL)          /*!< BE0F (Bit 5)                                          */
 #define R_CAN0_ECSR_BE0F_Msk            (0x20UL)       /*!< BE0F (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_ECSR_BE1F_Pos            (4UL)          /*!< BE1F (Bit 4)                                          */
 #define R_CAN0_ECSR_BE1F_Msk            (0x10UL)       /*!< BE1F (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_ECSR_CEF_Pos             (3UL)          /*!< CEF (Bit 3)                                           */
 #define R_CAN0_ECSR_CEF_Msk             (0x8UL)        /*!< CEF (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_ECSR_AEF_Pos             (2UL)          /*!< AEF (Bit 2)                                           */
 #define R_CAN0_ECSR_AEF_Msk             (0x4UL)        /*!< AEF (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_ECSR_FEF_Pos             (1UL)          /*!< FEF (Bit 1)                                           */
 #define R_CAN0_ECSR_FEF_Msk             (0x2UL)        /*!< FEF (Bitfield-Mask: 0x01)                             */
 #define R_CAN0_ECSR_SEF_Pos             (0UL)          /*!< SEF (Bit 0)                                           */
 #define R_CAN0_ECSR_SEF_Msk             (0x1UL)        /*!< SEF (Bitfield-Mask: 0x01)                             */
/* =========================================================  CSSR  ========================================================== */
 #define R_CAN0_CSSR_CSSR_Pos            (0UL)          /*!< CSSR (Bit 0)                                          */
 #define R_CAN0_CSSR_CSSR_Msk            (0xffUL)       /*!< CSSR (Bitfield-Mask: 0xff)                            */
/* =========================================================  MSSR  ========================================================== */
 #define R_CAN0_MSSR_SEST_Pos            (7UL)          /*!< SEST (Bit 7)                                          */
 #define R_CAN0_MSSR_SEST_Msk            (0x80UL)       /*!< SEST (Bitfield-Mask: 0x01)                            */
 #define R_CAN0_MSSR_MBNST_Pos           (0UL)          /*!< MBNST (Bit 0)                                         */
 #define R_CAN0_MSSR_MBNST_Msk           (0x1fUL)       /*!< MBNST (Bitfield-Mask: 0x1f)                           */
/* =========================================================  MSMR  ========================================================== */
 #define R_CAN0_MSMR_MBSM_Pos            (0UL)          /*!< MBSM (Bit 0)                                          */
 #define R_CAN0_MSMR_MBSM_Msk            (0x3UL)        /*!< MBSM (Bitfield-Mask: 0x03)                            */
/* ==========================================================  TSR  ========================================================== */
 #define R_CAN0_TSR_TSR_Pos              (0UL)          /*!< TSR (Bit 0)                                           */
 #define R_CAN0_TSR_TSR_Msk              (0xffffUL)     /*!< TSR (Bitfield-Mask: 0xffff)                           */
/* =========================================================  AFSR  ========================================================== */
 #define R_CAN0_AFSR_AFSR_Pos            (0UL)          /*!< AFSR (Bit 0)                                          */
 #define R_CAN0_AFSR_AFSR_Msk            (0xffffUL)     /*!< AFSR (Bitfield-Mask: 0xffff)                          */
/* ==========================================================  TCR  ========================================================== */
 #define R_CAN0_TCR_TSTM_Pos             (1UL)          /*!< TSTM (Bit 1)                                          */
 #define R_CAN0_TCR_TSTM_Msk             (0x6UL)        /*!< TSTM (Bitfield-Mask: 0x03)                            */
 #define R_CAN0_TCR_TSTE_Pos             (0UL)          /*!< TSTE (Bit 0)                                          */
 #define R_CAN0_TCR_TSTE_Msk             (0x1UL)        /*!< TSTE (Bitfield-Mask: 0x01)                            */

/* =========================================================================================================================== */
/* ================                                           R_CRC                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  CRCCR0  ========================================================= */
 #define R_CRC_CRCCR0_DORCLR_Pos          (7UL)          /*!< DORCLR (Bit 7)                                        */
 #define R_CRC_CRCCR0_DORCLR_Msk          (0x80UL)       /*!< DORCLR (Bitfield-Mask: 0x01)                          */
 #define R_CRC_CRCCR0_LMS_Pos             (6UL)          /*!< LMS (Bit 6)                                           */
 #define R_CRC_CRCCR0_LMS_Msk             (0x40UL)       /*!< LMS (Bitfield-Mask: 0x01)                             */
 #define R_CRC_CRCCR0_GPS_Pos             (0UL)          /*!< GPS (Bit 0)                                           */
 #define R_CRC_CRCCR0_GPS_Msk             (0x7UL)        /*!< GPS (Bitfield-Mask: 0x07)                             */
/* ========================================================  CRCCR1  ========================================================= */
 #define R_CRC_CRCCR1_CRCSEN_Pos          (7UL)          /*!< CRCSEN (Bit 7)                                        */
 #define R_CRC_CRCCR1_CRCSEN_Msk          (0x80UL)       /*!< CRCSEN (Bitfield-Mask: 0x01)                          */
 #define R_CRC_CRCCR1_CRCSWR_Pos          (6UL)          /*!< CRCSWR (Bit 6)                                        */
 #define R_CRC_CRCCR1_CRCSWR_Msk          (0x40UL)       /*!< CRCSWR (Bitfield-Mask: 0x01)                          */
/* ========================================================  CRCDIR  ========================================================= */
 #define R_CRC_CRCDIR_CRCDIR_Pos          (0UL)          /*!< CRCDIR (Bit 0)                                        */
 #define R_CRC_CRCDIR_CRCDIR_Msk          (0xffffffffUL) /*!< CRCDIR (Bitfield-Mask: 0xffffffff)                    */
/* =======================================================  CRCDIR_BY  ======================================================= */
 #define R_CRC_CRCDIR_BY_CRCDIR_BY_Pos    (0UL)          /*!< CRCDIR_BY (Bit 0)                                     */
 #define R_CRC_CRCDIR_BY_CRCDIR_BY_Msk    (0xffUL)       /*!< CRCDIR_BY (Bitfield-Mask: 0xff)                       */
/* ========================================================  CRCDOR  ========================================================= */
 #define R_CRC_CRCDOR_CRCDOR_Pos          (0UL)          /*!< CRCDOR (Bit 0)                                        */
 #define R_CRC_CRCDOR_CRCDOR_Msk          (0xffffffffUL) /*!< CRCDOR (Bitfield-Mask: 0xffffffff)                    */
/* =======================================================  CRCDOR_HA  ======================================================= */
 #define R_CRC_CRCDOR_HA_CRCDOR_HA_Pos    (0UL)          /*!< CRCDOR_HA (Bit 0)                                     */
 #define R_CRC_CRCDOR_HA_CRCDOR_HA_Msk    (0xffffUL)     /*!< CRCDOR_HA (Bitfield-Mask: 0xffff)                     */
/* =======================================================  CRCDOR_BY  ======================================================= */
 #define R_CRC_CRCDOR_BY_CRCDOR_BY_Pos    (0UL)          /*!< CRCDOR_BY (Bit 0)                                     */
 #define R_CRC_CRCDOR_BY_CRCDOR_BY_Msk    (0xffUL)       /*!< CRCDOR_BY (Bitfield-Mask: 0xff)                       */
/* ========================================================  CRCSAR  ========================================================= */
 #define R_CRC_CRCSAR_CRCSA_Pos           (0UL)          /*!< CRCSA (Bit 0)                                         */
 #define R_CRC_CRCSAR_CRCSA_Msk           (0x3fffUL)     /*!< CRCSA (Bitfield-Mask: 0x3fff)                         */

/* =========================================================================================================================== */
/* ================                                          R_CTSU2                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  CTSUCRA  ======================================================== */
 #define R_CTSU2_CTSUCRA_STRT_Pos      (0UL)          /*!< STRT (Bit 0)                                          */
 #define R_CTSU2_CTSUCRA_STRT_Msk      (0x1UL)        /*!< STRT (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUCRA_CAP_Pos       (1UL)          /*!< CAP (Bit 1)                                           */
 #define R_CTSU2_CTSUCRA_CAP_Msk       (0x2UL)        /*!< CAP (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUCRA_SNZ_Pos       (2UL)          /*!< SNZ (Bit 2)                                           */
 #define R_CTSU2_CTSUCRA_SNZ_Msk       (0x4UL)        /*!< SNZ (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUCRA_CFCON_Pos     (3UL)          /*!< CFCON (Bit 3)                                         */
 #define R_CTSU2_CTSUCRA_CFCON_Msk     (0x8UL)        /*!< CFCON (Bitfield-Mask: 0x01)                           */
 #define R_CTSU2_CTSUCRA_INIT_Pos      (4UL)          /*!< INIT (Bit 4)                                          */
 #define R_CTSU2_CTSUCRA_INIT_Msk      (0x10UL)       /*!< INIT (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUCRA_PUMPON_Pos    (5UL)          /*!< PUMPON (Bit 5)                                        */
 #define R_CTSU2_CTSUCRA_PUMPON_Msk    (0x20UL)       /*!< PUMPON (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCRA_TXVSEL_Pos    (6UL)          /*!< TXVSEL (Bit 6)                                        */
 #define R_CTSU2_CTSUCRA_TXVSEL_Msk    (0xc0UL)       /*!< TXVSEL (Bitfield-Mask: 0x03)                          */
 #define R_CTSU2_CTSUCRA_PON_Pos       (8UL)          /*!< PON (Bit 8)                                           */
 #define R_CTSU2_CTSUCRA_PON_Msk       (0x100UL)      /*!< PON (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUCRA_CSW_Pos       (9UL)          /*!< CSW (Bit 9)                                           */
 #define R_CTSU2_CTSUCRA_CSW_Msk       (0x200UL)      /*!< CSW (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUCRA_ATUNE0_Pos    (10UL)         /*!< ATUNE0 (Bit 10)                                       */
 #define R_CTSU2_CTSUCRA_ATUNE0_Msk    (0x400UL)      /*!< ATUNE0 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCRA_ATUNE1_Pos    (11UL)         /*!< ATUNE1 (Bit 11)                                       */
 #define R_CTSU2_CTSUCRA_ATUNE1_Msk    (0x800UL)      /*!< ATUNE1 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCRA_CLK_Pos       (12UL)         /*!< CLK (Bit 12)                                          */
 #define R_CTSU2_CTSUCRA_CLK_Msk       (0x3000UL)     /*!< CLK (Bitfield-Mask: 0x03)                             */
 #define R_CTSU2_CTSUCRA_MD0_Pos       (14UL)         /*!< MD0 (Bit 14)                                          */
 #define R_CTSU2_CTSUCRA_MD0_Msk       (0x4000UL)     /*!< MD0 (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUCRA_MD1_Pos       (15UL)         /*!< MD1 (Bit 15)                                          */
 #define R_CTSU2_CTSUCRA_MD1_Msk       (0x8000UL)     /*!< MD1 (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUCRA_MD2_Pos       (16UL)         /*!< MD2 (Bit 16)                                          */
 #define R_CTSU2_CTSUCRA_MD2_Msk       (0x10000UL)    /*!< MD2 (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUCRA_ATUNE2_Pos    (17UL)         /*!< ATUNE2 (Bit 17)                                       */
 #define R_CTSU2_CTSUCRA_ATUNE2_Msk    (0x20000UL)    /*!< ATUNE2 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCRA_LOAD_Pos      (18UL)         /*!< LOAD (Bit 18)                                         */
 #define R_CTSU2_CTSUCRA_LOAD_Msk      (0xc0000UL)    /*!< LOAD (Bitfield-Mask: 0x03)                            */
 #define R_CTSU2_CTSUCRA_POSEL_Pos     (20UL)         /*!< POSEL (Bit 20)                                        */
 #define R_CTSU2_CTSUCRA_POSEL_Msk     (0x300000UL)   /*!< POSEL (Bitfield-Mask: 0x03)                           */
 #define R_CTSU2_CTSUCRA_SDPSEL_Pos    (22UL)         /*!< SDPSEL (Bit 22)                                       */
 #define R_CTSU2_CTSUCRA_SDPSEL_Msk    (0x400000UL)   /*!< SDPSEL (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCRA_PCSEL_Pos     (23UL)         /*!< PCSEL (Bit 23)                                        */
 #define R_CTSU2_CTSUCRA_PCSEL_Msk     (0x800000UL)   /*!< PCSEL (Bitfield-Mask: 0x01)                           */
 #define R_CTSU2_CTSUCRA_STCLK_Pos     (24UL)         /*!< STCLK (Bit 24)                                        */
 #define R_CTSU2_CTSUCRA_STCLK_Msk     (0x3f000000UL) /*!< STCLK (Bitfield-Mask: 0x3f)                           */
 #define R_CTSU2_CTSUCRA_DCMODE_Pos    (30UL)         /*!< DCMODE (Bit 30)                                       */
 #define R_CTSU2_CTSUCRA_DCMODE_Msk    (0x40000000UL) /*!< DCMODE (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCRA_DCBACK_Pos    (31UL)         /*!< DCBACK (Bit 31)                                       */
 #define R_CTSU2_CTSUCRA_DCBACK_Msk    (0x80000000UL) /*!< DCBACK (Bitfield-Mask: 0x01)                          */
/* =======================================================  CTSUCRAL  ======================================================== */
/* ========================================================  CTSUCR0  ======================================================== */
/* ========================================================  CTSUCR1  ======================================================== */
/* =======================================================  CTSUCRAH  ======================================================== */
/* ========================================================  CTSUCR2  ======================================================== */
/* ========================================================  CTSUCR3  ======================================================== */
/* ========================================================  CTSUCRB  ======================================================== */
 #define R_CTSU2_CTSUCRB_PRRATIO_Pos    (0UL)          /*!< PRRATIO (Bit 0)                                       */
 #define R_CTSU2_CTSUCRB_PRRATIO_Msk    (0xfUL)        /*!< PRRATIO (Bitfield-Mask: 0x0f)                         */
 #define R_CTSU2_CTSUCRB_PRMODE_Pos     (4UL)          /*!< PRMODE (Bit 4)                                        */
 #define R_CTSU2_CTSUCRB_PRMODE_Msk     (0x30UL)       /*!< PRMODE (Bitfield-Mask: 0x03)                          */
 #define R_CTSU2_CTSUCRB_SOFF_Pos       (6UL)          /*!< SOFF (Bit 6)                                          */
 #define R_CTSU2_CTSUCRB_SOFF_Msk       (0x40UL)       /*!< SOFF (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUCRB_PROFF_Pos      (7UL)          /*!< PROFF (Bit 7)                                         */
 #define R_CTSU2_CTSUCRB_PROFF_Msk      (0x80UL)       /*!< PROFF (Bitfield-Mask: 0x01)                           */
 #define R_CTSU2_CTSUCRB_SST_Pos        (8UL)          /*!< SST (Bit 8)                                           */
 #define R_CTSU2_CTSUCRB_SST_Msk        (0xff00UL)     /*!< SST (Bitfield-Mask: 0xff)                             */
 #define R_CTSU2_CTSUCRB_SSMOD_Pos      (24UL)         /*!< SSMOD (Bit 24)                                        */
 #define R_CTSU2_CTSUCRB_SSMOD_Msk      (0x7000000UL)  /*!< SSMOD (Bitfield-Mask: 0x07)                           */
 #define R_CTSU2_CTSUCRB_SSCNT_Pos      (28UL)         /*!< SSCNT (Bit 28)                                        */
 #define R_CTSU2_CTSUCRB_SSCNT_Msk      (0x30000000UL) /*!< SSCNT (Bitfield-Mask: 0x03)                           */
/* =======================================================  CTSUCRBL  ======================================================== */
/* =======================================================  CTSUSDPRS  ======================================================= */
/* ========================================================  CTSUSST  ======================================================== */
/* =======================================================  CTSUCRBH  ======================================================== */
/* =======================================================  CTSUDCLKC  ======================================================= */
/* ========================================================  CTSUMCH  ======================================================== */
 #define R_CTSU2_CTSUMCH_MCH0_Pos    (0UL)       /*!< MCH0 (Bit 0)                                          */
 #define R_CTSU2_CTSUMCH_MCH0_Msk    (0x3fUL)    /*!< MCH0 (Bitfield-Mask: 0x3f)                            */
 #define R_CTSU2_CTSUMCH_MCH1_Pos    (8UL)       /*!< MCH1 (Bit 8)                                          */
 #define R_CTSU2_CTSUMCH_MCH1_Msk    (0x3f00UL)  /*!< MCH1 (Bitfield-Mask: 0x3f)                            */
 #define R_CTSU2_CTSUMCH_MCA0_Pos    (16UL)      /*!< MCA0 (Bit 16)                                         */
 #define R_CTSU2_CTSUMCH_MCA0_Msk    (0x10000UL) /*!< MCA0 (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUMCH_MCA1_Pos    (17UL)      /*!< MCA1 (Bit 17)                                         */
 #define R_CTSU2_CTSUMCH_MCA1_Msk    (0x20000UL) /*!< MCA1 (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUMCH_MCA2_Pos    (18UL)      /*!< MCA2 (Bit 18)                                         */
 #define R_CTSU2_CTSUMCH_MCA2_Msk    (0x40000UL) /*!< MCA2 (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUMCH_MCA3_Pos    (19UL)      /*!< MCA3 (Bit 19)                                         */
 #define R_CTSU2_CTSUMCH_MCA3_Msk    (0x80000UL) /*!< MCA3 (Bitfield-Mask: 0x01)                            */
/* =======================================================  CTSUMCHL  ======================================================== */
/* =======================================================  CTSUMCH0  ======================================================== */
/* =======================================================  CTSUMCH1  ======================================================== */
/* =======================================================  CTSUMCHH  ======================================================== */
/* =======================================================  CTSUMFAF  ======================================================== */
/* =======================================================  CTSUCHACA  ======================================================= */
 #define R_CTSU2_CTSUCHACA_CHAC00_Pos    (0UL)          /*!< CHAC00 (Bit 0)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC00_Msk    (0x1UL)        /*!< CHAC00 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC01_Pos    (1UL)          /*!< CHAC01 (Bit 1)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC01_Msk    (0x2UL)        /*!< CHAC01 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC02_Pos    (2UL)          /*!< CHAC02 (Bit 2)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC02_Msk    (0x4UL)        /*!< CHAC02 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC03_Pos    (3UL)          /*!< CHAC03 (Bit 3)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC03_Msk    (0x8UL)        /*!< CHAC03 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC04_Pos    (4UL)          /*!< CHAC04 (Bit 4)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC04_Msk    (0x10UL)       /*!< CHAC04 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC05_Pos    (5UL)          /*!< CHAC05 (Bit 5)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC05_Msk    (0x20UL)       /*!< CHAC05 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC06_Pos    (6UL)          /*!< CHAC06 (Bit 6)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC06_Msk    (0x40UL)       /*!< CHAC06 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC07_Pos    (7UL)          /*!< CHAC07 (Bit 7)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC07_Msk    (0x80UL)       /*!< CHAC07 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC08_Pos    (8UL)          /*!< CHAC08 (Bit 8)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC08_Msk    (0x100UL)      /*!< CHAC08 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC09_Pos    (9UL)          /*!< CHAC09 (Bit 9)                                        */
 #define R_CTSU2_CTSUCHACA_CHAC09_Msk    (0x200UL)      /*!< CHAC09 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC10_Pos    (10UL)         /*!< CHAC10 (Bit 10)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC10_Msk    (0x400UL)      /*!< CHAC10 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC11_Pos    (11UL)         /*!< CHAC11 (Bit 11)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC11_Msk    (0x800UL)      /*!< CHAC11 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC12_Pos    (12UL)         /*!< CHAC12 (Bit 12)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC12_Msk    (0x1000UL)     /*!< CHAC12 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC13_Pos    (13UL)         /*!< CHAC13 (Bit 13)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC13_Msk    (0x2000UL)     /*!< CHAC13 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC14_Pos    (14UL)         /*!< CHAC14 (Bit 14)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC14_Msk    (0x4000UL)     /*!< CHAC14 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC15_Pos    (15UL)         /*!< CHAC15 (Bit 15)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC15_Msk    (0x8000UL)     /*!< CHAC15 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC16_Pos    (16UL)         /*!< CHAC16 (Bit 16)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC16_Msk    (0x10000UL)    /*!< CHAC16 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC17_Pos    (17UL)         /*!< CHAC17 (Bit 17)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC17_Msk    (0x20000UL)    /*!< CHAC17 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC18_Pos    (18UL)         /*!< CHAC18 (Bit 18)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC18_Msk    (0x40000UL)    /*!< CHAC18 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC21_Pos    (21UL)         /*!< CHAC21 (Bit 21)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC21_Msk    (0x200000UL)   /*!< CHAC21 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC22_Pos    (22UL)         /*!< CHAC22 (Bit 22)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC22_Msk    (0x400000UL)   /*!< CHAC22 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC23_Pos    (23UL)         /*!< CHAC23 (Bit 23)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC23_Msk    (0x800000UL)   /*!< CHAC23 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC24_Pos    (24UL)         /*!< CHAC24 (Bit 24)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC24_Msk    (0x1000000UL)  /*!< CHAC24 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC25_Pos    (25UL)         /*!< CHAC25 (Bit 25)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC25_Msk    (0x2000000UL)  /*!< CHAC25 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC26_Pos    (26UL)         /*!< CHAC26 (Bit 26)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC26_Msk    (0x4000000UL)  /*!< CHAC26 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC27_Pos    (27UL)         /*!< CHAC27 (Bit 27)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC27_Msk    (0x8000000UL)  /*!< CHAC27 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC28_Pos    (28UL)         /*!< CHAC28 (Bit 28)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC28_Msk    (0x10000000UL) /*!< CHAC28 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC29_Pos    (29UL)         /*!< CHAC29 (Bit 29)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC29_Msk    (0x20000000UL) /*!< CHAC29 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC30_Pos    (30UL)         /*!< CHAC30 (Bit 30)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC30_Msk    (0x40000000UL) /*!< CHAC30 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACA_CHAC31_Pos    (31UL)         /*!< CHAC31 (Bit 31)                                       */
 #define R_CTSU2_CTSUCHACA_CHAC31_Msk    (0x80000000UL) /*!< CHAC31 (Bitfield-Mask: 0x01)                          */
/* ======================================================  CTSUCHACAL  ======================================================= */
/* =======================================================  CTSUCHAC0  ======================================================= */
/* =======================================================  CTSUCHAC1  ======================================================= */
/* ======================================================  CTSUCHACAH  ======================================================= */
/* =======================================================  CTSUCHAC2  ======================================================= */
/* =======================================================  CTSUCHAC3  ======================================================= */
/* =======================================================  CTSUCHACB  ======================================================= */
 #define R_CTSU2_CTSUCHACB_CHAC32_Pos      (0UL)          /*!< CHAC32 (Bit 0)                                        */
 #define R_CTSU2_CTSUCHACB_CHAC32_Msk      (0x1UL)        /*!< CHAC32 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACB_CHAC33_Pos      (1UL)          /*!< CHAC33 (Bit 1)                                        */
 #define R_CTSU2_CTSUCHACB_CHAC33_Msk      (0x2UL)        /*!< CHAC33 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACB_CHAC34_Pos      (2UL)          /*!< CHAC34 (Bit 2)                                        */
 #define R_CTSU2_CTSUCHACB_CHAC34_Msk      (0x4UL)        /*!< CHAC34 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCHACB_CHAC35_Pos      (3UL)          /*!< CHAC35 (Bit 3)                                        */
 #define R_CTSU2_CTSUCHACB_CHAC35_Msk      (0x8UL)        /*!< CHAC35 (Bitfield-Mask: 0x01)                          */
/* ======================================================  CTSUCHACBL  ======================================================= */
/* =======================================================  CTSUCHAC4  ======================================================= */
/* ======================================================  CTSUCHTRCA  ======================================================= */
 #define R_CTSU2_CTSUCHTRCA_CHTRC_Pos      (0UL)          /*!< CHTRC (Bit 0)                                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC_Msk      (0x1UL)        /*!< CHTRC (Bitfield-Mask: 0x01)                           */
 #define R_CTSU2_CTSUCHTRCA_CHTRC01_Pos    (1UL)          /*!< CHTRC01 (Bit 1)                                       */
 #define R_CTSU2_CTSUCHTRCA_CHTRC01_Msk    (0x2UL)        /*!< CHTRC01 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC02_Pos    (2UL)          /*!< CHTRC02 (Bit 2)                                       */
 #define R_CTSU2_CTSUCHTRCA_CHTRC02_Msk    (0x4UL)        /*!< CHTRC02 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC03_Pos    (3UL)          /*!< CHTRC03 (Bit 3)                                       */
 #define R_CTSU2_CTSUCHTRCA_CHTRC03_Msk    (0x8UL)        /*!< CHTRC03 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC04_Pos    (4UL)          /*!< CHTRC04 (Bit 4)                                       */
 #define R_CTSU2_CTSUCHTRCA_CHTRC04_Msk    (0x10UL)       /*!< CHTRC04 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC05_Pos    (5UL)          /*!< CHTRC05 (Bit 5)                                       */
 #define R_CTSU2_CTSUCHTRCA_CHTRC05_Msk    (0x20UL)       /*!< CHTRC05 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC06_Pos    (6UL)          /*!< CHTRC06 (Bit 6)                                       */
 #define R_CTSU2_CTSUCHTRCA_CHTRC06_Msk    (0x40UL)       /*!< CHTRC06 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC07_Pos    (7UL)          /*!< CHTRC07 (Bit 7)                                       */
 #define R_CTSU2_CTSUCHTRCA_CHTRC07_Msk    (0x80UL)       /*!< CHTRC07 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC08_Pos    (8UL)          /*!< CHTRC08 (Bit 8)                                       */
 #define R_CTSU2_CTSUCHTRCA_CHTRC08_Msk    (0x100UL)      /*!< CHTRC08 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC09_Pos    (9UL)          /*!< CHTRC09 (Bit 9)                                       */
 #define R_CTSU2_CTSUCHTRCA_CHTRC09_Msk    (0x200UL)      /*!< CHTRC09 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC10_Pos    (10UL)         /*!< CHTRC10 (Bit 10)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC10_Msk    (0x400UL)      /*!< CHTRC10 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC11_Pos    (11UL)         /*!< CHTRC11 (Bit 11)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC11_Msk    (0x800UL)      /*!< CHTRC11 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC12_Pos    (12UL)         /*!< CHTRC12 (Bit 12)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC12_Msk    (0x1000UL)     /*!< CHTRC12 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC13_Pos    (13UL)         /*!< CHTRC13 (Bit 13)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC13_Msk    (0x2000UL)     /*!< CHTRC13 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC14_Pos    (14UL)         /*!< CHTRC14 (Bit 14)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC14_Msk    (0x4000UL)     /*!< CHTRC14 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC15_Pos    (15UL)         /*!< CHTRC15 (Bit 15)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC15_Msk    (0x8000UL)     /*!< CHTRC15 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC16_Pos    (16UL)         /*!< CHTRC16 (Bit 16)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC16_Msk    (0x10000UL)    /*!< CHTRC16 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC17_Pos    (17UL)         /*!< CHTRC17 (Bit 17)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC17_Msk    (0x20000UL)    /*!< CHTRC17 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC18_Pos    (18UL)         /*!< CHTRC18 (Bit 18)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC18_Msk    (0x40000UL)    /*!< CHTRC18 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC21_Pos    (21UL)         /*!< CHTRC21 (Bit 21)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC21_Msk    (0x200000UL)   /*!< CHTRC21 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC22_Pos    (22UL)         /*!< CHTRC22 (Bit 22)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC22_Msk    (0x400000UL)   /*!< CHTRC22 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC23_Pos    (23UL)         /*!< CHTRC23 (Bit 23)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC23_Msk    (0x800000UL)   /*!< CHTRC23 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC24_Pos    (24UL)         /*!< CHTRC24 (Bit 24)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC24_Msk    (0x1000000UL)  /*!< CHTRC24 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC25_Pos    (25UL)         /*!< CHTRC25 (Bit 25)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC25_Msk    (0x2000000UL)  /*!< CHTRC25 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC26_Pos    (26UL)         /*!< CHTRC26 (Bit 26)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC26_Msk    (0x4000000UL)  /*!< CHTRC26 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC27_Pos    (27UL)         /*!< CHTRC27 (Bit 27)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC27_Msk    (0x8000000UL)  /*!< CHTRC27 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC28_Pos    (28UL)         /*!< CHTRC28 (Bit 28)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC28_Msk    (0x10000000UL) /*!< CHTRC28 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC29_Pos    (29UL)         /*!< CHTRC29 (Bit 29)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC29_Msk    (0x20000000UL) /*!< CHTRC29 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC30_Pos    (30UL)         /*!< CHTRC30 (Bit 30)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC30_Msk    (0x40000000UL) /*!< CHTRC30 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCA_CHTRC31_Pos    (31UL)         /*!< CHTRC31 (Bit 31)                                      */
 #define R_CTSU2_CTSUCHTRCA_CHTRC31_Msk    (0x80000000UL) /*!< CHTRC31 (Bitfield-Mask: 0x01)                         */
/* ======================================================  CTSUCHTRCAL  ====================================================== */
/* ======================================================  CTSUCHTRC0  ======================================================= */
/* ======================================================  CTSUCHTRC1  ======================================================= */
/* ======================================================  CTSUCHTRCAH  ====================================================== */
/* ======================================================  CTSUCHTRC2  ======================================================= */
/* ======================================================  CTSUCHTRC3  ======================================================= */
/* ======================================================  CTSUCHTRCB  ======================================================= */
 #define R_CTSU2_CTSUCHTRCB_CHTRC32_Pos    (0UL)        /*!< CHTRC32 (Bit 0)                                       */
 #define R_CTSU2_CTSUCHTRCB_CHTRC32_Msk    (0x1UL)      /*!< CHTRC32 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCB_CHTRC33_Pos    (1UL)        /*!< CHTRC33 (Bit 1)                                       */
 #define R_CTSU2_CTSUCHTRCB_CHTRC33_Msk    (0x2UL)      /*!< CHTRC33 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCB_CHTRC34_Pos    (2UL)        /*!< CHTRC34 (Bit 2)                                       */
 #define R_CTSU2_CTSUCHTRCB_CHTRC34_Msk    (0x4UL)      /*!< CHTRC34 (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCHTRCB_CHTRC35_Pos    (3UL)        /*!< CHTRC35 (Bit 3)                                       */
 #define R_CTSU2_CTSUCHTRCB_CHTRC35_Msk    (0x8UL)      /*!< CHTRC35 (Bitfield-Mask: 0x01)                         */
/* ======================================================  CTSUCHTRCBL  ====================================================== */
/* ======================================================  CTSUCHTRC4  ======================================================= */
/* ========================================================  CTSUSR  ========================================================= */
 #define R_CTSU2_CTSUSR_MFC_Pos            (0UL)        /*!< MFC (Bit 0)                                           */
 #define R_CTSU2_CTSUSR_MFC_Msk            (0x3UL)      /*!< MFC (Bitfield-Mask: 0x03)                             */
 #define R_CTSU2_CTSUSR_ICOMPRST_Pos       (5UL)        /*!< ICOMPRST (Bit 5)                                      */
 #define R_CTSU2_CTSUSR_ICOMPRST_Msk       (0x20UL)     /*!< ICOMPRST (Bitfield-Mask: 0x01)                        */
 #define R_CTSU2_CTSUSR_ICOMP1_Pos         (6UL)        /*!< ICOMP1 (Bit 6)                                        */
 #define R_CTSU2_CTSUSR_ICOMP1_Msk         (0x40UL)     /*!< ICOMP1 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUSR_ICOMP0_Pos         (7UL)        /*!< ICOMP0 (Bit 7)                                        */
 #define R_CTSU2_CTSUSR_ICOMP0_Msk         (0x80UL)     /*!< ICOMP0 (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUSR_STC_Pos            (8UL)        /*!< STC (Bit 8)                                           */
 #define R_CTSU2_CTSUSR_STC_Msk            (0x700UL)    /*!< STC (Bitfield-Mask: 0x07)                             */
 #define R_CTSU2_CTSUSR_DTSR_Pos           (12UL)       /*!< DTSR (Bit 12)                                         */
 #define R_CTSU2_CTSUSR_DTSR_Msk           (0x1000UL)   /*!< DTSR (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUSR_SENSOVF_Pos        (13UL)       /*!< SENSOVF (Bit 13)                                      */
 #define R_CTSU2_CTSUSR_SENSOVF_Msk        (0x2000UL)   /*!< SENSOVF (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUSR_SUOVF_Pos          (14UL)       /*!< SUOVF (Bit 14)                                        */
 #define R_CTSU2_CTSUSR_SUOVF_Msk          (0x4000UL)   /*!< SUOVF (Bitfield-Mask: 0x01)                           */
 #define R_CTSU2_CTSUSR_PS_Pos             (15UL)       /*!< PS (Bit 15)                                           */
 #define R_CTSU2_CTSUSR_PS_Msk             (0x8000UL)   /*!< PS (Bitfield-Mask: 0x01)                              */
 #define R_CTSU2_CTSUSR_CFCRDCH_Pos        (16UL)       /*!< CFCRDCH (Bit 16)                                      */
 #define R_CTSU2_CTSUSR_CFCRDCH_Msk        (0x3f0000UL) /*!< CFCRDCH (Bitfield-Mask: 0x3f)                         */
/* ========================================================  CTSUSRL  ======================================================== */
/* ========================================================  CTSUSR0  ======================================================== */
/* ========================================================  CTSUST  ========================================================= */
/* ========================================================  CTSUSRH  ======================================================== */
/* ========================================================  CTSUSR2  ======================================================== */
/* ========================================================  CTSUSO  ========================================================= */
 #define R_CTSU2_CTSUSO_SO_Pos              (0UL)          /*!< SO (Bit 0)                                            */
 #define R_CTSU2_CTSUSO_SO_Msk              (0x3ffUL)      /*!< SO (Bitfield-Mask: 0x3ff)                             */
 #define R_CTSU2_CTSUSO_SNUM_Pos            (10UL)         /*!< SNUM (Bit 10)                                         */
 #define R_CTSU2_CTSUSO_SNUM_Msk            (0x3fc00UL)    /*!< SNUM (Bitfield-Mask: 0xff)                            */
 #define R_CTSU2_CTSUSO_SSDIV_Pos           (20UL)         /*!< SSDIV (Bit 20)                                        */
 #define R_CTSU2_CTSUSO_SSDIV_Msk           (0xf00000UL)   /*!< SSDIV (Bitfield-Mask: 0x0f)                           */
 #define R_CTSU2_CTSUSO_SDPA_Pos            (24UL)         /*!< SDPA (Bit 24)                                         */
 #define R_CTSU2_CTSUSO_SDPA_Msk            (0xff000000UL) /*!< SDPA (Bitfield-Mask: 0xff)                            */
/* ========================================================  CTSUSO0  ======================================================== */
/* ========================================================  CTSUSO1  ======================================================== */
/* =======================================================  CTSUSCNT  ======================================================== */
 #define R_CTSU2_CTSUSCNT_SENSCNT_Pos       (0UL)          /*!< SENSCNT (Bit 0)                                       */
 #define R_CTSU2_CTSUSCNT_SENSCNT_Msk       (0xffffUL)     /*!< SENSCNT (Bitfield-Mask: 0xffff)                       */
 #define R_CTSU2_CTSUSCNT_SUCKCNT_Pos       (16UL)         /*!< SUCKCNT (Bit 16)                                      */
 #define R_CTSU2_CTSUSCNT_SUCKCNT_Msk       (0xffff0000UL) /*!< SUCKCNT (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CTSUSC  ========================================================= */
/* =======================================================  CTSUCALIB  ======================================================= */
 #define R_CTSU2_CTSUCALIB_TSOD_Pos         (2UL)          /*!< TSOD (Bit 2)                                          */
 #define R_CTSU2_CTSUCALIB_TSOD_Msk         (0x4UL)        /*!< TSOD (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUCALIB_DRV_Pos          (3UL)          /*!< DRV (Bit 3)                                           */
 #define R_CTSU2_CTSUCALIB_DRV_Msk          (0x8UL)        /*!< DRV (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUCALIB_CLKSEL_Pos       (4UL)          /*!< CLKSEL (Bit 4)                                        */
 #define R_CTSU2_CTSUCALIB_CLKSEL_Msk       (0x30UL)       /*!< CLKSEL (Bitfield-Mask: 0x03)                          */
 #define R_CTSU2_CTSUCALIB_SUCLKEN_Pos      (6UL)          /*!< SUCLKEN (Bit 6)                                       */
 #define R_CTSU2_CTSUCALIB_SUCLKEN_Msk      (0x40UL)       /*!< SUCLKEN (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCALIB_TSOC_Pos         (7UL)          /*!< TSOC (Bit 7)                                          */
 #define R_CTSU2_CTSUCALIB_TSOC_Msk         (0x80UL)       /*!< TSOC (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUCALIB_CNTRDSEL_Pos     (8UL)          /*!< CNTRDSEL (Bit 8)                                      */
 #define R_CTSU2_CTSUCALIB_CNTRDSEL_Msk     (0x100UL)      /*!< CNTRDSEL (Bitfield-Mask: 0x01)                        */
 #define R_CTSU2_CTSUCALIB_IOC_Pos          (9UL)          /*!< IOC (Bit 9)                                           */
 #define R_CTSU2_CTSUCALIB_IOC_Msk          (0x200UL)      /*!< IOC (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUCALIB_CFCRDMD_Pos      (10UL)         /*!< CFCRDMD (Bit 10)                                      */
 #define R_CTSU2_CTSUCALIB_CFCRDMD_Msk      (0x400UL)      /*!< CFCRDMD (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCALIB_DCOFF_Pos        (11UL)         /*!< DCOFF (Bit 11)                                        */
 #define R_CTSU2_CTSUCALIB_DCOFF_Msk        (0x800UL)      /*!< DCOFF (Bitfield-Mask: 0x01)                           */
 #define R_CTSU2_CTSUCALIB_IOCSEL_Pos       (12UL)         /*!< IOCSEL (Bit 12)                                       */
 #define R_CTSU2_CTSUCALIB_IOCSEL_Msk       (0x1000UL)     /*!< IOCSEL (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCALIB_CFCSEL_Pos       (16UL)         /*!< CFCSEL (Bit 16)                                       */
 #define R_CTSU2_CTSUCALIB_CFCSEL_Msk       (0x3f0000UL)   /*!< CFCSEL (Bitfield-Mask: 0x3f)                          */
 #define R_CTSU2_CTSUCALIB_CFCMODE_Pos      (22UL)         /*!< CFCMODE (Bit 22)                                      */
 #define R_CTSU2_CTSUCALIB_CFCMODE_Msk      (0x400000UL)   /*!< CFCMODE (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCALIB_DACMSEL_Pos      (24UL)         /*!< DACMSEL (Bit 24)                                      */
 #define R_CTSU2_CTSUCALIB_DACMSEL_Msk      (0x1000000UL)  /*!< DACMSEL (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCALIB_DACCARRY_Pos     (25UL)         /*!< DACCARRY (Bit 25)                                     */
 #define R_CTSU2_CTSUCALIB_DACCARRY_Msk     (0x2000000UL)  /*!< DACCARRY (Bitfield-Mask: 0x01)                        */
 #define R_CTSU2_CTSUCALIB_SUMSEL_Pos       (26UL)         /*!< SUMSEL (Bit 26)                                       */
 #define R_CTSU2_CTSUCALIB_SUMSEL_Msk       (0x4000000UL)  /*!< SUMSEL (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCALIB_SUCARRY_Pos      (27UL)         /*!< SUCARRY (Bit 27)                                      */
 #define R_CTSU2_CTSUCALIB_SUCARRY_Msk      (0x8000000UL)  /*!< SUCARRY (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUCALIB_DACCLK_Pos       (28UL)         /*!< DACCLK (Bit 28)                                       */
 #define R_CTSU2_CTSUCALIB_DACCLK_Msk       (0x10000000UL) /*!< DACCLK (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCALIB_CCOCLK_Pos       (29UL)         /*!< CCOCLK (Bit 29)                                       */
 #define R_CTSU2_CTSUCALIB_CCOCLK_Msk       (0x20000000UL) /*!< CCOCLK (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUCALIB_CCOCALIB_Pos     (30UL)         /*!< CCOCALIB (Bit 30)                                     */
 #define R_CTSU2_CTSUCALIB_CCOCALIB_Msk     (0x40000000UL) /*!< CCOCALIB (Bitfield-Mask: 0x01)                        */
 #define R_CTSU2_CTSUCALIB_TXREV_Pos        (31UL)         /*!< TXREV (Bit 31)                                        */
 #define R_CTSU2_CTSUCALIB_TXREV_Msk        (0x80000000UL) /*!< TXREV (Bitfield-Mask: 0x01)                           */
/* =======================================================  CTSUDBGR0  ======================================================= */
/* =======================================================  CTSUDBGR1  ======================================================= */
/* ======================================================  CTSUSUCLKA  ======================================================= */
 #define R_CTSU2_CTSUSUCLKA_SUADJ0_Pos      (0UL)          /*!< SUADJ0 (Bit 0)                                        */
 #define R_CTSU2_CTSUSUCLKA_SUADJ0_Msk      (0xffUL)       /*!< SUADJ0 (Bitfield-Mask: 0xff)                          */
 #define R_CTSU2_CTSUSUCLKA_SUMULTI0_Pos    (8UL)          /*!< SUMULTI0 (Bit 8)                                      */
 #define R_CTSU2_CTSUSUCLKA_SUMULTI0_Msk    (0xff00UL)     /*!< SUMULTI0 (Bitfield-Mask: 0xff)                        */
 #define R_CTSU2_CTSUSUCLKA_SUADJ1_Pos      (16UL)         /*!< SUADJ1 (Bit 16)                                       */
 #define R_CTSU2_CTSUSUCLKA_SUADJ1_Msk      (0xff0000UL)   /*!< SUADJ1 (Bitfield-Mask: 0xff)                          */
 #define R_CTSU2_CTSUSUCLKA_SUMULTI1_Pos    (24UL)         /*!< SUMULTI1 (Bit 24)                                     */
 #define R_CTSU2_CTSUSUCLKA_SUMULTI1_Msk    (0xff000000UL) /*!< SUMULTI1 (Bitfield-Mask: 0xff)                        */
/* ======================================================  CTSUSUCLK0  ======================================================= */
/* ======================================================  CTSUSUCLK1  ======================================================= */
/* ======================================================  CTSUSUCLKB  ======================================================= */
 #define R_CTSU2_CTSUSUCLKB_SUADJ2_Pos      (0UL)          /*!< SUADJ2 (Bit 0)                                        */
 #define R_CTSU2_CTSUSUCLKB_SUADJ2_Msk      (0xffUL)       /*!< SUADJ2 (Bitfield-Mask: 0xff)                          */
 #define R_CTSU2_CTSUSUCLKB_SUMULTI2_Pos    (8UL)          /*!< SUMULTI2 (Bit 8)                                      */
 #define R_CTSU2_CTSUSUCLKB_SUMULTI2_Msk    (0xff00UL)     /*!< SUMULTI2 (Bitfield-Mask: 0xff)                        */
 #define R_CTSU2_CTSUSUCLKB_SUADJ3_Pos      (16UL)         /*!< SUADJ3 (Bit 16)                                       */
 #define R_CTSU2_CTSUSUCLKB_SUADJ3_Msk      (0xff0000UL)   /*!< SUADJ3 (Bitfield-Mask: 0xff)                          */
 #define R_CTSU2_CTSUSUCLKB_SUMULTI3_Pos    (24UL)         /*!< SUMULTI3 (Bit 24)                                     */
 #define R_CTSU2_CTSUSUCLKB_SUMULTI3_Msk    (0xff000000UL) /*!< SUMULTI3 (Bitfield-Mask: 0xff)                        */
/* ======================================================  CTSUSUCLK2  ======================================================= */
/* ======================================================  CTSUSUCLK3  ======================================================= */
/* ======================================================  CTSUCFCCNT  ======================================================= */
 #define R_CTSU2_CTSUCFCCNT_CFCCNT_Pos      (0UL)          /*!< CFCCNT (Bit 0)                                        */
 #define R_CTSU2_CTSUCFCCNT_CFCCNT_Msk      (0xffffUL)     /*!< CFCCNT (Bitfield-Mask: 0xffff)                        */
/* ======================================================  CTSUCFCCNTL  ====================================================== */
/* ========================================================  CTSUOPT  ======================================================== */
 #define R_CTSU2_CTSUOPT_CCOCFEN_Pos        (0UL)          /*!< CCOCFEN (Bit 0)                                       */
 #define R_CTSU2_CTSUOPT_CCOCFEN_Msk        (0x1UL)        /*!< CCOCFEN (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUOPT_MCACEFN_Pos        (1UL)          /*!< MCACEFN (Bit 1)                                       */
 #define R_CTSU2_CTSUOPT_MCACEFN_Msk        (0x2UL)        /*!< MCACEFN (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUOPT_MAJIRIMD_Pos       (2UL)          /*!< MAJIRIMD (Bit 2)                                      */
 #define R_CTSU2_CTSUOPT_MAJIRIMD_Msk       (0x4UL)        /*!< MAJIRIMD (Bitfield-Mask: 0x01)                        */
 #define R_CTSU2_CTSUOPT_DTCLESS_Pos        (4UL)          /*!< DTCLESS (Bit 4)                                       */
 #define R_CTSU2_CTSUOPT_DTCLESS_Msk        (0x10UL)       /*!< DTCLESS (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUOPT_MTUCFEN_Pos        (5UL)          /*!< MTUCFEN (Bit 5)                                       */
 #define R_CTSU2_CTSUOPT_MTUCFEN_Msk        (0x20UL)       /*!< MTUCFEN (Bitfield-Mask: 0x01)                         */
 #define R_CTSU2_CTSUOPT_AJFEN_Pos          (8UL)          /*!< AJFEN (Bit 8)                                         */
 #define R_CTSU2_CTSUOPT_AJFEN_Msk          (0x100UL)      /*!< AJFEN (Bitfield-Mask: 0x01)                           */
 #define R_CTSU2_CTSUOPT_AJINTC_Pos         (9UL)          /*!< AJINTC (Bit 9)                                        */
 #define R_CTSU2_CTSUOPT_AJINTC_Msk         (0x200UL)      /*!< AJINTC (Bitfield-Mask: 0x01)                          */
 #define R_CTSU2_CTSUOPT_SCACTB_Pos         (16UL)         /*!< SCACTB (Bit 16)                                       */
 #define R_CTSU2_CTSUOPT_SCACTB_Msk         (0xf0000UL)    /*!< SCACTB (Bitfield-Mask: 0x0f)                          */
/* =======================================================  CTSUOPTL  ======================================================== */
/* ==========================================================  AC  =========================================================== */
/* ==========================================================  AJ  =========================================================== */
/* =======================================================  CTSUOPTH  ======================================================== */
/* =========================================================  ACTB  ========================================================== */
/* ======================================================  CTSUSCNTACT  ====================================================== */
 #define R_CTSU2_CTSUSCNTACT_SCNTACCOEFF_Pos    (0UL)          /*!< SCNTACCOEFF (Bit 0)                                   */
 #define R_CTSU2_CTSUSCNTACT_SCNTACCOEFF_Msk    (0xffffUL)     /*!< SCNTACCOEFF (Bitfield-Mask: 0xffff)                   */
 #define R_CTSU2_CTSUSCNTACT_SCNTACCOUNT_Pos    (16UL)         /*!< SCNTACCOUNT (Bit 16)                                  */
 #define R_CTSU2_CTSUSCNTACT_SCNTACCOUNT_Msk    (0xffff0000UL) /*!< SCNTACCOUNT (Bitfield-Mask: 0xffff)                   */
/* =====================================================  CTSUSCNTACTL  ====================================================== */
/* =====================================================  CTSUSCNTACTH  ====================================================== */
/* =======================================================  CTSUMACT1  ======================================================= */
 #define R_CTSU2_CTSUMACT1_SO_Pos               (0UL)          /*!< SO (Bit 0)                                            */
 #define R_CTSU2_CTSUMACT1_SO_Msk               (0x3ffUL)      /*!< SO (Bitfield-Mask: 0x3ff)                             */
 #define R_CTSU2_CTSUMACT1_OFFSETCOEFF_Pos      (16UL)         /*!< OFFSETCOEFF (Bit 16)                                  */
 #define R_CTSU2_CTSUMACT1_OFFSETCOEFF_Msk      (0xffff0000UL) /*!< OFFSETCOEFF (Bitfield-Mask: 0xffff)                   */
/* ======================================================  CTSUMACT1L  ======================================================= */
/* ======================================================  CTSUMACT1H  ======================================================= */
/* =======================================================  CTSUMACT2  ======================================================= */
 #define R_CTSU2_CTSUMACT2_SO_Pos               (0UL)          /*!< SO (Bit 0)                                            */
 #define R_CTSU2_CTSUMACT2_SO_Msk               (0x3ffUL)      /*!< SO (Bitfield-Mask: 0x3ff)                             */
 #define R_CTSU2_CTSUMACT2_OFFSETCOEFF_Pos      (16UL)         /*!< OFFSETCOEFF (Bit 16)                                  */
 #define R_CTSU2_CTSUMACT2_OFFSETCOEFF_Msk      (0xffff0000UL) /*!< OFFSETCOEFF (Bitfield-Mask: 0xffff)                   */
/* ======================================================  CTSUMACT2L  ======================================================= */
/* ======================================================  CTSUMACT2H  ======================================================= */
/* =======================================================  CTSUMACT3  ======================================================= */
 #define R_CTSU2_CTSUMACT3_SO_Pos               (0UL)          /*!< SO (Bit 0)                                            */
 #define R_CTSU2_CTSUMACT3_SO_Msk               (0x3ffUL)      /*!< SO (Bitfield-Mask: 0x3ff)                             */
 #define R_CTSU2_CTSUMACT3_OFFSETCOEFF_Pos      (16UL)         /*!< OFFSETCOEFF (Bit 16)                                  */
 #define R_CTSU2_CTSUMACT3_OFFSETCOEFF_Msk      (0xffff0000UL) /*!< OFFSETCOEFF (Bitfield-Mask: 0xffff)                   */
/* ======================================================  CTSUMACT3L  ======================================================= */
/* ======================================================  CTSUMACT3H  ======================================================= */
/* =======================================================  CTSUAJCR  ======================================================== */
 #define R_CTSU2_CTSUAJCR_TLOT_Pos              (0UL)          /*!< TLOT (Bit 0)                                          */
 #define R_CTSU2_CTSUAJCR_TLOT_Msk              (0xffUL)       /*!< TLOT (Bitfield-Mask: 0xff)                            */
 #define R_CTSU2_CTSUAJCR_THOT_Pos              (8UL)          /*!< THOT (Bit 8)                                          */
 #define R_CTSU2_CTSUAJCR_THOT_Msk              (0xff00UL)     /*!< THOT (Bitfield-Mask: 0xff)                            */
 #define R_CTSU2_CTSUAJCR_BLINI_Pos             (16UL)         /*!< BLINI (Bit 16)                                        */
 #define R_CTSU2_CTSUAJCR_BLINI_Msk             (0x10000UL)    /*!< BLINI (Bitfield-Mask: 0x01)                           */
 #define R_CTSU2_CTSUAJCR_JC_Pos                (20UL)         /*!< JC (Bit 20)                                           */
 #define R_CTSU2_CTSUAJCR_JC_Msk                (0x300000UL)   /*!< JC (Bitfield-Mask: 0x03)                              */
 #define R_CTSU2_CTSUAJCR_AJMMAT_Pos            (24UL)         /*!< AJMMAT (Bit 24)                                       */
 #define R_CTSU2_CTSUAJCR_AJMMAT_Msk            (0xf000000UL)  /*!< AJMMAT (Bitfield-Mask: 0x0f)                          */
 #define R_CTSU2_CTSUAJCR_AJBMAT_Pos            (28UL)         /*!< AJBMAT (Bit 28)                                       */
 #define R_CTSU2_CTSUAJCR_AJBMAT_Msk            (0xf0000000UL) /*!< AJBMAT (Bitfield-Mask: 0x0f)                          */
/* =======================================================  CTSUAJCRL  ======================================================= */
/* =========================================================  AJCR0  ========================================================= */
/* =========================================================  AJCR1  ========================================================= */
/* =======================================================  CTSUAJCRH  ======================================================= */
/* =========================================================  AJCR2  ========================================================= */
/* =========================================================  AJCR3  ========================================================= */
/* =======================================================  CTSUAJTHR  ======================================================= */
 #define R_CTSU2_CTSUAJTHR_AJTHL_Pos        (0UL)          /*!< AJTHL (Bit 0)                                         */
 #define R_CTSU2_CTSUAJTHR_AJTHL_Msk        (0xffffUL)     /*!< AJTHL (Bitfield-Mask: 0xffff)                         */
 #define R_CTSU2_CTSUAJTHR_AJTHH_Pos        (16UL)         /*!< AJTHH (Bit 16)                                        */
 #define R_CTSU2_CTSUAJTHR_AJTHH_Msk        (0xffff0000UL) /*!< AJTHH (Bitfield-Mask: 0xffff)                         */
/* ======================================================  CTSUAJTHRL  ======================================================= */
/* ======================================================  CTSUAJTHRH  ======================================================= */
/* ======================================================  CTSUAJMMAR  ======================================================= */
 #define R_CTSU2_CTSUAJMMAR_AJMMATI_Pos     (0UL)          /*!< AJMMATI (Bit 0)                                       */
 #define R_CTSU2_CTSUAJMMAR_AJMMATI_Msk     (0xfUL)        /*!< AJMMATI (Bitfield-Mask: 0x0f)                         */
 #define R_CTSU2_CTSUAJMMAR_AJMMR_Pos       (5UL)          /*!< AJMMR (Bit 5)                                         */
 #define R_CTSU2_CTSUAJMMAR_AJMMR_Msk       (0xffffffe0UL) /*!< AJMMR (Bitfield-Mask: 0x7ffffff)                      */
/* ======================================================  CTSUAJMMARL  ====================================================== */
/* ======================================================  CTSUAJMMARH  ====================================================== */
/* ======================================================  CTSUAJBLACT  ====================================================== */
 #define R_CTSU2_CTSUAJBLACT_AJBLACT_Pos    (0UL)          /*!< AJBLACT (Bit 0)                                       */
 #define R_CTSU2_CTSUAJBLACT_AJBLACT_Msk    (0xffffffffUL) /*!< AJBLACT (Bitfield-Mask: 0xffffffff)                   */
/* =====================================================  CTSUAJBLACTL  ====================================================== */
/* =====================================================  CTSUAJBLACTH  ====================================================== */
/* ======================================================  CTSUAJBLAR  ======================================================= */
 #define R_CTSU2_CTSUAJBLAR_AJBLAC_Pos      (0UL)          /*!< AJBLAC (Bit 0)                                        */
 #define R_CTSU2_CTSUAJBLAR_AJBLAC_Msk      (0xffffUL)     /*!< AJBLAC (Bitfield-Mask: 0xffff)                        */
 #define R_CTSU2_CTSUAJBLAR_AJBLAR_Pos      (16UL)         /*!< AJBLAR (Bit 16)                                       */
 #define R_CTSU2_CTSUAJBLAR_AJBLAR_Msk      (0xffff0000UL) /*!< AJBLAR (Bitfield-Mask: 0xffff)                        */
/* ======================================================  CTSUAJBLARL  ====================================================== */
/* ======================================================  CTSUAJBLARH  ====================================================== */
/* =======================================================  CTSUAJRR  ======================================================== */
 #define R_CTSU2_CTSUAJRR_TJR0_Pos          (0UL)          /*!< TJR0 (Bit 0)                                          */
 #define R_CTSU2_CTSUAJRR_TJR0_Msk          (0x1UL)        /*!< TJR0 (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUAJRR_TJR1_Pos          (1UL)          /*!< TJR1 (Bit 1)                                          */
 #define R_CTSU2_CTSUAJRR_TJR1_Msk          (0x2UL)        /*!< TJR1 (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUAJRR_TJR2_Pos          (2UL)          /*!< TJR2 (Bit 2)                                          */
 #define R_CTSU2_CTSUAJRR_TJR2_Msk          (0x4UL)        /*!< TJR2 (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUAJRR_TJR3_Pos          (3UL)          /*!< TJR3 (Bit 3)                                          */
 #define R_CTSU2_CTSUAJRR_TJR3_Msk          (0x8UL)        /*!< TJR3 (Bitfield-Mask: 0x01)                            */
 #define R_CTSU2_CTSUAJRR_FJR_Pos           (4UL)          /*!< FJR (Bit 4)                                           */
 #define R_CTSU2_CTSUAJRR_FJR_Msk           (0x10UL)       /*!< FJR (Bitfield-Mask: 0x01)                             */
 #define R_CTSU2_CTSUAJRR_SJCCR_Pos         (8UL)          /*!< SJCCR (Bit 8)                                         */
 #define R_CTSU2_CTSUAJRR_SJCCR_Msk         (0xff00UL)     /*!< SJCCR (Bitfield-Mask: 0xff)                           */
/* =======================================================  CTSUAJRRL  ======================================================= */
/* =======================================================  CTSUAJRR0  ======================================================= */
/* =======================================================  CTSUAJRR1  ======================================================= */

/* =========================================================================================================================== */
/* ================                                           R_DAC                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  DACR  ========================================================== */
 #define R_DAC_DACR_DAE_Pos            (5UL)      /*!< DAE (Bit 5)                                           */
 #define R_DAC_DACR_DAE_Msk            (0x20UL)   /*!< DAE (Bitfield-Mask: 0x01)                             */
 #define R_DAC_DACR_DAOE_Pos           (6UL)      /*!< DAOE (Bit 6)                                          */
 #define R_DAC_DACR_DAOE_Msk           (0x40UL)   /*!< DAOE (Bitfield-Mask: 0x01)                            */
/* =========================================================  DADR  ========================================================== */
 #define R_DAC_DADR_DADR_Pos           (0UL)      /*!< DADR (Bit 0)                                          */
 #define R_DAC_DADR_DADR_Msk           (0xffffUL) /*!< DADR (Bitfield-Mask: 0xffff)                          */
/* =========================================================  DADPR  ========================================================= */
 #define R_DAC_DADPR_DPSEL_Pos         (7UL)      /*!< DPSEL (Bit 7)                                         */
 #define R_DAC_DADPR_DPSEL_Msk         (0x80UL)   /*!< DPSEL (Bitfield-Mask: 0x01)                           */
/* ========================================================  DAADSCR  ======================================================== */
 #define R_DAC_DAADSCR_DAADST_Pos      (7UL)      /*!< DAADST (Bit 7)                                        */
 #define R_DAC_DAADSCR_DAADST_Msk      (0x80UL)   /*!< DAADST (Bitfield-Mask: 0x01)                          */
/* =======================================================  DAVREFCR  ======================================================== */
 #define R_DAC_DAVREFCR_REF_Pos        (0UL)      /*!< REF (Bit 0)                                           */
 #define R_DAC_DAVREFCR_REF_Msk        (0x7UL)    /*!< REF (Bitfield-Mask: 0x07)                             */
/* =========================================================  DAPC  ========================================================== */
 #define R_DAC_DAPC_PUMPEN_Pos         (0UL)      /*!< PUMPEN (Bit 0)                                        */
 #define R_DAC_DAPC_PUMPEN_Msk         (0x1UL)    /*!< PUMPEN (Bitfield-Mask: 0x01)                          */
/* ========================================================  DAAMPCR  ======================================================== */
 #define R_DAC_DAAMPCR_DAAMP_Pos       (6UL)      /*!< DAAMP (Bit 6)                                         */
 #define R_DAC_DAAMPCR_DAAMP_Msk       (0x40UL)   /*!< DAAMP (Bitfield-Mask: 0x01)                           */
/* ========================================================  DAASWCR  ======================================================== */
 #define R_DAC_DAASWCR_DAASW1_Pos      (7UL)      /*!< DAASW1 (Bit 7)                                        */
 #define R_DAC_DAASWCR_DAASW1_Msk      (0x80UL)   /*!< DAASW1 (Bitfield-Mask: 0x01)                          */
 #define R_DAC_DAASWCR_DAASW0_Pos      (6UL)      /*!< DAASW0 (Bit 6)                                        */
 #define R_DAC_DAASWCR_DAASW0_Msk      (0x40UL)   /*!< DAASW0 (Bitfield-Mask: 0x01)                          */
/* ========================================================  DAADUSR  ======================================================== */
 #define R_DAC_DAADUSR_AMADSEL0_Pos    (0UL)      /*!< AMADSEL0 (Bit 0)                                      */
 #define R_DAC_DAADUSR_AMADSEL0_Msk    (0x1UL)    /*!< AMADSEL0 (Bitfield-Mask: 0x01)                        */
 #define R_DAC_DAADUSR_AMADSEL1_Pos    (1UL)      /*!< AMADSEL1 (Bit 1)                                      */
 #define R_DAC_DAADUSR_AMADSEL1_Msk    (0x2UL)    /*!< AMADSEL1 (Bitfield-Mask: 0x01)                        */

/* =========================================================================================================================== */
/* ================                                          R_DEBUG                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  DBGSTR  ========================================================= */
 #define R_DEBUG_DBGSTR_CDBGPWRUPREQ_Pos        (28UL)         /*!< CDBGPWRUPREQ (Bit 28)                                 */
 #define R_DEBUG_DBGSTR_CDBGPWRUPREQ_Msk        (0x10000000UL) /*!< CDBGPWRUPREQ (Bitfield-Mask: 0x01)                    */
 #define R_DEBUG_DBGSTR_CDBGPWRUPACK_Pos        (29UL)         /*!< CDBGPWRUPACK (Bit 29)                                 */
 #define R_DEBUG_DBGSTR_CDBGPWRUPACK_Msk        (0x20000000UL) /*!< CDBGPWRUPACK (Bitfield-Mask: 0x01)                    */
/* =======================================================  DBGSTOPCR  ======================================================= */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_RPER_Pos     (24UL)         /*!< DBGSTOP_RPER (Bit 24)                                 */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_RPER_Msk     (0x1000000UL)  /*!< DBGSTOP_RPER (Bitfield-Mask: 0x01)                    */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_TIM_Pos      (14UL)         /*!< DBGSTOP_TIM (Bit 14)                                  */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_TIM_Msk      (0x4000UL)     /*!< DBGSTOP_TIM (Bitfield-Mask: 0x01)                     */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_SIR_Pos      (15UL)         /*!< DBGSTOP_SIR (Bit 15)                                  */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_SIR_Msk      (0x8000UL)     /*!< DBGSTOP_SIR (Bitfield-Mask: 0x01)                     */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_LVD_Pos      (16UL)         /*!< DBGSTOP_LVD (Bit 16)                                  */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_LVD_Msk      (0x10000UL)    /*!< DBGSTOP_LVD (Bitfield-Mask: 0x01)                     */
 #define R_DEBUG_DBGSTOPCR_DBGSTOP_RECCR_Pos    (25UL)         /*!< DBGSTOP_RECC