#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ffmpegProcess = new QProcess(this);
    ffmpegProcess->setProcessChannelMode(QProcess::MergedChannels);
    //connect(ffmpegProcess, &QProcess::readyRead, this, &MainWindow::onReadyReadStandardOutput);
    connect(ffmpegProcess, &QProcess::readyReadStandardOutput, this, &MainWindow::onReadyReadStandardOutput);
    connect(ffmpegProcess, &QProcess::readyReadStandardError, this, &MainWindow::onReadyReadStandardError);

    ffmpeg_thread = new FfmpegThread();
    connect(ffmpeg_thread, &FfmpegThread::main_window_signal, this, &MainWindow::ffmpeg_thread_slot);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::onReadyReadStandardOutput()
{
    QByteArray output = ffmpegProcess->readAllStandardOutput();
    ui->label_status->setText(QString("Status: Output - ") + QString(output));
}

void MainWindow::onReadyReadStandardError()
{
    QByteArray error = ffmpegProcess->readAllStandardError();
    ui->label_status->setText(QString("Status: Error - ") + QString(error));
}

void MainWindow::ffmpeg_thread_slot(int index_frame) {
    ui->label_status->setText(QString("Status: FPS - ") + QString::number(index_frame));
}

void MainWindow::on_pushButton_clicked()
{
    if (ui->lineEdit_rtsp->text().length() == 0) {
        ui->label_status->setText("Status: Error - rtsp link is empty");
        return;
    }
    if (ui->lineEdit_rtmp->text().length() == 0) {
        ui->label_status->setText("Status: Error - rtmp link is empty");
        return;
    }
    ffmpeg_thread->set_link(ui->lineEdit_rtsp->text().toStdString().c_str(), ui->lineEdit_rtmp->text().toStdString().c_str());
    ffmpeg_thread->start();
    type = 1;
}


void MainWindow::on_pushButton_2_clicked()
{
    if (type == 1) {
        ffmpeg_thread->stop();
    }
    if (type == 2) {
        ffmpegProcess->write("q");
    }
    type = 0;
}


void MainWindow::on_pushButton_3_clicked()
{
    if (ui->lineEdit_rtmp->text().length() == 0) {
        ui->label_status->setText("Status: Error - rtmp link is empty");
        return;
    }
    strcpy(rtmp_link, ui->lineEdit_rtmp->text().toStdString().c_str());
    QString program = "ffmpeg";
    QStringList arguments;
    arguments << "-f" << "v4l2" << "-pixel_format" << "nv12" << "-i" << "/dev/video73" << "-vcodec" << "h264_rkmpp" << "-an" << "-f" << "flv" << rtmp_link;
    ffmpegProcess->start(program, arguments);
    type = 2;
}

