#ifndef FFMPEGTHREAD_H
#define FFMPEGTHREAD_H

#include <QThread>
#include <QDebug>

extern "C" {
#include "libavcodec/avcodec.h"
#include "libavformat/avformat.h"
#include "libavfilter/avfilter.h"
#include "libavfilter/buffersink.h"
#include "libavfilter/buffersrc.h"
#include "libavutil/avutil.h"
#include "libavutil/audio_fifo.h"
#include "libavutil/mathematics.h"
#include "libswscale/swscale.h"
#include "libavutil/imgutils.h"
#include "libavutil/time.h"
#include "libswresample/swresample.h"
}

class FfmpegThread : public QThread {
    Q_OBJECT

public:
    FfmpegThread(QObject *parent = 0);
    virtual ~FfmpegThread();
    void set_link(const char *rtsp, const char *rtmp);
    void stop();

signals:
    void main_window_signal(int);

protected:
    virtual void run();

private:
    bool status = true;
    char input_link[255];
    char output_link[255];
    const int width = 640, height = 480, fps = 10;
};

#endif // FFMPEGTHREAD_H
