#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ffmpegProcess = new QProcess(this);
    ffmpegProcess->setProcessChannelMode(QProcess::MergedChannels);
    //connect(ffmpegProcess, &QProcess::readyRead, this, &MainWindow::onReadyReadStandardOutput);
    connect(ffmpegProcess, &QProcess::readyReadStandardOutput, this, &MainWindow::onReadyReadStandardOutput);
    connect(ffmpegProcess, &QProcess::readyReadStandardError, this, &MainWindow::onReadyReadStandardError);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::onReadyReadStandardOutput()
{
    QByteArray output = ffmpegProcess->readAllStandardOutput();
    ui->label_status->setText(QString("Status: Output - ") + QString(output));
}

void MainWindow::onReadyReadStandardError()
{
    QByteArray error = ffmpegProcess->readAllStandardError();
    ui->label_status->setText(QString("Status: Error - ") + QString(error));
}

void MainWindow::on_pushButton_clicked()
{
    if (ui->lineEdit_rtsp->text().length() == 0) {
        ui->label_status->setText("Status: Error - rtsp link is empty");
        return;
    }
    if (ui->lineEdit_rtmp->text().length() == 0) {
        ui->label_status->setText("Status: Error - rtmp link is empty");
        return;
    }
    strcpy(rtsp_link, ui->lineEdit_rtsp->text().toStdString().c_str());
    strcpy(rtmp_link, ui->lineEdit_rtmp->text().toStdString().c_str());
    QString program = "ffmpeg";
    QStringList arguments;
    arguments << "-i" << rtsp_link << "-vcodec" << "h264_rkmpp" << "-an" << "-f" << "flv" << rtmp_link;
    ffmpegProcess->start(program, arguments);
}


void MainWindow::on_pushButton_2_clicked()
{
    ffmpegProcess->write("q");
}


void MainWindow::on_pushButton_3_clicked()
{
    if (ui->lineEdit_rtmp->text().length() == 0) {
        ui->label_status->setText("Status: Error - rtmp link is empty");
        return;
    }
    strcpy(rtmp_link, ui->lineEdit_rtmp->text().toStdString().c_str());
    QString program = "ffmpeg";
    QStringList arguments;
    arguments << "-f" << "v4l2" << "-pixel_format" << "nv12" << "-i" << "/dev/video73" << "-vcodec" << "h264_rkmpp" << "-an" << "-f" << "flv" << rtmp_link;
    ffmpegProcess->start(program, arguments);
}

