#include "ffmpegthread.h"

FfmpegThread::FfmpegThread(QObject *parent) : QThread(parent) {
    //
}

FfmpegThread::~FfmpegThread() { }

void FfmpegThread::run() {
    int	i_video_output_stream = -1;
    int64_t i_video_frame = 0;

    avformat_network_init();

    AVPacket *packet = (AVPacket *)av_malloc(sizeof(AVPacket));

    AVDictionary* options = NULL;
    av_dict_set(&options, "max_delay", "200000", 0);
    av_dict_set(&options, "stimeout", "1000000", 0);  //设置超时断开连接时间
    av_dict_set(&options, "rtsp_transport", "tcp", 0);  //tcp方式打开

    AVFormatContext *p_video_input_format_ctx = avformat_alloc_context();
    AVStream *p_video_input_stream = NULL;
    if (avformat_open_input(&p_video_input_format_ctx, input_link, NULL, &options) != 0) {
        qDebug() << "error: input stream open fail!";
        emit main_window_signal(-1);
        return;
    }
    if (avformat_find_stream_info(p_video_input_format_ctx, NULL) < 0) {
        qDebug() << "error: couldn't find stream information.\n";
        emit main_window_signal(-1);
        return;
    }
    for (unsigned int i = 0; i < p_video_input_format_ctx->nb_streams; i++) {
        if (p_video_input_format_ctx->streams[i]->codecpar->codec_type == AVMEDIA_TYPE_VIDEO) {
            p_video_input_stream = p_video_input_format_ctx->streams[i];
            break;
        }
    }
    if (p_video_input_stream == NULL) {
        qDebug() << "error: couldn't find video stream.\n";
        emit main_window_signal(-1);
        return;
    }

    AVFormatContext *p_output_format_ctx;
    if (avformat_alloc_output_context2(&p_output_format_ctx, 0, "flv", output_link) != 0) {
        qDebug() << "error: avformat_alloc_output_context2!\n";
        emit main_window_signal(-1);
        return;
    }

    //添加视频流
    AVStream *p_video_output_stream = avformat_new_stream(p_output_format_ctx, NULL);
    if (!p_video_output_stream) {
        qDebug() << "error: avformat_new_stream failed!\n";
        emit main_window_signal(-1);
        return;
    }
    if (avcodec_parameters_copy(p_video_output_stream->codecpar, p_video_input_stream->codecpar) < 0) {
        qDebug() << "error: avformat_new_stream failed!\n";
        emit main_window_signal(-1);
        return;
    }
    //附加标志，这个一定要设置
    p_video_output_stream->codecpar->codec_tag = 0;

    ///打开rtmp 的网络输出IO  AVIOContext：输入输出对应的结构体，用于输入输出（读写文件，RTMP协议等）。
    if (avio_open(&p_output_format_ctx->pb, output_link, AVIO_FLAG_WRITE) != 0) {
        qDebug() << "error: avio_open failed!\n";
        emit main_window_signal(-1);
        return;
    }
    //写入封装头
    if (avformat_write_header(p_output_format_ctx, NULL) != 0) {
        qDebug() << "error: avformat_write_header failed!\n";
        emit main_window_signal(-1);
        return;
    }
    for (unsigned int i = 0; i < p_output_format_ctx->nb_streams; i++) {
        if (p_output_format_ctx->streams[i]->codecpar->codec_type == AVMEDIA_TYPE_VIDEO) {
            i_video_output_stream = i;
        }
    }

    while (1) {
        if (av_read_frame(p_video_input_format_ctx, packet) >= 0){
            packet->stream_index = i_video_output_stream;
            packet->pts = av_rescale_q_rnd(packet->pts, p_video_input_stream->time_base, p_video_output_stream->time_base, AV_ROUND_NEAR_INF);
            packet->dts = av_rescale_q_rnd(packet->dts, p_video_input_stream->time_base, p_video_output_stream->time_base, AV_ROUND_NEAR_INF);
            packet->duration = av_rescale_q(packet->duration, p_video_input_stream->time_base, p_video_output_stream->time_base);
            packet->pos = -1;

            if (av_interleaved_write_frame(p_output_format_ctx, packet) < 0) {
                qDebug() << "error: av_interleaved_write_frame failed!\n";
            }
            av_packet_unref(packet);
            i_video_frame++;
        }
        usleep(10000);
    }
}
