/*
@hehung
2023-5-22
email: 1398660197@qq.com
wechat: hehung95
reproduced and please indicate the source @hehung
*/

#include "hal_data.h"
#include "app_hw_i2c.h"

/* sci9 i2c */
i2c_master_event_t sci6_i2c_event = I2C_MASTER_EVENT_ABORTED;
//i2c_master_event_t sci2_i2c_event = I2C_MASTER_EVENT_ABORTED;

/* Initialize for I2c driver */
void I2c_Init(void)
{
	fsp_err_t err;
	
	// initialize the sci3 i2c
	// scl - P408
	// sda - P409
	err = R_SCI_I2C_Open(&g_sci6_i2c_ctrl, &g_sci6_i2c_cfg);
	assert(FSP_SUCCESS == err);
}

/* SCI9 I2C interrupt callback */
void sci6_i2c_master_callback(i2c_master_callback_args_t *p_args)
{
    sci6_i2c_event = I2C_MASTER_EVENT_ABORTED;
	
    if (NULL != p_args)
    {
        /* capture callback event for validating the i2c transfer event*/
        sci6_i2c_event = p_args->event;
    }
}

/* SCI1 I2C interrupt callback */
// void sci2_i2c_master_callback(i2c_master_callback_args_t *p_args)
// {
//     sci2_i2c_event = I2C_MASTER_EVENT_ABORTED;
	
//     if (NULL != p_args)
//     {
//         /* capture callback event for validating the i2c transfer event*/
//         sci2_i2c_event = p_args->event;
//     }
// }
